(* Comment 1: 
      the 2 lines below give the paths to your FeyArts and FormCalc
      X.xx is the version of your FeynArts and X.x that of your FormCalc
 *)
<< /..../FeynArts-X.xx/FeynArtsXxx.m

<< /.../FormCalc-X.x/FormCalcXx.m

time1 = SessionTime[]

CKM = IndexDelta

Neglect[ME] = Neglect[ME2] = 0

(* Comment 2 : Define your Process
  Define initial and Final Particles, here X H3 to nu_e \bar Nu_e, give it a name, name ="NAME" since this will create directories as NAME.fortran, etc....Below we called XH3toNnCoan
*)
process = {prt["X"], prt["H3"]} -> {prt["ne"], prt["Ne"]}

name = "XH3toNnCoan"

 (* Comment 3: 
  Model and Generic Model give the full path to your model. If these files are in the same directory as your Master_IDM.m file (the present file) then just entrer the names. The first one calls the .mod (Moldel.m) the second the .gen (Generic.gen). These files are generated by Lanhep
 *)

SetOptions[InsertFields, Model -> "Model", GenericModel -> "Generic"]

SetOptions[Paint, PaintLevel -> {Classes}, ColumnsXRows -> {4, 5}]

(* take the comments out if you want the diagrams painted
$PaintSE = MkDir[name <> ".diagrams"];
DoPaint[diags_, file_, opt___] := Paint[diags, opt,
  DisplayFunction -> (Export[ToFileName[$PaintSE, file <> ".ps"], #]&)]
*)


$PaintSE = MkDir[name <> ".diagrams"];
DoPaint[diags_, file_, opt___] := Paint[diags, opt,
  DisplayFunction -> (Export[ToFileName[$PaintSE, file <> ".ps"], #]&)]


(* What is below is for a 2-> 2 Process*)

Print["Born"]

tops = CreateTopologies[0, 2 -> 2];
ins = InsertFields[tops, process, InsertionLevel->{Classes}];
DoPaint[ins, "born"];
born = CalcFeynAmp[CreateFeynAmp[ins] ];

Print["Counter terms"]

tops = CreateCTTopologies[1, 2 -> 2, ExcludeTopologies -> {TadpoleCTs, WFCorrectionCTs}];
ins = InsertFields[tops, process, InsertionLevel->{Classes} ];
DoPaint[ins, "counter"];
counter = CalcFeynAmp[CreateFeynAmp[ins]];


Print["Self energies"]

tops = CreateTopologies[1, 2 -> 2, SelfEnergiesOnly];
ins = InsertFields[tops, process, InsertionLevel->{Classes} ];
DoPaint[ins, "self"];
self = CalcFeynAmp[CreateFeynAmp[ins]];


Print["Vertices"]

tops = CreateTopologies[1, 2 -> 2, TrianglesOnly];
(*ins = InsertFields[tops, process];*)
ins = InsertFields[tops, process, InsertionLevel->{Classes}];
DoPaint[ins, "vert"];
vert = CalcFeynAmp[CreateFeynAmp[ins]];


Print["Boxes"]

tops = CreateTopologies[1, 2 -> 2, BoxesOnly];
ins = InsertFields[tops, process, InsertionLevel->{Classes}];
DoPaint[ins, "box"];
box = CalcFeynAmp[CreateFeynAmp[ins]];


(* Since this file is for a 2-> 2 Process, no need for Pentagons, hence the commented line)
(*
Print["Pentagons"]

tops = CreateTopologies[1, 2 -> 2, PentagonsOnly];
ins = InsertFields[tops, process, InsertionLevel->{Classes}];
DoPaint[ins, "pentagons"];
pentagons= CalcFeynAmp[CreateFeynAmp[ins]];
*)

amps = {born, counter, self, vert, box(*, pentagons*)}

{born, counter, self, vert, box(*, pentagons*)} = Abbreviate[amps, 6, Preprocess -> OnSize[100, Simplify, 500, DenCollect]]

abbr = OptimizeAbbr[Abbr[]]

subexpr = OptimizeAbbr[Subexpr[]]

dir = SetupCodeDir[name <> ".fortran", Drivers -> name <> ".drivers"]

WriteSquaredME[born, {counter, self, vert, box(*, pentagons*)}, abbr, subexpr, dir]

WriteRenConst[amps, dir]


Print["time used: ", SessionTime[] - time1]

