/*
//#ifdef DUMMY
   //  default dummy routine 
#include "../../include/micromegas.h"
#include "../../include/micromegas_aux.h"

void improveCrossSection(long n1,long n2,long n3,long n4 ,double PcmIn, 
double * res) { return; }
*/

//#else

//  Example for IDM. File should be disposed in IDM/lib
//  Loop improved cross sections depend on input parameters of IDM and can not be used in generic case. 
// It is only example presented here to help the user to construct his own version of loop improved calculations 


#include "../../include/micromegas.h"
#include "../../include/micromegas_aux.h"



void improveCrossSection(long n1,long n2,long n3,long n4 ,double PcmIn,  double * res) 
{
//  sorting PDG identifiers 
     if(n1>n2){ long m=n1;n1=n2;n2=m;}
     if(n3>n4){ long m=n3;n3=n4;n4=m;}
 
// For code flexibility it is better to organize reading of improved cross sections from file.
// But here for simplicity we use tabulated data. 
 
//   for ~X,~X->W,W*       
    if(n1==35 &&  n2 == 35 &&   n3 == -24 &&  n4 == 24)
    { 
// printf("haha");
#define DIM 328
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/NLO_KL2_2_WW_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  

//   for ~X,~X->Z,Z*      
    if(n1==35 &&  n2 == 35 &&   n3 == 23 &&  n4 == 23)
    { 
// printf("haha");
#define DIM 470
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/LO_ZZ_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  

//   for ~X,~X->g,g and rest   
    if(n1==35 &&  n2 == 35 &&   n3 == 21 &&  n4 == 21)
    { 
// printf("haha");
#define DIM 470
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/LO_rest_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  


//   for ~X,~A->b,bbar       
    if(n1==35 &&  n2 == 35 &&   n3 == -5 &&  n4 == 5)
    { 
#define DIM 470
//      printf("hahahoho");
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/NLO_KL2_2_bb_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  

//   for ~X,~A->c,cbar
    if(n1==35 &&  n2 == 35 &&   n3 == -4 &&  n4 == 4)
    { 
#define DIM 470
//      printf("hahahoho");
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/LO_cc_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  

//   for ~X,~A->ta, ta
    if(n1==35 &&  n2 == 35 &&   n3 == -15 &&  n4 == 15)
    { 
#define DIM 470
//      printf("hahahoho");
      static int rdOn=0;
      static double pcmAr[DIM], vcsAr[DIM];
      static double m1,m2;
      static double ms,md;
      static double sqrtS;
      if(!rdOn) 
     {  FILE *XX= fopen("/home/sbanerjee/IDM/LO_tata_P59.txt","r"); 
        for(int i = 0; i < DIM; i++) fscanf(XX,"%lf %lf", &pcmAr[i], &vcsAr[i]);
        fclose(XX);
        m1 = pMass("~X");
        m2 = pMass("~X");
        ms = m1+m2;
        md = m1-m2; 
        rdOn=1;
      }    
//       double v=2*PcmIn/Mcdm; 
       sqrtS=sqrt(PcmIn*PcmIn+m1*m1) + sqrt(PcmIn*PcmIn+m2*m2);
       double v = PcmIn*4.0*pow(sqrtS,3.0)/(pow(sqrtS,4.0) - pow(ms*md,2.0)); 
//       printf("sqrtS=%.3E and v=%.3E \n",sqrtS,v);
       double cs, csLast;
       if(PcmIn>pcmAr[DIM-1])
       {  double PcmLast=pcmAr[DIM-1], sqrtSLast=sqrt(PcmLast*PcmLast+m1*m1) + sqrt(PcmLast*PcmLast+m2*m2), 
          vLast=PcmLast*4.0*pow(sqrtSLast,3.0)/(pow(sqrtSLast,4.0) - pow(ms*md,2.0)); csLast=vcsAr[DIM-1]/vLast;
          cs=csLast*(Mcdm*Mcdm+PcmLast*PcmLast)/(Mcdm*Mcdm+PcmIn*PcmIn);
          printf("Warning from improveCrossSection: PcmIn=%.3E out of tabulated region. 1/s interpolation is applied \n",PcmIn);
       } 
       else  cs=polint3(PcmIn,DIM,pcmAr,vcsAr)/v;
// debugging print  
//       printf(" improveCrossSection(~X,~X,Z,Z) PcmIn=%.3E   cs %.3E => %.3E\n", PcmIn, *res,cs);
//       printf(" m1 = %.3E, m2 = %.3E, ms=%.3E and md=%.3E\n", m1, m2, ms, md);
       *res=cs;
       return;
    }  
}
//#endif 
