      SUBROUTINE RELDEN(PAR,PROB)
      END

      DOUBLE PRECISION FUNCTION LUX(M)
      LUX=0
      END

      subroutine PrintRelDen(PROB, ch)
      END

      DOUBLE PRECISION FUNCTION PRINTCHANNELS(Xf,Beps,pres,fast,ch)
      PRINTCHANNELS=0
      END

      DOUBLE PRECISION FUNCTION PandaX(M)

*  Limit on the spin independent WIMP-nucleon cross-section,
*  from PandaX [arXiv:1607.07400]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=92)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/4.9961d0,5.0730d0,5.1498d0,5.2302d0,5.3197d0,5.4111d0,
     .5.5000d0,5.5982d0,5.6952d0,5.7899d0,5.8948d0,6.0092d0,6.1416d0,
     .6.2740d0,6.4202d0,6.5615d0,6.7156d0,6.8700d0,7.0265d0,7.2181d0,
     .7.4017d0,7.6059d0,7.8082d0,8.0320d0,8.2647d0,8.5166d0,8.7967d0,
     .9.1045d0,9.4388d0,9.7992d0,1.0159d1,1.0551d1,1.0978d1,1.1383d1,
     .1.1927d1,1.2500d1,1.3095d1,1.3730d1,1.4436d1,1.5195d1,1.6074d1,
     .1.7050d1,1.8106d1,1.9317d1,2.0606d1,2.2100d1,2.3737d1,2.5590d1,
     .2.7843d1,3.0202d1,3.3021d1,3.6104d1,3.9306d1,4.2792d1,4.6588d1,
     .5.0936d1,5.5606d1,6.0630d1,6.6008d1,7.2169d1,7.8570d1,8.5177d1,
     .9.2642d1,1.0053d2,1.0898d2,1.1815d2,1.2808d2,1.3932d2,1.5158d2,
     .1.6457d2,1.7841d2,1.9387d2,2.1040d2,2.2746d2,2.4642d2,2.6811d2,
     .2.9003d2,3.1395d2,3.4179d2,3.6987d2,3.9999d2,4.3328d2,4.6978d2,
     .5.0875d2,5.5245d2,5.9637d2,6.4598d2,7.0083d2,7.5980d2,8.2020d2,
     .8.8164d2,9.5360d2/
      DATA Y/9.2058d-7,7.6741d-7,6.3394d-7,5.2846d-7,4.4053d-7,
     .3.6391d-7,3.0336d-7,2.5289d-7,2.1081d-7,1.7574d-7,1.4705d-7,
     .1.2212d-7,1.0088d-7,8.4096d-8,6.9469d-8,5.7910d-8,4.8275d-8,
     .4.0026d-8,3.3547d-8,2.7712d-8,2.3101d-8,1.9126d-8,1.6054d-8,
     .1.3383d-8,1.1258d-8,9.4705d-9,7.9670d-9,6.6414d-9,5.5000d-9,
     .4.5000d-9,3.8000d-9,3.2000d-9,2.6500d-9,2.2500d-9,1.9000d-9,
     .1.5943d-9,1.3526d-9,1.1516d-9,9.8404d-10,8.4397d-10,7.2512d-10,
     .6.2584d-10,5.4685d-10,4.7814d-10,4.2235d-10,3.7635d-10,3.4003d-10,
     .3.1014d-10,2.8662d-10,2.7154d-10,2.5938d-10,2.5149d-10,2.4804d-10,
     .2.4892d-10,2.5006d-10,2.5529d-10,2.6385d-10,2.7223d-10,2.8520d-10,
     .2.9946d-10,3.1458d-10,3.3311d-10,3.5290d-10,3.7501d-10,3.9869d-10,
     .4.2427d-10,4.5096d-10,4.8082d-10,5.1261d-10,5.4563d-10,5.8115d-10,
     .6.2070d-10,6.6702d-10,7.1843d-10,7.7541d-10,8.3732d-10,9.0173d-10,
     .9.7180d-10,1.0499d-9,1.1314d-9,1.2190d-9,1.3196d-9,1.4321d-9,
     .1.5553d-9,1.7010d-9,1.8575d-9,2.0234d-9,2.2148d-9,2.4239d-9,
     .2.6522d-9,2.9208d-9,3.2220d-9/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       PandaX=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        PandaX=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END


      DOUBLE PRECISION FUNCTION LUX_SI(M)

*  Limit on the spin independent WIMP-nucleon cross-section,
*  from LUX [arXiv:1608.07648]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=99)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/5.4616d0,5.5230d0,5.5883d0,5.6779d0,5.7729d0,5.8659d0,
     .5.9617d0,6.0578d0,6.1569d0,6.2568d0,6.3674d0,6.5140d0,6.6628d0,
     .6.8195d0,6.9737d0,7.1240d0,7.3222d0,7.5346d0,7.7384d0,7.9899d0,
     .8.3084d0,8.6400d0,9.0234d0,9.4196d0,9.8401d0,1.0260d1,1.0731d1,
     .1.1224d1,1.1803d1,1.2410d1,1.3206d1,1.4109d1,1.5282d1,1.6640d1,
     .1.8303d1,2.0054d1,2.2301d1,2.5339d1,2.8659d1,3.2717d1,3.7766d1,
     .4.3862d1,5.1243d1,6.0149d1,7.0327d1,8.2227d1,9.6141d1,1.1241d2,
     .1.2983d2,1.4894d2,1.7144d2,1.9697d2,2.2716d2,2.5944d2,2.9720d2,
     .3.3706d2,3.8425d2,4.3932d2,5.0040d2,5.6947d2,6.5254d2,7.4578d2,
     .8.4754d2,9.6815d2,1.1060d3,1.2631d3,1.4443d3,1.6572d3,1.8944d3,
     .2.1489d3,2.4514d3,2.8016d3,3.1990d3,3.6560d3,4.1763d3,4.7359d3,
     .5.3979d3,6.1298d3,7.0323d3,7.9989d3,9.0461d3,1.0334d4,1.1807d4,
     .1.3414d4,1.5301d4,1.7568d4,1.9967d4,2.2583d4,2.5793d4,2.9468d4,
     .3.3407d4,3.8028d4,4.3233d4,4.9370d4,5.6294d4,6.4376d4,7.3073d4,
     .8.3439d4,9.5764d4/
      DATA Y/8.7557d-7,7.0640d-7,5.6991d-7,4.5245d-7,3.6307d-7,
     .2.9292d-7,2.3633d-7,1.9066d-7,1.5300d-7,1.2278d-7,9.9055d-8,
     .7.9063d-8,6.3787d-8,5.1462d-8,4.1076d-8,3.3139d-8,2.6736d-8,
     .2.1570d-8,1.7403d-8,1.4040d-8,1.1327d-8,9.1387d-9,7.2942d-9,
     .5.8849d-9,4.7478d-9,3.8305d-9,3.1092d-9,2.5202d-9,2.0332d-9,
     .1.6404d-9,1.3377d-9,1.0830d-9,8.9921d-10,7.4657d-10,6.1715d-10,
     .5.1648d-10,4.3820d-10,3.7100d-10,3.2163d-10,2.8051d-10,2.5193d-10,
     .2.2884d-10,2.2296d-10,2.2527d-10,2.3329d-10,2.4766d-10,2.6208d-10,
     .2.8393d-10,3.0905d-10,3.4542d-10,3.8158d-10,4.2559d-10,4.8292d-10,
     .5.4193d-10,6.0874d-10,6.9144d-10,7.8903d-10,8.9594d-10,1.0213d-9,
     .1.1812d-9,1.3503d-9,1.5340d-9,1.7598d-9,2.0227d-9,2.2995d-9,
     .2.6163d-9,3.0013d-9,3.4343d-9,3.9009d-9,4.4299d-9,5.0507d-9,
     .5.7378d-9,6.5244d-9,7.4947d-9,8.5192d-9,9.6949d-9,1.1157d-8,
     .1.2656d-8,1.4477d-8,1.6406d-8,1.8901d-8,2.1493d-8,2.4423d-8,
     .2.7992d-8,3.2189d-8,3.6818d-8,4.1737d-8,4.8049d-8,5.4667d-8,
     .6.2130d-8,7.0651d-8,8.1338d-8,9.2339d-8,1.0627d-7,1.2106d-7,
     .1.3908d-7,1.5797d-7,1.8127d-7,2.0872d-7/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       LUX_SI=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        LUX_SI=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END


      DOUBLE PRECISION FUNCTION LUX_SDn(M)

*  Limit on the spin dependent WIMP-neutron cross-section,
*  from LUX [arXiv:1602.03489]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=65)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/3.5089d0,3.5559d0,3.6117d0,3.6944d0,3.8005d0,3.9322d0,
     .4.0587d0,4.2124d0,4.3938d0,4.5995d0,4.8633d0,5.1178d0,5.3854d0,
     .5.7481d0,6.1375d0,6.6137d0,7.2497d0,7.9793d0,8.9073d0,1.0198d1,
     .1.1803d1,1.3756d1,1.6562d1,2.0270d1,2.4841d1,3.0667d1,3.8134d1,
     .4.7077d1,5.8117d1,7.1746d1,8.8571d1,1.0934d2,1.3401d2,1.6424d2,
     .2.0128d2,2.4669d2,3.0454d2,3.7323d2,4.5743d2,5.6122d2,6.8584d2,
     .8.3819d2,1.0245d3,1.2556d3,1.5501d3,1.8998d3,2.3515d3,2.8743d3,
     .3.5484d3,4.3488d3,5.3686d3,6.6276d3,8.1819d3,1.0101d4,1.2469d4,
     .1.5394d4,1.8866d4,2.3122d4,2.8337d4,3.4729d4,4.2563d4,5.2545d4,
     .6.4398d4,7.8924d4,9.7433d4/
      DATA Y/5.8308d1,3.0609d1,1.6417d1,8.8053d0,4.6223d0,2.4792d0,
     .1.3015d0,6.9803d-1,3.7439d-1,2.0080d-1,1.0576d-1,5.7766d-2,
     .3.0983d-2,1.6837d-2,9.3041d-3,4.9902d-3,2.7610d-3,1.5644d-3,
     .9.1432d-4,5.5074d-4,3.3725d-4,2.1965d-4,1.5809d-4,1.2213d-4,
     .1.0363d-4,9.5468d-5,9.3017d-5,1.0144d-4,1.2024d-4,1.2829d-4,
     .1.4925d-4,1.7713d-4,2.1255d-4,2.5532d-4,3.0719d-4,3.6834d-4,
     .4.4604d-4,5.4319d-4,6.6426d-4,8.1337d-4,9.8598d-4,1.1972d-3,
     .1.4534d-3,1.7725d-3,2.1856d-3,2.6573d-3,3.2858d-3,3.9900d-3,
     .4.9085d-3,6.0098d-3,7.4498d-3,9.2291d-3,1.1438d-2,1.4175d-2,
     .1.7569d-2,2.1777d-2,2.6812d-2,3.2993d-2,4.0385d-2,4.9253d-2,
     .5.9800d-2,7.4685d-2,9.1296d-2,1.1143d-1,1.3815d-1/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       LUX_SDn=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        LUX_SDn=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END


      DOUBLE PRECISION FUNCTION LUX_SDp(M)

*  Limit on the spin dependent WIMP-proton cross-section,
*  from LUX [arXiv:1602.03489]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=63)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/3.7146d0,3.8006d0,3.9158d0,4.0283d0,4.1475d0,4.3036d0,
     .4.5080d0,4.7211d0,4.9366d0,5.2311d0,5.5566d0,5.9213d0,6.3241d0,
     .6.8525d0,7.5330d0,8.3292d0,9.4195d0,1.0801d1,1.2426d1,1.4850d1,
     .1.7937d1,2.1940d1,2.6886d1,3.3188d1,4.1115d1,5.0936d1,6.2886d1,
     .7.7611d1,9.5801d1,1.1740d2,1.4387d2,1.7630d2,2.1605d2,2.6475d2,
     .3.2444d2,3.9759d2,4.8722d2,5.9706d2,7.3167d2,8.9925d2,1.0988d3,
     .1.3465d3,1.6500d3,2.0220d3,2.4959d3,3.0587d3,3.7482d3,4.5932d3,
     .5.6288d3,6.9480d3,8.5144d3,1.0434d4,1.2879d4,1.5783d4,1.9341d4,
     .2.3702d4,2.8927d4,3.5336d4,4.3302d4,5.3452d4,6.5641d4,8.0269d4,
     .9.8022d4/
      DATA Y/4.2591d2,2.2492d2,1.2054d2,6.4599d1,3.4620d1,1.8553d1,
     .9.7316d0,5.2154d0,2.7950d0,1.4979d0,8.2021d-1,4.4912d-1,2.4593d-1,
     .1.3759d-1,7.6979d-2,4.3762d-2,2.5462d-2,1.5474d-2,9.7035d-3,
     .6.6681d-3,4.8470d-3,3.7559d-3,3.0776d-3,2.8994d-3,3.0301d-3,
     .3.0744d-3,3.3700d-3,3.8407d-3,4.3656d-3,5.1836d-3,6.2232d-3,
     .7.5406d-3,9.0686d-3,1.0909d-2,1.3217d-2,1.6280d-2,2.0104d-2,
     .2.4668d-2,3.0377d-2,3.7481d-2,4.5532d-2,5.5336d-2,6.7269d-2,
     .8.1867d-2,9.9782d-2,1.2150d-1,1.4781d-1,1.8025d-1,2.1910d-1,
     .2.6932d-1,3.2924d-1,4.0028d-1,4.9247d-1,6.0128d-1,7.3156d-1,
     .8.9410d-1,1.0974d0,1.3330d0,1.6186d0,2.0243d0,2.4853d0,3.0205d0,
     .3.7224d0/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       LUX_SDp=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        LUX_SDp=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END


      DOUBLE PRECISION FUNCTION PICO60(M)

*  Limit on the spin dependent WIMP-proton cross-section,
*  from PICO-60 [arXiv:1510.07754]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=63)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/1.1353d1,1.1681d1,1.1963d1,1.2325d1,1.2699d1,1.3122d1,
     .1.3520d1,1.3971d1,1.4481d1,1.5053d1,1.5696d1,1.6365d1,1.7166d1,
     .1.8113d1,1.9113d1,2.0288d1,2.1665d1,2.3204d1,2.4927d1,2.7344d1,
     .2.9905d1,3.3500d1,3.7073d1,4.3556d1,4.9668d1,5.8006d1,6.7341d1,
     .7.8178d1,9.1302d1,1.0631d2,1.2342d2,1.4328d2,1.6634d2,1.9253d2,
     .2.2219d2,2.5488d2,2.9326d2,3.3742d2,3.8707d2,4.4139d2,5.0333d2,
     .5.8085d2,6.6235d2,7.5530d2,8.6129d2,9.8215d2,1.1200d3,1.2771d3,
     .1.4563d3,1.6607d3,1.8937d3,2.1595d3,2.4625d3,2.8080d3,3.2021d3,
     .3.6733d3,4.2138d3,4.8339d3,5.5452d3,6.3611d3,7.2972d3,8.3710d3,
     .9.5456d3/
      DATA Y/9.8640d-2,7.9912d-2,6.3719d-2,5.0350d-2,3.9785d-2,
     .3.1437d-2,2.5181d-2,2.0170d-2,1.5938d-2,1.2708d-2,9.9511d-3,
     .8.0069d-3,6.3269d-3,4.9994d-3,3.9863d-3,3.2075d-3,2.5808d-3,
     .2.0955d-3,1.7169d-3,1.4195d-3,1.1790d-3,9.6500d-4,8.4324d-4,
     .7.1315d-4,6.3970d-4,5.9769d-4,5.7122d-4,5.6607d-4,5.7642d-4,
     .5.9498d-4,6.2821d-4,6.7542d-4,7.3279d-4,8.0226d-4,8.8631d-4,
     .9.7917d-4,1.0916d-3,1.2225d-3,1.3877d-3,1.5611d-3,1.7483d-3,
     .1.9936d-3,2.2428d-3,2.5116d-3,2.8255d-3,3.1786d-3,3.5920d-3,
     .4.0776d-3,4.6289d-3,5.2547d-3,5.9651d-3,6.7716d-3,7.6871d-3,
     .8.7264d-3,9.9062d-3,1.1348d-2,1.2999d-2,1.4891d-2,1.7058d-2,
     .1.9540d-2,2.2384d-2,2.5641d-2,2.9373d-2/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       PICO60=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        PICO60=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END


      DOUBLE PRECISION FUNCTION PICO2L(M)

*  Limit on the spin dependent WIMP-proton cross-section,
*  from PICO-2L [arXiv:1601.03729]
*  X = WIMP mass in GeV, Y = cross section in pb

      IMPLICIT NONE
      INTEGER I,N
      PARAMETER(N=67)
      DOUBLE PRECISION X(N),Y(N),M

      DATA X/4.4767d0,4.6203d0,4.7119d0,4.8122d0,4.9314d0,5.0673d0,
     .5.1896d0,5.3366d0,5.5106d0,5.6846d0,5.8828d0,6.1099d0,6.3629d0,
     .6.6494d0,6.9636d0,7.3298d0,7.7125d0,8.1684d0,8.6907d0,9.2948d0,
     .9.9980d0,1.0829d1,1.1756d1,1.2855d1,1.4076d1,1.5528d1,1.7107d1,
     .1.8863d1,2.0849d1,2.3097d1,2.5588d1,2.8347d1,3.1404d1,3.4871d1,
     .3.8722d1,4.2897d1,4.7523d1,5.2770d1,5.8597d1,6.4905d1,7.2083d1,
     .8.0018d1,8.8880d1,9.8663d1,1.0934d2,1.2113d2,1.3387d2,1.4847d2,
     .1.6354d2,1.8118d2,1.9978d2,2.2143d2,2.4405d2,2.7037d2,2.9952d2,
     .3.3082d2,3.6423d2,4.0159d2,4.4283d2,4.8831d2,5.3845d2,5.9374d2,
     .6.5265d2,7.1910d2,7.9246d2,8.7375d2,9.6797d2/
      DATA Y/9.4929d-2,7.4629d-2,5.9863d-2,4.8150d-2,3.8517d-2,
     .3.0892d-2,2.4783d-2,1.9879d-2,1.6107d-2,1.2920d-2,1.0468d-2,
     .8.4812d-3,6.8031d-3,5.5675d-3,4.5109d-3,3.6916d-3,3.0453d-3,
     .2.4973d-3,2.0941d-3,1.7575d-3,1.4774d-3,1.2605d-3,1.0927d-3,
     .9.5861d-4,8.5731d-4,7.7716d-4,7.1868d-4,6.7194d-4,6.4006d-4,
     .6.1537d-4,6.0271d-4,5.9702d-4,5.9107d-4,5.9879d-4,6.0823d-4,
     .6.2132d-4,6.4006d-4,6.6342d-4,6.9349d-4,7.2525d-4,7.6659d-4,
     .8.0936d-4,8.6433d-4,9.2198d-4,9.8844d-4,1.0602d-3,1.1436d-3,
     .1.2328d-3,1.3298d-3,1.4391d-3,1.5602d-3,1.6985d-3,1.8413d-3,
     .2.0147d-3,2.2055d-3,2.4121d-3,2.6404d-3,2.8900d-3,3.1637d-3,
     .3.4623d-3,3.7891d-3,4.1508d-3,4.5363d-3,4.9644d-3,5.4330d-3,
     .5.9483d-3,6.5461d-3/

      IF(M.LT.X(1) .OR. M.GE.X(N))THEN
       PICO2L=1d99
       RETURN
      ENDIF
      DO I=1,N-1
       IF((M.GE.X(I)).AND.(M.LT.X(I+1)))THEN
        PICO2L=Y(I)+(Y(I+1)-Y(I))*(M-X(I))/(X(I+1)-X(I))
        RETURN
       ENDIF
      ENDDO

      END

