      SUBROUTINE FILLCOLL(NSMIN,NSSIN,SMPARA_H,SSPARA_H,NFLAG,IFLAG_H
     .,MCH,HMASS_H,OMIX_H
     .,STMASS_H,STMIX_H,SBMASS_H,SBMIX_H,STAUMASS_H,STAUMIX_H,SNU3MASS_H
     .,MC_H,UL_H,UR_H,MN_H,N_H,NCMAX,NHC_H,SHC_H,CHC_H
     .,NMNH,GAMBRN,NMCH,GAMBRC)
********************************************************************************
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
*-----------------------------------------------------------------------
*+CDE HC_ COMMON BLOCKS:
      COMMON /HC_SMPARA/ AEM_H,ASMZ_H,MZ_H,SW_H,ME_H,MMU_H,MTAU_H,MDMT_H
     .                  ,MSMT_H,MBMT_H,MUMT_H,MCMT_H,MTPOLE_H,GAMW_H
     .                  ,GAMZ_H,EEM_H,ASMT_H,CW_H,TW_H,MW_H,GW_H,GP_H
     .                  ,V_H,GF_H,MTMT_H
*
      COMMON /HC_RSUSYPARA/ TB_H,CB_H,SB_H,MQ3_H,MU3_H,MD3_H,ML3_H,ME3_H
*
      COMPLEX*16 MU_H,M1_H,M2_H,M3_H,AT_H,AB_H,ATAU_H
      COMMON /HC_CSUSYPARA/ MU_H,M1_H,M2_H,M3_H,AT_H,AB_H,ATAU_H
*
*NEW COMMON BLOCKS for V2
*
      REAL*8     RAUX_H(999)
      COMPLEX*16 CAUX_H(999)
      COMMON /HC_RAUX/ RAUX_H
      COMMON /HC_CAUX/ CAUX_H
      DATA NAUX/999/
*-----------------------------------------------------------------------
*ARRAYS:
      REAL*8 SMPARA_H(NSMIN),SSPARA_H(NSSIN)
*
      INTEGER*8 IFLAG_H(NFLAG)
*
      REAL*8     HMASS_H(3),OMIX_H(3,3)
      REAL*8     STMASS_H(2),SBMASS_H(2),STAUMASS_H(2),SNU3MASS_H
      REAL*8     MC_H(2),MN_H(4)
      COMPLEX*16 STMIX_H(2,2),SBMIX_H(2,2),STAUMIX_H(2,2)
      COMPLEX*16 UL_H(2,2),UR_H(2,2),N_H(4,4)
*
      COMPLEX*16 NHC_H(NCMAX,3)  ! 100 = NCMAX
      REAL*8     SHC_H(NCMAX)
      COMPLEX*16 CHC_H(NCMAX)
*
      REAL*8 GAMBRN(NMNH,3,3)
      REAL*8 GAMBRC(NMCH,3)
*=======================================================================
*Local
      REAL*8  CX_SM1(4),CX_SM2(4),CX_SM3(4)
      REAL*8  CX_MSSM1(4),CX_MSSM2(4),CX_MSSM3(4)
      REAL*8  CXBR_H(3)
*-------------------------------------------------------------------------------
*
      ILEP=1
*
      ILEP1=1
      ILEP2=1
      ILEP3=1
      CALL LEP_BOUND(HMASS_H(1),CDABS(NHC_H(70,1))**2,ILEP1)
      CALL LEP_BOUND(HMASS_H(2),CDABS(NHC_H(70,2))**2,ILEP2)
      CALL LEP_BOUND(HMASS_H(3),CDABS(NHC_H(70,3))**2,ILEP3)
      IF(ILEP1.EQ.0 .OR. ILEP2.EQ.0 .OR. ILEP3.EQ.0) ILEP=0

*when the two-Higgs mass difference is smaller than 2.5 GeV
      ILEP12=1
      ILEP13=1
      ILEP23=1
      IF(DABS(HMASS_H(1)-HMASS_H(2)).LT.2.5D0) 
     .CALL LEP_BOUND2(HMASS_H(1)+HMASS_H(2)
     .               ,CDABS(NHC_H(70,3))**2,ILEP12)
      IF(DABS(HMASS_H(1)-HMASS_H(3)).LT.2.5D0) 
     .CALL LEP_BOUND2(HMASS_H(1)+HMASS_H(3)
     .               ,CDABS(NHC_H(70,2))**2,ILEP13)
      IF(DABS(HMASS_H(2)-HMASS_H(3)).LT.2.5D0) 
     .CALL LEP_BOUND2(HMASS_H(2)+HMASS_H(3)
     .               ,CDABS(NHC_H(70,1))**2,ILEP23)
      IF(ILEP12.EQ.0 .OR. ILEP13.EQ.0 .OR. ILEP23.EQ.0) ILEP=0
*-------------------------------------------------------------------------------
*
*Production cross sections at 7-TeV LHC
*
      CALL LHC7_SM(HMASS_H(1),CX_SM1)
      CALL LHC7_SM(HMASS_H(2),CX_SM2)
      CALL LHC7_SM(HMASS_H(3),CX_SM3)

      DO IPROD=1,4
*
       IF(IPROD.EQ.1 .OR. IPROD.EQ. 2) THEN ! gg -> H1,H2,A
        FAC_1=(CDABS(NHC_H(84,1))**2+CDABS(NHC_H(85,1))**2)
     .        /CDABS(CAUX_H(221))**2
        FAC_2=(CDABS(NHC_H(84,2))**2+CDABS(NHC_H(85,2))**2)
     .        /CDABS(CAUX_H(222))**2
        FAC_3=(CDABS(NHC_H(84,3))**2+CDABS(NHC_H(85,3))**2)
     .        /CDABS(CAUX_H(223))**2
       ELSEIF(IPROD.EQ.3) THEN              ! bb -> H1,H2,A
        FAC_1=CDABS(NHC_H(17,1))**2
     .       +CDABS(NHC_H(18,1))**2
     .        /(1.D0-4.D0*RAUX_H(1)**2/HMASS_H(1)**2)
        FAC_2=CDABS(NHC_H(17,2))**2
     .       +CDABS(NHC_H(18,2))**2
     .        /(1.D0-4.D0*RAUX_H(1)**2/HMASS_H(2)**2)
        FAC_3=CDABS(NHC_H(17,3))**2
     .       +CDABS(NHC_H(18,3))**2
     .        /(1.D0-4.D0*RAUX_H(1)**2/HMASS_H(3)**2)
       ELSEIF(IPROD.EQ.4) THEN              ! VV -> H1,H2,A
        FAC_1=CDABS(NHC_H(70,1))**2
        FAC_2=CDABS(NHC_H(70,2))**2
        FAC_3=CDABS(NHC_H(70,3))**2
       ENDIF
*       print*,iprod,fac_1,fac_2,fac_a
*
       CX_MSSM1(IPROD)=FAC_1*CX_SM1(IPROD)
       CX_MSSM2(IPROD)=FAC_2*CX_SM2(IPROD)
       CX_MSSM3(IPROD)=FAC_3*CX_SM3(IPROD)
*
      ENDDO  ! IPROD
*
*
*{sigma(gg)[NLO]+sigma(bb)}*Br(tautau)
      CXBR_H(1)=(CX_MSSM1(1)+CX_MSSM1(3))*GAMBRN(3,3,1)
      CXBR_H(2)=(CX_MSSM2(1)+CX_MSSM2(3))*GAMBRN(3,3,2)
      CXBR_H(3)=(CX_MSSM3(1)+CX_MSSM3(3))*GAMBRN(3,3,3)
       I_A=1
       DO IH=1,3
         IF(OMIX_H(3,IH)**2.GT.OMIX_H(3,I_A)**2) I_A=IH
       ENDDO
*      print*,'>>> FILLCOLL :',mch,i_a,OMIX_H(3,i_a)**2
       IF(I_A.EQ.1) THEN
         IH1=2
         IH2=3
         I_A=1
       ELSEIF(I_A.EQ.2) THEN
         IH1=1
         IH2=3
         I_A=2
       ELSEIF(I_A.EQ.3) THEN
         IH1=1
         IH2=2
         I_A=3
       ELSE
         print*,'ERROR'
       ENDIF
*
      MASS_RESOL=0.21D0*130.D0/2.D0  ! 21 % resolution at MA=130 GeV
      ADD_H1=0.D0
      ADD_H2=0.D0
      IF(DABS(HMASS_H(I_A)-HMASS_H(IH1)).LE.MASS_RESOL) ADD_H1=1.D0
      IF(DABS(HMASS_H(I_A)-HMASS_H(IH2)).LE.MASS_RESOL) ADD_H2=1.D0
      CXBR=CXBR_H(I_A)+ADD_H1*CXBR_H(IH1)+ADD_H2*CXBR_H(IH2)
*
      ILHC=1
      CALL LHC7_HTAUTAU46(HMASS_H(I_A),CXBR,CXBR_BOUND,ILHC)
*      print*,'>>> FILLCOLL :',hmass_h(i_a),ilep,cxbr,cxbr_bound,ilhc
      ILHC_HTAUTAU46=ILHC
*
      RAUX_H(430)=DBLE(ILEP)
      RAUX_H(440)=DBLE(ILHC_HTAUTAU46)
*
*Print results
      IF(IFLAG_H(2).EQ.1) THEN
      print*,' '
      print*,'---------------------------------------------------------'
      print*,' Collider Limits'
      print*,'---------------------------------------------------------'
      IF (RAUX_H(430).EQ.0.D0) WRITE(*,1) ILEP
      IF (RAUX_H(430).EQ.1.D0) WRITE(*,2) ILEP
      IF (RAUX_H(440).EQ.0.D0) WRITE(*,3) ILHC
      IF (RAUX_H(440).EQ.1.D0) WRITE(*,4) ILHC
      print*,'---------------------------------------------------------'
      print*,' '
      ENDIF
*
 1    FORMAT('  ILEP(SM-like BRs assumed   ): ',I1,' (LEP Excluded) ')
 2    FORMAT('  ILEP(SM-like BRs assumed   ): ',I1,' (LEP Allowed ) ')
 3    FORMAT('  ILHC@7TeV(H->tau tau;4.6/fb): ',I1,' (LHC Excluded) ')
 4    FORMAT('  ILHC@7TeV(H->tau tau;4.6/fb): ',I1,' (LHC Allowed ) ')
*
      RETURN
      END


      SUBROUTINE LEP_BOUND(MH,GHSQ,ILEP)
*******************************************************************************
*
*Table 14 (a) of hep-ex/0602042 or Fig2.(a)
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
      PARAMETER(NDIM=53)
      REAL*8 MH_LEP(NDIM),GHSQ_LEP(NDIM)
*
      IF(MH.LT.12.D0) THEN
       ILEP=1
       RETURN
      ENDIF
      IF(MH.GT.114.D0) THEN
       ILEP=1
       RETURN
      ENDIF
*
      DO I=1,NDIM
      MH_LEP(I)=10.D0+2.D0*DBLE(I)
      ENDDO
*
      GHSQ_LEP( 1)=0.0204D0
      GHSQ_LEP( 2)=0.0176D0
      GHSQ_LEP( 3)=0.0158D0
      GHSQ_LEP( 4)=0.0150D0
      GHSQ_LEP( 5)=0.0156D0
      GHSQ_LEP( 6)=0.0177D0
      GHSQ_LEP( 7)=0.0194D0
      GHSQ_LEP( 8)=0.0207D0
      GHSQ_LEP( 9)=0.0223D0
      GHSQ_LEP(10)=0.0203D0
      GHSQ_LEP(11)=0.0193D0
      GHSQ_LEP(12)=0.0191D0
      GHSQ_LEP(13)=0.0241D0
      GHSQ_LEP(14)=0.0299D0
      GHSQ_LEP(15)=0.0333D0
      GHSQ_LEP(16)=0.0367D0
      GHSQ_LEP(17)=0.0378D0
      GHSQ_LEP(18)=0.0387D0
      GHSQ_LEP(19)=0.0391D0
      GHSQ_LEP(20)=0.0363D0
      GHSQ_LEP(21)=0.0386D0
      GHSQ_LEP(22)=0.0387D0
      GHSQ_LEP(23)=0.0384D0
      GHSQ_LEP(24)=0.0390D0
      GHSQ_LEP(25)=0.0398D0
      GHSQ_LEP(26)=0.0293D0
      GHSQ_LEP(27)=0.0278D0
      GHSQ_LEP(28)=0.0236D0
      GHSQ_LEP(29)=0.0236D0
      GHSQ_LEP(30)=0.0271D0
      GHSQ_LEP(31)=0.0291D0
      GHSQ_LEP(32)=0.0320D0
      GHSQ_LEP(33)=0.0421D0
      GHSQ_LEP(34)=0.0469D0
      GHSQ_LEP(35)=0.0435D0
      GHSQ_LEP(36)=0.0467D0
      GHSQ_LEP(37)=0.0539D0
      GHSQ_LEP(38)=0.0762D0
      GHSQ_LEP(39)=0.1120D0
      GHSQ_LEP(40)=0.1530D0
      GHSQ_LEP(41)=0.1790D0
      GHSQ_LEP(42)=0.2290D0
      GHSQ_LEP(43)=0.2390D0
      GHSQ_LEP(44)=0.2560D0
      GHSQ_LEP(45)=0.2440D0
      GHSQ_LEP(46)=0.2370D0
      GHSQ_LEP(47)=0.2550D0
      GHSQ_LEP(48)=0.2630D0
      GHSQ_LEP(49)=0.2660D0
      GHSQ_LEP(50)=0.2970D0
      GHSQ_LEP(51)=0.4350D0
      GHSQ_LEP(52)=0.8240D0
      GHSQ_LEP(53)=1.4100D0
*
*for 'lep_bound.dat'
*      do i=1,ndim
*       print*,dble(i),mh_lep(i),ghsq_lep(i),0.d0,0.d0
*     .       ,0.d0,0.d0,0.d0,0.d0,0.d0
*      enddo
*
      I_IN=INT( (MH-10.D0)/2.D0 )
      GHSQ_EXT=GHSQ_LEP(I_IN)
     .       +(GHSQ_LEP(I_IN+1)-GHSQ_LEP(I_IN))*(MH-MH_LEP(I_IN))/2.D0
*      print*,mh,i_in,ghsq_lep(i_in),ghsq_ext
      IF(GHSQ.GE.GHSQ_EXT) THEN
       ILEP=0
      ELSE
       ILEP=1
      ENDIF
*
      RETURN
      END


      SUBROUTINE LEP_BOUND2(MH,GHSQ,ILEP)
*******************************************************************************
*
*Table 17 (a) of hep-ex/0602042 
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
      PARAMETER(NDIM=41)
      REAL*8 MH_LEP(NDIM),GHSQ_LEP(NDIM)
*
      IF(MH.GT.200.D0) THEN
       ILEP=1
       RETURN
      ENDIF
*
      DO I=1,NDIM
      MH_LEP(I)=-5.D0+5.D0*DBLE(I)
      ENDDO
*
      GHSQ_LEP( 1)=0.0237D0
      GHSQ_LEP( 2)=0.0238D0
      GHSQ_LEP( 3)=0.0242D0
      GHSQ_LEP( 4)=0.0248D0
      GHSQ_LEP( 5)=0.0255D0
      GHSQ_LEP( 6)=0.0266D0
      GHSQ_LEP( 7)=0.0054D0
      GHSQ_LEP( 8)=0.0044D0
      GHSQ_LEP( 9)=0.0029D0
      GHSQ_LEP(10)=0.0033D0
      GHSQ_LEP(11)=0.0036D0
      GHSQ_LEP(12)=0.0043D0
      GHSQ_LEP(13)=0.0055D0
      GHSQ_LEP(14)=0.0073D0
      GHSQ_LEP(15)=0.0097D0
      GHSQ_LEP(16)=0.0142D0
      GHSQ_LEP(17)=0.0203D0
      GHSQ_LEP(18)=0.0357D0
      GHSQ_LEP(19)=0.0527D0
      GHSQ_LEP(20)=0.0520D0
      GHSQ_LEP(21)=0.0298D0
      GHSQ_LEP(22)=0.0243D0
      GHSQ_LEP(23)=0.0297D0
      GHSQ_LEP(24)=0.0472D0
      GHSQ_LEP(25)=0.0682D0
      GHSQ_LEP(26)=0.0676D0
      GHSQ_LEP(27)=0.0688D0
      GHSQ_LEP(28)=0.0618D0
      GHSQ_LEP(29)=0.0669D0
      GHSQ_LEP(30)=0.0600D0
      GHSQ_LEP(31)=0.0798D0
      GHSQ_LEP(32)=0.0967D0
      GHSQ_LEP(33)=0.1360D0
      GHSQ_LEP(34)=0.1790D0
      GHSQ_LEP(35)=0.3230D0
      GHSQ_LEP(36)=0.3520D0
      GHSQ_LEP(37)=0.7650D0
      GHSQ_LEP(38)=0.8380D0
      GHSQ_LEP(39)=1.0400D0
      GHSQ_LEP(40)=1.9300D0
      GHSQ_LEP(41)=6.9700D0
*
*      do i=1,ndim
*      print*,i,mh_lep(i),ghsq_lep(i)
*      enddo
*
      I_IN=INT( (MH+5.D0)/5.D0 )
      GHSQ_EXT=GHSQ_LEP(I_IN)
     .       +(GHSQ_LEP(I_IN+1)-GHSQ_LEP(I_IN))*(MH-MH_LEP(I_IN))/5.D0
*      print*,mh,i_in,ghsq_lep(i_in),ghsq_ext
      IF(GHSQ.GE.GHSQ_EXT) THEN
       ILEP=0
      ELSE
       ILEP=1
      ENDIF
*
      RETURN
      END


      SUBROUTINE LHC7_SM(MH,CX_SM)
********************************************************************************
*
* The SM Higgs production cross sections at the 7 TeV LHC
*
* IPROD
* 1 : gg -> H_SM @ NLO
* 2 : gg -> H_SM @ NNLO
* 3 : bb -> H_SM 
* 4 : VV -> H_SM 
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
      PARAMETER(NVAR=150)
      REAL*8    MHSM(NVAR),FILL(NVAR),CX_SM(4)
*-------------------------------------------------------------------------------
*
*      MH=50.D0
*      MH=1000.D0
*      MH=999.99999D0
      IF(MH.LT.50.D0 .OR. MH.GT.1000.D0) THEN
*       print*,'MH : Out of Range'
        CX_SM(1)=0.D0
        CX_SM(2)=0.D0
        CX_SM(3)=0.D0
        CX_SM(4)=0.D0
       GOTO 99
      ENDIF
*
      DO IPROD=1,4
*
       CALL CX_SM_HARD(IPROD,NITEM,MHSM,FILL)
*
       IF(MH.EQ.1000.D0) THEN
        CX_SM(IPROD)=FILL(NITEM)
        GOTO 98
       ENDIF
*
       DO IMH=1,NITEM
        IF(MHSM(IMH).GT.MH) THEN
         NMH=IMH-1
         GOTO 97
        ENDIF
       ENDDO
*
 97    CONTINUE
*        print*,iprod,mh,nmh,mhsm(nmh),mhsm(nmh+1)
*     .        ,fill(nmh),fill(nmh+1)
       CX_SM(IPROD)= FILL(NMH)
     .             +(FILL(NMH+1)-FILL(NMH))
     .             *(MH-MHSM(NMH))/(MHSM(NMH+1)-MHSM(NMH))
*
 98   CONTINUE
      ENDDO ! IPROD
*
*       print*,mh,(cx_sm(ii),ii=1,4)
  1   FORMAT('         MHSM(',I3,')=',E16.10)
  2   FORMAT('         FILL(',I3,')=',E16.10)
*
 99   RETURN
      END

      SUBROUTINE CX_SM_HARD(IPROD,NITEM,MHSM,FILL)
********************************************************************************
*
* The SM Higgs production cross sections at the 7 TeV LHC: Hard-cored
*
* Input:  IPROD
*         1 : gg -> H_SM @ NLO
*         2 : gg -> H_SM @ NNLO
*         3 : bb -> H_SM 
*         4 : VV -> H_SM 
*
* Output: NITEM : number of entries
*         MHSM  : SM Higgs mass
*         FILL  : Cross sections in pb
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
      PARAMETER(NVAR=150)
      REAL*8    MHSM(NVAR),FILL(NVAR)
*
      DO IVAR=1,NVAR
       MHSM(NVAR)=0.D0
       FILL(NVAR)=0.D0
      ENDDO
*
      IF(IPROD.EQ.1) THEN
       NITEM=141
         MHSM(  1)=0.5000000000E+02
         FILL(  1)=0.6865000000E+02
         MHSM(  2)=0.5500000000E+02
         FILL(  2)=0.5576480000E+02
         MHSM(  3)=0.6000000000E+02
         FILL(  3)=0.4641170000E+02
         MHSM(  4)=0.6500000000E+02
         FILL(  4)=0.3935350000E+02
         MHSM(  5)=0.7000000000E+02
         FILL(  5)=0.3386160000E+02
         MHSM(  6)=0.7500000000E+02
         FILL(  6)=0.2948080000E+02
         MHSM(  7)=0.8000000000E+02
         FILL(  7)=0.2591500000E+02
         MHSM(  8)=0.8500000000E+02
         FILL(  8)=0.2296510000E+02
         MHSM(  9)=0.9000000000E+02
         FILL(  9)=0.2049060000E+02
         MHSM( 10)=0.9500000000E+02
         FILL( 10)=0.1839150000E+02
         MHSM( 11)=0.1000000000E+03
         FILL( 11)=0.1659170000E+02
         MHSM( 12)=0.1050000000E+03
         FILL( 12)=0.1503850000E+02
         MHSM( 13)=0.1100000000E+03
         FILL( 13)=0.1369090000E+02
         MHSM( 14)=0.1150000000E+03
         FILL( 14)=0.1250700000E+02
         MHSM( 15)=0.1200000000E+03
         FILL( 15)=0.1146560000E+02
         MHSM( 16)=0.1250000000E+03
         FILL( 16)=0.1054360000E+02
         MHSM( 17)=0.1300000000E+03
         FILL( 17)=0.9723950000E+01
         MHSM( 18)=0.1350000000E+03
         FILL( 18)=0.8992540000E+01
         MHSM( 19)=0.1400000000E+03
         FILL( 19)=0.8336340000E+01
         MHSM( 20)=0.1450000000E+03
         FILL( 20)=0.7746700000E+01
         MHSM( 21)=0.1500000000E+03
         FILL( 21)=0.7214830000E+01
         MHSM( 22)=0.1550000000E+03
         FILL( 22)=0.6733670000E+01
         MHSM( 23)=0.1600000000E+03
         FILL( 23)=0.6297380000E+01
         MHSM( 24)=0.1650000000E+03
         FILL( 24)=0.5900420000E+01
         MHSM( 25)=0.1700000000E+03
         FILL( 25)=0.5538600000E+01
         MHSM( 26)=0.1750000000E+03
         FILL( 26)=0.5208090000E+01
         MHSM( 27)=0.1800000000E+03
         FILL( 27)=0.4905620000E+01
         MHSM( 28)=0.1850000000E+03
         FILL( 28)=0.4628350000E+01
         MHSM( 29)=0.1900000000E+03
         FILL( 29)=0.4373690000E+01
         MHSM( 30)=0.1950000000E+03
         FILL( 30)=0.4139350000E+01
         MHSM( 31)=0.2000000000E+03
         FILL( 31)=0.3923430000E+01
         MHSM( 32)=0.2050000000E+03
         FILL( 32)=0.3724210000E+01
         MHSM( 33)=0.2100000000E+03
         FILL( 33)=0.3540080000E+01
         MHSM( 34)=0.2150000000E+03
         FILL( 34)=0.3369790000E+01
         MHSM( 35)=0.2200000000E+03
         FILL( 35)=0.3212100000E+01
         MHSM( 36)=0.2250000000E+03
         FILL( 36)=0.3065960000E+01
         MHSM( 37)=0.2300000000E+03
         FILL( 37)=0.2930440000E+01
         MHSM( 38)=0.2350000000E+03
         FILL( 38)=0.2804630000E+01
         MHSM( 39)=0.2400000000E+03
         FILL( 39)=0.2687850000E+01
         MHSM( 40)=0.2450000000E+03
         FILL( 40)=0.2579350000E+01
         MHSM( 41)=0.2500000000E+03
         FILL( 41)=0.2478570000E+01
         MHSM( 42)=0.2550000000E+03
         FILL( 42)=0.2384940000E+01
         MHSM( 43)=0.2600000000E+03
         FILL( 43)=0.2298000000E+01
         MHSM( 44)=0.2650000000E+03
         FILL( 44)=0.2217310000E+01
         MHSM( 45)=0.2700000000E+03
         FILL( 45)=0.2142530000E+01
         MHSM( 46)=0.2750000000E+03
         FILL( 46)=0.2073290000E+01
         MHSM( 47)=0.2800000000E+03
         FILL( 47)=0.2009340000E+01
         MHSM( 48)=0.2850000000E+03
         FILL( 48)=0.1950460000E+01
         MHSM( 49)=0.2900000000E+03
         FILL( 49)=0.1896460000E+01
         MHSM( 50)=0.2950000000E+03
         FILL( 50)=0.1847220000E+01
         MHSM( 51)=0.3000000000E+03
         FILL( 51)=0.1802640000E+01
         MHSM( 52)=0.3050000000E+03
         FILL( 52)=0.1762750000E+01
         MHSM( 53)=0.3100000000E+03
         FILL( 53)=0.1727610000E+01
         MHSM( 54)=0.3150000000E+03
         FILL( 54)=0.1697440000E+01
         MHSM( 55)=0.3200000000E+03
         FILL( 55)=0.1672610000E+01
         MHSM( 56)=0.3250000000E+03
         FILL( 56)=0.1653760000E+01
         MHSM( 57)=0.3300000000E+03
         FILL( 57)=0.1641940000E+01
         MHSM( 58)=0.3350000000E+03
         FILL( 58)=0.1639160000E+01
         MHSM( 59)=0.3400000000E+03
         FILL( 59)=0.1649690000E+01
         MHSM( 60)=0.3450000000E+03
         FILL( 60)=0.1691050000E+01
         MHSM( 61)=0.3500000000E+03
         FILL( 61)=0.1753800000E+01
         MHSM( 62)=0.3550000000E+03
         FILL( 62)=0.1783040000E+01
         MHSM( 63)=0.3600000000E+03
         FILL( 63)=0.1791050000E+01
         MHSM( 64)=0.3650000000E+03
         FILL( 64)=0.1783050000E+01
         MHSM( 65)=0.3700000000E+03
         FILL( 65)=0.1762650000E+01
         MHSM( 66)=0.3750000000E+03
         FILL( 66)=0.1732660000E+01
         MHSM( 67)=0.3800000000E+03
         FILL( 67)=0.1695280000E+01
         MHSM( 68)=0.3850000000E+03
         FILL( 68)=0.1652310000E+01
         MHSM( 69)=0.3900000000E+03
         FILL( 69)=0.1605210000E+01
         MHSM( 70)=0.3950000000E+03
         FILL( 70)=0.1555190000E+01
         MHSM( 71)=0.4000000000E+03
         FILL( 71)=0.1503180000E+01
         MHSM( 72)=0.4050000000E+03
         FILL( 72)=0.1450000000E+01
         MHSM( 73)=0.4100000000E+03
         FILL( 73)=0.1396300000E+01
         MHSM( 74)=0.4150000000E+03
         FILL( 74)=0.1342580000E+01
         MHSM( 75)=0.4200000000E+03
         FILL( 75)=0.1289250000E+01
         MHSM( 76)=0.4250000000E+03
         FILL( 76)=0.1236660000E+01
         MHSM( 77)=0.4300000000E+03
         FILL( 77)=0.1185130000E+01
         MHSM( 78)=0.4350000000E+03
         FILL( 78)=0.1134640000E+01
         MHSM( 79)=0.4400000000E+03
         FILL( 79)=0.1085600000E+01
         MHSM( 80)=0.4450000000E+03
         FILL( 80)=0.1037980000E+01
         MHSM( 81)=0.4500000000E+03
         FILL( 81)=0.9919260000E+00
         MHSM( 82)=0.4550000000E+03
         FILL( 82)=0.9474540000E+00
         MHSM( 83)=0.4600000000E+03
         FILL( 83)=0.9046020000E+00
         MHSM( 84)=0.4650000000E+03
         FILL( 84)=0.8633820000E+00
         MHSM( 85)=0.4700000000E+03
         FILL( 85)=0.8237930000E+00
         MHSM( 86)=0.4750000000E+03
         FILL( 86)=0.7858110000E+00
         MHSM( 87)=0.4800000000E+03
         FILL( 87)=0.7494320000E+00
         MHSM( 88)=0.4850000000E+03
         FILL( 88)=0.7146130000E+00
         MHSM( 89)=0.4900000000E+03
         FILL( 89)=0.6812940000E+00
         MHSM( 90)=0.4950000000E+03
         FILL( 90)=0.6494620000E+00
         MHSM( 91)=0.5000000000E+03
         FILL( 91)=0.6190680000E+00
         MHSM( 92)=0.5100000000E+03
         FILL( 92)=0.5623720000E+00
         MHSM( 93)=0.5200000000E+03
         FILL( 93)=0.5108250000E+00
         MHSM( 94)=0.5300000000E+03
         FILL( 94)=0.4640200000E+00
         MHSM( 95)=0.5400000000E+03
         FILL( 95)=0.4215690000E+00
         MHSM( 96)=0.5500000000E+03
         FILL( 96)=0.3831040000E+00
         MHSM( 97)=0.5600000000E+03
         FILL( 97)=0.3482450000E+00
         MHSM( 98)=0.5700000000E+03
         FILL( 98)=0.3166800000E+00
         MHSM( 99)=0.5800000000E+03
         FILL( 99)=0.2880980000E+00
         MHSM(100)=0.5900000000E+03
         FILL(100)=0.2622190000E+00
         MHSM(101)=0.6000000000E+03
         FILL(101)=0.2387840000E+00
         MHSM(102)=0.6100000000E+03
         FILL(102)=0.2175550000E+00
         MHSM(103)=0.6200000000E+03
         FILL(103)=0.1983220000E+00
         MHSM(104)=0.6300000000E+03
         FILL(104)=0.1808940000E+00
         MHSM(105)=0.6400000000E+03
         FILL(105)=0.1650900000E+00
         MHSM(106)=0.6500000000E+03
         FILL(106)=0.1507520000E+00
         MHSM(107)=0.6600000000E+03
         FILL(107)=0.1377430000E+00
         MHSM(108)=0.6700000000E+03
         FILL(108)=0.1259310000E+00
         MHSM(109)=0.6800000000E+03
         FILL(109)=0.1152020000E+00
         MHSM(110)=0.6900000000E+03
         FILL(110)=0.1054460000E+00
         MHSM(111)=0.7000000000E+03
         FILL(111)=0.9657530000E-01
         MHSM(112)=0.7100000000E+03
         FILL(112)=0.8850390000E-01
         MHSM(113)=0.7200000000E+03
         FILL(113)=0.8115410000E-01
         MHSM(114)=0.7300000000E+03
         FILL(114)=0.7445810000E-01
         MHSM(115)=0.7400000000E+03
         FILL(115)=0.6835440000E-01
         MHSM(116)=0.7500000000E+03
         FILL(116)=0.6278720000E-01
         MHSM(117)=0.7600000000E+03
         FILL(117)=0.5770670000E-01
         MHSM(118)=0.7700000000E+03
         FILL(118)=0.5306640000E-01
         MHSM(119)=0.7800000000E+03
         FILL(119)=0.4882640000E-01
         MHSM(120)=0.7900000000E+03
         FILL(120)=0.4495040000E-01
         MHSM(121)=0.8000000000E+03
         FILL(121)=0.4140440000E-01
         MHSM(122)=0.8100000000E+03
         FILL(122)=0.3815860000E-01
         MHSM(123)=0.8200000000E+03
         FILL(123)=0.3518570000E-01
         MHSM(124)=0.8300000000E+03
         FILL(124)=0.3246130000E-01
         MHSM(125)=0.8400000000E+03
         FILL(125)=0.2996320000E-01
         MHSM(126)=0.8500000000E+03
         FILL(126)=0.2767150000E-01
         MHSM(127)=0.8600000000E+03
         FILL(127)=0.2556770000E-01
         MHSM(128)=0.8700000000E+03
         FILL(128)=0.2363550000E-01
         MHSM(129)=0.8800000000E+03
         FILL(129)=0.2185980000E-01
         MHSM(130)=0.8900000000E+03
         FILL(130)=0.2022710000E-01
         MHSM(131)=0.9000000000E+03
         FILL(131)=0.1872510000E-01
         MHSM(132)=0.9100000000E+03
         FILL(132)=0.1734270000E-01
         MHSM(133)=0.9200000000E+03
         FILL(133)=0.1606970000E-01
         MHSM(134)=0.9300000000E+03
         FILL(134)=0.1489670000E-01
         MHSM(135)=0.9400000000E+03
         FILL(135)=0.1381530000E-01
         MHSM(136)=0.9500000000E+03
         FILL(136)=0.1281790000E-01
         MHSM(137)=0.9600000000E+03
         FILL(137)=0.1189760000E-01
         MHSM(138)=0.9700000000E+03
         FILL(138)=0.1104800000E-01
         MHSM(139)=0.9800000000E+03
         FILL(139)=0.1026330000E-01
         MHSM(140)=0.9900000000E+03
         FILL(140)=0.9537900000E-02
         MHSM(141)=0.1000000000E+04
         FILL(141)=0.8867570000E-02
      ENDIF
*
      IF(IPROD.EQ.2) THEN
       NITEM=141
         FILL(  1)=0.8812340000E+02
         MHSM(  2)=0.5500000000E+02
         FILL(  2)=0.7219370000E+02
         MHSM(  3)=0.6000000000E+02
         FILL(  3)=0.6039610000E+02
         MHSM(  4)=0.6500000000E+02
         FILL(  4)=0.5135850000E+02
         MHSM(  5)=0.7000000000E+02
         FILL(  5)=0.4424930000E+02
         MHSM(  6)=0.7500000000E+02
         FILL(  6)=0.3853500000E+02
         MHSM(  7)=0.8000000000E+02
         FILL(  7)=0.3386000000E+02
         MHSM(  8)=0.8500000000E+02
         FILL(  8)=0.2997950000E+02
         MHSM(  9)=0.9000000000E+02
         FILL(  9)=0.2671840000E+02
         MHSM( 10)=0.9500000000E+02
         FILL( 10)=0.2394940000E+02
         MHSM( 11)=0.1000000000E+03
         FILL( 11)=0.2157560000E+02
         MHSM( 12)=0.1050000000E+03
         FILL( 12)=0.1952720000E+02
         MHSM( 13)=0.1100000000E+03
         FILL( 13)=0.1774980000E+02
         MHSM( 14)=0.1150000000E+03
         FILL( 14)=0.1619140000E+02
         MHSM( 15)=0.1200000000E+03
         FILL( 15)=0.1482180000E+02
         MHSM( 16)=0.1250000000E+03
         FILL( 16)=0.1361080000E+02
         MHSM( 17)=0.1300000000E+03
         FILL( 17)=0.1253590000E+02
         MHSM( 18)=0.1350000000E+03
         FILL( 18)=0.1157780000E+02
         MHSM( 19)=0.1400000000E+03
         FILL( 19)=0.1071980000E+02
         MHSM( 20)=0.1450000000E+03
         FILL( 20)=0.9949820000E+01
         MHSM( 21)=0.1500000000E+03
         FILL( 21)=0.9256210000E+01
         MHSM( 22)=0.1550000000E+03
         FILL( 22)=0.8629580000E+01
         MHSM( 23)=0.1600000000E+03
         FILL( 23)=0.8062090000E+01
         MHSM( 24)=0.1650000000E+03
         FILL( 24)=0.7546500000E+01
         MHSM( 25)=0.1700000000E+03
         FILL( 25)=0.7077120000E+01
         MHSM( 26)=0.1750000000E+03
         FILL( 26)=0.6648870000E+01
         MHSM( 27)=0.1800000000E+03
         FILL( 27)=0.6257380000E+01
         MHSM( 28)=0.1850000000E+03
         FILL( 28)=0.5898860000E+01
         MHSM( 29)=0.1900000000E+03
         FILL( 29)=0.5569910000E+01
         MHSM( 30)=0.1950000000E+03
         FILL( 30)=0.5267510000E+01
         MHSM( 31)=0.2000000000E+03
         FILL( 31)=0.4989130000E+01
         MHSM( 32)=0.2050000000E+03
         FILL( 32)=0.4732510000E+01
         MHSM( 33)=0.2100000000E+03
         FILL( 33)=0.4495550000E+01
         MHSM( 34)=0.2150000000E+03
         FILL( 34)=0.4276570000E+01
         MHSM( 35)=0.2200000000E+03
         FILL( 35)=0.4073950000E+01
         MHSM( 36)=0.2250000000E+03
         FILL( 36)=0.3886310000E+01
         MHSM( 37)=0.2300000000E+03
         FILL( 37)=0.3712400000E+01
         MHSM( 38)=0.2350000000E+03
         FILL( 38)=0.3551070000E+01
         MHSM( 39)=0.2400000000E+03
         FILL( 39)=0.3401370000E+01
         MHSM( 40)=0.2450000000E+03
         FILL( 40)=0.3262370000E+01
         MHSM( 41)=0.2500000000E+03
         FILL( 41)=0.3133310000E+01
         MHSM( 42)=0.2550000000E+03
         FILL( 42)=0.3013450000E+01
         MHSM( 43)=0.2600000000E+03
         FILL( 43)=0.2902190000E+01
         MHSM( 44)=0.2650000000E+03
         FILL( 44)=0.2798950000E+01
         MHSM( 45)=0.2700000000E+03
         FILL( 45)=0.2703270000E+01
         MHSM( 46)=0.2750000000E+03
         FILL( 46)=0.2614690000E+01
         MHSM( 47)=0.2800000000E+03
         FILL( 47)=0.2532870000E+01
         MHSM( 48)=0.2850000000E+03
         FILL( 48)=0.2457510000E+01
         MHSM( 49)=0.2900000000E+03
         FILL( 49)=0.2388360000E+01
         MHSM( 50)=0.2950000000E+03
         FILL( 50)=0.2325250000E+01
         MHSM( 51)=0.3000000000E+03
         FILL( 51)=0.2268050000E+01
         MHSM( 52)=0.3050000000E+03
         FILL( 52)=0.2216760000E+01
         MHSM( 53)=0.3100000000E+03
         FILL( 53)=0.2171470000E+01
         MHSM( 54)=0.3150000000E+03
         FILL( 54)=0.2132410000E+01
         MHSM( 55)=0.3200000000E+03
         FILL( 55)=0.2100020000E+01
         MHSM( 56)=0.3250000000E+03
         FILL( 56)=0.2075050000E+01
         MHSM( 57)=0.3300000000E+03
         FILL( 57)=0.2058770000E+01
         MHSM( 58)=0.3350000000E+03
         FILL( 58)=0.2053570000E+01
         MHSM( 59)=0.3400000000E+03
         FILL( 59)=0.2064520000E+01
         MHSM( 60)=0.3450000000E+03
         FILL( 60)=0.2111790000E+01
         MHSM( 61)=0.3500000000E+03
         FILL( 61)=0.2187640000E+01
         MHSM( 62)=0.3550000000E+03
         FILL( 62)=0.2224750000E+01
         MHSM( 63)=0.3600000000E+03
         FILL( 63)=0.2235980000E+01
         MHSM( 64)=0.3650000000E+03
         FILL( 64)=0.2227370000E+01
         MHSM( 65)=0.3700000000E+03
         FILL( 65)=0.2203260000E+01
         MHSM( 66)=0.3750000000E+03
         FILL( 66)=0.2167060000E+01
         MHSM( 67)=0.3800000000E+03
         FILL( 67)=0.2121490000E+01
         MHSM( 68)=0.3850000000E+03
         FILL( 68)=0.2068790000E+01
         MHSM( 69)=0.3900000000E+03
         FILL( 69)=0.2010800000E+01
         MHSM( 70)=0.3950000000E+03
         FILL( 70)=0.1949000000E+01
         MHSM( 71)=0.4000000000E+03
         FILL( 71)=0.1884610000E+01
         MHSM( 72)=0.4050000000E+03
         FILL( 72)=0.1818630000E+01
         MHSM( 73)=0.4100000000E+03
         FILL( 73)=0.1751900000E+01
         MHSM( 74)=0.4150000000E+03
         FILL( 74)=0.1685050000E+01
         MHSM( 75)=0.4200000000E+03
         FILL( 75)=0.1618610000E+01
         MHSM( 76)=0.4250000000E+03
         FILL( 76)=0.1553020000E+01
         MHSM( 77)=0.4300000000E+03
         FILL( 77)=0.1488670000E+01
         MHSM( 78)=0.4350000000E+03
         FILL( 78)=0.1425620000E+01
         MHSM( 79)=0.4400000000E+03
         FILL( 79)=0.1364290000E+01
         MHSM( 80)=0.4450000000E+03
         FILL( 80)=0.1304730000E+01
         MHSM( 81)=0.4500000000E+03
         FILL( 81)=0.1247070000E+01
         MHSM( 82)=0.4550000000E+03
         FILL( 82)=0.1191370000E+01
         MHSM( 83)=0.4600000000E+03
         FILL( 83)=0.1137670000E+01
         MHSM( 84)=0.4650000000E+03
         FILL( 84)=0.1085990000E+01
         MHSM( 85)=0.4700000000E+03
         FILL( 85)=0.1036330000E+01
         MHSM( 86)=0.4750000000E+03
         FILL( 86)=0.9886790000E+00
         MHSM( 87)=0.4800000000E+03
         FILL( 87)=0.9430150000E+00
         MHSM( 88)=0.4850000000E+03
         FILL( 88)=0.8992950000E+00
         MHSM( 89)=0.4900000000E+03
         FILL( 89)=0.8574510000E+00
         MHSM( 90)=0.4950000000E+03
         FILL( 90)=0.8174610000E+00
         MHSM( 91)=0.5000000000E+03
         FILL( 91)=0.7792660000E+00
         MHSM( 92)=0.5100000000E+03
         FILL( 92)=0.7079970000E+00
         MHSM( 93)=0.5200000000E+03
         FILL( 93)=0.6431730000E+00
         MHSM( 94)=0.5300000000E+03
         FILL( 94)=0.5842900000E+00
         MHSM( 95)=0.5400000000E+03
         FILL( 95)=0.5308670000E+00
         MHSM( 96)=0.5500000000E+03
         FILL( 96)=0.4824430000E+00
         MHSM( 97)=0.5600000000E+03
         FILL( 97)=0.4385550000E+00
         MHSM( 98)=0.5700000000E+03
         FILL( 98)=0.3988040000E+00
         MHSM( 99)=0.5800000000E+03
         FILL( 99)=0.3628040000E+00
         MHSM(100)=0.5900000000E+03
         FILL(100)=0.3302040000E+00
         MHSM(101)=0.6000000000E+03
         FILL(101)=0.3006780000E+00
         MHSM(102)=0.6100000000E+03
         FILL(102)=0.2739320000E+00
         MHSM(103)=0.6200000000E+03
         FILL(103)=0.2496970000E+00
         MHSM(104)=0.6300000000E+03
         FILL(104)=0.2277340000E+00
         MHSM(105)=0.6400000000E+03
         FILL(105)=0.2078190000E+00
         MHSM(106)=0.6500000000E+03
         FILL(106)=0.1897510000E+00
         MHSM(107)=0.6600000000E+03
         FILL(107)=0.1733570000E+00
         MHSM(108)=0.6700000000E+03
         FILL(108)=0.1584710000E+00
         MHSM(109)=0.6800000000E+03
         FILL(109)=0.1449500000E+00
         MHSM(110)=0.6900000000E+03
         FILL(110)=0.1326570000E+00
         MHSM(111)=0.7000000000E+03
         FILL(111)=0.1214800000E+00
         MHSM(112)=0.7100000000E+03
         FILL(112)=0.1113100000E+00
         MHSM(113)=0.7200000000E+03
         FILL(113)=0.1020500000E+00
         MHSM(114)=0.7300000000E+03
         FILL(114)=0.9361520000E-01
         MHSM(115)=0.7400000000E+03
         FILL(115)=0.8592670000E-01
         MHSM(116)=0.7500000000E+03
         FILL(116)=0.7891470000E-01
         MHSM(117)=0.7600000000E+03
         FILL(117)=0.7251630000E-01
         MHSM(118)=0.7700000000E+03
         FILL(118)=0.6667330000E-01
         MHSM(119)=0.7800000000E+03
         FILL(119)=0.6133480000E-01
         MHSM(120)=0.7900000000E+03
         FILL(120)=0.5645510000E-01
         MHSM(121)=0.8000000000E+03
         FILL(121)=0.5199160000E-01
         MHSM(122)=0.8100000000E+03
         FILL(122)=0.4790650000E-01
         MHSM(123)=0.8200000000E+03
         FILL(123)=0.4416540000E-01
         MHSM(124)=0.8300000000E+03
         FILL(124)=0.4073770000E-01
         MHSM(125)=0.8400000000E+03
         FILL(125)=0.3759520000E-01
         MHSM(126)=0.8500000000E+03
         FILL(126)=0.3471260000E-01
         MHSM(127)=0.8600000000E+03
         FILL(127)=0.3206700000E-01
         MHSM(128)=0.8700000000E+03
         FILL(128)=0.2963750000E-01
         MHSM(129)=0.8800000000E+03
         FILL(129)=0.2740530000E-01
         MHSM(130)=0.8900000000E+03
         FILL(130)=0.2535320000E-01
         MHSM(131)=0.9000000000E+03
         FILL(131)=0.2346570000E-01
         MHSM(132)=0.9100000000E+03
         FILL(132)=0.2172880000E-01
         MHSM(133)=0.9200000000E+03
         FILL(133)=0.2012960000E-01
         MHSM(134)=0.9300000000E+03
         FILL(134)=0.1865640000E-01
         MHSM(135)=0.9400000000E+03
         FILL(135)=0.1729850000E-01
         MHSM(136)=0.9500000000E+03
         FILL(136)=0.1604630000E-01
         MHSM(137)=0.9600000000E+03
         FILL(137)=0.1489120000E-01
         MHSM(138)=0.9700000000E+03
         FILL(138)=0.1382500000E-01
         MHSM(139)=0.9800000000E+03
         FILL(139)=0.1284040000E-01
         MHSM(140)=0.9900000000E+03
         FILL(140)=0.1193060000E-01
         MHSM(141)=0.1000000000E+04
         FILL(141)=0.1108990000E-01
      ENDIF
*
      IF(IPROD.EQ.3) THEN
       NITEM=141
         MHSM(  1)=0.5000000000E+02
         FILL(  1)=0.2464236870E+01
         MHSM(  2)=0.5500000000E+02
         FILL(  2)=0.1961742060E+01
         MHSM(  3)=0.6000000000E+02
         FILL(  3)=0.1573295490E+01
         MHSM(  4)=0.6500000000E+02
         FILL(  4)=0.1271487120E+01
         MHSM(  5)=0.7000000000E+02
         FILL(  5)=0.1035582310E+01
         MHSM(  6)=0.7500000000E+02
         FILL(  6)=0.8497914670E+00
         MHSM(  7)=0.8000000000E+02
         FILL(  7)=0.7024514410E+00
         MHSM(  8)=0.8500000000E+02
         FILL(  8)=0.5846935150E+00
         MHSM(  9)=0.9000000000E+02
         FILL(  9)=0.4897927270E+00
         MHSM( 10)=0.9500000000E+02
         FILL( 10)=0.4128293460E+00
         MHSM( 11)=0.1000000000E+03
         FILL( 11)=0.3499498700E+00
         MHSM( 12)=0.1050000000E+03
         FILL( 12)=0.2982471270E+00
         MHSM( 13)=0.1100000000E+03
         FILL( 13)=0.2554455070E+00
         MHSM( 14)=0.1150000000E+03
         FILL( 14)=0.2198107660E+00
         MHSM( 15)=0.1200000000E+03
         FILL( 15)=0.1899812740E+00
         MHSM( 16)=0.1250000000E+03
         FILL( 16)=0.1648940920E+00
         MHSM( 17)=0.1300000000E+03
         FILL( 17)=0.1435833230E+00
         MHSM( 18)=0.1350000000E+03
         FILL( 18)=0.1255572000E+00
         MHSM( 19)=0.1400000000E+03
         FILL( 19)=0.1101707300E+00
         MHSM( 20)=0.1450000000E+03
         FILL( 20)=0.9697624870E-01
         MHSM( 21)=0.1500000000E+03
         FILL( 21)=0.8562244740E-01
         MHSM( 22)=0.1550000000E+03
         FILL( 22)=0.7581830380E-01
         MHSM( 23)=0.1600000000E+03
         FILL( 23)=0.6732177790E-01
         MHSM( 24)=0.1650000000E+03
         FILL( 24)=0.5993433430E-01
         MHSM( 25)=0.1700000000E+03
         FILL( 25)=0.5349162170E-01
         MHSM( 26)=0.1750000000E+03
         FILL( 26)=0.4785403360E-01
         MHSM( 27)=0.1800000000E+03
         FILL( 27)=0.4290656600E-01
         MHSM( 28)=0.1850000000E+03
         FILL( 28)=0.3855285330E-01
         MHSM( 29)=0.1900000000E+03
         FILL( 29)=0.3471111490E-01
         MHSM( 30)=0.1950000000E+03
         FILL( 30)=0.3131339800E-01
         MHSM( 31)=0.2000000000E+03
         FILL( 31)=0.2830140150E-01
         MHSM( 32)=0.2050000000E+03
         FILL( 32)=0.2562517700E-01
         MHSM( 33)=0.2100000000E+03
         FILL( 33)=0.2324209510E-01
         MHSM( 34)=0.2150000000E+03
         FILL( 34)=0.2111572800E-01
         MHSM( 35)=0.2200000000E+03
         FILL( 35)=0.1921443810E-01
         MHSM( 36)=0.2250000000E+03
         FILL( 36)=0.1751105680E-01
         MHSM( 37)=0.2300000000E+03
         FILL( 37)=0.1598237870E-01
         MHSM( 38)=0.2350000000E+03
         FILL( 38)=0.1460759100E-01
         MHSM( 39)=0.2400000000E+03
         FILL( 39)=0.1336908310E-01
         MHSM( 40)=0.2450000000E+03
         FILL( 40)=0.1225169840E-01
         MHSM( 41)=0.2500000000E+03
         FILL( 41)=0.1124179140E-01
         MHSM( 42)=0.2550000000E+03
         FILL( 42)=0.1032775410E-01
         MHSM( 43)=0.2600000000E+03
         FILL( 43)=0.9499220590E-02
         MHSM( 44)=0.2650000000E+03
         FILL( 44)=0.8747117120E-02
         MHSM( 45)=0.2700000000E+03
         FILL( 45)=0.8063375910E-02
         MHSM( 46)=0.2750000000E+03
         FILL( 46)=0.7441069560E-02
         MHSM( 47)=0.2800000000E+03
         FILL( 47)=0.6873826630E-02
         MHSM( 48)=0.2850000000E+03
         FILL( 48)=0.6356229440E-02
         MHSM( 49)=0.2900000000E+03
         FILL( 49)=0.5883289000E-02
         MHSM( 50)=0.2950000000E+03
         FILL( 50)=0.5450663410E-02
         MHSM( 51)=0.3000000000E+03
         FILL( 51)=0.5054516610E-02
         MHSM( 52)=0.3050000000E+03
         FILL( 52)=0.4691307730E-02
         MHSM( 53)=0.3100000000E+03
         FILL( 53)=0.4357917990E-02
         MHSM( 54)=0.3150000000E+03
         FILL( 54)=0.4051587420E-02
         MHSM( 55)=0.3200000000E+03
         FILL( 55)=0.3769847240E-02
         MHSM( 56)=0.3250000000E+03
         FILL( 56)=0.3510421820E-02
         MHSM( 57)=0.3300000000E+03
         FILL( 57)=0.3271357320E-02
         MHSM( 58)=0.3350000000E+03
         FILL( 58)=0.3050851050E-02
         MHSM( 59)=0.3400000000E+03
         FILL( 59)=0.2847277640E-02
         MHSM( 60)=0.3450000000E+03
         FILL( 60)=0.2659168490E-02
         MHSM( 61)=0.3500000000E+03
         FILL( 61)=0.2485209370E-02
         MHSM( 62)=0.3550000000E+03
         FILL( 62)=0.2324195210E-02
         MHSM( 63)=0.3600000000E+03
         FILL( 63)=0.2175038730E-02
         MHSM( 64)=0.3650000000E+03
         FILL( 64)=0.2036746230E-02
         MHSM( 65)=0.3700000000E+03
         FILL( 65)=0.1908435120E-02
         MHSM( 66)=0.3750000000E+03
         FILL( 66)=0.1789307880E-02
         MHSM( 67)=0.3800000000E+03
         FILL( 67)=0.1678606670E-02
         MHSM( 68)=0.3850000000E+03
         FILL( 68)=0.1575666890E-02
         MHSM( 69)=0.3900000000E+03
         FILL( 69)=0.1479877400E-02
         MHSM( 70)=0.3950000000E+03
         FILL( 70)=0.1390679070E-02
         MHSM( 71)=0.4000000000E+03
         FILL( 71)=0.1307571320E-02
         MHSM( 72)=0.4050000000E+03
         FILL( 72)=0.1230081660E-02
         MHSM( 73)=0.4100000000E+03
         FILL( 73)=0.1157785520E-02
         MHSM( 74)=0.4150000000E+03
         FILL( 74)=0.1090288020E-02
         MHSM( 75)=0.4200000000E+03
         FILL( 75)=0.1027227070E-02
         MHSM( 76)=0.4250000000E+03
         FILL( 76)=0.9682832950E-03
         MHSM( 77)=0.4300000000E+03
         FILL( 77)=0.9131529860E-03
         MHSM( 78)=0.4350000000E+03
         FILL( 78)=0.8615582870E-03
         MHSM( 79)=0.4400000000E+03
         FILL( 79)=0.8132467960E-03
         MHSM( 80)=0.4450000000E+03
         FILL( 80)=0.7679847180E-03
         MHSM( 81)=0.4500000000E+03
         FILL( 81)=0.7255564420E-03
         MHSM( 82)=0.4550000000E+03
         FILL( 82)=0.6857633540E-03
         MHSM( 83)=0.4600000000E+03
         FILL( 83)=0.6484234190E-03
         MHSM( 84)=0.4650000000E+03
         FILL( 84)=0.6133663060E-03
         MHSM( 85)=0.4700000000E+03
         FILL( 85)=0.5804372800E-03
         MHSM( 86)=0.4750000000E+03
         FILL( 86)=0.5494944110E-03
         MHSM( 87)=0.4800000000E+03
         FILL( 87)=0.5204013510E-03
         MHSM( 88)=0.4850000000E+03
         FILL( 88)=0.4930355260E-03
         MHSM( 89)=0.4900000000E+03
         FILL( 89)=0.4672826450E-03
         MHSM( 90)=0.4950000000E+03
         FILL( 90)=0.4430361370E-03
         MHSM( 91)=0.5000000000E+03
         FILL( 91)=0.4201982020E-03
         MHSM( 92)=0.5100000000E+03
         FILL( 92)=0.3783910380E-03
         MHSM( 93)=0.5200000000E+03
         FILL( 93)=0.3412081700E-03
         MHSM( 94)=0.5300000000E+03
         FILL( 94)=0.3080828740E-03
         MHSM( 95)=0.5400000000E+03
         FILL( 95)=0.2785279570E-03
         MHSM( 96)=0.5500000000E+03
         FILL( 96)=0.2521165850E-03
         MHSM( 97)=0.5600000000E+03
         FILL( 97)=0.2284769560E-03
         MHSM( 98)=0.5700000000E+03
         FILL( 98)=0.2072880320E-03
         MHSM( 99)=0.5800000000E+03
         FILL( 99)=0.1882709120E-03
         MHSM(100)=0.5900000000E+03
         FILL(100)=0.1711813760E-03
         MHSM(101)=0.6000000000E+03
         FILL(101)=0.1558042880E-03
         MHSM(102)=0.6100000000E+03
         FILL(102)=0.1419505430E-03
         MHSM(103)=0.6200000000E+03
         FILL(103)=0.1294547070E-03
         MHSM(104)=0.6300000000E+03
         FILL(104)=0.1181711290E-03
         MHSM(105)=0.6400000000E+03
         FILL(105)=0.1079700640E-03
         MHSM(106)=0.6500000000E+03
         FILL(106)=0.9873740850E-04
         MHSM(107)=0.6600000000E+03
         FILL(107)=0.9037239590E-04
         MHSM(108)=0.6700000000E+03
         FILL(108)=0.8278601890E-04
         MHSM(109)=0.6800000000E+03
         FILL(109)=0.7589896210E-04
         MHSM(110)=0.6900000000E+03
         FILL(110)=0.6964039080E-04
         MHSM(111)=0.7000000000E+03
         FILL(111)=0.6394762200E-04
         MHSM(112)=0.7100000000E+03
         FILL(112)=0.5876485910E-04
         MHSM(113)=0.7200000000E+03
         FILL(113)=0.5404200760E-04
         MHSM(114)=0.7300000000E+03
         FILL(114)=0.4973428930E-04
         MHSM(115)=0.7400000000E+03
         FILL(115)=0.4580179550E-04
         MHSM(116)=0.7500000000E+03
         FILL(116)=0.4220898070E-04
         MHSM(117)=0.7600000000E+03
         FILL(117)=0.3892360430E-04
         MHSM(118)=0.7700000000E+03
         FILL(118)=0.3591698780E-04
         MHSM(119)=0.7800000000E+03
         FILL(119)=0.3316348900E-04
         MHSM(120)=0.7900000000E+03
         FILL(120)=0.3063974040E-04
         MHSM(121)=0.8000000000E+03
         FILL(121)=0.2832507270E-04
         MHSM(122)=0.8100000000E+03
         FILL(122)=0.2620062650E-04
         MHSM(123)=0.8200000000E+03
         FILL(123)=0.2424948880E-04
         MHSM(124)=0.8300000000E+03
         FILL(124)=0.2245607520E-04
         MHSM(125)=0.8400000000E+03
         FILL(125)=0.2080677370E-04
         MHSM(126)=0.8500000000E+03
         FILL(126)=0.1928887830E-04
         MHSM(127)=0.8600000000E+03
         FILL(127)=0.1789101450E-04
         MHSM(128)=0.8700000000E+03
         FILL(128)=0.1660291890E-04
         MHSM(129)=0.8800000000E+03
         FILL(129)=0.1541523560E-04
         MHSM(130)=0.8900000000E+03
         FILL(130)=0.1431954040E-04
         MHSM(131)=0.9000000000E+03
         FILL(131)=0.1330805340E-04
         MHSM(132)=0.9100000000E+03
         FILL(132)=0.1237378800E-04
         MHSM(133)=0.9200000000E+03
         FILL(133)=0.1151034460E-04
         MHSM(134)=0.9300000000E+03
         FILL(134)=0.1071193310E-04
         MHSM(135)=0.9400000000E+03
         FILL(135)=0.9973243230E-05
         MHSM(136)=0.9500000000E+03
         FILL(136)=0.9289461180E-05
         MHSM(137)=0.9600000000E+03
         FILL(137)=0.8656243260E-05
         MHSM(138)=0.9700000000E+03
         FILL(138)=0.8069497850E-05
         MHSM(139)=0.9800000000E+03
         FILL(139)=0.7525522880E-05
         MHSM(140)=0.9900000000E+03
         FILL(140)=0.7020979480E-05
         MHSM(141)=0.1000000000E+04
         FILL(141)=0.6552780630E-05
      ENDIF
*
      IF(IPROD.EQ.4) THEN
       NITEM=111
         MHSM(  1)=0.5000000000E+02
         FILL(  1)=0.2725125613E+01
         MHSM(  2)=0.5500000000E+02
         FILL(  2)=0.2530806976E+01
         MHSM(  3)=0.6000000000E+02
         FILL(  3)=0.2420138195E+01
         MHSM(  4)=0.6500000000E+02
         FILL(  4)=0.2252833689E+01
         MHSM(  5)=0.7000000000E+02
         FILL(  5)=0.2138917862E+01
         MHSM(  6)=0.7500000000E+02
         FILL(  6)=0.1999448978E+01
         MHSM(  7)=0.8000000000E+02
         FILL(  7)=0.1914763476E+01
         MHSM(  8)=0.8500000000E+02
         FILL(  8)=0.1775816158E+01
         MHSM(  9)=0.9000000000E+02
         FILL(  9)=0.1701463649E+01
         MHSM( 10)=0.9500000000E+02
         FILL( 10)=0.1627837139E+01
         MHSM( 11)=0.1000000000E+03
         FILL( 11)=0.1529030539E+01
         MHSM( 12)=0.1050000000E+03
         FILL( 12)=0.1474445757E+01
         MHSM( 13)=0.1100000000E+03
         FILL( 13)=0.1403191742E+01
         MHSM( 14)=0.1150000000E+03
         FILL( 14)=0.1330399671E+01
         MHSM( 15)=0.1200000000E+03
         FILL( 15)=0.1273169478E+01
         MHSM( 16)=0.1250000000E+03
         FILL( 16)=0.1212298966E+01
         MHSM( 17)=0.1300000000E+03
         FILL( 17)=0.1162862914E+01
         MHSM( 18)=0.1350000000E+03
         FILL( 18)=0.1107359215E+01
         MHSM( 19)=0.1400000000E+03
         FILL( 19)=0.1042762542E+01
         MHSM( 20)=0.1450000000E+03
         FILL( 20)=0.1002597686E+01
         MHSM( 21)=0.1500000000E+03
         FILL( 21)=0.9589258982E+00
         MHSM( 22)=0.1550000000E+03
         FILL( 22)=0.9159706242E+00
         MHSM( 23)=0.1600000000E+03
         FILL( 23)=0.8764361169E+00
         MHSM( 24)=0.1650000000E+03
         FILL( 24)=0.8483683315E+00
         MHSM( 25)=0.1700000000E+03
         FILL( 25)=0.8158639610E+00
         MHSM( 26)=0.1750000000E+03
         FILL( 26)=0.7752631440E+00
         MHSM( 27)=0.1800000000E+03
         FILL( 27)=0.7473570323E+00
         MHSM( 28)=0.1850000000E+03
         FILL( 28)=0.7230383035E+00
         MHSM( 29)=0.1900000000E+03
         FILL( 29)=0.6947275495E+00
         MHSM( 30)=0.1950000000E+03
         FILL( 30)=0.6659727042E+00
         MHSM( 31)=0.2000000000E+03
         FILL( 31)=0.6442046593E+00
         MHSM( 32)=0.2100000000E+03
         FILL( 32)=0.5864112607E+00
         MHSM( 33)=0.2200000000E+03
         FILL( 33)=0.5412832103E+00
         MHSM( 34)=0.2300000000E+03
         FILL( 34)=0.5015911334E+00
         MHSM( 35)=0.2400000000E+03
         FILL( 35)=0.4624205028E+00
         MHSM( 36)=0.2500000000E+03
         FILL( 36)=0.4302795497E+00
         MHSM( 37)=0.2600000000E+03
         FILL( 37)=0.3995257396E+00
         MHSM( 38)=0.2700000000E+03
         FILL( 38)=0.3715115602E+00
         MHSM( 39)=0.2800000000E+03
         FILL( 39)=0.3455909669E+00
         MHSM( 40)=0.2900000000E+03
         FILL( 40)=0.3213517835E+00
         MHSM( 41)=0.3000000000E+03
         FILL( 41)=0.3015434915E+00
         MHSM( 42)=0.3100000000E+03
         FILL( 42)=0.2823550720E+00
         MHSM( 43)=0.3200000000E+03
         FILL( 43)=0.2619972020E+00
         MHSM( 44)=0.3300000000E+03
         FILL( 44)=0.2438821729E+00
         MHSM( 45)=0.3400000000E+03
         FILL( 45)=0.2270139498E+00
         MHSM( 46)=0.3500000000E+03
         FILL( 46)=0.2108739789E+00
         MHSM( 47)=0.3600000000E+03
         FILL( 47)=0.2017831593E+00
         MHSM( 48)=0.3700000000E+03
         FILL( 48)=0.1894757510E+00
         MHSM( 49)=0.3800000000E+03
         FILL( 49)=0.1794519445E+00
         MHSM( 50)=0.3900000000E+03
         FILL( 50)=0.1689441088E+00
         MHSM( 51)=0.4000000000E+03
         FILL( 51)=0.1606682448E+00
         MHSM( 52)=0.4100000000E+03
         FILL( 52)=0.1520667362E+00
         MHSM( 53)=0.4200000000E+03
         FILL( 53)=0.1438205623E+00
         MHSM( 54)=0.4300000000E+03
         FILL( 54)=0.1367820645E+00
         MHSM( 55)=0.4400000000E+03
         FILL( 55)=0.1289205868E+00
         MHSM( 56)=0.4500000000E+03
         FILL( 56)=0.1223434336E+00
         MHSM( 57)=0.4600000000E+03
         FILL( 57)=0.1161476819E+00
         MHSM( 58)=0.4700000000E+03
         FILL( 58)=0.1094457029E+00
         MHSM( 59)=0.4800000000E+03
         FILL( 59)=0.1044640591E+00
         MHSM( 60)=0.4900000000E+03
         FILL( 60)=0.9907129033E-01
         MHSM( 61)=0.5000000000E+03
         FILL( 61)=0.9399693097E-01
         MHSM( 62)=0.5100000000E+03
         FILL( 62)=0.8904225971E-01
         MHSM( 63)=0.5200000000E+03
         FILL( 63)=0.8471712615E-01
         MHSM( 64)=0.5300000000E+03
         FILL( 64)=0.8015911239E-01
         MHSM( 65)=0.5400000000E+03
         FILL( 65)=0.7646497543E-01
         MHSM( 66)=0.5500000000E+03
         FILL( 66)=0.7264716999E-01
         MHSM( 67)=0.5600000000E+03
         FILL( 67)=0.6916585847E-01
         MHSM( 68)=0.5700000000E+03
         FILL( 68)=0.6574618015E-01
         MHSM( 69)=0.5800000000E+03
         FILL( 69)=0.6263532549E-01
         MHSM( 70)=0.5900000000E+03
         FILL( 70)=0.5974860496E-01
         MHSM( 71)=0.6000000000E+03
         FILL( 71)=0.5696733528E-01
         MHSM( 72)=0.6100000000E+03
         FILL( 72)=0.5418514826E-01
         MHSM( 73)=0.6200000000E+03
         FILL( 73)=0.5144750661E-01
         MHSM( 74)=0.6300000000E+03
         FILL( 74)=0.4896222595E-01
         MHSM( 75)=0.6400000000E+03
         FILL( 75)=0.4673783566E-01
         MHSM( 76)=0.6500000000E+03
         FILL( 76)=0.4455914527E-01
         MHSM( 77)=0.6600000000E+03
         FILL( 77)=0.4268600691E-01
         MHSM( 78)=0.6700000000E+03
         FILL( 78)=0.4066780866E-01
         MHSM( 79)=0.6800000000E+03
         FILL( 79)=0.3880187754E-01
         MHSM( 80)=0.6900000000E+03
         FILL( 80)=0.3704787385E-01
         MHSM( 81)=0.7000000000E+03
         FILL( 81)=0.3542992934E-01
         MHSM( 82)=0.7100000000E+03
         FILL( 82)=0.3395946100E-01
         MHSM( 83)=0.7200000000E+03
         FILL( 83)=0.3239608189E-01
         MHSM( 84)=0.7300000000E+03
         FILL( 84)=0.3115196359E-01
         MHSM( 85)=0.7400000000E+03
         FILL( 85)=0.2965639025E-01
         MHSM( 86)=0.7500000000E+03
         FILL( 86)=0.2851980197E-01
         MHSM( 87)=0.7600000000E+03
         FILL( 87)=0.2735988528E-01
         MHSM( 88)=0.7700000000E+03
         FILL( 88)=0.2621889064E-01
         MHSM( 89)=0.7800000000E+03
         FILL( 89)=0.2516371450E-01
         MHSM( 90)=0.7900000000E+03
         FILL( 90)=0.2397643800E-01
         MHSM( 91)=0.8000000000E+03
         FILL( 91)=0.2300097207E-01
         MHSM( 92)=0.8100000000E+03
         FILL( 92)=0.2213432358E-01
         MHSM( 93)=0.8200000000E+03
         FILL( 93)=0.2117979844E-01
         MHSM( 94)=0.8300000000E+03
         FILL( 94)=0.2022155770E-01
         MHSM( 95)=0.8400000000E+03
         FILL( 95)=0.1942701868E-01
         MHSM( 96)=0.8500000000E+03
         FILL( 96)=0.1886711329E-01
         MHSM( 97)=0.8600000000E+03
         FILL( 97)=0.1807576002E-01
         MHSM( 98)=0.8700000000E+03
         FILL( 98)=0.1727476039E-01
         MHSM( 99)=0.8800000000E+03
         FILL( 99)=0.1659168768E-01
         MHSM(100)=0.8900000000E+03
         FILL(100)=0.1599362482E-01
         MHSM(101)=0.9000000000E+03
         FILL(101)=0.1538610773E-01
         MHSM(102)=0.9100000000E+03
         FILL(102)=0.1476767206E-01
         MHSM(103)=0.9200000000E+03
         FILL(103)=0.1417033006E-01
         MHSM(104)=0.9300000000E+03
         FILL(104)=0.1361286458E-01
         MHSM(105)=0.9400000000E+03
         FILL(105)=0.1311225401E-01
         MHSM(106)=0.9500000000E+03
         FILL(106)=0.1275358226E-01
         MHSM(107)=0.9600000000E+03
         FILL(107)=0.1211617707E-01
         MHSM(108)=0.9700000000E+03
         FILL(108)=0.1167802570E-01
         MHSM(109)=0.9800000000E+03
         FILL(109)=0.1125294760E-01
         MHSM(110)=0.9900000000E+03
         FILL(110)=0.1096868645E-01
         MHSM(111)=0.1000000000E+04
         FILL(111)=0.1055962722E-01
      ENDIF
*
      RETURN
      END

      SUBROUTINE LHC7_HTAUTAU46(MA,CXBR_IN,CXBR_EXT,ILHC)
*******************************************************************************
*
*Table 4 of CMS PAS HIG-11-029 based on 4.6/fb or Fig.3
*
********************************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
*
      PARAMETER(NDIM=14)
      REAL*8 MA_LHC(NDIM),CXBR_LHC(NDIM)
*
      IF(MA.LT.90.D0) THEN
       ILHC=1
       RETURN
      ENDIF
      IF(MA.GT.500.D0) THEN
       ILHC=1
       RETURN
      ENDIF
*
      MA_LHC( 1)= 90.D0
      MA_LHC( 2)=100.D0
      MA_LHC( 3)=120.D0
      MA_LHC( 4)=130.D0
      MA_LHC( 5)=140.D0
      MA_LHC( 6)=160.D0
      MA_LHC( 7)=180.D0
      MA_LHC( 8)=200.D0
      MA_LHC( 9)=250.D0
      MA_LHC(10)=300.D0
      MA_LHC(11)=350.D0
      MA_LHC(12)=400.D0
      MA_LHC(13)=450.D0
      MA_LHC(14)=500.D0
*
      CXBR_LHC( 1)=22.50D0
      CXBR_LHC( 2)=15.10D0
      CXBR_LHC( 3)= 6.60D0
      CXBR_LHC( 4)= 4.58D0
      CXBR_LHC( 5)= 2.85D0
      CXBR_LHC( 6)= 1.18D0
      CXBR_LHC( 7)= 0.63D0
      CXBR_LHC( 8)= 0.43D0
      CXBR_LHC( 9)= 0.42D0
      CXBR_LHC(10)= 0.41D0
      CXBR_LHC(11)= 0.38D0
      CXBR_LHC(12)= 0.34D0
      CXBR_LHC(13)= 0.28D0
      CXBR_LHC(14)= 0.21D0
*
      IF(MA.EQ.500.D0) THEN
       NMA=13
       GOTO 97
      ENDIF
*
       DO IMA=1,NDIM
        IF(MA_LHC(IMA).GT.MA) THEN
         NMA=IMA-1
         GOTO 97
        ENDIF
       ENDDO
*
 97    CONTINUE
*        print*,ma,nma,ma_lhc(nma),ma_lhc(nma+1)
*     .        ,cxbr_lhc(nma),cxbr_lhc(nma+1)
*
       CXBR_EXT= CXBR_LHC(NMA)
     .         +(CXBR_LHC(NMA+1)-CXBR_LHC(NMA))
     .         *(MA-MA_LHC(NMA))/(MA_LHC(NMA+1)-MA_LHC(NMA))
*       print*,ma,cxbr_ext
*
      IF(CXBR_IN.GE.CXBR_EXT) THEN
       ILHC=0
      ELSE
       ILHC=1
      ENDIF
*
      RETURN
      END
