C=========   NMSSM scenario  ==========
C  One can define SUGRA or EWSB 
C  Default main.F reads SLHA file.
C=====================================

C#define SUGRA
#define EWSB

C====== Modules =================
C   Keys to switch on
C   various modules of micrOMEGAs
C================================
   
#define MASSES_INFO
C    Display information about SUSY and Higgs masses
#define CONSTRAINTS
C     Display  deltarho, B_>sgamma, Bs->mumu, gmuon and
C     check LEP mass limits 


C#define HIGGSBOUNDS 
#define LILITH
C#define SMODELS 


#define OMEGA
C    Calculate relic density and display contribution of
C                            individual channels 
#define INDIRECT_DETECTION
C     Compute spectra of gamma/positron/neutrinos
C     for DM annihilation; calculate <sigma*v> and
C     integrate gamma signal over DM galactic squared
C     density for given line of sight.

C!#define RESET_FORMFACTORS
C     Modify default nucleus form factors, 
C     DM velocity distribution,
C     A-dependence of Fermi-dencity.
#define CDM_NUCLEON 
C     Calculate amplitudes and cross-sections for
C     CDM-mucleon collisions 
C#define CDM_NUCLEUS
C     Calculate number of events for 1kg*day
C     and recoil energy distibution for various nuclei

#define NEUTRINO   neutrino telescope

C#define DECAYS
C     Calculates particle widths and branchings


#define CROSS_SECTIONS
C     Calculate cross sections and widths for
C      reactions specified by the user
 
C================ end of Modules  ======

C===== Options ========

C#define SHOWPLOTS
C     Display  graphical plots on the screen

#define CLEAN    to clean intermidiate files

C===== End of DEFINE  settings ===== 


      IMPLICIT NONE
C! external functions 
#include "../include/micromegas.fh"
#include "lib/pmodel.fh"

C! local  Parameters   
      INTEGER fast/1/
      REAL*8  Beps/1.E-4/,cut/0.01/
      REAL*8  m0,mhf,a0,tb,sgn,mXiF/0/,mXiS/0/,muP/0/,msP/0/,m3h/0/
      REAL*8  m32
      

C Variables      
      INTEGER err
      REAL*8 Omega,OmegaAppr,Xf,val
      REAL*8  gMG1,gMG2,gMG3,gAl,gAt,gAb,gMHu,gMHd,
     > gMl2,gMl3,gMr2,gMr3,gMq2,gMq3,gMu2,gMu3,gMd2,gMd3,
     >Lambda,aKappa,aLambda
      INTEGER  narg,nw 
      character *100 argv, buff
      character*10 cdmName
      integer spin2,charge3,cdim,PDGcdm
      real*8 Pcm,cosmin, cosmax,rw,width
      integer*8 cc,txtL
      integer ntot,l, nin,nout
      character*6 name(4)
      real*8 mass(4)
      real*8 Etest,cs,Qren,Qfact,pTmin
      integer outP
      real*8 Emin,NGtot,Xtot,sigmaV,v/0.001/,tab(NZ),fi,dfi
      character*100 mess

C  for CONSTRAINTS    
      real*8 constr0,constrM, constrP,csLim
C for HIGGSBOUNDS/HIGGSSIGNALS
      integer  NH0/5/, NHch/1/
      real*8 HB_result,HB_obsratio,HS_observ,HS_chi2, HS_pval
      character*70 HB_chan
      character*7 HB_version, HS_version
C for SMODELS 
      integer result 
      real*8 Rvalue
      character*30 analysis,topology,smodels_version
C for LILITH 
      real*8 m2logL, m2logL_reference,pvalue
      integer exp_ndf,n_par,ndf,vPython1, vPython2
      character*100 call_lilith
      character*10 lilith_version

C  for INDIRECT 
      real*8 N_tot, SpA(NZ),SpE(NZ), SpP(NZ) 
      real*8 FluxA(NZ),FluxE(NZ), FluxP(NZ)
C  for LoopGAMMA
      real*8 vcs_zg, vcs_gg

C for CDM_NUCLEON
      real*8  pA0(2),pA5(2),nA0(2),nA5(2),Nmass,SCcoeff,
     >ffS0P(3),ffS0N(3),ffbuff(3)

C  for CDM_NUCLEUS
      real*8  dNdE(200),rho,nEvents
C  for NEUTRINO 
      integer forSun
      real*8  rhoDet
      real*8 FluxN(NZ),FluxNb(NZ),FluxMu(NZ) 

C   for CROSS_SECTION
       character*10 next
       character*10 next_
       real*8 nextM 


C   to save the SLHA  input/output file  uncomment  
c       call delFiles(0)

#ifdef SUGRA
      write(*,*)
      write(*,*) '========= mSUGRA NMSSM scenario ========'
      narg = iargc()
      if(narg.lt.6) then
        write(*,*) ' One has to launch this program with parameters.'
        write(*,*) ' Six  of them are obligatory:'
        write(*,*) '    m0      common scalar mass at GUT scale'
        write(*,*) '    mhf     common gaugino mass at GUT scale'
        write(*,*) '    a0      trilinear soft breaking at GUT scale'
        write(*,*) '    tb      tan(beta)'
        write(*,*) '   Lambda   Lambda parameter'
        write(*,*) '   aKappa   aKappa parameter'
        write(*,*) ' Auxiliary parameters are'
        write(*,*) '    sgn  1(default)/-1, sign of Higgsino mass term'
        write(*,*) '    Mtp     top quark pole mass'
        write(*,*) '    MbMb    Mb(Mb) scale independent b-quark mass'
        write(*,*) '    alfSMZ  strong coupling at MZ'
        write(*,*) ' ================================================'
        write(*,*) 'Example: ./main 320 600 -1300 2 0.5 -1400'
        STOP
      else
        call getarg(1, argv)
        read(argv,*,ERR=100) m0
        call getarg(2, argv)
        read(argv,*,ERR=100) mhf
        call getarg(3, argv)
        read(argv,*,ERR=100) a0
        call getarg(4, argv)
        read(argv,*,ERR=100) tb
        call getarg(5, argv)
        read(argv,*,ERR=100) Lambda
        call getarg(6, argv)
        read(argv,*,ERR=100) aKappa

        if(narg.ge.7) then
          call getarg(7, argv)
          read(argv,*,ERR=100) sgn
        else 
          sgn=1
        endif 
        if(narg.ge.8) then
          call getarg(8, argv)
          read(argv,*,ERR=100) aLambda
        else 
          aLambda=a0 
        endif 

        if(narg.ge.9) then
          call getarg(9, argv)
          read(argv,*,ERR=100) val
          call assignValW('Mtp',val)
        endif 
        if(narg.ge.10) then
          call getarg(10, argv)
          read(argv,*,ERR=100) val
          call assignValW('MbMb',val)
        endif 
        if(narg.ge.11) then
          call getarg(11, argv)
          read(argv,*,ERR=100) val
          call assignValW('alfSMZ',val)
        endif 
      endif
  
      err=nmssmSUGRA(m0,mhf,a0,tb,sgn,Lambda,aLambda,aKappa,mXiF,mXiS,muP,msP,m3h)
      if(err.ne.0) goto 100

#elif defined(EWSB)

      write(*,*)
      write(*,*) '========= EWSB scale input NMSSM========='
      if(iargc().eq.0) then
         write(*,*)'Correct usage: ./main  <file with NMSSM parameters>'
         write(*,*)'Example: ./main  data1.par' 
         stop
      endif

      call getarg(1,argv)                               

      err=readVar(argv)

      if(err.eq.-1) then
          write(*,*) 'Can not open the file'
          stop
      endif

      if(err.gt.0) then
          write(*,*)'Wrong file contents at line ',err
          stop
      endif

      err=nmssmEWSB()
      if(err.lt.0) goto 100
#else
      write(*,*)
      write(*,*) '========= SLHA file input ========='
      narg=iargc()
      if(narg.eq.0) then 
        write(*,*) 
     >  'The program needs one argument:the name of SLHA input file.'
        write(*,*)  'Example: ./main spectr.dat'
        stop
      endif   
      call getarg(1,argv)
      write(*,*) 'Initial file  ', argv

C  mode= 1*m1+2*m2+4*m4+8*m8+16*m16
C  
C  m1  0 overwrite all;  1 keep old data  
C  m2  0 ignore mistake  1: stop in case of mistake in input file.    
C  m4  0 read DECAY      1: don't read   Decay       
C  m8  0 read BLOCK      1: don't read   Blocks        
C  m16 0 read QNUMBERS   1: don't read   QNUMBERS           
C
C     err=readSLHA(argv,mode)

      err=readSLHA(argv,0 )
      write(*,*) 'err=', err
      if(err.ne.0) stop

#endif

      goto 101
100   STOP '!Wrong input' 
101   continue
C  To print list od variables uncomment   
C      CALL printVar(6)

C    to save results in SLHA format  use 
C     Call writeLesH('slha.out') 


      err=sortOddParticles(cdmName)
      if(err.ne.0) then
        write(*,*) 'Can t calculate ', cdmName
        STOP
      endif 

      PDGcdm=qNumbers(cdmName,spin2, charge3,  cdim)
      write(*,fmt="('Dark matter candidate is ', A5,'with spin=',
     >I1,'/2 mass=',1PE10.2)") cdmName, spin2,Mcdm

      if(charge3.ne.0) then 
         write(*,fmt="('DM has electric charge',I1,'/3')") charge3
         STOP
      endif

      if(cdim.ne.1) then 
         write(*,*) 'DM has color charge'
         STOP
      endif

#ifdef MASSES_INFO  
      write(*,*) '=== MASSES OF HIGGS AND SUSY PARTICLES: ===' 
      CALL printHiggs(6)
      CALL printMasses(6,1)
#endif

#ifdef CONSTRAINTS
      write(*,*)

      IF(err.ne.0) THEN
         WRITE(*,*)' No RGE solution'
         WRITE(*,*)' Error message form NMHTools'
         nw=NMHwarn(6)
         STOP
      ELSE 
        write(*,*) 'Warnings from NMSSMTools:'
        nw=NMHwarn(6)
        if(nw.eq.0) write(*,*) '  .......  none'
      ENDIF
      write(*,*)
      write(*,*) '==== Physical Constraints: ====='

      constr0=bsgnlo(constrM,constrP)
      write(*,fmt="('B->s,gamma = ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP 

      constr0= bsmumu(constrM,constrP)
      write(*,fmt="('Bs->mu,mu  = ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP  
  
      constr0=btaunu(constrM,constrP)
      write(*,fmt="('B+->tau+,nu= ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP 

  
      constr0=deltamd(constrM,constrP)
      write(*,fmt="('deltaMd    = ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP 

      constr0=deltams(constrM,constrP)
      write(*,fmt="('deltaMs    = ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP 

      constr0=gmuon(constrM,constrP)
      write(*,fmt="('gmuon/BSM  = ',1PE9.2,'(',E9.2,',',E9.2,')')") 
     >constr0,constrM, constrP 

      if(Zinvisible().ne.0) write(*,*) "Excluded by Z->invisible"
      if(LspNlsp_LEP(csLim).ne.0) write(*,fmt='("Excluded by LEP  by e+,e- -> DM q qbar, Cross section=",E10.2,"pb")') csLim 
#endif


#ifdef HIGGSBOUNDS
      call system("cat spectr decay > HB.in");
      call system('echo BLOCK DMASS  >> HB.in')
      call system('echo "  25  2"  >> HB.in')
      call system('echo "  35  2"  >> HB.in')
      call system('echo "  45  2"  >> HB.in')
      call system('echo "  36  2"  >> HB.in')
      call system('echo "  46  2"  >> HB.in')
#include "../include/hBandS.inc_f"
      write(*,fmt='("HB(",A, ")result=",1PE10.1,3x,"obsratio=", E10.1," channel=", A )') HB_version, HB_result,HB_obsratio,HB_chan
      write(*,fmt='("HS(",A, "): Nobservables=",F5.0," chi^2 =", 1PE10.2," pval= ", E10.2)') HS_version,HS_observ,HS_chi2, HS_pval
#endif


#ifdef LILITH
      if(LiLithF("Lilith_in.xml").ne.0) then 
         m2logL_reference=0
         n_par=0
#include "../include/Lilith.inc_f"
         if(ndf.ne.0) write(*,fmt='("LILITH(DB",A,"):  -2*log(L): ",F5.2,"; -2*log(L_reference): ",F5.2,"; ndf: ",I3"; p-value: ",F5.2)') lilith_version, m2logL,m2logL_reference,ndf,pvalue
      else 
         write(*,*) "LILITH: there is no Higgs candidate"
      endif     
#endif


#ifdef SMODELS
      write(*,*) "SMODELS:"
#include "../include/SMODELS.inc_f"
      if(result.ge.0) write(*,fmt='("highest R=",1PE10.2," from ",A," topology ",A)') Rvalue,analysis,topology
      if(result.eq.-1) write(*,*) 'no channels for testing.'
      if(result.eq.0)  write(*,*) 'not excluded.' 
      if(result.eq.1)  write(*,*) 'excluded.'
#endif



#ifdef OMEGA
      write(*,*)
      write(*,*) '==== Calculation of relic density ====='
      write(*,*) 'Dark Matter candidate is ', cdmName                                   
      if(cdmName.ne.'~o1') then
          write(*,*) '~o1 is not LSP'
      else
          call o1Contents(6)
      endif                                                                          
      
      Omega=darkOmega(Xf,fast,Beps)
      write(*,'(a,3x,1PE10.2)') 'Omega=',Omega

      if(Omega.gt.0)OmegaAppr=printChannels(Xf,cut,Beps,1,6)
#endif


#ifdef  INDIRECT_DETECTION
      write(*,*) 
      write(*,*) '=============== Indirect detection ==========='

C** Emin - energy cut in GeV
      Emin=1     
      Etest=Mcdm/2
C** fi angle of sight [rad], dfi - half of cone angle    
      fi=0.1
      dfi=0.05
      sigmaV=calcSpectrum(1+2+4,SpA,SpE,SpP,NULL,NULL,NULL,err)    
C  Returns  sigma*v in cm^3/sec.
C  SpX - calculated spectra of annihilation.
C  Use SpectdNdE(E, SpX) to calculate energy distribution in 1/GeV units.
      write(*,*)
      write(*,fmt="('sigma*v=',1PE8.2,'[cm^3/s]')") sigmaV

      write(*,*) 'Photons'
      call gammaFluxTab(fi,dfi, sigmaV, SpA,  FluxA)
      write(*,fmt="('Phonton flux  for angle of sight ',
     < F4.2,'[rad]')") fi
      write(*,fmt="('and spherical region described by cone with angle '
     >,F4.2,'[rad]' )") 2*dfi
#ifdef SHOWPLOTS      
      write(mess,fmt="('gamma flux[cm^2 s GeV]^{-1} at fi=',F4.2,
     > ' from cone with angle=',F4.2,'[rad]')")fi,dfi*2  
      err= displaySpectrum(mess,Emin,Mcdm,FluxA)
#endif
      write(*,fmt="('Photon flux =',1PE8.2,
     >'[cm^2 s GeV]^{-1} for E=',0PF5.1,'[GeV]')")
     > SpectdNdE(Etest, FluxA), Etest
 
      write(*,*) 'Positrons'
      call  posiFluxTab(Emin, sigmaV, SpE, FluxE)

#ifdef SHOWPLOTS      
      err=displaySpectrum('positron flux [cm^2 s sr GeV]^{-1}',
     >Emin,Mcdm,FluxE)
#endif
      write(*,fmt="('Positron flux  = ',1PE8.2,
     >'[cm^2 sr s GeV]^{-1} for E=',0PF6.1,'[GeV]')")
     > SpectdNdE(Etest, FluxE),  Etest     

      write(*,*) 'antiProtons'
      call  pbarFluxTab(Emin, sigmaV, SpP,  FluxP)

#ifdef SHOWPLOTS      
      err=displaySpectrum('a-proton flux [cm^2 s sr GeV]^{-1}',
     >Emin,Mcdm,FluxP)
#endif

      write(*,fmt="('Anti proton flux  = ',1PE8.2,
     >'[cm^2 sr s GeV]^{-1} for E=',0PF6.1,'[GeV]')")
     > SpectdNdE(Etest, FluxP),  Etest     

#endif


#ifdef RESET_FORMFACTORS

C   The user has approach to form factors  which specifies quark contents 
C   of  proton and nucleon via global parametes like
C      <Type>FF<Nucleon><q>
C   where <Type> can be "Scalar", "pVector", and "Sigma"; 
C         <Nucleon>     "P" or "N" for proton and neutron
C         <q>            "d", "u","s"
C
C   calcScalarQuarkFF( Mu/Md, Ms/Md, sigmaPiN[MeV], sigma0[MeV])  
C   calculates and rewrites Scalar form factors

      write(*,*) 'protonFF (default)  d, u, s ', 
     >       ScalarFFPd, ScalarFFPu,ScalarFFPs
      write(*,*) 'neutronFF(default)  d, u, s ', 
     >       ScalarFFNd, ScalarFFNu,ScalarFFNs                          
      write(*,*) '===========Redefinition of form factors========='  
      call calcScalarQuarkFF(0.553d0,18.9d0,45.5d0,26.d0)
      write(*,*) 'protonFF (new)      d, u, s ', 
     >ScalarFFPd, ScalarFFPu,ScalarFFPs                           
      write(*,*) 'neutronFF(new)      d, u, s ', ScalarFFNd, 
     >ScalarFFNu,ScalarFFNs                    

C  Option to change parameters of DM velocity  distribution 

      call SetfMaxwell(220.d0,600.d0)
C    dN  ~  exp(-v^2/arg1^2)*Theta(v-arg2)  d^3v     
C    Earth velocity with respect to Galaxy defined by 'Vearth' parameter.
C    All parameters are  in [km/s] units.       
#endif


#ifdef  CDM_NUCLEON
      write(*,*)
      write(*,*) '==== Calculation of CDM-nucleons amplitudes  ====='   


      err=nucleonAmplitudes(CDM1, pA0,pA5,nA0,nA5)
      write(*,*)'CDM-nucleon amplitudes:'
      write(*,fmt="(' proton:  SI=',1PE9.2,' SD=',E9.2)")pA0(1),pA5(1)
      write(*,fmt="(' neutron: SI=',1PE9.2,' SD=',E9.2)")nA0(1),nA5(1) 

C  nucleon mass
      Nmass=0.939d0

      SCcoeff=4/M_PI*3.8937966E8
     >*(Nmass*Mcdm/(Nmass+ Mcdm))**2
      write(*,*) 'CDM-nucleon cross sections[pb]:'

      write(*,fmt="(' proton  SI=',1PE9.2,' SD=',E9.2)")
     >                           SCcoeff*pA0(1)**2,3*SCcoeff*pA5(1)**2
      write(*,fmt="(' neutron SI=',1PE9.2,' SD=',E9.2)")
     >                           SCcoeff*nA0(1)**2,3*SCcoeff*nA5(1)**2
#endif


#ifdef CDM_NUCLEUS
      write(*,*)
      write(*,*)'=========  Direct Detection ==========='

      write(*,*) 'Ge:'

      nEvents=nucleusRecoil(Maxwell,73,Z_Ge,J_Ge73,
     >S00Ge73,S01Ge73,S11Ge73,dNdE)
C  See '../include/micromegas.h' for description of arguments
C  Instead of Maxwell  one can use 'fDvDelta' Delta-function
C  velocity distribution.
      write(*,fmt="('Total number of events=',1PE9.2,' /day/kg')") 
     >nEvents

      write(*,fmt=
     >"(' Number of events in 10 - 50 KeV region=',1PE9.2,' /day/kg')") 
     >cutRecoilResult(dNdE,10.d0,50.d0) 


#ifdef SHOWPLOTS
       err=displayRecoilPlot(dNdE,
     >           'Distribution of recoil energy of 73Ge',0.d0,199.d0)
#endif
       write(*,*)
       write(*,*) '131Xe:'  
       nEvents=nucleusRecoil(Maxwell,131,Z_Xe,J_Xe131,
     > S00Xe131,S01Xe131,S11Xe131,dNdE)

      write(*,fmt=
     >"('Total number of events=',1PE9.2,' /day/kg')")nEvents
      write(*,fmt="(' Number of events in 10 - 50 KeV region=',
     >   1PE9.2, ' /day/kg')")cutRecoilResult(dNdE,1.d1,5.d1)


#ifdef SHOWPLOTS
      err=displayRecoilPlot(dNdE,
     >    'Distribution of recoil energy of 131Xe',0.d0,199.d0)
#endif

#endif

#ifdef NEUTRINO 
      forSun=1
      Emin=1
C rhoDet - detector density
      rhoDet=1     
      write(*,*)  
      write(*,fmt='("===============Neutrino Telescope=======  for  ",$)') 

      if(forSun.ne.0) then 
         write(*,*) "Sun"
      else 
         write(*,*) "Earth"  
      endif 

      err=neutrinoFlux(Maxwell,forSun, FluxN,FluxNb)
#ifdef SHOWPLOTS
      err=displaySpectrum("nu flux from Sun [1/Year/km^2/GeV]",Emin,Mcdm,FluxN)
      err=displaySpectrum("nu-bar from Sun  [1/Year/km^2/GeV]",Emin,Mcdm,FluxNb)
#endif
      write(*,fmt='("E>", 1PE8.2," GeV neutrino flux =", E8.2," [1/Year/km^2]")') Emin,spectrInfo(Emin,FluxN,NULL)
      write(*,fmt='("E>", 1PE8.2," GeV anti-neutrino flux =", E8.2," [1/Year/km^2]")') Emin, spectrInfo(Emin,FluxNb,NULL) 

C!  ICE CUBE
      if(forSun.eq.1) then 
         write(*,fmt='("IceCube22 exclusion confidence level = ",1PE8.2,"%")') 100*exLevIC22(FluxN,FluxNb,NULL)
      endif
  
C ======  Upward events
  
      call muonUpward(FluxN,FluxNb,FluxMu)
#ifdef SHOWPLOTS  
      err= displaySpectrum("Upward muons[1/Year/km^2/GeV]",Emin,Mcdm/2,FluxMu)
#endif

      write(*,fmt='("E>", 1PE8.2," GeV Upward muon flux =", E8.2," [1/Year/km^2]")') Emin,spectrInfo(Emin,FluxMu,NULL)
  
C ======  Contained events 
      call muonContained(FluxN,FluxNb,rhoDet, FluxMu)
#ifdef SHOWPLOTS  
      err=displaySpectrum("Contained  muons[1/Year/km^3/GeV]",Emin,Mcdm,FluxMu)
#endif
      write(*,fmt='("E>", 1PE8.2," Contained muon flux =", E8.2," [1/Year/km^3]")') Emin,spectrInfo(Emin,FluxMu,NULL)
#endif

#ifdef DECAYS

      write(*,*)
      write(*,*)'======Calculations of widths======='

      write(*,*) 
      pname = 'h'
      width=pWidth(pname,txtL)
      write(*,fmt="(A8, ':  total width ',1PE8.2,'[GeV]')") pname, width
      write(*,*)'and Branchings:'
      call printTxtList(txtL,6)

      write(*,*) 
      pname = '~o2'
      width=pWidth(pname,txtL)
      write(*,fmt="(A8,':  total width ',1PE8.2,'[GeV]')")pname, width
      write(*,*)'and Branchings:'
      call printTxtList(txtL,6)

#endif



#ifdef DECAYS

      write(*,*)
      write(*,*)'======Calculations of widths======='

C      pname = "h";
      width=pWidth('h1',txtL)
      write(*,fmt="('h1->',I1,'*x :  total width ',1PE8.2,'[GeV]')")
     >dim,width
      write(*,*)'and Branchings:'
      call printTxtList(txtL,6)

      width=pWidth('l',txtL)
      write(*,fmt="('l->',I1,'*x :  total width ',1PE8.2,'[GeV]')")
     >dim,width
      write(*,*)'and Branchings:'
      call printTxtList(txtL,6)

      write(*,fmt="('Br(e,Ne,nl)=',F4.2)") findBr(txtL,"e,Ne,nl")

C   pname = "~o2";
      width=pWidth('~o2',txtL)
      write(*,fmt="('~o2->',I1,'*x :  total width ',1PE8.2,'[GeV]')")
     >dim,width
      write(*,*)'and Branchings:'
      call printTxtList(txtL,6)

#endif


#ifdef CROSS_SECTIONS
      write(*,*)
      call nextOdd(next,1, nextM)
      if((next(1:1).ne.' ') .and. (nextM.lt.1000)) then 
         call antiparticle(next_,next)
         write(*,*)'======Calculations of cross sections======='
         write(*,*) ' Process p,p -> ', next,next_
         Pcm=6500 
         Qren=nextM
         Qfact=Qren
         pTmin=0
         cs=hCollider(Pcm,1,3,Qren, Qfact, next,next_,pTmin,1)
         write(*,fmt="('total cross section  ', 1PE8.2,'[pb]')") cs 
      endif    
#endif

#ifdef CLEAN
      call killPlots
      call system("rm -f inp spectr decay nngg.out omega ")
      call system("rm -f  nngg.out output.flha ")
      call system("rm -f HB.* HS.* hb.* hs.*  debug_channels.txt debug_predratio.txt  Key.dat")
      call system("rm -f Lilith_*   particles.py*")
      call system("rm -f  smodels.* summary.*")
#endif
      END
