* Patterson.F
* non-adaptive 1D Gauss-Kronrod-Patterson integration
* adapted from Quadpack's dqng.f for vector integrands
* this file is part of FormCalc
* last modified 16 Jun 04 th


#include "config.h"

************************************************************************

	subroutine Patterson(ncomp, lower, upper, integrand,
     &    epsrel, epsabs, result, error, neval, fail)
	implicit none
	integer ncomp, neval, fail
	double precision lower, upper, epsrel, epsabs
	double precision result(*), error(*)
	external integrand

	double precision samples(MAXCOMP, 2, 0:43)
	double precision range, mid, h
	double precision estimate, integral, fluct
	double precision err
	integer j, c

* abscissae
	double precision x(43)
	data x /
     &    .973906528517171720077964012084452D0,
     &    .865063366688984510732096688423493D0,
     &    .679409568299024406234327365114874D0,
     &    .433395394129247190799265943165784D0,
     &    .148874338981631210884826001129720D0,
     &    .995657163025808080735527280689003D0,
     &    .930157491355708226001207180059508D0,
     &    .780817726586416897063717578345042D0,
     &    .562757134668604683339000099272694D0,
     &    .294392862701460198131126603103866D0,
     &    .999333360901932081394099323919911D0,
     &    .987433402908088869795961478381209D0,
     &    .954807934814266299257919200290473D0,
     &    .900148695748328293625099494069092D0,
     &    .825198314983114150847066732588520D0,
     &    .732148388989304982612354848755461D0,
     &    .622847970537725238641159120344323D0,
     &    .499479574071056499952214885499755D0,
     &    .364901661346580768043989548502644D0,
     &    .222254919776601296498260928066212D0,
     &    .074650617461383322043914435796506D0,
     &    .999902977262729234490529830591582D0,
     &    .997989895986678745427496322365960D0,
     &    .992175497860687222808523352251425D0,
     &    .981358163572712773571916941623894D0,
     &    .965057623858384619128284110607926D0,
     &    .943167613133670596816416634507426D0,
     &    .915806414685507209591826430720050D0,
     &    .883221657771316501372117548744163D0,
     &    .845710748462415666605902011504855D0,
     &    .803557658035230982788739474980964D0,
     &    .757005730685495558328942793432020D0,
     &    .706273209787321819824094274740840D0,
     &    .651589466501177922534422205016736D0,
     &    .593223374057961088875273770349144D0,
     &    .531493605970831932285268948562671D0,
     &    .466763623042022844871966781659270D0,
     &    .399424847859218804732101665817923D0,
     &    .329874877106188288265053371824597D0,
     &    .258503559202161551802280975429025D0,
     &    .185695396568346652015917141167606D0,
     &    .111842213179907468172398359241362D0,
     &    .037352123394619870814998165437704D0 /

* weights of the 10-point formula
	double precision w10(5)
	data w10 /
     &    .066671344308688137593568809893332D0,
     &    .149451349150580593145776339657697D0,
     &    .219086362515982043995534934228163D0,
     &    .269266719309996355091226921569469D0,
     &    .295524224714752870173892994651338D0 /

* weights of the 21-point formula
	double precision w21(0:10)
	data w21 /
     &    .149445554002916905664936468389821D0,
     &    .032558162307964727478818972459390D0,
     &    .075039674810919952767043140916190D0,
     &    .109387158802297641899210590325805D0,
     &    .134709217311473325928054001771707D0,
     &    .147739104901338491374841515972068D0,
     &    .011694638867371874278064396062192D0,
     &    .054755896574351996031381300244580D0,
     &    .093125454583697605535065465083366D0,
     &    .123491976262065851077958109831074D0,
     &    .142775938577060080797094273138717D0 /

* weights of the 43-point formula
	double precision w43(0:21)
	data w43 /
     &    .074722147517403005594425168280423D0,
     &    .016296734289666564924281974617663D0,
     &    .037522876120869501461613795898115D0,
     &    .054694902058255442147212685465005D0,
     &    .067355414609478086075553166302174D0,
     &    .073870199632393953432140695251367D0,
     &    .005768556059769796184184327908655D0,
     &    .027371890593248842081276069289151D0,
     &    .046560826910428830743339154433824D0,
     &    .061744995201442564496240336030883D0,
     &    .071387267268693397768559114425516D0,
     &    .001844477640212414100389106552965D0,
     &    .010798689585891651740465406741293D0,
     &    .021895363867795428102523123075149D0,
     &    .032597463975345689443882222526137D0,
     &    .042163137935191811847627924327955D0,
     &    .050741939600184577780189020092084D0,
     &    .058379395542619248375475369330206D0,
     &    .064746404951445885544689259517511D0,
     &    .069566197912356484528633315038405D0,
     &    .072824441471833208150939535192842D0,
     &    .074507751014175118273571813842889D0 /

* weights of the 87-point formula
	double precision w87(0:43)
	data w87 /
     &    .037361073762679023410321241766599D0,
     &    .008148377384149172900002878448190D0,
     &    .018761438201562822243935059003794D0,
     &    .027347451050052286161582829741283D0,
     &    .033677707311637930046581056957588D0,
     &    .036935099820427907614589586742499D0,
     &    .002884872430211530501334156248695D0,
     &    .013685946022712701888950035273128D0,
     &    .023280413502888311123409291030404D0,
     &    .030872497611713358675466394126442D0,
     &    .035693633639418770719351355457044D0,
     &    .000915283345202241360843392549948D0,
     &    .005399280219300471367738743391053D0,
     &    .010947679601118931134327826856808D0,
     &    .016298731696787335262665703223280D0,
     &    .021081568889203835112433060188190D0,
     &    .025370969769253827243467999831710D0,
     &    .029189697756475752501446154084920D0,
     &    .032373202467202789685788194889595D0,
     &    .034783098950365142750781997949596D0,
     &    .036412220731351787562801163687577D0,
     &    .037253875503047708539592001191226D0,
     &    .000274145563762072350016527092881D0,
     &    .001807124155057942948341311753254D0,
     &    .004096869282759164864458070683480D0,
     &    .006758290051847378699816577897424D0,
     &    .009549957672201646536053581325377D0,
     &    .012329447652244853694626639963780D0,
     &    .015010447346388952376697286041943D0,
     &    .017548967986243191099665352925900D0,
     &    .019938037786440888202278192730714D0,
     &    .022194935961012286796332102959499D0,
     &    .024339147126000805470360647041454D0,
     &    .026374505414839207241503786552615D0,
     &    .028286910788771200659968002987960D0,
     &    .030052581128092695322521110347341D0,
     &    .031646751371439929404586051078883D0,
     &    .033050413419978503290785944862689D0,
     &    .034255099704226061787082821046821D0,
     &    .035262412660156681033782717998428D0,
     &    .036076989622888701185500318003895D0,
     &    .036698604498456094498018047441094D0,
     &    .037120549269832576114119958413599D0,
     &    .037334228751935040321235449094698D0 /

	range = .5D0*(upper - lower)
	mid = lower + range

* compute the integral using the 10- and 21-point formula

	call integrand(samples(1, 1, 0), mid)
	do j = 1, 10
	  h = range*x(j)
	  call integrand(samples(1, 1, j), mid + h)
	  call integrand(samples(1, 2, j), mid - h)
	enddo

	fail = 0

	do c = 1, ncomp
	  estimate = 0
	  integral = w21(0)*samples(c, 1, 0)
	  do j = 1, 10
	    h = samples(c, 1, j) + samples(c, 2, j)
	    integral = integral + w21(j)*h
	    if( j .le. 5 ) estimate = estimate + w10(j)*h
	  enddo

	  h = .5D0*integral
	  fluct = w21(0)*abs(samples(c, 1, 0) - h)
	  do j = 1, 10
	    fluct = fluct + w21(j)*(abs(samples(c, 1, j) - h) +
     &                              abs(samples(c, 2, j) - h))
	  enddo

	  integral = integral*range
	  err = abs(integral - range*estimate)
	  fluct = fluct*range
	  samples(c, 2, 0) = fluct
	  if( fluct .gt. 1D-13 )
     &      err = fluct*min(1D0, (200*err/fluct)**1.5D0)
	  error(c) = err
	  result(c) = integral
	  if( err .gt. max(abs(integral)*epsrel, epsabs) )
     &      fail = 1
	enddo

	if( fail .eq. 0 ) then
	  neval = 21
	  return
	endif

* compute the integral using the 43-point formula

	do j = 11, 21
	  h = range*x(j)
	  call integrand(samples(1, 1, j), mid + h)
	  call integrand(samples(1, 2, j), mid - h)
	enddo

	fail = 0

	do c = 1, ncomp
	  integral = w43(0)*samples(c, 1, 0)
	  do j = 1, 21
	    integral = integral + w43(j)*(samples(c, 1, j) +
     &                                    samples(c, 2, j))
	  enddo

	  integral = integral*range
	  err = abs(integral - result(c))
	  fluct = samples(c, 2, 0)
	  if( fluct .gt. 1D-13 )
     &      err = fluct*min(1D0, (200*err/fluct)**1.5D0)
	  error(c) = err
	  result(c) = integral
	  if( err .gt. max(abs(integral)*epsrel, epsabs) )
     &      fail = 1
	enddo

	if( fail .eq. 0 ) then
	  neval = 43
	  return
	endif

* compute the integral using the 87-point formula

	do j = 22, 43
	  h = range*x(j)
	  call integrand(samples(1, 1, j), mid + h)
	  call integrand(samples(1, 2, j), mid - h)
	enddo

	fail = 0

	do c = 1, ncomp
	  integral = w87(0)*samples(c, 1, 0)
	  do j = 1, 43
	    integral = integral + w87(j)*(samples(c, 1, j) +
     &                                    samples(c, 2, j))
	  enddo

	  integral = integral*range
	  err = abs(integral - result(c))
	  fluct = samples(c, 2, 0)
	  if( fluct .gt. 1D-13 )
     &      err = fluct*min(1D0, (200*err/fluct)**1.5D0)
	  error(c) = err
	  result(c) = integral
	  if( err .gt. max(abs(integral)*epsrel, epsabs) )
     &      fail = 1
	enddo

	neval = 87
	end
