* Gauss.F
* Gaussian integration of a vector
* this file is part of FormCalc
* last modified 15 Jun 04 th


#include "config.h"

************************************************************************
* nodes may be one of 8, 16, 24, 32 (see GaussData.m).

	subroutine Gauss(ncomp, lower, upper, integrand, nodes, result)
	implicit none
	integer ncomp, nodes
	double precision lower, upper, result(*)
	external integrand

	double precision tmp(MAXCOMP, 2), mid, range, x
	integer c, n, p

	double precision gaussdata(80)
	data gaussdata /
     &    0.96028985649753623168356086856947299D0,
     &    0.10122853629037625915253135430996219D0,
     &    0.79666647741362673959155393647583044D0,
     &    0.22238103445337447054435599442624088D0,
     &    0.52553240991632898581773904918924635D0,
     &    0.31370664587788728733796220198660131D0,
     &    0.18343464249564980493947614236018398D0,
     &    0.36268378337836198296515044927719561D0,
     &    0.98940093499164993259615417345033263D0,
     &    0.027152459411754094851780572456018104D0,
     &    0.94457502307323257607798841553460835D0,
     &    0.062253523938647892862843836994377694D0,
     &    0.86563120238783174388046789771239313D0,
     &    0.095158511682492784809925107602246226D0,
     &    0.75540440835500303389510119484744227D0,
     &    0.12462897125553387205247628219201642D0,
     &    0.61787624440264374844667176404879102D0,
     &    0.14959598881657673208150173054747855D0,
     &    0.45801677765722738634241944298357757D0,
     &    0.16915651939500253818931207903035996D0,
     &    0.28160355077925891323046050146049611D0,
     &    0.18260341504492358886676366796921994D0,
     &    0.095012509837637440185319335424958063D0,
     &    0.18945061045506849628539672320828311D0,
     &    0.99518721999702136017999740970073681D0,
     &    0.012341229799987199546805667070037292D0,
     &    0.97472855597130949819839199300816906D0,
     &    0.028531388628933663181307815951878286D0,
     &    0.93827455200273275852364900170872145D0,
     &    0.044277438817419806168602748211338229D0,
     &    0.88641552700440103421315434198219676D0,
     &    0.059298584915436780746367758500108585D0,
     &    0.82000198597390292195394987266974521D0,
     &    0.073346481411080305734033615253116518D0,
     &    0.74012419157855436424382810309997843D0,
     &    0.086190161531953275917185202983742667D0,
     &    0.64809365193697556925249578691074763D0,
     &    0.097618652104113888269880664464247154D0,
     &    0.54542147138883953565837561721837237D0,
     &    0.10744427011596563478257734244660622D0,
     &    0.43379350762604513848708423191334971D0,
     &    0.11550566805372560135334448390678356D0,
     &    0.31504267969616337438679329131981024D0,
     &    0.12167047292780339120446315347626243D0,
     &    0.19111886747361630915863982075706963D0,
     &    0.12583745634682829612137538251118369D0,
     &    0.064056892862605626085043082624745039D0,
     &    0.12793819534675215697405616522469537D0,
     &    0.99726386184948156354498112866504073D0,
     &    0.0070186100094700966004070637388531825D0,
     &    0.98561151154526833540017504463090198D0,
     &    0.016274394730905670605170562206386618D0,
     &    0.96476225558750643077381192811827496D0,
     &    0.025392065309262059455752589789224029D0,
     &    0.93490607593773968917091913483540933D0,
     &    0.034273862913021433102687732252372707D0,
     &    0.89632115576605212396530724371921227D0,
     &    0.042835898022226680656878646606125528D0,
     &    0.84936761373256997013369300496774254D0,
     &    0.050998059262376176196163244689521695D0,
     &    0.7944837959679424069630972989704289D0,
     &    0.058684093478535547145283637300170887D0,
     &    0.73218211874028968038742666509126715D0,
     &    0.065822222776361846837650063706938773D0,
     &    0.66304426693021520097511516866323837D0,
     &    0.072345794108848506225399356478487792D0,
     &    0.58771575724076232904074547640182686D0,
     &    0.078193895787070306471740918828306671D0,
     &    0.50689990893222939002374747437782123D0,
     &    0.083311924226946755222199074604348612D0,
     &    0.42135127613063534536411943617242648D0,
     &    0.087652093004403811142771462751802288D0,
     &    0.331868602282127649779916805730188D0,
     &    0.091173878695763884712868577111637063D0,
     &    0.23928736225213707454460320916550152D0,
     &    0.09384439908080456563918023766811726D0,
     &    0.14447196158279649348518637359881065D0,
     &    0.095638720079274859419082002204131101D0,
     &    0.048307665687738316234812570440502164D0,
     &    0.096540088514727800566764830063575795D0 /

	p = nodes/8
	p = (1 - 2*p)**2

	range = .5D0*(upper - lower)
	mid = lower + range

	do c = 1, ncomp
	  result(c) = 0
	enddo

	do n = 1, nodes, 2
	  x = range*gaussdata(p)
	  call integrand(tmp(1, 1), mid - x)
	  call integrand(tmp(1, 2), mid + x)
	  x = range*gaussdata(p + 1)
	  do c = 1, ncomp
	    result(c) = result(c) + x*(tmp(c, 1) + tmp(c, 2))
	  enddo
	  p = p + 2
	enddo
	end

