*     LanHEP output produced at Mon Apr 13 18:09:42 2009
*     Model named 'MSSMrc cha1 nans'

* #define QEXT(X) DBLE(X)


C           subroutine zero
C           double precision A
C           common /mdl_para/A(15000)
C           integer i
C              write(*,*) 'Zero'
C              DO i=1,15000
C                A(i)=-1E20
C              ENDDO
C           END 


      real*8 function CheckNCsector(m1_, m2_, mu_,tb_,mz_,sw_)
      real*8 m1_, m2_, mu_, tb_, mz_, sw_
      real*8 Z(4,4),M(4),MM(4,4),Q,s
      integer  i,j,k,l;
      real*8  slhaVal1,slhaVal2
      real*8  tw,w,b,sb,cb
      Q=100
      M(1)=slhaVal1('MASS',Q,1000022)
      M(2)=slhaVal1('MASS',Q,1000023)
      M(3)=slhaVal1('MASS',Q,1000025)
      M(4)=slhaVal1('MASS',Q,1000035)
      Q=dabs(M(1))

C      write(*,*) 'M=', M(1),M(2),M(3),M(4)

      DO i=1,4 
      DO j=1,4
      Z(i,j)=slhaVal2('NMIX',Q,j,i)
C      write(*,*) 'Z',i,j,' =', Z(i,j) 
      ENDDO
      ENDDO
      mTot=0

      DO  i=1,4
      DO l=1,4
      s=0 
      DO k=1,4 
       s=s+Z(i,k)*M(k)*Z(l,k)
      ENDDO
      MM(i,l)=s
      ENDDO
      ENDDO
      

      m1_=MM(1,1)
      m2_=MM(2,2)
      mu_=-MM(4,3) 

      tw=-MM(1,3)/MM(2,3)
      w=datan(tw)
      SW_=sin(w)
      tb_=-MM(1,4)/MM(1,3)
      cb=cos(datan(tb_))
      MZ_= -MM(3,1)/cb/sw_

      CheckNCsector=dabs(MM(1,2))
      if(CheckNCsector.lt.dabs(MM(3,3))) CheckNCsector=dabs(MM(3,3))
      if(CheckNCsector.lt.dabs(MM(4,4))) CheckNCsector=dabs(MM(4,4)) 
      end 

      subroutine ModelDefaults
      implicit none
      integer slharead
      real*8 slhaVal0,slhaVal1,slhaVal2,slhaWidth,zero,CheckNCsector
      integer slhaValExists0,slhaValExists1,slhaValExists2
      integer err
	  double precision findValW	
      real*8 Q,MSt_1,MSt_2        
 
#include "model.h"
C      call zero
      EE=3.134400E-01
      SW = 0.481
      s12 = 0.2229D0
      s23 = 0.0412D0
      s13 = 0.0036D0
      GG = 1.238D0

      Me = 0.000511D0
      Mm = 0.1057D0
      Mu = 0.0056D0
      Md = 0.00956D0
      Ml = 1.777D0
      Mc = 0.7212D0
      Ms = 0.1781D0

C*      err=slharead('slha.tmp',1)
      Q=0
      MST_1=slhaVal1('MASS',Q,1000006)
      MST_2=slhaVal1('MASS',Q,2000006)
      Q=sqrt(MST_1*MST_2)
      MZ=91.187
      Mt=slhaVal1('SMINPUTS',Q,6)
      Mb=2.7
      tb= slhaVal1('HMIX',Q,2) 
      mue=slhaVal1('HMIX', Q,1)
c      write(*,*) 'tb=',tb, 'mue=',mue
      MG1=slhaVal1('MSOFT',Q,1)
      MG2=slhaVal1('MSOFT',Q,2)
c       zero=CheckNCsector(MG1,MG2,mue,tb,MZ,SW)
      MG3=slhaVal1('MSOFT',Q,3)
      Ml2=slhaVal1('MSOFT',Q,32)
	  Ml1=Ml2
      Ml3=slhaVal1('MSOFT',Q,33)  
      Mr2=slhaVal1('MSOFT',Q,35)
	  Mr1=Mr2
      Mr3=slhaVal1('MSOFT',Q,36)
      Mq2=slhaVal1('MSOFT',Q,42) 
	  Mq1=Mq2
      Mq3=slhaVal1('MSOFT',Q,43)
      Mu2=slhaVal1('MSOFT',Q,45)  
	  Mu1=Mu2
      Mu3=slhaVal1('MSOFT',Q,46)      
      Md2=slhaVal1('MSOFT',Q,48)
	  Md1=Md2
      Md3=slhaVal1('MSOFT',Q,49)

      Al= slhaVal2('Ae',   Q,3,3)
      Am=Al
      At= slhaVal2('Au',   Q,3,3)
      Ab= slhaVal2('Ad',   Q,3,3)
      MH3=slhaVal1('MASS', Q,36)

c      dlh1 = 0D0
c      dlh2 = 0D0
c      dlh3 = 0D0
c      dlh4 = 0D0
c      dlh5 = 0D0
c      dlh6 = 0D0
c      dlh7 = 0D0

      wtop = 1.7524D0
      wZ = 2.4944D0
      wW = 2.08895D0
      wh =  0
      wHh = 0
      hisWidt(1)= slhawidth(25)
      hisWidt(2)= slhawidth(35)
      wH3 = slhaWidth(36)
CC      write(*,*) 'wH3=',wH3
      wHc = 0D0
      wSu1 = 0D0
      wSu2 = 0D0
      wSc1 = 0D0
      wSc2 = 0D0
      wStop1 = 0D0
      wStop2 = 0D0
      wSd1 = 0D0
      wSd2 = 0D0
      wSs1 = 0D0
      wSs2 = 0D0
      wSbot1 = 0D0
      wSbot2 = 0D0
      wSne = 0D0
      wSnmu = 0D0
      wSntau = 0D0
      wSe1 = 0D0
      wSe2 = 0D0
      wSmu1 = 0D0
      wSmu2 = 0D0
      wStau1 = 0D0
      wStau2 = 0D0
      wC1 = 0D0
      wC2 = 0D0
      wNE2 = 0D0
      wNE3 = 0D0
      wNE4 = 0D0
      wSG = 0D0
 
      nla = -1.0D0
      nlb = 1.4D0
      nld1 = 1.22D0
      nld2 = 2.55D0
      nlk = 0.876D0
      nle1 = -1.2D0
      nle2 = 3.77D0

      end


      real*8 function ModelConstIni( GI )
      implicit none

#include "model.h"

      double precision neut1,neut2
      double precision findValW	
      real*8 alpha,Q,slhaval0,slhaval1,slhaval2
      double complex Z(4,4)
      real*8 CheckNCsector,zero
      real*8 MNE(4),dI,dJ
      integer i,j,NCgi,k,l,GI
      double complex sc

      NCgi=GI
CC      write(*,*) 'NCgi=',NCgi
      Q=0
      ModelConstIni=0
      call ModelDefaults

      if(NCgi.eq.1) then
c         write(*,*) 
c     >'odl M1=', MG1,' M2=',MG2,' tb=',tb,' mu=',muE,' MZ=',MZ,' SW=',SW
       ModelConstIni=CheckNCsector(MG1,MG2,MUE,tb,MZ,SW)
       
c         write(*,*) 'zero=',zero
c         write(*,*) 
c     >'new M1=', MG1,' M2=',MG2,' tb=',tb,' mu=',muE,' MZ=',MZ,' SW=',SW
      endif

      CW = sqrt(1D0-SW**2)
      S2W = 2D0*SW*CW
      C2W = CW**2-SW**2
      MW = MZ*CW
      c12 = sqrt(1D0-s12**2)
      c23 = sqrt(1D0-s23**2)
      c13 = sqrt(1D0-s13**2)
      sb = tb/sqrt(1D0+tb**2)
      cb = sqrt(1D0-sb**2)
      t2b = 2D0*tb/(1D0-tb**2)
      c2b = cb**2-sb**2
      s2b = 2D0*sb*cb

      
      if(NCgi.gt.0) then  
        Zcsx = (MG2**2+mue**2)/2D0+MW**2
        Zctx = (MG2**2-mue**2)**2/4D0+MW**4*c2b**2+MW**2*(MG2
     &      **2+mue**2+2D0*mue*MG2*s2b)
        MC01 = sqrt(Zcsx-sqrt(Zctx))
        MC02 = sqrt(Zcsx+sqrt(Zctx))
        Zcc2u = -(MG2**2-mue**2-2D0*MW**2*c2b)/(MC02**2-MC01
     &      **2)
        Zcc2v = -(MG2**2-mue**2+2D0*MW**2*c2b)/(MC02**2-MC01
     &      **2)
        Zcsigu = -(MG2*cb+mue*sb)/sqrt((MG2*cb+mue*sb)**2)
        Zcsigv = -(MG2*sb+mue*cb)/sqrt((MG2*sb+mue*cb)**2)
        Zccu = sqrt((1D0+Zcc2u)/2D0)
        Zcsu = sqrt((1D0-Zcc2u)/2D0)*Zcsigu
        Zccv = sqrt((1D0+Zcc2v)/2D0)
        Zcsv = sqrt((1D0-Zcc2v)/2D0)*Zcsigv
        ZcdetM = mue*MG2-MW**2*s2b
        Zcsig1 = (mue*MG2-MW**2*s2b)/sqrt((mue*MG2-MW**2*s2b
     &      )**2)
        Zcsig2 = MW*Sqrt2*(cb*Zcsu*Zccv+sb*Zccu*Zcsv)+mue*Zcsv
     &      *Zcsu+MG2*Zccu*Zccv
        Zcsig3 = Zcsig1*Zcsig2/sqrt(Zcsig2**2)
        Zcsig4 = -MW*Sqrt2*(cb*Zccu*Zcsv+sb*Zcsu*Zccv)+mue
     &      *Zccv*Zccu+MG2*Zcsu*Zcsv
        MC1 = Zcsig2**2/sqrt(Zcsig2**2)
        MC2 = Zcsig4**2/sqrt(Zcsig4**2)
        Zm11 = Zccu*Zcsig1*Zcsig3
        Zm12 = -Zcsu*Zcsig3
        Zm21 = Zcsu*Zcsig1*Zcsig3
        Zm22 = Zccu*Zcsig3
        Zp11 = Zccv
        Zp12 = -Zcsv
        Zp21 = Zcsv
        Zp22 = Zccv
        neutk = neut1(MZ, MW, SW, MG1, MG2, mue, tb)
        DO i=1,4
          dI=i 
C          MNE(i)=neut2(neutk, 3D0, 1D0,dI)
           MNE(i)=neut2(neutk, 3D0 ,dI,1d0)
          DO j=1,4
            dJ=j
            Z(i,j)=neut2(neutk,1D0,dI,dJ)+cI*neut2(neutk, 2D0,dI,dJ)
          ENDDO
        ENDDO

c        DO i=1,4
c          DO j=1,4
c          sc=0
c          DO k=1,4
c            sc=sc+Z(i,k)*MNE(k)*Z(j,k)
c          ENDDO
c          write(*,*) 'M',i,j,'=',sc          
c          ENDDO
c        ENDDO

c        write(*,*) 'LSP mass=',MNE(1) 
       
c        write(*,*) 'LSP Components:', Z(1,1),Z(2,1),Z(3,1),Z(4,1)       
      else 

        MC1   =slhaVal1('MASS',Q, 1000024)
        MC2   =slhaVal1('MASS',Q, 1000037)
c       zero=CheckNCsector(MG1,MG2,MUE,tb,MZ,SW)

        Zm11  =slhaVal2('UMIX',Q, 1,1)
        Zm12  =slhaVal2('UMIX',Q, 2,1)
        Zm21  =slhaVal2('UMIX',Q, 1,2)
        Zm22  =slhaVal2('UMIX',Q, 2,2)
        Zp11  =slhaVal2('VMIX',Q, 1,1)
        Zp12  =slhaVal2('VMIX',Q, 2,1)
        Zp21  =slhaVal2('VMIX',Q, 1,2)
        Zp22  =slhaVal2('VMIX',Q, 2,2)

        MNE(1)=slhaVal1('MASS',Q,1000022)
        MNE(2)=slhaVal1('MASS',Q,1000023)
        MNE(3)=slhaVal1('MASS',Q,1000025)
        MNE(4)=slhaVal1('MASS',Q,1000035)
        DO i=1,4
        DO j=1,4
         Z(i,j)=slhaVal2('NMIX',Q,j,i)
        ENDDO
        ENDDO
        DO i=1,4
          if(MNE(i).lt.0) then 
            MNE(i)=-MNE(i)
            DO j=1,4
              Z(j,i)=CI*Z(j,i)
            ENDDO 
          endif 
        ENDDO
      endif


      MNE1=MNE(1)
      MNE2=MNE(2)
      MNE3=MNE(3)
      MNE4=MNE(4)
      Zn11=Z(1,1)
      Zn12=Z(1,2)
      Zn13=Z(1,3)
      Zn14=Z(1,4)
      Zn21=Z(2,1)
      Zn22=Z(2,2)
      Zn23=Z(2,3)
      Zn24=Z(2,4)
      Zn31=Z(3,1)
      Zn32=Z(3,2)
      Zn33=Z(3,3)
      Zn34=Z(3,4)
      Zn41=Z(4,1)
      Zn42=Z(4,2)
      Zn43=Z(4,3)
      Zn44=Z(4,4)
c      write(*,*)'Zn1k=',Zn11,Zn12,Zn13,Zn14
c      write(*,*)'Zn2k=',Zn21,Zn22,Zn23,Zn24
c      write(*,*)'Zn3k=',Zn31,Zn32,Zn33,Zn34
c      write(*,*)'Zn4k=',Zn41,Zn42,Zn43,Zn44 
c      write(*,*) 'Zm=',Zm11,Zm12,Zm21,Zm22
c      write(*,*) 'Zp=',Zp11,Zp12,Zp21,Zp22
 
C*      MSG = findValW('MSG')
      MSG = slhaVal1('MASS',Q,1000021)
      ls3 = Ml*Al/Sqrt2*EE/SW/MW/cb
      ls2 = Mm*Am/Sqrt2*EE/SW/MW/cb
      ls1 = Me*Ae/Sqrt2*EE/SW/MW/cb
c      MSne = sqrt(c2b*MW**2/2D0+CW**2*Ml1**2)/CW
c      MSnmu = sqrt(c2b*MW**2/2D0+CW**2*Ml2**2)/CW
c      MSntau = sqrt(c2b*MW**2/2D0+CW**2*Ml3**2)/CW
C*      MSne=findValW('MSne')
      MSne=slhaVal1('MASS',Q,1000012)
C*      MSnmu=findValW('MSnm')
      MSnmu=slhaVal1('MASS',Q,1000014)
C*      MSntau=findValW('MSnl')
      MSntau=slhaVal1('MASS',Q,1000016)	  
      MSeLL = Ml1**2+Me**2-MW**2/CW**2*(1D0/2D0-SW**2)*c2b
      MSeRR = Mr1**2+Me**2-MW**2/CW**2*SW**2*c2b
      MSeLR = MW*SW*Sqrt2*cb*ls1/EE-Me*mue*tb
      MSe1 = sqrt((MSeLL+MSeRR-sqrt((MSeLL-MSeRR)**2+4D0
     &      *MSeLR**2))/2D0)
      MSe2 = sqrt((MSeLL+MSeRR+sqrt((MSeLL-MSeRR)**2+4D0
     &      *MSeLR**2))/2D0)
C*      MSe1=findValW('MSeL')
C*      MSe2=findValW('MSeR')
      MSe1=slhaVal1('MASS',Q,1000011)
      MSe2=slhaVal1('MASS',Q,2000011)

      MSeth = 0
      ceth = cos(MSeth)
      seth = sin(MSeth)
      MSmuLL = Ml2**2+Mm**2-MW**2/CW**2*(1D0/2D0-SW**2)*c2b
      MSmuLR = MW*SW*Sqrt2*cb*ls2/EE-Mm*mue*tb
      MSmuRR = Mr2**2+Mm**2-MW**2/CW**2*SW**2*c2b
      MSmu1 = sqrt((MSmuLL+MSmuRR-sqrt((MSmuLL-MSmuRR)**2
     &      +4D0*MSmuLR**2))/2D0)
      MSmu2 = sqrt((MSmuLL+MSmuRR+sqrt((MSmuLL-MSmuRR)**2
     &      +4D0*MSmuLR**2))/2D0)
C*      MSmu1 = findValW('MSmL')
C*      MSmu2 = findValW('MSmR')
      MSmu1=slhaVal1('MASS',Q,1000013)
      MSmu2=slhaVal1('MASS',Q,2000013)

      MSmuth = 0
      smuth = sin(MSmuth)
      cmuth = cos(MSmuth)
      MSlLL = Ml3**2+Ml**2-MW**2/CW**2*(1D0/2D0-SW**2)*c2b
      MSlLR = MW*SW*Sqrt2*cb*ls3/EE-Ml*mue*tb
      MSlRR = Mr3**2+Ml**2-MW**2/CW**2*SW**2*c2b
      MStau1 = sqrt((MSlLL+MSlRR-sqrt((MSlLL-MSlRR)**2+4D0
     &      *MSlLR**2))/2D0)
      MStau2 = sqrt((MSlLL+MSlRR+sqrt((MSlLL-MSlRR)**2+4D0
     &      *MSlLR**2))/2D0)
      MSlth = atan2(-2D0*MSlLR, -MSlLL+MSlRR)/2D0
C*      MStau1=findValW('MSl1')
C*      MStau2=findValW('MSl2')
      MStau1=slhaVal1('MASS',Q,1000015)
      MStau2=slhaVal1('MASS',Q,2000015)
     
C*      MSlth = atan2(findValW('Zl12'),findValW('Zl11'))
      MSlth=atan2(slhaval2('STAUMIX',Q,1,2),slhaval2('STAUMIX',Q,1,1))	
      clth = cos(MSlth)
      slth = sin(MSlth)
      ds3 = Mb*Ab*EE/SW/MW/Sqrt2/cb
      us3 = -At*Mt*EE/SW/MW/Sqrt2/sb
      ds2 = Ms*As*EE/SW/MW/Sqrt2/cb
      us2 = -Mc*Ac*EE/SW/MW/Sqrt2/sb
      us1 = -Mu*Au*EE/SW/MW/Sqrt2/sb
      ds1 = Md*Ad*EE/SW/MW/Sqrt2/cb
      MSuLL = Mq2**2+Mu**2+MW**2/CW**2*(1D0/2D0-2D0/3D0*SW
     &      **2)*c2b
      MSuLR = -MW*SW*Sqrt2*sb*us1/EE-Mu*mue/tb
      MSuRR = Mu2**2+Mu**2+2D0/3D0*MW**2/CW**2*SW**2*c2b
      MSu1 = sqrt((MSuLL+MSuRR-sqrt((MSuLL-MSuRR)**2+4D0
     &      *MSuLR**2))/2D0)
      MSu2 = sqrt((MSuLL+MSuRR+sqrt((MSuLL-MSuRR)**2+4D0
     &      *MSuLR**2))/2D0)
C*      MSu1=findValW('MSuL')
C*      MSu2=findValW('MSuR')
      MSu1=slhaval1('MASS',Q,1000001)
      MSu2=slhaval1('MASS',Q,2000001)
      MSuth = 0
      cuth = cos(MSuth)
      suth = sin(MSuth)
      MScLL = Mq2**2+Mc**2+MW**2/CW**2*(1D0/2D0-2D0/3D0*SW
     &      **2)*c2b
      MScLR = -MW*SW*Sqrt2*sb*us2/EE-Mc*mue/tb
      MScRR = Mu2**2+Mc**2+2D0/3D0*MW**2/CW**2*SW**2*c2b
      MSc1 = sqrt((MScLL+MScRR-sqrt((MScLL-MScRR)**2+4D0
     &      *MScLR**2))/2D0)
      MSc2 = sqrt((MScLL+MScRR+sqrt((MScLL-MScRR)**2+4D0
     &      *MScLR**2))/2D0)
C*      MSc1=findValW('MScL')
C*      MSc2=findValW('MScR')
      MSc1=slhaval1('MASS',Q,1000004)
      MSc2=slhaval1('MASS',Q,2000004)
      MScth = 0
      ccth = cos(MScth)
      scth = sin(MScth)
      MStLL = Mq3**2+Mt**2+MW**2/CW**2*(1D0/2D0-2D0/3D0*SW
     &      **2)*c2b
      MStLR = -MW*SW*Sqrt2*sb*us3/EE-Mt*mue/tb
      MStRR = Mu3**2+Mt**2+2D0/3D0*MW**2/CW**2*SW**2*c2b
c      MStop1 = sqrt((MStLL+MStRR-sqrt((MStLL-MStRR)**2+4D0
c     &      *MStLR**2))/2D0)
c      MStop2 = sqrt((MStLL+MStRR+sqrt((MStLL-MStRR)**2+4D0
c     &      *MStLR**2))/2D0)
C*      MStop1=findValW('MSt1')
C*      MStop2=findValW('MSt2')
      MStop1=slhaval1('MASS',Q,1000006)
      MStop2=slhaval1('MASS',Q,2000006)   
      MStth = atan2(-2D0*MStLR, -MStLL+MStRR)/2D0
c      MStth = atan2(findValW('Zt12'), findValW('Zt11'))
      MStth=atan2(slhaval2('STOPMIX',Q,1,2), slhaval2('STOPMIX',Q,1,1))       
      ctth = cos(MStth)
      stth = sin(MStth)
      MSdLL = Mq2**2+Md**2-MW**2/CW**2*(1D0/2D0-1D0/3D0*SW
     &      **2)*c2b
      MSdLR = MW*SW*Sqrt2*cb*ds1/EE-Md*mue*tb
      MSdRR = Md2**2+Md**2-1D0/3D0*MW**2/CW**2*SW**2*c2b
      MSd1 = sqrt((MSdLL+MSdRR-sqrt((MSdLL-MSdRR)**2+4D0
     &      *MSdLR**2))/2D0)
      MSd2 = sqrt((MSdLL+MSdRR+sqrt((MSdLL-MSdRR)**2+4D0
     &      *MSdLR**2))/2D0)
      MSdth = atan2(-2D0*MSdLR, -MSdLL+MSdRR)/2D0
C      MSd1=findValW('MSdL')
C      MSd2=findValW('MSdR')
      MSd1=slhaval1('MASS',Q,1000001)
      MSd2=slhaval1('MASS',Q,2000001)
      MSdth=0
      cdth = cos(MSdth)
      sdth = sin(MSdth)
      MSsLL = Mq2**2+Ms**2-MW**2/CW**2*(1D0/2D0-1D0/3D0*SW
     &      **2)*c2b
      MSsLR = MW*SW*Sqrt2*cb*ds2/EE-Ms*mue*tb
      MSsRR = Md2**2+Ms**2-1D0/3D0*MW**2/CW**2*SW**2*c2b
      MSs1 = sqrt((MSsLL+MSsRR-sqrt((MSsLL-MSsRR)**2+4D0
     &      *MSsLR**2))/2D0)
      MSs2 = sqrt((MSsLL+MSsRR+sqrt((MSsLL-MSsRR)**2+4D0
     &      *MSsLR**2))/2D0)
      MSsth = atan2(-2D0*MSsLR, -MSsLL+MSsRR)/2D0
C*      MSs1=findValW('MSsL')
C*      MSs2=findValW('MSsR') 
      MSs1=slhaval1('MASS',Q,1000003)
      MSs2=slhaval1('MASS',Q,2000003)

      MSsth=0
      csth = cos(MSsth)
      ssth = sin(MSsth)
      MSbLL = Mq3**2+Mb**2-MW**2/CW**2*(1D0/2D0-1D0/3D0*SW
     &      **2)*c2b
      MSbLR = MW*SW*Sqrt2*cb*ds3/EE-Mb*mue*tb
      MSbRR = Md3**2+Mb**2-1D0/3D0*MW**2/CW**2*SW**2*c2b
      MSbot1 = sqrt((MSbLL+MSbRR-sqrt((MSbLL-MSbRR)**2+4D0
     &      *MSbLR**2))/2D0)
      MSbot2 = sqrt((MSbLL+MSbRR+sqrt((MSbLL-MSbRR)**2+4D0
     &      *MSbLR**2))/2D0)
      MSbth = atan2(-2D0*MSbLR, -MSbLL+MSbRR)/2D0
C*      MSbot1=findValW('MSb1')
C*      MSbot2=findValW('MSb2')

      MSbot1=slhaval1('MASS',Q,1000005)
      MSbot2=slhaval1('MASS',Q,2000005)
      
C*      MSbth=atan2(findValW('Zb12'),findValW('Zb11'))
      MSbth=atan2(slhaval2('SBOTMIX',Q,1,2),slhaval2('SBOTMIX',Q,1,1))
      cbth = cos(MSbth)
      sbth = sin(MSbth)
      vevv = 2D0*MW**2*SW**2/EE**2
      t2a1 = MH3**2*s2b+MZ**2*s2b
      t2a2 = MH3**2*c2b-MZ**2*c2b
      hha2 = atan2(-t2a1, -t2a2)
      ca = cos(hha2/2D0)
      sa = sin(hha2/2D0)
      alpha=slhaval0('ALPHA',Q)
      ca=cos(alpha)
      sa=sin(alpha)
      sapb = sa*cb+ca*sb
      samb = sa*cb-ca*sb
      capb = ca*cb-sa*sb
      camb = ca*cb+sa*sb
      s2a = 2D0*sa*ca
      c2a = ca**2-sa**2
      MHH = sqrt(MZ**2*capb**2+MH3**2*samb**2)
      Mh = sqrt(MZ**2*sapb**2+MH3**2*camb**2)
      MHc = sqrt(MH3**2+MW**2)
C*      Mh=findValW('Mh') 
C*      MHc=findValW('MHc')
      Mh=slhaval1('MASS',Q,25)
      MHc=slhaval1('MASS',Q,37)
      MSnl = MSntau
      MSl1 = MStau1
      MSl2 = MStau2
      MSnm = MSnmu
      MSm1 = MSmu1
      MSm2 = MSmu2
      smth = smuth
      cmth = cmuth
      MSt1 = MStop1
      MSt2 = MStop2
      MSb1 = MSbot1
      MSb2 = MSbot2
      SW2 = SW**2
      CW2 = CW**2
      MW2 = MW**2
      MZ2 = MZ**2
      EE2 = EE**2
      GG2 = GG**2
      Mesq = Me**2
      Mmsq = Mm**2
      Mlsq = Ml**2
      Musq = Mu**2
      Mdsq = Md**2
      Mcsq = Mc**2
      Mssq = Ms**2
      Mbsq = Mb**2
      Mtsq = Mt**2

c      write(*,*) 'MNE1=',MNE1, ' MC1=',MC1
c      write(*,*) 'mue=', mue

c         MC1    =MC1*1000
c         MC2    =MC2*1000
c         MNE1   =MNE1*1000
c         MNE2   =MNE2*1000
c         MNE3   =MNE3*1000
c         MNE4   =MNE4*1000
c         MSe1   =MSe1*1000
c         MSe2   =MSe2*1000
c         MSmu1  =MSmu1*1000
c         MSmu2  =MSmu2*1000
c         MStau1 =MStau1*1000
c         MStau2 =MStau2*1000
c         MSu1   =MSu1*1000
c         MSu2   =MSu2*1000
c         MSd1   =MSd1*1000
c         MSd2   =MSd2*1000
c         MSc1   =MSc1*1000
c         MSc2   =MSc2*1000
c         MSs1   =MSs1*1000
c         MSs2   =MSs2*1000
c         MStop1 =MStop1*1000
c         MStop2 =MStop2*1000
c         MSbot1 =MSbot1*1000
c         MSbot2 =MSbot2*1000
c         MSne   =MSne*1000
c         MSnmu  =MSnmu*1000
c         MSntau =MSntau*1000
c         MHH    =MHH*1000
c         MHHsq  =MHHsq*1000
c         Mh     =Mh*1000
c         MH3    =MH3*1000
c         MHc    =MHc    *1000


      MC1sq    = MC1**2
      MC2sq    = MC2**2
      MNE1sq   = MNE1**2
      MNE2sq   = MNE2**2
      MNE3sq   = MNE3**2
      MNE4sq   = MNE4**2
      MSe1sq   = MSe1**2
      MSe2sq   = MSe2**2
      MSmu1sq  = MSmu1**2
      MSmu2sq  = MSmu2**2
      MStau1sq = MStau1**2
      MStau2sq = MStau2**2
      MSu1sq   = MSu1**2
      MSu2sq   = MSu2**2
      MSd1sq   = MSd1**2
      MSd2sq   = MSd2**2
      MSc1sq   = MSc1**2
      MSc2sq   = MSc2**2
      MSs1sq   = MSs1**2
      MSs2sq   = MSs2**2
      MStop1sq = MStop1**2
      MStop2sq = MStop2**2
      MSbot1sq = MSbot1**2
      MSbot2sq = MSbot2**2
      MSnesq   = MSne**2
      MSnmusq  = MSnmu**2
      MSntausq = MSntau**2
      MHHsq    = MHH**2
      MHH2     = MHHsq
      Mhsq     = Mh**2
      MH3sq    = MH3**2
      MHcsq    = MHc**2     
      Alfa = EE**2/4D0/pi
      Alfa2 = Alfa**2

      call aaini01
      call aaini02
      call aaini03
      call aaini04
      call aaini05
      call aaini06
      call aaini07
      call aaini08
      call aaini09
      call aaini10
      call mtrini
      end

      subroutine aaini01
      implicit none
#include "model.h"

      AAABR(1) = 1D0-sb**2
      AAABR(2) = sb**2
      AAABR(3) = 2D0*MH3**2*sb**2+3D0*MW**2*sb**2-2D0*MW
     &      **2*sb**4-MW**2/CW**2*sb**2+2D0*MW**2/CW**2*sb
     &      **4+MW**2/CW**2*SW**2*sb**2-2D0*MW**2/CW**2*SW
     &      **2*sb**4
      AAABR(4) = MW**2*(1D0+1D0/CW**2+4D0*sb**2-4D0*sb**4
     &      -SW**2/CW**2-4D0*sb**2/CW**2+4D0*sb**4/CW**2
     &      +4D0*SW**2/CW**2*sb**2-4D0*SW**2/CW**2*sb**4)
      AAABR(5) = MW**2*(sb**2-3D0*sb**4+2D0*sb**6-sb**2/CW
     &      **2+3D0*sb**4/CW**2-2D0*sb**6/CW**2+SW**2/CW
     &      **2*sb**2-3D0*SW**2/CW**2*sb**4+2D0*SW**2/CW
     &      **2*sb**6)
      AAABR(6) = 2D0*MH3**2+MW**2+MW**2/CW**2-2D0*MH3**2
     &      *sb**2+MW**2*sb**2-2D0*MW**2*sb**4-MW**2/CW**2
     &      *SW**2-3D0*MW**2/CW**2*sb**2+2D0*MW**2/CW**2
     &      *sb**4+3D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2
     &      /CW**2*SW**2*sb**4
      AAABR(7) = MW**2
      AAABR(8) = cb*sb
      AAABR(9) = cb*(MH3**2*sb+2D0*MW**2*sb-2D0*MW**2*sb
     &      **3-MW**2/CW**2*sb+2D0*MW**2/CW**2*sb**3+MW**2
     &      /CW**2*SW**2*sb-2D0*MW**2/CW**2*SW**2*sb**3)
      AAABR(10) = MW**2*cb*(sb-2D0*sb**3-sb/CW**2+2D0*sb
     &      **3/CW**2+SW**2/CW**2*sb-2D0*SW**2/CW**2*sb**3)
      AAABR(11) = cb*(MH3**2*sb+MW**2*sb-4D0*MW**2*sb**3
     &      +4D0*MW**2*sb**5+4D0*MW**2/CW**2*sb**3-4D0*MW
     &      **2/CW**2*sb**5-4D0*MW**2/CW**2*SW**2*sb**3+4D0
     &      *MW**2/CW**2*SW**2*sb**5)
      AAABR(12) = cb*(MH3**2*sb+2D0*MW**2*sb**3+MW**2/CW
     &      **2*sb-2D0*MW**2/CW**2*sb**3-MW**2/CW**2*SW**2
     &      *sb+2D0*MW**2/CW**2*SW**2*sb**3)
      AAABR(13) = EE/MW/SW*(ca*sb-cb*sa)
      AAABR(14) = EE/MW/SW*(ca*cb+sa*sb)
      AAABR(15) = 2D0*MH3**2*sb**2+MW**2*sb**2-2D0*MW**2
     &      *sb**4-MW**2/CW**2*sb**2+2D0*MW**2/CW**2*sb**4
     &      +MW**2/CW**2*SW**2*sb**2-2D0*MW**2/CW**2*SW**2
     &      *sb**4
      AAABR(16) = MW**2*(1D0-1D0/CW**2-4D0*sb**2+4D0*sb**4
     &      +SW**2/CW**2+4D0*sb**2/CW**2-4D0*sb**4/CW**2
     &      -4D0*SW**2/CW**2*sb**2+4D0*SW**2/CW**2*sb**4)
      AAABR(17) = 2D0*MH3**2-MW**2+MW**2/CW**2-2D0*MH3**2
     &      *sb**2+3D0*MW**2*sb**2-2D0*MW**2*sb**4-MW**2
     &      /CW**2*SW**2-3D0*MW**2/CW**2*sb**2+2D0*MW**2
     &      /CW**2*sb**4+3D0*MW**2/CW**2*SW**2*sb**2-2D0
     &      *MW**2/CW**2*SW**2*sb**4
      AAABR(18) = cb*(MH3**2*sb+MW**2*sb-2D0*MW**2*sb**3
     &      -MW**2/CW**2*sb+2D0*MW**2/CW**2*sb**3+MW**2/CW
     &      **2*SW**2*sb-2D0*MW**2/CW**2*SW**2*sb**3)
      AAABR(19) = cb*(MH3**2*sb-4D0*MW**2*sb**3+4D0*MW**2
     &      *sb**5+4D0*MW**2/CW**2*sb**3-4D0*MW**2/CW**2
     &      *sb**5-4D0*MW**2/CW**2*SW**2*sb**3+4D0*MW**2
     &      /CW**2*SW**2*sb**5)
      AAABR(20) = cb*(MH3**2*sb-MW**2*sb+2D0*MW**2*sb**3
     &      +MW**2/CW**2*sb-2D0*MW**2/CW**2*sb**3-MW**2/CW
     &      **2*SW**2*sb+2D0*MW**2/CW**2*SW**2*sb**3)
      AAABR(21) = MW**2-2D0*MW**2*sb**2-MW**2*smuth**2-MW
     &      **2/CW**2*SW**2+2D0*MW**2*sb**2*smuth**2-2D0
     &      *Am*Mm*cmuth*smuth+2D0*MW**2/CW**2*SW**2*sb**2
     &      +3D0*MW**2/CW**2*SW**2*smuth**2-6D0*MW**2/CW
     &      **2*SW**2*sb**2*smuth**2
      AAABR(22) = MW**2*sb**2-MW**2*sb**4-MW**2*sb**2*smuth
     &      **2+MW**2*sb**4*smuth**2-MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*sb**4-Am*Mm*cmuth*sb**2
     &      *smuth+3D0*MW**2/CW**2*SW**2*sb**2*smuth**2-3D0
     &      *MW**2/CW**2*SW**2*sb**4*smuth**2-Mm/cb*cmuth
     &      *mue*sb*smuth
      AAABR(23) = MW**2*(1D0-2D0*sb**2-smuth**2+2D0*sb**2
     &      *smuth**2)
      AAABR(24) = MW**2-2D0*Ml2**2-2D0*Mm**2-2D0*MW**2*sb
     &      **2-MW**2*smuth**2+2D0*Ml2**2*smuth**2-2D0*Mr2
     &      **2*smuth**2-MW**2/CW**2*SW**2+2D0*MW**2*sb**2
     &      *smuth**2-4D0*Am*Mm*cmuth*smuth+2D0*MW**2/CW
     &      **2*SW**2*sb**2+3D0*MW**2/CW**2*SW**2*smuth**2
     &      -6D0*MW**2/CW**2*SW**2*sb**2*smuth**2+4D0*Mm
     &      /cb*cmuth*mue*sb*smuth
      AAABR(25) = 2D0*Am*Mm-4D0*Am*Mm*smuth**2+MW**2*cmuth
     &      *smuth-2D0*Ml2**2*cmuth*smuth+2D0*Mr2**2*cmuth
     &      *smuth-2D0*MW**2*cmuth*sb**2*smuth-2D0*Mm/cb
     &      *mue*sb-3D0*MW**2/CW**2*SW**2*cmuth*smuth+4D0
     &      *Mm/cb*mue*sb*smuth**2+6D0*MW**2/CW**2*SW**2
     &      *cmuth*sb**2*smuth
      AAABR(26) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(27) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(28) = Mm+Am*cmuth*smuth-cmuth/cb*mue*sb*smuth
      AAABR(29) = Mm/cb*cmuth*sb*smuth
      AAABR(30) = Ml2*(1D0-smuth**2)
      AAABR(31) = Mr2*smuth**2
      AAABR(32) = Mm*cmuth*smuth
      AAABR(33) = MW**2-2D0*MW**2*sb**2-MW**2*seth**2-MW
     &      **2/CW**2*SW**2+2D0*MW**2*sb**2*seth**2-2D0*Ae
     &      *Me*ceth*seth+2D0*MW**2/CW**2*SW**2*sb**2+3D0
     &      *MW**2/CW**2*SW**2*seth**2-6D0*MW**2/CW**2*SW
     &      **2*sb**2*seth**2
      AAABR(34) = MW**2*sb**2-MW**2*sb**4-MW**2*sb**2*seth
     &      **2+MW**2*sb**4*seth**2-MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*sb**4-Ae*Me*ceth*sb**2
     &      *seth+3D0*MW**2/CW**2*SW**2*sb**2*seth**2-3D0
     &      *MW**2/CW**2*SW**2*sb**4*seth**2-Me/cb*ceth*mue
     &      *sb*seth
      AAABR(35) = MW**2*(1D0-2D0*sb**2-seth**2+2D0*sb**2
     &      *seth**2)
      AAABR(36) = MW**2-2D0*Me**2-2D0*Ml1**2-2D0*MW**2*sb
     &      **2-MW**2*seth**2+2D0*Ml1**2*seth**2-2D0*Mr1
     &      **2*seth**2-MW**2/CW**2*SW**2+2D0*MW**2*sb**2
     &      *seth**2-4D0*Ae*Me*ceth*seth+2D0*MW**2/CW**2
     &      *SW**2*sb**2+3D0*MW**2/CW**2*SW**2*seth**2-6D0
     &      *MW**2/CW**2*SW**2*sb**2*seth**2+4D0*Me/cb*ceth
     &      *mue*sb*seth
      AAABR(37) = 2D0*Ae*Me-4D0*Ae*Me*seth**2+MW**2*ceth
     &      *seth-2D0*Ml1**2*ceth*seth+2D0*Mr1**2*ceth*seth
     &      -2D0*MW**2*ceth*sb**2*seth-2D0*Me/cb*mue*sb-3D0
     &      *MW**2/CW**2*SW**2*ceth*seth+4D0*Me/cb*mue*sb
     &      *seth**2+6D0*MW**2/CW**2*SW**2*ceth*sb**2*seth
      AAABR(38) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(39) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(40) = Me+Ae*ceth*seth-ceth/cb*mue*sb*seth
      AAABR(41) = Me/cb*ceth*sb*seth
      AAABR(42) = Ml1*(1D0-seth**2)
      AAABR(43) = Mr1*seth**2
      AAABR(44) = Me*ceth*seth
      AAABR(45) = MW**2-2D0*MW**2*sb**2-MW**2*slth**2-MW
     &      **2/CW**2*SW**2+2D0*MW**2*sb**2*slth**2-2D0*Al
     &      *Ml*clth*slth+2D0*MW**2/CW**2*SW**2*sb**2+3D0
     &      *MW**2/CW**2*SW**2*slth**2-6D0*MW**2/CW**2*SW
     &      **2*sb**2*slth**2
      AAABR(46) = MW**2*sb**2-MW**2*sb**4-MW**2*sb**2*slth
     &      **2+MW**2*sb**4*slth**2-MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*sb**4-Al*Ml*clth*sb**2
     &      *slth+3D0*MW**2/CW**2*SW**2*sb**2*slth**2-3D0
     &      *MW**2/CW**2*SW**2*sb**4*slth**2-Ml/cb*clth*mue
     &      *sb*slth
      AAABR(47) = MW**2*(1D0-2D0*sb**2-slth**2+2D0*sb**2
     &      *slth**2)
      AAABR(48) = MW**2-2D0*Ml**2-2D0*Ml3**2-2D0*MW**2*sb
     &      **2-MW**2*slth**2+2D0*Ml3**2*slth**2-2D0*Mr3
     &      **2*slth**2-MW**2/CW**2*SW**2+2D0*MW**2*sb**2
     &      *slth**2-4D0*Al*Ml*clth*slth+2D0*MW**2/CW**2
     &      *SW**2*sb**2+3D0*MW**2/CW**2*SW**2*slth**2-6D0
     &      *MW**2/CW**2*SW**2*sb**2*slth**2+4D0*Ml/cb*clth
     &      *mue*sb*slth
      AAABR(49) = 2D0*Al*Ml-4D0*Al*Ml*slth**2+MW**2*clth
     &      *slth-2D0*Ml3**2*clth*slth+2D0*Mr3**2*clth*slth
     &      -2D0*MW**2*clth*sb**2*slth-2D0*Ml/cb*mue*sb-3D0
     &      *MW**2/CW**2*SW**2*clth*slth+4D0*Ml/cb*mue*sb
     &      *slth**2+6D0*MW**2/CW**2*SW**2*clth*sb**2*slth
      AAABR(50) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(51) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(52) = Ml+Al*clth*slth-clth/cb*mue*sb*slth
      AAABR(53) = Ml/cb*clth*sb*slth
      AAABR(54) = Ml3*(1D0-slth**2)
      AAABR(55) = Mr3*slth**2
      AAABR(56) = Ml*clth*slth
      AAABR(57) = Al*Ml-2D0*Al*Ml*slth**2+MW**2*clth*slth
     &      -2D0*MW**2*clth*sb**2*slth-3D0*MW**2/CW**2*SW
     &      **2*clth*slth+6D0*MW**2/CW**2*SW**2*clth*sb**2
     &      *slth
      AAABR(58) = Al*Ml*sb**2-2D0*Al*Ml*sb**2*slth**2+2D0
     &      *MW**2*clth*sb**2*slth-2D0*MW**2*clth*sb**4*slth
     &      +Ml/cb*mue*sb-2D0*Ml/cb*mue*sb*slth**2-6D0*MW
     &      **2/CW**2*SW**2*clth*sb**2*slth+6D0*MW**2/CW
     &      **2*SW**2*clth*sb**4*slth
      AAABR(59) = MW**2*clth*slth*(1D0-2D0*sb**2)
      AAABR(60) = 2D0*Ml**2+2D0*Mr3**2-MW**2*slth**2+2D0
     &      *Ml3**2*slth**2-2D0*Mr3**2*slth**2-2D0*MW**2
     &      /CW**2*SW**2+2D0*MW**2*sb**2*slth**2-4D0*Al*Ml
     &      *clth*slth+4D0*MW**2/CW**2*SW**2*sb**2+3D0*MW
     &      **2/CW**2*SW**2*slth**2-6D0*MW**2/CW**2*SW**2
     &      *sb**2*slth**2+4D0*Ml/cb*clth*mue*sb*slth
      AAABR(61) = MW**2/CW**2*SW**2*clth*slth*(1D0-2D0*sb
     &      **2)
      AAABR(62) = MW**2/CW**3*SW**3*clth*slth*(1D0-2D0*sb
     &      **2)
      AAABR(63) = Al-2D0*Al*slth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*slth**2
      AAABR(64) = Ml/cb*sb*(1D0-2D0*slth**2)
      AAABR(65) = Ml3*clth*slth
      AAABR(66) = Mr3*clth*slth
      AAABR(67) = Ml*(1D0-2D0*slth**2)
      AAABR(68) = Am*Mm-2D0*Am*Mm*smuth**2+MW**2*cmuth*smuth
     &      -2D0*MW**2*cmuth*sb**2*smuth-3D0*MW**2/CW**2
     &      *SW**2*cmuth*smuth+6D0*MW**2/CW**2*SW**2*cmuth
     &      *sb**2*smuth
      AAABR(69) = Am*Mm*sb**2-2D0*Am*Mm*sb**2*smuth**2+2D0
     &      *MW**2*cmuth*sb**2*smuth-2D0*MW**2*cmuth*sb**4
     &      *smuth+Mm/cb*mue*sb-2D0*Mm/cb*mue*sb*smuth**2
     &      -6D0*MW**2/CW**2*SW**2*cmuth*sb**2*smuth+6D0
     &      *MW**2/CW**2*SW**2*cmuth*sb**4*smuth
      AAABR(70) = MW**2*cmuth*smuth*(1D0-2D0*sb**2)
      AAABR(71) = 2D0*Mm**2+2D0*Mr2**2-MW**2*smuth**2+2D0
     &      *Ml2**2*smuth**2-2D0*Mr2**2*smuth**2-2D0*MW**2
     &      /CW**2*SW**2+2D0*MW**2*sb**2*smuth**2-4D0*Am
     &      *Mm*cmuth*smuth+4D0*MW**2/CW**2*SW**2*sb**2+3D0
     &      *MW**2/CW**2*SW**2*smuth**2-6D0*MW**2/CW**2*SW
     &      **2*sb**2*smuth**2+4D0*Mm/cb*cmuth*mue*sb*smuth
      AAABR(72) = MW**2/CW**2*SW**2*cmuth*smuth*(1D0-2D0
     &      *sb**2)
      AAABR(73) = MW**2/CW**3*SW**3*cmuth*smuth*(1D0-2D0
     &      *sb**2)
      AAABR(74) = Am-2D0*Am*smuth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*smuth**2
      AAABR(75) = Mm/cb*sb*(1D0-2D0*smuth**2)
      AAABR(76) = Ml2*cmuth*smuth
      AAABR(77) = Mr2*cmuth*smuth
      AAABR(78) = Mm*(1D0-2D0*smuth**2)
      AAABR(79) = Ae*Me-2D0*Ae*Me*seth**2+MW**2*ceth*seth
     &      -2D0*MW**2*ceth*sb**2*seth-3D0*MW**2/CW**2*SW
     &      **2*ceth*seth+6D0*MW**2/CW**2*SW**2*ceth*sb**2
     &      *seth
      AAABR(80) = Ae*Me*sb**2-2D0*Ae*Me*sb**2*seth**2+2D0
     &      *MW**2*ceth*sb**2*seth-2D0*MW**2*ceth*sb**4*seth
     &      +Me/cb*mue*sb-2D0*Me/cb*mue*sb*seth**2-6D0*MW
     &      **2/CW**2*SW**2*ceth*sb**2*seth+6D0*MW**2/CW
     &      **2*SW**2*ceth*sb**4*seth
      AAABR(81) = MW**2*ceth*seth*(1D0-2D0*sb**2)
      AAABR(82) = 2D0*Me**2+2D0*Mr1**2-MW**2*seth**2+2D0
     &      *Ml1**2*seth**2-2D0*Mr1**2*seth**2-2D0*MW**2
     &      /CW**2*SW**2+2D0*MW**2*sb**2*seth**2-4D0*Ae*Me
     &      *ceth*seth+4D0*MW**2/CW**2*SW**2*sb**2+3D0*MW
     &      **2/CW**2*SW**2*seth**2-6D0*MW**2/CW**2*SW**2
     &      *sb**2*seth**2+4D0*Me/cb*ceth*mue*sb*seth
      AAABR(83) = MW**2/CW**2*SW**2*ceth*seth*(1D0-2D0*sb
     &      **2)
      AAABR(84) = MW**2/CW**3*SW**3*ceth*seth*(1D0-2D0*sb
     &      **2)
      AAABR(85) = Ae-2D0*Ae*seth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*seth**2
      AAABR(86) = Me/cb*sb*(1D0-2D0*seth**2)
      AAABR(87) = Ml1*ceth*seth
      AAABR(88) = Mr1*ceth*seth
      AAABR(89) = Me*(1D0-2D0*seth**2)
      AAABR(90) = MW**2*slth**2+2D0*MW**2/CW**2*SW**2-2D0
     &      *MW**2*sb**2*slth**2+2D0*Al*Ml*clth*slth-4D0
     &      *MW**2/CW**2*SW**2*sb**2-3D0*MW**2/CW**2*SW**2
     &      *slth**2+6D0*MW**2/CW**2*SW**2*sb**2*slth**2
      AAABR(91) = MW**2*sb**2*slth**2-MW**2*sb**4*slth**2
     &      +2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2/CW**2
     &      *SW**2*sb**4+Al*Ml*clth*sb**2*slth-3D0*MW**2
     &      /CW**2*SW**2*sb**2*slth**2+3D0*MW**2/CW**2*SW
     &      **2*sb**4*slth**2+Ml/cb*clth*mue*sb*slth
      AAABR(92) = MW**2*slth**2*(1D0-2D0*sb**2)
      AAABR(93) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(94) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(95) = Ml-Al*clth*slth+clth/cb*mue*sb*slth
      AAABR(96) = Ml3*slth**2
      AAABR(97) = Mr3*(1D0-slth**2)
      AAABR(98) = MW**2*smuth**2+2D0*MW**2/CW**2*SW**2-2D0
     &      *MW**2*sb**2*smuth**2+2D0*Am*Mm*cmuth*smuth-4D0
     &      *MW**2/CW**2*SW**2*sb**2-3D0*MW**2/CW**2*SW**2
     &      *smuth**2+6D0*MW**2/CW**2*SW**2*sb**2*smuth**2
      AAABR(99) = MW**2*sb**2*smuth**2-MW**2*sb**4*smuth
     &      **2+2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2/CW
     &      **2*SW**2*sb**4+Am*Mm*cmuth*sb**2*smuth-3D0*MW
     &      **2/CW**2*SW**2*sb**2*smuth**2+3D0*MW**2/CW**2
     &      *SW**2*sb**4*smuth**2+Mm/cb*cmuth*mue*sb*smuth
      AAABR(100) = MW**2*smuth**2*(1D0-2D0*sb**2)
      AAABR(101) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(102) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(103) = Mm-Am*cmuth*smuth+cmuth/cb*mue*sb*smuth
      AAABR(104) = Ml2*smuth**2
      AAABR(105) = Mr2*(1D0-smuth**2)
      AAABR(106) = MW**2*seth**2+2D0*MW**2/CW**2*SW**2-2D0
     &      *MW**2*sb**2*seth**2+2D0*Ae*Me*ceth*seth-4D0
     &      *MW**2/CW**2*SW**2*sb**2-3D0*MW**2/CW**2*SW**2
     &      *seth**2+6D0*MW**2/CW**2*SW**2*sb**2*seth**2
      AAABR(107) = MW**2*sb**2*seth**2-MW**2*sb**4*seth**2
     &      +2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2/CW**2
     &      *SW**2*sb**4+Ae*Me*ceth*sb**2*seth-3D0*MW**2
     &      /CW**2*SW**2*sb**2*seth**2+3D0*MW**2/CW**2*SW
     &      **2*sb**4*seth**2+Me/cb*ceth*mue*sb*seth
      AAABR(108) = MW**2*seth**2*(1D0-2D0*sb**2)
      AAABR(109) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(110) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(111) = Me-Ae*ceth*seth+ceth/cb*mue*sb*seth
      AAABR(112) = Ml1*seth**2
      AAABR(113) = Mr1*(1D0-seth**2)
      AAABR(114) = MW**2*(1D0-2D0*sb**2+SW**2/CW**2-2D0*SW
     &      **2/CW**2*sb**2)
      AAABR(115) = MW**2*(sb**2-sb**4+SW**2/CW**2*sb**2-SW
     &      **2/CW**2*sb**4)
      AAABR(116) = MW**2*(1D0-2D0*sb**2)
      AAABR(117) = MW**2+2D0*Ml1**2-2D0*MW**2*sb**2+MW**2
     &      /CW**2*SW**2-2D0*MW**2/CW**2*SW**2*sb**2
      AAABR(118) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2)
      AAABR(119) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2)
      AAABR(120) = MW**2+2D0*Ml3**2-2D0*MW**2*sb**2+MW**2
     &      /CW**2*SW**2-2D0*MW**2/CW**2*SW**2*sb**2
      AAABR(121) = MW**2+2D0*Ml2**2-2D0*MW**2*sb**2+MW**2
     &      /CW**2*SW**2-2D0*MW**2/CW**2*SW**2*sb**2
      AAABR(122) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*sbth
     &      **2+MW**2/CW**2*SW**2+6D0*MW**2*sb**2*sbth**2
     &      -6D0*Ab*Mb*cbth*sbth-2D0*MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*sbth**2-2D0*MW**2/CW**2
     &      *SW**2*sb**2*sbth**2
      AAABR(123) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*sbth**2+3D0*MW**2*sb**4*sbth**2+MW
     &      **2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2*sb**4
     &      -3D0*Ab*Mb*cbth*sb**2*sbth+MW**2/CW**2*SW**2
     &      *sb**2*sbth**2-MW**2/CW**2*SW**2*sb**4*sbth**2
     &      -3D0*Mb/cb*cbth*mue*sb*sbth
      AAABR(124) = MW**2*(1D0-2D0*sb**2-sbth**2+2D0*sb**2
     &      *sbth**2)
      AAABR(125) = 3D0*MW**2-6D0*Mb**2-6D0*Mq3**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*sbth**2-6D0*Md3**2*sbth**2
     &      +6D0*Mq3**2*sbth**2+MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*sbth**2-12D0*Ab*Mb*cbth*sbth-2D0*MW
     &      **2/CW**2*SW**2*sb**2+MW**2/CW**2*SW**2*sbth
     &      **2-2D0*MW**2/CW**2*SW**2*sb**2*sbth**2+12D0
     &      *Mb/cb*cbth*mue*sb*sbth
      AAABR(126) = 6D0*Ab*Mb-12D0*Ab*Mb*sbth**2+3D0*MW**2
     &      *cbth*sbth+6D0*Md3**2*cbth*sbth-6D0*Mq3**2*cbth
     &      *sbth-6D0*MW**2*cbth*sb**2*sbth-6D0*Mb/cb*mue
     &      *sb-MW**2/CW**2*SW**2*cbth*sbth+12D0*Mb/cb*mue
     &      *sb*sbth**2+2D0*MW**2/CW**2*SW**2*cbth*sb**2
     &      *sbth
      AAABR(127) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2+sbth
     &      **2-2D0*sb**2*sbth**2)
      AAABR(128) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2+sbth
     &      **2-2D0*sb**2*sbth**2)
      AAABR(129) = Mb+Ab*cbth*sbth-cbth/cb*mue*sb*sbth
      AAABR(130) = Mb/cb*cbth*sb*sbth
      AAABR(131) = Mq3*(1D0-sbth**2)
      AAABR(132) = Md3*sbth**2
      AAABR(133) = Mb*cbth*sbth
      AAABR(134) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*sdth
     &      **2+MW**2/CW**2*SW**2+6D0*MW**2*sb**2*sdth**2
     &      -6D0*Ad*Md*cdth*sdth-2D0*MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*sdth**2-2D0*MW**2/CW**2
     &      *SW**2*sb**2*sdth**2
      AAABR(135) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*sdth**2+3D0*MW**2*sb**4*sdth**2+MW
     &      **2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2*sb**4
     &      -3D0*Ad*Md*cdth*sb**2*sdth+MW**2/CW**2*SW**2
     &      *sb**2*sdth**2-MW**2/CW**2*SW**2*sb**4*sdth**2
     &      -3D0*Md/cb*cdth*mue*sb*sdth
      AAABR(136) = MW**2*(1D0-2D0*sb**2-sdth**2+2D0*sb**2
     &      *sdth**2)
      AAABR(137) = 3D0*MW**2-6D0*Md**2-6D0*Mq1**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*sdth**2-6D0*Md1**2*sdth**2
     &      +6D0*Mq1**2*sdth**2+MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*sdth**2-12D0*Ad*Md*cdth*sdth-2D0*MW
     &      **2/CW**2*SW**2*sb**2+MW**2/CW**2*SW**2*sdth
     &      **2-2D0*MW**2/CW**2*SW**2*sb**2*sdth**2+12D0
     &      *Md/cb*cdth*mue*sb*sdth
      AAABR(138) = 6D0*Ad*Md-12D0*Ad*Md*sdth**2+3D0*MW**2
     &      *cdth*sdth+6D0*Md1**2*cdth*sdth-6D0*Mq1**2*cdth
     &      *sdth-6D0*MW**2*cdth*sb**2*sdth-6D0*Md/cb*mue
     &      *sb-MW**2/CW**2*SW**2*cdth*sdth+12D0*Md/cb*mue
     &      *sb*sdth**2+2D0*MW**2/CW**2*SW**2*cdth*sb**2
     &      *sdth
      AAABR(139) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2+sdth
     &      **2-2D0*sb**2*sdth**2)
      AAABR(140) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2+sdth
     &      **2-2D0*sb**2*sdth**2)
      AAABR(141) = Md+Ad*cdth*sdth-cdth/cb*mue*sb*sdth
      AAABR(142) = Md/cb*cdth*sb*sdth
      AAABR(143) = Mq1*(1D0-sdth**2)
      AAABR(144) = Md1*sdth**2
      AAABR(145) = Md*cdth*sdth
      AAABR(146) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*ssth
     &      **2+MW**2/CW**2*SW**2+6D0*MW**2*sb**2*ssth**2
     &      -6D0*As*Ms*csth*ssth-2D0*MW**2/CW**2*SW**2*sb
     &      **2+MW**2/CW**2*SW**2*ssth**2-2D0*MW**2/CW**2
     &      *SW**2*sb**2*ssth**2
      AAABR(147) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*ssth**2+3D0*MW**2*sb**4*ssth**2+MW
     &      **2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2*sb**4
     &      -3D0*As*Ms*csth*sb**2*ssth+MW**2/CW**2*SW**2
     &      *sb**2*ssth**2-MW**2/CW**2*SW**2*sb**4*ssth**2
     &      -3D0*Ms/cb*csth*mue*sb*ssth
      AAABR(148) = MW**2*(1D0-2D0*sb**2-ssth**2+2D0*sb**2
     &      *ssth**2)
      AAABR(149) = 3D0*MW**2-6D0*Mq2**2-6D0*Ms**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*ssth**2-6D0*Md2**2*ssth**2
     &      +6D0*Mq2**2*ssth**2+MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*ssth**2-12D0*As*Ms*csth*ssth-2D0*MW
     &      **2/CW**2*SW**2*sb**2+MW**2/CW**2*SW**2*ssth
     &      **2-2D0*MW**2/CW**2*SW**2*sb**2*ssth**2+12D0
     &      *Ms/cb*csth*mue*sb*ssth
      AAABR(150) = 6D0*As*Ms-12D0*As*Ms*ssth**2+3D0*MW**2
     &      *csth*ssth+6D0*Md2**2*csth*ssth-6D0*Mq2**2*csth
     &      *ssth-6D0*MW**2*csth*sb**2*ssth-6D0*Ms/cb*mue
     &      *sb-MW**2/CW**2*SW**2*csth*ssth+12D0*Ms/cb*mue
     &      *sb*ssth**2+2D0*MW**2/CW**2*SW**2*csth*sb**2
     &      *ssth
      AAABR(151) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2+ssth
     &      **2-2D0*sb**2*ssth**2)
      AAABR(152) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2+ssth
     &      **2-2D0*sb**2*ssth**2)
      AAABR(153) = Ms+As*csth*ssth-csth/cb*mue*sb*ssth
      AAABR(154) = Ms/cb*csth*sb*ssth
      AAABR(155) = Mq2*(1D0-ssth**2)
      AAABR(156) = Md2*ssth**2
      AAABR(157) = Ms*csth*ssth
      AAABR(158) = 3D0*Ad*Md-6D0*Ad*Md*sdth**2+3D0*MW**2
     &      *cdth*sdth-6D0*MW**2*cdth*sb**2*sdth-MW**2/CW
     &      **2*SW**2*cdth*sdth+2D0*MW**2/CW**2*SW**2*cdth
     &      *sb**2*sdth
      AAABR(159) = 3D0*Ad*Md*sb**2-6D0*Ad*Md*sb**2*sdth**2
     &      +6D0*MW**2*cdth*sb**2*sdth-6D0*MW**2*cdth*sb
     &      **4*sdth+3D0*Md/cb*mue*sb-6D0*Md/cb*mue*sb*sdth
     &      **2-2D0*MW**2/CW**2*SW**2*cdth*sb**2*sdth+2D0
     &      *MW**2/CW**2*SW**2*cdth*sb**4*sdth
      AAABR(160) = MW**2*cdth*sdth*(1D0-2D0*sb**2)
      AAABR(161) = 6D0*Md**2+6D0*Md1**2-3D0*MW**2*sdth**2
     &      -6D0*Md1**2*sdth**2+6D0*Mq1**2*sdth**2-2D0*MW
     &      **2/CW**2*SW**2+6D0*MW**2*sb**2*sdth**2-12D0
     &      *Ad*Md*cdth*sdth+4D0*MW**2/CW**2*SW**2*sb**2
     &      +MW**2/CW**2*SW**2*sdth**2-2D0*MW**2/CW**2*SW
     &      **2*sb**2*sdth**2+12D0*Md/cb*cdth*mue*sb*sdth
      AAABR(162) = MW**2/CW**2*SW**2*cdth*sdth*(1D0-2D0*sb
     &      **2)
      AAABR(163) = MW**2/CW**3*SW**3*cdth*sdth*(1D0-2D0*sb
     &      **2)
      AAABR(164) = Ad-2D0*Ad*sdth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*sdth**2
      AAABR(165) = Md/cb*sb*(1D0-2D0*sdth**2)
      AAABR(166) = Mq1*cdth*sdth
      AAABR(167) = Md1*cdth*sdth
      AAABR(168) = Md*(1D0-2D0*sdth**2)
      AAABR(169) = 3D0*As*Ms-6D0*As*Ms*ssth**2+3D0*MW**2
     &      *csth*ssth-6D0*MW**2*csth*sb**2*ssth-MW**2/CW
     &      **2*SW**2*csth*ssth+2D0*MW**2/CW**2*SW**2*csth
     &      *sb**2*ssth
      AAABR(170) = 3D0*As*Ms*sb**2-6D0*As*Ms*sb**2*ssth**2
     &      +6D0*MW**2*csth*sb**2*ssth-6D0*MW**2*csth*sb
     &      **4*ssth+3D0*Ms/cb*mue*sb-6D0*Ms/cb*mue*sb*ssth
     &      **2-2D0*MW**2/CW**2*SW**2*csth*sb**2*ssth+2D0
     &      *MW**2/CW**2*SW**2*csth*sb**4*ssth
      AAABR(171) = MW**2*csth*ssth*(1D0-2D0*sb**2)
      AAABR(172) = 6D0*Md2**2+6D0*Ms**2-3D0*MW**2*ssth**2
     &      -6D0*Md2**2*ssth**2+6D0*Mq2**2*ssth**2-2D0*MW
     &      **2/CW**2*SW**2+6D0*MW**2*sb**2*ssth**2-12D0
     &      *As*Ms*csth*ssth+4D0*MW**2/CW**2*SW**2*sb**2
     &      +MW**2/CW**2*SW**2*ssth**2-2D0*MW**2/CW**2*SW
     &      **2*sb**2*ssth**2+12D0*Ms/cb*csth*mue*sb*ssth
      AAABR(173) = MW**2/CW**2*SW**2*csth*ssth*(1D0-2D0*sb
     &      **2)
      AAABR(174) = MW**2/CW**3*SW**3*csth*ssth*(1D0-2D0*sb
     &      **2)
      AAABR(175) = As-2D0*As*ssth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*ssth**2
      AAABR(176) = Ms/cb*sb*(1D0-2D0*ssth**2)
      AAABR(177) = Mq2*csth*ssth
      AAABR(178) = Md2*csth*ssth
      AAABR(179) = Ms*(1D0-2D0*ssth**2)
      AAABR(180) = 3D0*Ab*Mb-6D0*Ab*Mb*sbth**2+3D0*MW**2
     &      *cbth*sbth-6D0*MW**2*cbth*sb**2*sbth-MW**2/CW
     &      **2*SW**2*cbth*sbth+2D0*MW**2/CW**2*SW**2*cbth
     &      *sb**2*sbth
      AAABR(181) = 3D0*Ab*Mb*sb**2-6D0*Ab*Mb*sb**2*sbth**2
     &      +6D0*MW**2*cbth*sb**2*sbth-6D0*MW**2*cbth*sb
     &      **4*sbth+3D0*Mb/cb*mue*sb-6D0*Mb/cb*mue*sb*sbth
     &      **2-2D0*MW**2/CW**2*SW**2*cbth*sb**2*sbth+2D0
     &      *MW**2/CW**2*SW**2*cbth*sb**4*sbth
      AAABR(182) = MW**2*cbth*sbth*(1D0-2D0*sb**2)
      AAABR(183) = 6D0*Mb**2+6D0*Md3**2-3D0*MW**2*sbth**2
     &      -6D0*Md3**2*sbth**2+6D0*Mq3**2*sbth**2-2D0*MW
     &      **2/CW**2*SW**2+6D0*MW**2*sb**2*sbth**2-12D0
     &      *Ab*Mb*cbth*sbth+4D0*MW**2/CW**2*SW**2*sb**2
     &      +MW**2/CW**2*SW**2*sbth**2-2D0*MW**2/CW**2*SW
     &      **2*sb**2*sbth**2+12D0*Mb/cb*cbth*mue*sb*sbth
      AAABR(184) = MW**2/CW**2*SW**2*cbth*sbth*(1D0-2D0*sb
     &      **2)
      AAABR(185) = MW**2/CW**3*SW**3*cbth*sbth*(1D0-2D0*sb
     &      **2)
      AAABR(186) = Ab-2D0*Ab*sbth**2-mue/cb*sb+2D0*mue/cb
     &      *sb*sbth**2
      AAABR(187) = Mb/cb*sb*(1D0-2D0*sbth**2)
      AAABR(188) = Mq3*cbth*sbth
      AAABR(189) = Md3*cbth*sbth
      AAABR(190) = Mb*(1D0-2D0*sbth**2)
      AAABR(191) = 3D0*MW**2*ssth**2+2D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*ssth**2+6D0*As*Ms*csth*ssth
     &      -4D0*MW**2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2
     &      *ssth**2+2D0*MW**2/CW**2*SW**2*sb**2*ssth**2
      AAABR(192) = 3D0*MW**2*sb**2*ssth**2-3D0*MW**2*sb**4
     &      *ssth**2+2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2
     &      /CW**2*SW**2*sb**4+3D0*As*Ms*csth*sb**2*ssth
     &      -MW**2/CW**2*SW**2*sb**2*ssth**2+MW**2/CW**2
     &      *SW**2*sb**4*ssth**2+3D0*Ms/cb*csth*mue*sb*ssth
      AAABR(193) = MW**2*ssth**2*(1D0-2D0*sb**2)
      AAABR(194) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-ssth
     &      **2+2D0*sb**2*ssth**2)
      AAABR(195) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-ssth
     &      **2+2D0*sb**2*ssth**2)
      AAABR(196) = Ms-As*csth*ssth+csth/cb*mue*sb*ssth
      AAABR(197) = Mq2*ssth**2
      AAABR(198) = Md2*(1D0-ssth**2)
      AAABR(199) = 3D0*MW**2*sbth**2+2D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*sbth**2+6D0*Ab*Mb*cbth*sbth
     &      -4D0*MW**2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2
     &      *sbth**2+2D0*MW**2/CW**2*SW**2*sb**2*sbth**2
      AAABR(200) = 3D0*MW**2*sb**2*sbth**2-3D0*MW**2*sb**4
     &      *sbth**2+2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2
     &      /CW**2*SW**2*sb**4+3D0*Ab*Mb*cbth*sb**2*sbth
     &      -MW**2/CW**2*SW**2*sb**2*sbth**2+MW**2/CW**2
     &      *SW**2*sb**4*sbth**2+3D0*Mb/cb*cbth*mue*sb*sbth
      AAABR(201) = MW**2*sbth**2*(1D0-2D0*sb**2)
      AAABR(202) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-sbth
     &      **2+2D0*sb**2*sbth**2)
      AAABR(203) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-sbth
     &      **2+2D0*sb**2*sbth**2)
      AAABR(204) = Mb-Ab*cbth*sbth+cbth/cb*mue*sb*sbth
      AAABR(205) = Mq3*sbth**2
      AAABR(206) = Md3*(1D0-sbth**2)
      AAABR(207) = 3D0*MW**2*sdth**2+2D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*sdth**2+6D0*Ad*Md*cdth*sdth
     &      -4D0*MW**2/CW**2*SW**2*sb**2-MW**2/CW**2*SW**2
     &      *sdth**2+2D0*MW**2/CW**2*SW**2*sb**2*sdth**2
      AAABR(208) = 3D0*MW**2*sb**2*sdth**2-3D0*MW**2*sb**4
     &      *sdth**2+2D0*MW**2/CW**2*SW**2*sb**2-2D0*MW**2
     &      /CW**2*SW**2*sb**4+3D0*Ad*Md*cdth*sb**2*sdth
     &      -MW**2/CW**2*SW**2*sb**2*sdth**2+MW**2/CW**2
     &      *SW**2*sb**4*sdth**2+3D0*Md/cb*cdth*mue*sb*sdth
      AAABR(209) = MW**2*sdth**2*(1D0-2D0*sb**2)
      AAABR(210) = MW**2/CW**2*SW**2*(2D0-4D0*sb**2-sdth
     &      **2+2D0*sb**2*sdth**2)
      AAABR(211) = MW**2/CW**3*SW**3*(2D0-4D0*sb**2-sdth
     &      **2+2D0*sb**2*sdth**2)
      AAABR(212) = Md-Ad*cdth*sdth+cdth/cb*mue*sb*sdth
      AAABR(213) = Mq1*sdth**2
      AAABR(214) = Md1*(1D0-sdth**2)
      AAABR(215) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*suth
     &      **2-MW**2/CW**2*SW**2+6D0*MW**2*sb**2*suth**2
     &      +6D0*Au*Mu*cuth*suth+2D0*MW**2/CW**2*SW**2*sb
     &      **2+5D0*MW**2/CW**2*SW**2*suth**2-10D0*MW**2
     &      /CW**2*SW**2*sb**2*suth**2
      AAABR(216) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*suth**2+3D0*MW**2*sb**4*suth**2-3D0
     &      *Au*Mu*cuth*suth-MW**2/CW**2*SW**2*sb**2+MW**2
     &      /CW**2*SW**2*sb**4+3D0*Au*Mu*cuth*sb**2*suth
     &      +5D0*MW**2/CW**2*SW**2*sb**2*suth**2-5D0*MW**2
     &      /CW**2*SW**2*sb**4*suth**2-3D0*Mu*cb*cuth*mue
     &      /sb*suth
      AAABR(217) = MW**2*(1D0-2D0*sb**2-suth**2+2D0*sb**2
     &      *suth**2)
      AAABR(218) = 3D0*MW**2+6D0*Mq1**2+6D0*Mu**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*suth**2-6D0*Mq1**2*suth**2
     &      +6D0*Mu1**2*suth**2-MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*suth**2+12D0*Au*Mu*cuth*suth+2D0*MW
     &      **2/CW**2*SW**2*sb**2+5D0*MW**2/CW**2*SW**2*suth
     &      **2-10D0*MW**2/CW**2*SW**2*sb**2*suth**2-12D0
     &      *Mu*cb*cuth*mue/sb*suth
      AAABR(219) = 6D0*Au*Mu-12D0*Au*Mu*suth**2-3D0*MW**2
     &      *cuth*suth-6D0*Mq1**2*cuth*suth+6D0*Mu1**2*cuth
     &      *suth+6D0*MW**2*cuth*sb**2*suth-6D0*Mu*cb*mue
     &      /sb+5D0*MW**2/CW**2*SW**2*cuth*suth+12D0*Mu*cb
     &      *mue/sb*suth**2-10D0*MW**2/CW**2*SW**2*cuth*sb
     &      **2*suth
      AAABR(220) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(221) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(222) = Mu+Au*cuth*suth-cb*cuth*mue/sb*suth
      AAABR(223) = Mu*cb*cuth/sb*suth
      AAABR(224) = Mq1*(1D0-suth**2)
      AAABR(225) = Mu1*suth**2
      AAABR(226) = Mu*cuth*suth
      AAABR(227) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*stth
     &      **2-MW**2/CW**2*SW**2+6D0*MW**2*sb**2*stth**2
     &      +6D0*At*Mt*ctth*stth+2D0*MW**2/CW**2*SW**2*sb
     &      **2+5D0*MW**2/CW**2*SW**2*stth**2-10D0*MW**2
     &      /CW**2*SW**2*sb**2*stth**2
      AAABR(228) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*stth**2+3D0*MW**2*sb**4*stth**2-3D0
     &      *At*Mt*ctth*stth-MW**2/CW**2*SW**2*sb**2+MW**2
     &      /CW**2*SW**2*sb**4+3D0*At*Mt*ctth*sb**2*stth
     &      +5D0*MW**2/CW**2*SW**2*sb**2*stth**2-5D0*MW**2
     &      /CW**2*SW**2*sb**4*stth**2-3D0*Mt*cb*ctth*mue
     &      /sb*stth
      AAABR(229) = MW**2*(1D0-2D0*sb**2-stth**2+2D0*sb**2
     &      *stth**2)
      AAABR(230) = 3D0*MW**2+6D0*Mq3**2+6D0*Mt**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*stth**2-6D0*Mq3**2*stth**2
     &      +6D0*Mu3**2*stth**2-MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*stth**2+12D0*At*Mt*ctth*stth+2D0*MW
     &      **2/CW**2*SW**2*sb**2+5D0*MW**2/CW**2*SW**2*stth
     &      **2-10D0*MW**2/CW**2*SW**2*sb**2*stth**2-12D0
     &      *Mt*cb*ctth*mue/sb*stth
      AAABR(231) = 6D0*At*Mt-12D0*At*Mt*stth**2-3D0*MW**2
     &      *ctth*stth-6D0*Mq3**2*ctth*stth+6D0*Mu3**2*ctth
     &      *stth+6D0*MW**2*ctth*sb**2*stth-6D0*Mt*cb*mue
     &      /sb+5D0*MW**2/CW**2*SW**2*ctth*stth+12D0*Mt*cb
     &      *mue/sb*stth**2-10D0*MW**2/CW**2*SW**2*ctth*sb
     &      **2*stth
      AAABR(232) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(233) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(234) = Mt+At*ctth*stth-cb*ctth*mue/sb*stth
      AAABR(235) = Mt*cb*ctth/sb*stth
      AAABR(236) = Mq3*(1D0-stth**2)
      AAABR(237) = Mu3*stth**2
      AAABR(238) = Mt*ctth*stth
      AAABR(239) = 3D0*MW**2-6D0*MW**2*sb**2-3D0*MW**2*scth
     &      **2-MW**2/CW**2*SW**2+6D0*MW**2*sb**2*scth**2
     &      +6D0*Ac*Mc*ccth*scth+2D0*MW**2/CW**2*SW**2*sb
     &      **2+5D0*MW**2/CW**2*SW**2*scth**2-10D0*MW**2
     &      /CW**2*SW**2*sb**2*scth**2
      AAABR(240) = 3D0*MW**2*sb**2-3D0*MW**2*sb**4-3D0*MW
     &      **2*sb**2*scth**2+3D0*MW**2*sb**4*scth**2-3D0
     &      *Ac*Mc*ccth*scth-MW**2/CW**2*SW**2*sb**2+MW**2
     &      /CW**2*SW**2*sb**4+3D0*Ac*Mc*ccth*sb**2*scth
     &      +5D0*MW**2/CW**2*SW**2*sb**2*scth**2-5D0*MW**2
     &      /CW**2*SW**2*sb**4*scth**2-3D0*Mc*cb*ccth*mue
     &      /sb*scth
      AAABR(241) = MW**2*(1D0-2D0*sb**2-scth**2+2D0*sb**2
     &      *scth**2)
      AAABR(242) = 3D0*MW**2+6D0*Mc**2+6D0*Mq2**2-6D0*MW
     &      **2*sb**2-3D0*MW**2*scth**2-6D0*Mq2**2*scth**2
     &      +6D0*Mu2**2*scth**2-MW**2/CW**2*SW**2+6D0*MW
     &      **2*sb**2*scth**2+12D0*Ac*Mc*ccth*scth+2D0*MW
     &      **2/CW**2*SW**2*sb**2+5D0*MW**2/CW**2*SW**2*scth
     &      **2-10D0*MW**2/CW**2*SW**2*sb**2*scth**2-12D0
     &      *Mc*cb*ccth*mue/sb*scth
      AAABR(243) = 6D0*Ac*Mc-12D0*Ac*Mc*scth**2-3D0*MW**2
     &      *ccth*scth-6D0*Mq2**2*ccth*scth+6D0*Mu2**2*ccth
     &      *scth+6D0*MW**2*ccth*sb**2*scth-6D0*Mc*cb*mue
     &      /sb+5D0*MW**2/CW**2*SW**2*ccth*scth+12D0*Mc*cb
     &      *mue/sb*scth**2-10D0*MW**2/CW**2*SW**2*ccth*sb
     &      **2*scth
      AAABR(244) = MW**2/CW**2*SW**2*(1D0-2D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(245) = MW**2/CW**3*SW**3*(1D0-2D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(246) = Mc+Ac*ccth*scth-cb*ccth*mue/sb*scth
      AAABR(247) = Mc*cb*ccth/sb*scth
      AAABR(248) = Mq2*(1D0-scth**2)
      AAABR(249) = Mu2*scth**2
      AAABR(250) = Mc*ccth*scth
      AAABR(251) = 3D0*Ac*Mc-6D0*Ac*Mc*scth**2-3D0*MW**2
     &      *ccth*scth+6D0*MW**2*ccth*sb**2*scth+5D0*MW**2
     &      /CW**2*SW**2*ccth*scth-10D0*MW**2/CW**2*SW**2
     &      *ccth*sb**2*scth
      AAABR(252) = 3D0*Ac*Mc-3D0*Ac*Mc*sb**2-6D0*Ac*Mc*scth
     &      **2+6D0*Ac*Mc*sb**2*scth**2+6D0*MW**2*ccth*sb
     &      **2*scth-6D0*MW**2*ccth*sb**4*scth+3D0*Mc*cb
     &      *mue/sb-6D0*Mc*cb*mue/sb*scth**2-10D0*MW**2/CW
     &      **2*SW**2*ccth*sb**2*scth+10D0*MW**2/CW**2*SW
     &      **2*ccth*sb**4*scth
      AAABR(253) = MW**2*ccth*scth*(1D0-2D0*sb**2)
      AAABR(254) = 6D0*Mc**2+6D0*Mu2**2+3D0*MW**2*scth**2
     &      +6D0*Mq2**2*scth**2-6D0*Mu2**2*scth**2+4D0*MW
     &      **2/CW**2*SW**2-6D0*MW**2*sb**2*scth**2-12D0
     &      *Ac*Mc*ccth*scth-8D0*MW**2/CW**2*SW**2*sb**2
     &      -5D0*MW**2/CW**2*SW**2*scth**2+10D0*MW**2/CW
     &      **2*SW**2*sb**2*scth**2+12D0*Mc*cb*ccth*mue/sb
     &      *scth
      AAABR(255) = MW**2/CW**2*SW**2*ccth*scth*(1D0-2D0*sb
     &      **2)
      AAABR(256) = MW**2/CW**3*SW**3*ccth*scth*(1D0-2D0*sb
     &      **2)
      AAABR(257) = Ac-2D0*Ac*scth**2-cb*mue/sb+2D0*cb*mue
     &      /sb*scth**2
      AAABR(258) = Mc*cb/sb*(1D0-2D0*scth**2)
      AAABR(259) = Mq2*ccth*scth
      AAABR(260) = Mu2*ccth*scth
      AAABR(261) = Mc*(1D0-2D0*scth**2)
      AAABR(262) = 3D0*At*Mt-6D0*At*Mt*stth**2-3D0*MW**2
     &      *ctth*stth+6D0*MW**2*ctth*sb**2*stth+5D0*MW**2
     &      /CW**2*SW**2*ctth*stth-10D0*MW**2/CW**2*SW**2
     &      *ctth*sb**2*stth
      AAABR(263) = 3D0*At*Mt-3D0*At*Mt*sb**2-6D0*At*Mt*stth
     &      **2+6D0*At*Mt*sb**2*stth**2+6D0*MW**2*ctth*sb
     &      **2*stth-6D0*MW**2*ctth*sb**4*stth+3D0*Mt*cb
     &      *mue/sb-6D0*Mt*cb*mue/sb*stth**2-10D0*MW**2/CW
     &      **2*SW**2*ctth*sb**2*stth+10D0*MW**2/CW**2*SW
     &      **2*ctth*sb**4*stth
      AAABR(264) = MW**2*ctth*stth*(1D0-2D0*sb**2)
      AAABR(265) = 6D0*Mt**2+6D0*Mu3**2+3D0*MW**2*stth**2
     &      +6D0*Mq3**2*stth**2-6D0*Mu3**2*stth**2+4D0*MW
     &      **2/CW**2*SW**2-6D0*MW**2*sb**2*stth**2-12D0
     &      *At*Mt*ctth*stth-8D0*MW**2/CW**2*SW**2*sb**2
     &      -5D0*MW**2/CW**2*SW**2*stth**2+10D0*MW**2/CW
     &      **2*SW**2*sb**2*stth**2+12D0*Mt*cb*ctth*mue/sb
     &      *stth
      AAABR(266) = MW**2/CW**2*SW**2*ctth*stth*(1D0-2D0*sb
     &      **2)
      AAABR(267) = MW**2/CW**3*SW**3*ctth*stth*(1D0-2D0*sb
     &      **2)
      AAABR(268) = At-2D0*At*stth**2-cb*mue/sb+2D0*cb*mue
     &      /sb*stth**2
      AAABR(269) = Mt*cb/sb*(1D0-2D0*stth**2)
      AAABR(270) = Mq3*ctth*stth
      AAABR(271) = Mu3*ctth*stth
      AAABR(272) = Mt*(1D0-2D0*stth**2)
      AAABR(273) = 3D0*Au*Mu-6D0*Au*Mu*suth**2-3D0*MW**2
     &      *cuth*suth+6D0*MW**2*cuth*sb**2*suth+5D0*MW**2
     &      /CW**2*SW**2*cuth*suth-10D0*MW**2/CW**2*SW**2
     &      *cuth*sb**2*suth
      AAABR(274) = 3D0*Au*Mu-3D0*Au*Mu*sb**2-6D0*Au*Mu*suth
     &      **2+6D0*Au*Mu*sb**2*suth**2+6D0*MW**2*cuth*sb
     &      **2*suth-6D0*MW**2*cuth*sb**4*suth+3D0*Mu*cb
     &      *mue/sb-6D0*Mu*cb*mue/sb*suth**2-10D0*MW**2/CW
     &      **2*SW**2*cuth*sb**2*suth+10D0*MW**2/CW**2*SW
     &      **2*cuth*sb**4*suth
      AAABR(275) = MW**2*cuth*suth*(1D0-2D0*sb**2)
      AAABR(276) = 6D0*Mu**2+6D0*Mu1**2+3D0*MW**2*suth**2
     &      +6D0*Mq1**2*suth**2-6D0*Mu1**2*suth**2+4D0*MW
     &      **2/CW**2*SW**2-6D0*MW**2*sb**2*suth**2-12D0
     &      *Au*Mu*cuth*suth-8D0*MW**2/CW**2*SW**2*sb**2
     &      -5D0*MW**2/CW**2*SW**2*suth**2+10D0*MW**2/CW
     &      **2*SW**2*sb**2*suth**2+12D0*Mu*cb*cuth*mue/sb
     &      *suth
      AAABR(277) = MW**2/CW**2*SW**2*cuth*suth*(1D0-2D0*sb
     &      **2)
      AAABR(278) = MW**2/CW**3*SW**3*cuth*suth*(1D0-2D0*sb
     &      **2)
      AAABR(279) = Au-2D0*Au*suth**2-cb*mue/sb+2D0*cb*mue
     &      /sb*suth**2
      AAABR(280) = Mu*cb/sb*(1D0-2D0*suth**2)
      AAABR(281) = Mq1*cuth*suth
      AAABR(282) = Mu1*cuth*suth
      AAABR(283) = Mu*(1D0-2D0*suth**2)
      AAABR(284) = 3D0*MW**2*stth**2+4D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*stth**2-6D0*At*Mt*ctth*stth
     &      -8D0*MW**2/CW**2*SW**2*sb**2-5D0*MW**2/CW**2
     &      *SW**2*stth**2+10D0*MW**2/CW**2*SW**2*sb**2*stth
     &      **2
      AAABR(285) = 3D0*MW**2*sb**2*stth**2-3D0*MW**2*sb**4
     &      *stth**2+3D0*At*Mt*ctth*stth+4D0*MW**2/CW**2
     &      *SW**2*sb**2-4D0*MW**2/CW**2*SW**2*sb**4-3D0
     &      *At*Mt*ctth*sb**2*stth-5D0*MW**2/CW**2*SW**2
     &      *sb**2*stth**2+5D0*MW**2/CW**2*SW**2*sb**4*stth
     &      **2+3D0*Mt*cb*ctth*mue/sb*stth
      AAABR(286) = MW**2*stth**2*(1D0-2D0*sb**2)
      AAABR(287) = MW**2/CW**2*SW**2*(4D0-8D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(288) = MW**2/CW**3*SW**3*(4D0-8D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(289) = Mt-At*ctth*stth+cb*ctth*mue/sb*stth
      AAABR(290) = Mq3*stth**2
      AAABR(291) = Mu3*(1D0-stth**2)
      AAABR(292) = 3D0*MW**2*suth**2+4D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*suth**2-6D0*Au*Mu*cuth*suth
     &      -8D0*MW**2/CW**2*SW**2*sb**2-5D0*MW**2/CW**2
     &      *SW**2*suth**2+10D0*MW**2/CW**2*SW**2*sb**2*suth
     &      **2
      AAABR(293) = 3D0*MW**2*sb**2*suth**2-3D0*MW**2*sb**4
     &      *suth**2+3D0*Au*Mu*cuth*suth+4D0*MW**2/CW**2
     &      *SW**2*sb**2-4D0*MW**2/CW**2*SW**2*sb**4-3D0
     &      *Au*Mu*cuth*sb**2*suth-5D0*MW**2/CW**2*SW**2
     &      *sb**2*suth**2+5D0*MW**2/CW**2*SW**2*sb**4*suth
     &      **2+3D0*Mu*cb*cuth*mue/sb*suth
      AAABR(294) = MW**2*suth**2*(1D0-2D0*sb**2)
      AAABR(295) = MW**2/CW**2*SW**2*(4D0-8D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(296) = MW**2/CW**3*SW**3*(4D0-8D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(297) = Mu-Au*cuth*suth+cb*cuth*mue/sb*suth
      AAABR(298) = Mq1*suth**2
      AAABR(299) = Mu1*(1D0-suth**2)
      AAABR(300) = 3D0*MW**2*scth**2+4D0*MW**2/CW**2*SW**2
     &      -6D0*MW**2*sb**2*scth**2-6D0*Ac*Mc*ccth*scth
     &      -8D0*MW**2/CW**2*SW**2*sb**2-5D0*MW**2/CW**2
     &      *SW**2*scth**2+10D0*MW**2/CW**2*SW**2*sb**2*scth
     &      **2
      AAABR(301) = 3D0*MW**2*sb**2*scth**2-3D0*MW**2*sb**4
     &      *scth**2+3D0*Ac*Mc*ccth*scth+4D0*MW**2/CW**2
     &      *SW**2*sb**2-4D0*MW**2/CW**2*SW**2*sb**4-3D0
     &      *Ac*Mc*ccth*sb**2*scth-5D0*MW**2/CW**2*SW**2
     &      *sb**2*scth**2+5D0*MW**2/CW**2*SW**2*sb**4*scth
     &      **2+3D0*Mc*cb*ccth*mue/sb*scth
      AAABR(302) = MW**2*scth**2*(1D0-2D0*sb**2)
      AAABR(303) = MW**2/CW**2*SW**2*(4D0-8D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(304) = MW**2/CW**3*SW**3*(4D0-8D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(305) = Mc-Ac*ccth*scth+cb*ccth*mue/sb*scth
      AAABR(306) = Mq2*scth**2
      AAABR(307) = Mu2*(1D0-scth**2)
      AAABR(308) = MW**2*(1D0-1D0/CW**2-3D0*sb**2+2D0*sb
     &      **4+SW**2/CW**2+3D0*sb**2/CW**2-2D0*sb**4/CW
     &      **2-3D0*SW**2/CW**2*sb**2+2D0*SW**2/CW**2*sb**4)
      AAABR(309) = MW**2*(sb**2-2D0*sb**4-sb**2/CW**2+2D0
     &      *sb**4/CW**2+SW**2/CW**2*sb**2-2D0*SW**2/CW**2
     &      *sb**4)
      AAABR(310) = 3D0*MW**2-MW**2/CW**2+2D0*MH3**2*sa**2
     &      +2D0*MH3**2*sb**2-4D0*MW**2*sa**2-4D0*MW**2*sb
     &      **2+3D0*MW**2/CW**2*SW**2+2D0*MW**2/CW**2*sa
     &      **2+2D0*MW**2/CW**2*sb**2-4D0*MH3**2*sa**2*sb
     &      **2+8D0*MW**2*sa**2*sb**2-4D0*MW**2/CW**2*SW
     &      **2*sa**2-4D0*MW**2/CW**2*SW**2*sb**2-4D0*MW
     &      **2/CW**2*sa**2*sb**2+8D0*MW**2/CW**2*SW**2*sa
     &      **2*sb**2-4D0*MH3**2*ca*cb*sa*sb-4D0*MW**2*ca
     &      *cb*sa*sb-4D0*MW**2/CW**2*SW**2*ca*cb*sa*sb
      AAABR(311) = MH3**2*ca*sa-MH3**2*cb*sb-2D0*MW**2*ca
     &      *sa-MW**2*cb*sb+MW**2/CW**2*ca*sa-2D0*MH3**2
     &      *ca*sa*sb**2+2D0*MH3**2*cb*sa**2*sb+4D0*MW**2
     &      *ca*sa*sb**2+2D0*MW**2*cb*sa**2*sb-2D0*MW**2
     &      /CW**2*SW**2*ca*sa-MW**2/CW**2*SW**2*cb*sb-2D0
     &      *MW**2/CW**2*ca*sa*sb**2+4D0*MW**2/CW**2*SW**2
     &      *ca*sa*sb**2+2D0*MW**2/CW**2*SW**2*cb*sa**2*sb
      AAABR(312) = MW**2*(1D0-sa**2-sb**2+2D0*sa**2*sb**2
     &      -2D0*ca*cb*sa*sb)
      AAABR(313) = MW**2*(3D0-1D0/CW**2-4D0*sa**2-4D0*sb
     &      **2+3D0*SW**2/CW**2+2D0*sa**2/CW**2+2D0*sb**2
     &      /CW**2+8D0*sa**2*sb**2-4D0*SW**2/CW**2*sa**2
     &      -4D0*SW**2/CW**2*sb**2-4D0*sa**2/CW**2*sb**2
     &      +8D0*SW**2/CW**2*sa**2*sb**2-4D0*ca*cb*sa*sb
     &      -4D0*SW**2/CW**2*ca*cb*sa*sb)
      AAABR(314) = MH3**2*sb**2-MH3**2*sb**4-2D0*MW**2*sb
     &      **2+2D0*MW**2*sb**4+MW**2/CW**2*sb**2-MW**2/CW
     &      **2*sb**4-2D0*MH3**2*sa**2*sb**2+2D0*MH3**2*sa
     &      **2*sb**4+4D0*MW**2*sa**2*sb**2-4D0*MW**2*sa
     &      **2*sb**4-2D0*MW**2/CW**2*SW**2*sb**2+2D0*MW
     &      **2/CW**2*SW**2*sb**4-2D0*MW**2/CW**2*sa**2*sb
     &      **2+2D0*MW**2/CW**2*sa**2*sb**4+4D0*MW**2/CW
     &      **2*SW**2*sa**2*sb**2-4D0*MW**2/CW**2*SW**2*sa
     &      **2*sb**4-MH3**2*ca*cb*sa*sb+2D0*MH3**2*ca*cb
     &      *sa*sb**3-MW**2*ca*cb*sa*sb+2D0*MW**2*ca*cb*sa
     &      *sb**3-MW**2/CW**2*SW**2*ca*cb*sa*sb+2D0*MW**2
     &      /CW**2*SW**2*ca*cb*sa*sb**3
      AAABR(315) = MW**2/CW**2*SW**2*(1D0-sa**2-sb**2+2D0
     &      *sa**2*sb**2-2D0*ca*cb*sa*sb)
      AAABR(316) = MW**2/CW**3*SW**3*(1D0-sa**2-sb**2+2D0
     &      *sa**2*sb**2-2D0*ca*cb*sa*sb)
      AAABR(317) = EE/MW/SW*(ca*cb-sa*sb+3D0*sa*sb**3+3D0
     &      *sa**3*sb-4D0*sa**3*sb**3+ca*cb*sa**2+ca*cb*sb
     &      **2-4D0*ca*cb*sa**2*sb**2)
      AAABR(318) = EE/MW/SW*(ca*sb-ca*sb**3-cb*sa+cb*sa**3
     &      -3D0*ca*sa**2*sb+4D0*ca*sa**2*sb**3+3D0*cb*sa
     &      *sb**2-4D0*cb*sa**3*sb**2)
      AAABR(319) = sa**2+sb**2-2D0*sa**2*sb**2-2D0*ca*cb
     &      *sa*sb
      AAABR(320) = 2D0*MH3**2-MW**2+MW**2/CW**2-2D0*MH3**2
     &      *sa**2-2D0*MH3**2*sb**2+4D0*MW**2*sa**2+4D0*MW
     &      **2*sb**2-MW**2/CW**2*SW**2-2D0*MW**2/CW**2*sa
     &      **2-2D0*MW**2/CW**2*sb**2+4D0*MH3**2*sa**2*sb
     &      **2-8D0*MW**2*sa**2*sb**2+4D0*MW**2/CW**2*SW
     &      **2*sa**2+4D0*MW**2/CW**2*SW**2*sb**2+4D0*MW
     &      **2/CW**2*sa**2*sb**2-8D0*MW**2/CW**2*SW**2*sa
     &      **2*sb**2+4D0*MH3**2*ca*cb*sa*sb+4D0*MW**2*ca
     &      *cb*sa*sb+4D0*MW**2/CW**2*SW**2*ca*cb*sa*sb
      AAABR(321) = MW**2*(ca*sa+cb*sb-2D0*ca*sa*sb**2-2D0
     &      *cb*sa**2*sb)
      AAABR(322) = MW**2*(2D0*ca*sa+cb*sb-ca/CW**2*sa-4D0
     &      *ca*sa*sb**2-2D0*cb*sa**2*sb+2D0*SW**2/CW**2
     &      *ca*sa+SW**2/CW**2*cb*sb+2D0*ca/CW**2*sa*sb**2
     &      -4D0*SW**2/CW**2*ca*sa*sb**2-2D0*SW**2/CW**2
     &      *cb*sa**2*sb)
      AAABR(323) = MH3**2*cb*sb-2D0*MH3**2*cb*sb**3+MW**2
     &      *cb*sb-2D0*MW**2*cb*sb**3+4D0*MH3**2*ca*sa*sb
     &      **2-4D0*MH3**2*ca*sa*sb**4-2D0*MH3**2*cb*sa**2
     &      *sb+4D0*MH3**2*cb*sa**2*sb**3-8D0*MW**2*ca*sa
     &      *sb**2+8D0*MW**2*ca*sa*sb**4-2D0*MW**2*cb*sa
     &      **2*sb+4D0*MW**2*cb*sa**2*sb**3+MW**2/CW**2*SW
     &      **2*cb*sb-2D0*MW**2/CW**2*SW**2*cb*sb**3+4D0
     &      *MW**2/CW**2*ca*sa*sb**2-4D0*MW**2/CW**2*ca*sa
     &      *sb**4-8D0*MW**2/CW**2*SW**2*ca*sa*sb**2+8D0
     &      *MW**2/CW**2*SW**2*ca*sa*sb**4-2D0*MW**2/CW**2
     &      *SW**2*cb*sa**2*sb+4D0*MW**2/CW**2*SW**2*cb*sa
     &      **2*sb**3
      AAABR(324) = MW**2/CW**2*SW**2*(ca*sa+cb*sb-2D0*ca
     &      *sa*sb**2-2D0*cb*sa**2*sb)
      AAABR(325) = MW**2/CW**3*SW**3*(ca*sa+cb*sb-2D0*ca
     &      *sa*sb**2-2D0*cb*sa**2*sb)
      AAABR(326) = EE/MW/SW*(ca*sb**3-cb*sa**3+3D0*ca*sa
     &      **2*sb-4D0*ca*sa**2*sb**3-3D0*cb*sa*sb**2+4D0
     &      *cb*sa**3*sb**2)
      AAABR(327) = EE/MW/SW*(ca*cb+3D0*sa*sb-3D0*sa*sb**3
     &      -3D0*sa**3*sb+4D0*sa**3*sb**3-ca*cb*sa**2-ca
     &      *cb*sb**2+4D0*ca*cb*sa**2*sb**2)
      AAABR(328) = ca*sa-cb*sb-2D0*ca*sa*sb**2+2D0*cb*sa
     &      **2*sb
      AAABR(329) = MW**2*(sa**2+sb**2-2D0*sa**2*sb**2+2D0
     &      *ca*cb*sa*sb)
      AAABR(330) = MW**2*(1D0-1D0/CW**2-4D0*sa**2-4D0*sb
     &      **2+SW**2/CW**2+2D0*sa**2/CW**2+2D0*sb**2/CW
     &      **2+8D0*sa**2*sb**2-4D0*SW**2/CW**2*sa**2-4D0
     &      *SW**2/CW**2*sb**2-4D0*sa**2/CW**2*sb**2+8D0
     &      *SW**2/CW**2*sa**2*sb**2-4D0*ca*cb*sa*sb-4D0
     &      *SW**2/CW**2*ca*cb*sa*sb)
      AAABR(331) = MW**2/CW**2*SW**2*(sa**2+sb**2-2D0*sa
     &      **2*sb**2+2D0*ca*cb*sa*sb)
      AAABR(332) = MW**2/CW**3*SW**3*(sa**2+sb**2-2D0*sa
     &      **2*sb**2+2D0*ca*cb*sa*sb)
      AAABR(333) = EE/MW/SW*(2D0*sa*sb-3D0*sa*sb**3-3D0*sa
     &      **3*sb+4D0*sa**3*sb**3-ca*cb*sa**2-ca*cb*sb**2
     &      +4D0*ca*cb*sa**2*sb**2)
      AAABR(334) = EE/MW/SW*(2D0*ca*sb-ca*sb**3-2D0*cb*sa
     &      +cb*sa**3-3D0*ca*sa**2*sb+4D0*ca*sa**2*sb**3
     &      +3D0*cb*sa*sb**2-4D0*cb*sa**3*sb**2)
      AAABR(335) = 1D0-sa**2-sb**2+2D0*sa**2*sb**2+2D0*ca
     &      *cb*sa*sb
      AAABR(336) = MW*cb*sb
      AAABR(337) = MW*cb*sb*(CW+SW**2/CW)
      AAABR(338) = MW*(1D0-sb**2)
      AAABR(339) = MW*sb**2
      AAABR(340) = CW*MW
      AAABR(341) = MW*SW
      AAABR(342) = MW*(CW+SW**2/CW-CW*sb**2-SW**2/CW*sb**2)
      AAABR(343) = MW*(CW+SW**2/CW)
      AAABR(344) = MW*(SW+SW**3/CW**2)
      AAABR(345) = MW*sb**2*(CW+SW**2/CW)
      AAABR(346) = Zp11*Zp12+Zp21*Zp22
      AAABR(347) = Zp12**2+Zp22**2
      AAABR(348) = Zm11*Zm12+Zm21*Zm22
      AAABR(349) = Zm12**2+Zm22**2
      AAABR(350) = MG2*Zm11*Zp12+Zm21*Zp22*mue+MW*Sqrt2*Zm11
     &      *Zp22*sb+MW*Sqrt2*Zm21*Zp12*cb
      AAABR(351) = MG2*Zm12*Zp11+Zm22*Zp21*mue+MW*Sqrt2*Zm12
     &      *Zp21*sb+MW*Sqrt2*Zm22*Zp11*cb
      AAABR(352) = MG2*Zm12*Zp12+Zm22*Zp22*mue+MW*Sqrt2*Zm12
     &      *Zp22*sb+MW*Sqrt2*Zm22*Zp12*cb
      AAABR(353) = MW*Sqrt2*(Zm12*Zp22*sb+Zm22*Zp12*cb)
      AAABR(354) = MW*Sqrt2*(Zm12*Zp22*sb-Zm12*Zp22*sb**3
     &      -Zm22*Zp12*cb*sb**2)
      AAABR(355) = Zm22*Zp22
      AAABR(356) = Zm12*Zp12
      AAABR(357) = Zp11**2+Zp21**2
      AAABR(358) = Zm11**2+Zm21**2
      AAABR(359) = MG2*Zm11*Zp11+Zm21*Zp21*mue+MW*Sqrt2*Zm11
     &      *Zp21*sb+MW*Sqrt2*Zm21*Zp11*cb
      AAABR(360) = MW*Sqrt2*(Zm12*Zp21*sb+Zm22*Zp11*cb)
      AAABR(361) = MW*Sqrt2*(Zm12*Zp21*sb-Zm12*Zp21*sb**3
     &      -Zm22*Zp11*cb*sb**2)
      AAABR(362) = MW*Sqrt2*(Zm11*Zp22*sb+Zm21*Zp12*cb)
      AAABR(363) = MW*Sqrt2*(Zm11*Zp22*sb-Zm11*Zp22*sb**3
     &      -Zm21*Zp12*cb*sb**2)
      AAABR(364) = Zm22*Zp21
      AAABR(365) = Zm21*Zp22
      AAABR(366) = Zm11*Zp12
      AAABR(367) = Zm12*Zp11
      AAABR(368) = MW*Sqrt2*(Zm11*Zp21*sb+Zm21*Zp11*cb)
      AAABR(369) = MW*Sqrt2*(Zm11*Zp21*sb-Zm11*Zp21*sb**3
     &      -Zm21*Zp11*cb*sb**2)
      AAABR(370) = Zm21*Zp21
      AAABR(371) = Zm11*Zp11
      AAABC(1) = Zn11*dconjg(Zn11)+Zn21*dconjg(Zn21)+Zn31
     &      *dconjg(Zn31)+Zn41*dconjg(Zn41)
      AAABC(2) = dconjg(Zn11)*Zn12+dconjg(Zn21)*Zn22+dconjg(Zn31
     &      )*Zn32+dconjg(Zn41)*Zn42
      AAABC(3) = dconjg(Zn11)*Zn13+dconjg(Zn21)*Zn23+dconjg(Zn31
     &      )*Zn33+dconjg(Zn41)*Zn43
      AAABC(4) = dconjg(Zn11)*Zn14+dconjg(Zn21)*Zn24+dconjg(Zn31
     &      )*Zn34+dconjg(Zn41)*Zn44
      AAABC(5) = dconjg(Zn12)*Zn14+dconjg(Zn22)*Zn24+dconjg(Zn32
     &      )*Zn34+dconjg(Zn42)*Zn44
      AAABC(6) = dconjg(Zn13)*Zn14+dconjg(Zn23)*Zn24+dconjg(Zn33
     &      )*Zn34+dconjg(Zn43)*Zn44
      AAABC(7) = Zn14*dconjg(Zn14)+Zn24*dconjg(Zn24)+Zn34
     &      *dconjg(Zn34)+Zn44*dconjg(Zn44)
      AAABC(8) = MG1*Zn11**2+MG2*Zn21**2-2D0*Zn31*Zn41*mue
     &      +2D0*MW*Zn21*Zn31*cb-2D0*MW*Zn21*Zn41*sb-2D0
     &      *MW/CW*SW*Zn11*Zn31*cb+2D0*MW/CW*SW*Zn11*Zn41*sb
      AAABC(9) = MG1*Zn11*Zn12+MG2*Zn21*Zn22-Zn31*Zn42*mue
     &      -Zn32*Zn41*mue+MW*Zn21*Zn32*cb-MW*Zn21*Zn42*sb
     &      +MW*Zn22*Zn31*cb-MW*Zn22*Zn41*sb-MW/CW*SW*Zn11
     &      *Zn32*cb+MW/CW*SW*Zn11*Zn42*sb-MW/CW*SW*Zn12
     &      *Zn31*cb+MW/CW*SW*Zn12*Zn41*sb
      AAABC(10) = MG1*Zn11*Zn13+MG2*Zn21*Zn23-Zn31*Zn43*mue
     &      -Zn33*Zn41*mue+MW*Zn21*Zn33*cb-MW*Zn21*Zn43*sb
     &      +MW*Zn23*Zn31*cb-MW*Zn23*Zn41*sb-MW/CW*SW*Zn11
     &      *Zn33*cb+MW/CW*SW*Zn11*Zn43*sb-MW/CW*SW*Zn13
     &      *Zn31*cb+MW/CW*SW*Zn13*Zn41*sb
      AAABC(11) = MG1*Zn11*Zn14+MG2*Zn21*Zn24-Zn31*Zn44*mue
     &      -Zn34*Zn41*mue+MW*Zn21*Zn34*cb-MW*Zn21*Zn44*sb
     &      +MW*Zn24*Zn31*cb-MW*Zn24*Zn41*sb-MW/CW*SW*Zn11
     &      *Zn34*cb+MW/CW*SW*Zn11*Zn44*sb-MW/CW*SW*Zn14
     &      *Zn31*cb+MW/CW*SW*Zn14*Zn41*sb
      AAABC(12) = MW*(Zn21*Zn34*cb-Zn21*Zn44*sb+Zn24*Zn31
     &      *cb-Zn24*Zn41*sb-SW/CW*Zn11*Zn34*cb+SW/CW*Zn11
     &      *Zn44*sb-SW/CW*Zn14*Zn31*cb+SW/CW*Zn14*Zn41*sb)
      AAABC(13) = MW*(Zn21*Zn44*sb-Zn21*Zn44*sb**3+Zn24*Zn41
     &      *sb-Zn24*Zn41*sb**3+Zn21*Zn34*cb*sb**2+Zn24*Zn31
     &      *cb*sb**2-SW/CW*Zn11*Zn44*sb+SW/CW*Zn11*Zn44
     &      *sb**3-SW/CW*Zn14*Zn41*sb+SW/CW*Zn14*Zn41*sb
     &      **3-SW/CW*Zn11*Zn34*cb*sb**2-SW/CW*Zn14*Zn31
     &      *cb*sb**2)
      AAABC(14) = MG1*Zn12*Zn14+MG2*Zn22*Zn24-Zn32*Zn44*mue
     &      -Zn34*Zn42*mue+MW*Zn22*Zn34*cb-MW*Zn22*Zn44*sb
     &      +MW*Zn24*Zn32*cb-MW*Zn24*Zn42*sb-MW/CW*SW*Zn12
     &      *Zn34*cb+MW/CW*SW*Zn12*Zn44*sb-MW/CW*SW*Zn14
     &      *Zn32*cb+MW/CW*SW*Zn14*Zn42*sb
      AAABC(15) = MG1*Zn13*Zn14+MG2*Zn23*Zn24-Zn33*Zn44*mue
     &      -Zn34*Zn43*mue+MW*Zn23*Zn34*cb-MW*Zn23*Zn44*sb
     &      +MW*Zn24*Zn33*cb-MW*Zn24*Zn43*sb-MW/CW*SW*Zn13
     &      *Zn34*cb+MW/CW*SW*Zn13*Zn44*sb-MW/CW*SW*Zn14
     &      *Zn33*cb+MW/CW*SW*Zn14*Zn43*sb
      AAABC(16) = MG1*Zn14**2+MG2*Zn24**2-2D0*Zn34*Zn44*mue
     &      +2D0*MW*Zn24*Zn34*cb-2D0*MW*Zn24*Zn44*sb-2D0
     &      *MW/CW*SW*Zn14*Zn34*cb+2D0*MW/CW*SW*Zn14*Zn44*sb
      AAABC(17) = MW*(Zn21*Zn34*cb-Zn21*Zn44*sb+Zn24*Zn31
     &      *cb-Zn24*Zn41*sb)
      AAABC(18) = MW/CW*SW*(Zn11*Zn34*cb-Zn11*Zn44*sb+Zn14
     &      *Zn31*cb-Zn14*Zn41*sb)
      AAABC(19) = MW/CW**2*SW**2*(Zn11*Zn34*cb-Zn11*Zn44
     &      *sb+Zn14*Zn31*cb-Zn14*Zn41*sb)
      AAABC(20) = Zn31*Zn44+Zn34*Zn41
      AAABC(21) = Zn11*Zn14
      AAABC(22) = dconjg(Zn21)*dconjg(Zn24)
      AAABC(23) = MW*(Zn21*Zn31*cb-Zn21*Zn41*sb-SW/CW*Zn11
     &      *Zn31*cb+SW/CW*Zn11*Zn41*sb)
      AAABC(24) = MW*(Zn21*Zn41*sb-Zn21*Zn41*sb**3+Zn21*Zn31
     &      *cb*sb**2-SW/CW*Zn11*Zn41*sb+SW/CW*Zn11*Zn41
     &      *sb**3-SW/CW*Zn11*Zn31*cb*sb**2)
      AAABC(25) = MW*Zn21*(Zn31*cb-Zn41*sb)
      AAABC(26) = MW/CW*SW*Zn11*(Zn31*cb-Zn41*sb)
      AAABC(27) = MW/CW**2*SW**2*Zn11*(Zn31*cb-Zn41*sb)
      AAABC(28) = Zn31*Zn41
      AAABC(29) = Zn11**2
      AAABC(30) = dconjg(Zn21)**2
      AAABC(31) = Zn12*dconjg(Zn12)+Zn22*dconjg(Zn22)+Zn32
     &      *dconjg(Zn32)+Zn42*dconjg(Zn42)
      AAABC(32) = dconjg(Zn12)*Zn13+dconjg(Zn22)*Zn23+dconjg(Zn32
     &      )*Zn33+dconjg(Zn42)*Zn43
      AAABC(33) = MW*(Zn21*Zn32*cb-Zn21*Zn42*sb+Zn22*Zn31
     &      *cb-Zn22*Zn41*sb-SW/CW*Zn11*Zn32*cb+SW/CW*Zn11
     &      *Zn42*sb-SW/CW*Zn12*Zn31*cb+SW/CW*Zn12*Zn41*sb)
      AAABC(34) = MW*(Zn21*Zn42*sb-Zn21*Zn42*sb**3+Zn22*Zn41
     &      *sb-Zn22*Zn41*sb**3+Zn21*Zn32*cb*sb**2+Zn22*Zn31
     &      *cb*sb**2-SW/CW*Zn11*Zn42*sb+SW/CW*Zn11*Zn42
     &      *sb**3-SW/CW*Zn12*Zn41*sb+SW/CW*Zn12*Zn41*sb
     &      **3-SW/CW*Zn11*Zn32*cb*sb**2-SW/CW*Zn12*Zn31
     &      *cb*sb**2)
      AAABC(35) = MG1*Zn12**2+MG2*Zn22**2-2D0*Zn32*Zn42*mue
     &      +2D0*MW*Zn22*Zn32*cb-2D0*MW*Zn22*Zn42*sb-2D0
     &      *MW/CW*SW*Zn12*Zn32*cb+2D0*MW/CW*SW*Zn12*Zn42*sb
      AAABC(36) = MG1*Zn12*Zn13+MG2*Zn22*Zn23-Zn32*Zn43*mue
     &      -Zn33*Zn42*mue+MW*Zn22*Zn33*cb-MW*Zn22*Zn43*sb
     &      +MW*Zn23*Zn32*cb-MW*Zn23*Zn42*sb-MW/CW*SW*Zn12
     &      *Zn33*cb+MW/CW*SW*Zn12*Zn43*sb-MW/CW*SW*Zn13
     &      *Zn32*cb+MW/CW*SW*Zn13*Zn42*sb
      AAABC(37) = MW*(Zn21*Zn32*cb-Zn21*Zn42*sb+Zn22*Zn31
     &      *cb-Zn22*Zn41*sb)
      AAABC(38) = MW/CW*SW*(Zn11*Zn32*cb-Zn11*Zn42*sb+Zn12
     &      *Zn31*cb-Zn12*Zn41*sb)
      AAABC(39) = MW/CW**2*SW**2*(Zn11*Zn32*cb-Zn11*Zn42
     &      *sb+Zn12*Zn31*cb-Zn12*Zn41*sb)
      AAABC(40) = Zn31*Zn42+Zn32*Zn41
      AAABC(41) = Zn11*Zn12
      AAABC(42) = dconjg(Zn21)*dconjg(Zn22)
      AAABC(43) = Zn13*dconjg(Zn13)+Zn23*dconjg(Zn23)+Zn33
     &      *dconjg(Zn33)+Zn43*dconjg(Zn43)
      AAABC(44) = MW*(Zn21*Zn33*cb-Zn21*Zn43*sb+Zn23*Zn31
     &      *cb-Zn23*Zn41*sb-SW/CW*Zn11*Zn33*cb+SW/CW*Zn11
     &      *Zn43*sb-SW/CW*Zn13*Zn31*cb+SW/CW*Zn13*Zn41*sb)
      AAABC(45) = MW*(Zn21*Zn43*sb-Zn21*Zn43*sb**3+Zn23*Zn41
     &      *sb-Zn23*Zn41*sb**3+Zn21*Zn33*cb*sb**2+Zn23*Zn31
     &      *cb*sb**2-SW/CW*Zn11*Zn43*sb+SW/CW*Zn11*Zn43
     &      *sb**3-SW/CW*Zn13*Zn41*sb+SW/CW*Zn13*Zn41*sb
     &      **3-SW/CW*Zn11*Zn33*cb*sb**2-SW/CW*Zn13*Zn31
     &      *cb*sb**2)
      AAABC(46) = MG1*Zn13**2+MG2*Zn23**2-2D0*Zn33*Zn43*mue
     &      +2D0*MW*Zn23*Zn33*cb-2D0*MW*Zn23*Zn43*sb-2D0
     &      *MW/CW*SW*Zn13*Zn33*cb+2D0*MW/CW*SW*Zn13*Zn43*sb
      AAABC(47) = MW*(Zn21*Zn33*cb-Zn21*Zn43*sb+Zn23*Zn31
     &      *cb-Zn23*Zn41*sb)
      AAABC(48) = MW/CW*SW*(Zn11*Zn33*cb-Zn11*Zn43*sb+Zn13
     &      *Zn31*cb-Zn13*Zn41*sb)
      AAABC(49) = MW/CW**2*SW**2*(Zn11*Zn33*cb-Zn11*Zn43
     &      *sb+Zn13*Zn31*cb-Zn13*Zn41*sb)
      AAABC(50) = Zn31*Zn43+Zn33*Zn41
      AAABC(51) = Zn11*Zn13
      AAABC(52) = dconjg(Zn21)*dconjg(Zn23)
      AAABC(53) = MW*(Zn22*Zn32*cb-Zn22*Zn42*sb-SW/CW*Zn12
     &      *Zn32*cb+SW/CW*Zn12*Zn42*sb)
      AAABC(54) = MW*(Zn22*Zn42*sb-Zn22*Zn42*sb**3+Zn22*Zn32
     &      *cb*sb**2-SW/CW*Zn12*Zn42*sb+SW/CW*Zn12*Zn42
     &      *sb**3-SW/CW*Zn12*Zn32*cb*sb**2)
      AAABC(55) = MW*Zn22*(Zn32*cb-Zn42*sb)
      AAABC(56) = MW/CW*SW*Zn12*(Zn32*cb-Zn42*sb)
      AAABC(57) = MW/CW**2*SW**2*Zn12*(Zn32*cb-Zn42*sb)
      AAABC(58) = Zn32*Zn42
      AAABC(59) = Zn12**2
      AAABC(60) = dconjg(Zn22)**2
      AAABC(61) = MW*(Zn22*Zn33*cb-Zn22*Zn43*sb+Zn23*Zn32
     &      *cb-Zn23*Zn42*sb-SW/CW*Zn12*Zn33*cb+SW/CW*Zn12
     &      *Zn43*sb-SW/CW*Zn13*Zn32*cb+SW/CW*Zn13*Zn42*sb)
      AAABC(62) = MW*(Zn22*Zn43*sb-Zn22*Zn43*sb**3+Zn23*Zn42
     &      *sb-Zn23*Zn42*sb**3+Zn22*Zn33*cb*sb**2+Zn23*Zn32
     &      *cb*sb**2-SW/CW*Zn12*Zn43*sb+SW/CW*Zn12*Zn43
     &      *sb**3-SW/CW*Zn13*Zn42*sb+SW/CW*Zn13*Zn42*sb
     &      **3-SW/CW*Zn12*Zn33*cb*sb**2-SW/CW*Zn13*Zn32
     &      *cb*sb**2)
      AAABC(63) = MW*(Zn22*Zn33*cb-Zn22*Zn43*sb+Zn23*Zn32
     &      *cb-Zn23*Zn42*sb)
      AAABC(64) = MW/CW*SW*(Zn12*Zn33*cb-Zn12*Zn43*sb+Zn13
     &      *Zn32*cb-Zn13*Zn42*sb)
      AAABC(65) = MW/CW**2*SW**2*(Zn12*Zn33*cb-Zn12*Zn43
     &      *sb+Zn13*Zn32*cb-Zn13*Zn42*sb)
      AAABC(66) = Zn32*Zn43+Zn33*Zn42
      AAABC(67) = Zn12*Zn13
      AAABC(68) = dconjg(Zn22)*dconjg(Zn23)
      AAABC(69) = MW*(Zn22*Zn34*cb-Zn22*Zn44*sb+Zn24*Zn32
     &      *cb-Zn24*Zn42*sb-SW/CW*Zn12*Zn34*cb+SW/CW*Zn12
     &      *Zn44*sb-SW/CW*Zn14*Zn32*cb+SW/CW*Zn14*Zn42*sb)
      AAABC(70) = MW*(Zn22*Zn44*sb-Zn22*Zn44*sb**3+Zn24*Zn42
     &      *sb-Zn24*Zn42*sb**3+Zn22*Zn34*cb*sb**2+Zn24*Zn32
     &      *cb*sb**2-SW/CW*Zn12*Zn44*sb+SW/CW*Zn12*Zn44
     &      *sb**3-SW/CW*Zn14*Zn42*sb+SW/CW*Zn14*Zn42*sb
     &      **3-SW/CW*Zn12*Zn34*cb*sb**2-SW/CW*Zn14*Zn32
     &      *cb*sb**2)
      AAABC(71) = MW*(Zn22*Zn34*cb-Zn22*Zn44*sb+Zn24*Zn32
     &      *cb-Zn24*Zn42*sb)
      AAABC(72) = MW/CW*SW*(Zn12*Zn34*cb-Zn12*Zn44*sb+Zn14
     &      *Zn32*cb-Zn14*Zn42*sb)
      AAABC(73) = MW/CW**2*SW**2*(Zn12*Zn34*cb-Zn12*Zn44
     &      *sb+Zn14*Zn32*cb-Zn14*Zn42*sb)
      AAABC(74) = Zn32*Zn44+Zn34*Zn42
      AAABC(75) = Zn12*Zn14
      AAABC(76) = dconjg(Zn22)*dconjg(Zn24)
      AAABC(77) = MW*(Zn23*Zn33*cb-Zn23*Zn43*sb-SW/CW*Zn13
     &      *Zn33*cb+SW/CW*Zn13*Zn43*sb)
      AAABC(78) = MW*(Zn23*Zn43*sb-Zn23*Zn43*sb**3+Zn23*Zn33
     &      *cb*sb**2-SW/CW*Zn13*Zn43*sb+SW/CW*Zn13*Zn43
     &      *sb**3-SW/CW*Zn13*Zn33*cb*sb**2)
      AAABC(79) = MW*Zn23*(Zn33*cb-Zn43*sb)
      AAABC(80) = MW/CW*SW*Zn13*(Zn33*cb-Zn43*sb)
      AAABC(81) = MW/CW**2*SW**2*Zn13*(Zn33*cb-Zn43*sb)
      AAABC(82) = Zn33*Zn43
      AAABC(83) = Zn13**2
      AAABC(84) = dconjg(Zn23)**2
      AAABC(85) = MW*(Zn23*Zn34*cb-Zn23*Zn44*sb+Zn24*Zn33
     &      *cb-Zn24*Zn43*sb-SW/CW*Zn13*Zn34*cb+SW/CW*Zn13
     &      *Zn44*sb-SW/CW*Zn14*Zn33*cb+SW/CW*Zn14*Zn43*sb)
      AAABC(86) = MW*(Zn23*Zn44*sb-Zn23*Zn44*sb**3+Zn24*Zn43
     &      *sb-Zn24*Zn43*sb**3+Zn23*Zn34*cb*sb**2+Zn24*Zn33
     &      *cb*sb**2-SW/CW*Zn13*Zn44*sb+SW/CW*Zn13*Zn44
     &      *sb**3-SW/CW*Zn14*Zn43*sb+SW/CW*Zn14*Zn43*sb
     &      **3-SW/CW*Zn13*Zn34*cb*sb**2-SW/CW*Zn14*Zn33
     &      *cb*sb**2)
      AAABC(87) = MW*(Zn23*Zn34*cb-Zn23*Zn44*sb+Zn24*Zn33
     &      *cb-Zn24*Zn43*sb)
      AAABC(88) = MW/CW*SW*(Zn13*Zn34*cb-Zn13*Zn44*sb+Zn14
     &      *Zn33*cb-Zn14*Zn43*sb)
      AAABC(89) = MW/CW**2*SW**2*(Zn13*Zn34*cb-Zn13*Zn44
     &      *sb+Zn14*Zn33*cb-Zn14*Zn43*sb)
      AAABC(90) = Zn33*Zn44+Zn34*Zn43
      AAABC(91) = Zn13*Zn14
      AAABC(92) = dconjg(Zn23)*dconjg(Zn24)
      AAABC(93) = MW*(Zn24*Zn34*cb-Zn24*Zn44*sb-SW/CW*Zn14
     &      *Zn34*cb+SW/CW*Zn14*Zn44*sb)
      AAABC(94) = MW*(Zn24*Zn44*sb-Zn24*Zn44*sb**3+Zn24*Zn34
     &      *cb*sb**2-SW/CW*Zn14*Zn44*sb+SW/CW*Zn14*Zn44
     &      *sb**3-SW/CW*Zn14*Zn34*cb*sb**2)
      AAABC(95) = MW*Zn24*(Zn34*cb-Zn44*sb)
      AAABC(96) = MW/CW*SW*Zn14*(Zn34*cb-Zn44*sb)
      AAABC(97) = MW/CW**2*SW**2*Zn14*(Zn34*cb-Zn44*sb)
      AAABC(98) = Zn34*Zn44
      AAABC(99) = Zn14**2
      AAABC(100) = dconjg(Zn24)**2
      AAABR(372) = CW**2
      AAABR(373) = CW*SW
      AAABR(374) = SW**2
      AAABR(375) = CW**2-SW**2
      AAABR(376) = MW**2*(CW**2+SW**2)
      AAABR(377) = MW**2*(SW**3/CW+CW*SW)
      AAABR(378) = MW**2*(CW**2+2D0*SW**2+SW**4/CW**2)
      AAABR(379) = MW**2*(SW**5/CW**3+2D0*SW**3/CW+CW*SW)
      AAABR(380) = EE*MW
      AAABR(381) = EE*MW/SW*nlr
      AAABR(382) = EE*MW/SW*(1D0+nlk)
      AAABR(383) = EE*MW/SW*(nld2-ca*cb-sa*sb)
      AAABR(384) = EE*MW/SW*(nld1+ca*sb-cb*sa)
      AAABR(385) = EE*MW*(SW/CW-CW/SW+nlk/CW/SW)
      AAABR(386) = EE/CW*MW/SW
      AAABR(387) = EE/CW**2*MW/SW*(nle2+ca*cb+sa*sb)
      AAABR(388) = EE/CW**2*MW/SW*(nle1+ca*sb-cb*sa)
      AAABR(389) = EE*nla
      AAABR(390) = CW*EE/SW
      AAABR(391) = CW*EE/SW*nlb
      AAABR(392) = EE*MW*(ca/SW*cb+3D0*sa/SW*sb-2D0*sa/SW
     &      *sb**3-SW/CW**2*ca*cb+SW/CW**2*sa*sb-2D0*SW/CW
     &      **2*sa*sb**3+2D0*ca/SW*cb*sb**2+2D0*SW/CW**2
     &      *ca*cb*sb**2)
      AAABR(393) = EE*MW*(ca/SW*sb-SW/CW**2*ca*sb**3-2D0
     &      *cb/SW*sa*sb**2-SW/CW**2*cb*sa*sb**2)
      AAABR(394) = EE*MW*(3D0*ca/SW*sb-2D0*ca/SW*sb**3-cb
     &      /SW*sa+SW/CW**2*ca*sb-2D0*SW/CW**2*ca*sb**3+SW
     &      /CW**2*cb*sa-2D0*cb/SW*sa*sb**2-2D0*SW/CW**2
     &      *cb*sa*sb**2)
      AAABR(395) = EE*MW*(ca/SW*sb-3D0*ca/SW*sb**3+2D0*ca
     &      /SW*sb**5+SW/CW**2*ca*sb-3D0*SW/CW**2*ca*sb**3
     &      +2D0*SW/CW**2*ca*sb**5-cb/SW*sa*sb**2+2D0*cb
     &      /SW*sa*sb**4-SW/CW**2*cb*sa*sb**2+2D0*SW/CW**2
     &      *cb*sa*sb**4)
      AAABR(396) = EE*MW/SW*(3D0*ca*sb-2D0*ca*sb**3-cb*sa
     &      -2D0*cb*sa*sb**2)
      AAABR(397) = EE*MW*(2D0*ca/SW*sb-2D0*ca/SW*sb**3-cb
     &      /SW*sa+SW/CW**2*ca*sb-SW/CW**2*ca*sb**3+SW/CW
     &      **2*cb*sa-SW/CW**2*cb*sa*sb**2)
      AAABR(398) = EE/CW**2*MW*SW*(ca*sb-2D0*ca*sb**3+cb
     &      *sa-2D0*cb*sa*sb**2)
      AAABR(399) = EE/CW**3*MW*SW**2*(ca*sb-2D0*ca*sb**3
     &      +cb*sa-2D0*cb*sa*sb**2)
      AAABR(400) = EE*MW*(sa/SW*sb-SW/CW**2*sa*sb**3+2D0
     &      *ca/SW*cb*sb**2+SW/CW**2*ca*cb*sb**2)
      AAABR(401) = EE*MW*(sa/SW*sb-3D0*sa/SW*sb**3+2D0*sa
     &      /SW*sb**5+SW/CW**2*sa*sb-3D0*SW/CW**2*sa*sb**3
     &      +2D0*SW/CW**2*sa*sb**5+ca/SW*cb*sb**2-2D0*ca
     &      /SW*cb*sb**4+SW/CW**2*ca*cb*sb**2-2D0*SW/CW**2
     &      *ca*cb*sb**4)
      AAABR(402) = EE*MW/SW*(ca*cb+3D0*sa*sb-2D0*sa*sb**3
     &      +2D0*ca*cb*sb**2)
      AAABR(403) = EE*MW*(ca/SW*cb+2D0*sa/SW*sb-2D0*sa/SW
     &      *sb**3-SW/CW**2*ca*cb+SW/CW**2*sa*sb-SW/CW**2
     &      *sa*sb**3+SW/CW**2*ca*cb*sb**2)
      AAABR(404) = EE/CW**2*MW*SW*(ca*cb-sa*sb+2D0*sa*sb
     &      **3-2D0*ca*cb*sb**2)
      AAABR(405) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb+2D0*sa
     &      *sb**3-2D0*ca*cb*sb**2)
      AAABR(406) = EE*MW/SW
      AAABR(407) = EE*MW/SW*(1D0-sb**2)
      AAABR(408) = EE*MW/SW*sb**2
      AAABR(409) = EE/SW*Sqrt2/cb*(MW*ceth*sb-MW*ceth*sb
     &      **3-Me**2/MW*ceth*sb-Ae/MW*Me*sb*seth)
      AAABR(410) = EE/SW*Sqrt2*(Me/MW*mue*seth-2D0*MW/cb
     &      *ceth*sb+2D0*MW/cb*ceth*sb**3+Me**2/MW/cb*ceth
     &      *sb+Ae/MW*Me/cb*sb*seth)
      AAABR(411) = EE/SW*Sqrt2*(Me/MW*mue*seth+2D0*MW/cb
     &      *ceth*sb-2D0*MW/cb*ceth*sb**3+Me**2/MW/cb*ceth
     &      *sb)
      AAABR(412) = EE/SW*Sqrt2*(MW/cb*ceth*sb-3D0*MW/cb*ceth
     &      *sb**3+2D0*MW/cb*ceth*sb**5-Me/MW*mue*sb**2*seth
     &      -Me**2/MW/cb*ceth*sb**3)
      AAABR(413) = EE*MW/SW*Sqrt2/cb*ceth*(sb-sb**3)
      AAABR(414) = EE/SW*Sqrt2*(Me/MW*ceth*mue+2D0*MW/cb
     &      *sb*seth-2D0*MW/cb*sb**3*seth-Me**2/MW/cb*sb
     &      *seth+Ae/MW*Me/cb*ceth*sb)
      AAABR(415) = EE/SW*Sqrt2*(Me/MW*mue*seth-MW/cb*ceth
     &      *sb+MW/cb*ceth*sb**3)
      AAABR(416) = EE/MW/SW*Sqrt2*(mue*seth+Ae/cb*sb*seth
     &      +2D0*Me/cb*ceth*sb)
      AAABR(417) = EE/MW*Me/SW*Sqrt2*seth
      AAABR(418) = EE/MW*Me/SW*Sqrt2/cb*sb*seth
      AAABR(419) = EE/SW*Sqrt2/cb*(MW*cmuth*sb-MW*cmuth*sb
     &      **3-Mm**2/MW*cmuth*sb-Am/MW*Mm*sb*smuth)
      AAABR(420) = EE/SW*Sqrt2*(Mm/MW*mue*smuth-2D0*MW/cb
     &      *cmuth*sb+2D0*MW/cb*cmuth*sb**3+Mm**2/MW/cb*cmuth
     &      *sb+Am/MW*Mm/cb*sb*smuth)
      AAABR(421) = EE/SW*Sqrt2*(Mm/MW*mue*smuth+2D0*MW/cb
     &      *cmuth*sb-2D0*MW/cb*cmuth*sb**3+Mm**2/MW/cb*cmuth
     &      *sb)
      AAABR(422) = EE/SW*Sqrt2*(MW/cb*cmuth*sb-3D0*MW/cb
     &      *cmuth*sb**3+2D0*MW/cb*cmuth*sb**5-Mm/MW*mue
     &      *sb**2*smuth-Mm**2/MW/cb*cmuth*sb**3)
      AAABR(423) = EE*MW/SW*Sqrt2/cb*cmuth*(sb-sb**3)
      AAABR(424) = EE/SW*Sqrt2*(Mm/MW*cmuth*mue+2D0*MW/cb
     &      *sb*smuth-2D0*MW/cb*sb**3*smuth-Mm**2/MW/cb*sb
     &      *smuth+Am/MW*Mm/cb*cmuth*sb)
      AAABR(425) = EE/SW*Sqrt2*(Mm/MW*mue*smuth-MW/cb*cmuth
     &      *sb+MW/cb*cmuth*sb**3)
      AAABR(426) = EE/MW/SW*Sqrt2*(mue*smuth+Am/cb*sb*smuth
     &      +2D0*Mm/cb*cmuth*sb)
      AAABR(427) = EE/MW*Mm/SW*Sqrt2*smuth
      AAABR(428) = EE/MW*Mm/SW*Sqrt2/cb*sb*smuth
      AAABR(429) = EE/SW*Sqrt2/cb*(MW*clth*sb-MW*clth*sb
     &      **3-Ml**2/MW*clth*sb-Al/MW*Ml*sb*slth)
      AAABR(430) = EE/SW*Sqrt2*(Ml/MW*mue*slth-2D0*MW/cb
     &      *clth*sb+2D0*MW/cb*clth*sb**3+Ml**2/MW/cb*clth
     &      *sb+Al/MW*Ml/cb*sb*slth)
      AAABR(431) = EE/SW*Sqrt2*(Ml/MW*mue*slth+2D0*MW/cb
     &      *clth*sb-2D0*MW/cb*clth*sb**3+Ml**2/MW/cb*clth
     &      *sb)
      AAABR(432) = EE/SW*Sqrt2*(MW/cb*clth*sb-3D0*MW/cb*clth
     &      *sb**3+2D0*MW/cb*clth*sb**5-Ml/MW*mue*sb**2*slth
     &      -Ml**2/MW/cb*clth*sb**3)
      AAABR(433) = EE*MW/SW*Sqrt2/cb*clth*(sb-sb**3)
      AAABR(434) = EE/SW*Sqrt2*(Ml/MW*clth*mue+2D0*MW/cb
     &      *sb*slth-2D0*MW/cb*sb**3*slth-Ml**2/MW/cb*sb
     &      *slth+Al/MW*Ml/cb*clth*sb)
      AAABR(435) = EE/SW*Sqrt2*(Ml/MW*mue*slth-MW/cb*clth
     &      *sb+MW/cb*clth*sb**3)
      AAABR(436) = EE/MW/SW*Sqrt2*(mue*slth+Al/cb*sb*slth
     &      +2D0*Ml/cb*clth*sb)
      AAABR(437) = EE/MW*Ml/SW*Sqrt2*slth
      AAABR(438) = EE/MW*Ml/SW*Sqrt2/cb*sb*slth
      AAABR(439) = EE/SW*Sqrt2/cb*(MW*sb*smuth-MW*sb**3*smuth
     &      -Mm**2/MW*sb*smuth+Am/MW*Mm*cmuth*sb)
      AAABR(440) = EE/SW*Sqrt2*(Mm/MW*cmuth*mue-2D0*MW/cb
     &      *sb*smuth+2D0*MW/cb*sb**3*smuth-Mm**2/MW/cb*sb
     &      *smuth)
      AAABR(441) = EE/SW*Sqrt2*(MW/cb*sb*smuth-3D0*MW/cb
     &      *sb**3*smuth+2D0*MW/cb*sb**5*smuth+Mm/MW*cmuth
     &      *mue*sb**2-Mm**2/MW/cb*sb**3*smuth)
      AAABR(442) = EE*MW/SW*Sqrt2/cb*smuth*(sb-sb**3)
      AAABR(443) = EE/SW*Sqrt2*(Mm/MW*cmuth*mue+MW/cb*sb
     &      *smuth-MW/cb*sb**3*smuth)
      AAABR(444) = EE/MW/SW*Sqrt2*(cmuth*mue+Am/cb*cmuth
     &      *sb-2D0*Mm/cb*sb*smuth)
      AAABR(445) = EE/MW*Mm/SW*Sqrt2*cmuth
      AAABR(446) = EE/MW*Mm/SW*Sqrt2/cb*cmuth*sb
      AAABR(447) = EE/SW*Sqrt2/cb*(MW*sb*slth-MW*sb**3*slth
     &      -Ml**2/MW*sb*slth+Al/MW*Ml*clth*sb)
      AAABR(448) = EE/SW*Sqrt2*(Ml/MW*clth*mue-2D0*MW/cb
     &      *sb*slth+2D0*MW/cb*sb**3*slth-Ml**2/MW/cb*sb
     &      *slth)
      AAABR(449) = EE/SW*Sqrt2*(MW/cb*sb*slth-3D0*MW/cb*sb
     &      **3*slth+2D0*MW/cb*sb**5*slth+Ml/MW*clth*mue
     &      *sb**2-Ml**2/MW/cb*sb**3*slth)
      AAABR(450) = EE*MW/SW*Sqrt2/cb*slth*(sb-sb**3)
      AAABR(451) = EE/SW*Sqrt2*(Ml/MW*clth*mue+MW/cb*sb*slth
     &      -MW/cb*sb**3*slth)
      AAABR(452) = EE/MW/SW*Sqrt2*(clth*mue+Al/cb*clth*sb
     &      -2D0*Ml/cb*sb*slth)
      AAABR(453) = EE/MW*Ml/SW*Sqrt2*clth
      AAABR(454) = EE/MW*Ml/SW*Sqrt2/cb*clth*sb
      AAABR(455) = EE/SW*Sqrt2/cb*(MW*sb*seth-MW*sb**3*seth
     &      -Me**2/MW*sb*seth+Ae/MW*Me*ceth*sb)
      AAABR(456) = EE/SW*Sqrt2*(Me/MW*ceth*mue-2D0*MW/cb
     &      *sb*seth+2D0*MW/cb*sb**3*seth-Me**2/MW/cb*sb
     &      *seth)
      AAABR(457) = EE/SW*Sqrt2*(MW/cb*sb*seth-3D0*MW/cb*sb
     &      **3*seth+2D0*MW/cb*sb**5*seth+Me/MW*ceth*mue
     &      *sb**2-Me**2/MW/cb*sb**3*seth)
      AAABR(458) = EE*MW/SW*Sqrt2/cb*seth*(sb-sb**3)
      AAABR(459) = EE/SW*Sqrt2*(Me/MW*ceth*mue+MW/cb*sb*seth
     &      -MW/cb*sb**3*seth)
      AAABR(460) = EE/MW/SW*Sqrt2*(ceth*mue+Ae/cb*ceth*sb
     &      -2D0*Me/cb*sb*seth)
      AAABR(461) = EE/MW*Me/SW*Sqrt2*ceth
      AAABR(462) = EE/MW*Me/SW*Sqrt2/cb*ceth*sb
      AAABR(463) = EE/SW*Sqrt2*(Mu/MW*cdth*mue*suth-MW/cb
     &      *cdth*cuth*sb+MW/cb*cdth*cuth*sb**3+Md**2/MW
     &      /cb*cdth*cuth*sb+Ad/MW*Md/cb*cuth*sb*sdth+Md
     &      /MW*Mu/cb*sb*sdth*suth)
      AAABR(464) = EE/SW*Sqrt2*(Md/MW*cuth*mue*sdth+Mu/MW
     &      *cdth*mue*suth-2D0*MW/cb*cdth*cuth*sb+2D0*MW
     &      /cb*cdth*cuth*sb**3+Md**2/MW/cb*cdth*cuth*sb
     &      +Mu**2/MW/cb*cdth*cuth/sb-Mu**2/MW/cb*cdth*cuth
     &      *sb+Ad/MW*Md/cb*cuth*sb*sdth+Au/MW*Mu/cb*cdth
     &      /sb*suth-Au/MW*Mu/cb*cdth*sb*suth+Md/MW*Mu/cb
     &      /sb*sdth*suth)
      AAABR(465) = EE/SW*Sqrt2*(Md/MW*cuth*mue*sdth+Mu/MW
     &      *cdth*mue*suth+2D0*MW/cb*cdth*cuth*sb-2D0*MW
     &      /cb*cdth*cuth*sb**3+Md**2/MW/cb*cdth*cuth*sb
     &      +Mu**2/MW/cb*cdth*cuth/sb-Mu**2/MW/cb*cdth*cuth
     &      *sb+Md/MW*Mu/cb/sb*sdth*suth)
      AAABR(466) = EE/SW*Sqrt2*(Mu/MW*cdth*mue*suth+MW/cb
     &      *cdth*cuth*sb-3D0*MW/cb*cdth*cuth*sb**3+2D0*MW
     &      /cb*cdth*cuth*sb**5-Md/MW*cuth*mue*sb**2*sdth
     &      -Md**2/MW/cb*cdth*cuth*sb**3-Mu/MW*cdth*mue*sb
     &      **2*suth+Mu**2/MW/cb*cdth*cuth/sb-2D0*Mu**2/MW
     &      /cb*cdth*cuth*sb+Mu**2/MW/cb*cdth*cuth*sb**3
     &      +Md/MW*Mu/cb/sb*sdth*suth-2D0*Md/MW*Mu/cb*sb
     &      *sdth*suth)
      AAABR(467) = EE*MW/SW*Sqrt2/cb*cdth*cuth*(sb-sb**3)
      AAABR(468) = EE/SW*Sqrt2*(Md/MW*cdth*cuth*mue-Mu/MW
     &      *mue*sdth*suth+2D0*MW/cb*cuth*sb*sdth-2D0*MW
     &      /cb*cuth*sb**3*sdth-Md**2/MW/cb*cuth*sb*sdth
     &      -Mu**2/MW/cb*cuth/sb*sdth+Mu**2/MW/cb*cuth*sb
     &      *sdth+Ad/MW*Md/cb*cdth*cuth*sb-Au/MW*Mu/cb/sb
     &      *sdth*suth+Au/MW*Mu/cb*sb*sdth*suth+Md/MW*Mu
     &      /cb*cdth/sb*suth)
      AAABR(469) = EE/SW*Sqrt2*(Md/MW*mue*sdth*suth-Mu/MW
     &      *cdth*cuth*mue-2D0*MW/cb*cdth*sb*suth+2D0*MW
     &      /cb*cdth*sb**3*suth+Md**2/MW/cb*cdth*sb*suth
     &      +Mu**2/MW/cb*cdth/sb*suth-Mu**2/MW/cb*cdth*sb
     &      *suth+Ad/MW*Md/cb*sb*sdth*suth-Au/MW*Mu/cb*cdth
     &      *cuth/sb+Au/MW*Mu/cb*cdth*cuth*sb-Md/MW*Mu/cb
     &      *cuth/sb*sdth)
      AAABR(470) = EE/SW*Sqrt2*(Md/MW*cuth*mue*sdth-MW/cb
     &      *cdth*cuth*sb+MW/cb*cdth*cuth*sb**3+Mu**2/MW
     &      /cb*cdth*cuth/sb-Mu**2/MW/cb*cdth*cuth*sb+Au
     &      /MW*Mu/cb*cdth/sb*suth-Au/MW*Mu/cb*cdth*sb*suth
     &      +Md/MW*Mu/cb/sb*sdth*suth-Md/MW*Mu/cb*sb*sdth
     &      *suth)
      AAABR(471) = EE/MW/SW*Sqrt2*(cuth*mue*sdth+Ad/cb*cuth
     &      *sb*sdth+2D0*Md/cb*cdth*cuth*sb+Mu/cb/sb*sdth
     &      *suth)
      AAABR(472) = EE/MW/SW*Sqrt2*(Md*cuth*sdth+Mu*cdth*suth
     &      )
      AAABR(473) = EE/MW/SW*Sqrt2*(cdth*mue*suth+Au/cb*cdth
     &      /sb*suth-Au/cb*cdth*sb*suth+Md/cb/sb*sdth*suth
     &      +2D0*Mu/cb*cdth*cuth/sb-2D0*Mu/cb*cdth*cuth*sb)
      AAABR(474) = EE/MW*Mu/SW*Sqrt2/cb*cdth*suth*(1D0/sb
     &      -sb)
      AAABR(475) = EE/MW*Md/SW*Sqrt2/cb*cuth*sb*sdth
      AAABR(476) = EE/SW*Sqrt2*(Mt/MW*cbth*mue*stth-MW/cb
     &      *cbth*ctth*sb+MW/cb*cbth*ctth*sb**3+Mb**2/MW
     &      /cb*cbth*ctth*sb+Ab/MW*Mb/cb*ctth*sb*sbth+Mb
     &      /MW*Mt/cb*sb*sbth*stth)
      AAABR(477) = EE/SW*Sqrt2*(Mb/MW*ctth*mue*sbth+Mt/MW
     &      *cbth*mue*stth-2D0*MW/cb*cbth*ctth*sb+2D0*MW
     &      /cb*cbth*ctth*sb**3+Mb**2/MW/cb*cbth*ctth*sb
     &      +Mt**2/MW/cb*cbth*ctth/sb-Mt**2/MW/cb*cbth*ctth
     &      *sb+Ab/MW*Mb/cb*ctth*sb*sbth+At/MW*Mt/cb*cbth
     &      /sb*stth-At/MW*Mt/cb*cbth*sb*stth+Mb/MW*Mt/cb
     &      /sb*sbth*stth)
      AAABR(478) = EE/SW*Sqrt2*(Mb/MW*ctth*mue*sbth+Mt/MW
     &      *cbth*mue*stth+2D0*MW/cb*cbth*ctth*sb-2D0*MW
     &      /cb*cbth*ctth*sb**3+Mb**2/MW/cb*cbth*ctth*sb
     &      +Mt**2/MW/cb*cbth*ctth/sb-Mt**2/MW/cb*cbth*ctth
     &      *sb+Mb/MW*Mt/cb/sb*sbth*stth)
      AAABR(479) = EE/SW*Sqrt2*(Mt/MW*cbth*mue*stth+MW/cb
     &      *cbth*ctth*sb-3D0*MW/cb*cbth*ctth*sb**3+2D0*MW
     &      /cb*cbth*ctth*sb**5-Mb/MW*ctth*mue*sb**2*sbth
     &      -Mb**2/MW/cb*cbth*ctth*sb**3-Mt/MW*cbth*mue*sb
     &      **2*stth+Mt**2/MW/cb*cbth*ctth/sb-2D0*Mt**2/MW
     &      /cb*cbth*ctth*sb+Mt**2/MW/cb*cbth*ctth*sb**3
     &      +Mb/MW*Mt/cb/sb*sbth*stth-2D0*Mb/MW*Mt/cb*sb
     &      *sbth*stth)
      AAABR(480) = EE*MW/SW*Sqrt2/cb*cbth*ctth*(sb-sb**3)
      AAABR(481) = EE/SW*Sqrt2*(Mb/MW*cbth*ctth*mue-Mt/MW
     &      *mue*sbth*stth+2D0*MW/cb*ctth*sb*sbth-2D0*MW
     &      /cb*ctth*sb**3*sbth-Mb**2/MW/cb*ctth*sb*sbth
     &      -Mt**2/MW/cb*ctth/sb*sbth+Mt**2/MW/cb*ctth*sb
     &      *sbth+Ab/MW*Mb/cb*cbth*ctth*sb-At/MW*Mt/cb/sb
     &      *sbth*stth+At/MW*Mt/cb*sb*sbth*stth+Mb/MW*Mt
     &      /cb*cbth/sb*stth)
      AAABR(482) = EE/SW*Sqrt2*(Mb/MW*mue*sbth*stth-Mt/MW
     &      *cbth*ctth*mue-2D0*MW/cb*cbth*sb*stth+2D0*MW
     &      /cb*cbth*sb**3*stth+Mb**2/MW/cb*cbth*sb*stth
     &      +Mt**2/MW/cb*cbth/sb*stth-Mt**2/MW/cb*cbth*sb
     &      *stth+Ab/MW*Mb/cb*sb*sbth*stth-At/MW*Mt/cb*cbth
     &      *ctth/sb+At/MW*Mt/cb*cbth*ctth*sb-Mb/MW*Mt/cb
     &      *ctth/sb*sbth)
      AAABR(483) = EE/SW*Sqrt2*(Mb/MW*ctth*mue*sbth-MW/cb
     &      *cbth*ctth*sb+MW/cb*cbth*ctth*sb**3+Mt**2/MW
     &      /cb*cbth*ctth/sb-Mt**2/MW/cb*cbth*ctth*sb+At
     &      /MW*Mt/cb*cbth/sb*stth-At/MW*Mt/cb*cbth*sb*stth
     &      +Mb/MW*Mt/cb/sb*sbth*stth-Mb/MW*Mt/cb*sb*sbth
     &      *stth)
      AAABR(484) = EE/MW/SW*Sqrt2*(ctth*mue*sbth+Ab/cb*ctth
     &      *sb*sbth+2D0*Mb/cb*cbth*ctth*sb+Mt/cb/sb*sbth
     &      *stth)
      AAABR(485) = EE/MW/SW*Sqrt2*(Mb*ctth*sbth+Mt*cbth*stth
     &      )
      AAABR(486) = EE/MW/SW*Sqrt2*(cbth*mue*stth+At/cb*cbth
     &      /sb*stth-At/cb*cbth*sb*stth+Mb/cb/sb*sbth*stth
     &      +2D0*Mt/cb*cbth*ctth/sb-2D0*Mt/cb*cbth*ctth*sb)
      AAABR(487) = EE/MW*Mt/SW*Sqrt2/cb*cbth*stth*(1D0/sb
     &      -sb)
      AAABR(488) = EE/MW*Mb/SW*Sqrt2/cb*ctth*sb*sbth
      AAABR(489) = EE/SW*Sqrt2*(Mc/MW*csth*mue*scth-MW/cb
     &      *ccth*csth*sb+MW/cb*ccth*csth*sb**3+Ms**2/MW
     &      /cb*ccth*csth*sb+As/MW*Ms/cb*ccth*sb*ssth+Mc
     &      /MW*Ms/cb*sb*scth*ssth)
      AAABR(490) = EE/SW*Sqrt2*(Mc/MW*csth*mue*scth+Ms/MW
     &      *ccth*mue*ssth-2D0*MW/cb*ccth*csth*sb+2D0*MW
     &      /cb*ccth*csth*sb**3+Mc**2/MW/cb*ccth*csth/sb
     &      -Mc**2/MW/cb*ccth*csth*sb+Ms**2/MW/cb*ccth*csth
     &      *sb+Ac/MW*Mc/cb*csth/sb*scth-Ac/MW*Mc/cb*csth
     &      *sb*scth+As/MW*Ms/cb*ccth*sb*ssth+Mc/MW*Ms/cb
     &      /sb*scth*ssth)
      AAABR(491) = EE/SW*Sqrt2*(Mc/MW*csth*mue*scth+Ms/MW
     &      *ccth*mue*ssth+2D0*MW/cb*ccth*csth*sb-2D0*MW
     &      /cb*ccth*csth*sb**3+Mc**2/MW/cb*ccth*csth/sb
     &      -Mc**2/MW/cb*ccth*csth*sb+Ms**2/MW/cb*ccth*csth
     &      *sb+Mc/MW*Ms/cb/sb*scth*ssth)
      AAABR(492) = EE/SW*Sqrt2*(Mc/MW*csth*mue*scth+MW/cb
     &      *ccth*csth*sb-3D0*MW/cb*ccth*csth*sb**3+2D0*MW
     &      /cb*ccth*csth*sb**5-Mc/MW*csth*mue*sb**2*scth
     &      +Mc**2/MW/cb*ccth*csth/sb-2D0*Mc**2/MW/cb*ccth
     &      *csth*sb+Mc**2/MW/cb*ccth*csth*sb**3-Ms/MW*ccth
     &      *mue*sb**2*ssth-Ms**2/MW/cb*ccth*csth*sb**3+Mc
     &      /MW*Ms/cb/sb*scth*ssth-2D0*Mc/MW*Ms/cb*sb*scth
     &      *ssth)
      AAABR(493) = EE*MW/SW*Sqrt2/cb*ccth*csth*(sb-sb**3)
      AAABR(494) = EE/SW*Sqrt2*(Mc/MW*mue*scth*ssth-Ms/MW
     &      *ccth*csth*mue-2D0*MW/cb*ccth*sb*ssth+2D0*MW
     &      /cb*ccth*sb**3*ssth+Mc**2/MW/cb*ccth/sb*ssth
     &      -Mc**2/MW/cb*ccth*sb*ssth+Ms**2/MW/cb*ccth*sb
     &      *ssth+Ac/MW*Mc/cb/sb*scth*ssth-Ac/MW*Mc/cb*sb
     &      *scth*ssth-As/MW*Ms/cb*ccth*csth*sb-Mc/MW*Ms
     &      /cb*csth/sb*scth)
      AAABR(495) = EE/SW*Sqrt2*(Mc/MW*ccth*csth*mue-Ms/MW
     &      *mue*scth*ssth+2D0*MW/cb*csth*sb*scth-2D0*MW
     &      /cb*csth*sb**3*scth-Mc**2/MW/cb*csth/sb*scth
     &      +Mc**2/MW/cb*csth*sb*scth-Ms**2/MW/cb*csth*sb
     &      *scth+Ac/MW*Mc/cb*ccth*csth/sb-Ac/MW*Mc/cb*ccth
     &      *csth*sb-As/MW*Ms/cb*sb*scth*ssth+Mc/MW*Ms/cb
     &      *ccth/sb*ssth)
      AAABR(496) = EE/SW*Sqrt2*(Ms/MW*ccth*mue*ssth-MW/cb
     &      *ccth*csth*sb+MW/cb*ccth*csth*sb**3+Mc**2/MW
     &      /cb*ccth*csth/sb-Mc**2/MW/cb*ccth*csth*sb+Ac
     &      /MW*Mc/cb*csth/sb*scth-Ac/MW*Mc/cb*csth*sb*scth
     &      +Mc/MW*Ms/cb/sb*scth*ssth-Mc/MW*Ms/cb*sb*scth
     &      *ssth)
      AAABR(497) = EE/MW/SW*Sqrt2*(ccth*mue*ssth+As/cb*ccth
     &      *sb*ssth+Mc/cb/sb*scth*ssth+2D0*Ms/cb*ccth*csth
     &      *sb)
      AAABR(498) = EE/MW/SW*Sqrt2*(Mc*csth*scth+Ms*ccth*ssth
     &      )
      AAABR(499) = EE/MW/SW*Sqrt2*(csth*mue*scth+Ac/cb*csth
     &      /sb*scth-Ac/cb*csth*sb*scth+2D0*Mc/cb*ccth*csth
     &      /sb-2D0*Mc/cb*ccth*csth*sb+Ms/cb/sb*scth*ssth)
      AAABR(500) = EE/MW*Mc/SW*Sqrt2/cb*csth*scth*(1D0/sb
     &      -sb)
      AAABR(501) = EE/MW*Ms/SW*Sqrt2/cb*ccth*sb*ssth
      AAABR(502) = EE/SW*Sqrt2*(Mt/MW*mue*sbth*stth-MW/cb
     &      *ctth*sb*sbth+MW/cb*ctth*sb**3*sbth+Mb**2/MW
     &      /cb*ctth*sb*sbth-Ab/MW*Mb/cb*cbth*ctth*sb-Mb
     &      /MW*Mt/cb*cbth*sb*stth)
      AAABR(503) = EE/SW*Sqrt2*(Mb/MW*cbth*ctth*mue-Mt/MW
     &      *mue*sbth*stth-2D0*MW/cb*ctth*sb*sbth+2D0*MW
     &      /cb*ctth*sb**3*sbth-Mb**2/MW/cb*ctth*sb*sbth
     &      -Mt**2/MW/cb*ctth/sb*sbth+Mt**2/MW/cb*ctth*sb
     &      *sbth+Mb/MW*Mt/cb*cbth/sb*stth)
      AAABR(504) = EE/SW*Sqrt2*(Mt/MW*mue*sbth*stth+MW/cb
     &      *ctth*sb*sbth-3D0*MW/cb*ctth*sb**3*sbth+2D0*MW
     &      /cb*ctth*sb**5*sbth+Mb/MW*cbth*ctth*mue*sb**2
     &      -Mb**2/MW/cb*ctth*sb**3*sbth-Mt/MW*mue*sb**2
     &      *sbth*stth+Mt**2/MW/cb*ctth/sb*sbth-2D0*Mt**2
     &      /MW/cb*ctth*sb*sbth+Mt**2/MW/cb*ctth*sb**3*sbth
     &      -Mb/MW*Mt/cb*cbth/sb*stth+2D0*Mb/MW*Mt/cb*cbth
     &      *sb*stth)
      AAABR(505) = EE*MW/SW*Sqrt2/cb*ctth*sbth*(sb-sb**3)
      AAABR(506) = EE/SW*Sqrt2*(Mb/MW*cbth*mue*stth+Mt/MW
     &      *ctth*mue*sbth+2D0*MW/cb*sb*sbth*stth-2D0*MW
     &      /cb*sb**3*sbth*stth-Mb**2/MW/cb*sb*sbth*stth
     &      -Mt**2/MW/cb/sb*sbth*stth+Mt**2/MW/cb*sb*sbth
     &      *stth+Ab/MW*Mb/cb*cbth*sb*stth+At/MW*Mt/cb*ctth
     &      /sb*sbth-At/MW*Mt/cb*ctth*sb*sbth-Mb/MW*Mt/cb
     &      *cbth*ctth/sb)
      AAABR(507) = EE/SW*Sqrt2*(Mb/MW*cbth*ctth*mue+MW/cb
     &      *ctth*sb*sbth-MW/cb*ctth*sb**3*sbth-Mt**2/MW
     &      /cb*ctth/sb*sbth+Mt**2/MW/cb*ctth*sb*sbth-At
     &      /MW*Mt/cb/sb*sbth*stth+At/MW*Mt/cb*sb*sbth*stth
     &      +Mb/MW*Mt/cb*cbth/sb*stth-Mb/MW*Mt/cb*cbth*sb
     &      *stth)
      AAABR(508) = EE/MW/SW*Sqrt2*(cbth*ctth*mue+Ab/cb*cbth
     &      *ctth*sb-2D0*Mb/cb*ctth*sb*sbth+Mt/cb*cbth/sb
     &      *stth)
      AAABR(509) = EE/MW/SW*Sqrt2*(Mb*cbth*ctth-Mt*sbth*stth
     &      )
      AAABR(510) = EE/MW/SW*Sqrt2*(mue*sbth*stth+At/cb/sb
     &      *sbth*stth-At/cb*sb*sbth*stth-Mb/cb*cbth/sb*stth
     &      +2D0*Mt/cb*ctth/sb*sbth-2D0*Mt/cb*ctth*sb*sbth)
      AAABR(511) = EE/MW*Mt/SW*Sqrt2/cb*sbth*stth*(1D0/sb
     &      -sb)
      AAABR(512) = EE/MW*Mb/SW*Sqrt2/cb*cbth*ctth*sb
      AAABR(513) = EE/SW*Sqrt2*(Mc/MW*mue*scth*ssth-MW/cb
     &      *ccth*sb*ssth+MW/cb*ccth*sb**3*ssth+Ms**2/MW
     &      /cb*ccth*sb*ssth-As/MW*Ms/cb*ccth*csth*sb-Mc
     &      /MW*Ms/cb*csth*sb*scth)
      AAABR(514) = EE/SW*Sqrt2*(Mc/MW*mue*scth*ssth-Ms/MW
     &      *ccth*csth*mue+2D0*MW/cb*ccth*sb*ssth-2D0*MW
     &      /cb*ccth*sb**3*ssth+Mc**2/MW/cb*ccth/sb*ssth
     &      -Mc**2/MW/cb*ccth*sb*ssth+Ms**2/MW/cb*ccth*sb
     &      *ssth-Mc/MW*Ms/cb*csth/sb*scth)
      AAABR(515) = EE/SW*Sqrt2*(Mc/MW*mue*scth*ssth+MW/cb
     &      *ccth*sb*ssth-3D0*MW/cb*ccth*sb**3*ssth+2D0*MW
     &      /cb*ccth*sb**5*ssth-Mc/MW*mue*sb**2*scth*ssth
     &      +Mc**2/MW/cb*ccth/sb*ssth-2D0*Mc**2/MW/cb*ccth
     &      *sb*ssth+Mc**2/MW/cb*ccth*sb**3*ssth+Ms/MW*ccth
     &      *csth*mue*sb**2-Ms**2/MW/cb*ccth*sb**3*ssth-Mc
     &      /MW*Ms/cb*csth/sb*scth+2D0*Mc/MW*Ms/cb*csth*sb
     &      *scth)
      AAABR(516) = EE*MW/SW*Sqrt2/cb*ccth*ssth*(sb-sb**3)
      AAABR(517) = EE/SW*Sqrt2*(Mc/MW*ccth*mue*ssth+Ms/MW
     &      *csth*mue*scth+2D0*MW/cb*sb*scth*ssth-2D0*MW
     &      /cb*sb**3*scth*ssth-Mc**2/MW/cb/sb*scth*ssth
     &      +Mc**2/MW/cb*sb*scth*ssth-Ms**2/MW/cb*sb*scth
     &      *ssth+Ac/MW*Mc/cb*ccth/sb*ssth-Ac/MW*Mc/cb*ccth
     &      *sb*ssth+As/MW*Ms/cb*csth*sb*scth-Mc/MW*Ms/cb
     &      *ccth*csth/sb)
      AAABR(518) = EE/SW*Sqrt2*(Ms/MW*ccth*csth*mue+MW/cb
     &      *ccth*sb*ssth-MW/cb*ccth*sb**3*ssth-Mc**2/MW
     &      /cb*ccth/sb*ssth+Mc**2/MW/cb*ccth*sb*ssth-Ac
     &      /MW*Mc/cb/sb*scth*ssth+Ac/MW*Mc/cb*sb*scth*ssth
     &      +Mc/MW*Ms/cb*csth/sb*scth-Mc/MW*Ms/cb*csth*sb
     &      *scth)
      AAABR(519) = EE/MW/SW*Sqrt2*(ccth*csth*mue+As/cb*ccth
     &      *csth*sb+Mc/cb*csth/sb*scth-2D0*Ms/cb*ccth*sb
     &      *ssth)
      AAABR(520) = EE/MW/SW*Sqrt2*(Mc*scth*ssth-Ms*ccth*csth
     &      )
      AAABR(521) = EE/MW/SW*Sqrt2*(mue*scth*ssth+Ac/cb/sb
     &      *scth*ssth-Ac/cb*sb*scth*ssth+2D0*Mc/cb*ccth
     &      /sb*ssth-2D0*Mc/cb*ccth*sb*ssth-Ms/cb*csth/sb
     &      *scth)
      AAABR(522) = EE/MW*Mc/SW*Sqrt2/cb*scth*ssth*(1D0/sb
     &      -sb)
      AAABR(523) = EE/MW*Ms/SW*Sqrt2/cb*ccth*csth*sb
      AAABR(524) = EE/SW*Sqrt2*(Mu/MW*mue*sdth*suth-MW/cb
     &      *cuth*sb*sdth+MW/cb*cuth*sb**3*sdth+Md**2/MW
     &      /cb*cuth*sb*sdth-Ad/MW*Md/cb*cdth*cuth*sb-Md
     &      /MW*Mu/cb*cdth*sb*suth)
      AAABR(525) = EE/SW*Sqrt2*(Md/MW*cdth*cuth*mue-Mu/MW
     &      *mue*sdth*suth-2D0*MW/cb*cuth*sb*sdth+2D0*MW
     &      /cb*cuth*sb**3*sdth-Md**2/MW/cb*cuth*sb*sdth
     &      -Mu**2/MW/cb*cuth/sb*sdth+Mu**2/MW/cb*cuth*sb
     &      *sdth+Md/MW*Mu/cb*cdth/sb*suth)
      AAABR(526) = EE/SW*Sqrt2*(Mu/MW*mue*sdth*suth+MW/cb
     &      *cuth*sb*sdth-3D0*MW/cb*cuth*sb**3*sdth+2D0*MW
     &      /cb*cuth*sb**5*sdth+Md/MW*cdth*cuth*mue*sb**2
     &      -Md**2/MW/cb*cuth*sb**3*sdth-Mu/MW*mue*sb**2
     &      *sdth*suth+Mu**2/MW/cb*cuth/sb*sdth-2D0*Mu**2
     &      /MW/cb*cuth*sb*sdth+Mu**2/MW/cb*cuth*sb**3*sdth
     &      -Md/MW*Mu/cb*cdth/sb*suth+2D0*Md/MW*Mu/cb*cdth
     &      *sb*suth)
      AAABR(527) = EE*MW/SW*Sqrt2/cb*cuth*sdth*(sb-sb**3)
      AAABR(528) = EE/SW*Sqrt2*(Md/MW*cdth*mue*suth+Mu/MW
     &      *cuth*mue*sdth+2D0*MW/cb*sb*sdth*suth-2D0*MW
     &      /cb*sb**3*sdth*suth-Md**2/MW/cb*sb*sdth*suth
     &      -Mu**2/MW/cb/sb*sdth*suth+Mu**2/MW/cb*sb*sdth
     &      *suth+Ad/MW*Md/cb*cdth*sb*suth+Au/MW*Mu/cb*cuth
     &      /sb*sdth-Au/MW*Mu/cb*cuth*sb*sdth-Md/MW*Mu/cb
     &      *cdth*cuth/sb)
      AAABR(529) = EE/SW*Sqrt2*(Md/MW*cdth*cuth*mue+MW/cb
     &      *cuth*sb*sdth-MW/cb*cuth*sb**3*sdth-Mu**2/MW
     &      /cb*cuth/sb*sdth+Mu**2/MW/cb*cuth*sb*sdth-Au
     &      /MW*Mu/cb/sb*sdth*suth+Au/MW*Mu/cb*sb*sdth*suth
     &      +Md/MW*Mu/cb*cdth/sb*suth-Md/MW*Mu/cb*cdth*sb
     &      *suth)
      AAABR(530) = EE/MW/SW*Sqrt2*(cdth*cuth*mue+Ad/cb*cdth
     &      *cuth*sb-2D0*Md/cb*cuth*sb*sdth+Mu/cb*cdth/sb
     &      *suth)
      AAABR(531) = EE/MW/SW*Sqrt2*(Md*cdth*cuth-Mu*sdth*suth
     &      )
      AAABR(532) = EE/MW/SW*Sqrt2*(mue*sdth*suth+Au/cb/sb
     &      *sdth*suth-Au/cb*sb*sdth*suth-Md/cb*cdth/sb*suth
     &      +2D0*Mu/cb*cuth/sb*sdth-2D0*Mu/cb*cuth*sb*sdth)
      AAABR(533) = EE/MW*Mu/SW*Sqrt2/cb*sdth*suth*(1D0/sb
     &      -sb)
      AAABR(534) = EE/MW*Md/SW*Sqrt2/cb*cdth*cuth*sb
      AAABR(535) = EE/SW*Sqrt2*(Mt/MW*cbth*ctth*mue+MW/cb
     &      *cbth*sb*stth-MW/cb*cbth*sb**3*stth-Mb**2/MW
     &      /cb*cbth*sb*stth-Ab/MW*Mb/cb*sb*sbth*stth+Mb
     &      /MW*Mt/cb*ctth*sb*sbth)
      AAABR(536) = EE/SW*Sqrt2*(Mb/MW*mue*sbth*stth-Mt/MW
     &      *cbth*ctth*mue+2D0*MW/cb*cbth*sb*stth-2D0*MW
     &      /cb*cbth*sb**3*stth+Mb**2/MW/cb*cbth*sb*stth
     &      +Mt**2/MW/cb*cbth/sb*stth-Mt**2/MW/cb*cbth*sb
     &      *stth-Mb/MW*Mt/cb*ctth/sb*sbth)
      AAABR(537) = EE/SW*Sqrt2*(Mt/MW*cbth*ctth*mue-MW/cb
     &      *cbth*sb*stth+3D0*MW/cb*cbth*sb**3*stth-2D0*MW
     &      /cb*cbth*sb**5*stth+Mb/MW*mue*sb**2*sbth*stth
     &      +Mb**2/MW/cb*cbth*sb**3*stth-Mt/MW*cbth*ctth
     &      *mue*sb**2-Mt**2/MW/cb*cbth/sb*stth+2D0*Mt**2
     &      /MW/cb*cbth*sb*stth-Mt**2/MW/cb*cbth*sb**3*stth
     &      +Mb/MW*Mt/cb*ctth/sb*sbth-2D0*Mb/MW*Mt/cb*ctth
     &      *sb*sbth)
      AAABR(538) = EE*MW/SW*Sqrt2/cb*cbth*stth*(sb-sb**3)
      AAABR(539) = EE/SW*Sqrt2*(Mb/MW*mue*sbth*stth-MW/cb
     &      *cbth*sb*stth+MW/cb*cbth*sb**3*stth+Mt**2/MW
     &      /cb*cbth/sb*stth-Mt**2/MW/cb*cbth*sb*stth-At
     &      /MW*Mt/cb*cbth*ctth/sb+At/MW*Mt/cb*cbth*ctth
     &      *sb-Mb/MW*Mt/cb*ctth/sb*sbth+Mb/MW*Mt/cb*ctth
     &      *sb*sbth)
      AAABR(540) = EE/MW/SW*Sqrt2*(mue*sbth*stth+Ab/cb*sb
     &      *sbth*stth+2D0*Mb/cb*cbth*sb*stth-Mt/cb*ctth
     &      /sb*sbth)
      AAABR(541) = EE/MW/SW*Sqrt2*(Mb*sbth*stth-Mt*cbth*ctth
     &      )
      AAABR(542) = EE/MW/SW*Sqrt2*(cbth*ctth*mue+At/cb*cbth
     &      *ctth/sb-At/cb*cbth*ctth*sb+Mb/cb*ctth/sb*sbth
     &      -2D0*Mt/cb*cbth/sb*stth+2D0*Mt/cb*cbth*sb*stth)
      AAABR(543) = EE/MW*Mt/SW*Sqrt2/cb*cbth*ctth*(1D0/sb
     &      -sb)
      AAABR(544) = EE/MW*Mb/SW*Sqrt2/cb*sb*sbth*stth
      AAABR(545) = EE/SW*Sqrt2*(Mc/MW*ccth*csth*mue+MW/cb
     &      *csth*sb*scth-MW/cb*csth*sb**3*scth-Ms**2/MW
     &      /cb*csth*sb*scth-As/MW*Ms/cb*sb*scth*ssth+Mc
     &      /MW*Ms/cb*ccth*sb*ssth)
      AAABR(546) = EE/SW*Sqrt2*(Mc/MW*ccth*csth*mue-Ms/MW
     &      *mue*scth*ssth-2D0*MW/cb*csth*sb*scth+2D0*MW
     &      /cb*csth*sb**3*scth-Mc**2/MW/cb*csth/sb*scth
     &      +Mc**2/MW/cb*csth*sb*scth-Ms**2/MW/cb*csth*sb
     &      *scth+Mc/MW*Ms/cb*ccth/sb*ssth)
      AAABR(547) = EE/SW*Sqrt2*(Mc/MW*ccth*csth*mue-MW/cb
     &      *csth*sb*scth+3D0*MW/cb*csth*sb**3*scth-2D0*MW
     &      /cb*csth*sb**5*scth-Mc/MW*ccth*csth*mue*sb**2
     &      -Mc**2/MW/cb*csth/sb*scth+2D0*Mc**2/MW/cb*csth
     &      *sb*scth-Mc**2/MW/cb*csth*sb**3*scth+Ms/MW*mue
     &      *sb**2*scth*ssth+Ms**2/MW/cb*csth*sb**3*scth
     &      +Mc/MW*Ms/cb*ccth/sb*ssth-2D0*Mc/MW*Ms/cb*ccth
     &      *sb*ssth)
      AAABR(548) = EE*MW/SW*Sqrt2/cb*csth*scth*(sb-sb**3)
      AAABR(549) = EE/SW*Sqrt2*(Ms/MW*mue*scth*ssth-MW/cb
     &      *csth*sb*scth+MW/cb*csth*sb**3*scth+Mc**2/MW
     &      /cb*csth/sb*scth-Mc**2/MW/cb*csth*sb*scth-Ac
     &      /MW*Mc/cb*ccth*csth/sb+Ac/MW*Mc/cb*ccth*csth
     &      *sb-Mc/MW*Ms/cb*ccth/sb*ssth+Mc/MW*Ms/cb*ccth
     &      *sb*ssth)
      AAABR(550) = EE/MW/SW*Sqrt2*(mue*scth*ssth+As/cb*sb
     &      *scth*ssth-Mc/cb*ccth/sb*ssth+2D0*Ms/cb*csth
     &      *sb*scth)
      AAABR(551) = EE/MW/SW*Sqrt2*(Mc*ccth*csth-Ms*scth*ssth
     &      )
      AAABR(552) = EE/MW/SW*Sqrt2*(ccth*csth*mue+Ac/cb*ccth
     &      *csth/sb-Ac/cb*ccth*csth*sb-2D0*Mc/cb*csth/sb
     &      *scth+2D0*Mc/cb*csth*sb*scth+Ms/cb*ccth/sb*ssth)
      AAABR(553) = EE/MW*Mc/SW*Sqrt2/cb*ccth*csth*(1D0/sb
     &      -sb)
      AAABR(554) = EE/MW*Ms/SW*Sqrt2/cb*sb*scth*ssth
      AAABR(555) = EE/SW*Sqrt2*(Mu/MW*cdth*cuth*mue+MW/cb
     &      *cdth*sb*suth-MW/cb*cdth*sb**3*suth-Md**2/MW
     &      /cb*cdth*sb*suth-Ad/MW*Md/cb*sb*sdth*suth+Md
     &      /MW*Mu/cb*cuth*sb*sdth)
      AAABR(556) = EE/SW*Sqrt2*(Md/MW*mue*sdth*suth-Mu/MW
     &      *cdth*cuth*mue+2D0*MW/cb*cdth*sb*suth-2D0*MW
     &      /cb*cdth*sb**3*suth+Md**2/MW/cb*cdth*sb*suth
     &      +Mu**2/MW/cb*cdth/sb*suth-Mu**2/MW/cb*cdth*sb
     &      *suth-Md/MW*Mu/cb*cuth/sb*sdth)
      AAABR(557) = EE/SW*Sqrt2*(Mu/MW*cdth*cuth*mue-MW/cb
     &      *cdth*sb*suth+3D0*MW/cb*cdth*sb**3*suth-2D0*MW
     &      /cb*cdth*sb**5*suth+Md/MW*mue*sb**2*sdth*suth
     &      +Md**2/MW/cb*cdth*sb**3*suth-Mu/MW*cdth*cuth
     &      *mue*sb**2-Mu**2/MW/cb*cdth/sb*suth+2D0*Mu**2
     &      /MW/cb*cdth*sb*suth-Mu**2/MW/cb*cdth*sb**3*suth
     &      +Md/MW*Mu/cb*cuth/sb*sdth-2D0*Md/MW*Mu/cb*cuth
     &      *sb*sdth)
      AAABR(558) = EE*MW/SW*Sqrt2/cb*cdth*suth*(sb-sb**3)
      AAABR(559) = EE/SW*Sqrt2*(Md/MW*mue*sdth*suth-MW/cb
     &      *cdth*sb*suth+MW/cb*cdth*sb**3*suth+Mu**2/MW
     &      /cb*cdth/sb*suth-Mu**2/MW/cb*cdth*sb*suth-Au
     &      /MW*Mu/cb*cdth*cuth/sb+Au/MW*Mu/cb*cdth*cuth
     &      *sb-Md/MW*Mu/cb*cuth/sb*sdth+Md/MW*Mu/cb*cuth
     &      *sb*sdth)
      AAABR(560) = EE/MW/SW*Sqrt2*(mue*sdth*suth+Ad/cb*sb
     &      *sdth*suth+2D0*Md/cb*cdth*sb*suth-Mu/cb*cuth
     &      /sb*sdth)
      AAABR(561) = EE/MW/SW*Sqrt2*(Md*sdth*suth-Mu*cdth*cuth
     &      )
      AAABR(562) = EE/MW/SW*Sqrt2*(cdth*cuth*mue+Au/cb*cdth
     &      *cuth/sb-Au/cb*cdth*cuth*sb+Md/cb*cuth/sb*sdth
     &      -2D0*Mu/cb*cdth/sb*suth+2D0*Mu/cb*cdth*sb*suth)
      AAABR(563) = EE/MW*Mu/SW*Sqrt2/cb*cdth*cuth*(1D0/sb
     &      -sb)
      AAABR(564) = EE/MW*Md/SW*Sqrt2/cb*sb*sdth*suth
      AAABR(565) = EE/SW*Sqrt2*(Mt/MW*ctth*mue*sbth+MW/cb
     &      *sb*sbth*stth-MW/cb*sb**3*sbth*stth-Mb**2/MW
     &      /cb*sb*sbth*stth+Ab/MW*Mb/cb*cbth*sb*stth-Mb
     &      /MW*Mt/cb*cbth*ctth*sb)
      AAABR(566) = EE/SW*Sqrt2*(Mb/MW*cbth*mue*stth+Mt/MW
     &      *ctth*mue*sbth-2D0*MW/cb*sb*sbth*stth+2D0*MW
     &      /cb*sb**3*sbth*stth-Mb**2/MW/cb*sb*sbth*stth
     &      -Mt**2/MW/cb/sb*sbth*stth+Mt**2/MW/cb*sb*sbth
     &      *stth-Mb/MW*Mt/cb*cbth*ctth/sb)
      AAABR(567) = EE/SW*Sqrt2*(Mt/MW*ctth*mue*sbth-MW/cb
     &      *sb*sbth*stth+3D0*MW/cb*sb**3*sbth*stth-2D0*MW
     &      /cb*sb**5*sbth*stth-Mb/MW*cbth*mue*sb**2*stth
     &      +Mb**2/MW/cb*sb**3*sbth*stth-Mt/MW*ctth*mue*sb
     &      **2*sbth-Mt**2/MW/cb/sb*sbth*stth+2D0*Mt**2/MW
     &      /cb*sb*sbth*stth-Mt**2/MW/cb*sb**3*sbth*stth
     &      -Mb/MW*Mt/cb*cbth*ctth/sb+2D0*Mb/MW*Mt/cb*cbth
     &      *ctth*sb)
      AAABR(568) = EE*MW/SW*Sqrt2/cb*sbth*stth*(sb-sb**3)
      AAABR(569) = EE/SW*Sqrt2*(Mb/MW*cbth*mue*stth+MW/cb
     &      *sb*sbth*stth-MW/cb*sb**3*sbth*stth-Mt**2/MW
     &      /cb/sb*sbth*stth+Mt**2/MW/cb*sb*sbth*stth+At
     &      /MW*Mt/cb*ctth/sb*sbth-At/MW*Mt/cb*ctth*sb*sbth
     &      -Mb/MW*Mt/cb*cbth*ctth/sb+Mb/MW*Mt/cb*cbth*ctth
     &      *sb)
      AAABR(570) = EE/MW/SW*Sqrt2*(cbth*mue*stth+Ab/cb*cbth
     &      *sb*stth-2D0*Mb/cb*sb*sbth*stth-Mt/cb*cbth*ctth
     &      /sb)
      AAABR(571) = EE/MW/SW*Sqrt2*(Mb*cbth*stth+Mt*ctth*sbth
     &      )
      AAABR(572) = EE/MW/SW*Sqrt2*(ctth*mue*sbth+At/cb*ctth
     &      /sb*sbth-At/cb*ctth*sb*sbth-Mb/cb*cbth*ctth/sb
     &      -2D0*Mt/cb/sb*sbth*stth+2D0*Mt/cb*sb*sbth*stth)
      AAABR(573) = EE/MW*Mt/SW*Sqrt2/cb*ctth*sbth*(1D0/sb
     &      -sb)
      AAABR(574) = EE/MW*Mb/SW*Sqrt2/cb*cbth*sb*stth
      AAABR(575) = EE/SW*Sqrt2*(Mu/MW*cuth*mue*sdth+MW/cb
     &      *sb*sdth*suth-MW/cb*sb**3*sdth*suth-Md**2/MW
     &      /cb*sb*sdth*suth+Ad/MW*Md/cb*cdth*sb*suth-Md
     &      /MW*Mu/cb*cdth*cuth*sb)
      AAABR(576) = EE/SW*Sqrt2*(Md/MW*cdth*mue*suth+Mu/MW
     &      *cuth*mue*sdth-2D0*MW/cb*sb*sdth*suth+2D0*MW
     &      /cb*sb**3*sdth*suth-Md**2/MW/cb*sb*sdth*suth
     &      -Mu**2/MW/cb/sb*sdth*suth+Mu**2/MW/cb*sb*sdth
     &      *suth-Md/MW*Mu/cb*cdth*cuth/sb)
      AAABR(577) = EE/SW*Sqrt2*(Mu/MW*cuth*mue*sdth-MW/cb
     &      *sb*sdth*suth+3D0*MW/cb*sb**3*sdth*suth-2D0*MW
     &      /cb*sb**5*sdth*suth-Md/MW*cdth*mue*sb**2*suth
     &      +Md**2/MW/cb*sb**3*sdth*suth-Mu/MW*cuth*mue*sb
     &      **2*sdth-Mu**2/MW/cb/sb*sdth*suth+2D0*Mu**2/MW
     &      /cb*sb*sdth*suth-Mu**2/MW/cb*sb**3*sdth*suth
     &      -Md/MW*Mu/cb*cdth*cuth/sb+2D0*Md/MW*Mu/cb*cdth
     &      *cuth*sb)
      AAABR(578) = EE*MW/SW*Sqrt2/cb*sdth*suth*(sb-sb**3)
      AAABR(579) = EE/SW*Sqrt2*(Md/MW*cdth*mue*suth+MW/cb
     &      *sb*sdth*suth-MW/cb*sb**3*sdth*suth-Mu**2/MW
     &      /cb/sb*sdth*suth+Mu**2/MW/cb*sb*sdth*suth+Au
     &      /MW*Mu/cb*cuth/sb*sdth-Au/MW*Mu/cb*cuth*sb*sdth
     &      -Md/MW*Mu/cb*cdth*cuth/sb+Md/MW*Mu/cb*cdth*cuth
     &      *sb)
      AAABR(580) = EE/MW/SW*Sqrt2*(cdth*mue*suth+Ad/cb*cdth
     &      *sb*suth-2D0*Md/cb*sb*sdth*suth-Mu/cb*cdth*cuth
     &      /sb)
      AAABR(581) = EE/MW/SW*Sqrt2*(Md*cdth*suth+Mu*cuth*sdth
     &      )
      AAABR(582) = EE/MW/SW*Sqrt2*(cuth*mue*sdth+Au/cb*cuth
     &      /sb*sdth-Au/cb*cuth*sb*sdth-Md/cb*cdth*cuth/sb
     &      -2D0*Mu/cb/sb*sdth*suth+2D0*Mu/cb*sb*sdth*suth)
      AAABR(583) = EE/MW*Mu/SW*Sqrt2/cb*cuth*sdth*(1D0/sb
     &      -sb)
      AAABR(584) = EE/MW*Md/SW*Sqrt2/cb*cdth*sb*suth
      AAABR(585) = EE/SW*Sqrt2*(Mc/MW*ccth*mue*ssth+MW/cb
     &      *sb*scth*ssth-MW/cb*sb**3*scth*ssth-Ms**2/MW
     &      /cb*sb*scth*ssth+As/MW*Ms/cb*csth*sb*scth-Mc
     &      /MW*Ms/cb*ccth*csth*sb)
      AAABR(586) = EE/SW*Sqrt2*(Mc/MW*ccth*mue*ssth+Ms/MW
     &      *csth*mue*scth-2D0*MW/cb*sb*scth*ssth+2D0*MW
     &      /cb*sb**3*scth*ssth-Mc**2/MW/cb/sb*scth*ssth
     &      +Mc**2/MW/cb*sb*scth*ssth-Ms**2/MW/cb*sb*scth
     &      *ssth-Mc/MW*Ms/cb*ccth*csth/sb)
      AAABR(587) = EE/SW*Sqrt2*(Mc/MW*ccth*mue*ssth-MW/cb
     &      *sb*scth*ssth+3D0*MW/cb*sb**3*scth*ssth-2D0*MW
     &      /cb*sb**5*scth*ssth-Mc/MW*ccth*mue*sb**2*ssth
     &      -Mc**2/MW/cb/sb*scth*ssth+2D0*Mc**2/MW/cb*sb
     &      *scth*ssth-Mc**2/MW/cb*sb**3*scth*ssth-Ms/MW
     &      *csth*mue*sb**2*scth+Ms**2/MW/cb*sb**3*scth*ssth
     &      -Mc/MW*Ms/cb*ccth*csth/sb+2D0*Mc/MW*Ms/cb*ccth
     &      *csth*sb)
      AAABR(588) = EE*MW/SW*Sqrt2/cb*scth*ssth*(sb-sb**3)
      AAABR(589) = EE/SW*Sqrt2*(Ms/MW*csth*mue*scth+MW/cb
     &      *sb*scth*ssth-MW/cb*sb**3*scth*ssth-Mc**2/MW
     &      /cb/sb*scth*ssth+Mc**2/MW/cb*sb*scth*ssth+Ac
     &      /MW*Mc/cb*ccth/sb*ssth-Ac/MW*Mc/cb*ccth*sb*ssth
     &      -Mc/MW*Ms/cb*ccth*csth/sb+Mc/MW*Ms/cb*ccth*csth
     &      *sb)
      AAABR(590) = EE/MW/SW*Sqrt2*(csth*mue*scth+As/cb*csth
     &      *sb*scth-Mc/cb*ccth*csth/sb-2D0*Ms/cb*sb*scth
     &      *ssth)
      AAABR(591) = EE/MW/SW*Sqrt2*(Mc*ccth*ssth+Ms*csth*scth
     &      )
      AAABR(592) = EE/MW/SW*Sqrt2*(ccth*mue*ssth+Ac/cb*ccth
     &      /sb*ssth-Ac/cb*ccth*sb*ssth-2D0*Mc/cb/sb*scth
     &      *ssth+2D0*Mc/cb*sb*scth*ssth-Ms/cb*ccth*csth/sb)
      AAABR(593) = EE/MW*Mc/SW*Sqrt2/cb*ccth*ssth*(1D0/sb
     &      -sb)
      AAABR(594) = EE/MW*Ms/SW*Sqrt2/cb*csth*sb*scth
      AAABR(595) = EE*MW/SW*cb*sb
      AAABR(596) = EE*MW*(ca/SW*sb-2D0*ca/SW*sb**3+cb/SW
     &      *sa+2D0*SW/CW**2*ca*sb-2D0*SW/CW**2*ca*sb**3
     &      -2D0*cb/SW*sa*sb**2-2D0*SW/CW**2*cb*sa*sb**2)
      AAABR(597) = EE*MW*(ca/SW*cb-3D0*sa/SW*sb+4D0*sa/SW
     &      *sb**3-2D0*SW/CW**2*sa*sb+2D0*SW/CW**2*sa*sb
     &      **3-2D0*SW/CW**2*ca*cb*sb**2)
      AAABR(598) = EE*MW*(ca/SW*cb-sa/SW*sb+2D0*sa/SW*sb
     &      **3-2D0*SW/CW**2*sa*sb+2D0*SW/CW**2*sa*sb**3
     &      -2D0*ca/SW*cb*sb**2-2D0*SW/CW**2*ca*cb*sb**2)
      AAABR(599) = EE*MW*(sa/SW*sb-3D0*sa/SW*sb**3+2D0*sa
     &      /SW*sb**5-2D0*SW/CW**2*sa*sb**3+2D0*SW/CW**2
     &      *sa*sb**5+ca/SW*cb*sb**2-2D0*ca/SW*cb*sb**4+2D0
     &      *SW/CW**2*ca*cb*sb**2-2D0*SW/CW**2*ca*cb*sb**4)
      AAABR(600) = EE*MW/SW*(ca*cb-sa*sb+2D0*sa*sb**3-2D0
     &      *ca*cb*sb**2)
      AAABR(601) = EE*MW*(ca/SW*cb+sa/SW*sb-2D0*SW/CW**2
     &      *sa*sb+2D0*SW/CW**2*sa*sb**3-4D0*ca/SW*cb*sb
     &      **2-2D0*SW/CW**2*ca*cb*sb**2)
      AAABR(602) = EE/CW**2*MW*SW*(sa*sb-sa*sb**3+ca*cb*sb
     &      **2)
      AAABR(603) = EE/CW**3*MW*SW**2*(sa*sb-sa*sb**3+ca*cb
     &      *sb**2)
      AAABR(604) = EE*MW*(3D0*ca/SW*sb-4D0*ca/SW*sb**3+cb
     &      /SW*sa+2D0*SW/CW**2*ca*sb-2D0*SW/CW**2*ca*sb
     &      **3-2D0*SW/CW**2*cb*sa*sb**2)
      AAABR(605) = EE*MW*(ca/SW*sb-3D0*ca/SW*sb**3+2D0*ca
     &      /SW*sb**5-2D0*SW/CW**2*ca*sb**3+2D0*SW/CW**2
     &      *ca*sb**5-cb/SW*sa*sb**2+2D0*cb/SW*sa*sb**4-2D0
     &      *SW/CW**2*cb*sa*sb**2+2D0*SW/CW**2*cb*sa*sb**4)
      AAABR(606) = EE*MW/SW*(ca*sb-2D0*ca*sb**3+cb*sa-2D0
     &      *cb*sa*sb**2)
      AAABR(607) = EE*MW*(ca/SW*sb-cb/SW*sa-2D0*SW/CW**2
     &      *ca*sb+2D0*SW/CW**2*ca*sb**3+4D0*cb/SW*sa*sb
     &      **2+2D0*SW/CW**2*cb*sa*sb**2)
      AAABR(608) = EE/CW**2*MW*SW*(ca*sb-ca*sb**3-cb*sa*sb
     &      **2)
      AAABR(609) = EE/CW**3*MW*SW**2*(ca*sb-ca*sb**3-cb*sa
     &      *sb**2)
      AAABR(610) = EE*MW*(sa/SW*sb**3+SW/CW**2*sa*sb**3-ca
     &      /SW*cb*sb**2-SW/CW**2*ca*cb*sb**2)
      AAABR(611) = EE*MW*(ca/SW*cb-sa/SW*sb+2D0*sa/SW*sb
     &      **3+SW/CW**2*ca*cb-SW/CW**2*sa*sb+2D0*SW/CW**2
     &      *sa*sb**3-2D0*ca/SW*cb*sb**2-2D0*SW/CW**2*ca
     &      *cb*sb**2)
      AAABR(612) = EE*MW*(ca/SW*sb-2D0*ca/SW*sb**3+cb/SW
     &      *sa+SW/CW**2*ca*sb-2D0*SW/CW**2*ca*sb**3+SW/CW
     &      **2*cb*sa-2D0*cb/SW*sa*sb**2-2D0*SW/CW**2*cb
     &      *sa*sb**2)
      AAABR(613) = EE*MW*(ca/SW*cb-sa/SW*sb+sa/SW*sb**3+SW
     &      /CW**2*ca*cb-SW/CW**2*sa*sb+SW/CW**2*sa*sb**3
     &      -ca/SW*cb*sb**2-SW/CW**2*ca*cb*sb**2)
      AAABR(614) = EE*MW*(ca/SW*sb**3+SW/CW**2*ca*sb**3+cb
     &      /SW*sa*sb**2+SW/CW**2*cb*sa*sb**2)
      AAABR(615) = EE*MW*(ca/SW*sb-ca/SW*sb**3+cb/SW*sa+SW
     &      /CW**2*ca*sb-SW/CW**2*ca*sb**3+SW/CW**2*cb*sa
     &      -cb/SW*sa*sb**2-SW/CW**2*cb*sa*sb**2)
      AAABR(616) = EE/MW*Me/SW*(mue+Ae/cb*sb)
      AAABR(617) = EE/MW*Me/SW*mue
      AAABR(618) = EE/MW*Me/SW*mue*sb**2
      AAABR(619) = EE/MW/SW*(mue+Ae/cb*sb)
      AAABR(620) = EE/MW*Me/SW
      AAABR(621) = Ae*EE/MW*Me/SW/cb*sb
      AAABR(622) = EE/MW*Me/SW/cb*sb
      AAABR(623) = EE/MW*Ml/SW*(mue+Al/cb*sb)
      AAABR(624) = EE/MW*Ml/SW*mue
      AAABR(625) = EE/MW*Ml/SW*mue*sb**2
      AAABR(626) = EE/MW/SW*(mue+Al/cb*sb)
      AAABR(627) = EE/MW*Ml/SW
      AAABR(628) = Al*EE/MW*Ml/SW/cb*sb
      AAABR(629) = EE/MW*Ml/SW/cb*sb
      AAABR(630) = EE/MW*Mm/SW*(mue+Am/cb*sb)
      AAABR(631) = EE/MW*Mm/SW*mue
      AAABR(632) = EE/MW*Mm/SW*mue*sb**2
      AAABR(633) = EE/MW/SW*(mue+Am/cb*sb)
      AAABR(634) = EE/MW*Mm/SW
      AAABR(635) = Am*EE/MW*Mm/SW/cb*sb
      AAABR(636) = EE/MW*Mm/SW/cb*sb
      AAABR(637) = EE/MW*Mb/SW*(mue+Ab/cb*sb)
      AAABR(638) = EE/MW*Mb/SW*mue
      AAABR(639) = EE/MW*Mb/SW*mue*sb**2
      AAABR(640) = EE/MW/SW*(mue+Ab/cb*sb)
      AAABR(641) = EE/MW*Mb/SW
      AAABR(642) = Ab*EE/MW*Mb/SW/cb*sb
      AAABR(643) = EE/MW*Mb/SW/cb*sb
      AAABR(644) = EE/MW*Md/SW*(mue+Ad/cb*sb)
      AAABR(645) = EE/MW*Md/SW*mue
      AAABR(646) = EE/MW*Md/SW*mue*sb**2
      AAABR(647) = EE/MW/SW*(mue+Ad/cb*sb)
      AAABR(648) = EE/MW*Md/SW
      AAABR(649) = Ad*EE/MW*Md/SW/cb*sb
      AAABR(650) = EE/MW*Md/SW/cb*sb
      AAABR(651) = EE/MW*Ms/SW*(mue+As/cb*sb)
      AAABR(652) = EE/MW*Ms/SW*mue
      AAABR(653) = EE/MW*Ms/SW*mue*sb**2
      AAABR(654) = EE/MW/SW*(mue+As/cb*sb)
      AAABR(655) = EE/MW*Ms/SW
      AAABR(656) = As*EE/MW*Ms/SW/cb*sb
      AAABR(657) = EE/MW*Ms/SW/cb*sb
      AAABR(658) = EE/MW*Mt/SW*mue
      AAABR(659) = EE/MW*Mt/SW*(mue+At*cb/sb)
      AAABR(660) = EE/MW*Mt/SW*mue*(1D0-sb**2)
      AAABR(661) = EE/MW/SW*(mue+At*cb/sb)
      AAABR(662) = EE/MW*Mt/SW
      AAABR(663) = At*EE/MW*Mt/SW*cb/sb
      AAABR(664) = EE/MW*Mt/SW*cb/sb
      AAABR(665) = EE/MW*Mu/SW*mue
      AAABR(666) = EE/MW*Mu/SW*(mue+Au*cb/sb)
      AAABR(667) = EE/MW*Mu/SW*mue*(1D0-sb**2)
      AAABR(668) = EE/MW/SW*(mue+Au*cb/sb)
      AAABR(669) = EE/MW*Mu/SW
      AAABR(670) = Au*EE/MW*Mu/SW*cb/sb
      AAABR(671) = EE/MW*Mu/SW*cb/sb
      AAABR(672) = EE/MW*Mc/SW*mue
      AAABR(673) = EE/MW*Mc/SW*(mue+Ac*cb/sb)
      AAABR(674) = EE/MW*Mc/SW*mue*(1D0-sb**2)
      AAABR(675) = EE/MW/SW*(mue+Ac*cb/sb)
      AAABR(676) = EE/MW*Mc/SW
      AAABR(677) = Ac*EE/MW*Mc/SW*cb/sb
      AAABR(678) = EE/MW*Mc/SW*cb/sb
      AAABR(679) = EE*MW*(ca/SW*cb**2*sb-cb/SW*sa*sb**2+SW
     &      /CW**2*ca*cb**2*sb-SW/CW**2*cb*sa*sb**2)
      AAABR(680) = EE*MW/SW*(ca*cb**2*sb-cb*sa*sb**2)
      AAABR(681) = EE*MW*(ca/SW*cb*sb**2+cb**2/SW*sa*sb+SW
     &      /CW**2*ca*cb*sb**2+SW/CW**2*cb**2*sa*sb)
      AAABR(682) = EE*MW*(ca/SW*cb**2*sb**3+cb/SW*sa*sb**2
     &      -cb/SW*sa*sb**4+SW/CW**2*ca*cb**2*sb**3+SW/CW
     &      **2*cb*sa*sb**2-SW/CW**2*cb*sa*sb**4)
      AAABR(683) = EE/CW**2*MW*SW*(ca*cb**2*sb-cb*sa*sb**2)
      AAABR(684) = EE/CW**3*MW*SW**2*(ca*cb**2*sb-cb*sa*sb
     &      **2)
      AAABR(685) = EE*MW/SW*(ca*cb*sb**2+cb**2*sa*sb)
      AAABR(686) = EE*MW*(ca/SW*cb*sb**2-ca/SW*cb*sb**4-cb
     &      **2/SW*sa*sb**3+SW/CW**2*ca*cb*sb**2-SW/CW**2
     &      *ca*cb*sb**4-SW/CW**2*cb**2*sa*sb**3)
      AAABR(687) = EE/CW**2*MW*SW*(ca*cb*sb**2+cb**2*sa*sb)
      AAABR(688) = EE/CW**3*MW*SW**2*(ca*cb*sb**2+cb**2*sa
     &      *sb)
      AAABR(689) = EE/SW*Sqrt2*(MW*cmuth-Mm**2/MW*cmuth-2D0
     &      *MW*cmuth*sb**2-Am/MW*Mm*smuth+Mm/MW/cb*mue*sb
     &      *smuth)
      AAABR(690) = EE/SW*Sqrt2*(MW*cmuth-Mm**2/MW*cmuth-MW
     &      *cmuth*sb**2-Am/MW*Mm*smuth)
      AAABR(691) = EE/SW*Sqrt2*(MW*cmuth+Mm**2/MW*cmuth-2D0
     &      *MW*cmuth*sb**2-Mm/MW/cb*mue*sb*smuth)
      AAABR(692) = EE/SW*Sqrt2*(2D0*MW*cmuth*sb**2-2D0*MW
     &      *cmuth*sb**4+Mm**2/MW*cmuth*sb**2-Mm/MW/cb*mue
     &      *sb**3*smuth)
      AAABR(693) = EE*MW/SW*Sqrt2*cmuth*(1D0-2D0*sb**2)
      AAABR(694) = EE/SW*Sqrt2*(MW*smuth-Mm**2/MW*smuth-2D0
     &      *MW*sb**2*smuth+Am/MW*Mm*cmuth-Mm/MW/cb*cmuth
     &      *mue*sb)
      AAABR(695) = EE/SW*Sqrt2*(MW*cmuth*sb**2-Mm/MW/cb*mue
     &      *sb*smuth)
      AAABR(696) = EE/MW/SW*Sqrt2*(Am*smuth+2D0*Mm*cmuth
     &      -mue/cb*sb*smuth)
      AAABR(697) = EE/SW*Sqrt2*(MW*ceth-Me**2/MW*ceth-2D0
     &      *MW*ceth*sb**2-Ae/MW*Me*seth+Me/MW/cb*mue*sb
     &      *seth)
      AAABR(698) = EE/SW*Sqrt2*(MW*ceth-Me**2/MW*ceth-MW
     &      *ceth*sb**2-Ae/MW*Me*seth)
      AAABR(699) = EE/SW*Sqrt2*(MW*ceth+Me**2/MW*ceth-2D0
     &      *MW*ceth*sb**2-Me/MW/cb*mue*sb*seth)
      AAABR(700) = EE/SW*Sqrt2*(2D0*MW*ceth*sb**2-2D0*MW
     &      *ceth*sb**4+Me**2/MW*ceth*sb**2-Me/MW/cb*mue
     &      *sb**3*seth)
      AAABR(701) = EE*MW/SW*Sqrt2*ceth*(1D0-2D0*sb**2)
      AAABR(702) = EE/SW*Sqrt2*(MW*seth-Me**2/MW*seth-2D0
     &      *MW*sb**2*seth+Ae/MW*Me*ceth-Me/MW/cb*ceth*mue
     &      *sb)
      AAABR(703) = EE/SW*Sqrt2*(MW*ceth*sb**2-Me/MW/cb*mue
     &      *sb*seth)
      AAABR(704) = EE/MW/SW*Sqrt2*(Ae*seth+2D0*Me*ceth-mue
     &      /cb*sb*seth)
      AAABR(705) = EE/SW*Sqrt2*(MW*clth-Ml**2/MW*clth-2D0
     &      *MW*clth*sb**2-Al/MW*Ml*slth+Ml/MW/cb*mue*sb
     &      *slth)
      AAABR(706) = EE/SW*Sqrt2*(MW*clth-Ml**2/MW*clth-MW
     &      *clth*sb**2-Al/MW*Ml*slth)
      AAABR(707) = EE/SW*Sqrt2*(MW*clth+Ml**2/MW*clth-2D0
     &      *MW*clth*sb**2-Ml/MW/cb*mue*sb*slth)
      AAABR(708) = EE/SW*Sqrt2*(2D0*MW*clth*sb**2-2D0*MW
     &      *clth*sb**4+Ml**2/MW*clth*sb**2-Ml/MW/cb*mue
     &      *sb**3*slth)
      AAABR(709) = EE*MW/SW*Sqrt2*clth*(1D0-2D0*sb**2)
      AAABR(710) = EE/SW*Sqrt2*(MW*slth-Ml**2/MW*slth-2D0
     &      *MW*sb**2*slth+Al/MW*Ml*clth-Ml/MW/cb*clth*mue
     &      *sb)
      AAABR(711) = EE/SW*Sqrt2*(MW*clth*sb**2-Ml/MW/cb*mue
     &      *sb*slth)
      AAABR(712) = EE/MW/SW*Sqrt2*(Al*slth+2D0*Ml*clth-mue
     &      /cb*sb*slth)
      AAABR(713) = EE/MW*Mm/SW/cb*mue*sb
      AAABR(714) = EE/MW*Mm/SW*(Am-mue/cb*sb)
      AAABR(715) = EE/MW*Mm/SW/cb*mue*sb**3
      AAABR(716) = EE/MW/SW*(Am-mue/cb*sb)
      AAABR(717) = Am*EE/MW*Mm/SW
      AAABR(718) = EE/MW*Me/SW/cb*mue*sb
      AAABR(719) = EE/MW*Me/SW*(Ae-mue/cb*sb)
      AAABR(720) = EE/MW*Me/SW/cb*mue*sb**3
      AAABR(721) = EE/MW/SW*(Ae-mue/cb*sb)
      AAABR(722) = Ae*EE/MW*Me/SW
      AAABR(723) = EE/MW*Ml/SW/cb*mue*sb
      AAABR(724) = EE/MW*Ml/SW*(Al-mue/cb*sb)
      AAABR(725) = EE/MW*Ml/SW/cb*mue*sb**3
      AAABR(726) = EE/MW/SW*(Al-mue/cb*sb)
      AAABR(727) = Al*EE/MW*Ml/SW
      AAABR(728) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb-2D0*Ml**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*slth**2+MW/SW
     &      *sa*sb*slth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*slth**2-3D0*MW/CW**2*SW*sa*sb
     &      *slth**2+MW/SW*ca/cb*sb**2*slth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*slth**2-2D0*Al/MW*Ml/SW*ca
     &      /cb*clth*slth+2D0*Ml/MW/SW/cb*clth*mue*sa*slth)
      AAABR(729) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa-2D0*Ml**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*slth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*slth**2+3D0*MW/CW**2*SW*ca*sb*slth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *slth**2+MW/SW/cb*sa*sb**2*slth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*slth**2-2D0*Al/MW*Ml/SW/cb
     &      *clth*sa*slth-2D0*Ml/MW/SW*ca/cb*clth*mue*slth)
      AAABR(730) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa+2D0*Ml**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*slth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*slth**2+3D0*MW/CW**2*SW*ca*sb*slth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *slth**2+MW/SW/cb*sa*sb**2*slth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*slth**2+2D0*Ml/MW/SW*ca/cb
     &      *clth*mue*slth)
      AAABR(731) = EE*(MW/SW*ca*sb-MW/SW*ca*sb**3-MW/CW**2
     &      *SW*ca*sb+MW/CW**2*SW*ca*sb**3-MW/SW*ca*sb*slth
     &      **2+MW/SW*ca*sb**3*slth**2-MW/SW/cb*sa*sb**2
     &      +MW/SW/cb*sa*sb**4+3D0*MW/CW**2*SW*ca*sb*slth
     &      **2-3D0*MW/CW**2*SW*ca*sb**3*slth**2+MW/CW**2
     &      *SW/cb*sa*sb**2-MW/CW**2*SW/cb*sa*sb**4-2D0*Ml
     &      **2/MW/SW/cb*sa*sb**2+MW/SW/cb*sa*sb**2*slth
     &      **2-MW/SW/cb*sa*sb**4*slth**2-3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*slth**2+3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*slth**2-2D0*Ml/MW/SW*ca/cb*clth*mue*sb**2
     &      *slth)
      AAABR(732) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*slth**2-sa
     &      /cb*sb**2-sa/cb*slth**2+sa/cb*sb**2*slth**2)
      AAABR(733) = EE*(Al/MW*Ml/SW/cb*sa+Ml/MW/SW*ca/cb*mue
     &      +MW/SW*ca*clth*sb*slth+MW/SW/cb*clth*sa*slth
     &      -2D0*Al/MW*Ml/SW/cb*sa*slth**2-3D0*MW/CW**2*SW
     &      *ca*clth*sb*slth-3D0*MW/CW**2*SW/cb*clth*sa*slth
     &      -2D0*Ml/MW/SW*ca/cb*mue*slth**2-MW/SW/cb*clth
     &      *sa*sb**2*slth+3D0*MW/CW**2*SW/cb*clth*sa*sb
     &      **2*slth)
      AAABR(734) = EE/CW**2*MW*SW*(ca*sb+sa/cb-3D0*ca*sb
     &      *slth**2-sa/cb*sb**2-3D0*sa/cb*slth**2+3D0*sa
     &      /cb*sb**2*slth**2)
      AAABR(735) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb-3D0*ca
     &      *sb*slth**2-sa/cb*sb**2-3D0*sa/cb*slth**2+3D0
     &      *sa/cb*sb**2*slth**2)
      AAABR(736) = EE/MW/SW/cb*(2D0*Ml*sa+Al*clth*sa*slth
     &      +ca*clth*mue*slth)
      AAABR(737) = EE/MW*Ml/SW*ca/cb*clth*slth
      AAABR(738) = EE/MW*Ml/SW/cb*clth*sa*slth
      AAABR(739) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb-2D0*Mm**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*smuth**2+MW/SW
     &      *sa*sb*smuth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*smuth**2-3D0*MW/CW**2*SW*sa*sb
     &      *smuth**2+MW/SW*ca/cb*sb**2*smuth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*smuth**2-2D0*Am/MW*Mm/SW*ca
     &      /cb*cmuth*smuth+2D0*Mm/MW/SW/cb*cmuth*mue*sa
     &      *smuth)
      AAABR(740) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa-2D0*Mm**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*smuth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*smuth**2+3D0*MW/CW**2*SW*ca*sb*smuth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *smuth**2+MW/SW/cb*sa*sb**2*smuth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*smuth**2-2D0*Am/MW*Mm/SW/cb
     &      *cmuth*sa*smuth-2D0*Mm/MW/SW*ca/cb*cmuth*mue
     &      *smuth)
      AAABR(741) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa+2D0*Mm**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*smuth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*smuth**2+3D0*MW/CW**2*SW*ca*sb*smuth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *smuth**2+MW/SW/cb*sa*sb**2*smuth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*smuth**2+2D0*Mm/MW/SW*ca/cb
     &      *cmuth*mue*smuth)
      AAABR(742) = EE*(MW/SW*ca*sb-MW/SW*ca*sb**3-MW/CW**2
     &      *SW*ca*sb+MW/CW**2*SW*ca*sb**3-MW/SW*ca*sb*smuth
     &      **2+MW/SW*ca*sb**3*smuth**2-MW/SW/cb*sa*sb**2
     &      +MW/SW/cb*sa*sb**4+3D0*MW/CW**2*SW*ca*sb*smuth
     &      **2-3D0*MW/CW**2*SW*ca*sb**3*smuth**2+MW/CW**2
     &      *SW/cb*sa*sb**2-MW/CW**2*SW/cb*sa*sb**4-2D0*Mm
     &      **2/MW/SW/cb*sa*sb**2+MW/SW/cb*sa*sb**2*smuth
     &      **2-MW/SW/cb*sa*sb**4*smuth**2-3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*smuth**2+3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*smuth**2-2D0*Mm/MW/SW*ca/cb*cmuth*mue*sb
     &      **2*smuth)
      AAABR(743) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*smuth**2-sa
     &      /cb*sb**2-sa/cb*smuth**2+sa/cb*sb**2*smuth**2)
      AAABR(744) = EE*(Am/MW*Mm/SW/cb*sa+Mm/MW/SW*ca/cb*mue
     &      +MW/SW*ca*cmuth*sb*smuth+MW/SW/cb*cmuth*sa*smuth
     &      -2D0*Am/MW*Mm/SW/cb*sa*smuth**2-3D0*MW/CW**2
     &      *SW*ca*cmuth*sb*smuth-3D0*MW/CW**2*SW/cb*cmuth
     &      *sa*smuth-2D0*Mm/MW/SW*ca/cb*mue*smuth**2-MW
     &      /SW/cb*cmuth*sa*sb**2*smuth+3D0*MW/CW**2*SW/cb
     &      *cmuth*sa*sb**2*smuth)
      AAABR(745) = EE/CW**2*MW*SW*(ca*sb+sa/cb-3D0*ca*sb
     &      *smuth**2-sa/cb*sb**2-3D0*sa/cb*smuth**2+3D0
     &      *sa/cb*sb**2*smuth**2)
      AAABR(746) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb-3D0*ca
     &      *sb*smuth**2-sa/cb*sb**2-3D0*sa/cb*smuth**2+3D0
     &      *sa/cb*sb**2*smuth**2)
      AAABR(747) = EE/MW/SW/cb*(2D0*Mm*sa+Am*cmuth*sa*smuth
     &      +ca*cmuth*mue*smuth)
      AAABR(748) = EE/MW*Mm/SW*ca/cb*cmuth*smuth
      AAABR(749) = EE/MW*Mm/SW/cb*cmuth*sa*smuth
      AAABR(750) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb+2D0*Ml**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*slth**2+MW/SW
     &      *sa*sb*slth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*slth**2-3D0*MW/CW**2*SW*sa*sb
     &      *slth**2+MW/SW*ca/cb*sb**2*slth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*slth**2-2D0*Ml/MW/SW/cb*clth
     &      *mue*sa*slth)
      AAABR(751) = EE*(MW/SW*sa*sb-MW/SW*sa*sb**3-MW/CW**2
     &      *SW*sa*sb+MW/CW**2*SW*sa*sb**3+MW/SW*ca/cb*sb
     &      **2-MW/SW*ca/cb*sb**4-MW/SW*sa*sb*slth**2+MW
     &      /SW*sa*sb**3*slth**2-MW/CW**2*SW*ca/cb*sb**2
     &      +MW/CW**2*SW*ca/cb*sb**4+3D0*MW/CW**2*SW*sa*sb
     &      *slth**2-3D0*MW/CW**2*SW*sa*sb**3*slth**2+2D0
     &      *Ml**2/MW/SW*ca/cb*sb**2-MW/SW*ca/cb*sb**2*slth
     &      **2+MW/SW*ca/cb*sb**4*slth**2+3D0*MW/CW**2*SW
     &      *ca/cb*sb**2*slth**2-3D0*MW/CW**2*SW*ca/cb*sb
     &      **4*slth**2-2D0*Ml/MW/SW/cb*clth*mue*sa*sb**2
     &      *slth)
      AAABR(752) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca/cb
     &      *slth**2+sa*sb*slth**2+ca/cb*sb**2*slth**2)
      AAABR(753) = EE*(Al/MW*Ml/SW*ca/cb-Ml/MW/SW/cb*mue
     &      *sa+MW/SW*ca/cb*clth*slth-MW/SW*clth*sa*sb*slth
     &      -2D0*Al/MW*Ml/SW*ca/cb*slth**2-3D0*MW/CW**2*SW
     &      *ca/cb*clth*slth+3D0*MW/CW**2*SW*clth*sa*sb*slth
     &      +2D0*Ml/MW/SW/cb*mue*sa*slth**2-MW/SW*ca/cb*clth
     &      *sb**2*slth+3D0*MW/CW**2*SW*ca/cb*clth*sb**2
     &      *slth)
      AAABR(754) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb**2
     &      -3D0*ca/cb*slth**2+3D0*sa*sb*slth**2+3D0*ca/cb
     &      *sb**2*slth**2)
      AAABR(755) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2-3D0*ca/cb*slth**2+3D0*sa*sb*slth**2+3D0*ca
     &      /cb*sb**2*slth**2)
      AAABR(756) = EE/MW/SW/cb*(2D0*Ml*ca+Al*ca*clth*slth
     &      -clth*mue*sa*slth)
      AAABR(757) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb+2D0*Mm**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*smuth**2+MW/SW
     &      *sa*sb*smuth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*smuth**2-3D0*MW/CW**2*SW*sa*sb
     &      *smuth**2+MW/SW*ca/cb*sb**2*smuth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*smuth**2-2D0*Mm/MW/SW/cb*cmuth
     &      *mue*sa*smuth)
      AAABR(758) = EE*(MW/SW*sa*sb-MW/SW*sa*sb**3-MW/CW**2
     &      *SW*sa*sb+MW/CW**2*SW*sa*sb**3+MW/SW*ca/cb*sb
     &      **2-MW/SW*ca/cb*sb**4-MW/SW*sa*sb*smuth**2+MW
     &      /SW*sa*sb**3*smuth**2-MW/CW**2*SW*ca/cb*sb**2
     &      +MW/CW**2*SW*ca/cb*sb**4+3D0*MW/CW**2*SW*sa*sb
     &      *smuth**2-3D0*MW/CW**2*SW*sa*sb**3*smuth**2+2D0
     &      *Mm**2/MW/SW*ca/cb*sb**2-MW/SW*ca/cb*sb**2*smuth
     &      **2+MW/SW*ca/cb*sb**4*smuth**2+3D0*MW/CW**2*SW
     &      *ca/cb*sb**2*smuth**2-3D0*MW/CW**2*SW*ca/cb*sb
     &      **4*smuth**2-2D0*Mm/MW/SW/cb*cmuth*mue*sa*sb
     &      **2*smuth)
      AAABR(759) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca/cb
     &      *smuth**2+sa*sb*smuth**2+ca/cb*sb**2*smuth**2)
      AAABR(760) = EE*(Am/MW*Mm/SW*ca/cb-Mm/MW/SW/cb*mue
     &      *sa+MW/SW*ca/cb*cmuth*smuth-MW/SW*cmuth*sa*sb
     &      *smuth-2D0*Am/MW*Mm/SW*ca/cb*smuth**2-3D0*MW
     &      /CW**2*SW*ca/cb*cmuth*smuth+3D0*MW/CW**2*SW*cmuth
     &      *sa*sb*smuth+2D0*Mm/MW/SW/cb*mue*sa*smuth**2
     &      -MW/SW*ca/cb*cmuth*sb**2*smuth+3D0*MW/CW**2*SW
     &      *ca/cb*cmuth*sb**2*smuth)
      AAABR(761) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb**2
     &      -3D0*ca/cb*smuth**2+3D0*sa*sb*smuth**2+3D0*ca
     &      /cb*sb**2*smuth**2)
      AAABR(762) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2-3D0*ca/cb*smuth**2+3D0*sa*sb*smuth**2+3D0
     &      *ca/cb*sb**2*smuth**2)
      AAABR(763) = EE/MW/SW/cb*(2D0*Mm*ca+Am*ca*cmuth*smuth
     &      -cmuth*mue*sa*smuth)
      AAABR(764) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb-2D0*Me**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*seth**2+MW/SW
     &      *sa*sb*seth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*seth**2-3D0*MW/CW**2*SW*sa*sb
     &      *seth**2+MW/SW*ca/cb*sb**2*seth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*seth**2-2D0*Ae/MW*Me/SW*ca
     &      /cb*ceth*seth+2D0*Me/MW/SW/cb*ceth*mue*sa*seth)
      AAABR(765) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa-2D0*Me**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*seth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*seth**2+3D0*MW/CW**2*SW*ca*sb*seth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *seth**2+MW/SW/cb*sa*sb**2*seth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*seth**2-2D0*Ae/MW*Me/SW/cb
     &      *ceth*sa*seth-2D0*Me/MW/SW*ca/cb*ceth*mue*seth)
      AAABR(766) = EE*(MW/SW*ca/cb-MW/SW*sa*sb-MW/CW**2*SW
     &      *ca/cb+MW/CW**2*SW*sa*sb+2D0*Me**2/MW/SW*ca/cb
     &      -MW/SW*ca/cb*sb**2-MW/SW*ca/cb*seth**2+MW/SW
     &      *sa*sb*seth**2+MW/CW**2*SW*ca/cb*sb**2+3D0*MW
     &      /CW**2*SW*ca/cb*seth**2-3D0*MW/CW**2*SW*sa*sb
     &      *seth**2+MW/SW*ca/cb*sb**2*seth**2-3D0*MW/CW
     &      **2*SW*ca/cb*sb**2*seth**2-2D0*Me/MW/SW/cb*ceth
     &      *mue*sa*seth)
      AAABR(767) = EE*(MW/SW*sa*sb-MW/SW*sa*sb**3-MW/CW**2
     &      *SW*sa*sb+MW/CW**2*SW*sa*sb**3+MW/SW*ca/cb*sb
     &      **2-MW/SW*ca/cb*sb**4-MW/SW*sa*sb*seth**2+MW
     &      /SW*sa*sb**3*seth**2-MW/CW**2*SW*ca/cb*sb**2
     &      +MW/CW**2*SW*ca/cb*sb**4+3D0*MW/CW**2*SW*sa*sb
     &      *seth**2-3D0*MW/CW**2*SW*sa*sb**3*seth**2+2D0
     &      *Me**2/MW/SW*ca/cb*sb**2-MW/SW*ca/cb*sb**2*seth
     &      **2+MW/SW*ca/cb*sb**4*seth**2+3D0*MW/CW**2*SW
     &      *ca/cb*sb**2*seth**2-3D0*MW/CW**2*SW*ca/cb*sb
     &      **4*seth**2-2D0*Me/MW/SW/cb*ceth*mue*sa*sb**2
     &      *seth)
      AAABR(768) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca/cb
     &      *seth**2+sa*sb*seth**2+ca/cb*sb**2*seth**2)
      AAABR(769) = EE*(Ae/MW*Me/SW*ca/cb-Me/MW/SW/cb*mue
     &      *sa+MW/SW*ca/cb*ceth*seth-MW/SW*ceth*sa*sb*seth
     &      -2D0*Ae/MW*Me/SW*ca/cb*seth**2-3D0*MW/CW**2*SW
     &      *ca/cb*ceth*seth+3D0*MW/CW**2*SW*ceth*sa*sb*seth
     &      +2D0*Me/MW/SW/cb*mue*sa*seth**2-MW/SW*ca/cb*ceth
     &      *sb**2*seth+3D0*MW/CW**2*SW*ca/cb*ceth*sb**2
     &      *seth)
      AAABR(770) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb**2
     &      -3D0*ca/cb*seth**2+3D0*sa*sb*seth**2+3D0*ca/cb
     &      *sb**2*seth**2)
      AAABR(771) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2-3D0*ca/cb*seth**2+3D0*sa*sb*seth**2+3D0*ca
     &      /cb*sb**2*seth**2)
      AAABR(772) = EE/MW/SW/cb*(2D0*Me*ca+Ae*ca*ceth*seth
     &      -ceth*mue*sa*seth)
      AAABR(773) = EE/MW*Me/SW/cb*ceth*sa*seth
      AAABR(774) = EE/MW*Me/SW*ca/cb*ceth*seth
      AAABR(775) = EE*(MW/SW*ca*sb+MW/SW/cb*sa-MW/CW**2*SW
     &      *ca*sb-MW/CW**2*SW/cb*sa+2D0*Me**2/MW/SW/cb*sa
     &      -MW/SW*ca*sb*seth**2-MW/SW/cb*sa*sb**2-MW/SW
     &      /cb*sa*seth**2+3D0*MW/CW**2*SW*ca*sb*seth**2
     &      +MW/CW**2*SW/cb*sa*sb**2+3D0*MW/CW**2*SW/cb*sa
     &      *seth**2+MW/SW/cb*sa*sb**2*seth**2-3D0*MW/CW
     &      **2*SW/cb*sa*sb**2*seth**2+2D0*Me/MW/SW*ca/cb
     &      *ceth*mue*seth)
      AAABR(776) = EE*(MW/SW*ca*sb-MW/SW*ca*sb**3-MW/CW**2
     &      *SW*ca*sb+MW/CW**2*SW*ca*sb**3-MW/SW*ca*sb*seth
     &      **2+MW/SW*ca*sb**3*seth**2-MW/SW/cb*sa*sb**2
     &      +MW/SW/cb*sa*sb**4+3D0*MW/CW**2*SW*ca*sb*seth
     &      **2-3D0*MW/CW**2*SW*ca*sb**3*seth**2+MW/CW**2
     &      *SW/cb*sa*sb**2-MW/CW**2*SW/cb*sa*sb**4-2D0*Me
     &      **2/MW/SW/cb*sa*sb**2+MW/SW/cb*sa*sb**2*seth
     &      **2-MW/SW/cb*sa*sb**4*seth**2-3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*seth**2+3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*seth**2-2D0*Me/MW/SW*ca/cb*ceth*mue*sb**2
     &      *seth)
      AAABR(777) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*seth**2-sa
     &      /cb*sb**2-sa/cb*seth**2+sa/cb*sb**2*seth**2)
      AAABR(778) = EE*(Ae/MW*Me/SW/cb*sa+Me/MW/SW*ca/cb*mue
     &      +MW/SW*ca*ceth*sb*seth+MW/SW/cb*ceth*sa*seth
     &      -2D0*Ae/MW*Me/SW/cb*sa*seth**2-3D0*MW/CW**2*SW
     &      *ca*ceth*sb*seth-3D0*MW/CW**2*SW/cb*ceth*sa*seth
     &      -2D0*Me/MW/SW*ca/cb*mue*seth**2-MW/SW/cb*ceth
     &      *sa*sb**2*seth+3D0*MW/CW**2*SW/cb*ceth*sa*sb
     &      **2*seth)
      AAABR(779) = EE/CW**2*MW*SW*(ca*sb+sa/cb-3D0*ca*sb
     &      *seth**2-sa/cb*sb**2-3D0*sa/cb*seth**2+3D0*sa
     &      /cb*sb**2*seth**2)
      AAABR(780) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb-3D0*ca
     &      *sb*seth**2-sa/cb*sb**2-3D0*sa/cb*seth**2+3D0
     &      *sa/cb*sb**2*seth**2)
      AAABR(781) = EE/MW/SW/cb*(2D0*Me*sa+Ae*ceth*sa*seth
     &      +ca*ceth*mue*seth)
      AAABR(782) = EE*(Ml/MW/SW/cb*mue*sa+MW/SW*ca/cb*clth
     &      *slth-MW/SW*clth*sa*sb*slth-3D0*MW/CW**2*SW*ca
     &      /cb*clth*slth+3D0*MW/CW**2*SW*clth*sa*sb*slth
     &      -2D0*Ml/MW/SW/cb*mue*sa*slth**2-MW/SW*ca/cb*clth
     &      *sb**2*slth+3D0*MW/CW**2*SW*ca/cb*clth*sb**2
     &      *slth)
      AAABR(783) = EE*(MW/SW*clth*sa*sb*slth-MW/SW*clth*sa
     &      *sb**3*slth-3D0*MW/CW**2*SW*clth*sa*sb*slth+3D0
     &      *MW/CW**2*SW*clth*sa*sb**3*slth+Ml/MW/SW/cb*mue
     &      *sa*sb**2+MW/SW*ca/cb*clth*sb**2*slth-MW/SW*ca
     &      /cb*clth*sb**4*slth-3D0*MW/CW**2*SW*ca/cb*clth
     &      *sb**2*slth+3D0*MW/CW**2*SW*ca/cb*clth*sb**4
     &      *slth-2D0*Ml/MW/SW/cb*mue*sa*sb**2*slth**2)
      AAABR(784) = EE*MW/SW*clth*slth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(785) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-2D0*Ml**2/MW/SW*ca/cb+MW/SW*ca/cb*slth
     &      **2-MW/SW*sa*sb*slth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*slth**2+3D0*MW/CW
     &      **2*SW*sa*sb*slth**2-MW/SW*ca/cb*sb**2*slth**2
     &      +3D0*MW/CW**2*SW*ca/cb*sb**2*slth**2+2D0*Al/MW
     &      *Ml/SW*ca/cb*clth*slth-2D0*Ml/MW/SW/cb*clth*mue
     &      *sa*slth)
      AAABR(786) = EE/CW**2*MW*SW*clth*slth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(787) = EE/CW**3*MW*SW**2*clth*slth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(788) = EE/MW/SW/cb*(Al*ca-mue*sa-2D0*Al*ca*slth
     &      **2+2D0*mue*sa*slth**2)
      AAABR(789) = EE/MW*Ml/SW/cb*sa*(1D0-2D0*slth**2)
      AAABR(790) = EE/MW*Ml/SW*ca/cb*(1D0-2D0*slth**2)
      AAABR(791) = EE*(Me/MW/SW/cb*mue*sa+MW/SW*ca/cb*ceth
     &      *seth-MW/SW*ceth*sa*sb*seth-3D0*MW/CW**2*SW*ca
     &      /cb*ceth*seth+3D0*MW/CW**2*SW*ceth*sa*sb*seth
     &      -2D0*Me/MW/SW/cb*mue*sa*seth**2-MW/SW*ca/cb*ceth
     &      *sb**2*seth+3D0*MW/CW**2*SW*ca/cb*ceth*sb**2
     &      *seth)
      AAABR(792) = EE*(MW/SW*ceth*sa*sb*seth-MW/SW*ceth*sa
     &      *sb**3*seth-3D0*MW/CW**2*SW*ceth*sa*sb*seth+3D0
     &      *MW/CW**2*SW*ceth*sa*sb**3*seth+Me/MW/SW/cb*mue
     &      *sa*sb**2+MW/SW*ca/cb*ceth*sb**2*seth-MW/SW*ca
     &      /cb*ceth*sb**4*seth-3D0*MW/CW**2*SW*ca/cb*ceth
     &      *sb**2*seth+3D0*MW/CW**2*SW*ca/cb*ceth*sb**4
     &      *seth-2D0*Me/MW/SW/cb*mue*sa*sb**2*seth**2)
      AAABR(793) = EE*MW/SW*ceth*seth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(794) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-2D0*Me**2/MW/SW*ca/cb+MW/SW*ca/cb*seth
     &      **2-MW/SW*sa*sb*seth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*seth**2+3D0*MW/CW
     &      **2*SW*sa*sb*seth**2-MW/SW*ca/cb*sb**2*seth**2
     &      +3D0*MW/CW**2*SW*ca/cb*sb**2*seth**2+2D0*Ae/MW
     &      *Me/SW*ca/cb*ceth*seth-2D0*Me/MW/SW/cb*ceth*mue
     &      *sa*seth)
      AAABR(795) = EE/CW**2*MW*SW*ceth*seth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(796) = EE/CW**3*MW*SW**2*ceth*seth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(797) = EE/MW/SW/cb*(Ae*ca-mue*sa-2D0*Ae*ca*seth
     &      **2+2D0*mue*sa*seth**2)
      AAABR(798) = EE/MW*Me/SW/cb*sa*(1D0-2D0*seth**2)
      AAABR(799) = EE/MW*Me/SW*ca/cb*(1D0-2D0*seth**2)
      AAABR(800) = EE*(Mm/MW/SW/cb*mue*sa+MW/SW*ca/cb*cmuth
     &      *smuth-MW/SW*cmuth*sa*sb*smuth-3D0*MW/CW**2*SW
     &      *ca/cb*cmuth*smuth+3D0*MW/CW**2*SW*cmuth*sa*sb
     &      *smuth-2D0*Mm/MW/SW/cb*mue*sa*smuth**2-MW/SW
     &      *ca/cb*cmuth*sb**2*smuth+3D0*MW/CW**2*SW*ca/cb
     &      *cmuth*sb**2*smuth)
      AAABR(801) = EE*(MW/SW*cmuth*sa*sb*smuth-MW/SW*cmuth
     &      *sa*sb**3*smuth-3D0*MW/CW**2*SW*cmuth*sa*sb*smuth
     &      +3D0*MW/CW**2*SW*cmuth*sa*sb**3*smuth+Mm/MW/SW
     &      /cb*mue*sa*sb**2+MW/SW*ca/cb*cmuth*sb**2*smuth
     &      -MW/SW*ca/cb*cmuth*sb**4*smuth-3D0*MW/CW**2*SW
     &      *ca/cb*cmuth*sb**2*smuth+3D0*MW/CW**2*SW*ca/cb
     &      *cmuth*sb**4*smuth-2D0*Mm/MW/SW/cb*mue*sa*sb
     &      **2*smuth**2)
      AAABR(802) = EE*MW/SW*cmuth*smuth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(803) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-2D0*Mm**2/MW/SW*ca/cb+MW/SW*ca/cb*smuth
     &      **2-MW/SW*sa*sb*smuth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*smuth**2+3D0*MW
     &      /CW**2*SW*sa*sb*smuth**2-MW/SW*ca/cb*sb**2*smuth
     &      **2+3D0*MW/CW**2*SW*ca/cb*sb**2*smuth**2+2D0
     &      *Am/MW*Mm/SW*ca/cb*cmuth*smuth-2D0*Mm/MW/SW/cb
     &      *cmuth*mue*sa*smuth)
      AAABR(804) = EE/CW**2*MW*SW*cmuth*smuth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(805) = EE/CW**3*MW*SW**2*cmuth*smuth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(806) = EE/MW/SW/cb*(Am*ca-mue*sa-2D0*Am*ca*smuth
     &      **2+2D0*mue*sa*smuth**2)
      AAABR(807) = EE/MW*Mm/SW/cb*sa*(1D0-2D0*smuth**2)
      AAABR(808) = EE/MW*Mm/SW*ca/cb*(1D0-2D0*smuth**2)
      AAABR(809) = EE*(Mm/MW/SW*ca/cb*mue-MW/SW*ca*cmuth
     &      *sb*smuth-MW/SW/cb*cmuth*sa*smuth+3D0*MW/CW**2
     &      *SW*ca*cmuth*sb*smuth+3D0*MW/CW**2*SW/cb*cmuth
     &      *sa*smuth-2D0*Mm/MW/SW*ca/cb*mue*smuth**2+MW
     &      /SW/cb*cmuth*sa*sb**2*smuth-3D0*MW/CW**2*SW/cb
     &      *cmuth*sa*sb**2*smuth)
      AAABR(810) = EE*(MW/SW*ca*cmuth*sb*smuth-MW/SW*ca*cmuth
     &      *sb**3*smuth-3D0*MW/CW**2*SW*ca*cmuth*sb*smuth
     &      +3D0*MW/CW**2*SW*ca*cmuth*sb**3*smuth+Mm/MW/SW
     &      *ca/cb*mue*sb**2-MW/SW/cb*cmuth*sa*sb**2*smuth
     &      +MW/SW/cb*cmuth*sa*sb**4*smuth+3D0*MW/CW**2*SW
     &      /cb*cmuth*sa*sb**2*smuth-3D0*MW/CW**2*SW/cb*cmuth
     &      *sa*sb**4*smuth-2D0*Mm/MW/SW*ca/cb*mue*sb**2
     &      *smuth**2)
      AAABR(811) = EE*MW/SW*cmuth*smuth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(812) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-2D0*Mm**2/MW/SW/cb*sa+MW/SW*ca*sb*smuth
     &      **2+MW/SW/cb*sa*smuth**2-3D0*MW/CW**2*SW*ca*sb
     &      *smuth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW
     &      /CW**2*SW/cb*sa*smuth**2-MW/SW/cb*sa*sb**2*smuth
     &      **2+3D0*MW/CW**2*SW/cb*sa*sb**2*smuth**2+2D0
     &      *Am/MW*Mm/SW/cb*cmuth*sa*smuth+2D0*Mm/MW/SW*ca
     &      /cb*cmuth*mue*smuth)
      AAABR(813) = EE/CW**2*MW*SW*cmuth*smuth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(814) = EE/CW**3*MW*SW**2*cmuth*smuth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(815) = EE/MW/SW/cb*(Am*sa+ca*mue-2D0*Am*sa*smuth
     &      **2-2D0*ca*mue*smuth**2)
      AAABR(816) = EE*(Me/MW/SW*ca/cb*mue-MW/SW*ca*ceth*sb
     &      *seth-MW/SW/cb*ceth*sa*seth+3D0*MW/CW**2*SW*ca
     &      *ceth*sb*seth+3D0*MW/CW**2*SW/cb*ceth*sa*seth
     &      -2D0*Me/MW/SW*ca/cb*mue*seth**2+MW/SW/cb*ceth
     &      *sa*sb**2*seth-3D0*MW/CW**2*SW/cb*ceth*sa*sb
     &      **2*seth)
      AAABR(817) = EE*(MW/SW*ca*ceth*sb*seth-MW/SW*ca*ceth
     &      *sb**3*seth-3D0*MW/CW**2*SW*ca*ceth*sb*seth+3D0
     &      *MW/CW**2*SW*ca*ceth*sb**3*seth+Me/MW/SW*ca/cb
     &      *mue*sb**2-MW/SW/cb*ceth*sa*sb**2*seth+MW/SW
     &      /cb*ceth*sa*sb**4*seth+3D0*MW/CW**2*SW/cb*ceth
     &      *sa*sb**2*seth-3D0*MW/CW**2*SW/cb*ceth*sa*sb
     &      **4*seth-2D0*Me/MW/SW*ca/cb*mue*sb**2*seth**2)
      AAABR(818) = EE*MW/SW*ceth*seth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(819) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-2D0*Me**2/MW/SW/cb*sa+MW/SW*ca*sb*seth
     &      **2+MW/SW/cb*sa*seth**2-3D0*MW/CW**2*SW*ca*sb
     &      *seth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW/CW
     &      **2*SW/cb*sa*seth**2-MW/SW/cb*sa*sb**2*seth**2
     &      +3D0*MW/CW**2*SW/cb*sa*sb**2*seth**2+2D0*Ae/MW
     &      *Me/SW/cb*ceth*sa*seth+2D0*Me/MW/SW*ca/cb*ceth
     &      *mue*seth)
      AAABR(820) = EE/CW**2*MW*SW*ceth*seth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(821) = EE/CW**3*MW*SW**2*ceth*seth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(822) = EE/MW/SW/cb*(Ae*sa+ca*mue-2D0*Ae*sa*seth
     &      **2-2D0*ca*mue*seth**2)
      AAABR(823) = EE*(Ml/MW/SW*ca/cb*mue-MW/SW*ca*clth*sb
     &      *slth-MW/SW/cb*clth*sa*slth+3D0*MW/CW**2*SW*ca
     &      *clth*sb*slth+3D0*MW/CW**2*SW/cb*clth*sa*slth
     &      -2D0*Ml/MW/SW*ca/cb*mue*slth**2+MW/SW/cb*clth
     &      *sa*sb**2*slth-3D0*MW/CW**2*SW/cb*clth*sa*sb
     &      **2*slth)
      AAABR(824) = EE*(MW/SW*ca*clth*sb*slth-MW/SW*ca*clth
     &      *sb**3*slth-3D0*MW/CW**2*SW*ca*clth*sb*slth+3D0
     &      *MW/CW**2*SW*ca*clth*sb**3*slth+Ml/MW/SW*ca/cb
     &      *mue*sb**2-MW/SW/cb*clth*sa*sb**2*slth+MW/SW
     &      /cb*clth*sa*sb**4*slth+3D0*MW/CW**2*SW/cb*clth
     &      *sa*sb**2*slth-3D0*MW/CW**2*SW/cb*clth*sa*sb
     &      **4*slth-2D0*Ml/MW/SW*ca/cb*mue*sb**2*slth**2)
      AAABR(825) = EE*MW/SW*clth*slth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(826) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-2D0*Ml**2/MW/SW/cb*sa+MW/SW*ca*sb*slth
     &      **2+MW/SW/cb*sa*slth**2-3D0*MW/CW**2*SW*ca*sb
     &      *slth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW/CW
     &      **2*SW/cb*sa*slth**2-MW/SW/cb*sa*sb**2*slth**2
     &      +3D0*MW/CW**2*SW/cb*sa*sb**2*slth**2+2D0*Al/MW
     &      *Ml/SW/cb*clth*sa*slth+2D0*Ml/MW/SW*ca/cb*clth
     &      *mue*slth)
      AAABR(827) = EE/CW**2*MW*SW*clth*slth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(828) = EE/CW**3*MW*SW**2*clth*slth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(829) = EE/MW/SW/cb*(Al*sa+ca*mue-2D0*Al*sa*slth
     &      **2-2D0*ca*mue*slth**2)
      AAABR(830) = EE/SW*Sqrt2*(MW*seth-Me**2/MW*seth-MW
     &      *sb**2*seth+Ae/MW*Me*ceth)
      AAABR(831) = EE/SW*Sqrt2*(MW*seth+Me**2/MW*seth-2D0
     &      *MW*sb**2*seth+Me/MW/cb*ceth*mue*sb)
      AAABR(832) = EE/SW*Sqrt2*(2D0*MW*sb**2*seth-2D0*MW
     &      *sb**4*seth+Me**2/MW*sb**2*seth+Me/MW/cb*ceth
     &      *mue*sb**3)
      AAABR(833) = EE*MW/SW*Sqrt2*seth*(1D0-2D0*sb**2)
      AAABR(834) = EE/SW*Sqrt2*(MW*sb**2*seth+Me/MW/cb*ceth
     &      *mue*sb)
      AAABR(835) = EE/MW/SW*Sqrt2*(Ae*ceth-2D0*Me*seth-ceth
     &      /cb*mue*sb)
      AAABR(836) = EE/SW*Sqrt2*(MW*smuth-Mm**2/MW*smuth-MW
     &      *sb**2*smuth+Am/MW*Mm*cmuth)
      AAABR(837) = EE/SW*Sqrt2*(MW*smuth+Mm**2/MW*smuth-2D0
     &      *MW*sb**2*smuth+Mm/MW/cb*cmuth*mue*sb)
      AAABR(838) = EE/SW*Sqrt2*(2D0*MW*sb**2*smuth-2D0*MW
     &      *sb**4*smuth+Mm**2/MW*sb**2*smuth+Mm/MW/cb*cmuth
     &      *mue*sb**3)
      AAABR(839) = EE*MW/SW*Sqrt2*smuth*(1D0-2D0*sb**2)
      AAABR(840) = EE/SW*Sqrt2*(MW*sb**2*smuth+Mm/MW/cb*cmuth
     &      *mue*sb)
      AAABR(841) = EE/MW/SW*Sqrt2*(Am*cmuth-2D0*Mm*smuth
     &      -cmuth/cb*mue*sb)
      AAABR(842) = EE/SW*Sqrt2*(MW*slth-Ml**2/MW*slth-MW
     &      *sb**2*slth+Al/MW*Ml*clth)
      AAABR(843) = EE/SW*Sqrt2*(MW*slth+Ml**2/MW*slth-2D0
     &      *MW*sb**2*slth+Ml/MW/cb*clth*mue*sb)
      AAABR(844) = EE/SW*Sqrt2*(2D0*MW*sb**2*slth-2D0*MW
     &      *sb**4*slth+Ml**2/MW*sb**2*slth+Ml/MW/cb*clth
     &      *mue*sb**3)
      AAABR(845) = EE*MW/SW*Sqrt2*slth*(1D0-2D0*sb**2)
      AAABR(846) = EE/SW*Sqrt2*(MW*sb**2*slth+Ml/MW/cb*clth
     &      *mue*sb)
      AAABR(847) = EE/MW/SW*Sqrt2*(Al*clth-2D0*Ml*slth-clth
     &      /cb*mue*sb)
      AAABR(848) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+2D0*Me**2/MW/SW/cb*sa+MW/SW*ca*sb*seth
     &      **2+MW/SW/cb*sa*seth**2-3D0*MW/CW**2*SW*ca*sb
     &      *seth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW/CW
     &      **2*SW/cb*sa*seth**2-MW/SW/cb*sa*sb**2*seth**2
     &      +3D0*MW/CW**2*SW/cb*sa*sb**2*seth**2-2D0*Me/MW
     &      /SW*ca/cb*ceth*mue*seth)
      AAABR(849) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+MW/SW*ca*sb*seth**2-MW/SW*ca*sb
     &      **3*seth**2-3D0*MW/CW**2*SW*ca*sb*seth**2+3D0
     &      *MW/CW**2*SW*ca*sb**3*seth**2-2D0*MW/CW**2*SW
     &      /cb*sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-2D0
     &      *Me**2/MW/SW/cb*sa*sb**2-MW/SW/cb*sa*sb**2*seth
     &      **2+MW/SW/cb*sa*sb**4*seth**2+3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*seth**2-3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*seth**2+2D0*Me/MW/SW*ca/cb*ceth*mue*sb**2
     &      *seth)
      AAABR(850) = EE*MW/SW*seth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(851) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-3D0
     &      *ca*sb*seth**2-2D0*sa/cb*sb**2-3D0*sa/cb*seth
     &      **2+3D0*sa/cb*sb**2*seth**2)
      AAABR(852) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -3D0*ca*sb*seth**2-2D0*sa/cb*sb**2-3D0*sa/cb
     &      *seth**2+3D0*sa/cb*sb**2*seth**2)
      AAABR(853) = EE/MW/SW/cb*(2D0*Me*sa-Ae*ceth*sa*seth
     &      -ca*ceth*mue*seth)
      AAABR(854) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+2D0*Ml**2/MW/SW*ca/cb+MW/SW*ca/cb*slth
     &      **2-MW/SW*sa*sb*slth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*slth**2+3D0*MW/CW
     &      **2*SW*sa*sb*slth**2-MW/SW*ca/cb*sb**2*slth**2
     &      +3D0*MW/CW**2*SW*ca/cb*sb**2*slth**2+2D0*Ml/MW
     &      /SW/cb*clth*mue*sa*slth)
      AAABR(855) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+MW/SW*sa*sb*slth**2-MW/SW*sa*sb
     &      **3*slth**2+2D0*MW/CW**2*SW*ca/cb*sb**2-2D0*MW
     &      /CW**2*SW*ca/cb*sb**4-3D0*MW/CW**2*SW*sa*sb*slth
     &      **2+3D0*MW/CW**2*SW*sa*sb**3*slth**2+2D0*Ml**2
     &      /MW/SW*ca/cb*sb**2+MW/SW*ca/cb*sb**2*slth**2
     &      -MW/SW*ca/cb*sb**4*slth**2-3D0*MW/CW**2*SW*ca
     &      /cb*sb**2*slth**2+3D0*MW/CW**2*SW*ca/cb*sb**4
     &      *slth**2+2D0*Ml/MW/SW/cb*clth*mue*sa*sb**2*slth)
      AAABR(856) = EE*MW/SW*slth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(857) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-3D0*ca/cb*slth**2+3D0*sa*sb*slth
     &      **2+3D0*ca/cb*sb**2*slth**2)
      AAABR(858) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-3D0*ca/cb*slth**2+3D0*sa*sb
     &      *slth**2+3D0*ca/cb*sb**2*slth**2)
      AAABR(859) = EE/MW/SW/cb*(2D0*Ml*ca-Al*ca*clth*slth
     &      +clth*mue*sa*slth)
      AAABR(860) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+2D0*Ml**2/MW/SW/cb*sa+MW/SW*ca*sb*slth
     &      **2+MW/SW/cb*sa*slth**2-3D0*MW/CW**2*SW*ca*sb
     &      *slth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW/CW
     &      **2*SW/cb*sa*slth**2-MW/SW/cb*sa*sb**2*slth**2
     &      +3D0*MW/CW**2*SW/cb*sa*sb**2*slth**2-2D0*Ml/MW
     &      /SW*ca/cb*clth*mue*slth)
      AAABR(861) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+MW/SW*ca*sb*slth**2-MW/SW*ca*sb
     &      **3*slth**2-3D0*MW/CW**2*SW*ca*sb*slth**2+3D0
     &      *MW/CW**2*SW*ca*sb**3*slth**2-2D0*MW/CW**2*SW
     &      /cb*sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-2D0
     &      *Ml**2/MW/SW/cb*sa*sb**2-MW/SW/cb*sa*sb**2*slth
     &      **2+MW/SW/cb*sa*sb**4*slth**2+3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*slth**2-3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*slth**2+2D0*Ml/MW/SW*ca/cb*clth*mue*sb**2
     &      *slth)
      AAABR(862) = EE*MW/SW*slth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(863) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-3D0
     &      *ca*sb*slth**2-2D0*sa/cb*sb**2-3D0*sa/cb*slth
     &      **2+3D0*sa/cb*sb**2*slth**2)
      AAABR(864) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -3D0*ca*sb*slth**2-2D0*sa/cb*sb**2-3D0*sa/cb
     &      *slth**2+3D0*sa/cb*sb**2*slth**2)
      AAABR(865) = EE/MW/SW/cb*(2D0*Ml*sa-Al*clth*sa*slth
     &      -ca*clth*mue*slth)
      AAABR(866) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+2D0*Mm**2/MW/SW/cb*sa+MW/SW*ca*sb*smuth
     &      **2+MW/SW/cb*sa*smuth**2-3D0*MW/CW**2*SW*ca*sb
     &      *smuth**2-2D0*MW/CW**2*SW/cb*sa*sb**2-3D0*MW
     &      /CW**2*SW/cb*sa*smuth**2-MW/SW/cb*sa*sb**2*smuth
     &      **2+3D0*MW/CW**2*SW/cb*sa*sb**2*smuth**2-2D0
     &      *Mm/MW/SW*ca/cb*cmuth*mue*smuth)
      AAABR(867) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+MW/SW*ca*sb*smuth**2-MW/SW*ca*sb
     &      **3*smuth**2-3D0*MW/CW**2*SW*ca*sb*smuth**2+3D0
     &      *MW/CW**2*SW*ca*sb**3*smuth**2-2D0*MW/CW**2*SW
     &      /cb*sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-2D0
     &      *Mm**2/MW/SW/cb*sa*sb**2-MW/SW/cb*sa*sb**2*smuth
     &      **2+MW/SW/cb*sa*sb**4*smuth**2+3D0*MW/CW**2*SW
     &      /cb*sa*sb**2*smuth**2-3D0*MW/CW**2*SW/cb*sa*sb
     &      **4*smuth**2+2D0*Mm/MW/SW*ca/cb*cmuth*mue*sb
     &      **2*smuth)
      AAABR(868) = EE*MW/SW*smuth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(869) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-3D0
     &      *ca*sb*smuth**2-2D0*sa/cb*sb**2-3D0*sa/cb*smuth
     &      **2+3D0*sa/cb*sb**2*smuth**2)
      AAABR(870) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -3D0*ca*sb*smuth**2-2D0*sa/cb*sb**2-3D0*sa/cb
     &      *smuth**2+3D0*sa/cb*sb**2*smuth**2)
      AAABR(871) = EE/MW/SW/cb*(2D0*Mm*sa-Am*cmuth*sa*smuth
     &      -ca*cmuth*mue*smuth)
      AAABR(872) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+2D0*Mm**2/MW/SW*ca/cb+MW/SW*ca/cb*smuth
     &      **2-MW/SW*sa*sb*smuth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*smuth**2+3D0*MW
     &      /CW**2*SW*sa*sb*smuth**2-MW/SW*ca/cb*sb**2*smuth
     &      **2+3D0*MW/CW**2*SW*ca/cb*sb**2*smuth**2+2D0
     &      *Mm/MW/SW/cb*cmuth*mue*sa*smuth)
      AAABR(873) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+MW/SW*sa*sb*smuth**2-MW/SW*sa*sb
     &      **3*smuth**2+2D0*MW/CW**2*SW*ca/cb*sb**2-2D0
     &      *MW/CW**2*SW*ca/cb*sb**4-3D0*MW/CW**2*SW*sa*sb
     &      *smuth**2+3D0*MW/CW**2*SW*sa*sb**3*smuth**2+2D0
     &      *Mm**2/MW/SW*ca/cb*sb**2+MW/SW*ca/cb*sb**2*smuth
     &      **2-MW/SW*ca/cb*sb**4*smuth**2-3D0*MW/CW**2*SW
     &      *ca/cb*sb**2*smuth**2+3D0*MW/CW**2*SW*ca/cb*sb
     &      **4*smuth**2+2D0*Mm/MW/SW/cb*cmuth*mue*sa*sb
     &      **2*smuth)
      AAABR(874) = EE*MW/SW*smuth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(875) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-3D0*ca/cb*smuth**2+3D0*sa*sb*smuth
     &      **2+3D0*ca/cb*sb**2*smuth**2)
      AAABR(876) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-3D0*ca/cb*smuth**2+3D0*sa*sb
     &      *smuth**2+3D0*ca/cb*sb**2*smuth**2)
      AAABR(877) = EE/MW/SW/cb*(2D0*Mm*ca-Am*ca*cmuth*smuth
     &      +cmuth*mue*sa*smuth)
      AAABR(878) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+2D0*Me**2/MW/SW*ca/cb+MW/SW*ca/cb*seth
     &      **2-MW/SW*sa*sb*seth**2-2D0*MW/CW**2*SW*ca/cb
     &      *sb**2-3D0*MW/CW**2*SW*ca/cb*seth**2+3D0*MW/CW
     &      **2*SW*sa*sb*seth**2-MW/SW*ca/cb*sb**2*seth**2
     &      +3D0*MW/CW**2*SW*ca/cb*sb**2*seth**2+2D0*Me/MW
     &      /SW/cb*ceth*mue*sa*seth)
      AAABR(879) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+MW/SW*sa*sb*seth**2-MW/SW*sa*sb
     &      **3*seth**2+2D0*MW/CW**2*SW*ca/cb*sb**2-2D0*MW
     &      /CW**2*SW*ca/cb*sb**4-3D0*MW/CW**2*SW*sa*sb*seth
     &      **2+3D0*MW/CW**2*SW*sa*sb**3*seth**2+2D0*Me**2
     &      /MW/SW*ca/cb*sb**2+MW/SW*ca/cb*sb**2*seth**2
     &      -MW/SW*ca/cb*sb**4*seth**2-3D0*MW/CW**2*SW*ca
     &      /cb*sb**2*seth**2+3D0*MW/CW**2*SW*ca/cb*sb**4
     &      *seth**2+2D0*Me/MW/SW/cb*ceth*mue*sa*sb**2*seth)
      AAABR(880) = EE*MW/SW*seth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(881) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-3D0*ca/cb*seth**2+3D0*sa*sb*seth
     &      **2+3D0*ca/cb*sb**2*seth**2)
      AAABR(882) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-3D0*ca/cb*seth**2+3D0*sa*sb
     &      *seth**2+3D0*ca/cb*sb**2*seth**2)
      AAABR(883) = EE/MW/SW/cb*(2D0*Me*ca-Ae*ca*ceth*seth
     &      +ceth*mue*sa*seth)
      AAABR(884) = EE*MW*(ca/SW*cb-sa/SW*sb+SW/CW**2*ca*cb
     &      -SW/CW**2*sa*sb)
      AAABR(885) = EE*MW*(ca/SW*sb+cb/SW*sa+SW/CW**2*ca*sb
     &      +SW/CW**2*cb*sa)
      AAABR(886) = EE*MW*(sa/SW*sb-sa/SW*sb**3+SW/CW**2*sa
     &      *sb-SW/CW**2*sa*sb**3+ca/SW*cb*sb**2+SW/CW**2
     &      *ca*cb*sb**2)
      AAABR(887) = EE*MW/SW*(ca*cb-sa*sb)
      AAABR(888) = EE/CW**2*MW*SW*(ca*cb-sa*sb)
      AAABR(889) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb)
      AAABR(890) = EE*MW*(ca/SW*sb-ca/SW*sb**3+SW/CW**2*ca
     &      *sb-SW/CW**2*ca*sb**3-cb/SW*sa*sb**2-SW/CW**2
     &      *cb*sa*sb**2)
      AAABR(891) = EE*MW/SW*(ca*sb+cb*sa)
      AAABR(892) = EE/CW**2*MW*SW*(ca*sb+cb*sa)
      AAABR(893) = EE/CW**3*MW*SW**2*(ca*sb+cb*sa)
      AAABR(894) = EE/SW*Sqrt2*(MW*ccth*csth+Mc**2/MW*ccth
     &      *csth-Ms**2/MW*ccth*csth-2D0*MW*ccth*csth*sb
     &      **2+Ac/MW*Mc*csth*scth-As/MW*Ms*ccth*ssth-Mc
     &      /MW/cb*csth*mue/sb*scth+Mc/MW/cb*csth*mue*sb
     &      *scth+Ms/MW/cb*ccth*mue*sb*ssth)
      AAABR(895) = EE/SW*Sqrt2*(MW*ccth*csth-Ms**2/MW*ccth
     &      *csth-MW*ccth*csth*sb**2-As/MW*Ms*ccth*ssth-Mc
     &      /MW*Ms*scth*ssth-Mc/MW/cb*csth*mue/sb*scth+Mc
     &      /MW/cb*csth*mue*sb*scth)
      AAABR(896) = EE/SW*Sqrt2*(MW*ccth*csth-Mc**2/MW*ccth
     &      *csth+Ms**2/MW*ccth*csth-2D0*MW*ccth*csth*sb
     &      **2+Mc/MW/cb*csth*mue/sb*scth-Mc/MW/cb*csth*mue
     &      *sb*scth-Ms/MW/cb*ccth*mue*sb*ssth)
      AAABR(897) = EE/SW*Sqrt2*(Mc**2/MW*ccth*csth+2D0*MW
     &      *ccth*csth*sb**2-2D0*MW*ccth*csth*sb**4+Mc/MW
     &      *Ms*scth*ssth-Mc**2/MW*ccth*csth*sb**2+Ms**2
     &      /MW*ccth*csth*sb**2-Mc/MW/cb*csth*mue/sb*scth
     &      +2D0*Mc/MW/cb*csth*mue*sb*scth-Mc/MW/cb*csth
     &      *mue*sb**3*scth-Ms/MW/cb*ccth*mue*sb**3*ssth)
      AAABR(898) = EE*MW/SW*Sqrt2*ccth*csth*(1D0-2D0*sb**2)
      AAABR(899) = EE/SW*Sqrt2*(MW*csth*scth+Mc**2/MW*csth
     &      *scth-Ms**2/MW*csth*scth-2D0*MW*csth*sb**2*scth
     &      -Ac/MW*Mc*ccth*csth-As/MW*Ms*scth*ssth+Mc/MW
     &      /cb*ccth*csth*mue/sb-Mc/MW/cb*ccth*csth*mue*sb
     &      +Ms/MW/cb*mue*sb*scth*ssth)
      AAABR(900) = EE/SW*Sqrt2*(MW*ccth*ssth+Mc**2/MW*ccth
     &      *ssth-Ms**2/MW*ccth*ssth-2D0*MW*ccth*sb**2*ssth
     &      +Ac/MW*Mc*scth*ssth+As/MW*Ms*ccth*csth-Mc/MW
     &      /cb*mue/sb*scth*ssth+Mc/MW/cb*mue*sb*scth*ssth
     &      -Ms/MW/cb*ccth*csth*mue*sb)
      end

      subroutine aaini02
      implicit none
#include "model.h"

      AAABR(901) = EE/SW*Sqrt2*(Mc**2/MW*ccth*csth-MW*ccth
     &      *csth*sb**2+Ac/MW*Mc*csth*scth+Mc/MW*Ms*scth
     &      *ssth+Ms/MW/cb*ccth*mue*sb*ssth)
      AAABR(902) = EE/MW/SW*Sqrt2*ccth*(As*ssth+2D0*Ms*csth
     &      -mue/cb*sb*ssth)
      AAABR(903) = EE/MW/SW*Sqrt2/cb*(Mc*csth/sb*scth-Mc
     &      *csth*sb*scth-Ms*ccth*sb*ssth)
      AAABR(904) = EE/MW/SW*Sqrt2*csth*(Ac*scth+2D0*Mc*ccth
     &      -mue/cb/sb*scth+mue/cb*sb*scth)
      AAABR(905) = EE/MW*Mc/SW*Sqrt2*csth*scth
      AAABR(906) = EE/MW*Ms/SW*Sqrt2*ccth*ssth
      AAABR(907) = EE/SW*Sqrt2*(MW*cdth*cuth-Md**2/MW*cdth
     &      *cuth+Mu**2/MW*cdth*cuth-2D0*MW*cdth*cuth*sb
     &      **2-Ad/MW*Md*cuth*sdth+Au/MW*Mu*cdth*suth+Md
     &      /MW/cb*cuth*mue*sb*sdth-Mu/MW/cb*cdth*mue/sb
     &      *suth+Mu/MW/cb*cdth*mue*sb*suth)
      AAABR(908) = EE/SW*Sqrt2*(MW*cdth*cuth-Md**2/MW*cdth
     &      *cuth-MW*cdth*cuth*sb**2-Ad/MW*Md*cuth*sdth-Md
     &      /MW*Mu*sdth*suth-Mu/MW/cb*cdth*mue/sb*suth+Mu
     &      /MW/cb*cdth*mue*sb*suth)
      AAABR(909) = EE/SW*Sqrt2*(MW*cdth*cuth+Md**2/MW*cdth
     &      *cuth-Mu**2/MW*cdth*cuth-2D0*MW*cdth*cuth*sb
     &      **2-Md/MW/cb*cuth*mue*sb*sdth+Mu/MW/cb*cdth*mue
     &      /sb*suth-Mu/MW/cb*cdth*mue*sb*suth)
      AAABR(910) = EE/SW*Sqrt2*(Mu**2/MW*cdth*cuth+2D0*MW
     &      *cdth*cuth*sb**2-2D0*MW*cdth*cuth*sb**4+Md/MW
     &      *Mu*sdth*suth+Md**2/MW*cdth*cuth*sb**2-Mu**2
     &      /MW*cdth*cuth*sb**2-Md/MW/cb*cuth*mue*sb**3*sdth
     &      -Mu/MW/cb*cdth*mue/sb*suth+2D0*Mu/MW/cb*cdth
     &      *mue*sb*suth-Mu/MW/cb*cdth*mue*sb**3*suth)
      AAABR(911) = EE*MW/SW*Sqrt2*cdth*cuth*(1D0-2D0*sb**2)
      AAABR(912) = EE/SW*Sqrt2*(MW*cdth*suth-Md**2/MW*cdth
     &      *suth+Mu**2/MW*cdth*suth-2D0*MW*cdth*sb**2*suth
     &      -Ad/MW*Md*sdth*suth-Au/MW*Mu*cdth*cuth+Md/MW
     &      /cb*mue*sb*sdth*suth+Mu/MW/cb*cdth*cuth*mue/sb
     &      -Mu/MW/cb*cdth*cuth*mue*sb)
      AAABR(913) = EE/SW*Sqrt2*(MW*cuth*sdth-Md**2/MW*cuth
     &      *sdth+Mu**2/MW*cuth*sdth-2D0*MW*cuth*sb**2*sdth
     &      +Ad/MW*Md*cdth*cuth+Au/MW*Mu*sdth*suth-Md/MW
     &      /cb*cdth*cuth*mue*sb-Mu/MW/cb*mue/sb*sdth*suth
     &      +Mu/MW/cb*mue*sb*sdth*suth)
      AAABR(914) = EE/SW*Sqrt2*(Mu**2/MW*cdth*cuth-MW*cdth
     &      *cuth*sb**2+Au/MW*Mu*cdth*suth+Md/MW*Mu*sdth
     &      *suth+Md/MW/cb*cuth*mue*sb*sdth)
      AAABR(915) = EE/MW/SW*Sqrt2*cuth*(Ad*sdth+2D0*Md*cdth
     &      -mue/cb*sb*sdth)
      AAABR(916) = EE/MW/SW*Sqrt2/cb*(Md*cuth*sb*sdth-Mu
     &      *cdth/sb*suth+Mu*cdth*sb*suth)
      AAABR(917) = EE/MW/SW*Sqrt2*cdth*(Au*suth+2D0*Mu*cuth
     &      -mue/cb/sb*suth+mue/cb*sb*suth)
      AAABR(918) = EE/MW*Mu/SW*Sqrt2*cdth*suth
      AAABR(919) = EE/MW*Md/SW*Sqrt2*cuth*sdth
      AAABR(920) = EE/SW*Sqrt2*(MW*cbth*ctth-Mb**2/MW*cbth
     &      *ctth+Mt**2/MW*cbth*ctth-2D0*MW*cbth*ctth*sb
     &      **2-Ab/MW*Mb*ctth*sbth+At/MW*Mt*cbth*stth+Mb
     &      /MW/cb*ctth*mue*sb*sbth-Mt/MW/cb*cbth*mue/sb
     &      *stth+Mt/MW/cb*cbth*mue*sb*stth)
      AAABR(921) = EE/SW*Sqrt2*(MW*cbth*ctth-Mb**2/MW*cbth
     &      *ctth-MW*cbth*ctth*sb**2-Ab/MW*Mb*ctth*sbth-Mb
     &      /MW*Mt*sbth*stth-Mt/MW/cb*cbth*mue/sb*stth+Mt
     &      /MW/cb*cbth*mue*sb*stth)
      AAABR(922) = EE/SW*Sqrt2*(MW*cbth*ctth+Mb**2/MW*cbth
     &      *ctth-Mt**2/MW*cbth*ctth-2D0*MW*cbth*ctth*sb
     &      **2-Mb/MW/cb*ctth*mue*sb*sbth+Mt/MW/cb*cbth*mue
     &      /sb*stth-Mt/MW/cb*cbth*mue*sb*stth)
      AAABR(923) = EE/SW*Sqrt2*(Mt**2/MW*cbth*ctth+2D0*MW
     &      *cbth*ctth*sb**2-2D0*MW*cbth*ctth*sb**4+Mb/MW
     &      *Mt*sbth*stth+Mb**2/MW*cbth*ctth*sb**2-Mt**2
     &      /MW*cbth*ctth*sb**2-Mb/MW/cb*ctth*mue*sb**3*sbth
     &      -Mt/MW/cb*cbth*mue/sb*stth+2D0*Mt/MW/cb*cbth
     &      *mue*sb*stth-Mt/MW/cb*cbth*mue*sb**3*stth)
      AAABR(924) = EE*MW/SW*Sqrt2*cbth*ctth*(1D0-2D0*sb**2)
      AAABR(925) = EE/SW*Sqrt2*(MW*cbth*stth-Mb**2/MW*cbth
     &      *stth+Mt**2/MW*cbth*stth-2D0*MW*cbth*sb**2*stth
     &      -Ab/MW*Mb*sbth*stth-At/MW*Mt*cbth*ctth+Mb/MW
     &      /cb*mue*sb*sbth*stth+Mt/MW/cb*cbth*ctth*mue/sb
     &      -Mt/MW/cb*cbth*ctth*mue*sb)
      AAABR(926) = EE/SW*Sqrt2*(MW*ctth*sbth-Mb**2/MW*ctth
     &      *sbth+Mt**2/MW*ctth*sbth-2D0*MW*ctth*sb**2*sbth
     &      +Ab/MW*Mb*cbth*ctth+At/MW*Mt*sbth*stth-Mb/MW
     &      /cb*cbth*ctth*mue*sb-Mt/MW/cb*mue/sb*sbth*stth
     &      +Mt/MW/cb*mue*sb*sbth*stth)
      AAABR(927) = EE/SW*Sqrt2*(Mt**2/MW*cbth*ctth-MW*cbth
     &      *ctth*sb**2+At/MW*Mt*cbth*stth+Mb/MW*Mt*sbth
     &      *stth+Mb/MW/cb*ctth*mue*sb*sbth)
      AAABR(928) = EE/MW/SW*Sqrt2*ctth*(Ab*sbth+2D0*Mb*cbth
     &      -mue/cb*sb*sbth)
      AAABR(929) = EE/MW/SW*Sqrt2/cb*(Mb*ctth*sb*sbth-Mt
     &      *cbth/sb*stth+Mt*cbth*sb*stth)
      AAABR(930) = EE/MW/SW*Sqrt2*cbth*(At*stth+2D0*Mt*ctth
     &      -mue/cb/sb*stth+mue/cb*sb*stth)
      AAABR(931) = EE/MW*Mt/SW*Sqrt2*cbth*stth
      AAABR(932) = EE/MW*Mb/SW*Sqrt2*ctth*sbth
      AAABR(933) = EE/SW*Sqrt2*(MW*cbth*stth-Mb**2/MW*cbth
     &      *stth-MW*cbth*sb**2*stth-Ab/MW*Mb*sbth*stth+Mb
     &      /MW*Mt*ctth*sbth+Mt/MW/cb*cbth*ctth*mue/sb-Mt
     &      /MW/cb*cbth*ctth*mue*sb)
      AAABR(934) = EE/SW*Sqrt2*(MW*cbth*stth+Mb**2/MW*cbth
     &      *stth-Mt**2/MW*cbth*stth-2D0*MW*cbth*sb**2*stth
     &      -Mb/MW/cb*mue*sb*sbth*stth-Mt/MW/cb*cbth*ctth
     &      *mue/sb+Mt/MW/cb*cbth*ctth*mue*sb)
      AAABR(935) = EE/SW*Sqrt2*(Mt**2/MW*cbth*stth+2D0*MW
     &      *cbth*sb**2*stth-2D0*MW*cbth*sb**4*stth-Mb/MW
     &      *Mt*ctth*sbth+Mb**2/MW*cbth*sb**2*stth-Mt**2
     &      /MW*cbth*sb**2*stth-Mb/MW/cb*mue*sb**3*sbth*stth
     &      +Mt/MW/cb*cbth*ctth*mue/sb-2D0*Mt/MW/cb*cbth
     &      *ctth*mue*sb+Mt/MW/cb*cbth*ctth*mue*sb**3)
      AAABR(936) = EE*MW/SW*Sqrt2*cbth*stth*(1D0-2D0*sb**2)
      AAABR(937) = EE/SW*Sqrt2*(MW*sbth*stth-Mb**2/MW*sbth
     &      *stth+Mt**2/MW*sbth*stth-2D0*MW*sb**2*sbth*stth
     &      +Ab/MW*Mb*cbth*stth-At/MW*Mt*ctth*sbth-Mb/MW
     &      /cb*cbth*mue*sb*stth+Mt/MW/cb*ctth*mue/sb*sbth
     &      -Mt/MW/cb*ctth*mue*sb*sbth)
      AAABR(938) = EE/SW*Sqrt2*(Mt**2/MW*cbth*stth-MW*cbth
     &      *sb**2*stth-At/MW*Mt*cbth*ctth-Mb/MW*Mt*ctth
     &      *sbth+Mb/MW/cb*mue*sb*sbth*stth)
      AAABR(939) = EE/MW/SW*Sqrt2*stth*(Ab*sbth+2D0*Mb*cbth
     &      -mue/cb*sb*sbth)
      AAABR(940) = EE/MW/SW*Sqrt2/cb*(Mb*sb*sbth*stth+Mt
     &      *cbth*ctth/sb-Mt*cbth*ctth*sb)
      AAABR(941) = EE/MW/SW*Sqrt2*cbth*(At*ctth-2D0*Mt*stth
     &      -ctth/cb*mue/sb+ctth/cb*mue*sb)
      AAABR(942) = EE/MW*Mt/SW*Sqrt2*cbth*ctth
      AAABR(943) = EE/MW*Mb/SW*Sqrt2*sbth*stth
      AAABR(944) = EE/SW*Sqrt2*(MW*cdth*suth-Md**2/MW*cdth
     &      *suth-MW*cdth*sb**2*suth-Ad/MW*Md*sdth*suth+Md
     &      /MW*Mu*cuth*sdth+Mu/MW/cb*cdth*cuth*mue/sb-Mu
     &      /MW/cb*cdth*cuth*mue*sb)
      AAABR(945) = EE/SW*Sqrt2*(MW*cdth*suth+Md**2/MW*cdth
     &      *suth-Mu**2/MW*cdth*suth-2D0*MW*cdth*sb**2*suth
     &      -Md/MW/cb*mue*sb*sdth*suth-Mu/MW/cb*cdth*cuth
     &      *mue/sb+Mu/MW/cb*cdth*cuth*mue*sb)
      AAABR(946) = EE/SW*Sqrt2*(Mu**2/MW*cdth*suth+2D0*MW
     &      *cdth*sb**2*suth-2D0*MW*cdth*sb**4*suth-Md/MW
     &      *Mu*cuth*sdth+Md**2/MW*cdth*sb**2*suth-Mu**2
     &      /MW*cdth*sb**2*suth-Md/MW/cb*mue*sb**3*sdth*suth
     &      +Mu/MW/cb*cdth*cuth*mue/sb-2D0*Mu/MW/cb*cdth
     &      *cuth*mue*sb+Mu/MW/cb*cdth*cuth*mue*sb**3)
      AAABR(947) = EE*MW/SW*Sqrt2*cdth*suth*(1D0-2D0*sb**2)
      AAABR(948) = EE/SW*Sqrt2*(MW*sdth*suth-Md**2/MW*sdth
     &      *suth+Mu**2/MW*sdth*suth-2D0*MW*sb**2*sdth*suth
     &      +Ad/MW*Md*cdth*suth-Au/MW*Mu*cuth*sdth-Md/MW
     &      /cb*cdth*mue*sb*suth+Mu/MW/cb*cuth*mue/sb*sdth
     &      -Mu/MW/cb*cuth*mue*sb*sdth)
      AAABR(949) = EE/SW*Sqrt2*(Mu**2/MW*cdth*suth-MW*cdth
     &      *sb**2*suth-Au/MW*Mu*cdth*cuth-Md/MW*Mu*cuth
     &      *sdth+Md/MW/cb*mue*sb*sdth*suth)
      AAABR(950) = EE/MW/SW*Sqrt2*suth*(Ad*sdth+2D0*Md*cdth
     &      -mue/cb*sb*sdth)
      AAABR(951) = EE/MW/SW*Sqrt2/cb*(Md*sb*sdth*suth+Mu
     &      *cdth*cuth/sb-Mu*cdth*cuth*sb)
      AAABR(952) = EE/MW/SW*Sqrt2*cdth*(Au*cuth-2D0*Mu*suth
     &      -cuth/cb*mue/sb+cuth/cb*mue*sb)
      AAABR(953) = EE/MW*Mu/SW*Sqrt2*cdth*cuth
      AAABR(954) = EE/MW*Md/SW*Sqrt2*sdth*suth
      AAABR(955) = EE/SW*Sqrt2*(MW*csth*scth-Ms**2/MW*csth
     &      *scth-MW*csth*sb**2*scth-As/MW*Ms*scth*ssth+Mc
     &      /MW*Ms*ccth*ssth+Mc/MW/cb*ccth*csth*mue/sb-Mc
     &      /MW/cb*ccth*csth*mue*sb)
      AAABR(956) = EE/SW*Sqrt2*(MW*csth*scth-Mc**2/MW*csth
     &      *scth+Ms**2/MW*csth*scth-2D0*MW*csth*sb**2*scth
     &      -Mc/MW/cb*ccth*csth*mue/sb+Mc/MW/cb*ccth*csth
     &      *mue*sb-Ms/MW/cb*mue*sb*scth*ssth)
      AAABR(957) = EE/SW*Sqrt2*(Mc**2/MW*csth*scth+2D0*MW
     &      *csth*sb**2*scth-2D0*MW*csth*sb**4*scth-Mc/MW
     &      *Ms*ccth*ssth-Mc**2/MW*csth*sb**2*scth+Ms**2
     &      /MW*csth*sb**2*scth+Mc/MW/cb*ccth*csth*mue/sb
     &      -2D0*Mc/MW/cb*ccth*csth*mue*sb+Mc/MW/cb*ccth
     &      *csth*mue*sb**3-Ms/MW/cb*mue*sb**3*scth*ssth)
      AAABR(958) = EE*MW/SW*Sqrt2*csth*scth*(1D0-2D0*sb**2)
      AAABR(959) = EE/SW*Sqrt2*(MW*scth*ssth+Mc**2/MW*scth
     &      *ssth-Ms**2/MW*scth*ssth-2D0*MW*sb**2*scth*ssth
     &      -Ac/MW*Mc*ccth*ssth+As/MW*Ms*csth*scth+Mc/MW
     &      /cb*ccth*mue/sb*ssth-Mc/MW/cb*ccth*mue*sb*ssth
     &      -Ms/MW/cb*csth*mue*sb*scth)
      AAABR(960) = EE/SW*Sqrt2*(Mc**2/MW*csth*scth-MW*csth
     &      *sb**2*scth-Ac/MW*Mc*ccth*csth-Mc/MW*Ms*ccth
     &      *ssth+Ms/MW/cb*mue*sb*scth*ssth)
      AAABR(961) = EE/MW/SW*Sqrt2*scth*(As*ssth+2D0*Ms*csth
     &      -mue/cb*sb*ssth)
      AAABR(962) = EE/MW/SW*Sqrt2/cb*(Mc*ccth*csth/sb-Mc
     &      *ccth*csth*sb+Ms*sb*scth*ssth)
      AAABR(963) = EE/MW/SW*Sqrt2*csth*(Ac*ccth-2D0*Mc*scth
     &      -ccth/cb*mue/sb+ccth/cb*mue*sb)
      AAABR(964) = EE/MW*Mc/SW*Sqrt2*ccth*csth
      AAABR(965) = EE/MW*Ms/SW*Sqrt2*scth*ssth
      AAABR(966) = EE/MW*Ms/SW/cb*mue*sb
      AAABR(967) = EE/MW*Ms/SW*(As-mue/cb*sb)
      AAABR(968) = EE/MW*Ms/SW/cb*mue*sb**3
      AAABR(969) = EE/MW/SW*(As-mue/cb*sb)
      AAABR(970) = As*EE/MW*Ms/SW
      AAABR(971) = EE/MW*Mb/SW/cb*mue*sb
      AAABR(972) = EE/MW*Mb/SW*(Ab-mue/cb*sb)
      AAABR(973) = EE/MW*Mb/SW/cb*mue*sb**3
      AAABR(974) = EE/MW/SW*(Ab-mue/cb*sb)
      AAABR(975) = Ab*EE/MW*Mb/SW
      AAABR(976) = EE/MW*Md/SW/cb*mue*sb
      AAABR(977) = EE/MW*Md/SW*(Ad-mue/cb*sb)
      AAABR(978) = EE/MW*Md/SW/cb*mue*sb**3
      AAABR(979) = EE/MW/SW*(Ad-mue/cb*sb)
      AAABR(980) = Ad*EE/MW*Md/SW
      AAABR(981) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb-6D0*Md**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*sdth**2+3D0*MW/SW*sa*sb*sdth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*sdth**2-MW
     &      /CW**2*SW*sa*sb*sdth**2+3D0*MW/SW*ca/cb*sb**2
     &      *sdth**2-MW/CW**2*SW*ca/cb*sb**2*sdth**2-6D0
     &      *Ad/MW*Md/SW*ca/cb*cdth*sdth+6D0*Md/MW/SW/cb
     &      *cdth*mue*sa*sdth)
      AAABR(982) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa-6D0*Md**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*sdth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*sdth**2+MW/CW**2*SW
     &      *ca*sb*sdth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*sdth**2+3D0*MW/SW/cb*sa*sb**2*sdth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*sdth**2-6D0*Ad/MW
     &      *Md/SW/cb*cdth*sa*sdth-6D0*Md/MW/SW*ca/cb*cdth
     &      *mue*sdth)
      AAABR(983) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa+6D0*Md**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*sdth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*sdth**2+MW/CW**2*SW
     &      *ca*sb*sdth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*sdth**2+3D0*MW/SW/cb*sa*sb**2*sdth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*sdth**2+6D0*Md/MW
     &      /SW*ca/cb*cdth*mue*sdth)
      AAABR(984) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      +MW/CW**2*SW*ca*sb-MW/CW**2*SW*ca*sb**3-3D0*MW
     &      /SW*ca*sb*sdth**2+3D0*MW/SW*ca*sb**3*sdth**2
     &      -3D0*MW/SW/cb*sa*sb**2+3D0*MW/SW/cb*sa*sb**4
     &      +MW/CW**2*SW*ca*sb*sdth**2-MW/CW**2*SW*ca*sb
     &      **3*sdth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW**2
     &      *SW/cb*sa*sb**4-6D0*Md**2/MW/SW/cb*sa*sb**2+3D0
     &      *MW/SW/cb*sa*sb**2*sdth**2-3D0*MW/SW/cb*sa*sb
     &      **4*sdth**2-MW/CW**2*SW/cb*sa*sb**2*sdth**2+MW
     &      /CW**2*SW/cb*sa*sb**4*sdth**2-6D0*Md/MW/SW*ca
     &      /cb*cdth*mue*sb**2*sdth)
      AAABR(985) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*sdth**2-sa
     &      /cb*sb**2-sa/cb*sdth**2+sa/cb*sb**2*sdth**2)
      AAABR(986) = EE*(3D0*Ad/MW*Md/SW/cb*sa+3D0*Md/MW/SW
     &      *ca/cb*mue+3D0*MW/SW*ca*cdth*sb*sdth+3D0*MW/SW
     &      /cb*cdth*sa*sdth-6D0*Ad/MW*Md/SW/cb*sa*sdth**2
     &      -MW/CW**2*SW*ca*cdth*sb*sdth-MW/CW**2*SW/cb*cdth
     &      *sa*sdth-6D0*Md/MW/SW*ca/cb*mue*sdth**2-3D0*MW
     &      /SW/cb*cdth*sa*sb**2*sdth+MW/CW**2*SW/cb*cdth
     &      *sa*sb**2*sdth)
      AAABR(987) = EE/CW**2*MW*SW*(ca*sb+sa/cb+ca*sb*sdth
     &      **2-sa/cb*sb**2+sa/cb*sdth**2-sa/cb*sb**2*sdth
     &      **2)
      AAABR(988) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb+ca*sb*sdth
     &      **2-sa/cb*sb**2+sa/cb*sdth**2-sa/cb*sb**2*sdth
     &      **2)
      AAABR(989) = EE/MW/SW/cb*(2D0*Md*sa+Ad*cdth*sa*sdth
     &      +ca*cdth*mue*sdth)
      AAABR(990) = EE/MW*Md/SW*ca/cb*cdth*sdth
      AAABR(991) = EE/MW*Md/SW/cb*cdth*sa*sdth
      AAABR(992) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb-6D0*Mb**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*sbth**2+3D0*MW/SW*sa*sb*sbth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*sbth**2-MW
     &      /CW**2*SW*sa*sb*sbth**2+3D0*MW/SW*ca/cb*sb**2
     &      *sbth**2-MW/CW**2*SW*ca/cb*sb**2*sbth**2-6D0
     &      *Ab/MW*Mb/SW*ca/cb*cbth*sbth+6D0*Mb/MW/SW/cb
     &      *cbth*mue*sa*sbth)
      AAABR(993) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa-6D0*Mb**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*sbth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*sbth**2+MW/CW**2*SW
     &      *ca*sb*sbth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*sbth**2+3D0*MW/SW/cb*sa*sb**2*sbth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*sbth**2-6D0*Ab/MW
     &      *Mb/SW/cb*cbth*sa*sbth-6D0*Mb/MW/SW*ca/cb*cbth
     &      *mue*sbth)
      AAABR(994) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb+6D0*Mb**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*sbth**2+3D0*MW/SW*sa*sb*sbth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*sbth**2-MW
     &      /CW**2*SW*sa*sb*sbth**2+3D0*MW/SW*ca/cb*sb**2
     &      *sbth**2-MW/CW**2*SW*ca/cb*sb**2*sbth**2-6D0
     &      *Mb/MW/SW/cb*cbth*mue*sa*sbth)
      AAABR(995) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      +MW/CW**2*SW*sa*sb-MW/CW**2*SW*sa*sb**3+3D0*MW
     &      /SW*ca/cb*sb**2-3D0*MW/SW*ca/cb*sb**4-3D0*MW
     &      /SW*sa*sb*sbth**2+3D0*MW/SW*sa*sb**3*sbth**2
     &      +MW/CW**2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sb
     &      **4+MW/CW**2*SW*sa*sb*sbth**2-MW/CW**2*SW*sa
     &      *sb**3*sbth**2+6D0*Mb**2/MW/SW*ca/cb*sb**2-3D0
     &      *MW/SW*ca/cb*sb**2*sbth**2+3D0*MW/SW*ca/cb*sb
     &      **4*sbth**2+MW/CW**2*SW*ca/cb*sb**2*sbth**2-MW
     &      /CW**2*SW*ca/cb*sb**4*sbth**2-6D0*Mb/MW/SW/cb
     &      *cbth*mue*sa*sb**2*sbth)
      AAABR(996) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca/cb
     &      *sbth**2+sa*sb*sbth**2+ca/cb*sb**2*sbth**2)
      AAABR(997) = EE*(3D0*Ab/MW*Mb/SW*ca/cb-3D0*Mb/MW/SW
     &      /cb*mue*sa+3D0*MW/SW*ca/cb*cbth*sbth-3D0*MW/SW
     &      *cbth*sa*sb*sbth-6D0*Ab/MW*Mb/SW*ca/cb*sbth**2
     &      -MW/CW**2*SW*ca/cb*cbth*sbth+MW/CW**2*SW*cbth
     &      *sa*sb*sbth+6D0*Mb/MW/SW/cb*mue*sa*sbth**2-3D0
     &      *MW/SW*ca/cb*cbth*sb**2*sbth+MW/CW**2*SW*ca/cb
     &      *cbth*sb**2*sbth)
      AAABR(998) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb**2
     &      +ca/cb*sbth**2-sa*sb*sbth**2-ca/cb*sb**2*sbth
     &      **2)
      AAABR(999) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2+ca/cb*sbth**2-sa*sb*sbth**2-ca/cb*sb**2*sbth
     &      **2)
      AAABR(1000) = EE/MW/SW/cb*(2D0*Mb*ca+Ab*ca*cbth*sbth
     &      -cbth*mue*sa*sbth)
      AAABR(1001) = EE/MW*Mb/SW/cb*cbth*sa*sbth
      AAABR(1002) = EE/MW*Mb/SW*ca/cb*cbth*sbth
      AAABR(1003) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb+6D0*Md**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*sdth**2+3D0*MW/SW*sa*sb*sdth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*sdth**2-MW
     &      /CW**2*SW*sa*sb*sdth**2+3D0*MW/SW*ca/cb*sb**2
     &      *sdth**2-MW/CW**2*SW*ca/cb*sb**2*sdth**2-6D0
     &      *Md/MW/SW/cb*cdth*mue*sa*sdth)
      AAABR(1004) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      +MW/CW**2*SW*sa*sb-MW/CW**2*SW*sa*sb**3+3D0*MW
     &      /SW*ca/cb*sb**2-3D0*MW/SW*ca/cb*sb**4-3D0*MW
     &      /SW*sa*sb*sdth**2+3D0*MW/SW*sa*sb**3*sdth**2
     &      +MW/CW**2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sb
     &      **4+MW/CW**2*SW*sa*sb*sdth**2-MW/CW**2*SW*sa
     &      *sb**3*sdth**2+6D0*Md**2/MW/SW*ca/cb*sb**2-3D0
     &      *MW/SW*ca/cb*sb**2*sdth**2+3D0*MW/SW*ca/cb*sb
     &      **4*sdth**2+MW/CW**2*SW*ca/cb*sb**2*sdth**2-MW
     &      /CW**2*SW*ca/cb*sb**4*sdth**2-6D0*Md/MW/SW/cb
     &      *cdth*mue*sa*sb**2*sdth)
      AAABR(1005) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca
     &      /cb*sdth**2+sa*sb*sdth**2+ca/cb*sb**2*sdth**2)
      AAABR(1006) = EE*(3D0*Ad/MW*Md/SW*ca/cb-3D0*Md/MW/SW
     &      /cb*mue*sa+3D0*MW/SW*ca/cb*cdth*sdth-3D0*MW/SW
     &      *cdth*sa*sb*sdth-6D0*Ad/MW*Md/SW*ca/cb*sdth**2
     &      -MW/CW**2*SW*ca/cb*cdth*sdth+MW/CW**2*SW*cdth
     &      *sa*sb*sdth+6D0*Md/MW/SW/cb*mue*sa*sdth**2-3D0
     &      *MW/SW*ca/cb*cdth*sb**2*sdth+MW/CW**2*SW*ca/cb
     &      *cdth*sb**2*sdth)
      AAABR(1007) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb
     &      **2+ca/cb*sdth**2-sa*sb*sdth**2-ca/cb*sb**2*sdth
     &      **2)
      AAABR(1008) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb
     &      *sb**2+ca/cb*sdth**2-sa*sb*sdth**2-ca/cb*sb**2
     &      *sdth**2)
      AAABR(1009) = EE/MW/SW/cb*(2D0*Md*ca+Ad*ca*cdth*sdth
     &      -cdth*mue*sa*sdth)
      AAABR(1010) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb-6D0*Ms**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*ssth**2+3D0*MW/SW*sa*sb*ssth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*ssth**2-MW
     &      /CW**2*SW*sa*sb*ssth**2+3D0*MW/SW*ca/cb*sb**2
     &      *ssth**2-MW/CW**2*SW*ca/cb*sb**2*ssth**2-6D0
     &      *As/MW*Ms/SW*ca/cb*csth*ssth+6D0*Ms/MW/SW/cb
     &      *csth*mue*sa*ssth)
      AAABR(1011) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa-6D0*Ms**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*ssth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*ssth**2+MW/CW**2*SW
     &      *ca*sb*ssth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*ssth**2+3D0*MW/SW/cb*sa*sb**2*ssth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*ssth**2-6D0*As/MW
     &      *Ms/SW/cb*csth*sa*ssth-6D0*Ms/MW/SW*ca/cb*csth
     &      *mue*ssth)
      AAABR(1012) = EE*(3D0*MW/SW*ca/cb-3D0*MW/SW*sa*sb+MW
     &      /CW**2*SW*ca/cb-MW/CW**2*SW*sa*sb+6D0*Ms**2/MW
     &      /SW*ca/cb-3D0*MW/SW*ca/cb*sb**2-3D0*MW/SW*ca
     &      /cb*ssth**2+3D0*MW/SW*sa*sb*ssth**2-MW/CW**2
     &      *SW*ca/cb*sb**2+MW/CW**2*SW*ca/cb*ssth**2-MW
     &      /CW**2*SW*sa*sb*ssth**2+3D0*MW/SW*ca/cb*sb**2
     &      *ssth**2-MW/CW**2*SW*ca/cb*sb**2*ssth**2-6D0
     &      *Ms/MW/SW/cb*csth*mue*sa*ssth)
      AAABR(1013) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      +MW/CW**2*SW*sa*sb-MW/CW**2*SW*sa*sb**3+3D0*MW
     &      /SW*ca/cb*sb**2-3D0*MW/SW*ca/cb*sb**4-3D0*MW
     &      /SW*sa*sb*ssth**2+3D0*MW/SW*sa*sb**3*ssth**2
     &      +MW/CW**2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sb
     &      **4+MW/CW**2*SW*sa*sb*ssth**2-MW/CW**2*SW*sa
     &      *sb**3*ssth**2+6D0*Ms**2/MW/SW*ca/cb*sb**2-3D0
     &      *MW/SW*ca/cb*sb**2*ssth**2+3D0*MW/SW*ca/cb*sb
     &      **4*ssth**2+MW/CW**2*SW*ca/cb*sb**2*ssth**2-MW
     &      /CW**2*SW*ca/cb*sb**4*ssth**2-6D0*Ms/MW/SW/cb
     &      *csth*mue*sa*sb**2*ssth)
      AAABR(1014) = EE*MW/SW*(ca/cb-sa*sb-ca/cb*sb**2-ca
     &      /cb*ssth**2+sa*sb*ssth**2+ca/cb*sb**2*ssth**2)
      AAABR(1015) = EE*(3D0*As/MW*Ms/SW*ca/cb-3D0*Ms/MW/SW
     &      /cb*mue*sa+3D0*MW/SW*ca/cb*csth*ssth-3D0*MW/SW
     &      *csth*sa*sb*ssth-6D0*As/MW*Ms/SW*ca/cb*ssth**2
     &      -MW/CW**2*SW*ca/cb*csth*ssth+MW/CW**2*SW*csth
     &      *sa*sb*ssth+6D0*Ms/MW/SW/cb*mue*sa*ssth**2-3D0
     &      *MW/SW*ca/cb*csth*sb**2*ssth+MW/CW**2*SW*ca/cb
     &      *csth*sb**2*ssth)
      AAABR(1016) = EE/CW**2*MW*SW*(ca/cb-sa*sb-ca/cb*sb
     &      **2+ca/cb*ssth**2-sa*sb*ssth**2-ca/cb*sb**2*ssth
     &      **2)
      AAABR(1017) = EE/CW**3*MW*SW**2*(ca/cb-sa*sb-ca/cb
     &      *sb**2+ca/cb*ssth**2-sa*sb*ssth**2-ca/cb*sb**2
     &      *ssth**2)
      AAABR(1018) = EE/MW/SW/cb*(2D0*Ms*ca+As*ca*csth*ssth
     &      -csth*mue*sa*ssth)
      AAABR(1019) = EE/MW*Ms/SW/cb*csth*sa*ssth
      AAABR(1020) = EE/MW*Ms/SW*ca/cb*csth*ssth
      AAABR(1021) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa+6D0*Ms**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*ssth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*ssth**2+MW/CW**2*SW
     &      *ca*sb*ssth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*ssth**2+3D0*MW/SW/cb*sa*sb**2*ssth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*ssth**2+6D0*Ms/MW
     &      /SW*ca/cb*csth*mue*ssth)
      AAABR(1022) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      +MW/CW**2*SW*ca*sb-MW/CW**2*SW*ca*sb**3-3D0*MW
     &      /SW*ca*sb*ssth**2+3D0*MW/SW*ca*sb**3*ssth**2
     &      -3D0*MW/SW/cb*sa*sb**2+3D0*MW/SW/cb*sa*sb**4
     &      +MW/CW**2*SW*ca*sb*ssth**2-MW/CW**2*SW*ca*sb
     &      **3*ssth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW**2
     &      *SW/cb*sa*sb**4-6D0*Ms**2/MW/SW/cb*sa*sb**2+3D0
     &      *MW/SW/cb*sa*sb**2*ssth**2-3D0*MW/SW/cb*sa*sb
     &      **4*ssth**2-MW/CW**2*SW/cb*sa*sb**2*ssth**2+MW
     &      /CW**2*SW/cb*sa*sb**4*ssth**2-6D0*Ms/MW/SW*ca
     &      /cb*csth*mue*sb**2*ssth)
      AAABR(1023) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*ssth**2-sa
     &      /cb*sb**2-sa/cb*ssth**2+sa/cb*sb**2*ssth**2)
      AAABR(1024) = EE*(3D0*As/MW*Ms/SW/cb*sa+3D0*Ms/MW/SW
     &      *ca/cb*mue+3D0*MW/SW*ca*csth*sb*ssth+3D0*MW/SW
     &      /cb*csth*sa*ssth-6D0*As/MW*Ms/SW/cb*sa*ssth**2
     &      -MW/CW**2*SW*ca*csth*sb*ssth-MW/CW**2*SW/cb*csth
     &      *sa*ssth-6D0*Ms/MW/SW*ca/cb*mue*ssth**2-3D0*MW
     &      /SW/cb*csth*sa*sb**2*ssth+MW/CW**2*SW/cb*csth
     &      *sa*sb**2*ssth)
      AAABR(1025) = EE/CW**2*MW*SW*(ca*sb+sa/cb+ca*sb*ssth
     &      **2-sa/cb*sb**2+sa/cb*ssth**2-sa/cb*sb**2*ssth
     &      **2)
      AAABR(1026) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb+ca*sb
     &      *ssth**2-sa/cb*sb**2+sa/cb*ssth**2-sa/cb*sb**2
     &      *ssth**2)
      AAABR(1027) = EE/MW/SW/cb*(2D0*Ms*sa+As*csth*sa*ssth
     &      +ca*csth*mue*ssth)
      AAABR(1028) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW/cb*sa+MW
     &      /CW**2*SW*ca*sb+MW/CW**2*SW/cb*sa+6D0*Mb**2/MW
     &      /SW/cb*sa-3D0*MW/SW*ca*sb*sbth**2-3D0*MW/SW/cb
     &      *sa*sb**2-3D0*MW/SW/cb*sa*sbth**2+MW/CW**2*SW
     &      *ca*sb*sbth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW
     &      **2*SW/cb*sa*sbth**2+3D0*MW/SW/cb*sa*sb**2*sbth
     &      **2-MW/CW**2*SW/cb*sa*sb**2*sbth**2+6D0*Mb/MW
     &      /SW*ca/cb*cbth*mue*sbth)
      AAABR(1029) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      +MW/CW**2*SW*ca*sb-MW/CW**2*SW*ca*sb**3-3D0*MW
     &      /SW*ca*sb*sbth**2+3D0*MW/SW*ca*sb**3*sbth**2
     &      -3D0*MW/SW/cb*sa*sb**2+3D0*MW/SW/cb*sa*sb**4
     &      +MW/CW**2*SW*ca*sb*sbth**2-MW/CW**2*SW*ca*sb
     &      **3*sbth**2-MW/CW**2*SW/cb*sa*sb**2+MW/CW**2
     &      *SW/cb*sa*sb**4-6D0*Mb**2/MW/SW/cb*sa*sb**2+3D0
     &      *MW/SW/cb*sa*sb**2*sbth**2-3D0*MW/SW/cb*sa*sb
     &      **4*sbth**2-MW/CW**2*SW/cb*sa*sb**2*sbth**2+MW
     &      /CW**2*SW/cb*sa*sb**4*sbth**2-6D0*Mb/MW/SW*ca
     &      /cb*cbth*mue*sb**2*sbth)
      AAABR(1030) = EE*MW/SW*(ca*sb+sa/cb-ca*sb*sbth**2-sa
     &      /cb*sb**2-sa/cb*sbth**2+sa/cb*sb**2*sbth**2)
      AAABR(1031) = EE*(3D0*Ab/MW*Mb/SW/cb*sa+3D0*Mb/MW/SW
     &      *ca/cb*mue+3D0*MW/SW*ca*cbth*sb*sbth+3D0*MW/SW
     &      /cb*cbth*sa*sbth-6D0*Ab/MW*Mb/SW/cb*sa*sbth**2
     &      -MW/CW**2*SW*ca*cbth*sb*sbth-MW/CW**2*SW/cb*cbth
     &      *sa*sbth-6D0*Mb/MW/SW*ca/cb*mue*sbth**2-3D0*MW
     &      /SW/cb*cbth*sa*sb**2*sbth+MW/CW**2*SW/cb*cbth
     &      *sa*sb**2*sbth)
      AAABR(1032) = EE/CW**2*MW*SW*(ca*sb+sa/cb+ca*sb*sbth
     &      **2-sa/cb*sb**2+sa/cb*sbth**2-sa/cb*sb**2*sbth
     &      **2)
      AAABR(1033) = EE/CW**3*MW*SW**2*(ca*sb+sa/cb+ca*sb
     &      *sbth**2-sa/cb*sb**2+sa/cb*sbth**2-sa/cb*sb**2
     &      *sbth**2)
      AAABR(1034) = EE/MW/SW/cb*(2D0*Mb*sa+Ab*cbth*sa*sbth
     &      +ca*cbth*mue*sbth)
      AAABR(1035) = EE*(3D0*Md/MW/SW/cb*mue*sa+3D0*MW/SW
     &      *ca/cb*cdth*sdth-3D0*MW/SW*cdth*sa*sb*sdth-MW
     &      /CW**2*SW*ca/cb*cdth*sdth+MW/CW**2*SW*cdth*sa
     &      *sb*sdth-6D0*Md/MW/SW/cb*mue*sa*sdth**2-3D0*MW
     &      /SW*ca/cb*cdth*sb**2*sdth+MW/CW**2*SW*ca/cb*cdth
     &      *sb**2*sdth)
      AAABR(1036) = EE*(3D0*MW/SW*cdth*sa*sb*sdth-3D0*MW
     &      /SW*cdth*sa*sb**3*sdth-MW/CW**2*SW*cdth*sa*sb
     &      *sdth+MW/CW**2*SW*cdth*sa*sb**3*sdth+3D0*Md/MW
     &      /SW/cb*mue*sa*sb**2+3D0*MW/SW*ca/cb*cdth*sb**2
     &      *sdth-3D0*MW/SW*ca/cb*cdth*sb**4*sdth-MW/CW**2
     &      *SW*ca/cb*cdth*sb**2*sdth+MW/CW**2*SW*ca/cb*cdth
     &      *sb**4*sdth-6D0*Md/MW/SW/cb*mue*sa*sb**2*sdth
     &      **2)
      AAABR(1037) = EE*MW/SW*cdth*sdth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(1038) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-6D0*Md**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*sdth**2-3D0*MW/SW*sa*sb*sdth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sdth**2
     &      +MW/CW**2*SW*sa*sb*sdth**2-3D0*MW/SW*ca/cb*sb
     &      **2*sdth**2+MW/CW**2*SW*ca/cb*sb**2*sdth**2+6D0
     &      *Ad/MW*Md/SW*ca/cb*cdth*sdth-6D0*Md/MW/SW/cb
     &      *cdth*mue*sa*sdth)
      AAABR(1039) = EE/CW**2*MW*SW*cdth*sdth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(1040) = EE/CW**3*MW*SW**2*cdth*sdth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(1041) = EE/MW/SW/cb*(Ad*ca-mue*sa-2D0*Ad*ca*sdth
     &      **2+2D0*mue*sa*sdth**2)
      AAABR(1042) = EE/MW*Md/SW/cb*sa*(1D0-2D0*sdth**2)
      AAABR(1043) = EE/MW*Md/SW*ca/cb*(1D0-2D0*sdth**2)
      AAABR(1044) = EE*(3D0*Ms/MW/SW*ca/cb*mue-3D0*MW/SW
     &      *ca*csth*sb*ssth-3D0*MW/SW/cb*csth*sa*ssth+MW
     &      /CW**2*SW*ca*csth*sb*ssth+MW/CW**2*SW/cb*csth
     &      *sa*ssth-6D0*Ms/MW/SW*ca/cb*mue*ssth**2+3D0*MW
     &      /SW/cb*csth*sa*sb**2*ssth-MW/CW**2*SW/cb*csth
     &      *sa*sb**2*ssth)
      AAABR(1045) = EE*(3D0*MW/SW*ca*csth*sb*ssth-3D0*MW
     &      /SW*ca*csth*sb**3*ssth-MW/CW**2*SW*ca*csth*sb
     &      *ssth+MW/CW**2*SW*ca*csth*sb**3*ssth+3D0*Ms/MW
     &      /SW*ca/cb*mue*sb**2-3D0*MW/SW/cb*csth*sa*sb**2
     &      *ssth+3D0*MW/SW/cb*csth*sa*sb**4*ssth+MW/CW**2
     &      *SW/cb*csth*sa*sb**2*ssth-MW/CW**2*SW/cb*csth
     &      *sa*sb**4*ssth-6D0*Ms/MW/SW*ca/cb*mue*sb**2*ssth
     &      **2)
      AAABR(1046) = EE*MW/SW*csth*ssth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(1047) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-6D0*Ms**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*ssth**2+3D0*MW/SW/cb*sa*ssth**2-MW/CW**2
     &      *SW*ca*sb*ssth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*ssth**2-3D0*MW/SW/cb*sa*sb
     &      **2*ssth**2+MW/CW**2*SW/cb*sa*sb**2*ssth**2+6D0
     &      *As/MW*Ms/SW/cb*csth*sa*ssth+6D0*Ms/MW/SW*ca
     &      /cb*csth*mue*ssth)
      AAABR(1048) = EE/CW**2*MW*SW*csth*ssth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(1049) = EE/CW**3*MW*SW**2*csth*ssth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(1050) = EE/MW/SW/cb*(As*sa+ca*mue-2D0*As*sa*ssth
     &      **2-2D0*ca*mue*ssth**2)
      AAABR(1051) = EE/MW*Ms/SW*ca/cb*(1D0-2D0*ssth**2)
      AAABR(1052) = EE/MW*Ms/SW/cb*sa*(1D0-2D0*ssth**2)
      AAABR(1053) = EE*(3D0*Md/MW/SW*ca/cb*mue-3D0*MW/SW
     &      *ca*cdth*sb*sdth-3D0*MW/SW/cb*cdth*sa*sdth+MW
     &      /CW**2*SW*ca*cdth*sb*sdth+MW/CW**2*SW/cb*cdth
     &      *sa*sdth-6D0*Md/MW/SW*ca/cb*mue*sdth**2+3D0*MW
     &      /SW/cb*cdth*sa*sb**2*sdth-MW/CW**2*SW/cb*cdth
     &      *sa*sb**2*sdth)
      AAABR(1054) = EE*(3D0*MW/SW*ca*cdth*sb*sdth-3D0*MW
     &      /SW*ca*cdth*sb**3*sdth-MW/CW**2*SW*ca*cdth*sb
     &      *sdth+MW/CW**2*SW*ca*cdth*sb**3*sdth+3D0*Md/MW
     &      /SW*ca/cb*mue*sb**2-3D0*MW/SW/cb*cdth*sa*sb**2
     &      *sdth+3D0*MW/SW/cb*cdth*sa*sb**4*sdth+MW/CW**2
     &      *SW/cb*cdth*sa*sb**2*sdth-MW/CW**2*SW/cb*cdth
     &      *sa*sb**4*sdth-6D0*Md/MW/SW*ca/cb*mue*sb**2*sdth
     &      **2)
      AAABR(1055) = EE*MW/SW*cdth*sdth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(1056) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-6D0*Md**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*sdth**2+3D0*MW/SW/cb*sa*sdth**2-MW/CW**2
     &      *SW*ca*sb*sdth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*sdth**2-3D0*MW/SW/cb*sa*sb
     &      **2*sdth**2+MW/CW**2*SW/cb*sa*sb**2*sdth**2+6D0
     &      *Ad/MW*Md/SW/cb*cdth*sa*sdth+6D0*Md/MW/SW*ca
     &      /cb*cdth*mue*sdth)
      AAABR(1057) = EE/CW**2*MW*SW*cdth*sdth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(1058) = EE/CW**3*MW*SW**2*cdth*sdth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(1059) = EE/MW/SW/cb*(Ad*sa+ca*mue-2D0*Ad*sa*sdth
     &      **2-2D0*ca*mue*sdth**2)
      AAABR(1060) = EE*(3D0*Mb/MW/SW*ca/cb*mue-3D0*MW/SW
     &      *ca*cbth*sb*sbth-3D0*MW/SW/cb*cbth*sa*sbth+MW
     &      /CW**2*SW*ca*cbth*sb*sbth+MW/CW**2*SW/cb*cbth
     &      *sa*sbth-6D0*Mb/MW/SW*ca/cb*mue*sbth**2+3D0*MW
     &      /SW/cb*cbth*sa*sb**2*sbth-MW/CW**2*SW/cb*cbth
     &      *sa*sb**2*sbth)
      AAABR(1061) = EE*(3D0*MW/SW*ca*cbth*sb*sbth-3D0*MW
     &      /SW*ca*cbth*sb**3*sbth-MW/CW**2*SW*ca*cbth*sb
     &      *sbth+MW/CW**2*SW*ca*cbth*sb**3*sbth+3D0*Mb/MW
     &      /SW*ca/cb*mue*sb**2-3D0*MW/SW/cb*cbth*sa*sb**2
     &      *sbth+3D0*MW/SW/cb*cbth*sa*sb**4*sbth+MW/CW**2
     &      *SW/cb*cbth*sa*sb**2*sbth-MW/CW**2*SW/cb*cbth
     &      *sa*sb**4*sbth-6D0*Mb/MW/SW*ca/cb*mue*sb**2*sbth
     &      **2)
      AAABR(1062) = EE*MW/SW*cbth*sbth*(ca*sb+sa/cb-sa/cb
     &      *sb**2)
      AAABR(1063) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa-6D0*Mb**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*sbth**2+3D0*MW/SW/cb*sa*sbth**2-MW/CW**2
     &      *SW*ca*sb*sbth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*sbth**2-3D0*MW/SW/cb*sa*sb
     &      **2*sbth**2+MW/CW**2*SW/cb*sa*sb**2*sbth**2+6D0
     &      *Ab/MW*Mb/SW/cb*cbth*sa*sbth+6D0*Mb/MW/SW*ca
     &      /cb*cbth*mue*sbth)
      AAABR(1064) = EE/CW**2*MW*SW*cbth*sbth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(1065) = EE/CW**3*MW*SW**2*cbth*sbth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(1066) = EE/MW/SW/cb*(Ab*sa+ca*mue-2D0*Ab*sa*sbth
     &      **2-2D0*ca*mue*sbth**2)
      AAABR(1067) = EE/MW*Mb/SW*ca/cb*(1D0-2D0*sbth**2)
      AAABR(1068) = EE/MW*Mb/SW/cb*sa*(1D0-2D0*sbth**2)
      AAABR(1069) = EE*(3D0*Ms/MW/SW/cb*mue*sa+3D0*MW/SW
     &      *ca/cb*csth*ssth-3D0*MW/SW*csth*sa*sb*ssth-MW
     &      /CW**2*SW*ca/cb*csth*ssth+MW/CW**2*SW*csth*sa
     &      *sb*ssth-6D0*Ms/MW/SW/cb*mue*sa*ssth**2-3D0*MW
     &      /SW*ca/cb*csth*sb**2*ssth+MW/CW**2*SW*ca/cb*csth
     &      *sb**2*ssth)
      AAABR(1070) = EE*(3D0*MW/SW*csth*sa*sb*ssth-3D0*MW
     &      /SW*csth*sa*sb**3*ssth-MW/CW**2*SW*csth*sa*sb
     &      *ssth+MW/CW**2*SW*csth*sa*sb**3*ssth+3D0*Ms/MW
     &      /SW/cb*mue*sa*sb**2+3D0*MW/SW*ca/cb*csth*sb**2
     &      *ssth-3D0*MW/SW*ca/cb*csth*sb**4*ssth-MW/CW**2
     &      *SW*ca/cb*csth*sb**2*ssth+MW/CW**2*SW*ca/cb*csth
     &      *sb**4*ssth-6D0*Ms/MW/SW/cb*mue*sa*sb**2*ssth
     &      **2)
      AAABR(1071) = EE*MW/SW*csth*ssth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(1072) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-6D0*Ms**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*ssth**2-3D0*MW/SW*sa*sb*ssth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*ssth**2
     &      +MW/CW**2*SW*sa*sb*ssth**2-3D0*MW/SW*ca/cb*sb
     &      **2*ssth**2+MW/CW**2*SW*ca/cb*sb**2*ssth**2+6D0
     &      *As/MW*Ms/SW*ca/cb*csth*ssth-6D0*Ms/MW/SW/cb
     &      *csth*mue*sa*ssth)
      AAABR(1073) = EE/CW**2*MW*SW*csth*ssth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(1074) = EE/CW**3*MW*SW**2*csth*ssth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(1075) = EE/MW/SW/cb*(As*ca-mue*sa-2D0*As*ca*ssth
     &      **2+2D0*mue*sa*ssth**2)
      AAABR(1076) = EE*(3D0*Mb/MW/SW/cb*mue*sa+3D0*MW/SW
     &      *ca/cb*cbth*sbth-3D0*MW/SW*cbth*sa*sb*sbth-MW
     &      /CW**2*SW*ca/cb*cbth*sbth+MW/CW**2*SW*cbth*sa
     &      *sb*sbth-6D0*Mb/MW/SW/cb*mue*sa*sbth**2-3D0*MW
     &      /SW*ca/cb*cbth*sb**2*sbth+MW/CW**2*SW*ca/cb*cbth
     &      *sb**2*sbth)
      AAABR(1077) = EE*(3D0*MW/SW*cbth*sa*sb*sbth-3D0*MW
     &      /SW*cbth*sa*sb**3*sbth-MW/CW**2*SW*cbth*sa*sb
     &      *sbth+MW/CW**2*SW*cbth*sa*sb**3*sbth+3D0*Mb/MW
     &      /SW/cb*mue*sa*sb**2+3D0*MW/SW*ca/cb*cbth*sb**2
     &      *sbth-3D0*MW/SW*ca/cb*cbth*sb**4*sbth-MW/CW**2
     &      *SW*ca/cb*cbth*sb**2*sbth+MW/CW**2*SW*ca/cb*cbth
     &      *sb**4*sbth-6D0*Mb/MW/SW/cb*mue*sa*sb**2*sbth
     &      **2)
      AAABR(1078) = EE*MW/SW*cbth*sbth*(ca/cb-sa*sb-ca/cb
     &      *sb**2)
      AAABR(1079) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb-6D0*Mb**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*sbth**2-3D0*MW/SW*sa*sb*sbth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sbth**2
     &      +MW/CW**2*SW*sa*sb*sbth**2-3D0*MW/SW*ca/cb*sb
     &      **2*sbth**2+MW/CW**2*SW*ca/cb*sb**2*sbth**2+6D0
     &      *Ab/MW*Mb/SW*ca/cb*cbth*sbth-6D0*Mb/MW/SW/cb
     &      *cbth*mue*sa*sbth)
      AAABR(1080) = EE/CW**2*MW*SW*cbth*sbth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(1081) = EE/CW**3*MW*SW**2*cbth*sbth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(1082) = EE/MW/SW/cb*(Ab*ca-mue*sa-2D0*Ab*ca*sbth
     &      **2+2D0*mue*sa*sbth**2)
      AAABR(1083) = EE/SW*Sqrt2*(MW*cuth*sdth-Md**2/MW*cuth
     &      *sdth-MW*cuth*sb**2*sdth+Ad/MW*Md*cdth*cuth+Md
     &      /MW*Mu*cdth*suth-Mu/MW/cb*mue/sb*sdth*suth+Mu
     &      /MW/cb*mue*sb*sdth*suth)
      AAABR(1084) = EE/SW*Sqrt2*(MW*cuth*sdth+Md**2/MW*cuth
     &      *sdth-Mu**2/MW*cuth*sdth-2D0*MW*cuth*sb**2*sdth
     &      +Md/MW/cb*cdth*cuth*mue*sb+Mu/MW/cb*mue/sb*sdth
     &      *suth-Mu/MW/cb*mue*sb*sdth*suth)
      AAABR(1085) = EE/SW*Sqrt2*(Mu**2/MW*cuth*sdth+2D0*MW
     &      *cuth*sb**2*sdth-2D0*MW*cuth*sb**4*sdth-Md/MW
     &      *Mu*cdth*suth+Md**2/MW*cuth*sb**2*sdth-Mu**2
     &      /MW*cuth*sb**2*sdth+Md/MW/cb*cdth*cuth*mue*sb
     &      **3-Mu/MW/cb*mue/sb*sdth*suth+2D0*Mu/MW/cb*mue
     &      *sb*sdth*suth-Mu/MW/cb*mue*sb**3*sdth*suth)
      AAABR(1086) = EE*MW/SW*Sqrt2*cuth*sdth*(1D0-2D0*sb**2)
      AAABR(1087) = EE/SW*Sqrt2*(Mu**2/MW*cuth*sdth-MW*cuth
     &      *sb**2*sdth+Au/MW*Mu*sdth*suth-Md/MW*Mu*cdth
     &      *suth-Md/MW/cb*cdth*cuth*mue*sb)
      AAABR(1088) = EE/MW/SW*Sqrt2*cuth*(Ad*cdth-2D0*Md*sdth
     &      -cdth/cb*mue*sb)
      AAABR(1089) = EE/MW/SW*Sqrt2/cb*(Md*cdth*cuth*sb+Mu
     &      /sb*sdth*suth-Mu*sb*sdth*suth)
      AAABR(1090) = EE/MW/SW*Sqrt2*sdth*(Au*suth+2D0*Mu*cuth
     &      -mue/cb/sb*suth+mue/cb*sb*suth)
      AAABR(1091) = EE/MW*Mu/SW*Sqrt2*sdth*suth
      AAABR(1092) = EE/MW*Md/SW*Sqrt2*cdth*cuth
      AAABR(1093) = EE/SW*Sqrt2*(MW*ccth*ssth-Ms**2/MW*ccth
     &      *ssth-MW*ccth*sb**2*ssth+As/MW*Ms*ccth*csth+Mc
     &      /MW*Ms*csth*scth-Mc/MW/cb*mue/sb*scth*ssth+Mc
     &      /MW/cb*mue*sb*scth*ssth)
      AAABR(1094) = EE/SW*Sqrt2*(MW*ccth*ssth-Mc**2/MW*ccth
     &      *ssth+Ms**2/MW*ccth*ssth-2D0*MW*ccth*sb**2*ssth
     &      +Mc/MW/cb*mue/sb*scth*ssth-Mc/MW/cb*mue*sb*scth
     &      *ssth+Ms/MW/cb*ccth*csth*mue*sb)
      AAABR(1095) = EE/SW*Sqrt2*(Mc**2/MW*ccth*ssth+2D0*MW
     &      *ccth*sb**2*ssth-2D0*MW*ccth*sb**4*ssth-Mc/MW
     &      *Ms*csth*scth-Mc**2/MW*ccth*sb**2*ssth+Ms**2
     &      /MW*ccth*sb**2*ssth-Mc/MW/cb*mue/sb*scth*ssth
     &      +2D0*Mc/MW/cb*mue*sb*scth*ssth-Mc/MW/cb*mue*sb
     &      **3*scth*ssth+Ms/MW/cb*ccth*csth*mue*sb**3)
      AAABR(1096) = EE*MW/SW*Sqrt2*ccth*ssth*(1D0-2D0*sb**2)
      AAABR(1097) = EE/SW*Sqrt2*(Mc**2/MW*ccth*ssth-MW*ccth
     &      *sb**2*ssth+Ac/MW*Mc*scth*ssth-Mc/MW*Ms*csth
     &      *scth-Ms/MW/cb*ccth*csth*mue*sb)
      AAABR(1098) = EE/MW/SW*Sqrt2*ccth*(As*csth-2D0*Ms*ssth
     &      -csth/cb*mue*sb)
      AAABR(1099) = EE/MW/SW*Sqrt2/cb*(Mc/sb*scth*ssth-Mc
     &      *sb*scth*ssth+Ms*ccth*csth*sb)
      AAABR(1100) = EE/MW/SW*Sqrt2*ssth*(Ac*scth+2D0*Mc*ccth
     &      -mue/cb/sb*scth+mue/cb*sb*scth)
      AAABR(1101) = EE/MW*Mc/SW*Sqrt2*scth*ssth
      AAABR(1102) = EE/MW*Ms/SW*Sqrt2*ccth*csth
      AAABR(1103) = EE/SW*Sqrt2*(MW*ctth*sbth-Mb**2/MW*ctth
     &      *sbth-MW*ctth*sb**2*sbth+Ab/MW*Mb*cbth*ctth+Mb
     &      /MW*Mt*cbth*stth-Mt/MW/cb*mue/sb*sbth*stth+Mt
     &      /MW/cb*mue*sb*sbth*stth)
      AAABR(1104) = EE/SW*Sqrt2*(MW*ctth*sbth+Mb**2/MW*ctth
     &      *sbth-Mt**2/MW*ctth*sbth-2D0*MW*ctth*sb**2*sbth
     &      +Mb/MW/cb*cbth*ctth*mue*sb+Mt/MW/cb*mue/sb*sbth
     &      *stth-Mt/MW/cb*mue*sb*sbth*stth)
      AAABR(1105) = EE/SW*Sqrt2*(Mt**2/MW*ctth*sbth+2D0*MW
     &      *ctth*sb**2*sbth-2D0*MW*ctth*sb**4*sbth-Mb/MW
     &      *Mt*cbth*stth+Mb**2/MW*ctth*sb**2*sbth-Mt**2
     &      /MW*ctth*sb**2*sbth+Mb/MW/cb*cbth*ctth*mue*sb
     &      **3-Mt/MW/cb*mue/sb*sbth*stth+2D0*Mt/MW/cb*mue
     &      *sb*sbth*stth-Mt/MW/cb*mue*sb**3*sbth*stth)
      AAABR(1106) = EE*MW/SW*Sqrt2*ctth*sbth*(1D0-2D0*sb**2)
      AAABR(1107) = EE/SW*Sqrt2*(Mt**2/MW*ctth*sbth-MW*ctth
     &      *sb**2*sbth+At/MW*Mt*sbth*stth-Mb/MW*Mt*cbth
     &      *stth-Mb/MW/cb*cbth*ctth*mue*sb)
      AAABR(1108) = EE/MW/SW*Sqrt2*ctth*(Ab*cbth-2D0*Mb*sbth
     &      -cbth/cb*mue*sb)
      AAABR(1109) = EE/MW/SW*Sqrt2/cb*(Mb*cbth*ctth*sb+Mt
     &      /sb*sbth*stth-Mt*sb*sbth*stth)
      AAABR(1110) = EE/MW/SW*Sqrt2*sbth*(At*stth+2D0*Mt*ctth
     &      -mue/cb/sb*stth+mue/cb*sb*stth)
      AAABR(1111) = EE/MW*Mt/SW*Sqrt2*sbth*stth
      AAABR(1112) = EE/MW*Mb/SW*Sqrt2*cbth*ctth
      AAABR(1113) = EE/SW*Sqrt2*(MW*sbth*stth-Mb**2/MW*sbth
     &      *stth-MW*sb**2*sbth*stth+Ab/MW*Mb*cbth*stth-Mb
     &      /MW*Mt*cbth*ctth+Mt/MW/cb*ctth*mue/sb*sbth-Mt
     &      /MW/cb*ctth*mue*sb*sbth)
      AAABR(1114) = EE/SW*Sqrt2*(MW*sbth*stth+Mb**2/MW*sbth
     &      *stth-Mt**2/MW*sbth*stth-2D0*MW*sb**2*sbth*stth
     &      +Mb/MW/cb*cbth*mue*sb*stth-Mt/MW/cb*ctth*mue
     &      /sb*sbth+Mt/MW/cb*ctth*mue*sb*sbth)
      AAABR(1115) = EE/SW*Sqrt2*(Mt**2/MW*sbth*stth+2D0*MW
     &      *sb**2*sbth*stth-2D0*MW*sb**4*sbth*stth+Mb/MW
     &      *Mt*cbth*ctth+Mb**2/MW*sb**2*sbth*stth-Mt**2
     &      /MW*sb**2*sbth*stth+Mb/MW/cb*cbth*mue*sb**3*stth
     &      +Mt/MW/cb*ctth*mue/sb*sbth-2D0*Mt/MW/cb*ctth
     &      *mue*sb*sbth+Mt/MW/cb*ctth*mue*sb**3*sbth)
      AAABR(1116) = EE*MW/SW*Sqrt2*sbth*stth*(1D0-2D0*sb**2)
      AAABR(1117) = EE/SW*Sqrt2*(Mt**2/MW*sbth*stth-MW*sb
     &      **2*sbth*stth-At/MW*Mt*ctth*sbth+Mb/MW*Mt*cbth
     &      *ctth-Mb/MW/cb*cbth*mue*sb*stth)
      AAABR(1118) = EE/MW/SW*Sqrt2*stth*(Ab*cbth-2D0*Mb*sbth
     &      -cbth/cb*mue*sb)
      AAABR(1119) = EE/MW/SW*Sqrt2/cb*(Mb*cbth*sb*stth-Mt
     &      *ctth/sb*sbth+Mt*ctth*sb*sbth)
      AAABR(1120) = EE/MW/SW*Sqrt2*sbth*(At*ctth-2D0*Mt*stth
     &      -ctth/cb*mue/sb+ctth/cb*mue*sb)
      AAABR(1121) = EE/MW*Mt/SW*Sqrt2*ctth*sbth
      AAABR(1122) = EE/MW*Mb/SW*Sqrt2*cbth*stth
      AAABR(1123) = EE/SW*Sqrt2*(MW*sdth*suth-Md**2/MW*sdth
     &      *suth-MW*sb**2*sdth*suth+Ad/MW*Md*cdth*suth-Md
     &      /MW*Mu*cdth*cuth+Mu/MW/cb*cuth*mue/sb*sdth-Mu
     &      /MW/cb*cuth*mue*sb*sdth)
      AAABR(1124) = EE/SW*Sqrt2*(MW*sdth*suth+Md**2/MW*sdth
     &      *suth-Mu**2/MW*sdth*suth-2D0*MW*sb**2*sdth*suth
     &      +Md/MW/cb*cdth*mue*sb*suth-Mu/MW/cb*cuth*mue
     &      /sb*sdth+Mu/MW/cb*cuth*mue*sb*sdth)
      AAABR(1125) = EE/SW*Sqrt2*(Mu**2/MW*sdth*suth+2D0*MW
     &      *sb**2*sdth*suth-2D0*MW*sb**4*sdth*suth+Md/MW
     &      *Mu*cdth*cuth+Md**2/MW*sb**2*sdth*suth-Mu**2
     &      /MW*sb**2*sdth*suth+Md/MW/cb*cdth*mue*sb**3*suth
     &      +Mu/MW/cb*cuth*mue/sb*sdth-2D0*Mu/MW/cb*cuth
     &      *mue*sb*sdth+Mu/MW/cb*cuth*mue*sb**3*sdth)
      AAABR(1126) = EE*MW/SW*Sqrt2*sdth*suth*(1D0-2D0*sb**2)
      AAABR(1127) = EE/SW*Sqrt2*(Mu**2/MW*sdth*suth-MW*sb
     &      **2*sdth*suth-Au/MW*Mu*cuth*sdth+Md/MW*Mu*cdth
     &      *cuth-Md/MW/cb*cdth*mue*sb*suth)
      AAABR(1128) = EE/MW/SW*Sqrt2*suth*(Ad*cdth-2D0*Md*sdth
     &      -cdth/cb*mue*sb)
      AAABR(1129) = EE/MW/SW*Sqrt2/cb*(Md*cdth*sb*suth-Mu
     &      *cuth/sb*sdth+Mu*cuth*sb*sdth)
      AAABR(1130) = EE/MW/SW*Sqrt2*sdth*(Au*cuth-2D0*Mu*suth
     &      -cuth/cb*mue/sb+cuth/cb*mue*sb)
      AAABR(1131) = EE/MW*Mu/SW*Sqrt2*cuth*sdth
      AAABR(1132) = EE/MW*Md/SW*Sqrt2*cdth*suth
      AAABR(1133) = EE/SW*Sqrt2*(MW*scth*ssth-Ms**2/MW*scth
     &      *ssth-MW*sb**2*scth*ssth+As/MW*Ms*csth*scth-Mc
     &      /MW*Ms*ccth*csth+Mc/MW/cb*ccth*mue/sb*ssth-Mc
     &      /MW/cb*ccth*mue*sb*ssth)
      AAABR(1134) = EE/SW*Sqrt2*(MW*scth*ssth-Mc**2/MW*scth
     &      *ssth+Ms**2/MW*scth*ssth-2D0*MW*sb**2*scth*ssth
     &      -Mc/MW/cb*ccth*mue/sb*ssth+Mc/MW/cb*ccth*mue
     &      *sb*ssth+Ms/MW/cb*csth*mue*sb*scth)
      AAABR(1135) = EE/SW*Sqrt2*(Mc**2/MW*scth*ssth+2D0*MW
     &      *sb**2*scth*ssth-2D0*MW*sb**4*scth*ssth+Mc/MW
     &      *Ms*ccth*csth-Mc**2/MW*sb**2*scth*ssth+Ms**2
     &      /MW*sb**2*scth*ssth+Mc/MW/cb*ccth*mue/sb*ssth
     &      -2D0*Mc/MW/cb*ccth*mue*sb*ssth+Mc/MW/cb*ccth
     &      *mue*sb**3*ssth+Ms/MW/cb*csth*mue*sb**3*scth)
      AAABR(1136) = EE*MW/SW*Sqrt2*scth*ssth*(1D0-2D0*sb**2)
      AAABR(1137) = EE/SW*Sqrt2*(Mc**2/MW*scth*ssth-MW*sb
     &      **2*scth*ssth-Ac/MW*Mc*ccth*ssth+Mc/MW*Ms*ccth
     &      *csth-Ms/MW/cb*csth*mue*sb*scth)
      AAABR(1138) = EE/MW/SW*Sqrt2*scth*(As*csth-2D0*Ms*ssth
     &      -csth/cb*mue*sb)
      AAABR(1139) = EE/MW/SW*Sqrt2/cb*(Mc*ccth/sb*ssth-Mc
     &      *ccth*sb*ssth-Ms*csth*sb*scth)
      AAABR(1140) = EE/MW/SW*Sqrt2*ssth*(Ac*ccth-2D0*Mc*scth
     &      -ccth/cb*mue/sb+ccth/cb*mue*sb)
      AAABR(1141) = EE/MW*Mc/SW*Sqrt2*ccth*ssth
      AAABR(1142) = EE/MW*Ms/SW*Sqrt2*csth*scth
      AAABR(1143) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+6D0*Ms**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*ssth**2+3D0*MW/SW/cb*sa*ssth**2-MW/CW**2
     &      *SW*ca*sb*ssth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*ssth**2-3D0*MW/SW/cb*sa*sb
     &      **2*ssth**2+MW/CW**2*SW/cb*sa*sb**2*ssth**2-6D0
     &      *Ms/MW/SW*ca/cb*csth*mue*ssth)
      AAABR(1144) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+3D0*MW/SW*ca*sb*ssth**2-3D0*MW/SW
     &      *ca*sb**3*ssth**2-MW/CW**2*SW*ca*sb*ssth**2+MW
     &      /CW**2*SW*ca*sb**3*ssth**2-2D0*MW/CW**2*SW/cb
     &      *sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-6D0*Ms
     &      **2/MW/SW/cb*sa*sb**2-3D0*MW/SW/cb*sa*sb**2*ssth
     &      **2+3D0*MW/SW/cb*sa*sb**4*ssth**2+MW/CW**2*SW
     &      /cb*sa*sb**2*ssth**2-MW/CW**2*SW/cb*sa*sb**4
     &      *ssth**2+6D0*Ms/MW/SW*ca/cb*csth*mue*sb**2*ssth)
      AAABR(1145) = EE*MW/SW*ssth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(1146) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-ca
     &      *sb*ssth**2-2D0*sa/cb*sb**2-sa/cb*ssth**2+sa
     &      /cb*sb**2*ssth**2)
      AAABR(1147) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -ca*sb*ssth**2-2D0*sa/cb*sb**2-sa/cb*ssth**2
     &      +sa/cb*sb**2*ssth**2)
      AAABR(1148) = EE/MW/SW/cb*(2D0*Ms*sa-As*csth*sa*ssth
     &      -ca*csth*mue*ssth)
      AAABR(1149) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+6D0*Md**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*sdth**2-3D0*MW/SW*sa*sb*sdth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sdth**2
     &      +MW/CW**2*SW*sa*sb*sdth**2-3D0*MW/SW*ca/cb*sb
     &      **2*sdth**2+MW/CW**2*SW*ca/cb*sb**2*sdth**2+6D0
     &      *Md/MW/SW/cb*cdth*mue*sa*sdth)
      AAABR(1150) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+3D0*MW/SW*sa*sb*sdth**2-3D0*MW/SW
     &      *sa*sb**3*sdth**2+2D0*MW/CW**2*SW*ca/cb*sb**2
     &      -2D0*MW/CW**2*SW*ca/cb*sb**4-MW/CW**2*SW*sa*sb
     &      *sdth**2+MW/CW**2*SW*sa*sb**3*sdth**2+6D0*Md
     &      **2/MW/SW*ca/cb*sb**2+3D0*MW/SW*ca/cb*sb**2*sdth
     &      **2-3D0*MW/SW*ca/cb*sb**4*sdth**2-MW/CW**2*SW
     &      *ca/cb*sb**2*sdth**2+MW/CW**2*SW*ca/cb*sb**4
     &      *sdth**2+6D0*Md/MW/SW/cb*cdth*mue*sa*sb**2*sdth)
      AAABR(1151) = EE*MW/SW*sdth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(1152) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-ca/cb*sdth**2+sa*sb*sdth**2+ca/cb
     &      *sb**2*sdth**2)
      AAABR(1153) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-ca/cb*sdth**2+sa*sb*sdth**2
     &      +ca/cb*sb**2*sdth**2)
      AAABR(1154) = EE/MW/SW/cb*(2D0*Md*ca-Ad*ca*cdth*sdth
     &      +cdth*mue*sa*sdth)
      AAABR(1155) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+6D0*Mb**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*sbth**2+3D0*MW/SW/cb*sa*sbth**2-MW/CW**2
     &      *SW*ca*sb*sbth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*sbth**2-3D0*MW/SW/cb*sa*sb
     &      **2*sbth**2+MW/CW**2*SW/cb*sa*sb**2*sbth**2-6D0
     &      *Mb/MW/SW*ca/cb*cbth*mue*sbth)
      AAABR(1156) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+3D0*MW/SW*ca*sb*sbth**2-3D0*MW/SW
     &      *ca*sb**3*sbth**2-MW/CW**2*SW*ca*sb*sbth**2+MW
     &      /CW**2*SW*ca*sb**3*sbth**2-2D0*MW/CW**2*SW/cb
     &      *sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-6D0*Mb
     &      **2/MW/SW/cb*sa*sb**2-3D0*MW/SW/cb*sa*sb**2*sbth
     &      **2+3D0*MW/SW/cb*sa*sb**4*sbth**2+MW/CW**2*SW
     &      /cb*sa*sb**2*sbth**2-MW/CW**2*SW/cb*sa*sb**4
     &      *sbth**2+6D0*Mb/MW/SW*ca/cb*cbth*mue*sb**2*sbth)
      AAABR(1157) = EE*MW/SW*sbth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(1158) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-ca
     &      *sb*sbth**2-2D0*sa/cb*sb**2-sa/cb*sbth**2+sa
     &      /cb*sb**2*sbth**2)
      AAABR(1159) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -ca*sb*sbth**2-2D0*sa/cb*sb**2-sa/cb*sbth**2
     &      +sa/cb*sb**2*sbth**2)
      AAABR(1160) = EE/MW/SW/cb*(2D0*Mb*sa-Ab*cbth*sa*sbth
     &      -ca*cbth*mue*sbth)
      AAABR(1161) = EE*(2D0*MW/CW**2*SW*ca*sb+2D0*MW/CW**2
     &      *SW/cb*sa+6D0*Md**2/MW/SW/cb*sa+3D0*MW/SW*ca
     &      *sb*sdth**2+3D0*MW/SW/cb*sa*sdth**2-MW/CW**2
     &      *SW*ca*sb*sdth**2-2D0*MW/CW**2*SW/cb*sa*sb**2
     &      -MW/CW**2*SW/cb*sa*sdth**2-3D0*MW/SW/cb*sa*sb
     &      **2*sdth**2+MW/CW**2*SW/cb*sa*sb**2*sdth**2-6D0
     &      *Md/MW/SW*ca/cb*cdth*mue*sdth)
      AAABR(1162) = EE*(2D0*MW/CW**2*SW*ca*sb-2D0*MW/CW**2
     &      *SW*ca*sb**3+3D0*MW/SW*ca*sb*sdth**2-3D0*MW/SW
     &      *ca*sb**3*sdth**2-MW/CW**2*SW*ca*sb*sdth**2+MW
     &      /CW**2*SW*ca*sb**3*sdth**2-2D0*MW/CW**2*SW/cb
     &      *sa*sb**2+2D0*MW/CW**2*SW/cb*sa*sb**4-6D0*Md
     &      **2/MW/SW/cb*sa*sb**2-3D0*MW/SW/cb*sa*sb**2*sdth
     &      **2+3D0*MW/SW/cb*sa*sb**4*sdth**2+MW/CW**2*SW
     &      /cb*sa*sb**2*sdth**2-MW/CW**2*SW/cb*sa*sb**4
     &      *sdth**2+6D0*Md/MW/SW*ca/cb*cdth*mue*sb**2*sdth)
      AAABR(1163) = EE*MW/SW*sdth**2*(ca*sb+sa/cb-sa/cb*sb
     &      **2)
      AAABR(1164) = EE/CW**2*MW*SW*(2D0*ca*sb+2D0*sa/cb-ca
     &      *sb*sdth**2-2D0*sa/cb*sb**2-sa/cb*sdth**2+sa
     &      /cb*sb**2*sdth**2)
      AAABR(1165) = EE/CW**3*MW*SW**2*(2D0*ca*sb+2D0*sa/cb
     &      -ca*sb*sdth**2-2D0*sa/cb*sb**2-sa/cb*sdth**2
     &      +sa/cb*sb**2*sdth**2)
      AAABR(1166) = EE/MW/SW/cb*(2D0*Md*sa-Ad*cdth*sa*sdth
     &      -ca*cdth*mue*sdth)
      AAABR(1167) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+6D0*Ms**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*ssth**2-3D0*MW/SW*sa*sb*ssth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*ssth**2
     &      +MW/CW**2*SW*sa*sb*ssth**2-3D0*MW/SW*ca/cb*sb
     &      **2*ssth**2+MW/CW**2*SW*ca/cb*sb**2*ssth**2+6D0
     &      *Ms/MW/SW/cb*csth*mue*sa*ssth)
      AAABR(1168) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+3D0*MW/SW*sa*sb*ssth**2-3D0*MW/SW
     &      *sa*sb**3*ssth**2+2D0*MW/CW**2*SW*ca/cb*sb**2
     &      -2D0*MW/CW**2*SW*ca/cb*sb**4-MW/CW**2*SW*sa*sb
     &      *ssth**2+MW/CW**2*SW*sa*sb**3*ssth**2+6D0*Ms
     &      **2/MW/SW*ca/cb*sb**2+3D0*MW/SW*ca/cb*sb**2*ssth
     &      **2-3D0*MW/SW*ca/cb*sb**4*ssth**2-MW/CW**2*SW
     &      *ca/cb*sb**2*ssth**2+MW/CW**2*SW*ca/cb*sb**4
     &      *ssth**2+6D0*Ms/MW/SW/cb*csth*mue*sa*sb**2*ssth)
      AAABR(1169) = EE*MW/SW*ssth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(1170) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-ca/cb*ssth**2+sa*sb*ssth**2+ca/cb
     &      *sb**2*ssth**2)
      AAABR(1171) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-ca/cb*ssth**2+sa*sb*ssth**2
     &      +ca/cb*sb**2*ssth**2)
      AAABR(1172) = EE/MW/SW/cb*(2D0*Ms*ca-As*ca*csth*ssth
     &      +csth*mue*sa*ssth)
      AAABR(1173) = EE*(2D0*MW/CW**2*SW*ca/cb-2D0*MW/CW**2
     &      *SW*sa*sb+6D0*Mb**2/MW/SW*ca/cb+3D0*MW/SW*ca
     &      /cb*sbth**2-3D0*MW/SW*sa*sb*sbth**2-2D0*MW/CW
     &      **2*SW*ca/cb*sb**2-MW/CW**2*SW*ca/cb*sbth**2
     &      +MW/CW**2*SW*sa*sb*sbth**2-3D0*MW/SW*ca/cb*sb
     &      **2*sbth**2+MW/CW**2*SW*ca/cb*sb**2*sbth**2+6D0
     &      *Mb/MW/SW/cb*cbth*mue*sa*sbth)
      AAABR(1174) = EE*(2D0*MW/CW**2*SW*sa*sb-2D0*MW/CW**2
     &      *SW*sa*sb**3+3D0*MW/SW*sa*sb*sbth**2-3D0*MW/SW
     &      *sa*sb**3*sbth**2+2D0*MW/CW**2*SW*ca/cb*sb**2
     &      -2D0*MW/CW**2*SW*ca/cb*sb**4-MW/CW**2*SW*sa*sb
     &      *sbth**2+MW/CW**2*SW*sa*sb**3*sbth**2+6D0*Mb
     &      **2/MW/SW*ca/cb*sb**2+3D0*MW/SW*ca/cb*sb**2*sbth
     &      **2-3D0*MW/SW*ca/cb*sb**4*sbth**2-MW/CW**2*SW
     &      *ca/cb*sb**2*sbth**2+MW/CW**2*SW*ca/cb*sb**4
     &      *sbth**2+6D0*Mb/MW/SW/cb*cbth*mue*sa*sb**2*sbth)
      AAABR(1175) = EE*MW/SW*sbth**2*(ca/cb-sa*sb-ca/cb*sb
     &      **2)
      AAABR(1176) = EE/CW**2*MW*SW*(2D0*ca/cb-2D0*sa*sb-2D0
     &      *ca/cb*sb**2-ca/cb*sbth**2+sa*sb*sbth**2+ca/cb
     &      *sb**2*sbth**2)
      AAABR(1177) = EE/CW**3*MW*SW**2*(2D0*ca/cb-2D0*sa*sb
     &      -2D0*ca/cb*sb**2-ca/cb*sbth**2+sa*sb*sbth**2
     &      +ca/cb*sb**2*sbth**2)
      AAABR(1178) = EE/MW/SW/cb*(2D0*Mb*ca-Ab*ca*cbth*sbth
     &      +cbth*mue*sa*sbth)
      AAABR(1179) = EE/MW*Mu/SW*(Au-cb*mue/sb)
      AAABR(1180) = EE/MW*Mu/SW*cb*mue/sb
      AAABR(1181) = EE/MW*Mu/SW*cb*mue*(1D0/sb-sb)
      AAABR(1182) = EE/MW/SW*(Au-cb*mue/sb)
      AAABR(1183) = Au*EE/MW*Mu/SW
      AAABR(1184) = EE/MW*Mc/SW*(Ac-cb*mue/sb)
      AAABR(1185) = EE/MW*Mc/SW*cb*mue/sb
      AAABR(1186) = EE/MW*Mc/SW*cb*mue*(1D0/sb-sb)
      AAABR(1187) = EE/MW/SW*(Ac-cb*mue/sb)
      AAABR(1188) = Ac*EE/MW*Mc/SW
      AAABR(1189) = EE/MW*Mt/SW*(At-cb*mue/sb)
      AAABR(1190) = EE/MW*Mt/SW*cb*mue/sb
      AAABR(1191) = EE/MW*Mt/SW*cb*mue*(1D0/sb-sb)
      AAABR(1192) = EE/MW/SW*(At-cb*mue/sb)
      AAABR(1193) = At*EE/MW*Mt/SW
      AAABR(1194) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb+6D0*Mc**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*scth**2+3D0*MW/SW*sa
     &      *sb*scth**2+5D0*MW/CW**2*SW*ca*cb*scth**2-5D0
     &      *MW/CW**2*SW*sa*sb*scth**2+6D0*Ac/MW*Mc/SW*ccth
     &      *sa/sb*scth-6D0*Mc/MW/SW*ca*ccth*mue/sb*scth)
      AAABR(1195) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa-6D0*Mc**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*scth**2-3D0*MW/SW*cb
     &      *sa*scth**2+5D0*MW/CW**2*SW*ca*sb*scth**2+5D0
     &      *MW/CW**2*SW*cb*sa*scth**2-6D0*Ac/MW*Mc/SW*ca
     &      *ccth/sb*scth-6D0*Mc/MW/SW*ccth*mue*sa/sb*scth)
      AAABR(1196) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb-6D0*Mc**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*scth**2+3D0*MW/SW*sa
     &      *sb*scth**2+5D0*MW/CW**2*SW*ca*cb*scth**2-5D0
     &      *MW/CW**2*SW*sa*sb*scth**2+6D0*Mc/MW/SW*ca*ccth
     &      *mue/sb*scth)
      AAABR(1197) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      -MW/CW**2*SW*sa*sb+MW/CW**2*SW*sa*sb**3+6D0*Mc
     &      **2/MW/SW*sa/sb-6D0*Mc**2/MW/SW*sa*sb+3D0*MW
     &      /SW*ca*cb*sb**2-3D0*MW/SW*sa*sb*scth**2+3D0*MW
     &      /SW*sa*sb**3*scth**2-MW/CW**2*SW*ca*cb*sb**2
     &      +5D0*MW/CW**2*SW*sa*sb*scth**2-5D0*MW/CW**2*SW
     &      *sa*sb**3*scth**2-3D0*MW/SW*ca*cb*sb**2*scth
     &      **2+5D0*MW/CW**2*SW*ca*cb*sb**2*scth**2-6D0*Mc
     &      /MW/SW*ca*ccth*mue/sb*scth+6D0*Mc/MW/SW*ca*ccth
     &      *mue*sb*scth)
      AAABR(1198) = EE*MW/SW*(ca*cb-sa*sb-ca*cb*scth**2+sa
     &      *sb*scth**2)
      AAABR(1199) = EE*(3D0*Ac/MW*Mc/SW*sa/sb-3D0*Mc/MW/SW
     &      *ca*mue/sb-3D0*MW/SW*ca*cb*ccth*scth+3D0*MW/SW
     &      *ccth*sa*sb*scth-6D0*Ac/MW*Mc/SW*sa/sb*scth**2
     &      +5D0*MW/CW**2*SW*ca*cb*ccth*scth-5D0*MW/CW**2
     &      *SW*ccth*sa*sb*scth+6D0*Mc/MW/SW*ca*mue/sb*scth
     &      **2)
      AAABR(1200) = EE/CW**2*MW*SW*(ca*cb-sa*sb-5D0*ca*cb
     &      *scth**2+5D0*sa*sb*scth**2)
      AAABR(1201) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb-5D0*ca
     &      *cb*scth**2+5D0*sa*sb*scth**2)
      AAABR(1202) = EE/MW/SW/sb*(2D0*Mc*sa+Ac*ccth*sa*scth
     &      -ca*ccth*mue*scth)
      AAABR(1203) = EE/MW*Mc/SW*ca*ccth/sb*scth
      AAABR(1204) = EE/MW*Mc/SW*ccth*sa/sb*scth
      AAABR(1205) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb+6D0*Mt**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*stth**2+3D0*MW/SW*sa
     &      *sb*stth**2+5D0*MW/CW**2*SW*ca*cb*stth**2-5D0
     &      *MW/CW**2*SW*sa*sb*stth**2+6D0*At/MW*Mt/SW*ctth
     &      *sa/sb*stth-6D0*Mt/MW/SW*ca*ctth*mue/sb*stth)
      AAABR(1206) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa-6D0*Mt**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*stth**2-3D0*MW/SW*cb
     &      *sa*stth**2+5D0*MW/CW**2*SW*ca*sb*stth**2+5D0
     &      *MW/CW**2*SW*cb*sa*stth**2-6D0*At/MW*Mt/SW*ca
     &      *ctth/sb*stth-6D0*Mt/MW/SW*ctth*mue*sa/sb*stth)
      AAABR(1207) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb-6D0*Mt**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*stth**2+3D0*MW/SW*sa
     &      *sb*stth**2+5D0*MW/CW**2*SW*ca*cb*stth**2-5D0
     &      *MW/CW**2*SW*sa*sb*stth**2+6D0*Mt/MW/SW*ca*ctth
     &      *mue/sb*stth)
      AAABR(1208) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      -MW/CW**2*SW*sa*sb+MW/CW**2*SW*sa*sb**3+6D0*Mt
     &      **2/MW/SW*sa/sb-6D0*Mt**2/MW/SW*sa*sb+3D0*MW
     &      /SW*ca*cb*sb**2-3D0*MW/SW*sa*sb*stth**2+3D0*MW
     &      /SW*sa*sb**3*stth**2-MW/CW**2*SW*ca*cb*sb**2
     &      +5D0*MW/CW**2*SW*sa*sb*stth**2-5D0*MW/CW**2*SW
     &      *sa*sb**3*stth**2-3D0*MW/SW*ca*cb*sb**2*stth
     &      **2+5D0*MW/CW**2*SW*ca*cb*sb**2*stth**2-6D0*Mt
     &      /MW/SW*ca*ctth*mue/sb*stth+6D0*Mt/MW/SW*ca*ctth
     &      *mue*sb*stth)
      AAABR(1209) = EE*MW/SW*(ca*cb-sa*sb-ca*cb*stth**2+sa
     &      *sb*stth**2)
      AAABR(1210) = EE*(3D0*At/MW*Mt/SW*sa/sb-3D0*Mt/MW/SW
     &      *ca*mue/sb-3D0*MW/SW*ca*cb*ctth*stth+3D0*MW/SW
     &      *ctth*sa*sb*stth-6D0*At/MW*Mt/SW*sa/sb*stth**2
     &      +5D0*MW/CW**2*SW*ca*cb*ctth*stth-5D0*MW/CW**2
     &      *SW*ctth*sa*sb*stth+6D0*Mt/MW/SW*ca*mue/sb*stth
     &      **2)
      AAABR(1211) = EE/CW**2*MW*SW*(ca*cb-sa*sb-5D0*ca*cb
     &      *stth**2+5D0*sa*sb*stth**2)
      AAABR(1212) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb-5D0*ca
     &      *cb*stth**2+5D0*sa*sb*stth**2)
      AAABR(1213) = EE/MW/SW/sb*(2D0*Mt*sa+At*ctth*sa*stth
     &      -ca*ctth*mue*stth)
      AAABR(1214) = EE/MW*Mt/SW*ca*ctth/sb*stth
      AAABR(1215) = EE/MW*Mt/SW*ctth*sa/sb*stth
      AAABR(1216) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa+6D0*Mc**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*scth**2-3D0*MW/SW*cb
     &      *sa*scth**2+5D0*MW/CW**2*SW*ca*sb*scth**2+5D0
     &      *MW/CW**2*SW*cb*sa*scth**2+6D0*Mc/MW/SW*ccth
     &      *mue*sa/sb*scth)
      AAABR(1217) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      -MW/CW**2*SW*ca*sb+MW/CW**2*SW*ca*sb**3+6D0*Mc
     &      **2/MW/SW*ca/sb-6D0*Mc**2/MW/SW*ca*sb-3D0*MW
     &      /SW*ca*sb*scth**2+3D0*MW/SW*ca*sb**3*scth**2
     &      -3D0*MW/SW*cb*sa*sb**2+5D0*MW/CW**2*SW*ca*sb
     &      *scth**2-5D0*MW/CW**2*SW*ca*sb**3*scth**2+MW
     &      /CW**2*SW*cb*sa*sb**2+3D0*MW/SW*cb*sa*sb**2*scth
     &      **2-5D0*MW/CW**2*SW*cb*sa*sb**2*scth**2+6D0*Mc
     &      /MW/SW*ccth*mue*sa/sb*scth-6D0*Mc/MW/SW*ccth
     &      *mue*sa*sb*scth)
      AAABR(1218) = EE*MW/SW*(ca*sb+cb*sa-ca*sb*scth**2-cb
     &      *sa*scth**2)
      AAABR(1219) = EE*(3D0*Ac/MW*Mc/SW*ca/sb+3D0*Mc/MW/SW
     &      *mue*sa/sb+3D0*MW/SW*ca*ccth*sb*scth+3D0*MW/SW
     &      *cb*ccth*sa*scth-6D0*Ac/MW*Mc/SW*ca/sb*scth**2
     &      -5D0*MW/CW**2*SW*ca*ccth*sb*scth-5D0*MW/CW**2
     &      *SW*cb*ccth*sa*scth-6D0*Mc/MW/SW*mue*sa/sb*scth
     &      **2)
      AAABR(1220) = EE/CW**2*MW*SW*(ca*sb+cb*sa-5D0*ca*sb
     &      *scth**2-5D0*cb*sa*scth**2)
      AAABR(1221) = EE/CW**3*MW*SW**2*(ca*sb+cb*sa-5D0*ca
     &      *sb*scth**2-5D0*cb*sa*scth**2)
      AAABR(1222) = EE/MW/SW/sb*(2D0*Mc*ca+Ac*ca*ccth*scth
     &      +ccth*mue*sa*scth)
      AAABR(1223) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb+6D0*Mu**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*suth**2+3D0*MW/SW*sa
     &      *sb*suth**2+5D0*MW/CW**2*SW*ca*cb*suth**2-5D0
     &      *MW/CW**2*SW*sa*sb*suth**2+6D0*Au/MW*Mu/SW*cuth
     &      *sa/sb*suth-6D0*Mu/MW/SW*ca*cuth*mue/sb*suth)
      AAABR(1224) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa-6D0*Mu**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*suth**2-3D0*MW/SW*cb
     &      *sa*suth**2+5D0*MW/CW**2*SW*ca*sb*suth**2+5D0
     &      *MW/CW**2*SW*cb*sa*suth**2-6D0*Au/MW*Mu/SW*ca
     &      *cuth/sb*suth-6D0*Mu/MW/SW*cuth*mue*sa/sb*suth)
      AAABR(1225) = EE*(3D0*MW/SW*ca*cb-3D0*MW/SW*sa*sb-MW
     &      /CW**2*SW*ca*cb+MW/CW**2*SW*sa*sb-6D0*Mu**2/MW
     &      /SW*sa/sb-3D0*MW/SW*ca*cb*suth**2+3D0*MW/SW*sa
     &      *sb*suth**2+5D0*MW/CW**2*SW*ca*cb*suth**2-5D0
     &      *MW/CW**2*SW*sa*sb*suth**2+6D0*Mu/MW/SW*ca*cuth
     &      *mue/sb*suth)
      AAABR(1226) = EE*(3D0*MW/SW*sa*sb-3D0*MW/SW*sa*sb**3
     &      -MW/CW**2*SW*sa*sb+MW/CW**2*SW*sa*sb**3+6D0*Mu
     &      **2/MW/SW*sa/sb-6D0*Mu**2/MW/SW*sa*sb+3D0*MW
     &      /SW*ca*cb*sb**2-3D0*MW/SW*sa*sb*suth**2+3D0*MW
     &      /SW*sa*sb**3*suth**2-MW/CW**2*SW*ca*cb*sb**2
     &      +5D0*MW/CW**2*SW*sa*sb*suth**2-5D0*MW/CW**2*SW
     &      *sa*sb**3*suth**2-3D0*MW/SW*ca*cb*sb**2*suth
     &      **2+5D0*MW/CW**2*SW*ca*cb*sb**2*suth**2-6D0*Mu
     &      /MW/SW*ca*cuth*mue/sb*suth+6D0*Mu/MW/SW*ca*cuth
     &      *mue*sb*suth)
      AAABR(1227) = EE*MW/SW*(ca*cb-sa*sb-ca*cb*suth**2+sa
     &      *sb*suth**2)
      AAABR(1228) = EE*(3D0*Au/MW*Mu/SW*sa/sb-3D0*Mu/MW/SW
     &      *ca*mue/sb-3D0*MW/SW*ca*cb*cuth*suth+3D0*MW/SW
     &      *cuth*sa*sb*suth-6D0*Au/MW*Mu/SW*sa/sb*suth**2
     &      +5D0*MW/CW**2*SW*ca*cb*cuth*suth-5D0*MW/CW**2
     &      *SW*cuth*sa*sb*suth+6D0*Mu/MW/SW*ca*mue/sb*suth
     &      **2)
      AAABR(1229) = EE/CW**2*MW*SW*(ca*cb-sa*sb-5D0*ca*cb
     &      *suth**2+5D0*sa*sb*suth**2)
      AAABR(1230) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb-5D0*ca
     &      *cb*suth**2+5D0*sa*sb*suth**2)
      AAABR(1231) = EE/MW/SW/sb*(2D0*Mu*sa+Au*cuth*sa*suth
     &      -ca*cuth*mue*suth)
      AAABR(1232) = EE/MW*Mu/SW*ca*cuth/sb*suth
      AAABR(1233) = EE/MW*Mu/SW*cuth*sa/sb*suth
      AAABR(1234) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa+6D0*Mt**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*stth**2-3D0*MW/SW*cb
     &      *sa*stth**2+5D0*MW/CW**2*SW*ca*sb*stth**2+5D0
     &      *MW/CW**2*SW*cb*sa*stth**2+6D0*Mt/MW/SW*ctth
     &      *mue*sa/sb*stth)
      AAABR(1235) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      -MW/CW**2*SW*ca*sb+MW/CW**2*SW*ca*sb**3+6D0*Mt
     &      **2/MW/SW*ca/sb-6D0*Mt**2/MW/SW*ca*sb-3D0*MW
     &      /SW*ca*sb*stth**2+3D0*MW/SW*ca*sb**3*stth**2
     &      -3D0*MW/SW*cb*sa*sb**2+5D0*MW/CW**2*SW*ca*sb
     &      *stth**2-5D0*MW/CW**2*SW*ca*sb**3*stth**2+MW
     &      /CW**2*SW*cb*sa*sb**2+3D0*MW/SW*cb*sa*sb**2*stth
     &      **2-5D0*MW/CW**2*SW*cb*sa*sb**2*stth**2+6D0*Mt
     &      /MW/SW*ctth*mue*sa/sb*stth-6D0*Mt/MW/SW*ctth
     &      *mue*sa*sb*stth)
      AAABR(1236) = EE*MW/SW*(ca*sb+cb*sa-ca*sb*stth**2-cb
     &      *sa*stth**2)
      AAABR(1237) = EE*(3D0*At/MW*Mt/SW*ca/sb+3D0*Mt/MW/SW
     &      *mue*sa/sb+3D0*MW/SW*ca*ctth*sb*stth+3D0*MW/SW
     &      *cb*ctth*sa*stth-6D0*At/MW*Mt/SW*ca/sb*stth**2
     &      -5D0*MW/CW**2*SW*ca*ctth*sb*stth-5D0*MW/CW**2
     &      *SW*cb*ctth*sa*stth-6D0*Mt/MW/SW*mue*sa/sb*stth
     &      **2)
      AAABR(1238) = EE/CW**2*MW*SW*(ca*sb+cb*sa-5D0*ca*sb
     &      *stth**2-5D0*cb*sa*stth**2)
      AAABR(1239) = EE/CW**3*MW*SW**2*(ca*sb+cb*sa-5D0*ca
     &      *sb*stth**2-5D0*cb*sa*stth**2)
      AAABR(1240) = EE/MW/SW/sb*(2D0*Mt*ca+At*ca*ctth*stth
     &      +ctth*mue*sa*stth)
      AAABR(1241) = EE*(3D0*MW/SW*ca*sb+3D0*MW/SW*cb*sa-MW
     &      /CW**2*SW*ca*sb-MW/CW**2*SW*cb*sa+6D0*Mu**2/MW
     &      /SW*ca/sb-3D0*MW/SW*ca*sb*suth**2-3D0*MW/SW*cb
     &      *sa*suth**2+5D0*MW/CW**2*SW*ca*sb*suth**2+5D0
     &      *MW/CW**2*SW*cb*sa*suth**2+6D0*Mu/MW/SW*cuth
     &      *mue*sa/sb*suth)
      AAABR(1242) = EE*(3D0*MW/SW*ca*sb-3D0*MW/SW*ca*sb**3
     &      -MW/CW**2*SW*ca*sb+MW/CW**2*SW*ca*sb**3+6D0*Mu
     &      **2/MW/SW*ca/sb-6D0*Mu**2/MW/SW*ca*sb-3D0*MW
     &      /SW*ca*sb*suth**2+3D0*MW/SW*ca*sb**3*suth**2
     &      -3D0*MW/SW*cb*sa*sb**2+5D0*MW/CW**2*SW*ca*sb
     &      *suth**2-5D0*MW/CW**2*SW*ca*sb**3*suth**2+MW
     &      /CW**2*SW*cb*sa*sb**2+3D0*MW/SW*cb*sa*sb**2*suth
     &      **2-5D0*MW/CW**2*SW*cb*sa*sb**2*suth**2+6D0*Mu
     &      /MW/SW*cuth*mue*sa/sb*suth-6D0*Mu/MW/SW*cuth
     &      *mue*sa*sb*suth)
      AAABR(1243) = EE*MW/SW*(ca*sb+cb*sa-ca*sb*suth**2-cb
     &      *sa*suth**2)
      AAABR(1244) = EE*(3D0*Au/MW*Mu/SW*ca/sb+3D0*Mu/MW/SW
     &      *mue*sa/sb+3D0*MW/SW*ca*cuth*sb*suth+3D0*MW/SW
     &      *cb*cuth*sa*suth-6D0*Au/MW*Mu/SW*ca/sb*suth**2
     &      -5D0*MW/CW**2*SW*ca*cuth*sb*suth-5D0*MW/CW**2
     &      *SW*cb*cuth*sa*suth-6D0*Mu/MW/SW*mue*sa/sb*suth
     &      **2)
      AAABR(1245) = EE/CW**2*MW*SW*(ca*sb+cb*sa-5D0*ca*sb
     &      *suth**2-5D0*cb*sa*suth**2)
      AAABR(1246) = EE/CW**3*MW*SW**2*(ca*sb+cb*sa-5D0*ca
     &      *sb*suth**2-5D0*cb*sa*suth**2)
      AAABR(1247) = EE/MW/SW/sb*(2D0*Mu*ca+Au*ca*cuth*suth
     &      +cuth*mue*sa*suth)
      AAABR(1248) = EE*(3D0*Mt/MW/SW*mue*sa/sb-3D0*MW/SW
     &      *ca*ctth*sb*stth-3D0*MW/SW*cb*ctth*sa*stth+5D0
     &      *MW/CW**2*SW*ca*ctth*sb*stth+5D0*MW/CW**2*SW
     &      *cb*ctth*sa*stth-6D0*Mt/MW/SW*mue*sa/sb*stth**2)
      AAABR(1249) = EE*(3D0*Mt/MW/SW*mue*sa/sb-3D0*Mt/MW
     &      /SW*mue*sa*sb-3D0*MW/SW*ca*ctth*sb*stth+3D0*MW
     &      /SW*ca*ctth*sb**3*stth+5D0*MW/CW**2*SW*ca*ctth
     &      *sb*stth-5D0*MW/CW**2*SW*ca*ctth*sb**3*stth-6D0
     &      *Mt/MW/SW*mue*sa/sb*stth**2+6D0*Mt/MW/SW*mue
     &      *sa*sb*stth**2+3D0*MW/SW*cb*ctth*sa*sb**2*stth
     &      -5D0*MW/CW**2*SW*cb*ctth*sa*sb**2*stth)
      AAABR(1250) = EE*MW/SW*ctth*stth*(ca*sb+cb*sa)
      AAABR(1251) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa-6D0*Mt**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*stth**2+3D0*MW/SW*cb*sa*stth**2-5D0*MW/CW
     &      **2*SW*ca*sb*stth**2-5D0*MW/CW**2*SW*cb*sa*stth
     &      **2+6D0*At/MW*Mt/SW*ca*ctth/sb*stth+6D0*Mt/MW
     &      /SW*ctth*mue*sa/sb*stth)
      AAABR(1252) = EE/CW**2*MW*SW*ctth*stth*(ca*sb+cb*sa)
      AAABR(1253) = EE/CW**3*MW*SW**2*ctth*stth*(ca*sb+cb
     &      *sa)
      AAABR(1254) = EE/MW/SW/sb*(At*ca+mue*sa-2D0*At*ca*stth
     &      **2-2D0*mue*sa*stth**2)
      AAABR(1255) = EE/MW*Mt/SW*sa/sb*(1D0-2D0*stth**2)
      AAABR(1256) = EE/MW*Mt/SW*ca/sb*(1D0-2D0*stth**2)
      AAABR(1257) = EE*(3D0*Mt/MW/SW*ca*mue/sb-3D0*MW/SW
     &      *ca*cb*ctth*stth+3D0*MW/SW*ctth*sa*sb*stth+5D0
     &      *MW/CW**2*SW*ca*cb*ctth*stth-5D0*MW/CW**2*SW
     &      *ctth*sa*sb*stth-6D0*Mt/MW/SW*ca*mue/sb*stth**2)
      AAABR(1258) = EE*(3D0*Mt/MW/SW*ca*mue/sb-3D0*Mt/MW
     &      /SW*ca*mue*sb+3D0*MW/SW*ctth*sa*sb*stth-3D0*MW
     &      /SW*ctth*sa*sb**3*stth-5D0*MW/CW**2*SW*ctth*sa
     &      *sb*stth+5D0*MW/CW**2*SW*ctth*sa*sb**3*stth-6D0
     &      *Mt/MW/SW*ca*mue/sb*stth**2+6D0*Mt/MW/SW*ca*mue
     &      *sb*stth**2+3D0*MW/SW*ca*cb*ctth*sb**2*stth-5D0
     &      *MW/CW**2*SW*ca*cb*ctth*sb**2*stth)
      AAABR(1259) = EE*MW/SW*ctth*stth*(ca*cb-sa*sb)
      AAABR(1260) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb+6D0*Mt**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*stth**2-3D0*MW/SW*sa*sb*stth**2-5D0*MW/CW
     &      **2*SW*ca*cb*stth**2+5D0*MW/CW**2*SW*sa*sb*stth
     &      **2-6D0*At/MW*Mt/SW*ctth*sa/sb*stth+6D0*Mt/MW
     &      /SW*ca*ctth*mue/sb*stth)
      AAABR(1261) = EE/CW**2*MW*SW*ctth*stth*(ca*cb-sa*sb)
      AAABR(1262) = EE/CW**3*MW*SW**2*ctth*stth*(ca*cb-sa
     &      *sb)
      AAABR(1263) = EE/MW/SW/sb*(At*sa-ca*mue-2D0*At*sa*stth
     &      **2+2D0*ca*mue*stth**2)
      AAABR(1264) = EE*(3D0*Mu/MW/SW*ca*mue/sb-3D0*MW/SW
     &      *ca*cb*cuth*suth+3D0*MW/SW*cuth*sa*sb*suth+5D0
     &      *MW/CW**2*SW*ca*cb*cuth*suth-5D0*MW/CW**2*SW
     &      *cuth*sa*sb*suth-6D0*Mu/MW/SW*ca*mue/sb*suth**2)
      AAABR(1265) = EE*(3D0*Mu/MW/SW*ca*mue/sb-3D0*Mu/MW
     &      /SW*ca*mue*sb+3D0*MW/SW*cuth*sa*sb*suth-3D0*MW
     &      /SW*cuth*sa*sb**3*suth-5D0*MW/CW**2*SW*cuth*sa
     &      *sb*suth+5D0*MW/CW**2*SW*cuth*sa*sb**3*suth-6D0
     &      *Mu/MW/SW*ca*mue/sb*suth**2+6D0*Mu/MW/SW*ca*mue
     &      *sb*suth**2+3D0*MW/SW*ca*cb*cuth*sb**2*suth-5D0
     &      *MW/CW**2*SW*ca*cb*cuth*sb**2*suth)
      AAABR(1266) = EE*MW/SW*cuth*suth*(ca*cb-sa*sb)
      AAABR(1267) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb+6D0*Mu**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*suth**2-3D0*MW/SW*sa*sb*suth**2-5D0*MW/CW
     &      **2*SW*ca*cb*suth**2+5D0*MW/CW**2*SW*sa*sb*suth
     &      **2-6D0*Au/MW*Mu/SW*cuth*sa/sb*suth+6D0*Mu/MW
     &      /SW*ca*cuth*mue/sb*suth)
      AAABR(1268) = EE/CW**2*MW*SW*cuth*suth*(ca*cb-sa*sb)
      AAABR(1269) = EE/CW**3*MW*SW**2*cuth*suth*(ca*cb-sa
     &      *sb)
      AAABR(1270) = EE/MW/SW/sb*(Au*sa-ca*mue-2D0*Au*sa*suth
     &      **2+2D0*ca*mue*suth**2)
      AAABR(1271) = EE/MW*Mu/SW*ca/sb*(1D0-2D0*suth**2)
      AAABR(1272) = EE/MW*Mu/SW*sa/sb*(1D0-2D0*suth**2)
      AAABR(1273) = EE*(3D0*Mu/MW/SW*mue*sa/sb-3D0*MW/SW
     &      *ca*cuth*sb*suth-3D0*MW/SW*cb*cuth*sa*suth+5D0
     &      *MW/CW**2*SW*ca*cuth*sb*suth+5D0*MW/CW**2*SW
     &      *cb*cuth*sa*suth-6D0*Mu/MW/SW*mue*sa/sb*suth**2)
      AAABR(1274) = EE*(3D0*Mu/MW/SW*mue*sa/sb-3D0*Mu/MW
     &      /SW*mue*sa*sb-3D0*MW/SW*ca*cuth*sb*suth+3D0*MW
     &      /SW*ca*cuth*sb**3*suth+5D0*MW/CW**2*SW*ca*cuth
     &      *sb*suth-5D0*MW/CW**2*SW*ca*cuth*sb**3*suth-6D0
     &      *Mu/MW/SW*mue*sa/sb*suth**2+6D0*Mu/MW/SW*mue
     &      *sa*sb*suth**2+3D0*MW/SW*cb*cuth*sa*sb**2*suth
     &      -5D0*MW/CW**2*SW*cb*cuth*sa*sb**2*suth)
      AAABR(1275) = EE*MW/SW*cuth*suth*(ca*sb+cb*sa)
      AAABR(1276) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa-6D0*Mu**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*suth**2+3D0*MW/SW*cb*sa*suth**2-5D0*MW/CW
     &      **2*SW*ca*sb*suth**2-5D0*MW/CW**2*SW*cb*sa*suth
     &      **2+6D0*Au/MW*Mu/SW*ca*cuth/sb*suth+6D0*Mu/MW
     &      /SW*cuth*mue*sa/sb*suth)
      AAABR(1277) = EE/CW**2*MW*SW*cuth*suth*(ca*sb+cb*sa)
      AAABR(1278) = EE/CW**3*MW*SW**2*cuth*suth*(ca*sb+cb
     &      *sa)
      AAABR(1279) = EE/MW/SW/sb*(Au*ca+mue*sa-2D0*Au*ca*suth
     &      **2-2D0*mue*sa*suth**2)
      AAABR(1280) = EE*(3D0*Mc/MW/SW*ca*mue/sb-3D0*MW/SW
     &      *ca*cb*ccth*scth+3D0*MW/SW*ccth*sa*sb*scth+5D0
     &      *MW/CW**2*SW*ca*cb*ccth*scth-5D0*MW/CW**2*SW
     &      *ccth*sa*sb*scth-6D0*Mc/MW/SW*ca*mue/sb*scth**2)
      AAABR(1281) = EE*(3D0*Mc/MW/SW*ca*mue/sb-3D0*Mc/MW
     &      /SW*ca*mue*sb+3D0*MW/SW*ccth*sa*sb*scth-3D0*MW
     &      /SW*ccth*sa*sb**3*scth-5D0*MW/CW**2*SW*ccth*sa
     &      *sb*scth+5D0*MW/CW**2*SW*ccth*sa*sb**3*scth-6D0
     &      *Mc/MW/SW*ca*mue/sb*scth**2+6D0*Mc/MW/SW*ca*mue
     &      *sb*scth**2+3D0*MW/SW*ca*cb*ccth*sb**2*scth-5D0
     &      *MW/CW**2*SW*ca*cb*ccth*sb**2*scth)
      AAABR(1282) = EE*MW/SW*ccth*scth*(ca*cb-sa*sb)
      AAABR(1283) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb+6D0*Mc**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*scth**2-3D0*MW/SW*sa*sb*scth**2-5D0*MW/CW
     &      **2*SW*ca*cb*scth**2+5D0*MW/CW**2*SW*sa*sb*scth
     &      **2-6D0*Ac/MW*Mc/SW*ccth*sa/sb*scth+6D0*Mc/MW
     &      /SW*ca*ccth*mue/sb*scth)
      AAABR(1284) = EE/CW**2*MW*SW*ccth*scth*(ca*cb-sa*sb)
      AAABR(1285) = EE/CW**3*MW*SW**2*ccth*scth*(ca*cb-sa
     &      *sb)
      AAABR(1286) = EE/MW/SW/sb*(Ac*sa-ca*mue-2D0*Ac*sa*scth
     &      **2+2D0*ca*mue*scth**2)
      AAABR(1287) = EE/MW*Mc/SW*ca/sb*(1D0-2D0*scth**2)
      AAABR(1288) = EE/MW*Mc/SW*sa/sb*(1D0-2D0*scth**2)
      AAABR(1289) = EE*(3D0*Mc/MW/SW*mue*sa/sb-3D0*MW/SW
     &      *ca*ccth*sb*scth-3D0*MW/SW*cb*ccth*sa*scth+5D0
     &      *MW/CW**2*SW*ca*ccth*sb*scth+5D0*MW/CW**2*SW
     &      *cb*ccth*sa*scth-6D0*Mc/MW/SW*mue*sa/sb*scth**2)
      AAABR(1290) = EE*(3D0*Mc/MW/SW*mue*sa/sb-3D0*Mc/MW
     &      /SW*mue*sa*sb-3D0*MW/SW*ca*ccth*sb*scth+3D0*MW
     &      /SW*ca*ccth*sb**3*scth+5D0*MW/CW**2*SW*ca*ccth
     &      *sb*scth-5D0*MW/CW**2*SW*ca*ccth*sb**3*scth-6D0
     &      *Mc/MW/SW*mue*sa/sb*scth**2+6D0*Mc/MW/SW*mue
     &      *sa*sb*scth**2+3D0*MW/SW*cb*ccth*sa*sb**2*scth
     &      -5D0*MW/CW**2*SW*cb*ccth*sa*sb**2*scth)
      AAABR(1291) = EE*MW/SW*ccth*scth*(ca*sb+cb*sa)
      AAABR(1292) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa-6D0*Mc**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*scth**2+3D0*MW/SW*cb*sa*scth**2-5D0*MW/CW
     &      **2*SW*ca*sb*scth**2-5D0*MW/CW**2*SW*cb*sa*scth
     &      **2+6D0*Ac/MW*Mc/SW*ca*ccth/sb*scth+6D0*Mc/MW
     &      /SW*ccth*mue*sa/sb*scth)
      AAABR(1293) = EE/CW**2*MW*SW*ccth*scth*(ca*sb+cb*sa)
      AAABR(1294) = EE/CW**3*MW*SW**2*ccth*scth*(ca*sb+cb
     &      *sa)
      AAABR(1295) = EE/MW/SW/sb*(Ac*ca+mue*sa-2D0*Ac*ca*scth
     &      **2-2D0*mue*sa*scth**2)
      AAABR(1296) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb-6D0*Mc**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*scth**2-3D0*MW/SW*sa*sb*scth**2-5D0*MW/CW
     &      **2*SW*ca*cb*scth**2+5D0*MW/CW**2*SW*sa*sb*scth
     &      **2-6D0*Mc/MW/SW*ca*ccth*mue/sb*scth)
      AAABR(1297) = EE*(4D0*MW/CW**2*SW*sa*sb-4D0*MW/CW**2
     &      *SW*sa*sb**3+6D0*Mc**2/MW/SW*sa/sb-6D0*Mc**2
     &      /MW/SW*sa*sb+3D0*MW/SW*sa*sb*scth**2-3D0*MW/SW
     &      *sa*sb**3*scth**2+4D0*MW/CW**2*SW*ca*cb*sb**2
     &      -5D0*MW/CW**2*SW*sa*sb*scth**2+5D0*MW/CW**2*SW
     &      *sa*sb**3*scth**2+3D0*MW/SW*ca*cb*sb**2*scth
     &      **2-5D0*MW/CW**2*SW*ca*cb*sb**2*scth**2+6D0*Mc
     &      /MW/SW*ca*ccth*mue/sb*scth-6D0*Mc/MW/SW*ca*ccth
     &      *mue*sb*scth)
      AAABR(1298) = EE*MW/SW*scth**2*(ca*cb-sa*sb)
      AAABR(1299) = EE/CW**2*MW*SW*(4D0*ca*cb-4D0*sa*sb-5D0
     &      *ca*cb*scth**2+5D0*sa*sb*scth**2)
      AAABR(1300) = EE/CW**3*MW*SW**2*(4D0*ca*cb-4D0*sa*sb
     &      -5D0*ca*cb*scth**2+5D0*sa*sb*scth**2)
      AAABR(1301) = EE/MW/SW/sb*(2D0*Mc*sa-Ac*ccth*sa*scth
     &      +ca*ccth*mue*scth)
      AAABR(1302) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb-6D0*Mu**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*suth**2-3D0*MW/SW*sa*sb*suth**2-5D0*MW/CW
     &      **2*SW*ca*cb*suth**2+5D0*MW/CW**2*SW*sa*sb*suth
     &      **2-6D0*Mu/MW/SW*ca*cuth*mue/sb*suth)
      AAABR(1303) = EE*(4D0*MW/CW**2*SW*sa*sb-4D0*MW/CW**2
     &      *SW*sa*sb**3+6D0*Mu**2/MW/SW*sa/sb-6D0*Mu**2
     &      /MW/SW*sa*sb+3D0*MW/SW*sa*sb*suth**2-3D0*MW/SW
     &      *sa*sb**3*suth**2+4D0*MW/CW**2*SW*ca*cb*sb**2
     &      -5D0*MW/CW**2*SW*sa*sb*suth**2+5D0*MW/CW**2*SW
     &      *sa*sb**3*suth**2+3D0*MW/SW*ca*cb*sb**2*suth
     &      **2-5D0*MW/CW**2*SW*ca*cb*sb**2*suth**2+6D0*Mu
     &      /MW/SW*ca*cuth*mue/sb*suth-6D0*Mu/MW/SW*ca*cuth
     &      *mue*sb*suth)
      AAABR(1304) = EE*MW/SW*suth**2*(ca*cb-sa*sb)
      AAABR(1305) = EE/CW**2*MW*SW*(4D0*ca*cb-4D0*sa*sb-5D0
     &      *ca*cb*suth**2+5D0*sa*sb*suth**2)
      AAABR(1306) = EE/CW**3*MW*SW**2*(4D0*ca*cb-4D0*sa*sb
     &      -5D0*ca*cb*suth**2+5D0*sa*sb*suth**2)
      AAABR(1307) = EE/MW/SW/sb*(2D0*Mu*sa-Au*cuth*sa*suth
     &      +ca*cuth*mue*suth)
      AAABR(1308) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa+6D0*Mt**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*stth**2+3D0*MW/SW*cb*sa*stth**2-5D0*MW/CW
     &      **2*SW*ca*sb*stth**2-5D0*MW/CW**2*SW*cb*sa*stth
     &      **2-6D0*Mt/MW/SW*ctth*mue*sa/sb*stth)
      AAABR(1309) = EE*(4D0*MW/CW**2*SW*ca*sb-4D0*MW/CW**2
     &      *SW*ca*sb**3+6D0*Mt**2/MW/SW*ca/sb-6D0*Mt**2
     &      /MW/SW*ca*sb+3D0*MW/SW*ca*sb*stth**2-3D0*MW/SW
     &      *ca*sb**3*stth**2-5D0*MW/CW**2*SW*ca*sb*stth
     &      **2+5D0*MW/CW**2*SW*ca*sb**3*stth**2-4D0*MW/CW
     &      **2*SW*cb*sa*sb**2-3D0*MW/SW*cb*sa*sb**2*stth
     &      **2+5D0*MW/CW**2*SW*cb*sa*sb**2*stth**2-6D0*Mt
     &      /MW/SW*ctth*mue*sa/sb*stth+6D0*Mt/MW/SW*ctth
     &      *mue*sa*sb*stth)
      AAABR(1310) = EE*MW/SW*stth**2*(ca*sb+cb*sa)
      AAABR(1311) = EE/CW**2*MW*SW*(4D0*ca*sb+4D0*cb*sa-5D0
     &      *ca*sb*stth**2-5D0*cb*sa*stth**2)
      AAABR(1312) = EE/CW**3*MW*SW**2*(4D0*ca*sb+4D0*cb*sa
     &      -5D0*ca*sb*stth**2-5D0*cb*sa*stth**2)
      AAABR(1313) = EE/MW/SW/sb*(2D0*Mt*ca-At*ca*ctth*stth
     &      -ctth*mue*sa*stth)
      AAABR(1314) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa+6D0*Mu**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*suth**2+3D0*MW/SW*cb*sa*suth**2-5D0*MW/CW
     &      **2*SW*ca*sb*suth**2-5D0*MW/CW**2*SW*cb*sa*suth
     &      **2-6D0*Mu/MW/SW*cuth*mue*sa/sb*suth)
      AAABR(1315) = EE*(4D0*MW/CW**2*SW*ca*sb-4D0*MW/CW**2
     &      *SW*ca*sb**3+6D0*Mu**2/MW/SW*ca/sb-6D0*Mu**2
     &      /MW/SW*ca*sb+3D0*MW/SW*ca*sb*suth**2-3D0*MW/SW
     &      *ca*sb**3*suth**2-5D0*MW/CW**2*SW*ca*sb*suth
     &      **2+5D0*MW/CW**2*SW*ca*sb**3*suth**2-4D0*MW/CW
     &      **2*SW*cb*sa*sb**2-3D0*MW/SW*cb*sa*sb**2*suth
     &      **2+5D0*MW/CW**2*SW*cb*sa*sb**2*suth**2-6D0*Mu
     &      /MW/SW*cuth*mue*sa/sb*suth+6D0*Mu/MW/SW*cuth
     &      *mue*sa*sb*suth)
      AAABR(1316) = EE*MW/SW*suth**2*(ca*sb+cb*sa)
      AAABR(1317) = EE/CW**2*MW*SW*(4D0*ca*sb+4D0*cb*sa-5D0
     &      *ca*sb*suth**2-5D0*cb*sa*suth**2)
      AAABR(1318) = EE/CW**3*MW*SW**2*(4D0*ca*sb+4D0*cb*sa
     &      -5D0*ca*sb*suth**2-5D0*cb*sa*suth**2)
      AAABR(1319) = EE/MW/SW/sb*(2D0*Mu*ca-Au*ca*cuth*suth
     &      -cuth*mue*sa*suth)
      AAABR(1320) = EE*(4D0*MW/CW**2*SW*ca*cb-4D0*MW/CW**2
     &      *SW*sa*sb-6D0*Mt**2/MW/SW*sa/sb+3D0*MW/SW*ca
     &      *cb*stth**2-3D0*MW/SW*sa*sb*stth**2-5D0*MW/CW
     &      **2*SW*ca*cb*stth**2+5D0*MW/CW**2*SW*sa*sb*stth
     &      **2-6D0*Mt/MW/SW*ca*ctth*mue/sb*stth)
      AAABR(1321) = EE*(4D0*MW/CW**2*SW*sa*sb-4D0*MW/CW**2
     &      *SW*sa*sb**3+6D0*Mt**2/MW/SW*sa/sb-6D0*Mt**2
     &      /MW/SW*sa*sb+3D0*MW/SW*sa*sb*stth**2-3D0*MW/SW
     &      *sa*sb**3*stth**2+4D0*MW/CW**2*SW*ca*cb*sb**2
     &      -5D0*MW/CW**2*SW*sa*sb*stth**2+5D0*MW/CW**2*SW
     &      *sa*sb**3*stth**2+3D0*MW/SW*ca*cb*sb**2*stth
     &      **2-5D0*MW/CW**2*SW*ca*cb*sb**2*stth**2+6D0*Mt
     &      /MW/SW*ca*ctth*mue/sb*stth-6D0*Mt/MW/SW*ca*ctth
     &      *mue*sb*stth)
      AAABR(1322) = EE*MW/SW*stth**2*(ca*cb-sa*sb)
      AAABR(1323) = EE/CW**2*MW*SW*(4D0*ca*cb-4D0*sa*sb-5D0
     &      *ca*cb*stth**2+5D0*sa*sb*stth**2)
      AAABR(1324) = EE/CW**3*MW*SW**2*(4D0*ca*cb-4D0*sa*sb
     &      -5D0*ca*cb*stth**2+5D0*sa*sb*stth**2)
      AAABR(1325) = EE/MW/SW/sb*(2D0*Mt*sa-At*ctth*sa*stth
     &      +ca*ctth*mue*stth)
      AAABR(1326) = EE*(4D0*MW/CW**2*SW*ca*sb+4D0*MW/CW**2
     &      *SW*cb*sa+6D0*Mc**2/MW/SW*ca/sb+3D0*MW/SW*ca
     &      *sb*scth**2+3D0*MW/SW*cb*sa*scth**2-5D0*MW/CW
     &      **2*SW*ca*sb*scth**2-5D0*MW/CW**2*SW*cb*sa*scth
     &      **2-6D0*Mc/MW/SW*ccth*mue*sa/sb*scth)
      AAABR(1327) = EE*(4D0*MW/CW**2*SW*ca*sb-4D0*MW/CW**2
     &      *SW*ca*sb**3+6D0*Mc**2/MW/SW*ca/sb-6D0*Mc**2
     &      /MW/SW*ca*sb+3D0*MW/SW*ca*sb*scth**2-3D0*MW/SW
     &      *ca*sb**3*scth**2-5D0*MW/CW**2*SW*ca*sb*scth
     &      **2+5D0*MW/CW**2*SW*ca*sb**3*scth**2-4D0*MW/CW
     &      **2*SW*cb*sa*sb**2-3D0*MW/SW*cb*sa*sb**2*scth
     &      **2+5D0*MW/CW**2*SW*cb*sa*sb**2*scth**2-6D0*Mc
     &      /MW/SW*ccth*mue*sa/sb*scth+6D0*Mc/MW/SW*ccth
     &      *mue*sa*sb*scth)
      AAABR(1328) = EE*MW/SW*scth**2*(ca*sb+cb*sa)
      AAABR(1329) = EE/CW**2*MW*SW*(4D0*ca*sb+4D0*cb*sa-5D0
     &      *ca*sb*scth**2-5D0*cb*sa*scth**2)
      AAABR(1330) = EE/CW**3*MW*SW**2*(4D0*ca*sb+4D0*cb*sa
     &      -5D0*ca*sb*scth**2-5D0*cb*sa*scth**2)
      AAABR(1331) = EE/MW/SW/sb*(2D0*Mc*ca-Ac*ca*ccth*scth
     &      -ccth*mue*sa*scth)
      AAABR(1332) = EE*MW*(2D0*nld2/SW-ca/SW*cb+sa/SW*sb
     &      -2D0*sa/SW*sb**3-SW/CW**2*ca*cb+SW/CW**2*sa*sb
     &      -2D0*SW/CW**2*sa*sb**3+2D0*ca/SW*cb*sb**2+2D0
     &      *SW/CW**2*ca*cb*sb**2)
      AAABR(1333) = EE*MW*(sa/SW*sb+sa/SW*sb**3-2D0*sa/SW
     &      *sb**5-SW/CW**2*sa*sb+3D0*SW/CW**2*sa*sb**3-2D0
     &      *SW/CW**2*sa*sb**5-3D0*ca/SW*cb*sb**2+2D0*ca
     &      /SW*cb*sb**4-SW/CW**2*ca*cb*sb**2+2D0*SW/CW**2
     &      *ca*cb*sb**4)
      AAABR(1334) = EE*MW*(ca/SW*cb+SW/CW**2*ca*cb-SW/CW
     &      **2*sa*sb+SW/CW**2*sa*sb**3-2D0*ca/SW*cb*sb**2
     &      -SW/CW**2*ca*cb*sb**2)
      AAABR(1335) = EE*MW*(sa/SW*sb-2D0*sa/SW*sb**3-SW/CW
     &      **2*sa*sb**3+SW/CW**2*ca*cb*sb**2)
      AAABR(1336) = EE*MW*(2D0*nld1/SW-ca/SW*sb+2D0*ca/SW
     &      *sb**3-cb/SW*sa-SW/CW**2*ca*sb+2D0*SW/CW**2*ca
     &      *sb**3-SW/CW**2*cb*sa+2D0*cb/SW*sa*sb**2+2D0
     &      *SW/CW**2*cb*sa*sb**2)
      AAABR(1337) = EE*MW*(ca/SW*sb+ca/SW*sb**3-2D0*ca/SW
     &      *sb**5-SW/CW**2*ca*sb+3D0*SW/CW**2*ca*sb**3-2D0
     &      *SW/CW**2*ca*sb**5+3D0*cb/SW*sa*sb**2-2D0*cb
     &      /SW*sa*sb**4+SW/CW**2*cb*sa*sb**2-2D0*SW/CW**2
     &      *cb*sa*sb**4)
      AAABR(1338) = EE*MW*(cb/SW*sa+SW/CW**2*ca*sb-SW/CW
     &      **2*ca*sb**3+SW/CW**2*cb*sa-2D0*cb/SW*sa*sb**2
     &      -SW/CW**2*cb*sa*sb**2)
      AAABR(1339) = EE*MW*(ca/SW*sb-2D0*ca/SW*sb**3-SW/CW
     &      **2*ca*sb**3-SW/CW**2*cb*sa*sb**2)
      AAABR(1340) = EE*MW*(2D0*nle2/CW**2/SW+ca/SW*cb-sa
     &      /SW*sb+2D0*sa/SW*sb**3+SW/CW**2*ca*cb-SW/CW**2
     &      *sa*sb+2D0*SW/CW**2*sa*sb**3-2D0*ca/SW*cb*sb
     &      **2-2D0*SW/CW**2*ca*cb*sb**2)
      AAABR(1341) = EE*MW*(2D0*nle1/CW**2/SW-ca/SW*sb+2D0
     &      *ca/SW*sb**3-cb/SW*sa-SW/CW**2*ca*sb+2D0*SW/CW
     &      **2*ca*sb**3-SW/CW**2*cb*sa+2D0*cb/SW*sa*sb**2
     &      +2D0*SW/CW**2*cb*sa*sb**2)
      AAABR(1342) = EE*MW*(ca/SW*cb-5D0*sa/SW*sb+6D0*sa**3
     &      /SW*sb+SW/CW**2*ca*cb-5D0*SW/CW**2*sa*sb+6D0
     &      *SW/CW**2*sa**3*sb-6D0*ca/SW*cb*sa**2-6D0*SW
     &      /CW**2*ca*cb*sa**2)
      AAABR(1343) = EE*MW*(ca/SW*sb+cb/SW*sa-2D0*cb/SW*sa
     &      **3+SW/CW**2*ca*sb+SW/CW**2*cb*sa-2D0*SW/CW**2
     &      *cb*sa**3-2D0*ca/SW*sa**2*sb-2D0*SW/CW**2*ca
     &      *sa**2*sb)
      AAABR(1344) = EE*MW/SW*(ca*sb+cb*sa-2D0*cb*sa**3-2D0
     &      *ca*sa**2*sb)
      AAABR(1345) = EE*MW*(ca/SW*sb-ca/SW*sb**3+SW/CW**2
     &      *ca*sb-SW/CW**2*ca*sb**3-2D0*ca/SW*sa**2*sb+2D0
     &      *ca/SW*sa**2*sb**3-cb/SW*sa*sb**2+2D0*cb/SW*sa
     &      **3*sb**2-2D0*SW/CW**2*ca*sa**2*sb+2D0*SW/CW
     &      **2*ca*sa**2*sb**3-SW/CW**2*cb*sa*sb**2+2D0*SW
     &      /CW**2*cb*sa**3*sb**2)
      AAABR(1346) = EE/CW**2*MW*SW*(ca*sb+cb*sa-2D0*cb*sa
     &      **3-2D0*ca*sa**2*sb)
      AAABR(1347) = EE/CW**3*MW*SW**2*(ca*sb+cb*sa-2D0*cb
     &      *sa**3-2D0*ca*sa**2*sb)
      AAABR(1348) = EE*MW*(ca/SW*cb-sa/SW*sb+2D0*sa**3/SW
     &      *sb+SW/CW**2*ca*cb-SW/CW**2*sa*sb+2D0*SW/CW**2
     &      *sa**3*sb-2D0*ca/SW*cb*sa**2-2D0*SW/CW**2*ca
     &      *cb*sa**2)
      AAABR(1349) = EE*MW*(ca/SW*sb+5D0*cb/SW*sa-6D0*cb/SW
     &      *sa**3+SW/CW**2*ca*sb+5D0*SW/CW**2*cb*sa-6D0
     &      *SW/CW**2*cb*sa**3-6D0*ca/SW*sa**2*sb-6D0*SW
     &      /CW**2*ca*sa**2*sb)
      AAABR(1350) = EE*MW/SW*(ca*sb+5D0*cb*sa-6D0*cb*sa**3
     &      -6D0*ca*sa**2*sb)
      AAABR(1351) = EE*MW*(ca/SW*sb-ca/SW*sb**3+SW/CW**2
     &      *ca*sb-SW/CW**2*ca*sb**3-6D0*ca/SW*sa**2*sb+6D0
     &      *ca/SW*sa**2*sb**3-5D0*cb/SW*sa*sb**2+6D0*cb
     &      /SW*sa**3*sb**2-6D0*SW/CW**2*ca*sa**2*sb+6D0
     &      *SW/CW**2*ca*sa**2*sb**3-5D0*SW/CW**2*cb*sa*sb
     &      **2+6D0*SW/CW**2*cb*sa**3*sb**2)
      AAABR(1352) = EE/CW**2*MW*SW*(ca*sb+5D0*cb*sa-6D0*cb
     &      *sa**3-6D0*ca*sa**2*sb)
      AAABR(1353) = EE/CW**3*MW*SW**2*(ca*sb+5D0*cb*sa-6D0
     &      *cb*sa**3-6D0*ca*sa**2*sb)
      AAABR(1354) = EE*MW/SW*(ca*cb-sa*sb+2D0*sa**3*sb-2D0
     &      *ca*cb*sa**2)
      AAABR(1355) = EE*MW*(sa/SW*sb-sa/SW*sb**3-2D0*sa**3
     &      /SW*sb+2D0*sa**3/SW*sb**3+SW/CW**2*sa*sb-SW/CW
     &      **2*sa*sb**3-2D0*SW/CW**2*sa**3*sb+2D0*SW/CW
     &      **2*sa**3*sb**3+ca/SW*cb*sb**2+SW/CW**2*ca*cb
     &      *sb**2-2D0*ca/SW*cb*sa**2*sb**2-2D0*SW/CW**2
     &      *ca*cb*sa**2*sb**2)
      AAABR(1356) = EE/CW**2*MW*SW*(ca*cb-sa*sb+2D0*sa**3
     &      *sb-2D0*ca*cb*sa**2)
      AAABR(1357) = EE/CW**3*MW*SW**2*(ca*cb-sa*sb+2D0*sa
     &      **3*sb-2D0*ca*cb*sa**2)
      AAABR(1358) = EE*MW/SW*(ca*cb-5D0*sa*sb+6D0*sa**3*sb
     &      -6D0*ca*cb*sa**2)
      AAABR(1359) = EE*MW*(5D0*sa/SW*sb-5D0*sa/SW*sb**3-6D0
     &      *sa**3/SW*sb+6D0*sa**3/SW*sb**3+5D0*SW/CW**2
     &      *sa*sb-5D0*SW/CW**2*sa*sb**3-6D0*SW/CW**2*sa
     &      **3*sb+6D0*SW/CW**2*sa**3*sb**3+ca/SW*cb*sb**2
     &      +SW/CW**2*ca*cb*sb**2-6D0*ca/SW*cb*sa**2*sb**2
     &      -6D0*SW/CW**2*ca*cb*sa**2*sb**2)
      AAABR(1360) = EE/CW**2*MW*SW*(ca*cb-5D0*sa*sb+6D0*sa
     &      **3*sb-6D0*ca*cb*sa**2)
      AAABR(1361) = EE/CW**3*MW*SW**2*(ca*cb-5D0*sa*sb+6D0
     &      *sa**3*sb-6D0*ca*cb*sa**2)
      AAABR(1362) = EE*sb**2
      AAABR(1363) = EE*(1D0-sb**2)
      AAABR(1364) = EE*(SW/CW-CW/SW-SW/CW*sb**2+CW/SW*sb**2)
      AAABR(1365) = EE*(SW/CW-CW/SW)
      AAABR(1366) = EE*sb**2*(SW/CW-CW/SW)
      AAABR(1367) = EE*(1D0+SW**2/CW**2)
      AAABR(1368) = EE/SW*sb**2
      AAABR(1369) = EE/SW*(1D0-sb**2)
      AAABR(1370) = EE/SW
      AAABR(1371) = EE*cb*sb
      AAABR(1372) = EE*cb*sb*(SW/CW-CW/SW)
      AAABR(1373) = EE/SW*cb*sb
      AAABR(1374) = EE/SW*sa*sb
      AAABR(1375) = EE/SW*(ca*sb-cb*sa)
      AAABR(1376) = EE/SW*(ca*cb+sa*sb)
      AAABR(1377) = EE/SW*ca*cb
      AAABR(1378) = EE/SW*ca*sb
      AAABR(1379) = EE/SW*cb*sa
      AAABR(1380) = EE/SW*nlr
      AAABR(1381) = CW*EE/SW*(ca*cb+sa*sb)
      AAABR(1382) = EE*(ca*cb+sa*sb)
      AAABR(1383) = CW*EE/SW*(ca*sb-cb*sa)
      AAABR(1384) = EE*(ca*sb-cb*sa)
      AAABR(1385) = EE*(SW/CW*ca*sb-SW/CW*cb*sa+CW/SW*ca
     &      *sb-CW/SW*cb*sa)
      AAABR(1386) = EE*sa*sb*(SW/CW+CW/SW)
      AAABR(1387) = EE*(SW/CW*ca*cb+SW/CW*sa*sb+CW/SW*ca
     &      *cb+CW/SW*sa*sb)
      AAABR(1388) = EE*(ca*cb+sa*sb+SW**2/CW**2*ca*cb+SW
     &      **2/CW**2*sa*sb)
      AAABR(1389) = EE*ca*cb*(SW/CW+CW/SW)
      AAABR(1390) = EE*ca*sb*(SW/CW+CW/SW)
      AAABR(1391) = EE*(ca*sb-cb*sa+SW**2/CW**2*ca*sb-SW
     &      **2/CW**2*cb*sa)
      AAABR(1392) = EE*cb*sa*(SW/CW+CW/SW)
      AAABR(1393) = CW*EE/SW*(1D0-slth**2)
      AAABR(1394) = EE*(1D0-slth**2)
      AAABR(1395) = CW*EE/SW*(1D0-seth**2)
      AAABR(1396) = EE*(1D0-seth**2)
      AAABR(1397) = CW*EE/SW*(1D0-smuth**2)
      AAABR(1398) = EE*(1D0-smuth**2)
      AAABR(1399) = EE*(SW/CW-CW/SW+SW/CW*seth**2+CW/SW*seth
     &      **2)
      AAABR(1400) = EE*ceth*seth*(SW/CW+CW/SW)
      AAABR(1401) = EE*(1D0+seth**2+SW**2/CW**2+SW**2/CW
     &      **2*seth**2)
      AAABR(1402) = EE*(SW/CW-CW/SW+SW/CW*smuth**2+CW/SW
     &      *smuth**2)
      AAABR(1403) = EE*cmuth*smuth*(SW/CW+CW/SW)
      AAABR(1404) = EE*(1D0+smuth**2+SW**2/CW**2+SW**2/CW
     &      **2*smuth**2)
      AAABR(1405) = EE*(SW/CW-CW/SW+SW/CW*slth**2+CW/SW*slth
     &      **2)
      AAABR(1406) = EE*clth*slth*(SW/CW+CW/SW)
      AAABR(1407) = EE*(1D0+slth**2+SW**2/CW**2+SW**2/CW
     &      **2*slth**2)
      AAABR(1408) = CW*EE/SW*cmuth*smuth
      AAABR(1409) = EE*cmuth*smuth
      AAABR(1410) = CW*EE/SW*ceth*seth
      AAABR(1411) = EE*ceth*seth
      AAABR(1412) = CW*EE/SW*clth*slth
      AAABR(1413) = EE*clth*slth
      AAABR(1414) = EE*(2D0*SW/CW-SW/CW*smuth**2-CW/SW*smuth
     &      **2)
      AAABR(1415) = EE*cmuth*smuth*(1D0+SW**2/CW**2)
      AAABR(1416) = EE*(2D0*SW/CW-SW/CW*slth**2-CW/SW*slth
     &      **2)
      AAABR(1417) = EE*clth*slth*(1D0+SW**2/CW**2)
      AAABR(1418) = EE*(2D0*SW/CW-SW/CW*seth**2-CW/SW*seth
     &      **2)
      AAABR(1419) = EE*ceth*seth*(1D0+SW**2/CW**2)
      AAABR(1420) = EE/SW*Sqrt2*clth
      AAABR(1421) = EE/SW*Sqrt2*slth
      AAABR(1422) = EE/SW*Sqrt2*ceth
      AAABR(1423) = EE/SW*Sqrt2*seth
      AAABR(1424) = EE/SW*Sqrt2*cmuth
      AAABR(1425) = EE/SW*Sqrt2*smuth
      AAABR(1426) = CW*EE/SW*seth**2
      AAABR(1427) = EE*seth**2
      AAABR(1428) = CW*EE/SW*slth**2
      AAABR(1429) = EE*slth**2
      AAABR(1430) = CW*EE/SW*smuth**2
      AAABR(1431) = EE*smuth**2
      AAABR(1432) = EE*(2D0-smuth**2+2D0*SW**2/CW**2-SW**2
     &      /CW**2*smuth**2)
      AAABR(1433) = EE*(2D0-seth**2+2D0*SW**2/CW**2-SW**2
     &      /CW**2*seth**2)
      AAABR(1434) = EE*(2D0-slth**2+2D0*SW**2/CW**2-SW**2
     &      /CW**2*slth**2)
      AAABR(1435) = EE*(SW/CW+CW/SW)
      AAABR(1436) = CW*EE/SW*(1D0-sbth**2)
      AAABR(1437) = EE*(1D0-sbth**2)
      AAABR(1438) = CW*EE/SW*(1D0-ssth**2)
      AAABR(1439) = EE*(1D0-ssth**2)
      AAABR(1440) = CW*EE/SW*(1D0-sdth**2)
      AAABR(1441) = EE*(1D0-sdth**2)
      AAABR(1442) = EE*(SW/CW+3D0*CW/SW-3D0*SW/CW*ssth**2
     &      -3D0*CW/SW*ssth**2)
      AAABR(1443) = EE*csth*ssth*(SW/CW+CW/SW)
      AAABR(1444) = EE*(1D0-3D0*ssth**2+SW**2/CW**2-3D0*SW
     &      **2/CW**2*ssth**2)
      AAABR(1445) = EE*(SW/CW+3D0*CW/SW-3D0*SW/CW*sbth**2
     &      -3D0*CW/SW*sbth**2)
      AAABR(1446) = EE*cbth*sbth*(SW/CW+CW/SW)
      AAABR(1447) = EE*(1D0-3D0*sbth**2+SW**2/CW**2-3D0*SW
     &      **2/CW**2*sbth**2)
      AAABR(1448) = EE*(SW/CW+3D0*CW/SW-3D0*SW/CW*sdth**2
     &      -3D0*CW/SW*sdth**2)
      AAABR(1449) = EE*cdth*sdth*(SW/CW+CW/SW)
      AAABR(1450) = EE*(1D0-3D0*sdth**2+SW**2/CW**2-3D0*SW
     &      **2/CW**2*sdth**2)
      AAABR(1451) = CW*EE/SW*csth*ssth
      AAABR(1452) = EE*csth*ssth
      AAABR(1453) = CW*EE/SW*cbth*sbth
      AAABR(1454) = EE*cbth*sbth
      AAABR(1455) = CW*EE/SW*cdth*sdth
      AAABR(1456) = EE*cdth*sdth
      AAABR(1457) = EE*(2D0*SW/CW-3D0*SW/CW*sdth**2-3D0*CW
     &      /SW*sdth**2)
      AAABR(1458) = EE*cdth*sdth*(1D0+SW**2/CW**2)
      AAABR(1459) = EE*(2D0*SW/CW-3D0*SW/CW*sbth**2-3D0*CW
     &      /SW*sbth**2)
      AAABR(1460) = EE*cbth*sbth*(1D0+SW**2/CW**2)
      AAABR(1461) = EE*(2D0*SW/CW-3D0*SW/CW*ssth**2-3D0*CW
     &      /SW*ssth**2)
      AAABR(1462) = EE*csth*ssth*(1D0+SW**2/CW**2)
      AAABR(1463) = EE/SW*Sqrt2*ccth*csth
      AAABR(1464) = EE/SW*Sqrt2*csth*scth
      AAABR(1465) = EE/SW*Sqrt2*ccth*ssth
      AAABR(1466) = EE/SW*Sqrt2*cbth*ctth
      AAABR(1467) = EE/SW*Sqrt2*cbth*stth
      AAABR(1468) = EE/SW*Sqrt2*ctth*sbth
      AAABR(1469) = EE/SW*Sqrt2*cdth*cuth
      AAABR(1470) = EE/SW*Sqrt2*cdth*suth
      AAABR(1471) = EE/SW*Sqrt2*cuth*sdth
      AAABR(1472) = EE/SW*Sqrt2*scth*ssth
      AAABR(1473) = EE/SW*Sqrt2*sdth*suth
      AAABR(1474) = EE/SW*Sqrt2*sbth*stth
      AAABR(1475) = CW*EE/SW*ssth**2
      AAABR(1476) = EE*ssth**2
      AAABR(1477) = CW*EE/SW*sbth**2
      AAABR(1478) = EE*sbth**2
      AAABR(1479) = CW*EE/SW*sdth**2
      AAABR(1480) = EE*sdth**2
      AAABR(1481) = EE*(2D0-3D0*sbth**2+2D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*sbth**2)
      AAABR(1482) = EE*(2D0-3D0*sdth**2+2D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*sdth**2)
      AAABR(1483) = EE*(2D0-3D0*ssth**2+2D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*ssth**2)
      AAABR(1484) = CW*EE/SW*(1D0-suth**2)
      AAABR(1485) = EE*(1D0-suth**2)
      AAABR(1486) = CW*EE/SW*(1D0-stth**2)
      AAABR(1487) = EE*(1D0-stth**2)
      AAABR(1488) = CW*EE/SW*(1D0-scth**2)
      AAABR(1489) = EE*(1D0-scth**2)
      AAABR(1490) = EE*(SW/CW-3D0*CW/SW+3D0*SW/CW*suth**2
     &      +3D0*CW/SW*suth**2)
      AAABR(1491) = EE*cuth*suth*(SW/CW+CW/SW)
      AAABR(1492) = EE*(1D0+3D0*suth**2+SW**2/CW**2+3D0*SW
     &      **2/CW**2*suth**2)
      AAABR(1493) = EE*(SW/CW-3D0*CW/SW+3D0*SW/CW*scth**2
     &      +3D0*CW/SW*scth**2)
      AAABR(1494) = EE*ccth*scth*(SW/CW+CW/SW)
      AAABR(1495) = EE*(1D0+3D0*scth**2+SW**2/CW**2+3D0*SW
     &      **2/CW**2*scth**2)
      AAABR(1496) = EE*(SW/CW-3D0*CW/SW+3D0*SW/CW*stth**2
     &      +3D0*CW/SW*stth**2)
      AAABR(1497) = EE*ctth*stth*(SW/CW+CW/SW)
      AAABR(1498) = EE*(1D0+3D0*stth**2+SW**2/CW**2+3D0*SW
     &      **2/CW**2*stth**2)
      AAABR(1499) = CW*EE/SW*cuth*suth
      AAABR(1500) = EE*cuth*suth
      AAABR(1501) = CW*EE/SW*ccth*scth
      AAABR(1502) = EE*ccth*scth
      AAABR(1503) = CW*EE/SW*ctth*stth
      AAABR(1504) = EE*ctth*stth
      AAABR(1505) = EE*(4D0*SW/CW-3D0*SW/CW*suth**2-3D0*CW
     &      /SW*suth**2)
      AAABR(1506) = EE*cuth*suth*(1D0+SW**2/CW**2)
      AAABR(1507) = EE*(4D0*SW/CW-3D0*SW/CW*stth**2-3D0*CW
     &      /SW*stth**2)
      AAABR(1508) = EE*ctth*stth*(1D0+SW**2/CW**2)
      AAABR(1509) = EE*(4D0*SW/CW-3D0*SW/CW*scth**2-3D0*CW
     &      /SW*scth**2)
      AAABR(1510) = EE*ccth*scth*(1D0+SW**2/CW**2)
      AAABR(1511) = CW*EE/SW*stth**2
      AAABR(1512) = EE*stth**2
      AAABR(1513) = CW*EE/SW*suth**2
      AAABR(1514) = EE*suth**2
      AAABR(1515) = CW*EE/SW*scth**2
      AAABR(1516) = EE*scth**2
      AAABR(1517) = EE*(4D0-3D0*suth**2+4D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*suth**2)
      AAABR(1518) = EE*(4D0-3D0*scth**2+4D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*scth**2)
      AAABR(1519) = EE*(4D0-3D0*stth**2+4D0*SW**2/CW**2-3D0
     &      *SW**2/CW**2*stth**2)
      AAABR(1520) = EE/SW*nlk
      AAABR(1521) = EE/SW*nld2
      AAABR(1522) = EE/SW*nld1
      AAABR(1523) = EE/CW/SW*nle2
      AAABR(1524) = EE/CW/SW*nle1
      AAABR(1525) = EE*MW*cb*sb
      AAABR(1526) = EE/CW*MW*SW*cb*sb
      AAABR(1527) = EE*MW*(1D0+nla)
      AAABR(1528) = EE*MW*(1D0-sb**2)
      AAABR(1529) = EE*MW*sb**2
      AAABR(1530) = EE*MW*(SW/CW-CW/SW*nlb)
      AAABR(1531) = EE/CW*MW*SW
      AAABR(1532) = EE/CW*MW*SW*(1D0-sb**2)
      AAABR(1533) = EE*MW*(1D0+SW**2/CW**2)
      AAABR(1534) = EE/CW*MW*SW*sb**2
      AAABR(1535) = EE*MW*(SW*ca*sb-SW*cb*sa+CW**2/SW*ca
     &      *sb-CW**2/SW*cb*sa)
      AAABR(1536) = EE*MW*(CW*ca*sb-CW*cb*sa+SW**2/CW*ca
     &      *sb-SW**2/CW*cb*sa)
      AAABR(1537) = EE*MW*(SW*ca*cb+SW*sa*sb+CW**2/SW*ca
     &      *cb+CW**2/SW*sa*sb)
      AAABR(1538) = EE*MW*(CW*ca*cb+CW*sa*sb+SW**2/CW*ca
     &      *cb+SW**2/CW*sa*sb)
      AAABR(1539) = EE*MW/SW*(ca*cb+sa*sb)
      AAABR(1540) = EE*MW/SW*(ca*sb-cb*sa)
      AAABR(1541) = EE*MW/SW*(sa*sb-sa*sb**3-ca*cb*sb**2)
      AAABR(1542) = EE*MW/SW*(ca*sb-ca*sb**3+cb*sa*sb**2)
      AAABR(1543) = EE*MW*(2D0*SW*ca*cb+2D0*SW*sa*sb+SW**3
     &      /CW**2*ca*cb+SW**3/CW**2*sa*sb+CW**2/SW*ca*cb
     &      +CW**2/SW*sa*sb)
      AAABR(1544) = EE*MW*(2D0*SW*ca*sb-2D0*SW*cb*sa+SW**3
     &      /CW**2*ca*sb-SW**3/CW**2*cb*sa+CW**2/SW*ca*sb
     &      -CW**2/SW*cb*sa)
      AAABR(1545) = EE*MW*(2D0*SW*ca*sb-2D0*SW*ca*sb**3+SW
     &      **3/CW**2*ca*sb-SW**3/CW**2*ca*sb**3+CW**2/SW
     &      *ca*sb-CW**2/SW*ca*sb**3+2D0*SW*cb*sa*sb**2+SW
     &      **3/CW**2*cb*sa*sb**2+CW**2/SW*cb*sa*sb**2)
      AAABR(1546) = EE*MW*(CW*ca*sb-CW*cb*sa+SW**4/CW**3
     &      *ca*sb-SW**4/CW**3*cb*sa+2D0*SW**2/CW*ca*sb-2D0
     &      *SW**2/CW*cb*sa)
      AAABR(1547) = EE*MW*(2D0*SW*sa*sb-2D0*SW*sa*sb**3+SW
     &      **3/CW**2*sa*sb-SW**3/CW**2*sa*sb**3+CW**2/SW
     &      *sa*sb-CW**2/SW*sa*sb**3-2D0*SW*ca*cb*sb**2-SW
     &      **3/CW**2*ca*cb*sb**2-CW**2/SW*ca*cb*sb**2)
      AAABR(1548) = EE*MW*(CW*ca*cb+CW*sa*sb+SW**4/CW**3
     &      *ca*cb+SW**4/CW**3*sa*sb+2D0*SW**2/CW*ca*cb+2D0
     &      *SW**2/CW*sa*sb)
      AAABR(1549) = EE/SW*Sqrt2*(Zm11*Zp22*cb+Zm21*Zp12*sb)
      AAABR(1550) = EE/SW*Sqrt2*Zm22*Zp12*sb
      AAABR(1551) = EE/SW*Sqrt2*(Zm12*Zp21*cb+Zm22*Zp11*sb)
      AAABR(1552) = EE/SW*Sqrt2*(Zm12*Zp22*cb+Zm22*Zp12*sb)
      AAABR(1553) = EE/SW*Sqrt2*Zm12*Zp22*cb
      AAABR(1554) = EE/SW*Sqrt2*Zm21*Zp11*sb
      AAABR(1555) = EE/SW*Sqrt2*(Zm11*Zp21*cb+Zm21*Zp11*sb)
      AAABR(1556) = EE/SW*Sqrt2*Zm11*Zp21*cb
      AAABR(1557) = EE/SW*Sqrt2*Zm21*Zp12*sb
      AAABR(1558) = EE/SW*Sqrt2*Zm22*Zp11*sb
      AAABR(1559) = EE/SW*Sqrt2*Zm11*Zp22*cb
      AAABR(1560) = EE/SW*Sqrt2*Zm12*Zp21*cb
      AAABR(1561) = EE/SW*Sqrt2*(Zm11*Zp22*sb-Zm21*Zp12*cb)
      AAABR(1562) = EE/SW*Sqrt2*(Zm12*Zp21*sb-Zm22*Zp11*cb)
      AAABR(1563) = EE/SW*Sqrt2*(Zm12*Zp22*sb-Zm22*Zp12*cb)
      AAABR(1564) = EE/SW*Sqrt2*Zm22*Zp12*cb
      AAABR(1565) = EE/SW*Sqrt2*Zm12*Zp22*sb
      AAABR(1566) = EE/SW*Sqrt2*(Zm11*Zp21*sb-Zm21*Zp11*cb)
      AAABR(1567) = EE/SW*Sqrt2*Zm21*Zp12*cb
      AAABR(1568) = EE/SW*Sqrt2*Zm22*Zp11*cb
      AAABR(1569) = EE/SW*Sqrt2*Zm11*Zp22*sb
      AAABR(1570) = EE/SW*Sqrt2*Zm12*Zp21*sb
      AAABR(1571) = EE/SW*Sqrt2*Zm21*Zp11*cb
      AAABR(1572) = EE/SW*Sqrt2*Zm11*Zp21*sb
      AAABR(1573) = EE/SW*Sqrt2*(Zm11*Zp22*sa+Zm21*Zp12*ca)
      AAABR(1574) = EE/SW*Sqrt2*(Zm12*Zp21*sa+Zm22*Zp11*ca)
      AAABR(1575) = EE/SW*Sqrt2*(Zm12*Zp22*sa+Zm22*Zp12*ca)
      AAABR(1576) = EE/SW*Sqrt2*(Zm12*Zp22*ca-Zm22*Zp12*sa)
      AAABR(1577) = EE/SW*Sqrt2*(Zm11*Zp21*ca-Zm21*Zp11*sa)
      AAABR(1578) = EE/SW*Sqrt2*(Zm11*Zp22*ca-Zm21*Zp12*sa)
      AAABR(1579) = EE/SW*Sqrt2*(Zm12*Zp21*ca-Zm22*Zp11*sa)
      AAABR(1580) = EE/SW*Sqrt2*(Zm11*Zp21*sa+Zm21*Zp11*ca)
      AAABR(1581) = EE/SW*(2D0*Zm11*cmuth-Mm/MW*Sqrt2*Zm21
     &      /cb*smuth)
      AAABR(1582) = EE/SW*(2D0*Zm12*cmuth-Mm/MW*Sqrt2*Zm22
     &      /cb*smuth)
      AAABR(1583) = EE/SW*(2D0*Zm12*smuth+Mm/MW*Sqrt2*Zm22
     &      /cb*cmuth)
      AAABR(1584) = EE/SW*Zm12*cmuth
      AAABR(1585) = EE/MW*Mm/SW*Sqrt2*Zm22/cb*smuth
      AAABR(1586) = EE/MW*Mm/SW*Sqrt2*Zm22/cb*sb**2*smuth
      AAABR(1587) = EE/MW/SW*Sqrt2*Zm22/cb*smuth
      AAABR(1588) = EE/SW*(2D0*Zm11*ceth-Me/MW*Sqrt2*Zm21
     &      /cb*seth)
      AAABR(1589) = EE/SW*(2D0*Zm12*ceth-Me/MW*Sqrt2*Zm22
     &      /cb*seth)
      AAABR(1590) = EE/SW*(2D0*Zm12*seth+Me/MW*Sqrt2*Zm22
     &      /cb*ceth)
      AAABR(1591) = EE/SW*Zm12*ceth
      AAABR(1592) = EE/MW*Me/SW*Sqrt2*Zm22/cb*seth
      AAABR(1593) = EE/MW*Me/SW*Sqrt2*Zm22/cb*sb**2*seth
      AAABR(1594) = EE/MW/SW*Sqrt2*Zm22/cb*seth
      AAABR(1595) = EE/SW*(2D0*Zm11*seth+Me/MW*Sqrt2*Zm21
     &      /cb*ceth)
      AAABR(1596) = EE/SW*Zm11*ceth
      AAABR(1597) = EE/MW*Me/SW*Sqrt2*Zm21/cb*seth
      AAABR(1598) = EE/MW*Me/SW*Sqrt2*Zm21/cb*sb**2*seth
      AAABR(1599) = EE/MW/SW*Sqrt2*Zm21/cb*seth
      AAABR(1600) = EE/SW*(2D0*Zm11*smuth+Mm/MW*Sqrt2*Zm21
     &      /cb*cmuth)
      AAABR(1601) = EE/SW*Zm11*cmuth
      AAABR(1602) = EE/MW*Mm/SW*Sqrt2*Zm21/cb*smuth
      AAABR(1603) = EE/MW*Mm/SW*Sqrt2*Zm21/cb*sb**2*smuth
      AAABR(1604) = EE/MW/SW*Sqrt2*Zm21/cb*smuth
      AAABR(1605) = EE/SW*(2D0*Zm11*clth-Ml/MW*Sqrt2*Zm21
     &      /cb*slth)
      AAABR(1606) = EE/SW*(2D0*Zm12*clth-Ml/MW*Sqrt2*Zm22
     &      /cb*slth)
      AAABR(1607) = EE/SW*(2D0*Zm11*slth+Ml/MW*Sqrt2*Zm21
     &      /cb*clth)
      AAABR(1608) = EE/SW*Zm11*clth
      AAABR(1609) = EE/MW*Ml/SW*Sqrt2*Zm21/cb*slth
      AAABR(1610) = EE/MW*Ml/SW*Sqrt2*Zm21/cb*sb**2*slth
      AAABR(1611) = EE/MW/SW*Sqrt2*Zm21/cb*slth
      AAABR(1612) = EE/SW*(2D0*Zm12*slth+Ml/MW*Sqrt2*Zm22
     &      /cb*clth)
      AAABR(1613) = EE/SW*Zm12*clth
      AAABR(1614) = EE/MW*Ml/SW*Sqrt2*Zm22/cb*slth
      AAABR(1615) = EE/MW*Ml/SW*Sqrt2*Zm22/cb*sb**2*slth
      AAABR(1616) = EE/MW/SW*Sqrt2*Zm22/cb*slth
      AAABR(1617) = EE/SW*Zm12*smuth
      AAABR(1618) = EE/MW*Mm/SW*Sqrt2*Zm22/cb*cmuth
      AAABR(1619) = EE/MW*Mm/SW*Sqrt2*Zm22/cb*cmuth*sb**2
      AAABR(1620) = EE/MW/SW*Sqrt2*Zm22/cb*cmuth
      AAABR(1621) = EE/SW*Zm11*smuth
      AAABR(1622) = EE/MW*Mm/SW*Sqrt2*Zm21/cb*cmuth
      AAABR(1623) = EE/MW*Mm/SW*Sqrt2*Zm21/cb*cmuth*sb**2
      AAABR(1624) = EE/MW/SW*Sqrt2*Zm21/cb*cmuth
      AAABR(1625) = EE/SW*Zm12*seth
      AAABR(1626) = EE/MW*Me/SW*Sqrt2*Zm22/cb*ceth
      AAABR(1627) = EE/MW*Me/SW*Sqrt2*Zm22/cb*ceth*sb**2
      AAABR(1628) = EE/MW/SW*Sqrt2*Zm22/cb*ceth
      AAABR(1629) = EE/SW*Zm11*slth
      AAABR(1630) = EE/MW*Ml/SW*Sqrt2*Zm21/cb*clth
      AAABR(1631) = EE/MW*Ml/SW*Sqrt2*Zm21/cb*clth*sb**2
      AAABR(1632) = EE/MW/SW*Sqrt2*Zm21/cb*clth
      AAABR(1633) = EE/SW*Zm11*seth
      AAABR(1634) = EE/MW*Me/SW*Sqrt2*Zm21/cb*ceth
      AAABR(1635) = EE/MW*Me/SW*Sqrt2*Zm21/cb*ceth*sb**2
      AAABR(1636) = EE/MW/SW*Sqrt2*Zm21/cb*ceth
      AAABR(1637) = EE/SW*Zm12*slth
      AAABR(1638) = EE/MW*Ml/SW*Sqrt2*Zm22/cb*clth
      AAABR(1639) = EE/MW*Ml/SW*Sqrt2*Zm22/cb*clth*sb**2
      AAABR(1640) = EE/MW/SW*Sqrt2*Zm22/cb*clth
      AAABC(101) = EE*sb*(2D0*Zm11/SW*Zn31-Sqrt2/CW*Zm21
     &      *Zn11-Sqrt2/SW*Zm21*Zn21)
      AAABC(102) = EE*sb*(2D0*Zm11/SW*Zn32-Sqrt2/CW*Zm21
     &      *Zn12-Sqrt2/SW*Zm21*Zn22)
      AAABC(103) = EE*sb*(2D0*Zm12/SW*Zn32-Sqrt2/CW*Zm22
     &      *Zn12-Sqrt2/SW*Zm22*Zn22)
      AAABC(104) = EE*sb*(2D0*Zm11/SW*Zn33-Sqrt2/CW*Zm21
     &      *Zn13-Sqrt2/SW*Zm21*Zn23)
      AAABC(105) = EE*sb*(2D0*Zm11/SW*Zn34-Sqrt2/CW*Zm21
     &      *Zn14-Sqrt2/SW*Zm21*Zn24)
      AAABC(106) = EE/SW*sb*(2D0*Zm11*Zn32-Sqrt2*Zm21*Zn22)
      AAABC(107) = EE/CW*Sqrt2*Zm21*Zn12*sb
      AAABC(108) = EE/CW**2*SW*Sqrt2*Zm21*Zn12*sb
      AAABC(109) = EE*cb*(2D0*dconjg(Zn41)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn11)*Zp21+Sqrt2/SW*dconjg(Zn21)*Zp21
     &      )
      AAABC(110) = EE*cb*(2D0*dconjg(Zn42)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn12)*Zp21+Sqrt2/SW*dconjg(Zn22)*Zp21
     &      )
      AAABC(111) = EE*cb*(2D0*dconjg(Zn43)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn13)*Zp21+Sqrt2/SW*dconjg(Zn23)*Zp21
     &      )
      AAABC(112) = EE*cb*(2D0*dconjg(Zn44)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn14)*Zp21+Sqrt2/SW*dconjg(Zn24)*Zp21
     &      )
      AAABC(113) = EE*cb*(2D0*dconjg(Zn42)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn12)*Zp22+Sqrt2/SW*dconjg(Zn22)*Zp22
     &      )
      AAABC(114) = EE/SW*cb*(2D0*dconjg(Zn42)*Zp11+Sqrt2
     &      *dconjg(Zn22)*Zp21)
      AAABC(115) = EE/CW*Sqrt2*dconjg(Zn12)*Zp21*cb
      AAABC(116) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*Zp21*cb
      AAABC(117) = EE*sb*(2D0*Zm12/SW*Zn34-Sqrt2/CW*Zm22
     &      *Zn14-Sqrt2/SW*Zm22*Zn24)
      AAABC(118) = EE/SW*sb*(2D0*Zm11*Zn34-Sqrt2*Zm21*Zn24)
      AAABC(119) = EE/CW*Sqrt2*Zm21*Zn14*sb
      AAABC(120) = EE/CW**2*SW*Sqrt2*Zm21*Zn14*sb
      AAABC(121) = EE*cb*(2D0*dconjg(Zn44)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn14)*Zp22+Sqrt2/SW*dconjg(Zn24)*Zp22
     &      )
      AAABC(122) = EE/SW*cb*(2D0*dconjg(Zn44)*Zp11+Sqrt2
     &      *dconjg(Zn24)*Zp21)
      AAABC(123) = EE/CW*Sqrt2*dconjg(Zn14)*Zp21*cb
      AAABC(124) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*Zp21*cb
      AAABC(125) = EE*sb*(2D0*Zm12/SW*Zn33-Sqrt2/CW*Zm22
     &      *Zn13-Sqrt2/SW*Zm22*Zn23)
      AAABC(126) = EE/SW*sb*(2D0*Zm11*Zn33-Sqrt2*Zm21*Zn23)
      AAABC(127) = EE/CW*Sqrt2*Zm21*Zn13*sb
      AAABC(128) = EE/CW**2*SW*Sqrt2*Zm21*Zn13*sb
      AAABC(129) = EE*cb*(2D0*dconjg(Zn43)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn13)*Zp22+Sqrt2/SW*dconjg(Zn23)*Zp22
     &      )
      AAABC(130) = EE/SW*cb*(2D0*dconjg(Zn43)*Zp11+Sqrt2
     &      *dconjg(Zn23)*Zp21)
      AAABC(131) = EE/CW*Sqrt2*dconjg(Zn13)*Zp21*cb
      AAABC(132) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*Zp21*cb
      AAABC(133) = EE*sb*(2D0*Zm12/SW*Zn31-Sqrt2/CW*Zm22
     &      *Zn11-Sqrt2/SW*Zm22*Zn21)
      AAABC(134) = EE/SW*sb*(2D0*Zm11*Zn31-Sqrt2*Zm21*Zn21)
      AAABC(135) = EE/CW*Sqrt2*Zm21*Zn11*sb
      AAABC(136) = EE/CW**2*SW*Sqrt2*Zm21*Zn11*sb
      AAABC(137) = EE*cb*(2D0*dconjg(Zn41)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn11)*Zp22+Sqrt2/SW*dconjg(Zn21)*Zp22
     &      )
      AAABC(138) = EE/SW*cb*(2D0*dconjg(Zn41)*Zp11+Sqrt2
     &      *dconjg(Zn21)*Zp21)
      AAABC(139) = EE/CW*Sqrt2*dconjg(Zn11)*Zp21*cb
      AAABC(140) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*Zp21*cb
      AAABC(141) = EE/SW*sb*(2D0*Zm12*Zn33-Sqrt2*Zm22*Zn23)
      AAABC(142) = EE/CW*Sqrt2*Zm22*Zn13*sb
      AAABC(143) = EE/CW**2*SW*Sqrt2*Zm22*Zn13*sb
      AAABC(144) = EE/SW*cb*(2D0*dconjg(Zn43)*Zp12+Sqrt2
     &      *dconjg(Zn23)*Zp22)
      AAABC(145) = EE/CW*Sqrt2*dconjg(Zn13)*Zp22*cb
      AAABC(146) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*Zp22*cb
      AAABC(147) = EE/SW*sb*(2D0*Zm12*Zn32-Sqrt2*Zm22*Zn22)
      AAABC(148) = EE/CW*Sqrt2*Zm22*Zn12*sb
      AAABC(149) = EE/CW**2*SW*Sqrt2*Zm22*Zn12*sb
      AAABC(150) = EE/SW*cb*(2D0*dconjg(Zn42)*Zp12+Sqrt2
     &      *dconjg(Zn22)*Zp22)
      AAABC(151) = EE/CW*Sqrt2*dconjg(Zn12)*Zp22*cb
      AAABC(152) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*Zp22*cb
      AAABC(153) = EE/SW*sb*(2D0*Zm12*Zn31-Sqrt2*Zm22*Zn21)
      AAABC(154) = EE/CW*Sqrt2*Zm22*Zn11*sb
      AAABC(155) = EE/CW**2*SW*Sqrt2*Zm22*Zn11*sb
      AAABC(156) = EE/SW*cb*(2D0*dconjg(Zn41)*Zp12+Sqrt2
     &      *dconjg(Zn21)*Zp22)
      AAABC(157) = EE/CW*Sqrt2*dconjg(Zn11)*Zp22*cb
      AAABC(158) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*Zp22*cb
      AAABC(159) = EE/SW*sb*(2D0*Zm12*Zn34-Sqrt2*Zm22*Zn24)
      AAABC(160) = EE/CW*Sqrt2*Zm22*Zn14*sb
      AAABC(161) = EE/CW**2*SW*Sqrt2*Zm22*Zn14*sb
      AAABC(162) = EE/SW*cb*(2D0*dconjg(Zn44)*Zp12+Sqrt2
     &      *dconjg(Zn24)*Zp22)
      AAABC(163) = EE/CW*Sqrt2*dconjg(Zn14)*Zp22*cb
      AAABC(164) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*Zp22*cb
      AAABC(165) = EE*cb*(2D0*Zm12/SW*Zn31-Sqrt2/CW*Zm22
     &      *Zn11-Sqrt2/SW*Zm22*Zn21)
      AAABC(166) = EE*cb*(2D0*Zm12/SW*Zn32-Sqrt2/CW*Zm22
     &      *Zn12-Sqrt2/SW*Zm22*Zn22)
      AAABC(167) = EE*cb*(2D0*Zm11/SW*Zn33-Sqrt2/CW*Zm21
     &      *Zn13-Sqrt2/SW*Zm21*Zn23)
      AAABC(168) = EE*cb*(2D0*Zm12/SW*Zn33-Sqrt2/CW*Zm22
     &      *Zn13-Sqrt2/SW*Zm22*Zn23)
      AAABC(169) = EE*cb*(2D0*Zm12/SW*Zn34-Sqrt2/CW*Zm22
     &      *Zn14-Sqrt2/SW*Zm22*Zn24)
      AAABC(170) = EE/SW*cb*(2D0*Zm12*Zn33-Sqrt2*Zm22*Zn23)
      AAABC(171) = EE/CW*Sqrt2*Zm22*Zn13*cb
      AAABC(172) = EE/CW**2*SW*Sqrt2*Zm22*Zn13*cb
      AAABC(173) = EE*sb*(2D0*dconjg(Zn43)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn13)*Zp21+Sqrt2/SW*dconjg(Zn23)*Zp21
     &      )
      AAABC(174) = EE*sb*(2D0*dconjg(Zn41)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn11)*Zp22+Sqrt2/SW*dconjg(Zn21)*Zp22
     &      )
      AAABC(175) = EE*sb*(2D0*dconjg(Zn42)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn12)*Zp22+Sqrt2/SW*dconjg(Zn22)*Zp22
     &      )
      AAABC(176) = EE*sb*(2D0*dconjg(Zn43)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn13)*Zp22+Sqrt2/SW*dconjg(Zn23)*Zp22
     &      )
      AAABC(177) = EE*sb*(2D0*dconjg(Zn44)/SW*Zp12+Sqrt2
     &      /CW*dconjg(Zn14)*Zp22+Sqrt2/SW*dconjg(Zn24)*Zp22
     &      )
      AAABC(178) = EE/SW*sb*(2D0*dconjg(Zn43)*Zp12+Sqrt2
     &      *dconjg(Zn23)*Zp22)
      AAABC(179) = EE/CW*Sqrt2*dconjg(Zn13)*Zp22*sb
      AAABC(180) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*Zp22*sb
      AAABC(181) = EE*cb*(2D0*Zm11/SW*Zn32-Sqrt2/CW*Zm21
     &      *Zn12-Sqrt2/SW*Zm21*Zn22)
      AAABC(182) = EE/SW*cb*(2D0*Zm12*Zn32-Sqrt2*Zm22*Zn22)
      AAABC(183) = EE/CW*Sqrt2*Zm22*Zn12*cb
      AAABC(184) = EE/CW**2*SW*Sqrt2*Zm22*Zn12*cb
      AAABC(185) = EE*sb*(2D0*dconjg(Zn42)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn12)*Zp21+Sqrt2/SW*dconjg(Zn22)*Zp21
     &      )
      AAABC(186) = EE/SW*sb*(2D0*dconjg(Zn42)*Zp12+Sqrt2
     &      *dconjg(Zn22)*Zp22)
      AAABC(187) = EE/CW*Sqrt2*dconjg(Zn12)*Zp22*sb
      AAABC(188) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*Zp22*sb
      AAABC(189) = EE*cb*(2D0*Zm11/SW*Zn31-Sqrt2/CW*Zm21
     &      *Zn11-Sqrt2/SW*Zm21*Zn21)
      AAABC(190) = EE*cb*(2D0*Zm11/SW*Zn34-Sqrt2/CW*Zm21
     &      *Zn14-Sqrt2/SW*Zm21*Zn24)
      AAABC(191) = EE/SW*cb*(2D0*Zm11*Zn34-Sqrt2*Zm21*Zn24)
      AAABC(192) = EE/CW*Sqrt2*Zm21*Zn14*cb
      AAABC(193) = EE/CW**2*SW*Sqrt2*Zm21*Zn14*cb
      AAABC(194) = EE*sb*(2D0*dconjg(Zn41)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn11)*Zp21+Sqrt2/SW*dconjg(Zn21)*Zp21
     &      )
      AAABC(195) = EE*sb*(2D0*dconjg(Zn44)/SW*Zp11+Sqrt2
     &      /CW*dconjg(Zn14)*Zp21+Sqrt2/SW*dconjg(Zn24)*Zp21
     &      )
      AAABC(196) = EE/SW*sb*(2D0*dconjg(Zn44)*Zp11+Sqrt2
     &      *dconjg(Zn24)*Zp21)
      AAABC(197) = EE/CW*Sqrt2*dconjg(Zn14)*Zp21*sb
      AAABC(198) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*Zp21*sb
      AAABC(199) = EE/SW*cb*(2D0*Zm11*Zn33-Sqrt2*Zm21*Zn23)
      AAABC(200) = EE/CW*Sqrt2*Zm21*Zn13*cb
      AAABC(201) = EE/CW**2*SW*Sqrt2*Zm21*Zn13*cb
      AAABC(202) = EE/SW*sb*(2D0*dconjg(Zn43)*Zp11+Sqrt2
     &      *dconjg(Zn23)*Zp21)
      AAABC(203) = EE/CW*Sqrt2*dconjg(Zn13)*Zp21*sb
      AAABC(204) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*Zp21*sb
      AAABC(205) = EE/SW*cb*(2D0*Zm12*Zn31-Sqrt2*Zm22*Zn21)
      AAABC(206) = EE/CW*Sqrt2*Zm22*Zn11*cb
      AAABC(207) = EE/CW**2*SW*Sqrt2*Zm22*Zn11*cb
      AAABC(208) = EE/SW*sb*(2D0*dconjg(Zn41)*Zp12+Sqrt2
     &      *dconjg(Zn21)*Zp22)
      AAABC(209) = EE/CW*Sqrt2*dconjg(Zn11)*Zp22*sb
      AAABC(210) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*Zp22*sb
      AAABC(211) = EE/SW*cb*(2D0*Zm11*Zn31-Sqrt2*Zm21*Zn21)
      AAABC(212) = EE/CW*Sqrt2*Zm21*Zn11*cb
      AAABC(213) = EE/CW**2*SW*Sqrt2*Zm21*Zn11*cb
      AAABC(214) = EE/SW*sb*(2D0*dconjg(Zn41)*Zp11+Sqrt2
     &      *dconjg(Zn21)*Zp21)
      AAABC(215) = EE/CW*Sqrt2*dconjg(Zn11)*Zp21*sb
      AAABC(216) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*Zp21*sb
      AAABC(217) = EE/SW*cb*(2D0*Zm11*Zn32-Sqrt2*Zm21*Zn22)
      AAABC(218) = EE/CW*Sqrt2*Zm21*Zn12*cb
      AAABC(219) = EE/CW**2*SW*Sqrt2*Zm21*Zn12*cb
      AAABC(220) = EE/SW*sb*(2D0*dconjg(Zn42)*Zp11+Sqrt2
     &      *dconjg(Zn22)*Zp21)
      AAABC(221) = EE/CW*Sqrt2*dconjg(Zn12)*Zp21*sb
      AAABC(222) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*Zp21*sb
      AAABC(223) = EE/SW*cb*(2D0*Zm12*Zn34-Sqrt2*Zm22*Zn24)
      AAABC(224) = EE/CW*Sqrt2*Zm22*Zn14*cb
      AAABC(225) = EE/CW**2*SW*Sqrt2*Zm22*Zn14*cb
      AAABC(226) = EE/SW*sb*(2D0*dconjg(Zn44)*Zp12+Sqrt2
     &      *dconjg(Zn24)*Zp22)
      AAABC(227) = EE/CW*Sqrt2*dconjg(Zn14)*Zp22*sb
      AAABC(228) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*Zp22*sb
      AAABR(1641) = EE/SW*(2D0*Zm11*cbth-Mb/MW*Sqrt2*Zm21
     &      /cb*sbth)
      AAABR(1642) = EE/SW*(2D0*Zm12*cbth-Mb/MW*Sqrt2*Zm22
     &      /cb*sbth)
      AAABR(1643) = EE/SW*(2D0*Zm11*sbth+Mb/MW*Sqrt2*Zm21
     &      /cb*cbth)
      AAABR(1644) = EE/SW*Zm11*cbth
      AAABR(1645) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*sbth
      AAABR(1646) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*sb**2*sbth
      AAABR(1647) = EE/MW/SW*Sqrt2*Zm21/cb*sbth
      AAABR(1648) = EE/MW*Mt/SW*Sqrt2*Zp21*cbth/sb
      AAABR(1649) = EE/MW*Mt/SW*Sqrt2*Zp21/sb*sbth
      AAABR(1650) = EE/MW*Mt/SW*Sqrt2*Zp22*cbth/sb
      AAABR(1651) = EE/MW*Mt/SW*Sqrt2*Zp21*cbth*(1D0/sb-sb)
      AAABR(1652) = EE/MW/SW*Sqrt2*Zp21*cbth/sb
      AAABR(1653) = EE/SW*(2D0*Zm11*cdth-Md/MW*Sqrt2*Zm21
     &      /cb*sdth)
      AAABR(1654) = EE/SW*(2D0*Zm12*cdth-Md/MW*Sqrt2*Zm22
     &      /cb*sdth)
      AAABR(1655) = EE/SW*(2D0*Zm12*sdth+Md/MW*Sqrt2*Zm22
     &      /cb*cdth)
      AAABR(1656) = EE/SW*Zm12*cdth
      AAABR(1657) = EE/MW*Md/SW*Sqrt2*Zm22/cb*sdth
      AAABR(1658) = EE/MW*Md/SW*Sqrt2*Zm22/cb*sb**2*sdth
      AAABR(1659) = EE/MW/SW*Sqrt2*Zm22/cb*sdth
      AAABR(1660) = EE/MW*Mu/SW*Sqrt2*Zp21*cdth/sb
      AAABR(1661) = EE/MW*Mu/SW*Sqrt2*Zp22*cdth/sb
      AAABR(1662) = EE/MW*Mu/SW*Sqrt2*Zp22/sb*sdth
      AAABR(1663) = EE/MW*Mu/SW*Sqrt2*Zp22*cdth*(1D0/sb-sb)
      AAABR(1664) = EE/MW/SW*Sqrt2*Zp22*cdth/sb
      AAABR(1665) = EE/SW*(2D0*Zm11*csth-Ms/MW*Sqrt2*Zm21
     &      /cb*ssth)
      AAABR(1666) = EE/SW*(2D0*Zm12*csth-Ms/MW*Sqrt2*Zm22
     &      /cb*ssth)
      AAABR(1667) = EE/SW*(2D0*Zm11*ssth+Ms/MW*Sqrt2*Zm21
     &      /cb*csth)
      AAABR(1668) = EE/SW*Zm11*csth
      AAABR(1669) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*ssth
      AAABR(1670) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*sb**2*ssth
      AAABR(1671) = EE/MW/SW*Sqrt2*Zm21/cb*ssth
      AAABR(1672) = EE/MW*Mc/SW*Sqrt2*Zp21*csth/sb
      AAABR(1673) = EE/MW*Mc/SW*Sqrt2*Zp21/sb*ssth
      AAABR(1674) = EE/MW*Mc/SW*Sqrt2*Zp22*csth/sb
      AAABR(1675) = EE/MW*Mc/SW*Sqrt2*Zp21*csth*(1D0/sb-sb)
      AAABR(1676) = EE/MW/SW*Sqrt2*Zp21*csth/sb
      AAABR(1677) = EE/SW*(2D0*Zm11*sdth+Md/MW*Sqrt2*Zm21
     &      /cb*cdth)
      AAABR(1678) = EE/SW*Zm11*cdth
      AAABR(1679) = EE/MW*Md/SW*Sqrt2*Zm21/cb*sdth
      AAABR(1680) = EE/MW*Md/SW*Sqrt2*Zm21/cb*sb**2*sdth
      AAABR(1681) = EE/MW/SW*Sqrt2*Zm21/cb*sdth
      AAABR(1682) = EE/MW*Mu/SW*Sqrt2*Zp21/sb*sdth
      AAABR(1683) = EE/MW*Mu/SW*Sqrt2*Zp21*cdth*(1D0/sb-sb)
      AAABR(1684) = EE/MW/SW*Sqrt2*Zp21*cdth/sb
      AAABR(1685) = EE/SW*(2D0*Zm12*ssth+Ms/MW*Sqrt2*Zm22
     &      /cb*csth)
      AAABR(1686) = EE/SW*Zm12*csth
      AAABR(1687) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*ssth
      AAABR(1688) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*sb**2*ssth
      AAABR(1689) = EE/MW/SW*Sqrt2*Zm22/cb*ssth
      AAABR(1690) = EE/MW*Mc/SW*Sqrt2*Zp22/sb*ssth
      AAABR(1691) = EE/MW*Mc/SW*Sqrt2*Zp22*csth*(1D0/sb-sb)
      AAABR(1692) = EE/MW/SW*Sqrt2*Zp22*csth/sb
      AAABR(1693) = EE/SW*(2D0*Zm12*sbth+Mb/MW*Sqrt2*Zm22
     &      /cb*cbth)
      AAABR(1694) = EE/SW*Zm12*cbth
      AAABR(1695) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*sbth
      AAABR(1696) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*sb**2*sbth
      AAABR(1697) = EE/MW/SW*Sqrt2*Zm22/cb*sbth
      AAABR(1698) = EE/MW*Mt/SW*Sqrt2*Zp22/sb*sbth
      AAABR(1699) = EE/MW*Mt/SW*Sqrt2*Zp22*cbth*(1D0/sb-sb)
      AAABR(1700) = EE/MW/SW*Sqrt2*Zp22*cbth/sb
      AAABR(1701) = EE/SW*Zm12*sdth
      AAABR(1702) = EE/MW*Md/SW*Sqrt2*Zm22/cb*cdth
      AAABR(1703) = EE/MW*Md/SW*Sqrt2*Zm22/cb*cdth*sb**2
      AAABR(1704) = EE/MW/SW*Sqrt2*Zm22/cb*cdth
      AAABR(1705) = EE/MW*Mu/SW*Sqrt2*Zp22*sdth*(1D0/sb-sb)
      AAABR(1706) = EE/MW/SW*Sqrt2*Zp22/sb*sdth
      AAABR(1707) = EE/SW*Zm12*sbth
      AAABR(1708) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*cbth
      AAABR(1709) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*cbth*sb**2
      AAABR(1710) = EE/MW/SW*Sqrt2*Zm22/cb*cbth
      AAABR(1711) = EE/MW*Mt/SW*Sqrt2*Zp22*sbth*(1D0/sb-sb)
      AAABR(1712) = EE/MW/SW*Sqrt2*Zp22/sb*sbth
      AAABR(1713) = EE/SW*Zm11*sbth
      AAABR(1714) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*cbth
      AAABR(1715) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*cbth*sb**2
      AAABR(1716) = EE/MW/SW*Sqrt2*Zm21/cb*cbth
      AAABR(1717) = EE/MW*Mt/SW*Sqrt2*Zp21*sbth*(1D0/sb-sb)
      AAABR(1718) = EE/MW/SW*Sqrt2*Zp21/sb*sbth
      AAABR(1719) = EE/SW*Zm11*sdth
      AAABR(1720) = EE/MW*Md/SW*Sqrt2*Zm21/cb*cdth
      AAABR(1721) = EE/MW*Md/SW*Sqrt2*Zm21/cb*cdth*sb**2
      AAABR(1722) = EE/MW/SW*Sqrt2*Zm21/cb*cdth
      AAABR(1723) = EE/MW*Mu/SW*Sqrt2*Zp21*sdth*(1D0/sb-sb)
      AAABR(1724) = EE/MW/SW*Sqrt2*Zp21/sb*sdth
      AAABR(1725) = EE/SW*Zm11*ssth
      AAABR(1726) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*csth
      AAABR(1727) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*csth*sb**2
      AAABR(1728) = EE/MW/SW*Sqrt2*Zm21/cb*csth
      AAABR(1729) = EE/MW*Mc/SW*Sqrt2*Zp21*ssth*(1D0/sb-sb)
      AAABR(1730) = EE/MW/SW*Sqrt2*Zp21/sb*ssth
      AAABR(1731) = EE/SW*Zm12*ssth
      AAABR(1732) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*csth
      AAABR(1733) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*csth*sb**2
      AAABR(1734) = EE/MW/SW*Sqrt2*Zm22/cb*csth
      AAABR(1735) = EE/MW*Mc/SW*Sqrt2*Zp22*ssth*(1D0/sb-sb)
      AAABR(1736) = EE/MW/SW*Sqrt2*Zp22/sb*ssth
      AAABR(1737) = EE/MW*Mm/SW*tb
      AAABR(1738) = EE/MW*Mm/SW*sb**2*tb
      AAABR(1739) = EE/MW/SW*tb
      AAABR(1740) = EE/MW*Ml/SW*tb
      AAABR(1741) = EE/MW*Ml/SW*sb**2*tb
      AAABR(1742) = EE/MW*Me/SW*tb
      AAABR(1743) = EE/MW*Me/SW*sb**2*tb
      AAABR(1744) = EE/MW*Mm/SW*sb**2
      AAABR(1745) = EE/MW/SW
      AAABR(1746) = EE/MW*Me/SW*sb**2
      AAABR(1747) = EE/MW*Ml/SW*sb**2
      AAABR(1748) = EE/MW*Ml/SW*ca/cb
      AAABR(1749) = EE/MW*Ml/SW/cb*sa
      AAABR(1750) = EE/MW*Ml/SW*ca/cb*sb**2
      AAABR(1751) = EE/MW/SW*ca/cb
      AAABR(1752) = EE/MW*Mm/SW*ca/cb
      AAABR(1753) = EE/MW*Mm/SW/cb*sa
      AAABR(1754) = EE/MW*Mm/SW*ca/cb*sb**2
      AAABR(1755) = EE/MW*Me/SW*ca/cb
      AAABR(1756) = EE/MW*Me/SW/cb*sa
      AAABR(1757) = EE/MW*Me/SW/cb*sa*sb**2
      AAABR(1758) = EE/MW/SW/cb*sa
      AAABR(1759) = EE/MW*Mm/SW/cb*sa*sb**2
      AAABR(1760) = EE/MW*Me/SW*ca/cb*sb**2
      AAABR(1761) = EE/MW*Ml/SW/cb*sa*sb**2
      AAABR(1762) = EE/MW*Me/SW*Sqrt2*tb
      AAABR(1763) = EE/MW*Me/SW*Sqrt2*sb**2*tb
      AAABR(1764) = EE/MW/SW*Sqrt2*tb
      AAABR(1765) = EE/MW*Mm/SW*Sqrt2*tb
      AAABR(1766) = EE/MW*Mm/SW*Sqrt2*sb**2*tb
      AAABR(1767) = EE/MW*Ml/SW*Sqrt2*tb
      AAABR(1768) = EE/MW*Ml/SW*Sqrt2*sb**2*tb
      AAABR(1769) = EE/MW*Ml/SW*Sqrt2
      AAABR(1770) = EE/MW*Ml/SW*Sqrt2*sb**2
      AAABR(1771) = EE/MW/SW*Sqrt2
      AAABR(1772) = EE/MW*Me/SW*Sqrt2
      end

      subroutine aaini03
      implicit none
#include "model.h"

      AAABR(1773) = EE/MW*Me/SW*Sqrt2*sb**2
      AAABR(1774) = EE/MW*Mm/SW*Sqrt2
      AAABR(1775) = EE/MW*Mm/SW*Sqrt2*sb**2
      AAABC(229) = EE*Sqrt2*(dconjg(Zn11)/CW*ceth+dconjg(Zn21
     &      )/SW*ceth-Me/MW/SW*dconjg(Zn31)/cb*seth)
      AAABC(230) = EE*Sqrt2*(dconjg(Zn12)/CW*ceth+dconjg(Zn22
     &      )/SW*ceth-Me/MW/SW*dconjg(Zn32)/cb*seth)
      AAABC(231) = EE*Sqrt2*(dconjg(Zn13)/CW*ceth+dconjg(Zn23
     &      )/SW*ceth-Me/MW/SW*dconjg(Zn33)/cb*seth)
      AAABC(232) = EE*Sqrt2*(dconjg(Zn14)/CW*ceth+dconjg(Zn24
     &      )/SW*ceth-Me/MW/SW*dconjg(Zn34)/cb*seth)
      AAABC(233) = EE*Sqrt2*(dconjg(Zn12)/CW*seth+dconjg(Zn22
     &      )/SW*seth+Me/MW/SW*dconjg(Zn32)/cb*ceth)
      AAABC(234) = EE/SW*Sqrt2*dconjg(Zn22)*ceth
      AAABC(235) = EE/CW*Sqrt2*dconjg(Zn12)*ceth
      AAABC(236) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*ceth
      AAABC(237) = EE*Sqrt2*(2D0*Zn11/CW*seth+Me/MW/SW*Zn31
     &      /cb*ceth)
      AAABC(238) = EE*Sqrt2*(2D0*Zn12/CW*seth+Me/MW/SW*Zn32
     &      /cb*ceth)
      AAABC(239) = EE*Sqrt2*(2D0*Zn12/CW*ceth-Me/MW/SW*Zn32
     &      /cb*seth)
      AAABC(240) = EE*Sqrt2*(2D0*Zn13/CW*seth+Me/MW/SW*Zn33
     &      /cb*ceth)
      AAABC(241) = EE*Sqrt2*(2D0*Zn14/CW*seth+Me/MW/SW*Zn34
     &      /cb*ceth)
      AAABC(242) = EE/CW*Sqrt2*Zn12*seth
      AAABC(243) = EE/CW**2*SW*Sqrt2*Zn12*seth
      AAABC(244) = EE/MW*Me/SW*Sqrt2*dconjg(Zn32)/cb*seth
      AAABC(245) = EE/MW*Me/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *seth
      AAABC(246) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*seth
      AAABC(247) = EE/MW*Me/SW*Sqrt2*Zn32/cb*ceth
      AAABC(248) = EE/MW*Me/SW*Sqrt2*Zn32/cb*ceth*sb**2
      AAABC(249) = EE/MW/SW*Sqrt2*Zn32/cb*ceth
      AAABC(250) = EE*Sqrt2*(dconjg(Zn11)/CW*seth+dconjg(Zn21
     &      )/SW*seth+Me/MW/SW*dconjg(Zn31)/cb*ceth)
      AAABC(251) = EE/SW*Sqrt2*dconjg(Zn21)*ceth
      AAABC(252) = EE/CW*Sqrt2*dconjg(Zn11)*ceth
      AAABC(253) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*ceth
      AAABC(254) = EE*Sqrt2*(2D0*Zn11/CW*ceth-Me/MW/SW*Zn31
     &      /cb*seth)
      AAABC(255) = EE/CW*Sqrt2*Zn11*seth
      AAABC(256) = EE/CW**2*SW*Sqrt2*Zn11*seth
      AAABC(257) = EE/MW*Me/SW*Sqrt2*dconjg(Zn31)/cb*seth
      AAABC(258) = EE/MW*Me/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *seth
      AAABC(259) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*seth
      AAABC(260) = EE/MW*Me/SW*Sqrt2*Zn31/cb*ceth
      AAABC(261) = EE/MW*Me/SW*Sqrt2*Zn31/cb*ceth*sb**2
      AAABC(262) = EE/MW/SW*Sqrt2*Zn31/cb*ceth
      AAABC(263) = EE*Sqrt2*(dconjg(Zn11)/CW*cmuth+dconjg(Zn21
     &      )/SW*cmuth-Mm/MW/SW*dconjg(Zn31)/cb*smuth)
      AAABC(264) = EE*Sqrt2*(dconjg(Zn12)/CW*cmuth+dconjg(Zn22
     &      )/SW*cmuth-Mm/MW/SW*dconjg(Zn32)/cb*smuth)
      AAABC(265) = EE*Sqrt2*(dconjg(Zn13)/CW*cmuth+dconjg(Zn23
     &      )/SW*cmuth-Mm/MW/SW*dconjg(Zn33)/cb*smuth)
      AAABC(266) = EE*Sqrt2*(dconjg(Zn14)/CW*cmuth+dconjg(Zn24
     &      )/SW*cmuth-Mm/MW/SW*dconjg(Zn34)/cb*smuth)
      AAABC(267) = EE*Sqrt2*(dconjg(Zn14)/CW*smuth+dconjg(Zn24
     &      )/SW*smuth+Mm/MW/SW*dconjg(Zn34)/cb*cmuth)
      AAABC(268) = EE/SW*Sqrt2*dconjg(Zn24)*cmuth
      AAABC(269) = EE/CW*Sqrt2*dconjg(Zn14)*cmuth
      AAABC(270) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*cmuth
      AAABC(271) = EE*Sqrt2*(2D0*Zn11/CW*smuth+Mm/MW/SW*Zn31
     &      /cb*cmuth)
      AAABC(272) = EE*Sqrt2*(2D0*Zn12/CW*smuth+Mm/MW/SW*Zn32
     &      /cb*cmuth)
      AAABC(273) = EE*Sqrt2*(2D0*Zn13/CW*smuth+Mm/MW/SW*Zn33
     &      /cb*cmuth)
      AAABC(274) = EE*Sqrt2*(2D0*Zn14/CW*smuth+Mm/MW/SW*Zn34
     &      /cb*cmuth)
      AAABC(275) = EE*Sqrt2*(2D0*Zn14/CW*cmuth-Mm/MW/SW*Zn34
     &      /cb*smuth)
      AAABC(276) = EE/CW*Sqrt2*Zn14*smuth
      AAABC(277) = EE/CW**2*SW*Sqrt2*Zn14*smuth
      AAABC(278) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn34)/cb*smuth
      AAABC(279) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *smuth
      AAABC(280) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*smuth
      AAABC(281) = EE/MW*Mm/SW*Sqrt2*Zn34/cb*cmuth
      AAABC(282) = EE/MW*Mm/SW*Sqrt2*Zn34/cb*cmuth*sb**2
      AAABC(283) = EE/MW/SW*Sqrt2*Zn34/cb*cmuth
      AAABC(284) = EE*Sqrt2*(dconjg(Zn13)/CW*seth+dconjg(Zn23
     &      )/SW*seth+Me/MW/SW*dconjg(Zn33)/cb*ceth)
      AAABC(285) = EE/SW*Sqrt2*dconjg(Zn23)*ceth
      AAABC(286) = EE/CW*Sqrt2*dconjg(Zn13)*ceth
      AAABC(287) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*ceth
      AAABC(288) = EE*Sqrt2*(2D0*Zn13/CW*ceth-Me/MW/SW*Zn33
     &      /cb*seth)
      AAABC(289) = EE/CW*Sqrt2*Zn13*seth
      AAABC(290) = EE/CW**2*SW*Sqrt2*Zn13*seth
      AAABC(291) = EE/MW*Me/SW*Sqrt2*dconjg(Zn33)/cb*seth
      AAABC(292) = EE/MW*Me/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *seth
      AAABC(293) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*seth
      AAABC(294) = EE/MW*Me/SW*Sqrt2*Zn33/cb*ceth
      AAABC(295) = EE/MW*Me/SW*Sqrt2*Zn33/cb*ceth*sb**2
      AAABC(296) = EE/MW/SW*Sqrt2*Zn33/cb*ceth
      AAABC(297) = EE*Sqrt2*(dconjg(Zn11)/CW*clth+dconjg(Zn21
     &      )/SW*clth-Ml/MW/SW*dconjg(Zn31)/cb*slth)
      AAABC(298) = EE*Sqrt2*(dconjg(Zn12)/CW*clth+dconjg(Zn22
     &      )/SW*clth-Ml/MW/SW*dconjg(Zn32)/cb*slth)
      AAABC(299) = EE*Sqrt2*(dconjg(Zn13)/CW*clth+dconjg(Zn23
     &      )/SW*clth-Ml/MW/SW*dconjg(Zn33)/cb*slth)
      AAABC(300) = EE*Sqrt2*(dconjg(Zn14)/CW*clth+dconjg(Zn24
     &      )/SW*clth-Ml/MW/SW*dconjg(Zn34)/cb*slth)
      AAABC(301) = EE*Sqrt2*(dconjg(Zn14)/CW*slth+dconjg(Zn24
     &      )/SW*slth+Ml/MW/SW*dconjg(Zn34)/cb*clth)
      AAABC(302) = EE/SW*Sqrt2*dconjg(Zn24)*clth
      AAABC(303) = EE/CW*Sqrt2*dconjg(Zn14)*clth
      AAABC(304) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*clth
      AAABC(305) = EE*Sqrt2*(2D0*Zn11/CW*slth+Ml/MW/SW*Zn31
     &      /cb*clth)
      AAABC(306) = EE*Sqrt2*(2D0*Zn12/CW*slth+Ml/MW/SW*Zn32
     &      /cb*clth)
      AAABC(307) = EE*Sqrt2*(2D0*Zn13/CW*slth+Ml/MW/SW*Zn33
     &      /cb*clth)
      AAABC(308) = EE*Sqrt2*(2D0*Zn14/CW*slth+Ml/MW/SW*Zn34
     &      /cb*clth)
      AAABC(309) = EE*Sqrt2*(2D0*Zn14/CW*clth-Ml/MW/SW*Zn34
     &      /cb*slth)
      AAABC(310) = EE/CW*Sqrt2*Zn14*slth
      AAABC(311) = EE/CW**2*SW*Sqrt2*Zn14*slth
      AAABC(312) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn34)/cb*slth
      AAABC(313) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *slth
      AAABC(314) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*slth
      AAABC(315) = EE/MW*Ml/SW*Sqrt2*Zn34/cb*clth
      AAABC(316) = EE/MW*Ml/SW*Sqrt2*Zn34/cb*clth*sb**2
      AAABC(317) = EE/MW/SW*Sqrt2*Zn34/cb*clth
      AAABC(318) = EE*Sqrt2*(dconjg(Zn11)/CW*slth+dconjg(Zn21
     &      )/SW*slth+Ml/MW/SW*dconjg(Zn31)/cb*clth)
      AAABC(319) = EE/SW*Sqrt2*dconjg(Zn21)*clth
      AAABC(320) = EE/CW*Sqrt2*dconjg(Zn11)*clth
      AAABC(321) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*clth
      AAABC(322) = EE*Sqrt2*(2D0*Zn11/CW*clth-Ml/MW/SW*Zn31
     &      /cb*slth)
      AAABC(323) = EE/CW*Sqrt2*Zn11*slth
      AAABC(324) = EE/CW**2*SW*Sqrt2*Zn11*slth
      AAABC(325) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn31)/cb*slth
      AAABC(326) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *slth
      AAABC(327) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*slth
      AAABC(328) = EE/MW*Ml/SW*Sqrt2*Zn31/cb*clth
      AAABC(329) = EE/MW*Ml/SW*Sqrt2*Zn31/cb*clth*sb**2
      AAABC(330) = EE/MW/SW*Sqrt2*Zn31/cb*clth
      AAABC(331) = EE*Sqrt2*(dconjg(Zn13)/CW*smuth+dconjg(Zn23
     &      )/SW*smuth+Mm/MW/SW*dconjg(Zn33)/cb*cmuth)
      AAABC(332) = EE/SW*Sqrt2*dconjg(Zn23)*cmuth
      AAABC(333) = EE/CW*Sqrt2*dconjg(Zn13)*cmuth
      AAABC(334) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*cmuth
      AAABC(335) = EE*Sqrt2*(2D0*Zn13/CW*cmuth-Mm/MW/SW*Zn33
     &      /cb*smuth)
      AAABC(336) = EE/CW*Sqrt2*Zn13*smuth
      AAABC(337) = EE/CW**2*SW*Sqrt2*Zn13*smuth
      AAABC(338) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn33)/cb*smuth
      AAABC(339) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *smuth
      AAABC(340) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*smuth
      AAABC(341) = EE/MW*Mm/SW*Sqrt2*Zn33/cb*cmuth
      AAABC(342) = EE/MW*Mm/SW*Sqrt2*Zn33/cb*cmuth*sb**2
      AAABC(343) = EE/MW/SW*Sqrt2*Zn33/cb*cmuth
      AAABC(344) = EE*Sqrt2*(dconjg(Zn12)/CW*slth+dconjg(Zn22
     &      )/SW*slth+Ml/MW/SW*dconjg(Zn32)/cb*clth)
      AAABC(345) = EE/SW*Sqrt2*dconjg(Zn22)*clth
      AAABC(346) = EE/CW*Sqrt2*dconjg(Zn12)*clth
      AAABC(347) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*clth
      AAABC(348) = EE*Sqrt2*(2D0*Zn12/CW*clth-Ml/MW/SW*Zn32
     &      /cb*slth)
      AAABC(349) = EE/CW*Sqrt2*Zn12*slth
      AAABC(350) = EE/CW**2*SW*Sqrt2*Zn12*slth
      AAABC(351) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn32)/cb*slth
      AAABC(352) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *slth
      AAABC(353) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*slth
      AAABC(354) = EE/MW*Ml/SW*Sqrt2*Zn32/cb*clth
      AAABC(355) = EE/MW*Ml/SW*Sqrt2*Zn32/cb*clth*sb**2
      AAABC(356) = EE/MW/SW*Sqrt2*Zn32/cb*clth
      AAABC(357) = EE*Sqrt2*(dconjg(Zn13)/CW*slth+dconjg(Zn23
     &      )/SW*slth+Ml/MW/SW*dconjg(Zn33)/cb*clth)
      AAABC(358) = EE/SW*Sqrt2*dconjg(Zn23)*clth
      AAABC(359) = EE/CW*Sqrt2*dconjg(Zn13)*clth
      AAABC(360) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*clth
      AAABC(361) = EE*Sqrt2*(2D0*Zn13/CW*clth-Ml/MW/SW*Zn33
     &      /cb*slth)
      AAABC(362) = EE/CW*Sqrt2*Zn13*slth
      AAABC(363) = EE/CW**2*SW*Sqrt2*Zn13*slth
      AAABC(364) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn33)/cb*slth
      AAABC(365) = EE/MW*Ml/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *slth
      AAABC(366) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*slth
      AAABC(367) = EE/MW*Ml/SW*Sqrt2*Zn33/cb*clth
      AAABC(368) = EE/MW*Ml/SW*Sqrt2*Zn33/cb*clth*sb**2
      AAABC(369) = EE/MW/SW*Sqrt2*Zn33/cb*clth
      AAABC(370) = EE*Sqrt2*(dconjg(Zn14)/CW*seth+dconjg(Zn24
     &      )/SW*seth+Me/MW/SW*dconjg(Zn34)/cb*ceth)
      AAABC(371) = EE/SW*Sqrt2*dconjg(Zn24)*ceth
      AAABC(372) = EE/CW*Sqrt2*dconjg(Zn14)*ceth
      AAABC(373) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*ceth
      AAABC(374) = EE*Sqrt2*(2D0*Zn14/CW*ceth-Me/MW/SW*Zn34
     &      /cb*seth)
      AAABC(375) = EE/CW*Sqrt2*Zn14*seth
      AAABC(376) = EE/CW**2*SW*Sqrt2*Zn14*seth
      AAABC(377) = EE/MW*Me/SW*Sqrt2*dconjg(Zn34)/cb*seth
      AAABC(378) = EE/MW*Me/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *seth
      AAABC(379) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*seth
      AAABC(380) = EE/MW*Me/SW*Sqrt2*Zn34/cb*ceth
      AAABC(381) = EE/MW*Me/SW*Sqrt2*Zn34/cb*ceth*sb**2
      AAABC(382) = EE/MW/SW*Sqrt2*Zn34/cb*ceth
      AAABC(383) = EE*Sqrt2*(dconjg(Zn12)/CW*smuth+dconjg(Zn22
     &      )/SW*smuth+Mm/MW/SW*dconjg(Zn32)/cb*cmuth)
      AAABC(384) = EE/SW*Sqrt2*dconjg(Zn22)*cmuth
      AAABC(385) = EE/CW*Sqrt2*dconjg(Zn12)*cmuth
      AAABC(386) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*cmuth
      AAABC(387) = EE*Sqrt2*(2D0*Zn12/CW*cmuth-Mm/MW/SW*Zn32
     &      /cb*smuth)
      AAABC(388) = EE/CW*Sqrt2*Zn12*smuth
      AAABC(389) = EE/CW**2*SW*Sqrt2*Zn12*smuth
      AAABC(390) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn32)/cb*smuth
      AAABC(391) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *smuth
      AAABC(392) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*smuth
      AAABC(393) = EE/MW*Mm/SW*Sqrt2*Zn32/cb*cmuth
      AAABC(394) = EE/MW*Mm/SW*Sqrt2*Zn32/cb*cmuth*sb**2
      AAABC(395) = EE/MW/SW*Sqrt2*Zn32/cb*cmuth
      AAABC(396) = EE*Sqrt2*(dconjg(Zn11)/CW*smuth+dconjg(Zn21
     &      )/SW*smuth+Mm/MW/SW*dconjg(Zn31)/cb*cmuth)
      AAABC(397) = EE/SW*Sqrt2*dconjg(Zn21)*cmuth
      AAABC(398) = EE/CW*Sqrt2*dconjg(Zn11)*cmuth
      AAABC(399) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*cmuth
      AAABC(400) = EE*Sqrt2*(2D0*Zn11/CW*cmuth-Mm/MW/SW*Zn31
     &      /cb*smuth)
      AAABC(401) = EE/CW*Sqrt2*Zn11*smuth
      AAABC(402) = EE/CW**2*SW*Sqrt2*Zn11*smuth
      AAABC(403) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn31)/cb*smuth
      AAABC(404) = EE/MW*Mm/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *smuth
      AAABC(405) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*smuth
      AAABC(406) = EE/MW*Mm/SW*Sqrt2*Zn31/cb*cmuth
      AAABC(407) = EE/MW*Mm/SW*Sqrt2*Zn31/cb*cmuth*sb**2
      AAABC(408) = EE/MW/SW*Sqrt2*Zn31/cb*cmuth
      AAABC(409) = EE/SW*Sqrt2*dconjg(Zn23)*seth
      AAABC(410) = EE/SW*Sqrt2*dconjg(Zn24)*slth
      AAABC(411) = EE/SW*Sqrt2*dconjg(Zn23)*slth
      AAABC(412) = EE/SW*Sqrt2*dconjg(Zn24)*seth
      AAABC(413) = EE/SW*Sqrt2*dconjg(Zn21)*smuth
      AAABC(414) = EE/SW*Sqrt2*dconjg(Zn24)*smuth
      AAABC(415) = EE/SW*Sqrt2*dconjg(Zn23)*smuth
      AAABC(416) = EE/SW*Sqrt2*dconjg(Zn22)*smuth
      AAABC(417) = EE/SW*Sqrt2*dconjg(Zn22)*seth
      AAABC(418) = EE/SW*Sqrt2*dconjg(Zn22)*slth
      AAABC(419) = EE/SW*Sqrt2*dconjg(Zn21)*seth
      AAABC(420) = EE/SW*Sqrt2*dconjg(Zn21)*slth
      AAABR(1776) = EE/SW*Zp11
      AAABR(1777) = EE/SW*Zp12
      AAABR(1778) = EE/MW*Me/SW*Sqrt2*Zm21/cb
      AAABR(1779) = EE/MW*Me/SW*Sqrt2*Zm22/cb
      AAABR(1780) = EE/MW*Me/SW*Sqrt2*Zm21/cb*sb**2
      AAABR(1781) = EE/MW/SW*Sqrt2*Zm21/cb
      AAABR(1782) = EE/MW*Ml/SW*Sqrt2*Zm21/cb
      AAABR(1783) = EE/MW*Ml/SW*Sqrt2*Zm22/cb
      AAABR(1784) = EE/MW*Ml/SW*Sqrt2*Zm21/cb*sb**2
      AAABR(1785) = EE/MW*Mm/SW*Sqrt2*Zm21/cb
      AAABR(1786) = EE/MW*Mm/SW*Sqrt2*Zm22/cb
      AAABR(1787) = EE/MW*Mm/SW*Sqrt2*Zm21/cb*sb**2
      AAABR(1788) = EE/MW*Ml/SW*Sqrt2*Zm22/cb*sb**2
      AAABR(1789) = EE/MW/SW*Sqrt2*Zm22/cb
      AAABR(1790) = EE/MW*Me/SW*Sqrt2*Zm22/cb*sb**2
      AAABR(1791) = EE/MW*Mm/SW*Sqrt2*Zm22/cb*sb**2
      AAABC(421) = EE*Sqrt2*(dconjg(Zn11)/CW-dconjg(Zn21
     &      )/SW)
      AAABC(422) = EE*Sqrt2*(dconjg(Zn12)/CW-dconjg(Zn22
     &      )/SW)
      AAABC(423) = EE*Sqrt2*(dconjg(Zn13)/CW-dconjg(Zn23
     &      )/SW)
      AAABC(424) = EE*Sqrt2*(dconjg(Zn14)/CW-dconjg(Zn24
     &      )/SW)
      AAABC(425) = EE/SW*Sqrt2*dconjg(Zn24)
      AAABC(426) = EE/CW*Sqrt2*dconjg(Zn14)
      AAABC(427) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)
      AAABC(428) = EE/SW*Sqrt2*dconjg(Zn23)
      AAABC(429) = EE/CW*Sqrt2*dconjg(Zn13)
      AAABC(430) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)
      AAABC(431) = EE/SW*Sqrt2*dconjg(Zn22)
      AAABC(432) = EE/CW*Sqrt2*dconjg(Zn12)
      AAABC(433) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)
      AAABC(434) = EE/SW*Sqrt2*dconjg(Zn21)
      AAABC(435) = EE/CW*Sqrt2*dconjg(Zn11)
      AAABC(436) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)
      AAABC(437) = EE*Sqrt2*(dconjg(Zn11)/CW*cbth-3D0*dconjg(Zn21
     &      )/SW*cbth+3D0*Mb/MW/SW*dconjg(Zn31)/cb*sbth)
      AAABC(438) = EE*Sqrt2*(dconjg(Zn12)/CW*cbth-3D0*dconjg(Zn22
     &      )/SW*cbth+3D0*Mb/MW/SW*dconjg(Zn32)/cb*sbth)
      AAABC(439) = EE*Sqrt2*(dconjg(Zn13)/CW*cbth-3D0*dconjg(Zn23
     &      )/SW*cbth+3D0*Mb/MW/SW*dconjg(Zn33)/cb*sbth)
      AAABC(440) = EE*Sqrt2*(dconjg(Zn14)/CW*cbth-3D0*dconjg(Zn24
     &      )/SW*cbth+3D0*Mb/MW/SW*dconjg(Zn34)/cb*sbth)
      AAABC(441) = EE*Sqrt2*(dconjg(Zn11)/CW*sbth-3D0*dconjg(Zn21
     &      )/SW*sbth-3D0*Mb/MW/SW*dconjg(Zn31)/cb*cbth)
      AAABC(442) = EE/SW*Sqrt2*dconjg(Zn21)*cbth
      AAABC(443) = EE/CW*Sqrt2*dconjg(Zn11)*cbth
      AAABC(444) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*cbth
      AAABC(445) = EE*Sqrt2*(2D0*Zn11/CW*sbth+3D0*Mb/MW/SW
     &      *Zn31/cb*cbth)
      AAABC(446) = EE*Sqrt2*(2D0*Zn11/CW*cbth-3D0*Mb/MW/SW
     &      *Zn31/cb*sbth)
      AAABC(447) = EE*Sqrt2*(2D0*Zn12/CW*sbth+3D0*Mb/MW/SW
     &      *Zn32/cb*cbth)
      AAABC(448) = EE*Sqrt2*(2D0*Zn13/CW*sbth+3D0*Mb/MW/SW
     &      *Zn33/cb*cbth)
      AAABC(449) = EE*Sqrt2*(2D0*Zn14/CW*sbth+3D0*Mb/MW/SW
     &      *Zn34/cb*cbth)
      AAABC(450) = EE/CW*Sqrt2*Zn11*sbth
      AAABC(451) = EE/CW**2*SW*Sqrt2*Zn11*sbth
      AAABC(452) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn31)/cb*sbth
      AAABC(453) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *sbth
      AAABC(454) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*sbth
      AAABC(455) = EE/MW*Mb/SW*Sqrt2*Zn31/cb*cbth
      AAABC(456) = EE/MW*Mb/SW*Sqrt2*Zn31/cb*cbth*sb**2
      AAABC(457) = EE/MW/SW*Sqrt2*Zn31/cb*cbth
      AAABC(458) = EE*Sqrt2*(dconjg(Zn11)/CW*cdth-3D0*dconjg(Zn21
     &      )/SW*cdth+3D0*Md/MW/SW*dconjg(Zn31)/cb*sdth)
      AAABC(459) = EE*Sqrt2*(dconjg(Zn12)/CW*cdth-3D0*dconjg(Zn22
     &      )/SW*cdth+3D0*Md/MW/SW*dconjg(Zn32)/cb*sdth)
      AAABC(460) = EE*Sqrt2*(dconjg(Zn13)/CW*cdth-3D0*dconjg(Zn23
     &      )/SW*cdth+3D0*Md/MW/SW*dconjg(Zn33)/cb*sdth)
      AAABC(461) = EE*Sqrt2*(dconjg(Zn14)/CW*cdth-3D0*dconjg(Zn24
     &      )/SW*cdth+3D0*Md/MW/SW*dconjg(Zn34)/cb*sdth)
      AAABC(462) = EE*Sqrt2*(dconjg(Zn12)/CW*sdth-3D0*dconjg(Zn22
     &      )/SW*sdth-3D0*Md/MW/SW*dconjg(Zn32)/cb*cdth)
      AAABC(463) = EE/SW*Sqrt2*dconjg(Zn22)*cdth
      AAABC(464) = EE/CW*Sqrt2*dconjg(Zn12)*cdth
      AAABC(465) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*cdth
      AAABC(466) = EE*Sqrt2*(2D0*Zn11/CW*sdth+3D0*Md/MW/SW
     &      *Zn31/cb*cdth)
      AAABC(467) = EE*Sqrt2*(2D0*Zn12/CW*sdth+3D0*Md/MW/SW
     &      *Zn32/cb*cdth)
      AAABC(468) = EE*Sqrt2*(2D0*Zn12/CW*cdth-3D0*Md/MW/SW
     &      *Zn32/cb*sdth)
      AAABC(469) = EE*Sqrt2*(2D0*Zn13/CW*sdth+3D0*Md/MW/SW
     &      *Zn33/cb*cdth)
      AAABC(470) = EE*Sqrt2*(2D0*Zn14/CW*sdth+3D0*Md/MW/SW
     &      *Zn34/cb*cdth)
      AAABC(471) = EE/CW*Sqrt2*Zn12*sdth
      AAABC(472) = EE/CW**2*SW*Sqrt2*Zn12*sdth
      AAABC(473) = EE/MW*Md/SW*Sqrt2*dconjg(Zn32)/cb*sdth
      AAABC(474) = EE/MW*Md/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *sdth
      AAABC(475) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*sdth
      AAABC(476) = EE/MW*Md/SW*Sqrt2*Zn32/cb*cdth
      AAABC(477) = EE/MW*Md/SW*Sqrt2*Zn32/cb*cdth*sb**2
      AAABC(478) = EE/MW/SW*Sqrt2*Zn32/cb*cdth
      AAABC(479) = EE*Sqrt2*(dconjg(Zn13)/CW*sdth-3D0*dconjg(Zn23
     &      )/SW*sdth-3D0*Md/MW/SW*dconjg(Zn33)/cb*cdth)
      AAABC(480) = EE/SW*Sqrt2*dconjg(Zn23)*cdth
      AAABC(481) = EE/CW*Sqrt2*dconjg(Zn13)*cdth
      AAABC(482) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*cdth
      AAABC(483) = EE*Sqrt2*(2D0*Zn13/CW*cdth-3D0*Md/MW/SW
     &      *Zn33/cb*sdth)
      AAABC(484) = EE/CW*Sqrt2*Zn13*sdth
      AAABC(485) = EE/CW**2*SW*Sqrt2*Zn13*sdth
      AAABC(486) = EE/MW*Md/SW*Sqrt2*dconjg(Zn33)/cb*sdth
      AAABC(487) = EE/MW*Md/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *sdth
      AAABC(488) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*sdth
      AAABC(489) = EE/MW*Md/SW*Sqrt2*Zn33/cb*cdth
      AAABC(490) = EE/MW*Md/SW*Sqrt2*Zn33/cb*cdth*sb**2
      AAABC(491) = EE/MW/SW*Sqrt2*Zn33/cb*cdth
      AAABC(492) = EE*Sqrt2*(dconjg(Zn14)/CW*sbth-3D0*dconjg(Zn24
     &      )/SW*sbth-3D0*Mb/MW/SW*dconjg(Zn34)/cb*cbth)
      AAABC(493) = EE/SW*Sqrt2*dconjg(Zn24)*cbth
      AAABC(494) = EE/CW*Sqrt2*dconjg(Zn14)*cbth
      AAABC(495) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*cbth
      AAABC(496) = EE*Sqrt2*(2D0*Zn14/CW*cbth-3D0*Mb/MW/SW
     &      *Zn34/cb*sbth)
      AAABC(497) = EE/CW*Sqrt2*Zn14*sbth
      AAABC(498) = EE/CW**2*SW*Sqrt2*Zn14*sbth
      AAABC(499) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn34)/cb*sbth
      AAABC(500) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *sbth
      AAABC(501) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*sbth
      AAABC(502) = EE/MW*Mb/SW*Sqrt2*Zn34/cb*cbth
      AAABC(503) = EE/MW*Mb/SW*Sqrt2*Zn34/cb*cbth*sb**2
      AAABC(504) = EE/MW/SW*Sqrt2*Zn34/cb*cbth
      AAABC(505) = EE*Sqrt2*(dconjg(Zn11)/CW*sdth-3D0*dconjg(Zn21
     &      )/SW*sdth-3D0*Md/MW/SW*dconjg(Zn31)/cb*cdth)
      AAABC(506) = EE/SW*Sqrt2*dconjg(Zn21)*cdth
      AAABC(507) = EE/CW*Sqrt2*dconjg(Zn11)*cdth
      AAABC(508) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*cdth
      AAABC(509) = EE*Sqrt2*(2D0*Zn11/CW*cdth-3D0*Md/MW/SW
     &      *Zn31/cb*sdth)
      AAABC(510) = EE/CW*Sqrt2*Zn11*sdth
      AAABC(511) = EE/CW**2*SW*Sqrt2*Zn11*sdth
      AAABC(512) = EE/MW*Md/SW*Sqrt2*dconjg(Zn31)/cb*sdth
      AAABC(513) = EE/MW*Md/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *sdth
      AAABC(514) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*sdth
      AAABC(515) = EE/MW*Md/SW*Sqrt2*Zn31/cb*cdth
      AAABC(516) = EE/MW*Md/SW*Sqrt2*Zn31/cb*cdth*sb**2
      AAABC(517) = EE/MW/SW*Sqrt2*Zn31/cb*cdth
      AAABC(518) = EE*Sqrt2*(dconjg(Zn14)/CW*sdth-3D0*dconjg(Zn24
     &      )/SW*sdth-3D0*Md/MW/SW*dconjg(Zn34)/cb*cdth)
      AAABC(519) = EE/SW*Sqrt2*dconjg(Zn24)*cdth
      AAABC(520) = EE/CW*Sqrt2*dconjg(Zn14)*cdth
      AAABC(521) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*cdth
      AAABC(522) = EE*Sqrt2*(2D0*Zn14/CW*cdth-3D0*Md/MW/SW
     &      *Zn34/cb*sdth)
      AAABC(523) = EE/CW*Sqrt2*Zn14*sdth
      AAABC(524) = EE/CW**2*SW*Sqrt2*Zn14*sdth
      AAABC(525) = EE/MW*Md/SW*Sqrt2*dconjg(Zn34)/cb*sdth
      AAABC(526) = EE/MW*Md/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *sdth
      AAABC(527) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*sdth
      AAABC(528) = EE/MW*Md/SW*Sqrt2*Zn34/cb*cdth
      AAABC(529) = EE/MW*Md/SW*Sqrt2*Zn34/cb*cdth*sb**2
      AAABC(530) = EE/MW/SW*Sqrt2*Zn34/cb*cdth
      AAABC(531) = EE*Sqrt2*(dconjg(Zn11)/CW*csth-3D0*dconjg(Zn21
     &      )/SW*csth+3D0*Ms/MW/SW*dconjg(Zn31)/cb*ssth)
      AAABC(532) = EE*Sqrt2*(dconjg(Zn12)/CW*csth-3D0*dconjg(Zn22
     &      )/SW*csth+3D0*Ms/MW/SW*dconjg(Zn32)/cb*ssth)
      AAABC(533) = EE*Sqrt2*(dconjg(Zn13)/CW*csth-3D0*dconjg(Zn23
     &      )/SW*csth+3D0*Ms/MW/SW*dconjg(Zn33)/cb*ssth)
      AAABC(534) = EE*Sqrt2*(dconjg(Zn14)/CW*csth-3D0*dconjg(Zn24
     &      )/SW*csth+3D0*Ms/MW/SW*dconjg(Zn34)/cb*ssth)
      AAABC(535) = EE*Sqrt2*(dconjg(Zn13)/CW*ssth-3D0*dconjg(Zn23
     &      )/SW*ssth-3D0*Ms/MW/SW*dconjg(Zn33)/cb*csth)
      AAABC(536) = EE/SW*Sqrt2*dconjg(Zn23)*csth
      AAABC(537) = EE/CW*Sqrt2*dconjg(Zn13)*csth
      AAABC(538) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*csth
      AAABC(539) = EE*Sqrt2*(2D0*Zn11/CW*ssth+3D0*Ms/MW/SW
     &      *Zn31/cb*csth)
      AAABC(540) = EE*Sqrt2*(2D0*Zn12/CW*ssth+3D0*Ms/MW/SW
     &      *Zn32/cb*csth)
      AAABC(541) = EE*Sqrt2*(2D0*Zn13/CW*ssth+3D0*Ms/MW/SW
     &      *Zn33/cb*csth)
      AAABC(542) = EE*Sqrt2*(2D0*Zn13/CW*csth-3D0*Ms/MW/SW
     &      *Zn33/cb*ssth)
      AAABC(543) = EE*Sqrt2*(2D0*Zn14/CW*ssth+3D0*Ms/MW/SW
     &      *Zn34/cb*csth)
      AAABC(544) = EE/CW*Sqrt2*Zn13*ssth
      AAABC(545) = EE/CW**2*SW*Sqrt2*Zn13*ssth
      AAABC(546) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn33)/cb*ssth
      AAABC(547) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *ssth
      AAABC(548) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*ssth
      AAABC(549) = EE/MW*Ms/SW*Sqrt2*Zn33/cb*csth
      AAABC(550) = EE/MW*Ms/SW*Sqrt2*Zn33/cb*csth*sb**2
      AAABC(551) = EE/MW/SW*Sqrt2*Zn33/cb*csth
      AAABC(552) = EE*Sqrt2*(dconjg(Zn13)/CW*sbth-3D0*dconjg(Zn23
     &      )/SW*sbth-3D0*Mb/MW/SW*dconjg(Zn33)/cb*cbth)
      AAABC(553) = EE/SW*Sqrt2*dconjg(Zn23)*cbth
      AAABC(554) = EE/CW*Sqrt2*dconjg(Zn13)*cbth
      AAABC(555) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*cbth
      AAABC(556) = EE*Sqrt2*(2D0*Zn13/CW*cbth-3D0*Mb/MW/SW
     &      *Zn33/cb*sbth)
      AAABC(557) = EE/CW*Sqrt2*Zn13*sbth
      AAABC(558) = EE/CW**2*SW*Sqrt2*Zn13*sbth
      AAABC(559) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn33)/cb*sbth
      AAABC(560) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn33)/cb*sb**2
     &      *sbth
      AAABC(561) = EE/MW/SW*Sqrt2*dconjg(Zn33)/cb*sbth
      AAABC(562) = EE/MW*Mb/SW*Sqrt2*Zn33/cb*cbth
      AAABC(563) = EE/MW*Mb/SW*Sqrt2*Zn33/cb*cbth*sb**2
      AAABC(564) = EE/MW/SW*Sqrt2*Zn33/cb*cbth
      AAABC(565) = EE*Sqrt2*(dconjg(Zn11)/CW*ssth-3D0*dconjg(Zn21
     &      )/SW*ssth-3D0*Ms/MW/SW*dconjg(Zn31)/cb*csth)
      AAABC(566) = EE/SW*Sqrt2*dconjg(Zn21)*csth
      AAABC(567) = EE/CW*Sqrt2*dconjg(Zn11)*csth
      AAABC(568) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*csth
      AAABC(569) = EE*Sqrt2*(2D0*Zn11/CW*csth-3D0*Ms/MW/SW
     &      *Zn31/cb*ssth)
      AAABC(570) = EE/CW*Sqrt2*Zn11*ssth
      AAABC(571) = EE/CW**2*SW*Sqrt2*Zn11*ssth
      AAABC(572) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn31)/cb*ssth
      AAABC(573) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn31)/cb*sb**2
     &      *ssth
      AAABC(574) = EE/MW/SW*Sqrt2*dconjg(Zn31)/cb*ssth
      AAABC(575) = EE/MW*Ms/SW*Sqrt2*Zn31/cb*csth
      AAABC(576) = EE/MW*Ms/SW*Sqrt2*Zn31/cb*csth*sb**2
      AAABC(577) = EE/MW/SW*Sqrt2*Zn31/cb*csth
      AAABC(578) = EE*Sqrt2*(dconjg(Zn12)/CW*sbth-3D0*dconjg(Zn22
     &      )/SW*sbth-3D0*Mb/MW/SW*dconjg(Zn32)/cb*cbth)
      AAABC(579) = EE/SW*Sqrt2*dconjg(Zn22)*cbth
      AAABC(580) = EE/CW*Sqrt2*dconjg(Zn12)*cbth
      AAABC(581) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*cbth
      AAABC(582) = EE*Sqrt2*(2D0*Zn12/CW*cbth-3D0*Mb/MW/SW
     &      *Zn32/cb*sbth)
      AAABC(583) = EE/CW*Sqrt2*Zn12*sbth
      AAABC(584) = EE/CW**2*SW*Sqrt2*Zn12*sbth
      AAABC(585) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn32)/cb*sbth
      AAABC(586) = EE/MW*Mb/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *sbth
      AAABC(587) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*sbth
      AAABC(588) = EE/MW*Mb/SW*Sqrt2*Zn32/cb*cbth
      AAABC(589) = EE/MW*Mb/SW*Sqrt2*Zn32/cb*cbth*sb**2
      AAABC(590) = EE/MW/SW*Sqrt2*Zn32/cb*cbth
      AAABC(591) = EE*Sqrt2*(dconjg(Zn14)/CW*ssth-3D0*dconjg(Zn24
     &      )/SW*ssth-3D0*Ms/MW/SW*dconjg(Zn34)/cb*csth)
      AAABC(592) = EE/SW*Sqrt2*dconjg(Zn24)*csth
      AAABC(593) = EE/CW*Sqrt2*dconjg(Zn14)*csth
      AAABC(594) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*csth
      AAABC(595) = EE*Sqrt2*(2D0*Zn14/CW*csth-3D0*Ms/MW/SW
     &      *Zn34/cb*ssth)
      AAABC(596) = EE/CW*Sqrt2*Zn14*ssth
      AAABC(597) = EE/CW**2*SW*Sqrt2*Zn14*ssth
      AAABC(598) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn34)/cb*ssth
      AAABC(599) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn34)/cb*sb**2
     &      *ssth
      AAABC(600) = EE/MW/SW*Sqrt2*dconjg(Zn34)/cb*ssth
      AAABC(601) = EE/MW*Ms/SW*Sqrt2*Zn34/cb*csth
      AAABC(602) = EE/MW*Ms/SW*Sqrt2*Zn34/cb*csth*sb**2
      AAABC(603) = EE/MW/SW*Sqrt2*Zn34/cb*csth
      AAABC(604) = EE*Sqrt2*(dconjg(Zn12)/CW*ssth-3D0*dconjg(Zn22
     &      )/SW*ssth-3D0*Ms/MW/SW*dconjg(Zn32)/cb*csth)
      AAABC(605) = EE/SW*Sqrt2*dconjg(Zn22)*csth
      AAABC(606) = EE/CW*Sqrt2*dconjg(Zn12)*csth
      AAABC(607) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*csth
      AAABC(608) = EE*Sqrt2*(2D0*Zn12/CW*csth-3D0*Ms/MW/SW
     &      *Zn32/cb*ssth)
      AAABC(609) = EE/CW*Sqrt2*Zn12*ssth
      AAABC(610) = EE/CW**2*SW*Sqrt2*Zn12*ssth
      AAABC(611) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn32)/cb*ssth
      AAABC(612) = EE/MW*Ms/SW*Sqrt2*dconjg(Zn32)/cb*sb**2
     &      *ssth
      AAABC(613) = EE/MW/SW*Sqrt2*dconjg(Zn32)/cb*ssth
      AAABC(614) = EE/MW*Ms/SW*Sqrt2*Zn32/cb*csth
      AAABC(615) = EE/MW*Ms/SW*Sqrt2*Zn32/cb*csth*sb**2
      AAABC(616) = EE/MW/SW*Sqrt2*Zn32/cb*csth
      AAABC(617) = EE/SW*Sqrt2*dconjg(Zn22)*ssth
      AAABC(618) = EE/SW*Sqrt2*dconjg(Zn24)*sbth
      AAABC(619) = EE/SW*Sqrt2*dconjg(Zn23)*sdth
      AAABC(620) = EE/SW*Sqrt2*dconjg(Zn24)*ssth
      AAABC(621) = EE/SW*Sqrt2*dconjg(Zn21)*sbth
      AAABC(622) = EE/SW*Sqrt2*dconjg(Zn22)*sbth
      AAABC(623) = EE/SW*Sqrt2*dconjg(Zn21)*sdth
      AAABC(624) = EE/SW*Sqrt2*dconjg(Zn22)*sdth
      AAABC(625) = EE/SW*Sqrt2*dconjg(Zn21)*ssth
      AAABC(626) = EE/SW*Sqrt2*dconjg(Zn23)*ssth
      AAABC(627) = EE/SW*Sqrt2*dconjg(Zn23)*sbth
      AAABC(628) = EE/SW*Sqrt2*dconjg(Zn24)*sdth
      AAABR(1792) = EE/MW*Mb/SW*tb
      AAABR(1793) = EE/MW*Mb/SW*sb**2*tb
      AAABR(1794) = EE/MW*Ms/SW*tb
      AAABR(1795) = EE/MW*Ms/SW*sb**2*tb
      AAABR(1796) = EE/MW*Md/SW*tb
      AAABR(1797) = EE/MW*Md/SW*sb**2*tb
      AAABR(1798) = EE/MW*Ms/SW*sb**2
      AAABR(1799) = EE/MW*Mb/SW*sb**2
      AAABR(1800) = EE/MW*Md/SW*sb**2
      AAABR(1801) = EE/MW*Md/SW*ca/cb
      AAABR(1802) = EE/MW*Md/SW/cb*sa
      AAABR(1803) = EE/MW*Md/SW/cb*sa*sb**2
      AAABR(1804) = EE/MW*Md/SW*ca/cb*sb**2
      AAABR(1805) = EE/MW*Ms/SW*ca/cb
      AAABR(1806) = EE/MW*Ms/SW/cb*sa
      AAABR(1807) = EE/MW*Ms/SW/cb*sa*sb**2
      AAABR(1808) = EE/MW*Mb/SW*ca/cb
      AAABR(1809) = EE/MW*Mb/SW/cb*sa
      AAABR(1810) = EE/MW*Mb/SW/cb*sa*sb**2
      AAABR(1811) = EE/MW*Ms/SW*ca/cb*sb**2
      AAABR(1812) = EE/MW*Mb/SW*ca/cb*sb**2
      AAABR(1813) = EE/MW*Mu/SW*Sqrt2/cb*(1D0/sb-sb)
      AAABR(1814) = EE/MW*Mu/SW*Sqrt2/cb*(1D0/sb-2D0*sb+sb
     &      **3)
      AAABR(1815) = EE/MW/SW*Sqrt2/cb*(1D0/sb-sb)
      AAABR(1816) = EE/MW*Md/SW*Sqrt2/cb*sb
      AAABR(1817) = EE/MW*Md/SW*Sqrt2/cb*sb**3
      AAABR(1818) = EE/MW/SW*Sqrt2/cb*sb
      AAABR(1819) = EE/MW*Mc/SW*Sqrt2/cb*(1D0/sb-sb)
      AAABR(1820) = EE/MW*Mc/SW*Sqrt2/cb*(1D0/sb-2D0*sb+sb
     &      **3)
      AAABR(1821) = EE/MW*Ms/SW*Sqrt2/cb*sb
      AAABR(1822) = EE/MW*Ms/SW*Sqrt2/cb*sb**3
      AAABR(1823) = EE/MW*Mt/SW*Sqrt2/cb*(1D0/sb-sb)
      AAABR(1824) = EE/MW*Mt/SW*Sqrt2/cb*(1D0/sb-2D0*sb+sb
     &      **3)
      AAABR(1825) = EE/MW*Mb/SW*Sqrt2/cb*sb
      AAABR(1826) = EE/MW*Mb/SW*Sqrt2/cb*sb**3
      AAABR(1827) = EE/MW*Mc/SW*Sqrt2
      AAABR(1828) = EE/MW*Mc/SW*Sqrt2*(1D0-sb**2)
      AAABR(1829) = EE/MW*Ms/SW*Sqrt2
      AAABR(1830) = EE/MW*Ms/SW*Sqrt2*sb**2
      AAABR(1831) = EE/MW*Mt/SW*Sqrt2
      AAABR(1832) = EE/MW*Mt/SW*Sqrt2*(1D0-sb**2)
      AAABR(1833) = EE/MW*Mb/SW*Sqrt2
      AAABR(1834) = EE/MW*Mb/SW*Sqrt2*sb**2
      AAABR(1835) = EE/MW*Mu/SW*Sqrt2
      AAABR(1836) = EE/MW*Mu/SW*Sqrt2*(1D0-sb**2)
      AAABR(1837) = EE/MW*Md/SW*Sqrt2
      AAABR(1838) = EE/MW*Md/SW*Sqrt2*sb**2
      AAABR(1839) = EE/SW*(2D0*Zp11*ccth-Mc/MW*Sqrt2*Zp21
     &      /sb*scth)
      AAABR(1840) = EE/SW*(2D0*Zp12*ccth-Mc/MW*Sqrt2*Zp22
     &      /sb*scth)
      AAABR(1841) = EE/SW*(2D0*Zp11*scth+Mc/MW*Sqrt2*Zp21
     &      *ccth/sb)
      AAABR(1842) = EE/SW*Zp11*ccth
      AAABR(1843) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*ccth
      AAABR(1844) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*scth
      AAABR(1845) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*ccth
      AAABR(1846) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*ccth*sb**2
      AAABR(1847) = EE/MW/SW*Sqrt2*Zm21/cb*ccth
      AAABR(1848) = EE/MW*Mc/SW*Sqrt2*Zp21/sb*scth
      AAABR(1849) = EE/MW*Mc/SW*Sqrt2*Zp21*scth*(1D0/sb-sb)
      AAABR(1850) = EE/MW/SW*Sqrt2*Zp21/sb*scth
      AAABR(1851) = EE/SW*(2D0*Zp11*ctth-Mt/MW*Sqrt2*Zp21
     &      /sb*stth)
      AAABR(1852) = EE/SW*(2D0*Zp12*ctth-Mt/MW*Sqrt2*Zp22
     &      /sb*stth)
      AAABR(1853) = EE/SW*(2D0*Zp11*stth+Mt/MW*Sqrt2*Zp21
     &      *ctth/sb)
      AAABR(1854) = EE/SW*Zp11*ctth
      AAABR(1855) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*ctth
      AAABR(1856) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*stth
      AAABR(1857) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*ctth
      AAABR(1858) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*ctth*sb**2
      AAABR(1859) = EE/MW/SW*Sqrt2*Zm21/cb*ctth
      AAABR(1860) = EE/MW*Mt/SW*Sqrt2*Zp21/sb*stth
      AAABR(1861) = EE/MW*Mt/SW*Sqrt2*Zp21*stth*(1D0/sb-sb)
      AAABR(1862) = EE/MW/SW*Sqrt2*Zp21/sb*stth
      AAABR(1863) = EE/SW*(2D0*Zp11*cuth-Mu/MW*Sqrt2*Zp21
     &      /sb*suth)
      AAABR(1864) = EE/SW*(2D0*Zp12*cuth-Mu/MW*Sqrt2*Zp22
     &      /sb*suth)
      AAABR(1865) = EE/SW*(2D0*Zp11*suth+Mu/MW*Sqrt2*Zp21
     &      *cuth/sb)
      AAABR(1866) = EE/SW*Zp11*cuth
      AAABR(1867) = EE/MW*Md/SW*Sqrt2*Zm21/cb*cuth
      AAABR(1868) = EE/MW*Md/SW*Sqrt2*Zm21/cb*suth
      AAABR(1869) = EE/MW*Md/SW*Sqrt2*Zm22/cb*cuth
      AAABR(1870) = EE/MW*Md/SW*Sqrt2*Zm21/cb*cuth*sb**2
      AAABR(1871) = EE/MW/SW*Sqrt2*Zm21/cb*cuth
      AAABR(1872) = EE/MW*Mu/SW*Sqrt2*Zp21/sb*suth
      AAABR(1873) = EE/MW*Mu/SW*Sqrt2*Zp21*suth*(1D0/sb-sb)
      AAABR(1874) = EE/MW/SW*Sqrt2*Zp21/sb*suth
      AAABR(1875) = EE/SW*(2D0*Zp12*stth+Mt/MW*Sqrt2*Zp22
     &      *ctth/sb)
      AAABR(1876) = EE/SW*Zp11*stth
      AAABR(1877) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*stth
      AAABR(1878) = EE/MW*Mb/SW*Sqrt2*Zm21/cb*sb**2*stth
      AAABR(1879) = EE/MW/SW*Sqrt2*Zm21/cb*stth
      AAABR(1880) = EE/MW*Mt/SW*Sqrt2*Zp21*ctth/sb
      AAABR(1881) = EE/MW*Mt/SW*Sqrt2*Zp21*ctth*(1D0/sb-sb)
      AAABR(1882) = EE/MW/SW*Sqrt2*Zp21*ctth/sb
      AAABR(1883) = EE/SW*(2D0*Zp12*scth+Mc/MW*Sqrt2*Zp22
     &      *ccth/sb)
      AAABR(1884) = EE/SW*Zp11*scth
      AAABR(1885) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*scth
      AAABR(1886) = EE/MW*Ms/SW*Sqrt2*Zm21/cb*sb**2*scth
      AAABR(1887) = EE/MW/SW*Sqrt2*Zm21/cb*scth
      AAABR(1888) = EE/MW*Mc/SW*Sqrt2*Zp21*ccth/sb
      AAABR(1889) = EE/MW*Mc/SW*Sqrt2*Zp21*ccth*(1D0/sb-sb)
      AAABR(1890) = EE/MW/SW*Sqrt2*Zp21*ccth/sb
      AAABR(1891) = EE/SW*(2D0*Zp12*suth+Mu/MW*Sqrt2*Zp22
     &      *cuth/sb)
      AAABR(1892) = EE/SW*Zp11*suth
      AAABR(1893) = EE/MW*Md/SW*Sqrt2*Zm22/cb*suth
      AAABR(1894) = EE/MW*Md/SW*Sqrt2*Zm21/cb*sb**2*suth
      AAABR(1895) = EE/MW/SW*Sqrt2*Zm21/cb*suth
      AAABR(1896) = EE/MW*Mu/SW*Sqrt2*Zp21*cuth/sb
      AAABR(1897) = EE/MW*Mu/SW*Sqrt2*Zp21*cuth*(1D0/sb-sb)
      AAABR(1898) = EE/MW/SW*Sqrt2*Zp21*cuth/sb
      AAABR(1899) = EE/SW*Zp12*ctth
      AAABR(1900) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*ctth*sb**2
      AAABR(1901) = EE/MW/SW*Sqrt2*Zm22/cb*ctth
      AAABR(1902) = EE/MW*Mt/SW*Sqrt2*Zp22/sb*stth
      AAABR(1903) = EE/MW*Mt/SW*Sqrt2*Zp22*stth*(1D0/sb-sb)
      AAABR(1904) = EE/MW/SW*Sqrt2*Zp22/sb*stth
      AAABR(1905) = EE/SW*Zp12*cuth
      AAABR(1906) = EE/MW*Md/SW*Sqrt2*Zm22/cb*cuth*sb**2
      AAABR(1907) = EE/MW/SW*Sqrt2*Zm22/cb*cuth
      AAABR(1908) = EE/MW*Mu/SW*Sqrt2*Zp22/sb*suth
      AAABR(1909) = EE/MW*Mu/SW*Sqrt2*Zp22*suth*(1D0/sb-sb)
      AAABR(1910) = EE/MW/SW*Sqrt2*Zp22/sb*suth
      AAABR(1911) = EE/SW*Zp12*ccth
      AAABR(1912) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*ccth*sb**2
      AAABR(1913) = EE/MW/SW*Sqrt2*Zm22/cb*ccth
      AAABR(1914) = EE/MW*Mc/SW*Sqrt2*Zp22/sb*scth
      AAABR(1915) = EE/MW*Mc/SW*Sqrt2*Zp22*scth*(1D0/sb-sb)
      AAABR(1916) = EE/MW/SW*Sqrt2*Zp22/sb*scth
      AAABR(1917) = EE/SW*Zp12*stth
      AAABR(1918) = EE/MW*Mb/SW*Sqrt2*Zm22/cb*sb**2*stth
      AAABR(1919) = EE/MW/SW*Sqrt2*Zm22/cb*stth
      AAABR(1920) = EE/MW*Mt/SW*Sqrt2*Zp22*ctth/sb
      AAABR(1921) = EE/MW*Mt/SW*Sqrt2*Zp22*ctth*(1D0/sb-sb)
      AAABR(1922) = EE/MW/SW*Sqrt2*Zp22*ctth/sb
      AAABR(1923) = EE/SW*Zp12*scth
      AAABR(1924) = EE/MW*Ms/SW*Sqrt2*Zm22/cb*sb**2*scth
      AAABR(1925) = EE/MW/SW*Sqrt2*Zm22/cb*scth
      AAABR(1926) = EE/MW*Mc/SW*Sqrt2*Zp22*ccth/sb
      AAABR(1927) = EE/MW*Mc/SW*Sqrt2*Zp22*ccth*(1D0/sb-sb)
      AAABR(1928) = EE/MW/SW*Sqrt2*Zp22*ccth/sb
      AAABR(1929) = EE/SW*Zp12*suth
      AAABR(1930) = EE/MW*Md/SW*Sqrt2*Zm22/cb*sb**2*suth
      AAABR(1931) = EE/MW/SW*Sqrt2*Zm22/cb*suth
      AAABR(1932) = EE/MW*Mu/SW*Sqrt2*Zp22*cuth/sb
      AAABR(1933) = EE/MW*Mu/SW*Sqrt2*Zp22*cuth*(1D0/sb-sb)
      AAABR(1934) = EE/MW/SW*Sqrt2*Zp22*cuth/sb
      AAABR(1935) = GG*Sqrt2*csth
      AAABR(1936) = GG*Sqrt2*ssth
      AAABR(1937) = GG*Sqrt2*cbth
      AAABR(1938) = GG*Sqrt2*sbth
      AAABR(1939) = GG*Sqrt2*cdth
      AAABR(1940) = GG*Sqrt2*sdth
      AAABC(629) = EE*Sqrt2*(dconjg(Zn11)/CW*ctth+3D0*dconjg(Zn21
     &      )/SW*ctth+3D0*Mt/MW/SW*dconjg(Zn41)/sb*stth)
      AAABC(630) = EE*Sqrt2*(dconjg(Zn12)/CW*ctth+3D0*dconjg(Zn22
     &      )/SW*ctth+3D0*Mt/MW/SW*dconjg(Zn42)/sb*stth)
      AAABC(631) = EE*Sqrt2*(dconjg(Zn13)/CW*ctth+3D0*dconjg(Zn23
     &      )/SW*ctth+3D0*Mt/MW/SW*dconjg(Zn43)/sb*stth)
      AAABC(632) = EE*Sqrt2*(dconjg(Zn14)/CW*ctth+3D0*dconjg(Zn24
     &      )/SW*ctth+3D0*Mt/MW/SW*dconjg(Zn44)/sb*stth)
      AAABC(633) = EE*Sqrt2*(dconjg(Zn11)/CW*stth+3D0*dconjg(Zn21
     &      )/SW*stth-3D0*Mt/MW/SW*dconjg(Zn41)*ctth/sb)
      AAABC(634) = EE/SW*Sqrt2*dconjg(Zn21)*ctth
      AAABC(635) = EE/CW*Sqrt2*dconjg(Zn11)*ctth
      AAABC(636) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*ctth
      AAABC(637) = EE*Sqrt2*(4D0*Zn11/CW*stth-3D0*Mt/MW/SW
     &      *Zn41*ctth/sb)
      AAABC(638) = EE*Sqrt2*(4D0*Zn11/CW*ctth+3D0*Mt/MW/SW
     &      *Zn41/sb*stth)
      AAABC(639) = EE*Sqrt2*(4D0*Zn12/CW*stth-3D0*Mt/MW/SW
     &      *Zn42*ctth/sb)
      AAABC(640) = EE*Sqrt2*(4D0*Zn13/CW*stth-3D0*Mt/MW/SW
     &      *Zn43*ctth/sb)
      AAABC(641) = EE*Sqrt2*(4D0*Zn14/CW*stth-3D0*Mt/MW/SW
     &      *Zn44*ctth/sb)
      AAABC(642) = EE/CW*Sqrt2*Zn11*stth
      AAABC(643) = EE/CW**2*SW*Sqrt2*Zn11*stth
      AAABC(644) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn41)/sb*stth
      AAABC(645) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn41)*stth*(1D0
     &      /sb-sb)
      AAABC(646) = EE/MW/SW*Sqrt2*dconjg(Zn41)/sb*stth
      AAABC(647) = EE/MW*Mt/SW*Sqrt2*Zn41*ctth/sb
      AAABC(648) = EE/MW*Mt/SW*Sqrt2*Zn41*ctth*(1D0/sb-sb)
      AAABC(649) = EE/MW/SW*Sqrt2*Zn41*ctth/sb
      AAABC(650) = EE*Sqrt2*(dconjg(Zn11)/CW*ccth+3D0*dconjg(Zn21
     &      )/SW*ccth+3D0*Mc/MW/SW*dconjg(Zn41)/sb*scth)
      AAABC(651) = EE*Sqrt2*(dconjg(Zn12)/CW*ccth+3D0*dconjg(Zn22
     &      )/SW*ccth+3D0*Mc/MW/SW*dconjg(Zn42)/sb*scth)
      AAABC(652) = EE*Sqrt2*(dconjg(Zn13)/CW*ccth+3D0*dconjg(Zn23
     &      )/SW*ccth+3D0*Mc/MW/SW*dconjg(Zn43)/sb*scth)
      AAABC(653) = EE*Sqrt2*(dconjg(Zn14)/CW*ccth+3D0*dconjg(Zn24
     &      )/SW*ccth+3D0*Mc/MW/SW*dconjg(Zn44)/sb*scth)
      AAABC(654) = EE*Sqrt2*(dconjg(Zn11)/CW*scth+3D0*dconjg(Zn21
     &      )/SW*scth-3D0*Mc/MW/SW*dconjg(Zn41)*ccth/sb)
      AAABC(655) = EE/SW*Sqrt2*dconjg(Zn21)*ccth
      AAABC(656) = EE/CW*Sqrt2*dconjg(Zn11)*ccth
      AAABC(657) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*ccth
      AAABC(658) = EE*Sqrt2*(4D0*Zn11/CW*scth-3D0*Mc/MW/SW
     &      *Zn41*ccth/sb)
      AAABC(659) = EE*Sqrt2*(4D0*Zn11/CW*ccth+3D0*Mc/MW/SW
     &      *Zn41/sb*scth)
      AAABC(660) = EE*Sqrt2*(4D0*Zn12/CW*scth-3D0*Mc/MW/SW
     &      *Zn42*ccth/sb)
      AAABC(661) = EE*Sqrt2*(4D0*Zn13/CW*scth-3D0*Mc/MW/SW
     &      *Zn43*ccth/sb)
      AAABC(662) = EE*Sqrt2*(4D0*Zn14/CW*scth-3D0*Mc/MW/SW
     &      *Zn44*ccth/sb)
      AAABC(663) = EE/CW*Sqrt2*Zn11*scth
      AAABC(664) = EE/CW**2*SW*Sqrt2*Zn11*scth
      AAABC(665) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn41)/sb*scth
      AAABC(666) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn41)*scth*(1D0
     &      /sb-sb)
      AAABC(667) = EE/MW/SW*Sqrt2*dconjg(Zn41)/sb*scth
      AAABC(668) = EE/MW*Mc/SW*Sqrt2*Zn41*ccth/sb
      AAABC(669) = EE/MW*Mc/SW*Sqrt2*Zn41*ccth*(1D0/sb-sb)
      AAABC(670) = EE/MW/SW*Sqrt2*Zn41*ccth/sb
      AAABC(671) = EE*Sqrt2*(dconjg(Zn12)/CW*stth+3D0*dconjg(Zn22
     &      )/SW*stth-3D0*Mt/MW/SW*dconjg(Zn42)*ctth/sb)
      AAABC(672) = EE/SW*Sqrt2*dconjg(Zn22)*ctth
      AAABC(673) = EE/CW*Sqrt2*dconjg(Zn12)*ctth
      AAABC(674) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*ctth
      AAABC(675) = EE*Sqrt2*(4D0*Zn12/CW*ctth+3D0*Mt/MW/SW
     &      *Zn42/sb*stth)
      AAABC(676) = EE/CW*Sqrt2*Zn12*stth
      AAABC(677) = EE/CW**2*SW*Sqrt2*Zn12*stth
      AAABC(678) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn42)/sb*stth
      AAABC(679) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn42)*stth*(1D0
     &      /sb-sb)
      AAABC(680) = EE/MW/SW*Sqrt2*dconjg(Zn42)/sb*stth
      AAABC(681) = EE/MW*Mt/SW*Sqrt2*Zn42*ctth/sb
      AAABC(682) = EE/MW*Mt/SW*Sqrt2*Zn42*ctth*(1D0/sb-sb)
      AAABC(683) = EE/MW/SW*Sqrt2*Zn42*ctth/sb
      AAABC(684) = EE*Sqrt2*(dconjg(Zn11)/CW*cuth+3D0*dconjg(Zn21
     &      )/SW*cuth+3D0*Mu/MW/SW*dconjg(Zn41)/sb*suth)
      AAABC(685) = EE*Sqrt2*(dconjg(Zn12)/CW*cuth+3D0*dconjg(Zn22
     &      )/SW*cuth+3D0*Mu/MW/SW*dconjg(Zn42)/sb*suth)
      AAABC(686) = EE*Sqrt2*(dconjg(Zn13)/CW*cuth+3D0*dconjg(Zn23
     &      )/SW*cuth+3D0*Mu/MW/SW*dconjg(Zn43)/sb*suth)
      AAABC(687) = EE*Sqrt2*(dconjg(Zn14)/CW*cuth+3D0*dconjg(Zn24
     &      )/SW*cuth+3D0*Mu/MW/SW*dconjg(Zn44)/sb*suth)
      AAABC(688) = EE*Sqrt2*(dconjg(Zn14)/CW*suth+3D0*dconjg(Zn24
     &      )/SW*suth-3D0*Mu/MW/SW*dconjg(Zn44)*cuth/sb)
      AAABC(689) = EE/SW*Sqrt2*dconjg(Zn24)*cuth
      AAABC(690) = EE/CW*Sqrt2*dconjg(Zn14)*cuth
      AAABC(691) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*cuth
      AAABC(692) = EE*Sqrt2*(4D0*Zn11/CW*suth-3D0*Mu/MW/SW
     &      *Zn41*cuth/sb)
      AAABC(693) = EE*Sqrt2*(4D0*Zn12/CW*suth-3D0*Mu/MW/SW
     &      *Zn42*cuth/sb)
      AAABC(694) = EE*Sqrt2*(4D0*Zn13/CW*suth-3D0*Mu/MW/SW
     &      *Zn43*cuth/sb)
      AAABC(695) = EE*Sqrt2*(4D0*Zn14/CW*suth-3D0*Mu/MW/SW
     &      *Zn44*cuth/sb)
      AAABC(696) = EE*Sqrt2*(4D0*Zn14/CW*cuth+3D0*Mu/MW/SW
     &      *Zn44/sb*suth)
      AAABC(697) = EE/CW*Sqrt2*Zn14*suth
      AAABC(698) = EE/CW**2*SW*Sqrt2*Zn14*suth
      AAABC(699) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn44)/sb*suth
      AAABC(700) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn44)*suth*(1D0
     &      /sb-sb)
      AAABC(701) = EE/MW/SW*Sqrt2*dconjg(Zn44)/sb*suth
      AAABC(702) = EE/MW*Mu/SW*Sqrt2*Zn44*cuth/sb
      AAABC(703) = EE/MW*Mu/SW*Sqrt2*Zn44*cuth*(1D0/sb-sb)
      AAABC(704) = EE/MW/SW*Sqrt2*Zn44*cuth/sb
      AAABC(705) = EE*Sqrt2*(dconjg(Zn13)/CW*suth+3D0*dconjg(Zn23
     &      )/SW*suth-3D0*Mu/MW/SW*dconjg(Zn43)*cuth/sb)
      AAABC(706) = EE/SW*Sqrt2*dconjg(Zn23)*cuth
      AAABC(707) = EE/CW*Sqrt2*dconjg(Zn13)*cuth
      AAABC(708) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*cuth
      AAABC(709) = EE*Sqrt2*(4D0*Zn13/CW*cuth+3D0*Mu/MW/SW
     &      *Zn43/sb*suth)
      AAABC(710) = EE/CW*Sqrt2*Zn13*suth
      AAABC(711) = EE/CW**2*SW*Sqrt2*Zn13*suth
      AAABC(712) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn43)/sb*suth
      AAABC(713) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn43)*suth*(1D0
     &      /sb-sb)
      AAABC(714) = EE/MW/SW*Sqrt2*dconjg(Zn43)/sb*suth
      AAABC(715) = EE/MW*Mu/SW*Sqrt2*Zn43*cuth/sb
      AAABC(716) = EE/MW*Mu/SW*Sqrt2*Zn43*cuth*(1D0/sb-sb)
      AAABC(717) = EE/MW/SW*Sqrt2*Zn43*cuth/sb
      AAABC(718) = EE*Sqrt2*(dconjg(Zn11)/CW*suth+3D0*dconjg(Zn21
     &      )/SW*suth-3D0*Mu/MW/SW*dconjg(Zn41)*cuth/sb)
      AAABC(719) = EE/SW*Sqrt2*dconjg(Zn21)*cuth
      AAABC(720) = EE/CW*Sqrt2*dconjg(Zn11)*cuth
      AAABC(721) = EE/CW**2*SW*Sqrt2*dconjg(Zn11)*cuth
      AAABC(722) = EE*Sqrt2*(4D0*Zn11/CW*cuth+3D0*Mu/MW/SW
     &      *Zn41/sb*suth)
      AAABC(723) = EE/CW*Sqrt2*Zn11*suth
      AAABC(724) = EE/CW**2*SW*Sqrt2*Zn11*suth
      AAABC(725) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn41)/sb*suth
      AAABC(726) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn41)*suth*(1D0
     &      /sb-sb)
      AAABC(727) = EE/MW/SW*Sqrt2*dconjg(Zn41)/sb*suth
      AAABC(728) = EE/MW*Mu/SW*Sqrt2*Zn41*cuth/sb
      AAABC(729) = EE/MW*Mu/SW*Sqrt2*Zn41*cuth*(1D0/sb-sb)
      AAABC(730) = EE/MW/SW*Sqrt2*Zn41*cuth/sb
      AAABC(731) = EE*Sqrt2*(dconjg(Zn14)/CW*scth+3D0*dconjg(Zn24
     &      )/SW*scth-3D0*Mc/MW/SW*dconjg(Zn44)*ccth/sb)
      AAABC(732) = EE/SW*Sqrt2*dconjg(Zn24)*ccth
      AAABC(733) = EE/CW*Sqrt2*dconjg(Zn14)*ccth
      AAABC(734) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*ccth
      AAABC(735) = EE*Sqrt2*(4D0*Zn14/CW*ccth+3D0*Mc/MW/SW
     &      *Zn44/sb*scth)
      AAABC(736) = EE/CW*Sqrt2*Zn14*scth
      AAABC(737) = EE/CW**2*SW*Sqrt2*Zn14*scth
      AAABC(738) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn44)/sb*scth
      AAABC(739) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn44)*scth*(1D0
     &      /sb-sb)
      AAABC(740) = EE/MW/SW*Sqrt2*dconjg(Zn44)/sb*scth
      AAABC(741) = EE/MW*Mc/SW*Sqrt2*Zn44*ccth/sb
      AAABC(742) = EE/MW*Mc/SW*Sqrt2*Zn44*ccth*(1D0/sb-sb)
      AAABC(743) = EE/MW/SW*Sqrt2*Zn44*ccth/sb
      AAABC(744) = EE*Sqrt2*(dconjg(Zn12)/CW*suth+3D0*dconjg(Zn22
     &      )/SW*suth-3D0*Mu/MW/SW*dconjg(Zn42)*cuth/sb)
      AAABC(745) = EE/SW*Sqrt2*dconjg(Zn22)*cuth
      AAABC(746) = EE/CW*Sqrt2*dconjg(Zn12)*cuth
      AAABC(747) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*cuth
      AAABC(748) = EE*Sqrt2*(4D0*Zn12/CW*cuth+3D0*Mu/MW/SW
     &      *Zn42/sb*suth)
      AAABC(749) = EE/CW*Sqrt2*Zn12*suth
      AAABC(750) = EE/CW**2*SW*Sqrt2*Zn12*suth
      AAABC(751) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn42)/sb*suth
      AAABC(752) = EE/MW*Mu/SW*Sqrt2*dconjg(Zn42)*suth*(1D0
     &      /sb-sb)
      AAABC(753) = EE/MW/SW*Sqrt2*dconjg(Zn42)/sb*suth
      AAABC(754) = EE/MW*Mu/SW*Sqrt2*Zn42*cuth/sb
      AAABC(755) = EE/MW*Mu/SW*Sqrt2*Zn42*cuth*(1D0/sb-sb)
      AAABC(756) = EE/MW/SW*Sqrt2*Zn42*cuth/sb
      AAABC(757) = EE*Sqrt2*(dconjg(Zn12)/CW*scth+3D0*dconjg(Zn22
     &      )/SW*scth-3D0*Mc/MW/SW*dconjg(Zn42)*ccth/sb)
      AAABC(758) = EE/SW*Sqrt2*dconjg(Zn22)*ccth
      AAABC(759) = EE/CW*Sqrt2*dconjg(Zn12)*ccth
      AAABC(760) = EE/CW**2*SW*Sqrt2*dconjg(Zn12)*ccth
      AAABC(761) = EE*Sqrt2*(4D0*Zn12/CW*ccth+3D0*Mc/MW/SW
     &      *Zn42/sb*scth)
      AAABC(762) = EE/CW*Sqrt2*Zn12*scth
      AAABC(763) = EE/CW**2*SW*Sqrt2*Zn12*scth
      AAABC(764) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn42)/sb*scth
      AAABC(765) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn42)*scth*(1D0
     &      /sb-sb)
      AAABC(766) = EE/MW/SW*Sqrt2*dconjg(Zn42)/sb*scth
      AAABC(767) = EE/MW*Mc/SW*Sqrt2*Zn42*ccth/sb
      AAABC(768) = EE/MW*Mc/SW*Sqrt2*Zn42*ccth*(1D0/sb-sb)
      AAABC(769) = EE/MW/SW*Sqrt2*Zn42*ccth/sb
      AAABC(770) = EE*Sqrt2*(dconjg(Zn13)/CW*stth+3D0*dconjg(Zn23
     &      )/SW*stth-3D0*Mt/MW/SW*dconjg(Zn43)*ctth/sb)
      AAABC(771) = EE/SW*Sqrt2*dconjg(Zn23)*ctth
      AAABC(772) = EE/CW*Sqrt2*dconjg(Zn13)*ctth
      AAABC(773) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*ctth
      AAABC(774) = EE*Sqrt2*(4D0*Zn13/CW*ctth+3D0*Mt/MW/SW
     &      *Zn43/sb*stth)
      AAABC(775) = EE/CW*Sqrt2*Zn13*stth
      AAABC(776) = EE/CW**2*SW*Sqrt2*Zn13*stth
      AAABC(777) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn43)/sb*stth
      AAABC(778) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn43)*stth*(1D0
     &      /sb-sb)
      AAABC(779) = EE/MW/SW*Sqrt2*dconjg(Zn43)/sb*stth
      AAABC(780) = EE/MW*Mt/SW*Sqrt2*Zn43*ctth/sb
      AAABC(781) = EE/MW*Mt/SW*Sqrt2*Zn43*ctth*(1D0/sb-sb)
      AAABC(782) = EE/MW/SW*Sqrt2*Zn43*ctth/sb
      AAABC(783) = EE*Sqrt2*(dconjg(Zn14)/CW*stth+3D0*dconjg(Zn24
     &      )/SW*stth-3D0*Mt/MW/SW*dconjg(Zn44)*ctth/sb)
      AAABC(784) = EE/SW*Sqrt2*dconjg(Zn24)*ctth
      AAABC(785) = EE/CW*Sqrt2*dconjg(Zn14)*ctth
      AAABC(786) = EE/CW**2*SW*Sqrt2*dconjg(Zn14)*ctth
      AAABC(787) = EE*Sqrt2*(4D0*Zn14/CW*ctth+3D0*Mt/MW/SW
     &      *Zn44/sb*stth)
      AAABC(788) = EE/CW*Sqrt2*Zn14*stth
      AAABC(789) = EE/CW**2*SW*Sqrt2*Zn14*stth
      AAABC(790) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn44)/sb*stth
      AAABC(791) = EE/MW*Mt/SW*Sqrt2*dconjg(Zn44)*stth*(1D0
     &      /sb-sb)
      AAABC(792) = EE/MW/SW*Sqrt2*dconjg(Zn44)/sb*stth
      AAABC(793) = EE/MW*Mt/SW*Sqrt2*Zn44*ctth/sb
      AAABC(794) = EE/MW*Mt/SW*Sqrt2*Zn44*ctth*(1D0/sb-sb)
      AAABC(795) = EE/MW/SW*Sqrt2*Zn44*ctth/sb
      AAABC(796) = EE*Sqrt2*(dconjg(Zn13)/CW*scth+3D0*dconjg(Zn23
     &      )/SW*scth-3D0*Mc/MW/SW*dconjg(Zn43)*ccth/sb)
      AAABC(797) = EE/SW*Sqrt2*dconjg(Zn23)*ccth
      AAABC(798) = EE/CW*Sqrt2*dconjg(Zn13)*ccth
      AAABC(799) = EE/CW**2*SW*Sqrt2*dconjg(Zn13)*ccth
      AAABC(800) = EE*Sqrt2*(4D0*Zn13/CW*ccth+3D0*Mc/MW/SW
     &      *Zn43/sb*scth)
      AAABC(801) = EE/CW*Sqrt2*Zn13*scth
      AAABC(802) = EE/CW**2*SW*Sqrt2*Zn13*scth
      AAABC(803) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn43)/sb*scth
      AAABC(804) = EE/MW*Mc/SW*Sqrt2*dconjg(Zn43)*scth*(1D0
     &      /sb-sb)
      AAABC(805) = EE/MW/SW*Sqrt2*dconjg(Zn43)/sb*scth
      AAABC(806) = EE/MW*Mc/SW*Sqrt2*Zn43*ccth/sb
      AAABC(807) = EE/MW*Mc/SW*Sqrt2*Zn43*ccth*(1D0/sb-sb)
      AAABC(808) = EE/MW/SW*Sqrt2*Zn43*ccth/sb
      AAABC(809) = EE/SW*Sqrt2*dconjg(Zn23)*suth
      AAABC(810) = EE/SW*Sqrt2*dconjg(Zn23)*scth
      AAABC(811) = EE/SW*Sqrt2*dconjg(Zn22)*suth
      AAABC(812) = EE/SW*Sqrt2*dconjg(Zn24)*scth
      AAABC(813) = EE/SW*Sqrt2*dconjg(Zn23)*stth
      AAABC(814) = EE/SW*Sqrt2*dconjg(Zn24)*suth
      AAABC(815) = EE/SW*Sqrt2*dconjg(Zn21)*stth
      AAABC(816) = EE/SW*Sqrt2*dconjg(Zn22)*stth
      AAABC(817) = EE/SW*Sqrt2*dconjg(Zn21)*scth
      AAABC(818) = EE/SW*Sqrt2*dconjg(Zn21)*suth
      AAABC(819) = EE/SW*Sqrt2*dconjg(Zn22)*scth
      AAABC(820) = EE/SW*Sqrt2*dconjg(Zn24)*stth
      AAABR(1941) = EE/MW*Mt/SW/tb
      AAABR(1942) = EE/MW*Mt/SW/tb*(1D0-sb**2)
      AAABR(1943) = EE/MW/SW/tb
      AAABR(1944) = EE/MW*Mu/SW/tb
      AAABR(1945) = EE/MW*Mu/SW/tb*(1D0-sb**2)
      AAABR(1946) = EE/MW*Mc/SW/tb
      AAABR(1947) = EE/MW*Mc/SW/tb*(1D0-sb**2)
      AAABR(1948) = EE/MW*Mu/SW*(1D0-sb**2)
      AAABR(1949) = EE/MW*Mt/SW*(1D0-sb**2)
      AAABR(1950) = EE/MW*Mc/SW*(1D0-sb**2)
      AAABR(1951) = EE/MW*Mu/SW*sa/sb
      AAABR(1952) = EE/MW*Mu/SW*ca/sb
      AAABR(1953) = EE/MW*Mu/SW*ca*(1D0/sb-sb)
      AAABR(1954) = EE/MW/SW*ca/sb
      AAABR(1955) = EE/MW*Mc/SW*sa/sb
      AAABR(1956) = EE/MW*Mc/SW*ca/sb
      AAABR(1957) = EE/MW*Mc/SW*sa*(1D0/sb-sb)
      AAABR(1958) = EE/MW/SW*sa/sb
      AAABR(1959) = EE/MW*Mu/SW*sa*(1D0/sb-sb)
      AAABR(1960) = EE/MW*Mt/SW*sa/sb
      AAABR(1961) = EE/MW*Mt/SW*ca/sb
      AAABR(1962) = EE/MW*Mt/SW*sa*(1D0/sb-sb)
      AAABR(1963) = EE/MW*Mt/SW*ca*(1D0/sb-sb)
      AAABR(1964) = EE/MW*Mc/SW*ca*(1D0/sb-sb)
      AAABR(1965) = GG*Sqrt2*ctth
      AAABR(1966) = GG*Sqrt2*stth
      AAABR(1967) = GG*Sqrt2*cuth
      AAABR(1968) = GG*Sqrt2*suth
      AAABR(1969) = GG*Sqrt2*ccth
      AAABR(1970) = GG*Sqrt2*scth
      AAABC(821) = EE*sb*(Zn11/CW*Zn34+Zn14/CW*Zn31-Zn21
     &      /SW*Zn34-Zn24/SW*Zn31)
      AAABC(822) = EE*(Zn11/CW*Zn31*sb-Zn11/CW*Zn41*cb-Zn21
     &      /SW*Zn31*sb+Zn21/SW*Zn41*cb)
      AAABC(823) = EE*(Zn11/CW*Zn32*sb-Zn11/CW*Zn42*cb+Zn12
     &      /CW*Zn31*sb-Zn12/CW*Zn41*cb-Zn21/SW*Zn32*sb+Zn21
     &      /SW*Zn42*cb-Zn22/SW*Zn31*sb+Zn22/SW*Zn41*cb)
      AAABC(824) = EE*(Zn11/CW*Zn33*sb-Zn11/CW*Zn43*cb+Zn13
     &      /CW*Zn31*sb-Zn13/CW*Zn41*cb-Zn21/SW*Zn33*sb+Zn21
     &      /SW*Zn43*cb-Zn23/SW*Zn31*sb+Zn23/SW*Zn41*cb)
      AAABC(825) = EE*(Zn11/CW*Zn34*sb-Zn11/CW*Zn44*cb+Zn14
     &      /CW*Zn31*sb-Zn14/CW*Zn41*cb-Zn21/SW*Zn34*sb+Zn21
     &      /SW*Zn44*cb-Zn24/SW*Zn31*sb+Zn24/SW*Zn41*cb)
      AAABC(826) = EE*(Zn12/CW*Zn34*sb-Zn12/CW*Zn44*cb+Zn14
     &      /CW*Zn32*sb-Zn14/CW*Zn42*cb-Zn22/SW*Zn34*sb+Zn22
     &      /SW*Zn44*cb-Zn24/SW*Zn32*sb+Zn24/SW*Zn42*cb)
      AAABC(827) = EE*(Zn13/CW*Zn34*sb-Zn13/CW*Zn44*cb+Zn14
     &      /CW*Zn33*sb-Zn14/CW*Zn43*cb-Zn23/SW*Zn34*sb+Zn23
     &      /SW*Zn44*cb-Zn24/SW*Zn33*sb+Zn24/SW*Zn43*cb)
      AAABC(828) = EE*(Zn14/CW*Zn34*sb-Zn14/CW*Zn44*cb-Zn24
     &      /SW*Zn34*sb+Zn24/SW*Zn44*cb)
      AAABC(829) = EE/SW*(Zn21*Zn34*sb-Zn21*Zn44*cb+Zn24
     &      *Zn31*sb-Zn24*Zn41*cb)
      AAABC(830) = EE/CW*(Zn11*Zn34*sb-Zn11*Zn44*cb+Zn14
     &      *Zn31*sb-Zn14*Zn41*cb)
      AAABC(831) = EE/CW**2*SW*(Zn11*Zn34*sb-Zn11*Zn44*cb
     &      +Zn14*Zn31*sb-Zn14*Zn41*cb)
      AAABC(832) = EE*cb*(Zn11/CW*Zn44+Zn14/CW*Zn41-Zn21
     &      /SW*Zn44-Zn24/SW*Zn41)
      AAABC(833) = EE*sb*(Zn11/CW*Zn33+Zn13/CW*Zn31-Zn21
     &      /SW*Zn33-Zn23/SW*Zn31)
      AAABC(834) = EE*(Zn12/CW*Zn33*sb-Zn12/CW*Zn43*cb+Zn13
     &      /CW*Zn32*sb-Zn13/CW*Zn42*cb-Zn22/SW*Zn33*sb+Zn22
     &      /SW*Zn43*cb-Zn23/SW*Zn32*sb+Zn23/SW*Zn42*cb)
      AAABC(835) = EE*(Zn13/CW*Zn33*sb-Zn13/CW*Zn43*cb-Zn23
     &      /SW*Zn33*sb+Zn23/SW*Zn43*cb)
      AAABC(836) = EE/SW*(Zn21*Zn33*sb-Zn21*Zn43*cb+Zn23
     &      *Zn31*sb-Zn23*Zn41*cb)
      AAABC(837) = EE/CW*(Zn11*Zn33*sb-Zn11*Zn43*cb+Zn13
     &      *Zn31*sb-Zn13*Zn41*cb)
      AAABC(838) = EE/CW**2*SW*(Zn11*Zn33*sb-Zn11*Zn43*cb
     &      +Zn13*Zn31*sb-Zn13*Zn41*cb)
      AAABC(839) = EE*cb*(Zn11/CW*Zn43+Zn13/CW*Zn41-Zn21
     &      /SW*Zn43-Zn23/SW*Zn41)
      AAABC(840) = EE*sb*(Zn11/CW*Zn32+Zn12/CW*Zn31-Zn21
     &      /SW*Zn32-Zn22/SW*Zn31)
      AAABC(841) = EE*(Zn12/CW*Zn32*sb-Zn12/CW*Zn42*cb-Zn22
     &      /SW*Zn32*sb+Zn22/SW*Zn42*cb)
      AAABC(842) = EE/SW*(Zn21*Zn32*sb-Zn21*Zn42*cb+Zn22
     &      *Zn31*sb-Zn22*Zn41*cb)
      AAABC(843) = EE/CW*(Zn11*Zn32*sb-Zn11*Zn42*cb+Zn12
     &      *Zn31*sb-Zn12*Zn41*cb)
      AAABC(844) = EE/CW**2*SW*(Zn11*Zn32*sb-Zn11*Zn42*cb
     &      +Zn12*Zn31*sb-Zn12*Zn41*cb)
      AAABC(845) = EE*cb*(Zn11/CW*Zn42+Zn12/CW*Zn41-Zn21
     &      /SW*Zn42-Zn22/SW*Zn41)
      AAABC(846) = EE*Zn31*sb*(Zn11/CW-Zn21/SW)
      AAABC(847) = EE/SW*Zn21*(Zn31*sb-Zn41*cb)
      AAABC(848) = EE/CW*Zn11*(Zn31*sb-Zn41*cb)
      AAABC(849) = EE/CW**2*SW*Zn11*(Zn31*sb-Zn41*cb)
      AAABC(850) = EE*Zn41*cb*(Zn11/CW-Zn21/SW)
      AAABC(851) = EE*(Zn11/CW*Zn31*cb+Zn11/CW*Zn41*sb-Zn21
     &      /SW*Zn31*cb-Zn21/SW*Zn41*sb)
      AAABC(852) = EE*(Zn11/CW*Zn32*cb+Zn11/CW*Zn42*sb+Zn12
     &      /CW*Zn31*cb+Zn12/CW*Zn41*sb-Zn21/SW*Zn32*cb-Zn21
     &      /SW*Zn42*sb-Zn22/SW*Zn31*cb-Zn22/SW*Zn41*sb)
      AAABC(853) = EE*(Zn11/CW*Zn33*cb+Zn11/CW*Zn43*sb+Zn13
     &      /CW*Zn31*cb+Zn13/CW*Zn41*sb-Zn21/SW*Zn33*cb-Zn21
     &      /SW*Zn43*sb-Zn23/SW*Zn31*cb-Zn23/SW*Zn41*sb)
      AAABC(854) = EE*(Zn11/CW*Zn34*cb+Zn11/CW*Zn44*sb+Zn14
     &      /CW*Zn31*cb+Zn14/CW*Zn41*sb-Zn21/SW*Zn34*cb-Zn21
     &      /SW*Zn44*sb-Zn24/SW*Zn31*cb-Zn24/SW*Zn41*sb)
      AAABC(855) = EE*Zn31*cb*(Zn11/CW-Zn21/SW)
      AAABC(856) = EE/SW*Zn21*(Zn31*cb+Zn41*sb)
      AAABC(857) = EE/CW*Zn11*(Zn31*cb+Zn41*sb)
      AAABC(858) = EE/CW**2*SW*Zn11*(Zn31*cb+Zn41*sb)
      AAABC(859) = EE*Zn41*sb*(Zn11/CW-Zn21/SW)
      AAABC(860) = EE*cb*(Zn11/CW*Zn34+Zn14/CW*Zn31-Zn21
     &      /SW*Zn34-Zn24/SW*Zn31)
      AAABC(861) = EE*(Zn12/CW*Zn34*cb+Zn12/CW*Zn44*sb+Zn14
     &      /CW*Zn32*cb+Zn14/CW*Zn42*sb-Zn22/SW*Zn34*cb-Zn22
     &      /SW*Zn44*sb-Zn24/SW*Zn32*cb-Zn24/SW*Zn42*sb)
      AAABC(862) = EE*(Zn13/CW*Zn34*cb+Zn13/CW*Zn44*sb+Zn14
     &      /CW*Zn33*cb+Zn14/CW*Zn43*sb-Zn23/SW*Zn34*cb-Zn23
     &      /SW*Zn44*sb-Zn24/SW*Zn33*cb-Zn24/SW*Zn43*sb)
      AAABC(863) = EE*(Zn14/CW*Zn34*cb+Zn14/CW*Zn44*sb-Zn24
     &      /SW*Zn34*cb-Zn24/SW*Zn44*sb)
      AAABC(864) = EE/SW*(Zn21*Zn34*cb+Zn21*Zn44*sb+Zn24
     &      *Zn31*cb+Zn24*Zn41*sb)
      AAABC(865) = EE/CW*(Zn11*Zn34*cb+Zn11*Zn44*sb+Zn14
     &      *Zn31*cb+Zn14*Zn41*sb)
      AAABC(866) = EE/CW**2*SW*(Zn11*Zn34*cb+Zn11*Zn44*sb
     &      +Zn14*Zn31*cb+Zn14*Zn41*sb)
      AAABC(867) = EE*sb*(Zn11/CW*Zn44+Zn14/CW*Zn41-Zn21
     &      /SW*Zn44-Zn24/SW*Zn41)
      AAABC(868) = EE*cb*(Zn11/CW*Zn32+Zn12/CW*Zn31-Zn21
     &      /SW*Zn32-Zn22/SW*Zn31)
      AAABC(869) = EE*(Zn12/CW*Zn32*cb+Zn12/CW*Zn42*sb-Zn22
     &      /SW*Zn32*cb-Zn22/SW*Zn42*sb)
      AAABC(870) = EE*(Zn12/CW*Zn33*cb+Zn12/CW*Zn43*sb+Zn13
     &      /CW*Zn32*cb+Zn13/CW*Zn42*sb-Zn22/SW*Zn33*cb-Zn22
     &      /SW*Zn43*sb-Zn23/SW*Zn32*cb-Zn23/SW*Zn42*sb)
      AAABC(871) = EE/SW*(Zn21*Zn32*cb+Zn21*Zn42*sb+Zn22
     &      *Zn31*cb+Zn22*Zn41*sb)
      AAABC(872) = EE/CW*(Zn11*Zn32*cb+Zn11*Zn42*sb+Zn12
     &      *Zn31*cb+Zn12*Zn41*sb)
      AAABC(873) = EE/CW**2*SW*(Zn11*Zn32*cb+Zn11*Zn42*sb
     &      +Zn12*Zn31*cb+Zn12*Zn41*sb)
      AAABC(874) = EE*sb*(Zn11/CW*Zn42+Zn12/CW*Zn41-Zn21
     &      /SW*Zn42-Zn22/SW*Zn41)
      AAABC(875) = EE*cb*(Zn11/CW*Zn33+Zn13/CW*Zn31-Zn21
     &      /SW*Zn33-Zn23/SW*Zn31)
      AAABC(876) = EE*(Zn13/CW*Zn33*cb+Zn13/CW*Zn43*sb-Zn23
     &      /SW*Zn33*cb-Zn23/SW*Zn43*sb)
      AAABC(877) = EE/SW*(Zn21*Zn33*cb+Zn21*Zn43*sb+Zn23
     &      *Zn31*cb+Zn23*Zn41*sb)
      AAABC(878) = EE/CW*(Zn11*Zn33*cb+Zn11*Zn43*sb+Zn13
     &      *Zn31*cb+Zn13*Zn41*sb)
      AAABC(879) = EE/CW**2*SW*(Zn11*Zn33*cb+Zn11*Zn43*sb
     &      +Zn13*Zn31*cb+Zn13*Zn41*sb)
      AAABC(880) = EE*sb*(Zn11/CW*Zn43+Zn13/CW*Zn41-Zn21
     &      /SW*Zn43-Zn23/SW*Zn41)
      AAABC(881) = EE*(Zn11/CW*Zn31*ca-Zn11/CW*Zn41*sa-Zn21
     &      /SW*Zn31*ca+Zn21/SW*Zn41*sa)
      AAABC(882) = EE*(Zn11/CW*Zn32*ca-Zn11/CW*Zn42*sa+Zn12
     &      /CW*Zn31*ca-Zn12/CW*Zn41*sa-Zn21/SW*Zn32*ca+Zn21
     &      /SW*Zn42*sa-Zn22/SW*Zn31*ca+Zn22/SW*Zn41*sa)
      AAABC(883) = EE*(Zn11/CW*Zn33*ca-Zn11/CW*Zn43*sa+Zn13
     &      /CW*Zn31*ca-Zn13/CW*Zn41*sa-Zn21/SW*Zn33*ca+Zn21
     &      /SW*Zn43*sa-Zn23/SW*Zn31*ca+Zn23/SW*Zn41*sa)
      AAABC(884) = EE*(Zn11/CW*Zn34*ca-Zn11/CW*Zn44*sa+Zn14
     &      /CW*Zn31*ca-Zn14/CW*Zn41*sa-Zn21/SW*Zn34*ca+Zn21
     &      /SW*Zn44*sa-Zn24/SW*Zn31*ca+Zn24/SW*Zn41*sa)
      AAABC(885) = EE*(Zn11/CW*Zn32*sa+Zn11/CW*Zn42*ca+Zn12
     &      /CW*Zn31*sa+Zn12/CW*Zn41*ca-Zn21/SW*Zn32*sa-Zn21
     &      /SW*Zn42*ca-Zn22/SW*Zn31*sa-Zn22/SW*Zn41*ca)
      AAABC(886) = EE*(Zn12/CW*Zn32*ca-Zn12/CW*Zn42*sa-Zn22
     &      /SW*Zn32*ca+Zn22/SW*Zn42*sa)
      AAABC(887) = EE*(Zn12/CW*Zn33*ca-Zn12/CW*Zn43*sa+Zn13
     &      /CW*Zn32*ca-Zn13/CW*Zn42*sa-Zn22/SW*Zn33*ca+Zn22
     &      /SW*Zn43*sa-Zn23/SW*Zn32*ca+Zn23/SW*Zn42*sa)
      AAABC(888) = EE*(Zn12/CW*Zn34*ca-Zn12/CW*Zn44*sa+Zn14
     &      /CW*Zn32*ca-Zn14/CW*Zn42*sa-Zn22/SW*Zn34*ca+Zn22
     &      /SW*Zn44*sa-Zn24/SW*Zn32*ca+Zn24/SW*Zn42*sa)
      AAABC(889) = EE/SW*(Zn21*Zn32*ca-Zn21*Zn42*sa+Zn22
     &      *Zn31*ca-Zn22*Zn41*sa)
      AAABC(890) = EE/CW*(Zn11*Zn32*ca-Zn11*Zn42*sa+Zn12
     &      *Zn31*ca-Zn12*Zn41*sa)
      AAABC(891) = EE/CW**2*SW*(Zn11*Zn32*ca-Zn11*Zn42*sa
     &      +Zn12*Zn31*ca-Zn12*Zn41*sa)
      AAABC(892) = EE*(Zn11/CW*Zn31*sa+Zn11/CW*Zn41*ca-Zn21
     &      /SW*Zn31*sa-Zn21/SW*Zn41*ca)
      AAABC(893) = EE*(Zn11/CW*Zn33*sa+Zn11/CW*Zn43*ca+Zn13
     &      /CW*Zn31*sa+Zn13/CW*Zn41*ca-Zn21/SW*Zn33*sa-Zn21
     &      /SW*Zn43*ca-Zn23/SW*Zn31*sa-Zn23/SW*Zn41*ca)
      AAABC(894) = EE*(Zn11/CW*Zn34*sa+Zn11/CW*Zn44*ca+Zn14
     &      /CW*Zn31*sa+Zn14/CW*Zn41*ca-Zn21/SW*Zn34*sa-Zn21
     &      /SW*Zn44*ca-Zn24/SW*Zn31*sa-Zn24/SW*Zn41*ca)
      AAABC(895) = EE/SW*Zn21*(Zn31*sa+Zn41*ca)
      AAABC(896) = EE/CW*Zn11*(Zn31*sa+Zn41*ca)
      AAABC(897) = EE/CW**2*SW*Zn11*(Zn31*sa+Zn41*ca)
      AAABC(898) = EE*(Zn12/CW*Zn33*sa+Zn12/CW*Zn43*ca+Zn13
     &      /CW*Zn32*sa+Zn13/CW*Zn42*ca-Zn22/SW*Zn33*sa-Zn22
     &      /SW*Zn43*ca-Zn23/SW*Zn32*sa-Zn23/SW*Zn42*ca)
      AAABC(899) = EE*(Zn13/CW*Zn33*sa+Zn13/CW*Zn43*ca-Zn23
     &      /SW*Zn33*sa-Zn23/SW*Zn43*ca)
      AAABC(900) = EE*(Zn13/CW*Zn34*sa+Zn13/CW*Zn44*ca+Zn14
     &      /CW*Zn33*sa+Zn14/CW*Zn43*ca-Zn23/SW*Zn34*sa-Zn23
     &      /SW*Zn44*ca-Zn24/SW*Zn33*sa-Zn24/SW*Zn43*ca)
      AAABC(901) = EE/SW*(Zn21*Zn33*sa+Zn21*Zn43*ca+Zn23
     &      *Zn31*sa+Zn23*Zn41*ca)
      AAABC(902) = EE/CW*(Zn11*Zn33*sa+Zn11*Zn43*ca+Zn13
     &      *Zn31*sa+Zn13*Zn41*ca)
      AAABC(903) = EE/CW**2*SW*(Zn11*Zn33*sa+Zn11*Zn43*ca
     &      +Zn13*Zn31*sa+Zn13*Zn41*ca)
      AAABC(904) = EE*(Zn13/CW*Zn34*ca-Zn13/CW*Zn44*sa+Zn14
     &      /CW*Zn33*ca-Zn14/CW*Zn43*sa-Zn23/SW*Zn34*ca+Zn23
     &      /SW*Zn44*sa-Zn24/SW*Zn33*ca+Zn24/SW*Zn43*sa)
      AAABC(905) = EE*(Zn14/CW*Zn34*ca-Zn14/CW*Zn44*sa-Zn24
     &      /SW*Zn34*ca+Zn24/SW*Zn44*sa)
      AAABC(906) = EE/SW*(Zn21*Zn34*ca-Zn21*Zn44*sa+Zn24
     &      *Zn31*ca-Zn24*Zn41*sa)
      AAABC(907) = EE/CW*(Zn11*Zn34*ca-Zn11*Zn44*sa+Zn14
     &      *Zn31*ca-Zn14*Zn41*sa)
      AAABC(908) = EE/CW**2*SW*(Zn11*Zn34*ca-Zn11*Zn44*sa
     &      +Zn14*Zn31*ca-Zn14*Zn41*sa)
      AAABC(909) = EE*(Zn12/CW*Zn34*sa+Zn12/CW*Zn44*ca+Zn14
     &      /CW*Zn32*sa+Zn14/CW*Zn42*ca-Zn22/SW*Zn34*sa-Zn22
     &      /SW*Zn44*ca-Zn24/SW*Zn32*sa-Zn24/SW*Zn42*ca)
      AAABC(910) = EE*(Zn14/CW*Zn34*sa+Zn14/CW*Zn44*ca-Zn24
     &      /SW*Zn34*sa-Zn24/SW*Zn44*ca)
      AAABC(911) = EE/SW*(Zn21*Zn34*sa+Zn21*Zn44*ca+Zn24
     &      *Zn31*sa+Zn24*Zn41*ca)
      AAABC(912) = EE/CW*(Zn11*Zn34*sa+Zn11*Zn44*ca+Zn14
     &      *Zn31*sa+Zn14*Zn41*ca)
      AAABC(913) = EE/CW**2*SW*(Zn11*Zn34*sa+Zn11*Zn44*ca
     &      +Zn14*Zn31*sa+Zn14*Zn41*ca)
      AAABC(914) = EE*(Zn13/CW*Zn33*ca-Zn13/CW*Zn43*sa-Zn23
     &      /SW*Zn33*ca+Zn23/SW*Zn43*sa)
      AAABC(915) = EE/SW*(Zn21*Zn33*ca-Zn21*Zn43*sa+Zn23
     &      *Zn31*ca-Zn23*Zn41*sa)
      AAABC(916) = EE/CW*(Zn11*Zn33*ca-Zn11*Zn43*sa+Zn13
     &      *Zn31*ca-Zn13*Zn41*sa)
      AAABC(917) = EE/CW**2*SW*(Zn11*Zn33*ca-Zn11*Zn43*sa
     &      +Zn13*Zn31*ca-Zn13*Zn41*sa)
      AAABC(918) = EE/SW*Zn21*(Zn31*ca-Zn41*sa)
      AAABC(919) = EE/CW*Zn11*(Zn31*ca-Zn41*sa)
      AAABC(920) = EE/CW**2*SW*Zn11*(Zn31*ca-Zn41*sa)
      AAABC(921) = EE*(Zn12/CW*Zn32*sa+Zn12/CW*Zn42*ca-Zn22
     &      /SW*Zn32*sa-Zn22/SW*Zn42*ca)
      AAABC(922) = EE/SW*(Zn21*Zn32*sa+Zn21*Zn42*ca+Zn22
     &      *Zn31*sa+Zn22*Zn41*ca)
      AAABC(923) = EE/CW*(Zn11*Zn32*sa+Zn11*Zn42*ca+Zn12
     &      *Zn31*sa+Zn12*Zn41*ca)
      AAABC(924) = EE/CW**2*SW*(Zn11*Zn32*sa+Zn11*Zn42*ca
     &      +Zn12*Zn31*sa+Zn12*Zn41*ca)
      AAABC(925) = EE*sb*(Zn12/CW*Zn33+Zn13/CW*Zn32-Zn22
     &      /SW*Zn33-Zn23/SW*Zn32)
      AAABC(926) = EE/SW*(Zn22*Zn33*sb-Zn22*Zn43*cb+Zn23
     &      *Zn32*sb-Zn23*Zn42*cb)
      AAABC(927) = EE/CW*(Zn12*Zn33*sb-Zn12*Zn43*cb+Zn13
     &      *Zn32*sb-Zn13*Zn42*cb)
      AAABC(928) = EE/CW**2*SW*(Zn12*Zn33*sb-Zn12*Zn43*cb
     &      +Zn13*Zn32*sb-Zn13*Zn42*cb)
      AAABC(929) = EE*cb*(Zn12/CW*Zn43+Zn13/CW*Zn42-Zn22
     &      /SW*Zn43-Zn23/SW*Zn42)
      AAABC(930) = EE*sb*(Zn12/CW*Zn34+Zn14/CW*Zn32-Zn22
     &      /SW*Zn34-Zn24/SW*Zn32)
      AAABC(931) = EE/SW*(Zn22*Zn34*sb-Zn22*Zn44*cb+Zn24
     &      *Zn32*sb-Zn24*Zn42*cb)
      AAABC(932) = EE/CW*(Zn12*Zn34*sb-Zn12*Zn44*cb+Zn14
     &      *Zn32*sb-Zn14*Zn42*cb)
      AAABC(933) = EE/CW**2*SW*(Zn12*Zn34*sb-Zn12*Zn44*cb
     &      +Zn14*Zn32*sb-Zn14*Zn42*cb)
      AAABC(934) = EE*cb*(Zn12/CW*Zn44+Zn14/CW*Zn42-Zn22
     &      /SW*Zn44-Zn24/SW*Zn42)
      AAABC(935) = EE*Zn32*sb*(Zn12/CW-Zn22/SW)
      AAABC(936) = EE/SW*Zn22*(Zn32*sb-Zn42*cb)
      AAABC(937) = EE/CW*Zn12*(Zn32*sb-Zn42*cb)
      AAABC(938) = EE/CW**2*SW*Zn12*(Zn32*sb-Zn42*cb)
      AAABC(939) = EE*Zn42*cb*(Zn12/CW-Zn22/SW)
      AAABC(940) = EE*cb*(Zn12/CW*Zn33+Zn13/CW*Zn32-Zn22
     &      /SW*Zn33-Zn23/SW*Zn32)
      AAABC(941) = EE/SW*(Zn22*Zn33*cb+Zn22*Zn43*sb+Zn23
     &      *Zn32*cb+Zn23*Zn42*sb)
      AAABC(942) = EE/CW*(Zn12*Zn33*cb+Zn12*Zn43*sb+Zn13
     &      *Zn32*cb+Zn13*Zn42*sb)
      AAABC(943) = EE/CW**2*SW*(Zn12*Zn33*cb+Zn12*Zn43*sb
     &      +Zn13*Zn32*cb+Zn13*Zn42*sb)
      AAABC(944) = EE*sb*(Zn12/CW*Zn43+Zn13/CW*Zn42-Zn22
     &      /SW*Zn43-Zn23/SW*Zn42)
      AAABC(945) = EE*cb*(Zn12/CW*Zn34+Zn14/CW*Zn32-Zn22
     &      /SW*Zn34-Zn24/SW*Zn32)
      AAABC(946) = EE/SW*(Zn22*Zn34*cb+Zn22*Zn44*sb+Zn24
     &      *Zn32*cb+Zn24*Zn42*sb)
      AAABC(947) = EE/CW*(Zn12*Zn34*cb+Zn12*Zn44*sb+Zn14
     &      *Zn32*cb+Zn14*Zn42*sb)
      AAABC(948) = EE/CW**2*SW*(Zn12*Zn34*cb+Zn12*Zn44*sb
     &      +Zn14*Zn32*cb+Zn14*Zn42*sb)
      AAABC(949) = EE*sb*(Zn12/CW*Zn44+Zn14/CW*Zn42-Zn22
     &      /SW*Zn44-Zn24/SW*Zn42)
      AAABC(950) = EE*Zn32*cb*(Zn12/CW-Zn22/SW)
      AAABC(951) = EE/SW*Zn22*(Zn32*cb+Zn42*sb)
      AAABC(952) = EE/CW*Zn12*(Zn32*cb+Zn42*sb)
      AAABC(953) = EE/CW**2*SW*Zn12*(Zn32*cb+Zn42*sb)
      AAABC(954) = EE*Zn42*sb*(Zn12/CW-Zn22/SW)
      AAABC(955) = EE/SW*Zn22*(Zn32*ca-Zn42*sa)
      AAABC(956) = EE/CW*Zn12*(Zn32*ca-Zn42*sa)
      AAABC(957) = EE/CW**2*SW*Zn12*(Zn32*ca-Zn42*sa)
      AAABC(958) = EE/SW*(Zn22*Zn33*sa+Zn22*Zn43*ca+Zn23
     &      *Zn32*sa+Zn23*Zn42*ca)
      AAABC(959) = EE/CW*(Zn12*Zn33*sa+Zn12*Zn43*ca+Zn13
     &      *Zn32*sa+Zn13*Zn42*ca)
      AAABC(960) = EE/CW**2*SW*(Zn12*Zn33*sa+Zn12*Zn43*ca
     &      +Zn13*Zn32*sa+Zn13*Zn42*ca)
      AAABC(961) = EE/SW*(Zn22*Zn34*ca-Zn22*Zn44*sa+Zn24
     &      *Zn32*ca-Zn24*Zn42*sa)
      AAABC(962) = EE/CW*(Zn12*Zn34*ca-Zn12*Zn44*sa+Zn14
     &      *Zn32*ca-Zn14*Zn42*sa)
      AAABC(963) = EE/CW**2*SW*(Zn12*Zn34*ca-Zn12*Zn44*sa
     &      +Zn14*Zn32*ca-Zn14*Zn42*sa)
      AAABC(964) = EE/SW*(Zn22*Zn34*sa+Zn22*Zn44*ca+Zn24
     &      *Zn32*sa+Zn24*Zn42*ca)
      AAABC(965) = EE/CW*(Zn12*Zn34*sa+Zn12*Zn44*ca+Zn14
     &      *Zn32*sa+Zn14*Zn42*ca)
      AAABC(966) = EE/CW**2*SW*(Zn12*Zn34*sa+Zn12*Zn44*ca
     &      +Zn14*Zn32*sa+Zn14*Zn42*ca)
      AAABC(967) = EE/SW*(Zn22*Zn33*ca-Zn22*Zn43*sa+Zn23
     &      *Zn32*ca-Zn23*Zn42*sa)
      AAABC(968) = EE/CW*(Zn12*Zn33*ca-Zn12*Zn43*sa+Zn13
     &      *Zn32*ca-Zn13*Zn42*sa)
      AAABC(969) = EE/CW**2*SW*(Zn12*Zn33*ca-Zn12*Zn43*sa
     &      +Zn13*Zn32*ca-Zn13*Zn42*sa)
      AAABC(970) = EE/SW*Zn22*(Zn32*sa+Zn42*ca)
      AAABC(971) = EE/CW*Zn12*(Zn32*sa+Zn42*ca)
      AAABC(972) = EE/CW**2*SW*Zn12*(Zn32*sa+Zn42*ca)
      AAABC(973) = EE*Zn33*sb*(Zn13/CW-Zn23/SW)
      AAABC(974) = EE/SW*Zn23*(Zn33*sb-Zn43*cb)
      AAABC(975) = EE/CW*Zn13*(Zn33*sb-Zn43*cb)
      AAABC(976) = EE/CW**2*SW*Zn13*(Zn33*sb-Zn43*cb)
      AAABC(977) = EE*Zn43*cb*(Zn13/CW-Zn23/SW)
      AAABC(978) = EE*sb*(Zn13/CW*Zn34+Zn14/CW*Zn33-Zn23
     &      /SW*Zn34-Zn24/SW*Zn33)
      AAABC(979) = EE/SW*(Zn23*Zn34*sb-Zn23*Zn44*cb+Zn24
     &      *Zn33*sb-Zn24*Zn43*cb)
      AAABC(980) = EE/CW*(Zn13*Zn34*sb-Zn13*Zn44*cb+Zn14
     &      *Zn33*sb-Zn14*Zn43*cb)
      AAABC(981) = EE/CW**2*SW*(Zn13*Zn34*sb-Zn13*Zn44*cb
     &      +Zn14*Zn33*sb-Zn14*Zn43*cb)
      AAABC(982) = EE*cb*(Zn13/CW*Zn44+Zn14/CW*Zn43-Zn23
     &      /SW*Zn44-Zn24/SW*Zn43)
      AAABC(983) = EE*Zn33*cb*(Zn13/CW-Zn23/SW)
      AAABC(984) = EE/SW*Zn23*(Zn33*cb+Zn43*sb)
      AAABC(985) = EE/CW*Zn13*(Zn33*cb+Zn43*sb)
      AAABC(986) = EE/CW**2*SW*Zn13*(Zn33*cb+Zn43*sb)
      AAABC(987) = EE*Zn43*sb*(Zn13/CW-Zn23/SW)
      AAABC(988) = EE*cb*(Zn13/CW*Zn34+Zn14/CW*Zn33-Zn23
     &      /SW*Zn34-Zn24/SW*Zn33)
      AAABC(989) = EE/SW*(Zn23*Zn34*cb+Zn23*Zn44*sb+Zn24
     &      *Zn33*cb+Zn24*Zn43*sb)
      AAABC(990) = EE/CW*(Zn13*Zn34*cb+Zn13*Zn44*sb+Zn14
     &      *Zn33*cb+Zn14*Zn43*sb)
      AAABC(991) = EE/CW**2*SW*(Zn13*Zn34*cb+Zn13*Zn44*sb
     &      +Zn14*Zn33*cb+Zn14*Zn43*sb)
      AAABC(992) = EE*sb*(Zn13/CW*Zn44+Zn14/CW*Zn43-Zn23
     &      /SW*Zn44-Zn24/SW*Zn43)
      AAABC(993) = EE/SW*(Zn23*Zn34*ca-Zn23*Zn44*sa+Zn24
     &      *Zn33*ca-Zn24*Zn43*sa)
      AAABC(994) = EE/CW*(Zn13*Zn34*ca-Zn13*Zn44*sa+Zn14
     &      *Zn33*ca-Zn14*Zn43*sa)
      AAABC(995) = EE/CW**2*SW*(Zn13*Zn34*ca-Zn13*Zn44*sa
     &      +Zn14*Zn33*ca-Zn14*Zn43*sa)
      AAABC(996) = EE/SW*Zn23*(Zn33*ca-Zn43*sa)
      AAABC(997) = EE/CW*Zn13*(Zn33*ca-Zn43*sa)
      AAABC(998) = EE/CW**2*SW*Zn13*(Zn33*ca-Zn43*sa)
      AAABC(999) = EE/SW*(Zn23*Zn34*sa+Zn23*Zn44*ca+Zn24
     &      *Zn33*sa+Zn24*Zn43*ca)
      AAABC(1000) = EE/CW*(Zn13*Zn34*sa+Zn13*Zn44*ca+Zn14
     &      *Zn33*sa+Zn14*Zn43*ca)
      AAABC(1001) = EE/CW**2*SW*(Zn13*Zn34*sa+Zn13*Zn44*ca
     &      +Zn14*Zn33*sa+Zn14*Zn43*ca)
      AAABC(1002) = EE/SW*Zn23*(Zn33*sa+Zn43*ca)
      AAABC(1003) = EE/CW*Zn13*(Zn33*sa+Zn43*ca)
      AAABC(1004) = EE/CW**2*SW*Zn13*(Zn33*sa+Zn43*ca)
      AAABC(1005) = EE*Zn34*sb*(Zn14/CW-Zn24/SW)
      AAABC(1006) = EE/SW*Zn24*(Zn34*sb-Zn44*cb)
      AAABC(1007) = EE/CW*Zn14*(Zn34*sb-Zn44*cb)
      AAABC(1008) = EE/CW**2*SW*Zn14*(Zn34*sb-Zn44*cb)
      AAABC(1009) = EE*Zn44*cb*(Zn14/CW-Zn24/SW)
      AAABC(1010) = EE*Zn34*cb*(Zn14/CW-Zn24/SW)
      AAABC(1011) = EE/SW*Zn24*(Zn34*cb+Zn44*sb)
      AAABC(1012) = EE/CW*Zn14*(Zn34*cb+Zn44*sb)
      AAABC(1013) = EE/CW**2*SW*Zn14*(Zn34*cb+Zn44*sb)
      AAABC(1014) = EE*Zn44*sb*(Zn14/CW-Zn24/SW)
      AAABC(1015) = EE/SW*Zn24*(Zn34*sa+Zn44*ca)
      AAABC(1016) = EE/CW*Zn14*(Zn34*sa+Zn44*ca)
      AAABC(1017) = EE/CW**2*SW*Zn14*(Zn34*sa+Zn44*ca)
      AAABC(1018) = EE/SW*Zn24*(Zn34*ca-Zn44*sa)
      AAABC(1019) = EE/CW*Zn14*(Zn34*ca-Zn44*sa)
      AAABC(1020) = EE/CW**2*SW*Zn14*(Zn34*ca-Zn44*sa)
      AAABR(1971) = CW*EE/SW*(2D0*Zm11*Zm12+Zm21*Zm22)
      AAABR(1972) = EE*(2D0*Zm11*Zm12+Zm21*Zm22)
      AAABR(1973) = CW*EE/SW*(2D0*Zp11*Zp12+Zp21*Zp22)
      AAABR(1974) = EE*(2D0*Zp11*Zp12+Zp21*Zp22)
      AAABR(1975) = CW*EE/SW*(2D0*Zm11**2+Zm21**2)
      AAABR(1976) = EE*(2D0*Zm11**2+Zm21**2)
      AAABR(1977) = CW*EE/SW*(2D0*Zp11**2+Zp21**2)
      AAABR(1978) = EE*(2D0*Zp11**2+Zp21**2)
      AAABR(1979) = CW*EE/SW*(2D0*Zm12**2+Zm22**2)
      AAABR(1980) = EE*(2D0*Zm12**2+Zm22**2)
      end

      subroutine aaini04
      implicit none
#include "model.h"

      AAABR(1981) = CW*EE/SW*(2D0*Zp12**2+Zp22**2)
      AAABR(1982) = EE*(2D0*Zp12**2+Zp22**2)
      AAABR(1983) = EE*(SW/CW*Zm21**2-2D0*CW/SW*Zm11**2-CW
     &      /SW*Zm21**2)
      AAABR(1984) = EE*(SW/CW*Zm21*Zm22-2D0*CW/SW*Zm11*Zm12
     &      -CW/SW*Zm21*Zm22)
      AAABR(1985) = EE*(SW/CW*Zp21**2-2D0*CW/SW*Zp11**2-CW
     &      /SW*Zp21**2)
      AAABR(1986) = EE*(SW/CW*Zp21*Zp22-2D0*CW/SW*Zp11*Zp12
     &      -CW/SW*Zp21*Zp22)
      AAABR(1987) = EE*Zm21**2*(1D0+SW**2/CW**2)
      AAABR(1988) = EE*Zp21**2*(1D0+SW**2/CW**2)
      AAABR(1989) = EE*(SW/CW*Zm22**2-2D0*CW/SW*Zm12**2-CW
     &      /SW*Zm22**2)
      AAABR(1990) = EE*(SW/CW*Zp22**2-2D0*CW/SW*Zp12**2-CW
     &      /SW*Zp22**2)
      AAABR(1991) = EE*Zm21*Zm22*(1D0+SW**2/CW**2)
      AAABR(1992) = EE*Zp21*Zp22*(1D0+SW**2/CW**2)
      AAABR(1993) = EE*Zm22**2*(1D0+SW**2/CW**2)
      AAABR(1994) = EE*Zp22**2*(1D0+SW**2/CW**2)
      AAABC(1021) = EE/SW*(2D0*Zm12*dconjg(Zn21)+Sqrt2*Zm22
     &      *dconjg(Zn31))
      AAABC(1022) = EE/SW*(2D0*Zm12*dconjg(Zn22)+Sqrt2*Zm22
     &      *dconjg(Zn32))
      AAABC(1023) = EE/SW*(2D0*Zm12*dconjg(Zn23)+Sqrt2*Zm22
     &      *dconjg(Zn33))
      AAABC(1024) = EE/SW*(2D0*Zm11*dconjg(Zn24)+Sqrt2*Zm21
     &      *dconjg(Zn34))
      AAABC(1025) = EE/SW*(2D0*Zm12*dconjg(Zn24)+Sqrt2*Zm22
     &      *dconjg(Zn34))
      AAABC(1026) = EE/SW*(2D0*Zn24*Zp11-Sqrt2*Zn44*Zp21)
      AAABC(1027) = EE/SW*(2D0*Zn21*Zp12-Sqrt2*Zn41*Zp22)
      AAABC(1028) = EE/SW*(2D0*Zn22*Zp12-Sqrt2*Zn42*Zp22)
      AAABC(1029) = EE/SW*(2D0*Zn23*Zp12-Sqrt2*Zn43*Zp22)
      AAABC(1030) = EE/SW*(2D0*Zn24*Zp12-Sqrt2*Zn44*Zp22)
      AAABC(1031) = EE/SW*(2D0*Zm11*dconjg(Zn23)+Sqrt2*Zm21
     &      *dconjg(Zn33))
      AAABC(1032) = EE/SW*(2D0*Zn23*Zp11-Sqrt2*Zn43*Zp21)
      AAABC(1033) = EE/SW*(2D0*Zm11*dconjg(Zn21)+Sqrt2*Zm21
     &      *dconjg(Zn31))
      AAABC(1034) = EE/SW*(2D0*Zn21*Zp11-Sqrt2*Zn41*Zp21)
      AAABC(1035) = EE/SW*(2D0*Zm11*dconjg(Zn22)+Sqrt2*Zm21
     &      *dconjg(Zn32))
      AAABC(1036) = EE/SW*(2D0*Zn22*Zp11-Sqrt2*Zn42*Zp21)
      AAABR(1995) = EE/CW*SW
      AAABR(1996) = EE/SW*Sqrt2
      AAABR(1997) = EE*(SW/CW+3D0*CW/SW)
      AAABR(1998) = EE*(SW/CW-3D0*CW/SW)
      AAABC(1037) = CW*EE/SW*(dconjg(Zn31)*Zn32-dconjg(Zn41
     &      )*Zn42)
      AAABC(1038) = EE*(dconjg(Zn31)*Zn32-dconjg(Zn41)*Zn42)
      AAABC(1039) = CW*EE/SW*(dconjg(Zn31)*Zn33-dconjg(Zn41
     &      )*Zn43)
      AAABC(1040) = EE*(dconjg(Zn31)*Zn33-dconjg(Zn41)*Zn43)
      AAABC(1041) = CW*EE/SW*(dconjg(Zn31)*Zn34-dconjg(Zn41
     &      )*Zn44)
      AAABC(1042) = EE*(dconjg(Zn31)*Zn34-dconjg(Zn41)*Zn44)
      AAABC(1043) = CW*EE/SW*(Zn31*dconjg(Zn31)-Zn41*dconjg(Zn41
     &      ))
      AAABC(1044) = EE*(Zn31*dconjg(Zn31)-Zn41*dconjg(Zn41))
      AAABC(1045) = EE*(SW/CW*Zn31*dconjg(Zn31)-SW/CW*Zn41
     &      *dconjg(Zn41)+CW/SW*Zn31*dconjg(Zn31)-CW/SW*Zn41
     &      *dconjg(Zn41))
      AAABC(1046) = EE*(SW/CW*dconjg(Zn31)*Zn32-SW/CW*dconjg(Zn41
     &      )*Zn42+CW/SW*dconjg(Zn31)*Zn32-CW/SW*dconjg(Zn41
     &      )*Zn42)
      AAABC(1047) = EE*(SW/CW*dconjg(Zn31)*Zn33-SW/CW*dconjg(Zn41
     &      )*Zn43+CW/SW*dconjg(Zn31)*Zn33-CW/SW*dconjg(Zn41
     &      )*Zn43)
      AAABC(1048) = EE*(SW/CW*dconjg(Zn31)*Zn34-SW/CW*dconjg(Zn41
     &      )*Zn44+CW/SW*dconjg(Zn31)*Zn34-CW/SW*dconjg(Zn41
     &      )*Zn44)
      AAABC(1049) = EE*(SW/CW*dconjg(Zn32)*Zn33-SW/CW*dconjg(Zn42
     &      )*Zn43+CW/SW*dconjg(Zn32)*Zn33-CW/SW*dconjg(Zn42
     &      )*Zn43)
      AAABC(1050) = EE*(SW/CW*Zn33*dconjg(Zn33)-SW/CW*Zn43
     &      *dconjg(Zn43)+CW/SW*Zn33*dconjg(Zn33)-CW/SW*Zn43
     &      *dconjg(Zn43))
      AAABC(1051) = EE*(SW/CW*dconjg(Zn33)*Zn34-SW/CW*dconjg(Zn43
     &      )*Zn44+CW/SW*dconjg(Zn33)*Zn34-CW/SW*dconjg(Zn43
     &      )*Zn44)
      AAABC(1052) = EE*(dconjg(Zn31)*Zn33-dconjg(Zn41)*Zn43
     &      +SW**2/CW**2*dconjg(Zn31)*Zn33-SW**2/CW**2*dconjg(Zn41
     &      )*Zn43)
      AAABC(1053) = EE*(Zn31*dconjg(Zn31)-Zn41*dconjg(Zn41
     &      )+SW**2/CW**2*Zn31*dconjg(Zn31)-SW**2/CW**2*Zn41
     &      *dconjg(Zn41))
      AAABC(1054) = EE*(SW/CW*dconjg(Zn32)*Zn34-SW/CW*dconjg(Zn42
     &      )*Zn44+CW/SW*dconjg(Zn32)*Zn34-CW/SW*dconjg(Zn42
     &      )*Zn44)
      AAABC(1055) = EE*(SW/CW*Zn34*dconjg(Zn34)-SW/CW*Zn44
     &      *dconjg(Zn44)+CW/SW*Zn34*dconjg(Zn34)-CW/SW*Zn44
     &      *dconjg(Zn44))
      AAABC(1056) = EE*(dconjg(Zn31)*Zn34-dconjg(Zn41)*Zn44
     &      +SW**2/CW**2*dconjg(Zn31)*Zn34-SW**2/CW**2*dconjg(Zn41
     &      )*Zn44)
      AAABC(1057) = EE*(SW/CW*Zn32*dconjg(Zn32)-SW/CW*Zn42
     &      *dconjg(Zn42)+CW/SW*Zn32*dconjg(Zn32)-CW/SW*Zn42
     &      *dconjg(Zn42))
      AAABC(1058) = EE*(dconjg(Zn31)*Zn32-dconjg(Zn41)*Zn42
     &      +SW**2/CW**2*dconjg(Zn31)*Zn32-SW**2/CW**2*dconjg(Zn41
     &      )*Zn42)
      AAABC(1059) = CW*EE/SW*(Zn32*dconjg(Zn32)-Zn42*dconjg(Zn42
     &      ))
      AAABC(1060) = EE*(Zn32*dconjg(Zn32)-Zn42*dconjg(Zn42))
      AAABC(1061) = CW*EE/SW*(dconjg(Zn32)*Zn34-dconjg(Zn42
     &      )*Zn44)
      AAABC(1062) = EE*(dconjg(Zn32)*Zn34-dconjg(Zn42)*Zn44)
      AAABC(1063) = CW*EE/SW*(dconjg(Zn32)*Zn33-dconjg(Zn42
     &      )*Zn43)
      AAABC(1064) = EE*(dconjg(Zn32)*Zn33-dconjg(Zn42)*Zn43)
      AAABC(1065) = EE*(Zn32*dconjg(Zn32)-Zn42*dconjg(Zn42
     &      )+SW**2/CW**2*Zn32*dconjg(Zn32)-SW**2/CW**2*Zn42
     &      *dconjg(Zn42))
      AAABC(1066) = EE*(dconjg(Zn32)*Zn34-dconjg(Zn42)*Zn44
     &      +SW**2/CW**2*dconjg(Zn32)*Zn34-SW**2/CW**2*dconjg(Zn42
     &      )*Zn44)
      AAABC(1067) = EE*(dconjg(Zn32)*Zn33-dconjg(Zn42)*Zn43
     &      +SW**2/CW**2*dconjg(Zn32)*Zn33-SW**2/CW**2*dconjg(Zn42
     &      )*Zn43)
      AAABC(1068) = CW*EE/SW*(dconjg(Zn33)*Zn34-dconjg(Zn43
     &      )*Zn44)
      AAABC(1069) = EE*(dconjg(Zn33)*Zn34-dconjg(Zn43)*Zn44)
      AAABC(1070) = CW*EE/SW*(Zn33*dconjg(Zn33)-Zn43*dconjg(Zn43
     &      ))
      AAABC(1071) = EE*(Zn33*dconjg(Zn33)-Zn43*dconjg(Zn43))
      AAABC(1072) = EE*(dconjg(Zn33)*Zn34-dconjg(Zn43)*Zn44
     &      +SW**2/CW**2*dconjg(Zn33)*Zn34-SW**2/CW**2*dconjg(Zn43
     &      )*Zn44)
      AAABC(1073) = EE*(Zn33*dconjg(Zn33)-Zn43*dconjg(Zn43
     &      )+SW**2/CW**2*Zn33*dconjg(Zn33)-SW**2/CW**2*Zn43
     &      *dconjg(Zn43))
      AAABC(1074) = CW*EE/SW*(Zn34*dconjg(Zn34)-Zn44*dconjg(Zn44
     &      ))
      AAABC(1075) = EE*(Zn34*dconjg(Zn34)-Zn44*dconjg(Zn44))
      AAABC(1076) = EE*(Zn34*dconjg(Zn34)-Zn44*dconjg(Zn44
     &      )+SW**2/CW**2*Zn34*dconjg(Zn34)-SW**2/CW**2*Zn44
     &      *dconjg(Zn44))
      AAABR(1999) = EE**2/SW*nlr
      AAABR(2000) = EE**2/SW*nlk
      AAABR(2001) = EE**2/SW*nld2
      AAABR(2002) = EE**2/SW*nld1
      AAABR(2003) = EE**2/SW**2*(nlr+ca*cb*nld1+ca*nld2*sb
     &      -cb*nld2*sa+nld1*sa*sb)
      AAABR(2004) = EE**2/SW**2*(nlk-ca*cb*nld2+ca*nld1*sb
     &      -cb*nld1*sa-nld2*sa*sb)
      AAABR(2005) = EE**2/SW**2*(nlr-ca*cb*nld1-ca*nld2*sb
     &      +cb*nld2*sa-nld1*sa*sb)
      AAABR(2006) = EE**2/SW**2*nlr
      AAABR(2007) = EE**2/SW**2*nlr*(ca*cb+sa*sb)
      AAABR(2008) = EE**2/SW**2*nlr*(ca*sb-cb*sa)
      AAABR(2009) = EE**2/SW**2*(nlk+ca*cb*nld2-ca*nld1*sb
     &      +cb*nld1*sa+nld2*sa*sb)
      AAABR(2010) = EE**2/SW**2*nlk
      AAABR(2011) = EE**2/SW**2*(nld2-ca*cb*nlk-nlk*sa*sb)
      AAABR(2012) = EE**2/SW**2*(nld1+ca*nlk*sb-cb*nlk*sa)
      AAABR(2013) = EE**2/SW**2*(ca*cb*nld1-ca*nld2*sb+cb
     &      *nld2*sa+nld1*sa*sb)
      AAABR(2014) = EE**2/SW**2*nld2*(ca*cb+sa*sb)
      AAABR(2015) = EE**2/SW**2*nld1*(ca*sb-cb*sa)
      AAABR(2016) = EE**2*(nlr/CW-CW/SW**2*nlr+ca/CW/SW**2
     &      *cb*nld1+ca/CW/SW**2*nld2*sb-cb/CW/SW**2*nld2
     &      *sa+nld1/CW/SW**2*sa*sb)
      AAABR(2017) = EE**2*(nlk/CW-CW/SW**2*nlk-ca/CW/SW**2
     &      *cb*nld2+ca/CW/SW**2*nld1*sb-cb/CW/SW**2*nld1
     &      *sa-nld2/CW/SW**2*sa*sb)
      AAABR(2018) = EE**2*(nld2/CW-CW/SW**2*nld2-ca/CW/SW
     &      **2*cb*nlk+ca/CW/SW**2*nlr*sb-cb/CW/SW**2*nlr
     &      *sa-nlk/CW/SW**2*sa*sb)
      AAABR(2019) = EE**2*(nld1/CW-CW/SW**2*nld1+ca/CW/SW
     &      **2*cb*nlr+ca/CW/SW**2*nlk*sb-cb/CW/SW**2*nlk
     &      *sa+nlr/CW/SW**2*sa*sb)
      AAABR(2020) = EE**2/CW/SW**2*(ca*cb*nle1-ca*nle2*sb
     &      +cb*nle2*sa+nle1*sa*sb)
      AAABR(2021) = EE**2/CW/SW**2*(ca*cb*nle2+ca*nle1*sb
     &      -cb*nle1*sa+nle2*sa*sb)
      AAABR(2022) = EE**2/CW/SW**2*nle2
      AAABR(2023) = EE**2/CW/SW**2*nle1
      AAABR(2024) = EE**2/CW**2/SW**2*(ca*cb*nle1-ca*nle2
     &      *sb+cb*nle2*sa+nle1*sa*sb)
      AAABR(2025) = EE**2/CW**2/SW**2*(ca*cb*nle2+ca*nle1
     &      *sb-cb*nle1*sa+nle2*sa*sb)
      AAABR(2026) = EE**2/CW**2/SW**2*nle2*(ca*cb+sa*sb)
      AAABR(2027) = EE**2/CW**2/SW**2*nle1*(ca*sb-cb*sa)
      AAABR(2028) = EE**2/CW**2/SW**2*(ca*cb*nle1+ca*nle2
     &      *sb-cb*nle2*sa+nle1*sa*sb)
      AAABR(2029) = EE**2*nla
      AAABR(2030) = CW*EE**2/SW*nlb
      AAABR(2031) = EE**2*(nla+CW**2/SW**2*nlb)
      AAABR(2032) = CW*EE**2/SW*(nla+nlb)
      AAABR(2033) = CW**2*EE**2/SW**2*nlb
      AAABR(2034) = CW*EE**2/SW*nla
      AAABR(2035) = EE**2*(1D0/CW**2+1D0/SW**2-4D0*sb**2
     &      /CW**2+4D0*sb**4/CW**2-4D0*sb**2/SW**2+4D0*sb
     &      **4/SW**2)
      AAABR(2036) = EE**2/SW**2*(1D0-4D0*sb**2+4D0*sb**4)
      AAABR(2037) = EE**2*(sb**2/CW**2-2D0*sb**4/CW**2+sb
     &      **2/SW**2-2D0*sb**4/SW**2)
      AAABR(2038) = EE**2*(1D0/CW**2+1D0/SW**2-3D0*sb**2
     &      /CW**2+2D0*sb**4/CW**2-3D0*sb**2/SW**2+2D0*sb
     &      **4/SW**2)
      AAABR(2039) = EE**2/CW**2*(1D0-4D0*sb**2+4D0*sb**4)
      AAABR(2040) = EE**2/CW**3*SW*(1D0-4D0*sb**2+4D0*sb**4)
      AAABR(2041) = EE**2*cb*(sb/CW**2-4D0*sb**3/CW**2+sb
     &      /SW**2-4D0*sb**3/SW**2)
      AAABR(2042) = EE**2*cb*(sb/CW**2-2D0*sb**3/CW**2+sb
     &      /SW**2-2D0*sb**3/SW**2)
      AAABR(2043) = EE**2/SW**2*cb*(sb-2D0*sb**3)
      AAABR(2044) = EE**2*cb*(3D0*sb/CW**2-4D0*sb**3/CW**2
     &      +3D0*sb/SW**2-4D0*sb**3/SW**2)
      AAABR(2045) = EE**2/CW**2*cb*(sb-2D0*sb**3)
      AAABR(2046) = EE**2/CW**3*SW*cb*(sb-2D0*sb**3)
      AAABR(2047) = EE**2*cb**2*sb**2*(1D0/CW**2+1D0/SW**2)
      AAABR(2048) = EE**2/SW**2*cb**2*sb**2
      AAABR(2049) = EE**2/CW**2*cb**2*sb**2
      AAABR(2050) = EE**2/CW**3*SW*cb**2*sb**2
      AAABR(2051) = EE**2*cb*(sb/CW**2-2D0*sb**3/CW**2-2D0
     &      *sb**3/SW**2)
      AAABR(2052) = EE**2*cb*(2D0*sb**3/CW**2-sb/SW**2+2D0
     &      *sb**3/SW**2)
      AAABR(2053) = EE**2*cb*(sb/CW**2-2D0*sb**3/CW**2+2D0
     &      *sb/SW**2-2D0*sb**3/SW**2)
      AAABR(2054) = EE**2*cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      +sb/SW**2-2D0*sb**3/SW**2)
      AAABR(2055) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +sb**2/SW**2-sb**4/SW**2-3D0*sb**2/CW**2*seth
     &      **2+3D0*sb**4/CW**2*seth**2-sb**2/SW**2*seth
     &      **2+sb**4/SW**2*seth**2+2D0*Me**2/MW**2/SW**2
     &      *sb**2*seth**2)
      AAABR(2056) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*seth**2/CW**2
     &      -3D0*sb**2/SW**2+2D0*sb**4/SW**2-seth**2/SW**2
     &      +9D0*sb**2/CW**2*seth**2-6D0*sb**4/CW**2*seth
     &      **2+3D0*sb**2/SW**2*seth**2-2D0*sb**4/SW**2*seth
     &      **2-2D0*Me**2/MW**2/SW**2*sb**2*seth**2)
      AAABR(2057) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-seth**2+3D0*sb**2*seth**2-2D0*sb**4*seth
     &      **2)
      AAABR(2058) = EE**2/cb**2*ceth*seth*(3D0/CW**2+1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2-3D0*sb
     &      **2/SW**2+2D0*sb**4/SW**2+2D0*Me**2/MW**2/SW
     &      **2*sb**2)
      AAABR(2059) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*seth**2/CW**2-2D0
     &      *sb**2/SW**2+sb**4/SW**2-seth**2/SW**2+6D0*sb
     &      **2/CW**2*seth**2-3D0*sb**4/CW**2*seth**2+2D0
     &      *sb**2/SW**2*seth**2-sb**4/SW**2*seth**2)
      AAABR(2060) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*seth**2+9D0*sb**2*seth**2-6D0*sb**4
     &      *seth**2)
      AAABR(2061) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*seth**2+9D0*sb**2*seth**2-6D0*sb**4
     &      *seth**2)
      AAABR(2062) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2*seth
     &      **2
      AAABR(2063) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**4*seth
     &      **2
      AAABR(2064) = EE**2/MW**2*Me/SW**2/cb**2*sb**2*seth**2
      AAABR(2065) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +sb**2/SW**2-sb**4/SW**2-3D0*sb**2/CW**2*slth
     &      **2+3D0*sb**4/CW**2*slth**2-sb**2/SW**2*slth
     &      **2+sb**4/SW**2*slth**2+2D0*Ml**2/MW**2/SW**2
     &      *sb**2*slth**2)
      AAABR(2066) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*slth**2/CW**2
     &      -3D0*sb**2/SW**2+2D0*sb**4/SW**2-slth**2/SW**2
     &      +9D0*sb**2/CW**2*slth**2-6D0*sb**4/CW**2*slth
     &      **2+3D0*sb**2/SW**2*slth**2-2D0*sb**4/SW**2*slth
     &      **2-2D0*Ml**2/MW**2/SW**2*sb**2*slth**2)
      AAABR(2067) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-slth**2+3D0*sb**2*slth**2-2D0*sb**4*slth
     &      **2)
      AAABR(2068) = EE**2/cb**2*clth*slth*(3D0/CW**2+1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2-3D0*sb
     &      **2/SW**2+2D0*sb**4/SW**2+2D0*Ml**2/MW**2/SW
     &      **2*sb**2)
      AAABR(2069) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*slth**2/CW**2-2D0
     &      *sb**2/SW**2+sb**4/SW**2-slth**2/SW**2+6D0*sb
     &      **2/CW**2*slth**2-3D0*sb**4/CW**2*slth**2+2D0
     &      *sb**2/SW**2*slth**2-sb**4/SW**2*slth**2)
      AAABR(2070) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*slth**2+9D0*sb**2*slth**2-6D0*sb**4
     &      *slth**2)
      AAABR(2071) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*slth**2+9D0*sb**2*slth**2-6D0*sb**4
     &      *slth**2)
      AAABR(2072) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2*slth
     &      **2
      AAABR(2073) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**4*slth
     &      **2
      AAABR(2074) = EE**2/MW**2*Ml/SW**2/cb**2*sb**2*slth**2
      AAABR(2075) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +sb**2/SW**2-sb**4/SW**2-3D0*sb**2/CW**2*smuth
     &      **2+3D0*sb**4/CW**2*smuth**2-sb**2/SW**2*smuth
     &      **2+sb**4/SW**2*smuth**2+2D0*Mm**2/MW**2/SW**2
     &      *sb**2*smuth**2)
      AAABR(2076) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*smuth**2/CW
     &      **2-3D0*sb**2/SW**2+2D0*sb**4/SW**2-smuth**2
     &      /SW**2+9D0*sb**2/CW**2*smuth**2-6D0*sb**4/CW
     &      **2*smuth**2+3D0*sb**2/SW**2*smuth**2-2D0*sb
     &      **4/SW**2*smuth**2-2D0*Mm**2/MW**2/SW**2*sb**2
     &      *smuth**2)
      AAABR(2077) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-smuth**2+3D0*sb**2*smuth**2-2D0*sb**4
     &      *smuth**2)
      AAABR(2078) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2+1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2-3D0*sb
     &      **2/SW**2+2D0*sb**4/SW**2+2D0*Mm**2/MW**2/SW
     &      **2*sb**2)
      AAABR(2079) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*smuth**2/CW**2-2D0
     &      *sb**2/SW**2+sb**4/SW**2-smuth**2/SW**2+6D0*sb
     &      **2/CW**2*smuth**2-3D0*sb**4/CW**2*smuth**2+2D0
     &      *sb**2/SW**2*smuth**2-sb**4/SW**2*smuth**2)
      AAABR(2080) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*smuth**2+9D0*sb**2*smuth**2-6D0*sb
     &      **4*smuth**2)
      AAABR(2081) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-3D0*smuth**2+9D0*sb**2*smuth**2-6D0*sb
     &      **4*smuth**2)
      AAABR(2082) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2*smuth
     &      **2
      AAABR(2083) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**4*smuth
     &      **2
      AAABR(2084) = EE**2/MW**2*Mm/SW**2/cb**2*sb**2*smuth
     &      **2
      AAABR(2085) = EE**2/cb**2*ceth*seth*(3D0*sb**2/CW**2
     &      -3D0*sb**4/CW**2+sb**2/SW**2-sb**4/SW**2-2D0
     &      *Me**2/MW**2/SW**2*sb**2)
      AAABR(2086) = EE**2/SW**2/cb**2*ceth*seth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2087) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*seth**2/CW**2-seth**2/SW
     &      **2+9D0*sb**2/CW**2*seth**2-6D0*sb**4/CW**2*seth
     &      **2+3D0*sb**2/SW**2*seth**2-2D0*sb**4/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*sb**2-2D0*Me**2/MW
     &      **2/SW**2*sb**2*seth**2)
      AAABR(2088) = EE**2/cb**2*ceth*seth*(3D0/CW**2+1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2-2D0*sb
     &      **2/SW**2+sb**4/SW**2)
      AAABR(2089) = EE**2/CW**2/cb**2*ceth*seth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2090) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2091) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth*sb
     &      **2*seth
      AAABR(2092) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth*sb
     &      **4*seth
      AAABR(2093) = EE**2/MW**2*Me/SW**2/cb**2*ceth*sb**2
     &      *seth
      AAABR(2094) = EE**2/cb**2*clth*slth*(3D0*sb**2/CW**2
     &      -3D0*sb**4/CW**2+sb**2/SW**2-sb**4/SW**2-2D0
     &      *Ml**2/MW**2/SW**2*sb**2)
      AAABR(2095) = EE**2/SW**2/cb**2*clth*slth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2096) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*slth**2/CW**2-slth**2/SW
     &      **2+9D0*sb**2/CW**2*slth**2-6D0*sb**4/CW**2*slth
     &      **2+3D0*sb**2/SW**2*slth**2-2D0*sb**4/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*sb**2-2D0*Ml**2/MW
     &      **2/SW**2*sb**2*slth**2)
      AAABR(2097) = EE**2/cb**2*clth*slth*(3D0/CW**2+1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2-2D0*sb
     &      **2/SW**2+sb**4/SW**2)
      AAABR(2098) = EE**2/CW**2/cb**2*clth*slth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2099) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2100) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth*sb
     &      **2*slth
      AAABR(2101) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth*sb
     &      **4*slth
      AAABR(2102) = EE**2/MW**2*Ml/SW**2/cb**2*clth*sb**2
     &      *slth
      AAABR(2103) = EE**2/cb**2*cmuth*smuth*(3D0*sb**2/CW
     &      **2-3D0*sb**4/CW**2+sb**2/SW**2-sb**4/SW**2-2D0
     &      *Mm**2/MW**2/SW**2*sb**2)
      AAABR(2104) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2105) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*smuth**2/CW**2-smuth**2
     &      /SW**2+9D0*sb**2/CW**2*smuth**2-6D0*sb**4/CW
     &      **2*smuth**2+3D0*sb**2/SW**2*smuth**2-2D0*sb
     &      **4/SW**2*smuth**2+2D0*Mm**2/MW**2/SW**2*sb**2
     &      -2D0*Mm**2/MW**2/SW**2*sb**2*smuth**2)
      AAABR(2106) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2+1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2-2D0*sb
     &      **2/SW**2+sb**4/SW**2)
      AAABR(2107) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2108) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2109) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth*sb
     &      **2*smuth
      AAABR(2110) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth*sb
     &      **4*smuth
      AAABR(2111) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*sb**2
     &      *smuth
      AAABR(2112) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*slth**2+3D0*sb**4/CW**2
     &      *slth**2-sb**2/SW**2*slth**2+sb**4/SW**2*slth
     &      **2-2D0*Ml**2/MW**2/SW**2*sb**2+2D0*Ml**2/MW
     &      **2/SW**2*sb**2*slth**2)
      AAABR(2113) = EE**2/SW**2/cb**2*slth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2114) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*slth**2/CW**2-slth**2/SW
     &      **2+6D0*sb**2/CW**2*slth**2-3D0*sb**4/CW**2*slth
     &      **2+2D0*sb**2/SW**2*slth**2-sb**4/SW**2*slth**2)
      AAABR(2115) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*slth**2+9D0*sb**2*slth**2-6D0*sb**4
     &      *slth**2)
      AAABR(2116) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*slth**2+9D0*sb**2*slth**2-6D0*sb**4
     &      *slth**2)
      AAABR(2117) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2*(1D0
     &      -slth**2)
      AAABR(2118) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**4*(1D0
     &      -slth**2)
      AAABR(2119) = EE**2/MW**2*Ml/SW**2/cb**2*sb**2*(1D0
     &      -slth**2)
      AAABR(2120) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*seth**2+3D0*sb**4/CW**2
     &      *seth**2-sb**2/SW**2*seth**2+sb**4/SW**2*seth
     &      **2-2D0*Me**2/MW**2/SW**2*sb**2+2D0*Me**2/MW
     &      **2/SW**2*sb**2*seth**2)
      AAABR(2121) = EE**2/SW**2/cb**2*seth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2122) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*seth**2/CW**2-seth**2/SW
     &      **2+6D0*sb**2/CW**2*seth**2-3D0*sb**4/CW**2*seth
     &      **2+2D0*sb**2/SW**2*seth**2-sb**4/SW**2*seth**2)
      AAABR(2123) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*seth**2+9D0*sb**2*seth**2-6D0*sb**4
     &      *seth**2)
      AAABR(2124) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*seth**2+9D0*sb**2*seth**2-6D0*sb**4
     &      *seth**2)
      AAABR(2125) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2*(1D0
     &      -seth**2)
      AAABR(2126) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**4*(1D0
     &      -seth**2)
      AAABR(2127) = EE**2/MW**2*Me/SW**2/cb**2*sb**2*(1D0
     &      -seth**2)
      AAABR(2128) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*smuth**2+3D0*sb**4/CW
     &      **2*smuth**2-sb**2/SW**2*smuth**2+sb**4/SW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2*sb**2+2D0*Mm
     &      **2/MW**2/SW**2*sb**2*smuth**2)
      AAABR(2129) = EE**2/SW**2/cb**2*smuth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2130) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*smuth**2/CW**2-smuth**2
     &      /SW**2+6D0*sb**2/CW**2*smuth**2-3D0*sb**4/CW
     &      **2*smuth**2+2D0*sb**2/SW**2*smuth**2-sb**4/SW
     &      **2*smuth**2)
      AAABR(2131) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*smuth**2+9D0*sb**2*smuth**2-6D0*sb
     &      **4*smuth**2)
      AAABR(2132) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-3D0*smuth**2+9D0*sb**2*smuth**2-6D0*sb
     &      **4*smuth**2)
      AAABR(2133) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2*(1D0
     &      -smuth**2)
      AAABR(2134) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**4*(1D0
     &      -smuth**2)
      AAABR(2135) = EE**2/MW**2*Mm/SW**2/cb**2*sb**2*(1D0
     &      -smuth**2)
      AAABR(2136) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2+2D0*Ml**2/MW**2/SW**2
     &      *sb**2)
      AAABR(2137) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+3D0*sb**2/SW**2
     &      -2D0*sb**4/SW**2-2D0*Ml**2/MW**2/SW**2*sb**2)
      AAABR(2138) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4)
      AAABR(2139) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+2D0*sb**2/SW**2-sb**4
     &      /SW**2)
      AAABR(2140) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4)
      AAABR(2141) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4)
      AAABR(2142) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2
      AAABR(2143) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**4
      AAABR(2144) = EE**2/MW**2*Ml/SW**2/cb**2*sb**2
      AAABR(2145) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2+2D0*Me**2/MW**2/SW**2
     &      *sb**2)
      AAABR(2146) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+3D0*sb**2/SW**2
     &      -2D0*sb**4/SW**2-2D0*Me**2/MW**2/SW**2*sb**2)
      AAABR(2147) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2
      AAABR(2148) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**4
      AAABR(2149) = EE**2/MW**2*Me/SW**2/cb**2*sb**2
      AAABR(2150) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2+2D0*Mm**2/MW**2/SW**2
     &      *sb**2)
      AAABR(2151) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+3D0*sb**2/SW**2
     &      -2D0*sb**4/SW**2-2D0*Mm**2/MW**2/SW**2*sb**2)
      AAABR(2152) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2
      AAABR(2153) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**4
      AAABR(2154) = EE**2/MW**2*Mm/SW**2/cb**2*sb**2
      AAABR(2155) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -3D0*sb**2/SW**2+3D0*sb**4/SW**2+sb**2/CW**2
     &      *ssth**2-sb**4/CW**2*ssth**2+3D0*sb**2/SW**2
     &      *ssth**2-3D0*sb**4/SW**2*ssth**2-6D0*Ms**2/MW
     &      **2/SW**2*sb**2*ssth**2)
      AAABR(2156) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+ssth**2/CW**2+9D0
     &      *sb**2/SW**2-6D0*sb**4/SW**2+3D0*ssth**2/SW**2
     &      -3D0*sb**2/CW**2*ssth**2+2D0*sb**4/CW**2*ssth
     &      **2-12D0*Mc**2/MW**2/SW**2-9D0*sb**2/SW**2*ssth
     &      **2+6D0*sb**4/SW**2*ssth**2+6D0*Mc**2/MW**2/SW
     &      **2/sb**2+6D0*Mc**2/MW**2/SW**2*sb**2+12D0*Mc
     &      **2/MW**2/SW**2*ssth**2-6D0*Mc**2/MW**2/SW**2
     &      /sb**2*ssth**2-6D0*Mc**2/MW**2/SW**2*sb**2*ssth
     &      **2+6D0*Ms**2/MW**2/SW**2*sb**2*ssth**2)
      AAABR(2157) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-ssth**2+3D0*sb**2*ssth**2-2D0*sb**4*ssth
     &      **2)
      AAABR(2158) = EE**2/cb**2*csth*ssth*(1D0/CW**2+3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2-9D0*sb
     &      **2/SW**2+6D0*sb**4/SW**2+12D0*Mc**2/MW**2/SW
     &      **2-6D0*Mc**2/MW**2/SW**2/sb**2-6D0*Mc**2/MW
     &      **2/SW**2*sb**2+6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(2159) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+ssth**2/CW**2+6D0*sb
     &      **2/SW**2-3D0*sb**4/SW**2+3D0*ssth**2/SW**2-2D0
     &      *sb**2/CW**2*ssth**2+sb**4/CW**2*ssth**2-12D0
     &      *Mc**2/MW**2/SW**2-6D0*sb**2/SW**2*ssth**2+3D0
     &      *sb**4/SW**2*ssth**2+6D0*Mc**2/MW**2/SW**2/sb
     &      **2+6D0*Mc**2/MW**2/SW**2*sb**2+12D0*Mc**2/MW
     &      **2/SW**2*ssth**2-6D0*Mc**2/MW**2/SW**2/sb**2
     &      *ssth**2-6D0*Mc**2/MW**2/SW**2*sb**2*ssth**2)
      AAABR(2160) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+ssth**2-3D0*sb**2*ssth**2+2D0*sb**4*ssth
     &      **2)
      AAABR(2161) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+ssth**2-3D0*sb**2*ssth**2+2D0*sb**4*ssth
     &      **2)
      AAABR(2162) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2-Mc
     &      **2/sb**2-Mc**2*sb**2-2D0*Mc**2*ssth**2+Mc**2
     &      /sb**2*ssth**2+Mc**2*sb**2*ssth**2-Ms**2*sb**2
     &      *ssth**2)
      AAABR(2163) = EE**2/MW**2/SW**2/cb**2*(3D0*Mc**2-Mc
     &      **2/sb**2-3D0*Mc**2*sb**2+Mc**2*sb**4-3D0*Mc
     &      **2*ssth**2+Mc**2/sb**2*ssth**2+3D0*Mc**2*sb
     &      **2*ssth**2-Mc**2*sb**4*ssth**2+Ms**2*sb**4*ssth
     &      **2)
      AAABR(2164) = EE**2/MW**2*Ms/SW**2/cb**2*sb**2*ssth**2
      AAABR(2165) = EE**2/MW**2*Mc/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*ssth**2+ssth**2/sb**2+sb**2*ssth
     &      **2)
      AAABR(2166) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -3D0*sb**2/SW**2+3D0*sb**4/SW**2+sb**2/CW**2
     &      *sbth**2-sb**4/CW**2*sbth**2+3D0*sb**2/SW**2
     &      *sbth**2-3D0*sb**4/SW**2*sbth**2-6D0*Mb**2/MW
     &      **2/SW**2*sb**2*sbth**2)
      AAABR(2167) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+sbth**2/CW**2+9D0
     &      *sb**2/SW**2-6D0*sb**4/SW**2+3D0*sbth**2/SW**2
     &      -3D0*sb**2/CW**2*sbth**2+2D0*sb**4/CW**2*sbth
     &      **2-12D0*Mt**2/MW**2/SW**2-9D0*sb**2/SW**2*sbth
     &      **2+6D0*sb**4/SW**2*sbth**2+6D0*Mt**2/MW**2/SW
     &      **2/sb**2+6D0*Mt**2/MW**2/SW**2*sb**2+12D0*Mt
     &      **2/MW**2/SW**2*sbth**2+6D0*Mb**2/MW**2/SW**2
     &      *sb**2*sbth**2-6D0*Mt**2/MW**2/SW**2/sb**2*sbth
     &      **2-6D0*Mt**2/MW**2/SW**2*sb**2*sbth**2)
      AAABR(2168) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-sbth**2+3D0*sb**2*sbth**2-2D0*sb**4*sbth
     &      **2)
      AAABR(2169) = EE**2/cb**2*cbth*sbth*(1D0/CW**2+3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2-9D0*sb
     &      **2/SW**2+6D0*sb**4/SW**2+12D0*Mt**2/MW**2/SW
     &      **2+6D0*Mb**2/MW**2/SW**2*sb**2-6D0*Mt**2/MW
     &      **2/SW**2/sb**2-6D0*Mt**2/MW**2/SW**2*sb**2)
      AAABR(2170) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+sbth**2/CW**2+6D0*sb
     &      **2/SW**2-3D0*sb**4/SW**2+3D0*sbth**2/SW**2-2D0
     &      *sb**2/CW**2*sbth**2+sb**4/CW**2*sbth**2-12D0
     &      *Mt**2/MW**2/SW**2-6D0*sb**2/SW**2*sbth**2+3D0
     &      *sb**4/SW**2*sbth**2+6D0*Mt**2/MW**2/SW**2/sb
     &      **2+6D0*Mt**2/MW**2/SW**2*sb**2+12D0*Mt**2/MW
     &      **2/SW**2*sbth**2-6D0*Mt**2/MW**2/SW**2/sb**2
     &      *sbth**2-6D0*Mt**2/MW**2/SW**2*sb**2*sbth**2)
      AAABR(2171) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+sbth**2-3D0*sb**2*sbth**2+2D0*sb**4*sbth
     &      **2)
      AAABR(2172) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+sbth**2-3D0*sb**2*sbth**2+2D0*sb**4*sbth
     &      **2)
      AAABR(2173) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt**2-Mt
     &      **2/sb**2-Mt**2*sb**2-2D0*Mt**2*sbth**2-Mb**2
     &      *sb**2*sbth**2+Mt**2/sb**2*sbth**2+Mt**2*sb**2
     &      *sbth**2)
      AAABR(2174) = EE**2/MW**2/SW**2/cb**2*(3D0*Mt**2-Mt
     &      **2/sb**2-3D0*Mt**2*sb**2+Mt**2*sb**4-3D0*Mt
     &      **2*sbth**2+Mb**2*sb**4*sbth**2+Mt**2/sb**2*sbth
     &      **2+3D0*Mt**2*sb**2*sbth**2-Mt**2*sb**4*sbth**2)
      AAABR(2175) = EE**2/MW**2*Mb/SW**2/cb**2*sb**2*sbth**2
      AAABR(2176) = EE**2/MW**2*Mt/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*sbth**2+sbth**2/sb**2+sb**2*sbth
     &      **2)
      AAABR(2177) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -3D0*sb**2/SW**2+3D0*sb**4/SW**2+sb**2/CW**2
     &      *sdth**2-sb**4/CW**2*sdth**2+3D0*sb**2/SW**2
     &      *sdth**2-3D0*sb**4/SW**2*sdth**2-6D0*Md**2/MW
     &      **2/SW**2*sb**2*sdth**2)
      AAABR(2178) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+sdth**2/CW**2+9D0
     &      *sb**2/SW**2-6D0*sb**4/SW**2+3D0*sdth**2/SW**2
     &      -3D0*sb**2/CW**2*sdth**2+2D0*sb**4/CW**2*sdth
     &      **2-12D0*Mu**2/MW**2/SW**2-9D0*sb**2/SW**2*sdth
     &      **2+6D0*sb**4/SW**2*sdth**2+6D0*Mu**2/MW**2/SW
     &      **2/sb**2+6D0*Mu**2/MW**2/SW**2*sb**2+12D0*Mu
     &      **2/MW**2/SW**2*sdth**2+6D0*Md**2/MW**2/SW**2
     &      *sb**2*sdth**2-6D0*Mu**2/MW**2/SW**2/sb**2*sdth
     &      **2-6D0*Mu**2/MW**2/SW**2*sb**2*sdth**2)
      AAABR(2179) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-sdth**2+3D0*sb**2*sdth**2-2D0*sb**4*sdth
     &      **2)
      AAABR(2180) = EE**2/cb**2*cdth*sdth*(1D0/CW**2+3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2-9D0*sb
     &      **2/SW**2+6D0*sb**4/SW**2+12D0*Mu**2/MW**2/SW
     &      **2+6D0*Md**2/MW**2/SW**2*sb**2-6D0*Mu**2/MW
     &      **2/SW**2/sb**2-6D0*Mu**2/MW**2/SW**2*sb**2)
      AAABR(2181) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+sdth**2/CW**2+6D0*sb
     &      **2/SW**2-3D0*sb**4/SW**2+3D0*sdth**2/SW**2-2D0
     &      *sb**2/CW**2*sdth**2+sb**4/CW**2*sdth**2-12D0
     &      *Mu**2/MW**2/SW**2-6D0*sb**2/SW**2*sdth**2+3D0
     &      *sb**4/SW**2*sdth**2+6D0*Mu**2/MW**2/SW**2/sb
     &      **2+6D0*Mu**2/MW**2/SW**2*sb**2+12D0*Mu**2/MW
     &      **2/SW**2*sdth**2-6D0*Mu**2/MW**2/SW**2/sb**2
     &      *sdth**2-6D0*Mu**2/MW**2/SW**2*sb**2*sdth**2)
      AAABR(2182) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+sdth**2-3D0*sb**2*sdth**2+2D0*sb**4*sdth
     &      **2)
      AAABR(2183) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4+sdth**2-3D0*sb**2*sdth**2+2D0*sb**4*sdth
     &      **2)
      AAABR(2184) = EE**2/MW**2/SW**2/cb**2*(2D0*Mu**2-Mu
     &      **2/sb**2-Mu**2*sb**2-2D0*Mu**2*sdth**2-Md**2
     &      *sb**2*sdth**2+Mu**2/sb**2*sdth**2+Mu**2*sb**2
     &      *sdth**2)
      AAABR(2185) = EE**2/MW**2/SW**2/cb**2*(3D0*Mu**2-Mu
     &      **2/sb**2-3D0*Mu**2*sb**2+Mu**2*sb**4-3D0*Mu
     &      **2*sdth**2+Md**2*sb**4*sdth**2+Mu**2/sb**2*sdth
     &      **2+3D0*Mu**2*sb**2*sdth**2-Mu**2*sb**4*sdth**2)
      AAABR(2186) = EE**2/MW**2*Md/SW**2/cb**2*sb**2*sdth**2
      AAABR(2187) = EE**2/MW**2*Mu/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*sdth**2+sdth**2/sb**2+sb**2*sdth
     &      **2)
      AAABR(2188) = EE**2/cb**2*csth*ssth*(sb**2/CW**2-sb
     &      **4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW**2-6D0
     &      *Ms**2/MW**2/SW**2*sb**2)
      AAABR(2189) = EE**2/SW**2/cb**2*csth*ssth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2190) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-ssth**2/CW**2-3D0*ssth**2/SW
     &      **2+3D0*sb**2/CW**2*ssth**2-2D0*sb**4/CW**2*ssth
     &      **2+9D0*sb**2/SW**2*ssth**2-6D0*sb**4/SW**2*ssth
     &      **2-12D0*Mc**2/MW**2/SW**2*ssth**2+6D0*Ms**2
     &      /MW**2/SW**2*sb**2+6D0*Mc**2/MW**2/SW**2/sb**2
     &      *ssth**2+6D0*Mc**2/MW**2/SW**2*sb**2*ssth**2
     &      -6D0*Ms**2/MW**2/SW**2*sb**2*ssth**2)
      AAABR(2191) = EE**2/cb**2*csth*ssth*(1D0/CW**2+3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2-6D0*sb**2
     &      /SW**2+3D0*sb**4/SW**2+12D0*Mc**2/MW**2/SW**2
     &      -6D0*Mc**2/MW**2/SW**2/sb**2-6D0*Mc**2/MW**2
     &      /SW**2*sb**2)
      AAABR(2192) = EE**2/CW**2/cb**2*csth*ssth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2193) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2194) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(2D0
     &      *Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2195) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(3D0
     &      *Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2*sb**4
     &      -Ms**2*sb**4)
      AAABR(2196) = EE**2/MW**2*Ms/SW**2/cb**2*csth*sb**2
     &      *ssth
      AAABR(2197) = EE**2/MW**2*Mc/SW**2/cb**2*csth*ssth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2198) = EE**2/cb**2*cbth*sbth*(sb**2/CW**2-sb
     &      **4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW**2-6D0
     &      *Mb**2/MW**2/SW**2*sb**2)
      AAABR(2199) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2200) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-sbth**2/CW**2-3D0*sbth**2/SW
     &      **2+3D0*sb**2/CW**2*sbth**2-2D0*sb**4/CW**2*sbth
     &      **2+9D0*sb**2/SW**2*sbth**2-6D0*sb**4/SW**2*sbth
     &      **2+6D0*Mb**2/MW**2/SW**2*sb**2-12D0*Mt**2/MW
     &      **2/SW**2*sbth**2-6D0*Mb**2/MW**2/SW**2*sb**2
     &      *sbth**2+6D0*Mt**2/MW**2/SW**2/sb**2*sbth**2
     &      +6D0*Mt**2/MW**2/SW**2*sb**2*sbth**2)
      AAABR(2201) = EE**2/cb**2*cbth*sbth*(1D0/CW**2+3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2-6D0*sb**2
     &      /SW**2+3D0*sb**4/SW**2+12D0*Mt**2/MW**2/SW**2
     &      -6D0*Mt**2/MW**2/SW**2/sb**2-6D0*Mt**2/MW**2
     &      /SW**2*sb**2)
      AAABR(2202) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2203) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2204) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(2D0
     &      *Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2205) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(3D0
     &      *Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2*sb**2
     &      +Mt**2*sb**4)
      AAABR(2206) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sb**2
     &      *sbth
      AAABR(2207) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*sbth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2208) = EE**2/cb**2*cdth*sdth*(sb**2/CW**2-sb
     &      **4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW**2-6D0
     &      *Md**2/MW**2/SW**2*sb**2)
      AAABR(2209) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2210) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-sdth**2/CW**2-3D0*sdth**2/SW
     &      **2+3D0*sb**2/CW**2*sdth**2-2D0*sb**4/CW**2*sdth
     &      **2+9D0*sb**2/SW**2*sdth**2-6D0*sb**4/SW**2*sdth
     &      **2+6D0*Md**2/MW**2/SW**2*sb**2-12D0*Mu**2/MW
     &      **2/SW**2*sdth**2-6D0*Md**2/MW**2/SW**2*sb**2
     &      *sdth**2+6D0*Mu**2/MW**2/SW**2/sb**2*sdth**2
     &      +6D0*Mu**2/MW**2/SW**2*sb**2*sdth**2)
      AAABR(2211) = EE**2/cb**2*cdth*sdth*(1D0/CW**2+3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2-6D0*sb**2
     &      /SW**2+3D0*sb**4/SW**2+12D0*Mu**2/MW**2/SW**2
     &      -6D0*Mu**2/MW**2/SW**2/sb**2-6D0*Mu**2/MW**2
     &      /SW**2*sb**2)
      AAABR(2212) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2213) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2214) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(2D0
     &      *Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2215) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(3D0
     &      *Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2*sb**2
     &      +Mu**2*sb**4)
      AAABR(2216) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sb**2
     &      *sdth
      AAABR(2217) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*sdth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2218) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*sbth**2+sb**4/CW**2*sbth**2
     &      -3D0*sb**2/SW**2*sbth**2+3D0*sb**4/SW**2*sbth
     &      **2-6D0*Mb**2/MW**2/SW**2*sb**2+6D0*Mb**2/MW
     &      **2/SW**2*sb**2*sbth**2)
      AAABR(2219) = EE**2/SW**2/cb**2*sbth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2220) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-sbth**2/CW**2-3D0*sbth**2/SW
     &      **2+2D0*sb**2/CW**2*sbth**2-sb**4/CW**2*sbth
     &      **2+6D0*sb**2/SW**2*sbth**2-3D0*sb**4/SW**2*sbth
     &      **2-12D0*Mt**2/MW**2/SW**2*sbth**2+6D0*Mt**2
     &      /MW**2/SW**2/sb**2*sbth**2+6D0*Mt**2/MW**2/SW
     &      **2*sb**2*sbth**2)
      AAABR(2221) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-sbth**2+3D0*sb**2*sbth**2-2D0*sb**4*sbth
     &      **2)
      AAABR(2222) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-sbth**2+3D0*sb**2*sbth**2-2D0*sb**4*sbth
     &      **2)
      AAABR(2223) = EE**2/MW**2/SW**2/cb**2*(Mb**2*sb**2
     &      -2D0*Mt**2*sbth**2-Mb**2*sb**2*sbth**2+Mt**2
     &      /sb**2*sbth**2+Mt**2*sb**2*sbth**2)
      AAABR(2224) = EE**2/MW**2/SW**2/cb**2*(Mb**2*sb**4
     &      +3D0*Mt**2*sbth**2-Mb**2*sb**4*sbth**2-Mt**2
     &      /sb**2*sbth**2-3D0*Mt**2*sb**2*sbth**2+Mt**2
     &      *sb**4*sbth**2)
      AAABR(2225) = EE**2/MW**2*Mb/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2)
      AAABR(2226) = EE**2/MW**2*Mt/SW**2/cb**2*sbth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2227) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*sdth**2+sb**4/CW**2*sdth**2
     &      -3D0*sb**2/SW**2*sdth**2+3D0*sb**4/SW**2*sdth
     &      **2-6D0*Md**2/MW**2/SW**2*sb**2+6D0*Md**2/MW
     &      **2/SW**2*sb**2*sdth**2)
      AAABR(2228) = EE**2/SW**2/cb**2*sdth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2229) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-sdth**2/CW**2-3D0*sdth**2/SW
     &      **2+2D0*sb**2/CW**2*sdth**2-sb**4/CW**2*sdth
     &      **2+6D0*sb**2/SW**2*sdth**2-3D0*sb**4/SW**2*sdth
     &      **2-12D0*Mu**2/MW**2/SW**2*sdth**2+6D0*Mu**2
     &      /MW**2/SW**2/sb**2*sdth**2+6D0*Mu**2/MW**2/SW
     &      **2*sb**2*sdth**2)
      AAABR(2230) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-sdth**2+3D0*sb**2*sdth**2-2D0*sb**4*sdth
     &      **2)
      AAABR(2231) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-sdth**2+3D0*sb**2*sdth**2-2D0*sb**4*sdth
     &      **2)
      AAABR(2232) = EE**2/MW**2/SW**2/cb**2*(Md**2*sb**2
     &      -2D0*Mu**2*sdth**2-Md**2*sb**2*sdth**2+Mu**2
     &      /sb**2*sdth**2+Mu**2*sb**2*sdth**2)
      AAABR(2233) = EE**2/MW**2/SW**2/cb**2*(Md**2*sb**4
     &      +3D0*Mu**2*sdth**2-Md**2*sb**4*sdth**2-Mu**2
     &      /sb**2*sdth**2-3D0*Mu**2*sb**2*sdth**2+Mu**2
     &      *sb**4*sdth**2)
      AAABR(2234) = EE**2/MW**2*Md/SW**2/cb**2*sb**2*(1D0
     &      -sdth**2)
      AAABR(2235) = EE**2/MW**2*Mu/SW**2/cb**2*sdth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2236) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*ssth**2+sb**4/CW**2*ssth**2
     &      -3D0*sb**2/SW**2*ssth**2+3D0*sb**4/SW**2*ssth
     &      **2-6D0*Ms**2/MW**2/SW**2*sb**2+6D0*Ms**2/MW
     &      **2/SW**2*sb**2*ssth**2)
      AAABR(2237) = EE**2/SW**2/cb**2*ssth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2238) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-ssth**2/CW**2-3D0*ssth**2/SW
     &      **2+2D0*sb**2/CW**2*ssth**2-sb**4/CW**2*ssth
     &      **2+6D0*sb**2/SW**2*ssth**2-3D0*sb**4/SW**2*ssth
     &      **2-12D0*Mc**2/MW**2/SW**2*ssth**2+6D0*Mc**2
     &      /MW**2/SW**2/sb**2*ssth**2+6D0*Mc**2/MW**2/SW
     &      **2*sb**2*ssth**2)
      AAABR(2239) = EE**2/CW**2/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-ssth**2+3D0*sb**2*ssth**2-2D0*sb**4*ssth
     &      **2)
      AAABR(2240) = EE**2/CW**3*SW/cb**2*(2D0-6D0*sb**2+4D0
     &      *sb**4-ssth**2+3D0*sb**2*ssth**2-2D0*sb**4*ssth
     &      **2)
      AAABR(2241) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2*ssth
     &      **2-Ms**2*sb**2-Mc**2/sb**2*ssth**2-Mc**2*sb
     &      **2*ssth**2+Ms**2*sb**2*ssth**2)
      AAABR(2242) = EE**2/MW**2/SW**2/cb**2*(3D0*Mc**2*ssth
     &      **2+Ms**2*sb**4-Mc**2/sb**2*ssth**2-3D0*Mc**2
     &      *sb**2*ssth**2+Mc**2*sb**4*ssth**2-Ms**2*sb**4
     &      *ssth**2)
      AAABR(2243) = EE**2/MW**2*Ms/SW**2/cb**2*sb**2*(1D0
     &      -ssth**2)
      AAABR(2244) = EE**2/MW**2*Mc/SW**2/cb**2*ssth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2245) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2-5D0*sb**2/CW
     &      **2*scth**2+5D0*sb**4/CW**2*scth**2-3D0*sb**2
     &      /SW**2*scth**2+3D0*sb**4/SW**2*scth**2-6D0*Ms
     &      **2/MW**2/SW**2*sb**2+6D0*Ms**2/MW**2/SW**2*sb
     &      **2*scth**2)
      AAABR(2246) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-5D0*scth**2/CW**2
     &      -9D0*sb**2/SW**2+6D0*sb**4/SW**2-3D0*scth**2
     &      /SW**2+15D0*sb**2/CW**2*scth**2-10D0*sb**4/CW
     &      **2*scth**2+9D0*sb**2/SW**2*scth**2-6D0*sb**4
     &      /SW**2*scth**2-12D0*Mc**2/MW**2/SW**2*scth**2
     &      +6D0*Ms**2/MW**2/SW**2*sb**2+6D0*Mc**2/MW**2
     &      /SW**2/sb**2*scth**2+6D0*Mc**2/MW**2/SW**2*sb
     &      **2*scth**2-6D0*Ms**2/MW**2/SW**2*sb**2*scth**2)
      AAABR(2247) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-scth**2+3D0*sb**2*scth**2-2D0*sb**4*scth
     &      **2)
      AAABR(2248) = EE**2/cb**2*ccth*scth*(5D0/CW**2+3D0
     &      /SW**2-15D0*sb**2/CW**2+10D0*sb**4/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2+12D0*Mc**2/MW**2
     &      /SW**2-6D0*Mc**2/MW**2/SW**2/sb**2-6D0*Mc**2
     &      /MW**2/SW**2*sb**2+6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(2249) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-5D0*scth**2/CW**2-6D0
     &      *sb**2/SW**2+3D0*sb**4/SW**2-3D0*scth**2/SW**2
     &      +10D0*sb**2/CW**2*scth**2-5D0*sb**4/CW**2*scth
     &      **2+6D0*sb**2/SW**2*scth**2-3D0*sb**4/SW**2*scth
     &      **2-12D0*Mc**2/MW**2/SW**2*scth**2+6D0*Mc**2
     &      /MW**2/SW**2/sb**2*scth**2+6D0*Mc**2/MW**2/SW
     &      **2*sb**2*scth**2)
      AAABR(2250) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*scth**2+15D0*sb**2*scth**2-10D0*sb
     &      **4*scth**2)
      AAABR(2251) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*scth**2+15D0*sb**2*scth**2-10D0*sb
     &      **4*scth**2)
      AAABR(2252) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2*scth
     &      **2-Ms**2*sb**2-Mc**2/sb**2*scth**2-Mc**2*sb
     &      **2*scth**2+Ms**2*sb**2*scth**2)
      AAABR(2253) = EE**2/MW**2/SW**2/cb**2*(3D0*Mc**2*scth
     &      **2+Ms**2*sb**4-Mc**2/sb**2*scth**2-3D0*Mc**2
     &      *sb**2*scth**2+Mc**2*sb**4*scth**2-Ms**2*sb**4
     &      *scth**2)
      AAABR(2254) = EE**2/MW**2*Mc/SW**2/cb**2*scth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2255) = EE**2/MW**2*Ms/SW**2/cb**2*sb**2*(1D0
     &      -scth**2)
      AAABR(2256) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2-5D0*sb**2/CW
     &      **2*stth**2+5D0*sb**4/CW**2*stth**2-3D0*sb**2
     &      /SW**2*stth**2+3D0*sb**4/SW**2*stth**2-6D0*Mb
     &      **2/MW**2/SW**2*sb**2+6D0*Mb**2/MW**2/SW**2*sb
     &      **2*stth**2)
      AAABR(2257) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-5D0*stth**2/CW**2
     &      -9D0*sb**2/SW**2+6D0*sb**4/SW**2-3D0*stth**2
     &      /SW**2+15D0*sb**2/CW**2*stth**2-10D0*sb**4/CW
     &      **2*stth**2+9D0*sb**2/SW**2*stth**2-6D0*sb**4
     &      /SW**2*stth**2+6D0*Mb**2/MW**2/SW**2*sb**2-12D0
     &      *Mt**2/MW**2/SW**2*stth**2-6D0*Mb**2/MW**2/SW
     &      **2*sb**2*stth**2+6D0*Mt**2/MW**2/SW**2/sb**2
     &      *stth**2+6D0*Mt**2/MW**2/SW**2*sb**2*stth**2)
      AAABR(2258) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-stth**2+3D0*sb**2*stth**2-2D0*sb**4*stth
     &      **2)
      AAABR(2259) = EE**2/cb**2*ctth*stth*(5D0/CW**2+3D0
     &      /SW**2-15D0*sb**2/CW**2+10D0*sb**4/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2+12D0*Mt**2/MW**2
     &      /SW**2+6D0*Mb**2/MW**2/SW**2*sb**2-6D0*Mt**2
     &      /MW**2/SW**2/sb**2-6D0*Mt**2/MW**2/SW**2*sb**2)
      AAABR(2260) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-5D0*stth**2/CW**2-6D0
     &      *sb**2/SW**2+3D0*sb**4/SW**2-3D0*stth**2/SW**2
     &      +10D0*sb**2/CW**2*stth**2-5D0*sb**4/CW**2*stth
     &      **2+6D0*sb**2/SW**2*stth**2-3D0*sb**4/SW**2*stth
     &      **2-12D0*Mt**2/MW**2/SW**2*stth**2+6D0*Mt**2
     &      /MW**2/SW**2/sb**2*stth**2+6D0*Mt**2/MW**2/SW
     &      **2*sb**2*stth**2)
      AAABR(2261) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*stth**2+15D0*sb**2*stth**2-10D0*sb
     &      **4*stth**2)
      AAABR(2262) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*stth**2+15D0*sb**2*stth**2-10D0*sb
     &      **4*stth**2)
      AAABR(2263) = EE**2/MW**2/SW**2/cb**2*(Mb**2*sb**2
     &      -2D0*Mt**2*stth**2-Mb**2*sb**2*stth**2+Mt**2
     &      /sb**2*stth**2+Mt**2*sb**2*stth**2)
      AAABR(2264) = EE**2/MW**2/SW**2/cb**2*(Mb**2*sb**4
     &      +3D0*Mt**2*stth**2-Mb**2*sb**4*stth**2-Mt**2
     &      /sb**2*stth**2-3D0*Mt**2*sb**2*stth**2+Mt**2
     &      *sb**4*stth**2)
      AAABR(2265) = EE**2/MW**2*Mt/SW**2/cb**2*stth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2266) = EE**2/MW**2*Mb/SW**2/cb**2*sb**2*(1D0
     &      -stth**2)
      AAABR(2267) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2-5D0*sb**2/CW
     &      **2*suth**2+5D0*sb**4/CW**2*suth**2-3D0*sb**2
     &      /SW**2*suth**2+3D0*sb**4/SW**2*suth**2-6D0*Md
     &      **2/MW**2/SW**2*sb**2+6D0*Md**2/MW**2/SW**2*sb
     &      **2*suth**2)
      AAABR(2268) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-5D0*suth**2/CW**2
     &      -9D0*sb**2/SW**2+6D0*sb**4/SW**2-3D0*suth**2
     &      /SW**2+15D0*sb**2/CW**2*suth**2-10D0*sb**4/CW
     &      **2*suth**2+9D0*sb**2/SW**2*suth**2-6D0*sb**4
     &      /SW**2*suth**2+6D0*Md**2/MW**2/SW**2*sb**2-12D0
     &      *Mu**2/MW**2/SW**2*suth**2-6D0*Md**2/MW**2/SW
     &      **2*sb**2*suth**2+6D0*Mu**2/MW**2/SW**2/sb**2
     &      *suth**2+6D0*Mu**2/MW**2/SW**2*sb**2*suth**2)
      AAABR(2269) = EE**2/SW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-suth**2+3D0*sb**2*suth**2-2D0*sb**4*suth
     &      **2)
      AAABR(2270) = EE**2/cb**2*cuth*suth*(5D0/CW**2+3D0
     &      /SW**2-15D0*sb**2/CW**2+10D0*sb**4/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2+12D0*Mu**2/MW**2
     &      /SW**2+6D0*Md**2/MW**2/SW**2*sb**2-6D0*Mu**2
     &      /MW**2/SW**2/sb**2-6D0*Mu**2/MW**2/SW**2*sb**2)
      AAABR(2271) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-5D0*suth**2/CW**2-6D0
     &      *sb**2/SW**2+3D0*sb**4/SW**2-3D0*suth**2/SW**2
     &      +10D0*sb**2/CW**2*suth**2-5D0*sb**4/CW**2*suth
     &      **2+6D0*sb**2/SW**2*suth**2-3D0*sb**4/SW**2*suth
     &      **2-12D0*Mu**2/MW**2/SW**2*suth**2+6D0*Mu**2
     &      /MW**2/SW**2/sb**2*suth**2+6D0*Mu**2/MW**2/SW
     &      **2*sb**2*suth**2)
      AAABR(2272) = EE**2/CW**2/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*suth**2+15D0*sb**2*suth**2-10D0*sb
     &      **4*suth**2)
      AAABR(2273) = EE**2/CW**3*SW/cb**2*(1D0-3D0*sb**2+2D0
     &      *sb**4-5D0*suth**2+15D0*sb**2*suth**2-10D0*sb
     &      **4*suth**2)
      AAABR(2274) = EE**2/MW**2/SW**2/cb**2*(Md**2*sb**2
     &      -2D0*Mu**2*suth**2-Md**2*sb**2*suth**2+Mu**2
     &      /sb**2*suth**2+Mu**2*sb**2*suth**2)
      AAABR(2275) = EE**2/MW**2/SW**2/cb**2*(Md**2*sb**4
     &      +3D0*Mu**2*suth**2-Md**2*sb**4*suth**2-Mu**2
     &      /sb**2*suth**2-3D0*Mu**2*sb**2*suth**2+Mu**2
     &      *sb**4*suth**2)
      AAABR(2276) = EE**2/MW**2*Mu/SW**2/cb**2*suth**2*(2D0
     &      -1D0/sb**2-sb**2)
      AAABR(2277) = EE**2/MW**2*Md/SW**2/cb**2*sb**2*(1D0
     &      -suth**2)
      AAABR(2278) = EE**2/cb**2*cuth*suth*(5D0*sb**2/CW**2
     &      -5D0*sb**4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW
     &      **2-6D0*Md**2/MW**2/SW**2*sb**2)
      AAABR(2279) = EE**2/SW**2/cb**2*cuth*suth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2280) = EE**2/cb**2*(4D0/CW**2-12D0*sb**2/CW
     &      **2+8D0*sb**4/CW**2-5D0*suth**2/CW**2-3D0*suth
     &      **2/SW**2+15D0*sb**2/CW**2*suth**2-10D0*sb**4
     &      /CW**2*suth**2+12D0*Mu**2/MW**2/SW**2+9D0*sb
     &      **2/SW**2*suth**2-6D0*sb**4/SW**2*suth**2-6D0
     &      *Mu**2/MW**2/SW**2/sb**2-6D0*Mu**2/MW**2/SW**2
     &      *sb**2-12D0*Mu**2/MW**2/SW**2*suth**2-6D0*Md
     &      **2/MW**2/SW**2*sb**2*suth**2+6D0*Mu**2/MW**2
     &      /SW**2/sb**2*suth**2+6D0*Mu**2/MW**2/SW**2*sb
     &      **2*suth**2)
      AAABR(2281) = EE**2/cb**2*cuth*suth*(5D0/CW**2+3D0
     &      /SW**2-10D0*sb**2/CW**2+5D0*sb**4/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2+12D0*Mu**2/MW**2/SW
     &      **2-6D0*Mu**2/MW**2/SW**2/sb**2-6D0*Mu**2/MW
     &      **2/SW**2*sb**2)
      AAABR(2282) = EE**2/CW**2/cb**2*cuth*suth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2283) = EE**2/CW**3*SW/cb**2*cuth*suth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2284) = EE**2/MW**2/SW**2/cb**2*cuth*suth*(2D0
     &      *Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2285) = EE**2/MW**2/SW**2/cb**2*cuth*suth*(3D0
     &      *Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2*sb**2
     &      +Mu**2*sb**4)
      AAABR(2286) = EE**2/MW**2*Mu/SW**2/cb**2*cuth*suth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2287) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sb**2
     &      *suth
      AAABR(2288) = EE**2/cb**2*ctth*stth*(5D0*sb**2/CW**2
     &      -5D0*sb**4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW
     &      **2-6D0*Mb**2/MW**2/SW**2*sb**2)
      AAABR(2289) = EE**2/SW**2/cb**2*ctth*stth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2290) = EE**2/cb**2*(4D0/CW**2-12D0*sb**2/CW
     &      **2+8D0*sb**4/CW**2-5D0*stth**2/CW**2-3D0*stth
     &      **2/SW**2+15D0*sb**2/CW**2*stth**2-10D0*sb**4
     &      /CW**2*stth**2+12D0*Mt**2/MW**2/SW**2+9D0*sb
     &      **2/SW**2*stth**2-6D0*sb**4/SW**2*stth**2-6D0
     &      *Mt**2/MW**2/SW**2/sb**2-6D0*Mt**2/MW**2/SW**2
     &      *sb**2-12D0*Mt**2/MW**2/SW**2*stth**2-6D0*Mb
     &      **2/MW**2/SW**2*sb**2*stth**2+6D0*Mt**2/MW**2
     &      /SW**2/sb**2*stth**2+6D0*Mt**2/MW**2/SW**2*sb
     &      **2*stth**2)
      AAABR(2291) = EE**2/cb**2*ctth*stth*(5D0/CW**2+3D0
     &      /SW**2-10D0*sb**2/CW**2+5D0*sb**4/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2+12D0*Mt**2/MW**2/SW
     &      **2-6D0*Mt**2/MW**2/SW**2/sb**2-6D0*Mt**2/MW
     &      **2/SW**2*sb**2)
      AAABR(2292) = EE**2/CW**2/cb**2*ctth*stth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2293) = EE**2/CW**3*SW/cb**2*ctth*stth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2294) = EE**2/MW**2/SW**2/cb**2*ctth*stth*(2D0
     &      *Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2295) = EE**2/MW**2/SW**2/cb**2*ctth*stth*(3D0
     &      *Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2*sb**2
     &      +Mt**2*sb**4)
      AAABR(2296) = EE**2/MW**2*Mt/SW**2/cb**2*ctth*stth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2297) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sb**2
     &      *stth
      AAABR(2298) = EE**2/cb**2*ccth*scth*(5D0*sb**2/CW**2
     &      -5D0*sb**4/CW**2+3D0*sb**2/SW**2-3D0*sb**4/SW
     &      **2-6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(2299) = EE**2/SW**2/cb**2*ccth*scth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2300) = EE**2/cb**2*(4D0/CW**2-12D0*sb**2/CW
     &      **2+8D0*sb**4/CW**2-5D0*scth**2/CW**2-3D0*scth
     &      **2/SW**2+15D0*sb**2/CW**2*scth**2-10D0*sb**4
     &      /CW**2*scth**2+12D0*Mc**2/MW**2/SW**2+9D0*sb
     &      **2/SW**2*scth**2-6D0*sb**4/SW**2*scth**2-6D0
     &      *Mc**2/MW**2/SW**2/sb**2-6D0*Mc**2/MW**2/SW**2
     &      *sb**2-12D0*Mc**2/MW**2/SW**2*scth**2+6D0*Mc
     &      **2/MW**2/SW**2/sb**2*scth**2+6D0*Mc**2/MW**2
     &      /SW**2*sb**2*scth**2-6D0*Ms**2/MW**2/SW**2*sb
     &      **2*scth**2)
      AAABR(2301) = EE**2/cb**2*ccth*scth*(5D0/CW**2+3D0
     &      /SW**2-10D0*sb**2/CW**2+5D0*sb**4/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2+12D0*Mc**2/MW**2/SW
     &      **2-6D0*Mc**2/MW**2/SW**2/sb**2-6D0*Mc**2/MW
     &      **2/SW**2*sb**2)
      AAABR(2302) = EE**2/CW**2/cb**2*ccth*scth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2303) = EE**2/CW**3*SW/cb**2*ccth*scth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2304) = EE**2/MW**2/SW**2/cb**2*ccth*scth*(2D0
     &      *Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2305) = EE**2/MW**2/SW**2/cb**2*ccth*scth*(3D0
     &      *Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2*sb**4
     &      -Ms**2*sb**4)
      AAABR(2306) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*scth
     &      *(2D0-1D0/sb**2-sb**2)
      AAABR(2307) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*sb**2
     &      *scth
      AAABR(2308) = EE**2/cb**2*(4D0*sb**2/CW**2-4D0*sb**4
     &      /CW**2-5D0*sb**2/CW**2*stth**2+5D0*sb**4/CW**2
     &      *stth**2-3D0*sb**2/SW**2*stth**2+3D0*sb**4/SW
     &      **2*stth**2+6D0*Mb**2/MW**2/SW**2*sb**2*stth**2)
      AAABR(2309) = EE**2/SW**2/cb**2*stth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2310) = EE**2/cb**2*(4D0/CW**2-8D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-5D0*stth**2/CW**2-3D0*stth**2
     &      /SW**2+10D0*sb**2/CW**2*stth**2-5D0*sb**4/CW
     &      **2*stth**2+12D0*Mt**2/MW**2/SW**2+6D0*sb**2
     &      /SW**2*stth**2-3D0*sb**4/SW**2*stth**2-6D0*Mt
     &      **2/MW**2/SW**2/sb**2-6D0*Mt**2/MW**2/SW**2*sb
     &      **2-12D0*Mt**2/MW**2/SW**2*stth**2+6D0*Mt**2
     &      /MW**2/SW**2/sb**2*stth**2+6D0*Mt**2/MW**2/SW
     &      **2*sb**2*stth**2)
      AAABR(2311) = EE**2/CW**2/cb**2*(4D0-12D0*sb**2+8D0
     &      *sb**4-5D0*stth**2+15D0*sb**2*stth**2-10D0*sb
     &      **4*stth**2)
      AAABR(2312) = EE**2/CW**3*SW/cb**2*(4D0-12D0*sb**2
     &      +8D0*sb**4-5D0*stth**2+15D0*sb**2*stth**2-10D0
     &      *sb**4*stth**2)
      AAABR(2313) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt**2-Mt
     &      **2/sb**2-Mt**2*sb**2-2D0*Mt**2*stth**2-Mb**2
     &      *sb**2*stth**2+Mt**2/sb**2*stth**2+Mt**2*sb**2
     &      *stth**2)
      AAABR(2314) = EE**2/MW**2/SW**2/cb**2*(3D0*Mt**2-Mt
     &      **2/sb**2-3D0*Mt**2*sb**2+Mt**2*sb**4-3D0*Mt
     &      **2*stth**2+Mb**2*sb**4*stth**2+Mt**2/sb**2*stth
     &      **2+3D0*Mt**2*sb**2*stth**2-Mt**2*sb**4*stth**2)
      AAABR(2315) = EE**2/MW**2*Mt/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*stth**2+stth**2/sb**2+sb**2*stth
     &      **2)
      AAABR(2316) = EE**2/MW**2*Mb/SW**2/cb**2*sb**2*stth**2
      AAABR(2317) = EE**2/cb**2*(4D0*sb**2/CW**2-4D0*sb**4
     &      /CW**2-5D0*sb**2/CW**2*scth**2+5D0*sb**4/CW**2
     &      *scth**2-3D0*sb**2/SW**2*scth**2+3D0*sb**4/SW
     &      **2*scth**2+6D0*Ms**2/MW**2/SW**2*sb**2*scth**2)
      AAABR(2318) = EE**2/SW**2/cb**2*scth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2319) = EE**2/cb**2*(4D0/CW**2-8D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-5D0*scth**2/CW**2-3D0*scth**2
     &      /SW**2+10D0*sb**2/CW**2*scth**2-5D0*sb**4/CW
     &      **2*scth**2+12D0*Mc**2/MW**2/SW**2+6D0*sb**2
     &      /SW**2*scth**2-3D0*sb**4/SW**2*scth**2-6D0*Mc
     &      **2/MW**2/SW**2/sb**2-6D0*Mc**2/MW**2/SW**2*sb
     &      **2-12D0*Mc**2/MW**2/SW**2*scth**2+6D0*Mc**2
     &      /MW**2/SW**2/sb**2*scth**2+6D0*Mc**2/MW**2/SW
     &      **2*sb**2*scth**2)
      AAABR(2320) = EE**2/CW**2/cb**2*(4D0-12D0*sb**2+8D0
     &      *sb**4-5D0*scth**2+15D0*sb**2*scth**2-10D0*sb
     &      **4*scth**2)
      AAABR(2321) = EE**2/CW**3*SW/cb**2*(4D0-12D0*sb**2
     &      +8D0*sb**4-5D0*scth**2+15D0*sb**2*scth**2-10D0
     &      *sb**4*scth**2)
      AAABR(2322) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2-Mc
     &      **2/sb**2-Mc**2*sb**2-2D0*Mc**2*scth**2+Mc**2
     &      /sb**2*scth**2+Mc**2*sb**2*scth**2-Ms**2*sb**2
     &      *scth**2)
      AAABR(2323) = EE**2/MW**2/SW**2/cb**2*(3D0*Mc**2-Mc
     &      **2/sb**2-3D0*Mc**2*sb**2+Mc**2*sb**4-3D0*Mc
     &      **2*scth**2+Mc**2/sb**2*scth**2+3D0*Mc**2*sb
     &      **2*scth**2-Mc**2*sb**4*scth**2+Ms**2*sb**4*scth
     &      **2)
      AAABR(2324) = EE**2/MW**2*Mc/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*scth**2+scth**2/sb**2+sb**2*scth
     &      **2)
      AAABR(2325) = EE**2/MW**2*Ms/SW**2/cb**2*sb**2*scth**2
      AAABR(2326) = EE**2/cb**2*(4D0*sb**2/CW**2-4D0*sb**4
     &      /CW**2-5D0*sb**2/CW**2*suth**2+5D0*sb**4/CW**2
     &      *suth**2-3D0*sb**2/SW**2*suth**2+3D0*sb**4/SW
     &      **2*suth**2+6D0*Md**2/MW**2/SW**2*sb**2*suth**2)
      AAABR(2327) = EE**2/SW**2/cb**2*suth**2*(1D0-3D0*sb
     &      **2+2D0*sb**4)
      AAABR(2328) = EE**2/cb**2*(4D0/CW**2-8D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-5D0*suth**2/CW**2-3D0*suth**2
     &      /SW**2+10D0*sb**2/CW**2*suth**2-5D0*sb**4/CW
     &      **2*suth**2+12D0*Mu**2/MW**2/SW**2+6D0*sb**2
     &      /SW**2*suth**2-3D0*sb**4/SW**2*suth**2-6D0*Mu
     &      **2/MW**2/SW**2/sb**2-6D0*Mu**2/MW**2/SW**2*sb
     &      **2-12D0*Mu**2/MW**2/SW**2*suth**2+6D0*Mu**2
     &      /MW**2/SW**2/sb**2*suth**2+6D0*Mu**2/MW**2/SW
     &      **2*sb**2*suth**2)
      AAABR(2329) = EE**2/CW**2/cb**2*(4D0-12D0*sb**2+8D0
     &      *sb**4-5D0*suth**2+15D0*sb**2*suth**2-10D0*sb
     &      **4*suth**2)
      AAABR(2330) = EE**2/CW**3*SW/cb**2*(4D0-12D0*sb**2
     &      +8D0*sb**4-5D0*suth**2+15D0*sb**2*suth**2-10D0
     &      *sb**4*suth**2)
      AAABR(2331) = EE**2/MW**2/SW**2/cb**2*(2D0*Mu**2-Mu
     &      **2/sb**2-Mu**2*sb**2-2D0*Mu**2*suth**2-Md**2
     &      *sb**2*suth**2+Mu**2/sb**2*suth**2+Mu**2*sb**2
     &      *suth**2)
      AAABR(2332) = EE**2/MW**2/SW**2/cb**2*(3D0*Mu**2-Mu
     &      **2/sb**2-3D0*Mu**2*sb**2+Mu**2*sb**4-3D0*Mu
     &      **2*suth**2+Md**2*sb**4*suth**2+Mu**2/sb**2*suth
     &      **2+3D0*Mu**2*sb**2*suth**2-Mu**2*sb**4*suth**2)
      AAABR(2333) = EE**2/MW**2*Mu/SW**2/cb**2*(2D0-1D0/sb
     &      **2-sb**2-2D0*suth**2+suth**2/sb**2+sb**2*suth
     &      **2)
      AAABR(2334) = EE**2/MW**2*Md/SW**2/cb**2*sb**2*suth**2
      AAABR(2335) = EE**2*(1D0/CW**2+1D0/SW**2-8D0*sb**2
     &      /CW**2+8D0*sb**4/CW**2-8D0*sb**2/SW**2+8D0*sb
     &      **4/SW**2)
      AAABR(2336) = EE**2/SW**2*(1D0-8D0*sb**2+8D0*sb**4)
      AAABR(2337) = EE**2/CW**2*(1D0-8D0*sb**2+8D0*sb**4)
      AAABR(2338) = EE**2/CW**3*SW*(1D0-8D0*sb**2+8D0*sb**4)
      AAABR(2339) = EE**2*(sb**2/CW**2-2D0*sb**4/CW**2+3D0
     &      *sb**2/SW**2-2D0*sb**4/SW**2)
      AAABR(2340) = EE**2*(1D0/CW**2-1D0/SW**2-4D0*sb**2
     &      /CW**2+4D0*sb**4/CW**2-4D0*sb**2/SW**2+4D0*sb
     &      **4/SW**2)
      AAABR(2341) = EE**2/SW**2*(1D0+4D0*sb**2-4D0*sb**4)
      AAABR(2342) = EE**2*(1D0/CW**2-1D0/SW**2-3D0*sb**2
     &      /CW**2+2D0*sb**4/CW**2-sb**2/SW**2+2D0*sb**4
     &      /SW**2)
      AAABR(2343) = EE**2*(sb**2/CW**2+sb**2/SW**2-2D0*sa
     &      **2/CW**2*sb**2+2D0*ca/SW**2*cb*sa*sb)
      AAABR(2344) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sa**2
     &      /CW**2-sb**2/CW**2+sb**2/SW**2+2D0*sa**2/CW**2
     &      *sb**2-2D0*ca/SW**2*cb*sa*sb)
      AAABR(2345) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sa**2
     &      /CW**2-2D0*sb**2/CW**2+4D0*sa**2/CW**2*sb**2
     &      -4D0*ca/SW**2*cb*sa*sb)
      AAABR(2346) = EE**2/SW**2*(1D0+4D0*ca*cb*sa*sb)
      AAABR(2347) = EE**2*(ca/CW**2*sa+cb/SW**2*sb-2D0*ca
     &      /CW**2*sa*sb**2-2D0*cb/SW**2*sa**2*sb)
      AAABR(2348) = EE**2/CW**2*(1D0-2D0*sa**2-2D0*sb**2
     &      +4D0*sa**2*sb**2)
      AAABR(2349) = EE**2/CW**3*SW*(1D0-2D0*sa**2-2D0*sb
     &      **2+4D0*sa**2*sb**2)
      AAABR(2350) = EE**2*(sb**2/CW**2-sb**2/SW**2-2D0*sa
     &      **2/CW**2*sb**2+2D0*ca/SW**2*cb*sa*sb)
      AAABR(2351) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sa**2
     &      /CW**2-2D0*sb**2/CW**2+4D0*sa**2/CW**2*sb**2
     &      -4D0*ca/SW**2*cb*sa*sb)
      AAABR(2352) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sa**2
     &      /CW**2-sb**2/CW**2-sb**2/SW**2+2D0*sa**2/CW**2
     &      *sb**2-2D0*ca/SW**2*cb*sa*sb)
      AAABR(2353) = EE**2/SW**2*(1D0-4D0*ca*cb*sa*sb)
      AAABR(2354) = EE**2*(cb/SW**2*sb-2D0*ca/CW**2*sa*sb
     &      **2-2D0*cb/SW**2*sa**2*sb)
      AAABR(2355) = EE**2*(2D0*ca/CW**2*sa+cb/SW**2*sb-2D0
     &      *ca/CW**2*sa*sb**2-2D0*cb/SW**2*sa**2*sb)
      AAABR(2356) = EE**2/SW**2*cb*sb*(1D0-2D0*sa**2)
      AAABR(2357) = EE**2/CW**2*ca*sa*(1D0-2D0*sb**2)
      AAABR(2358) = EE**2/CW**3*SW*ca*sa*(1D0-2D0*sb**2)
      AAABR(2359) = EE**2/SW**2*Sqrt2/cb**2*clth*(sb**2-sb
     &      **4-Ml**2/MW**2*sb**2)
      AAABR(2360) = EE**2/SW**2*Sqrt2/cb**2*clth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Ml**2/MW**2*sb**2)
      AAABR(2361) = EE**2/SW**2*Sqrt2/cb**2*clth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2362) = EE**2/SW**2*Sqrt2/cb**2*slth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Ml**2/MW**2*sb**2)
      AAABR(2363) = EE**2/SW**2*Sqrt2/cb**2*clth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2364) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*clth
     &      *sb**2
      AAABR(2365) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*clth
     &      *sb**4
      AAABR(2366) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb**2*clth
     &      *sb**2
      AAABR(2367) = EE**2/SW**2*Sqrt2/cb**2*cmuth*(sb**2
     &      -sb**4-Mm**2/MW**2*sb**2)
      AAABR(2368) = EE**2/SW**2*Sqrt2/cb**2*cmuth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Mm**2/MW**2*sb**2)
      AAABR(2369) = EE**2/SW**2*Sqrt2/cb**2*cmuth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2370) = EE**2/SW**2*Sqrt2/cb**2*smuth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Mm**2/MW**2*sb**2)
      AAABR(2371) = EE**2/SW**2*Sqrt2/cb**2*cmuth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2372) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*cmuth
     &      *sb**2
      AAABR(2373) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*cmuth
     &      *sb**4
      AAABR(2374) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb**2*cmuth
     &      *sb**2
      AAABR(2375) = EE**2/SW**2*Sqrt2/cb**2*ceth*(sb**2-sb
     &      **4-Me**2/MW**2*sb**2)
      AAABR(2376) = EE**2/SW**2*Sqrt2/cb**2*ceth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Me**2/MW**2*sb**2)
      AAABR(2377) = EE**2/SW**2*Sqrt2/cb**2*ceth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2378) = EE**2/SW**2*Sqrt2/cb**2*seth*(1D0-3D0
     &      *sb**2+2D0*sb**4+Me**2/MW**2*sb**2)
      AAABR(2379) = EE**2/SW**2*Sqrt2/cb**2*ceth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2380) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*ceth
     &      *sb**2
      AAABR(2381) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*ceth
     &      *sb**4
      AAABR(2382) = EE**2/MW**2*Me/SW**2*Sqrt2/cb**2*ceth
     &      *sb**2
      AAABR(2383) = EE**2/SW**2*Sqrt2/cb**2*seth*(sb**2-sb
     &      **4-Me**2/MW**2*sb**2)
      AAABR(2384) = EE**2/SW**2*Sqrt2/cb**2*seth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2385) = EE**2/SW**2*Sqrt2/cb**2*seth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2386) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*sb
     &      **2*seth
      AAABR(2387) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*sb
     &      **4*seth
      AAABR(2388) = EE**2/MW**2*Me/SW**2*Sqrt2/cb**2*sb**2
     &      *seth
      AAABR(2389) = EE**2/SW**2*Sqrt2/cb**2*slth*(sb**2-sb
     &      **4-Ml**2/MW**2*sb**2)
      AAABR(2390) = EE**2/SW**2*Sqrt2/cb**2*slth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2391) = EE**2/SW**2*Sqrt2/cb**2*slth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2392) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*sb
     &      **2*slth
      AAABR(2393) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*sb
     &      **4*slth
      AAABR(2394) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb**2*sb**2
     &      *slth
      AAABR(2395) = EE**2/SW**2*Sqrt2/cb**2*smuth*(sb**2
     &      -sb**4-Mm**2/MW**2*sb**2)
      AAABR(2396) = EE**2/SW**2*Sqrt2/cb**2*smuth*(1D0-3D0
     &      *sb**2+2D0*sb**4)
      AAABR(2397) = EE**2/SW**2*Sqrt2/cb**2*smuth*(1D0-2D0
     &      *sb**2+sb**4)
      AAABR(2398) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*sb
     &      **2*smuth
      AAABR(2399) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*sb
     &      **4*smuth
      AAABR(2400) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb**2*sb**2
     &      *smuth
      AAABR(2401) = EE**2/SW**2*Sqrt2/cb**2*(ccth*csth*sb
     &      **2-ccth*csth*sb**4-Mc/MW**2*Ms*scth*ssth-Ms
     &      **2/MW**2*ccth*csth*sb**2+Mc/MW**2*Ms*sb**2*scth
     &      *ssth)
      AAABR(2402) = EE**2/SW**2*Sqrt2/cb**2*(ccth*csth*sb
     &      **2-ccth*csth*sb**4+Mc/MW**2*Ms*scth*ssth-Ms
     &      **2/MW**2*ccth*csth*sb**2-Mc/MW**2*Ms*sb**2*scth
     &      *ssth)
      AAABR(2403) = EE**2/SW**2*Sqrt2/cb**2*ccth*csth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mc**2/MW**2-Mc**2/MW
     &      **2/sb**2-Mc**2/MW**2*sb**2+Ms**2/MW**2*sb**2)
      AAABR(2404) = EE**2/SW**2*Sqrt2/cb**2*ccth*csth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2405) = EE**2/SW**2*Sqrt2/cb**2*ccth*ssth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mc**2/MW**2-Mc**2/MW
     &      **2/sb**2-Mc**2/MW**2*sb**2+Ms**2/MW**2*sb**2)
      AAABR(2406) = EE**2/SW**2*Sqrt2/cb**2*csth*scth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mc**2/MW**2-Mc**2/MW
     &      **2/sb**2-Mc**2/MW**2*sb**2+Ms**2/MW**2*sb**2)
      AAABR(2407) = EE**2/SW**2*Sqrt2/cb**2*(ccth*csth-2D0
     &      *ccth*csth*sb**2+ccth*csth*sb**4+2D0*Mc**2/MW
     &      **2*ccth*csth-Mc/MW**2*Ms*scth*ssth-Mc**2/MW
     &      **2*ccth*csth/sb**2-Mc**2/MW**2*ccth*csth*sb
     &      **2+Mc/MW**2*Ms*sb**2*scth*ssth)
      AAABR(2408) = EE**2/SW**2*Sqrt2/cb**2*(ccth*csth-2D0
     &      *ccth*csth*sb**2+ccth*csth*sb**4+2D0*Mc**2/MW
     &      **2*ccth*csth+Mc/MW**2*Ms*scth*ssth-Mc**2/MW
     &      **2*ccth*csth/sb**2-Mc**2/MW**2*ccth*csth*sb
     &      **2-Mc/MW**2*Ms*sb**2*scth*ssth)
      AAABR(2409) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ccth*csth
     &      *(2D0*Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2410) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ccth*csth
     &      *(3D0*Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2
     &      *sb**4-Ms**2*sb**4)
      AAABR(2411) = EE**2/MW**2*Mc/SW**2*Sqrt2/cb**2*ccth
     &      *csth*(2D0-1D0/sb**2-sb**2)
      AAABR(2412) = EE**2/MW**2*Ms/SW**2*Sqrt2/cb**2*ccth
     &      *csth*sb**2
      AAABR(2413) = EE**2/SW**2*Sqrt2/cb**2*(cdth*cuth*sb
     &      **2-cdth*cuth*sb**4-Md/MW**2*Mu*sdth*suth-Md
     &      **2/MW**2*cdth*cuth*sb**2+Md/MW**2*Mu*sb**2*sdth
     &      *suth)
      AAABR(2414) = EE**2/SW**2*Sqrt2/cb**2*(cdth*cuth*sb
     &      **2-cdth*cuth*sb**4+Md/MW**2*Mu*sdth*suth-Md
     &      **2/MW**2*cdth*cuth*sb**2-Md/MW**2*Mu*sb**2*sdth
     &      *suth)
      AAABR(2415) = EE**2/SW**2*Sqrt2/cb**2*cdth*cuth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mu**2/MW**2+Md**2/MW
     &      **2*sb**2-Mu**2/MW**2/sb**2-Mu**2/MW**2*sb**2)
      AAABR(2416) = EE**2/SW**2*Sqrt2/cb**2*cdth*cuth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2417) = EE**2/SW**2*Sqrt2/cb**2*cuth*sdth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mu**2/MW**2+Md**2/MW
     &      **2*sb**2-Mu**2/MW**2/sb**2-Mu**2/MW**2*sb**2)
      AAABR(2418) = EE**2/SW**2*Sqrt2/cb**2*cdth*suth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mu**2/MW**2+Md**2/MW
     &      **2*sb**2-Mu**2/MW**2/sb**2-Mu**2/MW**2*sb**2)
      AAABR(2419) = EE**2/SW**2*Sqrt2/cb**2*(cdth*cuth-2D0
     &      *cdth*cuth*sb**2+cdth*cuth*sb**4+2D0*Mu**2/MW
     &      **2*cdth*cuth-Md/MW**2*Mu*sdth*suth-Mu**2/MW
     &      **2*cdth*cuth/sb**2-Mu**2/MW**2*cdth*cuth*sb
     &      **2+Md/MW**2*Mu*sb**2*sdth*suth)
      AAABR(2420) = EE**2/SW**2*Sqrt2/cb**2*(cdth*cuth-2D0
     &      *cdth*cuth*sb**2+cdth*cuth*sb**4+2D0*Mu**2/MW
     &      **2*cdth*cuth+Md/MW**2*Mu*sdth*suth-Mu**2/MW
     &      **2*cdth*cuth/sb**2-Mu**2/MW**2*cdth*cuth*sb
     &      **2-Md/MW**2*Mu*sb**2*sdth*suth)
      AAABR(2421) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cdth*cuth
     &      *(2D0*Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2422) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cdth*cuth
     &      *(3D0*Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2
     &      *sb**2+Mu**2*sb**4)
      AAABR(2423) = EE**2/MW**2*Mu/SW**2*Sqrt2/cb**2*cdth
     &      *cuth*(2D0-1D0/sb**2-sb**2)
      AAABR(2424) = EE**2/MW**2*Md/SW**2*Sqrt2/cb**2*cdth
     &      *cuth*sb**2
      AAABR(2425) = EE**2/SW**2*Sqrt2/cb**2*(cbth*ctth*sb
     &      **2-cbth*ctth*sb**4-Mb/MW**2*Mt*sbth*stth-Mb
     &      **2/MW**2*cbth*ctth*sb**2+Mb/MW**2*Mt*sb**2*sbth
     &      *stth)
      AAABR(2426) = EE**2/SW**2*Sqrt2/cb**2*(cbth*ctth*sb
     &      **2-cbth*ctth*sb**4+Mb/MW**2*Mt*sbth*stth-Mb
     &      **2/MW**2*cbth*ctth*sb**2-Mb/MW**2*Mt*sb**2*sbth
     &      *stth)
      AAABR(2427) = EE**2/SW**2*Sqrt2/cb**2*cbth*ctth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mt**2/MW**2+Mb**2/MW
     &      **2*sb**2-Mt**2/MW**2/sb**2-Mt**2/MW**2*sb**2)
      AAABR(2428) = EE**2/SW**2*Sqrt2/cb**2*cbth*ctth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2429) = EE**2/SW**2*Sqrt2/cb**2*ctth*sbth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mt**2/MW**2+Mb**2/MW
     &      **2*sb**2-Mt**2/MW**2/sb**2-Mt**2/MW**2*sb**2)
      AAABR(2430) = EE**2/SW**2*Sqrt2/cb**2*cbth*stth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mt**2/MW**2+Mb**2/MW
     &      **2*sb**2-Mt**2/MW**2/sb**2-Mt**2/MW**2*sb**2)
      AAABR(2431) = EE**2/SW**2*Sqrt2/cb**2*(cbth*ctth-2D0
     &      *cbth*ctth*sb**2+cbth*ctth*sb**4+2D0*Mt**2/MW
     &      **2*cbth*ctth-Mb/MW**2*Mt*sbth*stth-Mt**2/MW
     &      **2*cbth*ctth/sb**2-Mt**2/MW**2*cbth*ctth*sb
     &      **2+Mb/MW**2*Mt*sb**2*sbth*stth)
      AAABR(2432) = EE**2/SW**2*Sqrt2/cb**2*(cbth*ctth-2D0
     &      *cbth*ctth*sb**2+cbth*ctth*sb**4+2D0*Mt**2/MW
     &      **2*cbth*ctth+Mb/MW**2*Mt*sbth*stth-Mt**2/MW
     &      **2*cbth*ctth/sb**2-Mt**2/MW**2*cbth*ctth*sb
     &      **2-Mb/MW**2*Mt*sb**2*sbth*stth)
      AAABR(2433) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cbth*ctth
     &      *(2D0*Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2434) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cbth*ctth
     &      *(3D0*Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2
     &      *sb**2+Mt**2*sb**4)
      AAABR(2435) = EE**2/MW**2*Mt/SW**2*Sqrt2/cb**2*cbth
     &      *ctth*(2D0-1D0/sb**2-sb**2)
      AAABR(2436) = EE**2/MW**2*Mb/SW**2*Sqrt2/cb**2*cbth
     &      *ctth*sb**2
      AAABR(2437) = EE**2/SW**2*Sqrt2/cb**2*(cuth*sb**2*sdth
     &      -cuth*sb**4*sdth+Md/MW**2*Mu*cdth*suth-Md**2
     &      /MW**2*cuth*sb**2*sdth-Md/MW**2*Mu*cdth*sb**2
     &      *suth)
      AAABR(2438) = EE**2/SW**2*Sqrt2/cb**2*(cuth*sb**2*sdth
     &      -cuth*sb**4*sdth-Md/MW**2*Mu*cdth*suth-Md**2
     &      /MW**2*cuth*sb**2*sdth+Md/MW**2*Mu*cdth*sb**2
     &      *suth)
      AAABR(2439) = EE**2/SW**2*Sqrt2/cb**2*cuth*sdth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2440) = EE**2/SW**2*Sqrt2/cb**2*sdth*suth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mu**2/MW**2+Md**2/MW
     &      **2*sb**2-Mu**2/MW**2/sb**2-Mu**2/MW**2*sb**2)
      AAABR(2441) = EE**2/SW**2*Sqrt2/cb**2*(cuth*sdth-2D0
     &      *cuth*sb**2*sdth+cuth*sb**4*sdth+2D0*Mu**2/MW
     &      **2*cuth*sdth+Md/MW**2*Mu*cdth*suth-Mu**2/MW
     &      **2*cuth/sb**2*sdth-Mu**2/MW**2*cuth*sb**2*sdth
     &      -Md/MW**2*Mu*cdth*sb**2*suth)
      AAABR(2442) = EE**2/SW**2*Sqrt2/cb**2*(cuth*sdth-2D0
     &      *cuth*sb**2*sdth+cuth*sb**4*sdth+2D0*Mu**2/MW
     &      **2*cuth*sdth-Md/MW**2*Mu*cdth*suth-Mu**2/MW
     &      **2*cuth/sb**2*sdth-Mu**2/MW**2*cuth*sb**2*sdth
     &      +Md/MW**2*Mu*cdth*sb**2*suth)
      AAABR(2443) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cuth*sdth
     &      *(2D0*Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2444) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cuth*sdth
     &      *(3D0*Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2
     &      *sb**2+Mu**2*sb**4)
      AAABR(2445) = EE**2/MW**2*Mu/SW**2*Sqrt2/cb**2*cuth
     &      *sdth*(2D0-1D0/sb**2-sb**2)
      AAABR(2446) = EE**2/MW**2*Md/SW**2*Sqrt2/cb**2*cuth
     &      *sb**2*sdth
      AAABR(2447) = EE**2/SW**2*Sqrt2/cb**2*(ccth*sb**2*ssth
     &      -ccth*sb**4*ssth+Mc/MW**2*Ms*csth*scth-Ms**2
     &      /MW**2*ccth*sb**2*ssth-Mc/MW**2*Ms*csth*sb**2
     &      *scth)
      AAABR(2448) = EE**2/SW**2*Sqrt2/cb**2*(ccth*sb**2*ssth
     &      -ccth*sb**4*ssth-Mc/MW**2*Ms*csth*scth-Ms**2
     &      /MW**2*ccth*sb**2*ssth+Mc/MW**2*Ms*csth*sb**2
     &      *scth)
      AAABR(2449) = EE**2/SW**2*Sqrt2/cb**2*ccth*ssth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2450) = EE**2/SW**2*Sqrt2/cb**2*scth*ssth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mc**2/MW**2-Mc**2/MW
     &      **2/sb**2-Mc**2/MW**2*sb**2+Ms**2/MW**2*sb**2)
      AAABR(2451) = EE**2/SW**2*Sqrt2/cb**2*(ccth*ssth-2D0
     &      *ccth*sb**2*ssth+ccth*sb**4*ssth+2D0*Mc**2/MW
     &      **2*ccth*ssth+Mc/MW**2*Ms*csth*scth-Mc**2/MW
     &      **2*ccth/sb**2*ssth-Mc**2/MW**2*ccth*sb**2*ssth
     &      -Mc/MW**2*Ms*csth*sb**2*scth)
      AAABR(2452) = EE**2/SW**2*Sqrt2/cb**2*(ccth*ssth-2D0
     &      *ccth*sb**2*ssth+ccth*sb**4*ssth+2D0*Mc**2/MW
     &      **2*ccth*ssth-Mc/MW**2*Ms*csth*scth-Mc**2/MW
     &      **2*ccth/sb**2*ssth-Mc**2/MW**2*ccth*sb**2*ssth
     &      +Mc/MW**2*Ms*csth*sb**2*scth)
      AAABR(2453) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ccth*ssth
     &      *(2D0*Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2454) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ccth*ssth
     &      *(3D0*Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2
     &      *sb**4-Ms**2*sb**4)
      AAABR(2455) = EE**2/MW**2*Mc/SW**2*Sqrt2/cb**2*ccth
     &      *ssth*(2D0-1D0/sb**2-sb**2)
      AAABR(2456) = EE**2/MW**2*Ms/SW**2*Sqrt2/cb**2*ccth
     &      *sb**2*ssth
      AAABR(2457) = EE**2/SW**2*Sqrt2/cb**2*(ctth*sb**2*sbth
     &      -ctth*sb**4*sbth+Mb/MW**2*Mt*cbth*stth-Mb**2
     &      /MW**2*ctth*sb**2*sbth-Mb/MW**2*Mt*cbth*sb**2
     &      *stth)
      AAABR(2458) = EE**2/SW**2*Sqrt2/cb**2*(ctth*sb**2*sbth
     &      -ctth*sb**4*sbth-Mb/MW**2*Mt*cbth*stth-Mb**2
     &      /MW**2*ctth*sb**2*sbth+Mb/MW**2*Mt*cbth*sb**2
     &      *stth)
      AAABR(2459) = EE**2/SW**2*Sqrt2/cb**2*ctth*sbth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2460) = EE**2/SW**2*Sqrt2/cb**2*sbth*stth*(1D0
     &      -3D0*sb**2+2D0*sb**4+2D0*Mt**2/MW**2+Mb**2/MW
     &      **2*sb**2-Mt**2/MW**2/sb**2-Mt**2/MW**2*sb**2)
      AAABR(2461) = EE**2/SW**2*Sqrt2/cb**2*(ctth*sbth-2D0
     &      *ctth*sb**2*sbth+ctth*sb**4*sbth+2D0*Mt**2/MW
     &      **2*ctth*sbth+Mb/MW**2*Mt*cbth*stth-Mt**2/MW
     &      **2*ctth/sb**2*sbth-Mt**2/MW**2*ctth*sb**2*sbth
     &      -Mb/MW**2*Mt*cbth*sb**2*stth)
      AAABR(2462) = EE**2/SW**2*Sqrt2/cb**2*(ctth*sbth-2D0
     &      *ctth*sb**2*sbth+ctth*sb**4*sbth+2D0*Mt**2/MW
     &      **2*ctth*sbth-Mb/MW**2*Mt*cbth*stth-Mt**2/MW
     &      **2*ctth/sb**2*sbth-Mt**2/MW**2*ctth*sb**2*sbth
     &      +Mb/MW**2*Mt*cbth*sb**2*stth)
      AAABR(2463) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ctth*sbth
     &      *(2D0*Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2464) = EE**2/MW**2/SW**2*Sqrt2/cb**2*ctth*sbth
     &      *(3D0*Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2
     &      *sb**2+Mt**2*sb**4)
      AAABR(2465) = EE**2/MW**2*Mt/SW**2*Sqrt2/cb**2*ctth
     &      *sbth*(2D0-1D0/sb**2-sb**2)
      AAABR(2466) = EE**2/MW**2*Mb/SW**2*Sqrt2/cb**2*ctth
     &      *sb**2*sbth
      AAABR(2467) = EE**2/SW**2*Sqrt2/cb**2*(cbth*sb**2*stth
     &      -cbth*sb**4*stth+Mb/MW**2*Mt*ctth*sbth-Mb**2
     &      /MW**2*cbth*sb**2*stth-Mb/MW**2*Mt*ctth*sb**2
     &      *sbth)
      AAABR(2468) = EE**2/SW**2*Sqrt2/cb**2*(cbth*sb**2*stth
     &      -cbth*sb**4*stth-Mb/MW**2*Mt*ctth*sbth-Mb**2
     &      /MW**2*cbth*sb**2*stth+Mb/MW**2*Mt*ctth*sb**2
     &      *sbth)
      AAABR(2469) = EE**2/SW**2*Sqrt2/cb**2*cbth*stth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2470) = EE**2/SW**2*Sqrt2/cb**2*(cbth*stth-2D0
     &      *cbth*sb**2*stth+cbth*sb**4*stth+2D0*Mt**2/MW
     &      **2*cbth*stth+Mb/MW**2*Mt*ctth*sbth-Mt**2/MW
     &      **2*cbth/sb**2*stth-Mt**2/MW**2*cbth*sb**2*stth
     &      -Mb/MW**2*Mt*ctth*sb**2*sbth)
      AAABR(2471) = EE**2/SW**2*Sqrt2/cb**2*(cbth*stth-2D0
     &      *cbth*sb**2*stth+cbth*sb**4*stth+2D0*Mt**2/MW
     &      **2*cbth*stth-Mb/MW**2*Mt*ctth*sbth-Mt**2/MW
     &      **2*cbth/sb**2*stth-Mt**2/MW**2*cbth*sb**2*stth
     &      +Mb/MW**2*Mt*ctth*sb**2*sbth)
      AAABR(2472) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cbth*stth
     &      *(2D0*Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2473) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cbth*stth
     &      *(3D0*Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2
     &      *sb**2+Mt**2*sb**4)
      AAABR(2474) = EE**2/MW**2*Mt/SW**2*Sqrt2/cb**2*cbth
     &      *stth*(2D0-1D0/sb**2-sb**2)
      AAABR(2475) = EE**2/MW**2*Mb/SW**2*Sqrt2/cb**2*cbth
     &      *sb**2*stth
      AAABR(2476) = EE**2/SW**2*Sqrt2/cb**2*(cdth*sb**2*suth
     &      -cdth*sb**4*suth+Md/MW**2*Mu*cuth*sdth-Md**2
     &      /MW**2*cdth*sb**2*suth-Md/MW**2*Mu*cuth*sb**2
     &      *sdth)
      AAABR(2477) = EE**2/SW**2*Sqrt2/cb**2*(cdth*sb**2*suth
     &      -cdth*sb**4*suth-Md/MW**2*Mu*cuth*sdth-Md**2
     &      /MW**2*cdth*sb**2*suth+Md/MW**2*Mu*cuth*sb**2
     &      *sdth)
      AAABR(2478) = EE**2/SW**2*Sqrt2/cb**2*cdth*suth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2479) = EE**2/SW**2*Sqrt2/cb**2*(cdth*suth-2D0
     &      *cdth*sb**2*suth+cdth*sb**4*suth+2D0*Mu**2/MW
     &      **2*cdth*suth+Md/MW**2*Mu*cuth*sdth-Mu**2/MW
     &      **2*cdth/sb**2*suth-Mu**2/MW**2*cdth*sb**2*suth
     &      -Md/MW**2*Mu*cuth*sb**2*sdth)
      AAABR(2480) = EE**2/SW**2*Sqrt2/cb**2*(cdth*suth-2D0
     &      *cdth*sb**2*suth+cdth*sb**4*suth+2D0*Mu**2/MW
     &      **2*cdth*suth-Md/MW**2*Mu*cuth*sdth-Mu**2/MW
     &      **2*cdth/sb**2*suth-Mu**2/MW**2*cdth*sb**2*suth
     &      +Md/MW**2*Mu*cuth*sb**2*sdth)
      AAABR(2481) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cdth*suth
     &      *(2D0*Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2482) = EE**2/MW**2/SW**2*Sqrt2/cb**2*cdth*suth
     &      *(3D0*Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2
     &      *sb**2+Mu**2*sb**4)
      AAABR(2483) = EE**2/MW**2*Mu/SW**2*Sqrt2/cb**2*cdth
     &      *suth*(2D0-1D0/sb**2-sb**2)
      AAABR(2484) = EE**2/MW**2*Md/SW**2*Sqrt2/cb**2*cdth
     &      *sb**2*suth
      AAABR(2485) = EE**2/SW**2*Sqrt2/cb**2*(csth*sb**2*scth
     &      -csth*sb**4*scth+Mc/MW**2*Ms*ccth*ssth-Ms**2
     &      /MW**2*csth*sb**2*scth-Mc/MW**2*Ms*ccth*sb**2
     &      *ssth)
      AAABR(2486) = EE**2/SW**2*Sqrt2/cb**2*(csth*sb**2*scth
     &      -csth*sb**4*scth-Mc/MW**2*Ms*ccth*ssth-Ms**2
     &      /MW**2*csth*sb**2*scth+Mc/MW**2*Ms*ccth*sb**2
     &      *ssth)
      AAABR(2487) = EE**2/SW**2*Sqrt2/cb**2*csth*scth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2488) = EE**2/SW**2*Sqrt2/cb**2*(csth*scth-2D0
     &      *csth*sb**2*scth+csth*sb**4*scth+2D0*Mc**2/MW
     &      **2*csth*scth+Mc/MW**2*Ms*ccth*ssth-Mc**2/MW
     &      **2*csth/sb**2*scth-Mc**2/MW**2*csth*sb**2*scth
     &      -Mc/MW**2*Ms*ccth*sb**2*ssth)
      AAABR(2489) = EE**2/SW**2*Sqrt2/cb**2*(csth*scth-2D0
     &      *csth*sb**2*scth+csth*sb**4*scth+2D0*Mc**2/MW
     &      **2*csth*scth-Mc/MW**2*Ms*ccth*ssth-Mc**2/MW
     &      **2*csth/sb**2*scth-Mc**2/MW**2*csth*sb**2*scth
     &      +Mc/MW**2*Ms*ccth*sb**2*ssth)
      AAABR(2490) = EE**2/MW**2/SW**2*Sqrt2/cb**2*csth*scth
     &      *(2D0*Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2491) = EE**2/MW**2/SW**2*Sqrt2/cb**2*csth*scth
     &      *(3D0*Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2
     &      *sb**4-Ms**2*sb**4)
      AAABR(2492) = EE**2/MW**2*Mc/SW**2*Sqrt2/cb**2*csth
     &      *scth*(2D0-1D0/sb**2-sb**2)
      AAABR(2493) = EE**2/MW**2*Ms/SW**2*Sqrt2/cb**2*csth
     &      *sb**2*scth
      AAABR(2494) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*sdth*suth
     &      -sb**4*sdth*suth-Md/MW**2*Mu*cdth*cuth-Md**2
     &      /MW**2*sb**2*sdth*suth+Md/MW**2*Mu*cdth*cuth
     &      *sb**2)
      AAABR(2495) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*sdth*suth
     &      -sb**4*sdth*suth+Md/MW**2*Mu*cdth*cuth-Md**2
     &      /MW**2*sb**2*sdth*suth-Md/MW**2*Mu*cdth*cuth
     &      *sb**2)
      AAABR(2496) = EE**2/SW**2*Sqrt2/cb**2*sdth*suth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2497) = EE**2/SW**2*Sqrt2/cb**2*(sdth*suth-2D0
     &      *sb**2*sdth*suth+sb**4*sdth*suth+2D0*Mu**2/MW
     &      **2*sdth*suth-Md/MW**2*Mu*cdth*cuth-Mu**2/MW
     &      **2/sb**2*sdth*suth-Mu**2/MW**2*sb**2*sdth*suth
     &      +Md/MW**2*Mu*cdth*cuth*sb**2)
      AAABR(2498) = EE**2/SW**2*Sqrt2/cb**2*(sdth*suth-2D0
     &      *sb**2*sdth*suth+sb**4*sdth*suth+2D0*Mu**2/MW
     &      **2*sdth*suth+Md/MW**2*Mu*cdth*cuth-Mu**2/MW
     &      **2/sb**2*sdth*suth-Mu**2/MW**2*sb**2*sdth*suth
     &      -Md/MW**2*Mu*cdth*cuth*sb**2)
      AAABR(2499) = EE**2/MW**2/SW**2*Sqrt2/cb**2*sdth*suth
     &      *(2D0*Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2*sb**2)
      AAABR(2500) = EE**2/MW**2/SW**2*Sqrt2/cb**2*sdth*suth
     &      *(3D0*Mu**2-Md**2*sb**4-Mu**2/sb**2-3D0*Mu**2
     &      *sb**2+Mu**2*sb**4)
      AAABR(2501) = EE**2/MW**2*Mu/SW**2*Sqrt2/cb**2*sdth
     &      *suth*(2D0-1D0/sb**2-sb**2)
      AAABR(2502) = EE**2/MW**2*Md/SW**2*Sqrt2/cb**2*sb**2
     &      *sdth*suth
      AAABR(2503) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*sbth*stth
     &      -sb**4*sbth*stth-Mb/MW**2*Mt*cbth*ctth-Mb**2
     &      /MW**2*sb**2*sbth*stth+Mb/MW**2*Mt*cbth*ctth
     &      *sb**2)
      AAABR(2504) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*sbth*stth
     &      -sb**4*sbth*stth+Mb/MW**2*Mt*cbth*ctth-Mb**2
     &      /MW**2*sb**2*sbth*stth-Mb/MW**2*Mt*cbth*ctth
     &      *sb**2)
      AAABR(2505) = EE**2/SW**2*Sqrt2/cb**2*sbth*stth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2506) = EE**2/SW**2*Sqrt2/cb**2*(sbth*stth-2D0
     &      *sb**2*sbth*stth+sb**4*sbth*stth+2D0*Mt**2/MW
     &      **2*sbth*stth-Mb/MW**2*Mt*cbth*ctth-Mt**2/MW
     &      **2/sb**2*sbth*stth-Mt**2/MW**2*sb**2*sbth*stth
     &      +Mb/MW**2*Mt*cbth*ctth*sb**2)
      AAABR(2507) = EE**2/SW**2*Sqrt2/cb**2*(sbth*stth-2D0
     &      *sb**2*sbth*stth+sb**4*sbth*stth+2D0*Mt**2/MW
     &      **2*sbth*stth+Mb/MW**2*Mt*cbth*ctth-Mt**2/MW
     &      **2/sb**2*sbth*stth-Mt**2/MW**2*sb**2*sbth*stth
     &      -Mb/MW**2*Mt*cbth*ctth*sb**2)
      AAABR(2508) = EE**2/MW**2/SW**2*Sqrt2/cb**2*sbth*stth
     &      *(2D0*Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2*sb**2)
      AAABR(2509) = EE**2/MW**2/SW**2*Sqrt2/cb**2*sbth*stth
     &      *(3D0*Mt**2-Mb**2*sb**4-Mt**2/sb**2-3D0*Mt**2
     &      *sb**2+Mt**2*sb**4)
      AAABR(2510) = EE**2/MW**2*Mt/SW**2*Sqrt2/cb**2*sbth
     &      *stth*(2D0-1D0/sb**2-sb**2)
      AAABR(2511) = EE**2/MW**2*Mb/SW**2*Sqrt2/cb**2*sb**2
     &      *sbth*stth
      AAABR(2512) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*scth*ssth
     &      -sb**4*scth*ssth-Mc/MW**2*Ms*ccth*csth-Ms**2
     &      /MW**2*sb**2*scth*ssth+Mc/MW**2*Ms*ccth*csth
     &      *sb**2)
      AAABR(2513) = EE**2/SW**2*Sqrt2/cb**2*(sb**2*scth*ssth
     &      -sb**4*scth*ssth+Mc/MW**2*Ms*ccth*csth-Ms**2
     &      /MW**2*sb**2*scth*ssth-Mc/MW**2*Ms*ccth*csth
     &      *sb**2)
      AAABR(2514) = EE**2/SW**2*Sqrt2/cb**2*scth*ssth*(1D0
     &      -3D0*sb**2+2D0*sb**4)
      AAABR(2515) = EE**2/SW**2*Sqrt2/cb**2*(scth*ssth-2D0
     &      *sb**2*scth*ssth+sb**4*scth*ssth+2D0*Mc**2/MW
     &      **2*scth*ssth-Mc/MW**2*Ms*ccth*csth-Mc**2/MW
     &      **2/sb**2*scth*ssth-Mc**2/MW**2*sb**2*scth*ssth
     &      +Mc/MW**2*Ms*ccth*csth*sb**2)
      AAABR(2516) = EE**2/SW**2*Sqrt2/cb**2*(scth*ssth-2D0
     &      *sb**2*scth*ssth+sb**4*scth*ssth+2D0*Mc**2/MW
     &      **2*scth*ssth+Mc/MW**2*Ms*ccth*csth-Mc**2/MW
     &      **2/sb**2*scth*ssth-Mc**2/MW**2*sb**2*scth*ssth
     &      -Mc/MW**2*Ms*ccth*csth*sb**2)
      AAABR(2517) = EE**2/MW**2/SW**2*Sqrt2/cb**2*scth*ssth
     &      *(2D0*Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(2518) = EE**2/MW**2/SW**2*Sqrt2/cb**2*scth*ssth
     &      *(3D0*Mc**2-Mc**2/sb**2-3D0*Mc**2*sb**2+Mc**2
     &      *sb**4-Ms**2*sb**4)
      AAABR(2519) = EE**2/MW**2*Mc/SW**2*Sqrt2/cb**2*scth
     &      *ssth*(2D0-1D0/sb**2-sb**2)
      AAABR(2520) = EE**2/MW**2*Ms/SW**2*Sqrt2/cb**2*sb**2
     &      *scth*ssth
      AAABR(2521) = EE**2*(1D0/SW**2-4D0*sb**2/CW**2+4D0
     &      *sb**4/CW**2-4D0*sb**2/SW**2+4D0*sb**4/SW**2)
      AAABR(2522) = EE**2/CW**2*(sb**2-sb**4)
      AAABR(2523) = EE**2/CW**3*SW*(sb**2-sb**4)
      AAABR(2524) = EE**2/SW**2*(ca*cb+sa*sb)
      AAABR(2525) = EE**2/SW**2*(ca*sb-cb*sa)
      AAABR(2526) = EE**2/SW**2*cb*sa
      AAABR(2527) = EE**2/SW**2*ca*sb
      AAABR(2528) = EE**2/SW**2*ca*cb
      AAABR(2529) = EE**2/SW**2*sa*sb
      AAABR(2530) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2-sb**2/SW**2-smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2+sb**2/SW**2*smuth
     &      **2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(2531) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2-sb**2/SW**2-smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2+sb**2/SW**2*smuth
     &      **2+Mm**2/MW**2/SW**2*smuth**2)
      AAABR(2532) = EE**2/SW**2*tb*(1D0-sb**2-smuth**2+sb
     &      **2*smuth**2)
      AAABR(2533) = EE**2*cmuth*smuth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-Mm**2/MW**2/SW
     &      **2)
      AAABR(2534) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2-sb**2/SW**2-smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2+sb**2/SW**2*smuth
     &      **2)
      AAABR(2535) = EE**2/CW**2*tb*(1D0-sb**2-3D0*smuth**2
     &      +3D0*sb**2*smuth**2)
      AAABR(2536) = EE**2/CW**3*SW*tb*(1D0-sb**2-3D0*smuth
     &      **2+3D0*sb**2*smuth**2)
      AAABR(2537) = EE**2/MW**2*Mm**2/SW**2*smuth**2*tb
      AAABR(2538) = EE**2/MW**2*Mm**2/SW**2*sb**2*smuth**2
     &      *tb
      AAABR(2539) = EE**2/MW**2*Mm/SW**2*smuth**2*tb
      AAABR(2540) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2-sb**2/SW**2-seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2+sb**2/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(2541) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2-sb**2/SW**2-seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2+sb**2/SW**2*seth
     &      **2+Me**2/MW**2/SW**2*seth**2)
      AAABR(2542) = EE**2/SW**2*tb*(1D0-sb**2-seth**2+sb
     &      **2*seth**2)
      AAABR(2543) = EE**2*ceth*seth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-Me**2/MW**2/SW
     &      **2)
      AAABR(2544) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2-sb**2/SW**2-seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2+sb**2/SW**2*seth**2)
      AAABR(2545) = EE**2/CW**2*tb*(1D0-sb**2-3D0*seth**2
     &      +3D0*sb**2*seth**2)
      AAABR(2546) = EE**2/CW**3*SW*tb*(1D0-sb**2-3D0*seth
     &      **2+3D0*sb**2*seth**2)
      AAABR(2547) = EE**2/MW**2*Me**2/SW**2*seth**2*tb
      AAABR(2548) = EE**2/MW**2*Me**2/SW**2*sb**2*seth**2*tb
      AAABR(2549) = EE**2/MW**2*Me/SW**2*seth**2*tb
      AAABR(2550) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2-sb**2/SW**2-slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2+sb**2/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(2551) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2-sb**2/SW**2-slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2+sb**2/SW**2*slth
     &      **2+Ml**2/MW**2/SW**2*slth**2)
      AAABR(2552) = EE**2/SW**2*tb*(1D0-sb**2-slth**2+sb
     &      **2*slth**2)
      AAABR(2553) = EE**2*clth*slth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-Ml**2/MW**2/SW
     &      **2)
      AAABR(2554) = EE**2*tb*(1D0/CW**2+1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2-sb**2/SW**2-slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2+sb**2/SW**2*slth**2)
      AAABR(2555) = EE**2/CW**2*tb*(1D0-sb**2-3D0*slth**2
     &      +3D0*sb**2*slth**2)
      AAABR(2556) = EE**2/CW**3*SW*tb*(1D0-sb**2-3D0*slth
     &      **2+3D0*sb**2*slth**2)
      AAABR(2557) = EE**2/MW**2*Ml**2/SW**2*slth**2*tb
      AAABR(2558) = EE**2/MW**2*Ml**2/SW**2*sb**2*slth**2*tb
      AAABR(2559) = EE**2/MW**2*Ml/SW**2*slth**2*tb
      AAABR(2560) = EE**2*ceth*seth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Me**2/MW
     &      **2/SW**2)
      AAABR(2561) = EE**2/SW**2*ceth*seth*tb*(1D0-sb**2)
      AAABR(2562) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-Me**2/MW**2/SW**2+sb**2/SW**2*seth**2
     &      +Me**2/MW**2/SW**2*seth**2)
      AAABR(2563) = EE**2*ceth*seth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2)
      AAABR(2564) = EE**2/CW**2*ceth*seth*tb*(1D0-sb**2)
      AAABR(2565) = EE**2/CW**3*SW*ceth*seth*tb*(1D0-sb**2)
      AAABR(2566) = EE**2/MW**2*Me**2/SW**2*ceth*seth*tb
      AAABR(2567) = EE**2/MW**2*Me**2/SW**2*ceth*sb**2*seth
     &      *tb
      AAABR(2568) = EE**2/MW**2*Me/SW**2*ceth*seth*tb
      AAABR(2569) = EE**2*cmuth*smuth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Mm**2/MW
     &      **2/SW**2)
      AAABR(2570) = EE**2/SW**2*cmuth*smuth*tb*(1D0-sb**2)
      AAABR(2571) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-Mm**2/MW**2/SW**2+sb**2/SW**2*smuth
     &      **2+Mm**2/MW**2/SW**2*smuth**2)
      AAABR(2572) = EE**2*cmuth*smuth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2)
      AAABR(2573) = EE**2/CW**2*cmuth*smuth*tb*(1D0-sb**2)
      AAABR(2574) = EE**2/CW**3*SW*cmuth*smuth*tb*(1D0-sb
     &      **2)
      AAABR(2575) = EE**2/MW**2*Mm**2/SW**2*cmuth*smuth*tb
      AAABR(2576) = EE**2/MW**2*Mm**2/SW**2*cmuth*sb**2*smuth
     &      *tb
      AAABR(2577) = EE**2/MW**2*Mm/SW**2*cmuth*smuth*tb
      AAABR(2578) = EE**2*clth*slth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Ml**2/MW
     &      **2/SW**2)
      AAABR(2579) = EE**2/SW**2*clth*slth*tb*(1D0-sb**2)
      AAABR(2580) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-Ml**2/MW**2/SW**2+sb**2/SW**2*slth**2
     &      +Ml**2/MW**2/SW**2*slth**2)
      AAABR(2581) = EE**2*clth*slth*tb*(3D0/CW**2+1D0/SW
     &      **2-3D0*sb**2/CW**2-sb**2/SW**2)
      AAABR(2582) = EE**2/CW**2*clth*slth*tb*(1D0-sb**2)
      AAABR(2583) = EE**2/CW**3*SW*clth*slth*tb*(1D0-sb**2)
      AAABR(2584) = EE**2/MW**2*Ml**2/SW**2*clth*slth*tb
      AAABR(2585) = EE**2/MW**2*Ml**2/SW**2*clth*sb**2*slth
     &      *tb
      AAABR(2586) = EE**2/MW**2*Ml/SW**2*clth*slth*tb
      AAABR(2587) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2+sb**2/SW**2*smuth
     &      **2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(2588) = EE**2/SW**2*smuth**2*tb*(1D0-sb**2)
      AAABR(2589) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2+sb**2/SW**2*smuth**2)
      AAABR(2590) = EE**2/CW**2*tb*(2D0-2D0*sb**2-3D0*smuth
     &      **2+3D0*sb**2*smuth**2)
      AAABR(2591) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-3D0
     &      *smuth**2+3D0*sb**2*smuth**2)
      AAABR(2592) = EE**2/MW**2*Mm**2/SW**2*tb*(1D0-smuth
     &      **2)
      AAABR(2593) = EE**2/MW**2*Mm**2/SW**2*sb**2*tb*(1D0
     &      -smuth**2)
      AAABR(2594) = EE**2/MW**2*Mm/SW**2*tb*(1D0-smuth**2)
      AAABR(2595) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2+sb**2/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(2596) = EE**2/SW**2*seth**2*tb*(1D0-sb**2)
      AAABR(2597) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2+sb**2/SW**2*seth**2)
      AAABR(2598) = EE**2/CW**2*tb*(2D0-2D0*sb**2-3D0*seth
     &      **2+3D0*sb**2*seth**2)
      AAABR(2599) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-3D0
     &      *seth**2+3D0*sb**2*seth**2)
      AAABR(2600) = EE**2/MW**2*Me**2/SW**2*tb*(1D0-seth**2)
      AAABR(2601) = EE**2/MW**2*Me**2/SW**2*sb**2*tb*(1D0
     &      -seth**2)
      AAABR(2602) = EE**2/MW**2*Me/SW**2*tb*(1D0-seth**2)
      AAABR(2603) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2+sb**2/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(2604) = EE**2/SW**2*slth**2*tb*(1D0-sb**2)
      AAABR(2605) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2+sb**2/SW**2*slth**2)
      AAABR(2606) = EE**2/CW**2*tb*(2D0-2D0*sb**2-3D0*slth
     &      **2+3D0*sb**2*slth**2)
      AAABR(2607) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-3D0
     &      *slth**2+3D0*sb**2*slth**2)
      AAABR(2608) = EE**2/MW**2*Ml**2/SW**2*tb*(1D0-slth**2)
      AAABR(2609) = EE**2/MW**2*Ml**2/SW**2*sb**2*tb*(1D0
     &      -slth**2)
      AAABR(2610) = EE**2/MW**2*Ml/SW**2*tb*(1D0-slth**2)
      AAABR(2611) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+2D0*Ml**2/MW**2/SW**2)
      AAABR(2612) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+Ml**2/MW**2/SW**2)
      AAABR(2613) = EE**2/SW**2*tb*(1D0-sb**2)
      AAABR(2614) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2)
      AAABR(2615) = EE**2/CW**2*tb*(1D0-sb**2)
      AAABR(2616) = EE**2/CW**3*SW*tb*(1D0-sb**2)
      AAABR(2617) = EE**2/MW**2*Ml**2/SW**2*tb
      AAABR(2618) = EE**2/MW**2*Ml**2/SW**2*sb**2*tb
      AAABR(2619) = EE**2/MW**2*Ml/SW**2*tb
      AAABR(2620) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+2D0*Mm**2/MW**2/SW**2)
      AAABR(2621) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+Mm**2/MW**2/SW**2)
      AAABR(2622) = EE**2/MW**2*Mm**2/SW**2*tb
      AAABR(2623) = EE**2/MW**2*Mm**2/SW**2*sb**2*tb
      AAABR(2624) = EE**2/MW**2*Mm/SW**2*tb
      AAABR(2625) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+2D0*Me**2/MW**2/SW**2)
      AAABR(2626) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2+sb**2/SW**2+Me**2/MW**2/SW**2)
      AAABR(2627) = EE**2/MW**2*Me**2/SW**2*tb
      AAABR(2628) = EE**2/MW**2*Me**2/SW**2*sb**2*tb
      AAABR(2629) = EE**2/MW**2*Me/SW**2*tb
      AAABR(2630) = EE**2/SW**2*Sqrt2*clth*tb*(1D0-sb**2
     &      -Ml**2/MW**2)
      AAABR(2631) = EE**2/SW**2*Sqrt2*clth*tb*(2D0-2D0*sb
     &      **2-Ml**2/MW**2)
      AAABR(2632) = EE**2/SW**2*Sqrt2*clth*tb*(1D0-sb**2)
      AAABR(2633) = EE**2/SW**2*Sqrt2*slth*tb*(2D0-2D0*sb
     &      **2-Ml**2/MW**2)
      AAABR(2634) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*clth*tb
      AAABR(2635) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*clth*sb
     &      **2*tb
      AAABR(2636) = EE**2/MW**2*Ml/SW**2*Sqrt2*clth*tb
      AAABR(2637) = EE**2/SW**2*Sqrt2*ceth*tb*(1D0-sb**2
     &      -Me**2/MW**2)
      AAABR(2638) = EE**2/SW**2*Sqrt2*ceth*tb*(2D0-2D0*sb
     &      **2-Me**2/MW**2)
      AAABR(2639) = EE**2/SW**2*Sqrt2*ceth*tb*(1D0-sb**2)
      AAABR(2640) = EE**2/SW**2*Sqrt2*seth*tb*(2D0-2D0*sb
     &      **2-Me**2/MW**2)
      AAABR(2641) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ceth*tb
      AAABR(2642) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ceth*sb
     &      **2*tb
      AAABR(2643) = EE**2/MW**2*Me/SW**2*Sqrt2*ceth*tb
      AAABR(2644) = EE**2/SW**2*Sqrt2*cmuth*tb*(1D0-sb**2
     &      -Mm**2/MW**2)
      AAABR(2645) = EE**2/SW**2*Sqrt2*cmuth*tb*(2D0-2D0*sb
     &      **2-Mm**2/MW**2)
      AAABR(2646) = EE**2/SW**2*Sqrt2*cmuth*tb*(1D0-sb**2)
      AAABR(2647) = EE**2/SW**2*Sqrt2*smuth*tb*(2D0-2D0*sb
     &      **2-Mm**2/MW**2)
      AAABR(2648) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*cmuth*tb
      AAABR(2649) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*cmuth*sb
     &      **2*tb
      AAABR(2650) = EE**2/MW**2*Mm/SW**2*Sqrt2*cmuth*tb
      AAABR(2651) = EE**2/SW**2*Sqrt2*smuth*tb*(1D0-sb**2
     &      -Mm**2/MW**2)
      AAABR(2652) = EE**2/SW**2*Sqrt2*smuth*tb*(1D0-sb**2)
      AAABR(2653) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*smuth*tb
      AAABR(2654) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*sb**2*smuth
     &      *tb
      AAABR(2655) = EE**2/MW**2*Mm/SW**2*Sqrt2*smuth*tb
      AAABR(2656) = EE**2/SW**2*Sqrt2*seth*tb*(1D0-sb**2
     &      -Me**2/MW**2)
      AAABR(2657) = EE**2/SW**2*Sqrt2*seth*tb*(1D0-sb**2)
      AAABR(2658) = EE**2/MW**2*Me**2/SW**2*Sqrt2*seth*tb
      AAABR(2659) = EE**2/MW**2*Me**2/SW**2*Sqrt2*sb**2*seth
     &      *tb
      AAABR(2660) = EE**2/MW**2*Me/SW**2*Sqrt2*seth*tb
      AAABR(2661) = EE**2/SW**2*Sqrt2*slth*tb*(1D0-sb**2
     &      -Ml**2/MW**2)
      AAABR(2662) = EE**2/SW**2*Sqrt2*slth*tb*(1D0-sb**2)
      AAABR(2663) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*slth*tb
      AAABR(2664) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*sb**2*slth
     &      *tb
      AAABR(2665) = EE**2/MW**2*Ml/SW**2*Sqrt2*slth*tb
      AAABR(2666) = EE**2/SW**2*Sqrt2*ca/cb**2*clth*(sb-sb
     &      **3-Ml**2/MW**2*sb)
      AAABR(2667) = EE**2/SW**2*Sqrt2*clth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2-Ml**2/MW**2*ca
     &      /cb**2*sb)
      AAABR(2668) = EE**2/SW**2*Sqrt2*clth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3+Ml**2/MW**2/cb
     &      **2*sa*sb)
      AAABR(2669) = EE**2/SW**2*Sqrt2*clth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2670) = EE**2/SW**2*Sqrt2*slth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2-Ml**2/MW**2*ca
     &      /cb**2*sb)
      AAABR(2671) = EE**2/SW**2*Sqrt2/cb*clth*sa*(1D0-sb**2)
      AAABR(2672) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb**2
     &      *clth*sb
      AAABR(2673) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb**2
     &      *clth*sb**3
      AAABR(2674) = EE**2/MW**2*Ml/SW**2*Sqrt2*ca/cb**2*clth
     &      *sb
      AAABR(2675) = EE**2/SW**2*Sqrt2/cb**2*ceth*sa*(sb-sb
     &      **3-Me**2/MW**2*sb)
      AAABR(2676) = EE**2/SW**2*Sqrt2*ceth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2-Me**2/MW**2*ca
     &      /cb**2*sb)
      AAABR(2677) = EE**2/SW**2*Sqrt2*ceth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3+Me**2/MW**2/cb
     &      **2*sa*sb)
      AAABR(2678) = EE**2/SW**2*Sqrt2*ceth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2679) = EE**2/SW**2*Sqrt2*seth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3+Me**2/MW**2/cb
     &      **2*sa*sb)
      AAABR(2680) = EE**2/SW**2*Sqrt2*ca/cb*ceth*(1D0-sb**2)
      AAABR(2681) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*ceth
     &      *sa*sb
      AAABR(2682) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*ceth
     &      *sa*sb**3
      AAABR(2683) = EE**2/MW**2*Me/SW**2*Sqrt2/cb**2*ceth
     &      *sa*sb
      AAABR(2684) = EE**2/SW**2*Sqrt2*ca/cb**2*ceth*(sb-sb
     &      **3-Me**2/MW**2*sb)
      AAABR(2685) = EE**2/SW**2*Sqrt2*ceth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2686) = EE**2/SW**2*Sqrt2*seth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2-Me**2/MW**2*ca
     &      /cb**2*sb)
      AAABR(2687) = EE**2/SW**2*Sqrt2/cb*ceth*sa*(1D0-sb**2)
      AAABR(2688) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb**2
     &      *ceth*sb
      AAABR(2689) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb**2
     &      *ceth*sb**3
      AAABR(2690) = EE**2/MW**2*Me/SW**2*Sqrt2*ca/cb**2*ceth
     &      *sb
      AAABR(2691) = EE**2/SW**2*Sqrt2/cb**2*clth*sa*(sb-sb
     &      **3-Ml**2/MW**2*sb)
      AAABR(2692) = EE**2/SW**2*Sqrt2*clth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2693) = EE**2/SW**2*Sqrt2*slth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3+Ml**2/MW**2/cb
     &      **2*sa*sb)
      AAABR(2694) = EE**2/SW**2*Sqrt2*ca/cb*clth*(1D0-sb**2)
      AAABR(2695) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*clth
     &      *sa*sb
      AAABR(2696) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*clth
     &      *sa*sb**3
      AAABR(2697) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb**2*clth
     &      *sa*sb
      AAABR(2698) = EE**2/SW**2*Sqrt2*ca/cb**2*cmuth*(sb
     &      -sb**3-Mm**2/MW**2*sb)
      AAABR(2699) = EE**2/SW**2*Sqrt2*cmuth*(sa/cb+ca/cb
     &      **2*sb-ca/cb**2*sb**3-sa/cb*sb**2-Mm**2/MW**2
     &      *ca/cb**2*sb)
      AAABR(2700) = EE**2/SW**2*Sqrt2*cmuth*(ca/cb-ca/cb
     &      *sb**2-sa/cb**2*sb+sa/cb**2*sb**3+Mm**2/MW**2
     &      /cb**2*sa*sb)
      AAABR(2701) = EE**2/SW**2*Sqrt2*cmuth*(sa/cb+ca/cb
     &      **2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2702) = EE**2/SW**2*Sqrt2*smuth*(sa/cb+ca/cb
     &      **2*sb-ca/cb**2*sb**3-sa/cb*sb**2-Mm**2/MW**2
     &      *ca/cb**2*sb)
      AAABR(2703) = EE**2/SW**2*Sqrt2/cb*cmuth*sa*(1D0-sb
     &      **2)
      AAABR(2704) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb**2
     &      *cmuth*sb
      AAABR(2705) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb**2
     &      *cmuth*sb**3
      AAABR(2706) = EE**2/MW**2*Mm/SW**2*Sqrt2*ca/cb**2*cmuth
     &      *sb
      AAABR(2707) = EE**2/SW**2*Sqrt2/cb**2*cmuth*sa*(sb
     &      -sb**3-Mm**2/MW**2*sb)
      AAABR(2708) = EE**2/SW**2*Sqrt2*cmuth*(ca/cb-ca/cb
     &      *sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2709) = EE**2/SW**2*Sqrt2*smuth*(ca/cb-ca/cb
     &      *sb**2-sa/cb**2*sb+sa/cb**2*sb**3+Mm**2/MW**2
     &      /cb**2*sa*sb)
      AAABR(2710) = EE**2/SW**2*Sqrt2*ca/cb*cmuth*(1D0-sb
     &      **2)
      AAABR(2711) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*cmuth
     &      *sa*sb
      AAABR(2712) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*cmuth
     &      *sa*sb**3
      AAABR(2713) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb**2*cmuth
     &      *sa*sb
      AAABR(2714) = EE**2/SW**2*Sqrt2*ca/cb**2*smuth*(sb
     &      -sb**3-Mm**2/MW**2*sb)
      AAABR(2715) = EE**2/SW**2*Sqrt2*smuth*(sa/cb+ca/cb
     &      **2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2716) = EE**2/SW**2*Sqrt2/cb*sa*smuth*(1D0-sb
     &      **2)
      AAABR(2717) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb**2
     &      *sb*smuth
      AAABR(2718) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb**2
     &      *sb**3*smuth
      AAABR(2719) = EE**2/MW**2*Mm/SW**2*Sqrt2*ca/cb**2*sb
     &      *smuth
      AAABR(2720) = EE**2/SW**2*Sqrt2*ca/cb**2*seth*(sb-sb
     &      **3-Me**2/MW**2*sb)
      AAABR(2721) = EE**2/SW**2*Sqrt2*seth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2722) = EE**2/SW**2*Sqrt2/cb*sa*seth*(1D0-sb**2)
      AAABR(2723) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb**2
     &      *sb*seth
      AAABR(2724) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb**2
     &      *sb**3*seth
      AAABR(2725) = EE**2/MW**2*Me/SW**2*Sqrt2*ca/cb**2*sb
     &      *seth
      AAABR(2726) = EE**2/SW**2*Sqrt2*ca/cb**2*slth*(sb-sb
     &      **3-Ml**2/MW**2*sb)
      AAABR(2727) = EE**2/SW**2*Sqrt2*slth*(sa/cb+ca/cb**2
     &      *sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2728) = EE**2/SW**2*Sqrt2/cb*sa*slth*(1D0-sb**2)
      AAABR(2729) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb**2
     &      *sb*slth
      AAABR(2730) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb**2
     &      *sb**3*slth
      AAABR(2731) = EE**2/MW**2*Ml/SW**2*Sqrt2*ca/cb**2*sb
     &      *slth
      AAABR(2732) = EE**2/SW**2*Sqrt2/cb**2*sa*seth*(sb-sb
     &      **3-Me**2/MW**2*sb)
      AAABR(2733) = EE**2/SW**2*Sqrt2*seth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2734) = EE**2/SW**2*Sqrt2*ca/cb*seth*(1D0-sb**2)
      AAABR(2735) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*sa
     &      *sb*seth
      AAABR(2736) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb**2*sa
     &      *sb**3*seth
      AAABR(2737) = EE**2/MW**2*Me/SW**2*Sqrt2/cb**2*sa*sb
     &      *seth
      AAABR(2738) = EE**2/SW**2*Sqrt2/cb**2*sa*smuth*(sb
     &      -sb**3-Mm**2/MW**2*sb)
      AAABR(2739) = EE**2/SW**2*Sqrt2*smuth*(ca/cb-ca/cb
     &      *sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2740) = EE**2/SW**2*Sqrt2*ca/cb*smuth*(1D0-sb
     &      **2)
      AAABR(2741) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*sa
     &      *sb*smuth
      AAABR(2742) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb**2*sa
     &      *sb**3*smuth
      AAABR(2743) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb**2*sa*sb
     &      *smuth
      AAABR(2744) = EE**2/SW**2*Sqrt2/cb**2*sa*slth*(sb-sb
     &      **3-Ml**2/MW**2*sb)
      AAABR(2745) = EE**2/SW**2*Sqrt2*slth*(ca/cb-ca/cb*sb
     &      **2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(2746) = EE**2/SW**2*Sqrt2*ca/cb*slth*(1D0-sb**2)
      AAABR(2747) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*sa
     &      *sb*slth
      AAABR(2748) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb**2*sa
     &      *sb**3*slth
      AAABR(2749) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb**2*sa*sb
     &      *slth
      AAABR(2750) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sbth**2-sb**3
     &      /CW**2*sbth**2+3D0*sb/SW**2*sbth**2-3D0*sb**3
     &      /SW**2*sbth**2-6D0*Mb**2/MW**2/SW**2*sb*sbth**2)
      AAABR(2751) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sbth**2-sb**3
     &      /CW**2*sbth**2+3D0*sb/SW**2*sbth**2-3D0*sb**3
     &      /SW**2*sbth**2+3D0*Mt**2/MW**2/SW**2/sb-3D0*Mt
     &      **2/MW**2/SW**2*sb-3D0*Mb**2/MW**2/SW**2*sb*sbth
     &      **2-3D0*Mt**2/MW**2/SW**2/sb*sbth**2+3D0*Mt**2
     &      /MW**2/SW**2*sb*sbth**2)
      AAABR(2752) = EE**2/SW**2/cb*(sb-sb**3-sb*sbth**2+sb
     &      **3*sbth**2)
      AAABR(2753) = EE**2/cb*cbth*sbth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0*Mb**2/MW
     &      **2/SW**2*sb-3D0*Mt**2/MW**2/SW**2/sb+3D0*Mt
     &      **2/MW**2/SW**2*sb)
      AAABR(2754) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sbth**2-sb**3
     &      /CW**2*sbth**2+3D0*sb/SW**2*sbth**2-3D0*sb**3
     &      /SW**2*sbth**2+6D0*Mt**2/MW**2/SW**2/sb-6D0*Mt
     &      **2/MW**2/SW**2*sb-6D0*Mt**2/MW**2/SW**2/sb*sbth
     &      **2+6D0*Mt**2/MW**2/SW**2*sb*sbth**2)
      AAABR(2755) = EE**2/CW**2/cb*(sb-sb**3+sb*sbth**2-sb
     &      **3*sbth**2)
      AAABR(2756) = EE**2/CW**3*SW/cb*(sb-sb**3+sb*sbth**2
     &      -sb**3*sbth**2)
      AAABR(2757) = EE**2/MW**2/SW**2/cb*(Mt**2/sb-Mt**2
     &      *sb-Mb**2*sb*sbth**2-Mt**2/sb*sbth**2+Mt**2*sb
     &      *sbth**2)
      AAABR(2758) = EE**2/MW**2/SW**2/cb*(Mt**2/sb-2D0*Mt
     &      **2*sb+Mt**2*sb**3+Mb**2*sb**3*sbth**2-Mt**2
     &      /sb*sbth**2+2D0*Mt**2*sb*sbth**2-Mt**2*sb**3
     &      *sbth**2)
      AAABR(2759) = EE**2/MW**2*Mb/SW**2/cb*sb*sbth**2
      AAABR(2760) = EE**2/MW**2*Mt/SW**2/cb*(1D0/sb-sb-sbth
     &      **2/sb+sb*sbth**2)
      AAABR(2761) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*ssth**2-sb**3
     &      /CW**2*ssth**2+3D0*sb/SW**2*ssth**2-3D0*sb**3
     &      /SW**2*ssth**2-6D0*Ms**2/MW**2/SW**2*sb*ssth**2)
      AAABR(2762) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*ssth**2-sb**3
     &      /CW**2*ssth**2+3D0*sb/SW**2*ssth**2-3D0*sb**3
     &      /SW**2*ssth**2+3D0*Mc**2/MW**2/SW**2/sb-3D0*Mc
     &      **2/MW**2/SW**2*sb-3D0*Mc**2/MW**2/SW**2/sb*ssth
     &      **2+3D0*Mc**2/MW**2/SW**2*sb*ssth**2-3D0*Ms**2
     &      /MW**2/SW**2*sb*ssth**2)
      AAABR(2763) = EE**2/SW**2/cb*(sb-sb**3-sb*ssth**2+sb
     &      **3*ssth**2)
      AAABR(2764) = EE**2/cb*csth*ssth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0*Mc**2/MW
     &      **2/SW**2/sb+3D0*Mc**2/MW**2/SW**2*sb-3D0*Ms
     &      **2/MW**2/SW**2*sb)
      AAABR(2765) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*ssth**2-sb**3
     &      /CW**2*ssth**2+3D0*sb/SW**2*ssth**2-3D0*sb**3
     &      /SW**2*ssth**2+6D0*Mc**2/MW**2/SW**2/sb-6D0*Mc
     &      **2/MW**2/SW**2*sb-6D0*Mc**2/MW**2/SW**2/sb*ssth
     &      **2+6D0*Mc**2/MW**2/SW**2*sb*ssth**2)
      AAABR(2766) = EE**2/CW**2/cb*(sb-sb**3+sb*ssth**2-sb
     &      **3*ssth**2)
      AAABR(2767) = EE**2/CW**3*SW/cb*(sb-sb**3+sb*ssth**2
     &      -sb**3*ssth**2)
      AAABR(2768) = EE**2/MW**2/SW**2/cb*(Mc**2/sb-Mc**2
     &      *sb-Mc**2/sb*ssth**2+Mc**2*sb*ssth**2-Ms**2*sb
     &      *ssth**2)
      AAABR(2769) = EE**2/MW**2/SW**2/cb*(Mc**2/sb-2D0*Mc
     &      **2*sb+Mc**2*sb**3-Mc**2/sb*ssth**2+2D0*Mc**2
     &      *sb*ssth**2-Mc**2*sb**3*ssth**2+Ms**2*sb**3*ssth
     &      **2)
      AAABR(2770) = EE**2/MW**2*Ms/SW**2/cb*sb*ssth**2
      AAABR(2771) = EE**2/MW**2*Mc/SW**2/cb*(1D0/sb-sb-ssth
     &      **2/sb+sb*ssth**2)
      AAABR(2772) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sdth**2-sb**3
     &      /CW**2*sdth**2+3D0*sb/SW**2*sdth**2-3D0*sb**3
     &      /SW**2*sdth**2-6D0*Md**2/MW**2/SW**2*sb*sdth**2)
      AAABR(2773) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sdth**2-sb**3
     &      /CW**2*sdth**2+3D0*sb/SW**2*sdth**2-3D0*sb**3
     &      /SW**2*sdth**2+3D0*Mu**2/MW**2/SW**2/sb-3D0*Mu
     &      **2/MW**2/SW**2*sb-3D0*Md**2/MW**2/SW**2*sb*sdth
     &      **2-3D0*Mu**2/MW**2/SW**2/sb*sdth**2+3D0*Mu**2
     &      /MW**2/SW**2*sb*sdth**2)
      AAABR(2774) = EE**2/SW**2/cb*(sb-sb**3-sb*sdth**2+sb
     &      **3*sdth**2)
      AAABR(2775) = EE**2/cb*cdth*sdth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0*Md**2/MW
     &      **2/SW**2*sb-3D0*Mu**2/MW**2/SW**2/sb+3D0*Mu
     &      **2/MW**2/SW**2*sb)
      AAABR(2776) = EE**2/cb*(sb/CW**2-sb**3/CW**2-3D0*sb
     &      /SW**2+3D0*sb**3/SW**2+sb/CW**2*sdth**2-sb**3
     &      /CW**2*sdth**2+3D0*sb/SW**2*sdth**2-3D0*sb**3
     &      /SW**2*sdth**2+6D0*Mu**2/MW**2/SW**2/sb-6D0*Mu
     &      **2/MW**2/SW**2*sb-6D0*Mu**2/MW**2/SW**2/sb*sdth
     &      **2+6D0*Mu**2/MW**2/SW**2*sb*sdth**2)
      AAABR(2777) = EE**2/CW**2/cb*(sb-sb**3+sb*sdth**2-sb
     &      **3*sdth**2)
      AAABR(2778) = EE**2/CW**3*SW/cb*(sb-sb**3+sb*sdth**2
     &      -sb**3*sdth**2)
      AAABR(2779) = EE**2/MW**2/SW**2/cb*(Mu**2/sb-Mu**2
     &      *sb-Md**2*sb*sdth**2-Mu**2/sb*sdth**2+Mu**2*sb
     &      *sdth**2)
      AAABR(2780) = EE**2/MW**2/SW**2/cb*(Mu**2/sb-2D0*Mu
     &      **2*sb+Mu**2*sb**3+Md**2*sb**3*sdth**2-Mu**2
     &      /sb*sdth**2+2D0*Mu**2*sb*sdth**2-Mu**2*sb**3
     &      *sdth**2)
      AAABR(2781) = EE**2/MW**2*Md/SW**2/cb*sb*sdth**2
      AAABR(2782) = EE**2/MW**2*Mu/SW**2/cb*(1D0/sb-sb-sdth
     &      **2/sb+sb*sdth**2)
      AAABR(2783) = EE**2/cb*csth*ssth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Ms**2/MW
     &      **2/SW**2*sb)
      AAABR(2784) = EE**2/SW**2/cb*csth*ssth*(sb-sb**3)
      AAABR(2785) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*ssth**2+sb**3/CW**2*ssth**2-3D0*sb
     &      /SW**2*ssth**2+3D0*sb**3/SW**2*ssth**2-3D0*Ms
     &      **2/MW**2/SW**2*sb+3D0*Mc**2/MW**2/SW**2/sb*ssth
     &      **2-3D0*Mc**2/MW**2/SW**2*sb*ssth**2+3D0*Ms**2
     &      /MW**2/SW**2*sb*ssth**2)
      AAABR(2786) = EE**2/cb*csth*ssth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Mc**2/MW
     &      **2/SW**2/sb+6D0*Mc**2/MW**2/SW**2*sb)
      AAABR(2787) = EE**2/CW**2/cb*csth*ssth*(sb-sb**3)
      AAABR(2788) = EE**2/CW**3*SW/cb*csth*ssth*(sb-sb**3)
      AAABR(2789) = EE**2/MW**2/SW**2/cb*csth*ssth*(Mc**2
     &      /sb-Mc**2*sb+Ms**2*sb)
      AAABR(2790) = EE**2/MW**2/SW**2/cb*csth*ssth*(Mc**2
     &      /sb-2D0*Mc**2*sb+Mc**2*sb**3-Ms**2*sb**3)
      AAABR(2791) = EE**2/MW**2*Ms/SW**2/cb*csth*sb*ssth
      AAABR(2792) = EE**2/MW**2*Mc/SW**2/cb*csth*ssth*(1D0
     &      /sb-sb)
      AAABR(2793) = EE**2/cb*cdth*sdth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Md**2/MW
     &      **2/SW**2*sb)
      AAABR(2794) = EE**2/SW**2/cb*cdth*sdth*(sb-sb**3)
      AAABR(2795) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sdth**2+sb**3/CW**2*sdth**2-3D0*sb
     &      /SW**2*sdth**2+3D0*sb**3/SW**2*sdth**2-3D0*Md
     &      **2/MW**2/SW**2*sb+3D0*Md**2/MW**2/SW**2*sb*sdth
     &      **2+3D0*Mu**2/MW**2/SW**2/sb*sdth**2-3D0*Mu**2
     &      /MW**2/SW**2*sb*sdth**2)
      AAABR(2796) = EE**2/cb*cdth*sdth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Mu**2/MW
     &      **2/SW**2/sb+6D0*Mu**2/MW**2/SW**2*sb)
      AAABR(2797) = EE**2/CW**2/cb*cdth*sdth*(sb-sb**3)
      AAABR(2798) = EE**2/CW**3*SW/cb*cdth*sdth*(sb-sb**3)
      AAABR(2799) = EE**2/MW**2/SW**2/cb*cdth*sdth*(Md**2
     &      *sb+Mu**2/sb-Mu**2*sb)
      AAABR(2800) = EE**2/MW**2/SW**2/cb*cdth*sdth*(Md**2
     &      *sb**3-Mu**2/sb+2D0*Mu**2*sb-Mu**2*sb**3)
      AAABR(2801) = EE**2/MW**2*Md/SW**2/cb*cdth*sb*sdth
      AAABR(2802) = EE**2/MW**2*Mu/SW**2/cb*cdth*sdth*(1D0
     &      /sb-sb)
      AAABR(2803) = EE**2/cb*cbth*sbth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Mb**2/MW
     &      **2/SW**2*sb)
      AAABR(2804) = EE**2/SW**2/cb*cbth*sbth*(sb-sb**3)
      AAABR(2805) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sbth**2+sb**3/CW**2*sbth**2-3D0*sb
     &      /SW**2*sbth**2+3D0*sb**3/SW**2*sbth**2-3D0*Mb
     &      **2/MW**2/SW**2*sb+3D0*Mb**2/MW**2/SW**2*sb*sbth
     &      **2+3D0*Mt**2/MW**2/SW**2/sb*sbth**2-3D0*Mt**2
     &      /MW**2/SW**2*sb*sbth**2)
      AAABR(2806) = EE**2/cb*cbth*sbth*(sb/CW**2-sb**3/CW
     &      **2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0*Mt**2/MW
     &      **2/SW**2/sb+6D0*Mt**2/MW**2/SW**2*sb)
      AAABR(2807) = EE**2/CW**2/cb*cbth*sbth*(sb-sb**3)
      AAABR(2808) = EE**2/CW**3*SW/cb*cbth*sbth*(sb-sb**3)
      AAABR(2809) = EE**2/MW**2/SW**2/cb*cbth*sbth*(Mb**2
     &      *sb+Mt**2/sb-Mt**2*sb)
      AAABR(2810) = EE**2/MW**2/SW**2/cb*cbth*sbth*(Mb**2
     &      *sb**3-Mt**2/sb+2D0*Mt**2*sb-Mt**2*sb**3)
      AAABR(2811) = EE**2/MW**2*Mb/SW**2/cb*cbth*sb*sbth
      AAABR(2812) = EE**2/MW**2*Mt/SW**2/cb*cbth*sbth*(1D0
     &      /sb-sb)
      AAABR(2813) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*ssth**2+sb**3/CW**2*ssth**2-3D0*sb
     &      /SW**2*ssth**2+3D0*sb**3/SW**2*ssth**2-6D0*Ms
     &      **2/MW**2/SW**2*sb+6D0*Ms**2/MW**2/SW**2*sb*ssth
     &      **2)
      AAABR(2814) = EE**2/SW**2/cb*ssth**2*(sb-sb**3)
      AAABR(2815) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*ssth**2+sb**3/CW**2*ssth**2-3D0*sb
     &      /SW**2*ssth**2+3D0*sb**3/SW**2*ssth**2+6D0*Mc
     &      **2/MW**2/SW**2/sb*ssth**2-6D0*Mc**2/MW**2/SW
     &      **2*sb*ssth**2)
      AAABR(2816) = EE**2/CW**2/cb*(2D0*sb-2D0*sb**3-sb*ssth
     &      **2+sb**3*ssth**2)
      AAABR(2817) = EE**2/CW**3*SW/cb*(2D0*sb-2D0*sb**3-sb
     &      *ssth**2+sb**3*ssth**2)
      AAABR(2818) = EE**2/MW**2/SW**2/cb*(Ms**2*sb-Mc**2
     &      /sb*ssth**2+Mc**2*sb*ssth**2-Ms**2*sb*ssth**2)
      AAABR(2819) = EE**2/MW**2/SW**2/cb*(Ms**2*sb**3+Mc
     &      **2/sb*ssth**2-2D0*Mc**2*sb*ssth**2+Mc**2*sb
     &      **3*ssth**2-Ms**2*sb**3*ssth**2)
      AAABR(2820) = EE**2/MW**2*Ms/SW**2/cb*sb*(1D0-ssth**2)
      AAABR(2821) = EE**2/MW**2*Mc/SW**2/cb*ssth**2*(1D0
     &      /sb-sb)
      AAABR(2822) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sbth**2+sb**3/CW**2*sbth**2-3D0*sb
     &      /SW**2*sbth**2+3D0*sb**3/SW**2*sbth**2-6D0*Mb
     &      **2/MW**2/SW**2*sb+6D0*Mb**2/MW**2/SW**2*sb*sbth
     &      **2)
      AAABR(2823) = EE**2/SW**2/cb*sbth**2*(sb-sb**3)
      AAABR(2824) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sbth**2+sb**3/CW**2*sbth**2-3D0*sb
     &      /SW**2*sbth**2+3D0*sb**3/SW**2*sbth**2+6D0*Mt
     &      **2/MW**2/SW**2/sb*sbth**2-6D0*Mt**2/MW**2/SW
     &      **2*sb*sbth**2)
      AAABR(2825) = EE**2/CW**2/cb*(2D0*sb-2D0*sb**3-sb*sbth
     &      **2+sb**3*sbth**2)
      AAABR(2826) = EE**2/CW**3*SW/cb*(2D0*sb-2D0*sb**3-sb
     &      *sbth**2+sb**3*sbth**2)
      AAABR(2827) = EE**2/MW**2/SW**2/cb*(Mb**2*sb-Mb**2
     &      *sb*sbth**2-Mt**2/sb*sbth**2+Mt**2*sb*sbth**2)
      AAABR(2828) = EE**2/MW**2/SW**2/cb*(Mb**2*sb**3-Mb
     &      **2*sb**3*sbth**2+Mt**2/sb*sbth**2-2D0*Mt**2
     &      *sb*sbth**2+Mt**2*sb**3*sbth**2)
      AAABR(2829) = EE**2/MW**2*Mb/SW**2/cb*sb*(1D0-sbth**2)
      AAABR(2830) = EE**2/MW**2*Mt/SW**2/cb*sbth**2*(1D0
     &      /sb-sb)
      AAABR(2831) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sdth**2+sb**3/CW**2*sdth**2-3D0*sb
     &      /SW**2*sdth**2+3D0*sb**3/SW**2*sdth**2-6D0*Md
     &      **2/MW**2/SW**2*sb+6D0*Md**2/MW**2/SW**2*sb*sdth
     &      **2)
      AAABR(2832) = EE**2/SW**2/cb*sdth**2*(sb-sb**3)
      AAABR(2833) = EE**2/cb*(2D0*sb/CW**2-2D0*sb**3/CW**2
     &      -sb/CW**2*sdth**2+sb**3/CW**2*sdth**2-3D0*sb
     &      /SW**2*sdth**2+3D0*sb**3/SW**2*sdth**2+6D0*Mu
     &      **2/MW**2/SW**2/sb*sdth**2-6D0*Mu**2/MW**2/SW
     &      **2*sb*sdth**2)
      AAABR(2834) = EE**2/CW**2/cb*(2D0*sb-2D0*sb**3-sb*sdth
     &      **2+sb**3*sdth**2)
      AAABR(2835) = EE**2/CW**3*SW/cb*(2D0*sb-2D0*sb**3-sb
     &      *sdth**2+sb**3*sdth**2)
      AAABR(2836) = EE**2/MW**2/SW**2/cb*(Md**2*sb-Md**2
     &      *sb*sdth**2-Mu**2/sb*sdth**2+Mu**2*sb*sdth**2)
      AAABR(2837) = EE**2/MW**2/SW**2/cb*(Md**2*sb**3-Md
     &      **2*sb**3*sdth**2+Mu**2/sb*sdth**2-2D0*Mu**2
     &      *sb*sdth**2+Mu**2*sb**3*sdth**2)
      AAABR(2838) = EE**2/MW**2*Md/SW**2/cb*sb*(1D0-sdth**2)
      AAABR(2839) = EE**2/MW**2*Mu/SW**2/cb*sdth**2*(1D0
     &      /sb-sb)
      AAABR(2840) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*suth**2+5D0
     &      *sb**3/CW**2*suth**2-3D0*sb/SW**2*suth**2+3D0
     &      *sb**3/SW**2*suth**2-6D0*Md**2/MW**2/SW**2*sb
     &      +6D0*Md**2/MW**2/SW**2*sb*suth**2)
      AAABR(2841) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*suth**2+5D0
     &      *sb**3/CW**2*suth**2-3D0*sb/SW**2*suth**2+3D0
     &      *sb**3/SW**2*suth**2-3D0*Md**2/MW**2/SW**2*sb
     &      +3D0*Md**2/MW**2/SW**2*sb*suth**2+3D0*Mu**2/MW
     &      **2/SW**2/sb*suth**2-3D0*Mu**2/MW**2/SW**2*sb
     &      *suth**2)
      AAABR(2842) = EE**2/SW**2/cb*(sb-sb**3-sb*suth**2+sb
     &      **3*suth**2)
      AAABR(2843) = EE**2/cb*cuth*suth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0
     &      *Md**2/MW**2/SW**2*sb-3D0*Mu**2/MW**2/SW**2/sb
     &      +3D0*Mu**2/MW**2/SW**2*sb)
      AAABR(2844) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*suth**2+5D0
     &      *sb**3/CW**2*suth**2-3D0*sb/SW**2*suth**2+3D0
     &      *sb**3/SW**2*suth**2+6D0*Mu**2/MW**2/SW**2/sb
     &      *suth**2-6D0*Mu**2/MW**2/SW**2*sb*suth**2)
      AAABR(2845) = EE**2/CW**2/cb*(sb-sb**3-5D0*sb*suth
     &      **2+5D0*sb**3*suth**2)
      AAABR(2846) = EE**2/CW**3*SW/cb*(sb-sb**3-5D0*sb*suth
     &      **2+5D0*sb**3*suth**2)
      AAABR(2847) = EE**2/MW**2/SW**2/cb*(Md**2*sb-Md**2
     &      *sb*suth**2-Mu**2/sb*suth**2+Mu**2*sb*suth**2)
      AAABR(2848) = EE**2/MW**2/SW**2/cb*(Md**2*sb**3-Md
     &      **2*sb**3*suth**2+Mu**2/sb*suth**2-2D0*Mu**2
     &      *sb*suth**2+Mu**2*sb**3*suth**2)
      AAABR(2849) = EE**2/MW**2*Mu/SW**2/cb*suth**2*(1D0
     &      /sb-sb)
      AAABR(2850) = EE**2/MW**2*Md/SW**2/cb*sb*(1D0-suth**2)
      AAABR(2851) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*scth**2+5D0
     &      *sb**3/CW**2*scth**2-3D0*sb/SW**2*scth**2+3D0
     &      *sb**3/SW**2*scth**2-6D0*Ms**2/MW**2/SW**2*sb
     &      +6D0*Ms**2/MW**2/SW**2*sb*scth**2)
      AAABR(2852) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*scth**2+5D0
     &      *sb**3/CW**2*scth**2-3D0*sb/SW**2*scth**2+3D0
     &      *sb**3/SW**2*scth**2-3D0*Ms**2/MW**2/SW**2*sb
     &      +3D0*Mc**2/MW**2/SW**2/sb*scth**2-3D0*Mc**2/MW
     &      **2/SW**2*sb*scth**2+3D0*Ms**2/MW**2/SW**2*sb
     &      *scth**2)
      AAABR(2853) = EE**2/SW**2/cb*(sb-sb**3-sb*scth**2+sb
     &      **3*scth**2)
      AAABR(2854) = EE**2/cb*ccth*scth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0
     &      *Mc**2/MW**2/SW**2/sb+3D0*Mc**2/MW**2/SW**2*sb
     &      -3D0*Ms**2/MW**2/SW**2*sb)
      AAABR(2855) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*scth**2+5D0
     &      *sb**3/CW**2*scth**2-3D0*sb/SW**2*scth**2+3D0
     &      *sb**3/SW**2*scth**2+6D0*Mc**2/MW**2/SW**2/sb
     &      *scth**2-6D0*Mc**2/MW**2/SW**2*sb*scth**2)
      AAABR(2856) = EE**2/CW**2/cb*(sb-sb**3-5D0*sb*scth
     &      **2+5D0*sb**3*scth**2)
      AAABR(2857) = EE**2/CW**3*SW/cb*(sb-sb**3-5D0*sb*scth
     &      **2+5D0*sb**3*scth**2)
      AAABR(2858) = EE**2/MW**2/SW**2/cb*(Ms**2*sb-Mc**2
     &      /sb*scth**2+Mc**2*sb*scth**2-Ms**2*sb*scth**2)
      AAABR(2859) = EE**2/MW**2/SW**2/cb*(Ms**2*sb**3+Mc
     &      **2/sb*scth**2-2D0*Mc**2*sb*scth**2+Mc**2*sb
     &      **3*scth**2-Ms**2*sb**3*scth**2)
      AAABR(2860) = EE**2/MW**2*Mc/SW**2/cb*scth**2*(1D0
     &      /sb-sb)
      AAABR(2861) = EE**2/MW**2*Ms/SW**2/cb*sb*(1D0-scth**2)
      AAABR(2862) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*stth**2+5D0
     &      *sb**3/CW**2*stth**2-3D0*sb/SW**2*stth**2+3D0
     &      *sb**3/SW**2*stth**2-6D0*Mb**2/MW**2/SW**2*sb
     &      +6D0*Mb**2/MW**2/SW**2*sb*stth**2)
      AAABR(2863) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*stth**2+5D0
     &      *sb**3/CW**2*stth**2-3D0*sb/SW**2*stth**2+3D0
     &      *sb**3/SW**2*stth**2-3D0*Mb**2/MW**2/SW**2*sb
     &      +3D0*Mb**2/MW**2/SW**2*sb*stth**2+3D0*Mt**2/MW
     &      **2/SW**2/sb*stth**2-3D0*Mt**2/MW**2/SW**2*sb
     &      *stth**2)
      AAABR(2864) = EE**2/SW**2/cb*(sb-sb**3-sb*stth**2+sb
     &      **3*stth**2)
      AAABR(2865) = EE**2/cb*ctth*stth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-3D0
     &      *Mb**2/MW**2/SW**2*sb-3D0*Mt**2/MW**2/SW**2/sb
     &      +3D0*Mt**2/MW**2/SW**2*sb)
      AAABR(2866) = EE**2/cb*(sb/CW**2-sb**3/CW**2+3D0*sb
     &      /SW**2-3D0*sb**3/SW**2-5D0*sb/CW**2*stth**2+5D0
     &      *sb**3/CW**2*stth**2-3D0*sb/SW**2*stth**2+3D0
     &      *sb**3/SW**2*stth**2+6D0*Mt**2/MW**2/SW**2/sb
     &      *stth**2-6D0*Mt**2/MW**2/SW**2*sb*stth**2)
      AAABR(2867) = EE**2/CW**2/cb*(sb-sb**3-5D0*sb*stth
     &      **2+5D0*sb**3*stth**2)
      AAABR(2868) = EE**2/CW**3*SW/cb*(sb-sb**3-5D0*sb*stth
     &      **2+5D0*sb**3*stth**2)
      AAABR(2869) = EE**2/MW**2/SW**2/cb*(Mb**2*sb-Mb**2
     &      *sb*stth**2-Mt**2/sb*stth**2+Mt**2*sb*stth**2)
      AAABR(2870) = EE**2/MW**2/SW**2/cb*(Mb**2*sb**3-Mb
     &      **2*sb**3*stth**2+Mt**2/sb*stth**2-2D0*Mt**2
     &      *sb*stth**2+Mt**2*sb**3*stth**2)
      AAABR(2871) = EE**2/MW**2*Mt/SW**2/cb*stth**2*(1D0
     &      /sb-sb)
      AAABR(2872) = EE**2/MW**2*Mb/SW**2/cb*sb*(1D0-stth**2)
      AAABR(2873) = EE**2/cb*cuth*suth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Md**2/MW**2/SW**2*sb)
      AAABR(2874) = EE**2/SW**2/cb*cuth*suth*(sb-sb**3)
      AAABR(2875) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*suth**2+5D0*sb**3/CW**2*suth**2
     &      -3D0*sb/SW**2*suth**2+3D0*sb**3/SW**2*suth**2
     &      -3D0*Mu**2/MW**2/SW**2/sb+3D0*Mu**2/MW**2/SW
     &      **2*sb+3D0*Md**2/MW**2/SW**2*sb*suth**2+3D0*Mu
     &      **2/MW**2/SW**2/sb*suth**2-3D0*Mu**2/MW**2/SW
     &      **2*sb*suth**2)
      AAABR(2876) = EE**2/cb*cuth*suth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Mu**2/MW**2/SW**2/sb+6D0*Mu**2/MW**2/SW**2*sb)
      AAABR(2877) = EE**2/CW**2/cb*cuth*suth*(sb-sb**3)
      AAABR(2878) = EE**2/CW**3*SW/cb*cuth*suth*(sb-sb**3)
      AAABR(2879) = EE**2/MW**2/SW**2/cb*cuth*suth*(Md**2
     &      *sb+Mu**2/sb-Mu**2*sb)
      AAABR(2880) = EE**2/MW**2/SW**2/cb*cuth*suth*(Md**2
     &      *sb**3-Mu**2/sb+2D0*Mu**2*sb-Mu**2*sb**3)
      AAABR(2881) = EE**2/MW**2*Mu/SW**2/cb*cuth*suth*(1D0
     &      /sb-sb)
      AAABR(2882) = EE**2/MW**2*Md/SW**2/cb*cuth*sb*suth
      AAABR(2883) = EE**2/cb*ccth*scth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Ms**2/MW**2/SW**2*sb)
      AAABR(2884) = EE**2/SW**2/cb*ccth*scth*(sb-sb**3)
      AAABR(2885) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*scth**2+5D0*sb**3/CW**2*scth**2
     &      -3D0*sb/SW**2*scth**2+3D0*sb**3/SW**2*scth**2
     &      -3D0*Mc**2/MW**2/SW**2/sb+3D0*Mc**2/MW**2/SW
     &      **2*sb+3D0*Mc**2/MW**2/SW**2/sb*scth**2-3D0*Mc
     &      **2/MW**2/SW**2*sb*scth**2+3D0*Ms**2/MW**2/SW
     &      **2*sb*scth**2)
      AAABR(2886) = EE**2/cb*ccth*scth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Mc**2/MW**2/SW**2/sb+6D0*Mc**2/MW**2/SW**2*sb)
      AAABR(2887) = EE**2/CW**2/cb*ccth*scth*(sb-sb**3)
      AAABR(2888) = EE**2/CW**3*SW/cb*ccth*scth*(sb-sb**3)
      AAABR(2889) = EE**2/MW**2/SW**2/cb*ccth*scth*(Mc**2
     &      /sb-Mc**2*sb+Ms**2*sb)
      AAABR(2890) = EE**2/MW**2/SW**2/cb*ccth*scth*(Mc**2
     &      /sb-2D0*Mc**2*sb+Mc**2*sb**3-Ms**2*sb**3)
      AAABR(2891) = EE**2/MW**2*Mc/SW**2/cb*ccth*scth*(1D0
     &      /sb-sb)
      AAABR(2892) = EE**2/MW**2*Ms/SW**2/cb*ccth*sb*scth
      AAABR(2893) = EE**2/cb*ctth*stth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Mb**2/MW**2/SW**2*sb)
      AAABR(2894) = EE**2/SW**2/cb*ctth*stth*(sb-sb**3)
      AAABR(2895) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*stth**2+5D0*sb**3/CW**2*stth**2
     &      -3D0*sb/SW**2*stth**2+3D0*sb**3/SW**2*stth**2
     &      -3D0*Mt**2/MW**2/SW**2/sb+3D0*Mt**2/MW**2/SW
     &      **2*sb+3D0*Mb**2/MW**2/SW**2*sb*stth**2+3D0*Mt
     &      **2/MW**2/SW**2/sb*stth**2-3D0*Mt**2/MW**2/SW
     &      **2*sb*stth**2)
      AAABR(2896) = EE**2/cb*ctth*stth*(5D0*sb/CW**2-5D0
     &      *sb**3/CW**2+3D0*sb/SW**2-3D0*sb**3/SW**2-6D0
     &      *Mt**2/MW**2/SW**2/sb+6D0*Mt**2/MW**2/SW**2*sb)
      AAABR(2897) = EE**2/CW**2/cb*ctth*stth*(sb-sb**3)
      AAABR(2898) = EE**2/CW**3*SW/cb*ctth*stth*(sb-sb**3)
      AAABR(2899) = EE**2/MW**2/SW**2/cb*ctth*stth*(Mb**2
     &      *sb+Mt**2/sb-Mt**2*sb)
      AAABR(2900) = EE**2/MW**2/SW**2/cb*ctth*stth*(Mb**2
     &      *sb**3-Mt**2/sb+2D0*Mt**2*sb-Mt**2*sb**3)
      AAABR(2901) = EE**2/MW**2*Mt/SW**2/cb*ctth*stth*(1D0
     &      /sb-sb)
      AAABR(2902) = EE**2/MW**2*Mb/SW**2/cb*ctth*sb*stth
      AAABR(2903) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Ms**2/MW**2*ccth*csth*sb+Mc/MW**2
     &      *Ms*sb*scth*ssth)
      AAABR(2904) = EE**2/SW**2*Sqrt2/cb*(2D0*ccth*csth*sb
     &      -2D0*ccth*csth*sb**3-Mc**2/MW**2*ccth*csth/sb
     &      +Mc**2/MW**2*ccth*csth*sb-Ms**2/MW**2*ccth*csth
     &      *sb+Mc/MW**2*Ms/sb*scth*ssth)
      AAABR(2905) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Ms**2/MW**2*ccth*csth*sb+Mc/MW**2
     &      *Ms/sb*scth*ssth-Mc/MW**2*Ms*sb*scth*ssth)
      AAABR(2906) = EE**2/SW**2*Sqrt2/cb*ccth*csth*(sb-sb
     &      **3)
      AAABR(2907) = EE**2/SW**2*Sqrt2/cb*(2D0*ccth*sb*ssth
     &      -2D0*ccth*sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth
     &      +Mc**2/MW**2*ccth*sb*ssth-Ms**2/MW**2*ccth*sb
     &      *ssth-Mc/MW**2*Ms*csth/sb*scth)
      AAABR(2908) = EE**2/SW**2*Sqrt2/cb*(2D0*csth*sb*scth
     &      -2D0*csth*sb**3*scth-Mc**2/MW**2*csth/sb*scth
     &      +Mc**2/MW**2*csth*sb*scth-Ms**2/MW**2*csth*sb
     &      *scth-Mc/MW**2*Ms*ccth/sb*ssth)
      AAABR(2909) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Mc**2/MW**2*ccth*csth/sb+Mc**2/MW
     &      **2*ccth*csth*sb+Mc/MW**2*Ms*sb*scth*ssth)
      AAABR(2910) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Mc**2/MW**2*ccth*csth/sb+Mc**2/MW
     &      **2*ccth*csth*sb+Mc/MW**2*Ms/sb*scth*ssth-Mc
     &      /MW**2*Ms*sb*scth*ssth)
      AAABR(2911) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*ccth
     &      *csth/sb-Mc**2*ccth*csth*sb+Ms**2*ccth*csth*sb
     &      -Mc*Ms/sb*scth*ssth)
      AAABR(2912) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc/sb*scth
     &      *ssth-2D0*Ms*ccth*csth*sb)
      AAABR(2913) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *ccth*csth/sb-4D0*Mc**2*ccth*csth*sb+2D0*Mc**2
     &      *ccth*csth*sb**3-2D0*Ms**2*ccth*csth*sb**3-Mc
     &      *Ms/sb*scth*ssth+2D0*Mc*Ms*sb*scth*ssth)
      AAABR(2914) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*ccth
     &      *csth/sb-2D0*Mc*ccth*csth*sb-Ms/sb*scth*ssth)
      AAABR(2915) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb+Mb/MW**2
     &      *Mt*sb*sbth*stth)
      AAABR(2916) = EE**2/SW**2*Sqrt2/cb*(2D0*cbth*ctth*sb
     &      -2D0*cbth*ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb
     &      -Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW**2*cbth*ctth
     &      *sb+Mb/MW**2*Mt/sb*sbth*stth)
      AAABR(2917) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb+Mb/MW**2
     &      *Mt/sb*sbth*stth-Mb/MW**2*Mt*sb*sbth*stth)
      AAABR(2918) = EE**2/SW**2*Sqrt2/cb*cbth*ctth*(sb-sb
     &      **3)
      AAABR(2919) = EE**2/SW**2*Sqrt2/cb*(2D0*ctth*sb*sbth
     &      -2D0*ctth*sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth
     &      -Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW**2*ctth*sb
     &      *sbth-Mb/MW**2*Mt*cbth/sb*stth)
      AAABR(2920) = EE**2/SW**2*Sqrt2/cb*(2D0*cbth*sb*stth
     &      -2D0*cbth*sb**3*stth-Mb**2/MW**2*cbth*sb*stth
     &      -Mt**2/MW**2*cbth/sb*stth+Mt**2/MW**2*cbth*sb
     &      *stth-Mb/MW**2*Mt*ctth/sb*sbth)
      AAABR(2921) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW
     &      **2*cbth*ctth*sb+Mb/MW**2*Mt*sb*sbth*stth)
      AAABR(2922) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW
     &      **2*cbth*ctth*sb+Mb/MW**2*Mt/sb*sbth*stth-Mb
     &      /MW**2*Mt*sb*sbth*stth)
      AAABR(2923) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*cbth
     &      *ctth*sb+Mt**2*cbth*ctth/sb-Mt**2*cbth*ctth*sb
     &      -Mb*Mt/sb*sbth*stth)
      AAABR(2924) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*cbth
     &      *ctth*sb-Mt/sb*sbth*stth)
      end

      subroutine aaini05
      implicit none
#include "model.h"

      AAABR(2925) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *cbth*ctth*sb**3-2D0*Mt**2*cbth*ctth/sb+4D0*Mt
     &      **2*cbth*ctth*sb-2D0*Mt**2*cbth*ctth*sb**3+Mb
     &      *Mt/sb*sbth*stth-2D0*Mb*Mt*sb*sbth*stth)
      AAABR(2926) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb/sb*sbth
     &      *stth-2D0*Mt*cbth*ctth/sb+2D0*Mt*cbth*ctth*sb)
      AAABR(2927) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Md**2/MW**2*cdth*cuth*sb+Md/MW**2
     &      *Mu*sb*sdth*suth)
      AAABR(2928) = EE**2/SW**2*Sqrt2/cb*(2D0*cdth*cuth*sb
     &      -2D0*cdth*cuth*sb**3-Md**2/MW**2*cdth*cuth*sb
     &      -Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW**2*cdth*cuth
     &      *sb+Md/MW**2*Mu/sb*sdth*suth)
      AAABR(2929) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Md**2/MW**2*cdth*cuth*sb+Md/MW**2
     &      *Mu/sb*sdth*suth-Md/MW**2*Mu*sb*sdth*suth)
      AAABR(2930) = EE**2/SW**2*Sqrt2/cb*cdth*cuth*(sb-sb
     &      **3)
      AAABR(2931) = EE**2/SW**2*Sqrt2/cb*(2D0*cuth*sb*sdth
     &      -2D0*cuth*sb**3*sdth-Md**2/MW**2*cuth*sb*sdth
     &      -Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW**2*cuth*sb
     &      *sdth-Md/MW**2*Mu*cdth/sb*suth)
      AAABR(2932) = EE**2/SW**2*Sqrt2/cb*(2D0*cdth*sb*suth
     &      -2D0*cdth*sb**3*suth-Md**2/MW**2*cdth*sb*suth
     &      -Mu**2/MW**2*cdth/sb*suth+Mu**2/MW**2*cdth*sb
     &      *suth-Md/MW**2*Mu*cuth/sb*sdth)
      AAABR(2933) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW
     &      **2*cdth*cuth*sb+Md/MW**2*Mu*sb*sdth*suth)
      AAABR(2934) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW
     &      **2*cdth*cuth*sb+Md/MW**2*Mu/sb*sdth*suth-Md
     &      /MW**2*Mu*sb*sdth*suth)
      AAABR(2935) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cdth
     &      *cuth*sb+Mu**2*cdth*cuth/sb-Mu**2*cdth*cuth*sb
     &      -Md*Mu/sb*sdth*suth)
      AAABR(2936) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cdth
     &      *cuth*sb-Mu/sb*sdth*suth)
      AAABR(2937) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cdth*cuth*sb**3-2D0*Mu**2*cdth*cuth/sb+4D0*Mu
     &      **2*cdth*cuth*sb-2D0*Mu**2*cdth*cuth*sb**3+Md
     &      *Mu/sb*sdth*suth-2D0*Md*Mu*sb*sdth*suth)
      AAABR(2938) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md/sb*sdth
     &      *suth-2D0*Mu*cdth*cuth/sb+2D0*Mu*cdth*cuth*sb)
      AAABR(2939) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Md**2/MW**2*cuth*sb*sdth-Md/MW**2
     &      *Mu*cdth*sb*suth)
      AAABR(2940) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Md**2/MW**2*cuth*sb*sdth-Md/MW**2
     &      *Mu*cdth/sb*suth+Md/MW**2*Mu*cdth*sb*suth)
      AAABR(2941) = EE**2/SW**2*Sqrt2/cb*cuth*sdth*(sb-sb
     &      **3)
      AAABR(2942) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*sdth*suth
     &      -2D0*sb**3*sdth*suth-Md**2/MW**2*sb*sdth*suth
     &      -Mu**2/MW**2/sb*sdth*suth+Mu**2/MW**2*sb*sdth
     &      *suth+Md/MW**2*Mu*cdth*cuth/sb)
      AAABR(2943) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW
     &      **2*cuth*sb*sdth-Md/MW**2*Mu*cdth*sb*suth)
      AAABR(2944) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW
     &      **2*cuth*sb*sdth-Md/MW**2*Mu*cdth/sb*suth+Md
     &      /MW**2*Mu*cdth*sb*suth)
      AAABR(2945) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cuth
     &      *sb*sdth+Mu**2*cuth/sb*sdth-Mu**2*cuth*sb*sdth
     &      +Md*Mu*cdth/sb*suth)
      AAABR(2946) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cuth
     &      *sb*sdth+Mu*cdth/sb*suth)
      AAABR(2947) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cuth*sb**3*sdth-2D0*Mu**2*cuth/sb*sdth+4D0*Mu
     &      **2*cuth*sb*sdth-2D0*Mu**2*cuth*sb**3*sdth-Md
     &      *Mu*cdth/sb*suth+2D0*Md*Mu*cdth*sb*suth)
      AAABR(2948) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cdth/sb
     &      *suth+2D0*Mu*cuth/sb*sdth-2D0*Mu*cuth*sb*sdth)
      AAABR(2949) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth-Mb/MW**2
     &      *Mt*cbth*sb*stth)
      AAABR(2950) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth-Mb/MW**2
     &      *Mt*cbth/sb*stth+Mb/MW**2*Mt*cbth*sb*stth)
      AAABR(2951) = EE**2/SW**2*Sqrt2/cb*ctth*sbth*(sb-sb
     &      **3)
      AAABR(2952) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*sbth*stth
     &      -2D0*sb**3*sbth*stth-Mb**2/MW**2*sb*sbth*stth
     &      -Mt**2/MW**2/sb*sbth*stth+Mt**2/MW**2*sb*sbth
     &      *stth+Mb/MW**2*Mt*cbth*ctth/sb)
      AAABR(2953) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW
     &      **2*ctth*sb*sbth-Mb/MW**2*Mt*cbth*sb*stth)
      AAABR(2954) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW
     &      **2*ctth*sb*sbth-Mb/MW**2*Mt*cbth/sb*stth+Mb
     &      /MW**2*Mt*cbth*sb*stth)
      AAABR(2955) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*ctth
     &      *sb*sbth+Mt**2*ctth/sb*sbth-Mt**2*ctth*sb*sbth
     &      +Mb*Mt*cbth/sb*stth)
      AAABR(2956) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*ctth
     &      *sb*sbth+Mt*cbth/sb*stth)
      AAABR(2957) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *ctth*sb**3*sbth-2D0*Mt**2*ctth/sb*sbth+4D0*Mt
     &      **2*ctth*sb*sbth-2D0*Mt**2*ctth*sb**3*sbth-Mb
     &      *Mt*cbth/sb*stth+2D0*Mb*Mt*cbth*sb*stth)
      AAABR(2958) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*cbth/sb
     &      *stth+2D0*Mt*ctth/sb*sbth-2D0*Mt*ctth*sb*sbth)
      AAABR(2959) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Ms**2/MW**2*ccth*sb*ssth-Mc/MW**2
     &      *Ms*csth*sb*scth)
      AAABR(2960) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Ms**2/MW**2*ccth*sb*ssth-Mc/MW**2
     &      *Ms*csth/sb*scth+Mc/MW**2*Ms*csth*sb*scth)
      AAABR(2961) = EE**2/SW**2*Sqrt2/cb*ccth*ssth*(sb-sb
     &      **3)
      AAABR(2962) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*scth*ssth
     &      -2D0*sb**3*scth*ssth-Mc**2/MW**2/sb*scth*ssth
     &      +Mc**2/MW**2*sb*scth*ssth-Ms**2/MW**2*sb*scth
     &      *ssth+Mc/MW**2*Ms*ccth*csth/sb)
      AAABR(2963) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth+Mc**2/MW
     &      **2*ccth*sb*ssth-Mc/MW**2*Ms*csth*sb*scth)
      AAABR(2964) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth+Mc**2/MW
     &      **2*ccth*sb*ssth-Mc/MW**2*Ms*csth/sb*scth+Mc
     &      /MW**2*Ms*csth*sb*scth)
      AAABR(2965) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*ccth
     &      /sb*ssth-Mc**2*ccth*sb*ssth+Ms**2*ccth*sb*ssth
     &      +Mc*Ms*csth/sb*scth)
      AAABR(2966) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*csth/sb
     &      *scth+2D0*Ms*ccth*sb*ssth)
      AAABR(2967) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *ccth/sb*ssth-4D0*Mc**2*ccth*sb*ssth+2D0*Mc**2
     &      *ccth*sb**3*ssth-2D0*Ms**2*ccth*sb**3*ssth+Mc
     &      *Ms*csth/sb*scth-2D0*Mc*Ms*csth*sb*scth)
      AAABR(2968) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*ccth
     &      /sb*ssth-2D0*Mc*ccth*sb*ssth+Ms*csth/sb*scth)
      AAABR(2969) = EE**2/SW**2*Sqrt2*(ca/cb**2*ccth*csth
     &      *sb-ca/cb**2*ccth*csth*sb**3-Mc/MW**2*Ms/cb*sa
     &      *scth*ssth-Ms**2/MW**2*ca/cb**2*ccth*csth*sb)
      AAABR(2970) = EE**2/SW**2*Sqrt2*(ccth/cb*csth*sa+ca
     &      /cb**2*ccth*csth*sb-ca/cb**2*ccth*csth*sb**3
     &      -ccth/cb*csth*sa*sb**2+Mc**2/MW**2/cb*ccth*csth
     &      *sa-Mc/MW**2*Ms/cb*sa*scth*ssth-Mc**2/MW**2/cb
     &      *ccth*csth*sa/sb**2-Ms**2/MW**2*ca/cb**2*ccth
     &      *csth*sb-Mc/MW**2*Ms*ca/cb**2/sb*scth*ssth+Mc
     &      /MW**2*Ms*ca/cb**2*sb*scth*ssth)
      AAABR(2971) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*csth-ca
     &      /cb*ccth*csth*sb**2-ccth/cb**2*csth*sa*sb+ccth
     &      /cb**2*csth*sa*sb**3+Mc**2/MW**2*ca/cb*ccth*csth
     &      -Mc/MW**2*Ms*ca/cb*scth*ssth-Mc**2/MW**2*ca/cb
     &      *ccth*csth/sb**2+Ms**2/MW**2/cb**2*ccth*csth
     &      *sa*sb+Mc/MW**2*Ms/cb**2*sa/sb*scth*ssth-Mc/MW
     &      **2*Ms/cb**2*sa*sb*scth*ssth)
      AAABR(2972) = EE**2/SW**2*Sqrt2*ccth*csth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2973) = EE**2/SW**2*Sqrt2*(ccth/cb*sa*ssth+ca
     &      /cb**2*ccth*sb*ssth-ca/cb**2*ccth*sb**3*ssth
     &      -ccth/cb*sa*sb**2*ssth+Mc**2/MW**2/cb*ccth*sa
     &      *ssth+Mc/MW**2*Ms/cb*csth*sa*scth-Mc**2/MW**2
     &      /cb*ccth*sa/sb**2*ssth-Ms**2/MW**2*ca/cb**2*ccth
     &      *sb*ssth+Mc/MW**2*Ms*ca/cb**2*csth/sb*scth-Mc
     &      /MW**2*Ms*ca/cb**2*csth*sb*scth)
      AAABR(2974) = EE**2/SW**2*Sqrt2*(csth/cb*sa*scth+ca
     &      /cb**2*csth*sb*scth-ca/cb**2*csth*sb**3*scth
     &      -csth/cb*sa*sb**2*scth+Mc**2/MW**2/cb*csth*sa
     &      *scth+Mc/MW**2*Ms/cb*ccth*sa*ssth-Mc**2/MW**2
     &      /cb*csth*sa/sb**2*scth-Ms**2/MW**2*ca/cb**2*csth
     &      *sb*scth+Mc/MW**2*Ms*ca/cb**2*ccth/sb*ssth-Mc
     &      /MW**2*Ms*ca/cb**2*ccth*sb*ssth)
      AAABR(2975) = EE**2/SW**2*Sqrt2*(ccth/cb*csth*sa-ccth
     &      /cb*csth*sa*sb**2+Mc**2/MW**2/cb*ccth*csth*sa
     &      -Mc**2/MW**2/cb*ccth*csth*sa/sb**2-Mc/MW**2*Ms
     &      *ca/cb**2/sb*scth*ssth+Mc/MW**2*Ms*ca/cb**2*sb
     &      *scth*ssth)
      AAABR(2976) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2/cb*ccth
     &      *csth*sa-Mc*Ms/cb*sa*scth*ssth-Mc**2/cb*ccth
     &      *csth*sa/sb**2-Ms**2*ca/cb**2*ccth*csth*sb-Mc
     &      *Ms*ca/cb**2/sb*scth*ssth+Mc*Ms*ca/cb**2*sb*scth
     &      *ssth)
      AAABR(2977) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2/cb
     &      *ccth*csth*sa-Mc*Ms/cb*sa*scth*ssth-2D0*Mc**2
     &      /cb*ccth*csth*sa/sb**2-2D0*Mc**2/cb*ccth*csth
     &      *sa*sb**2+2D0*Ms**2*ca/cb**2*ccth*csth*sb**3
     &      -Mc*Ms*ca/cb**2/sb*scth*ssth+3D0*Mc*Ms*ca/cb
     &      **2*sb*scth*ssth-2D0*Mc*Ms*ca/cb**2*sb**3*scth
     &      *ssth+2D0*Mc*Ms/cb*sa*sb**2*scth*ssth)
      AAABR(2978) = EE**2/MW**2/SW**2*Sqrt2*(Mc/cb*sa*scth
     &      *ssth+Mc*ca/cb**2/sb*scth*ssth-Mc*ca/cb**2*sb
     &      *scth*ssth+2D0*Ms*ca/cb**2*ccth*csth*sb)
      AAABR(2979) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc/cb*ccth
     &      *csth*sa-Ms/cb*sa*scth*ssth-2D0*Mc/cb*ccth*csth
     &      *sa/sb**2-Ms*ca/cb**2/sb*scth*ssth+Ms*ca/cb**2
     &      *sb*scth*ssth)
      AAABR(2980) = EE**2/SW**2*Sqrt2*(ca/cb**2*cbth*ctth
     &      *sb-ca/cb**2*cbth*ctth*sb**3-Mb/MW**2*Mt/cb*sa
     &      *sbth*stth-Mb**2/MW**2*ca/cb**2*cbth*ctth*sb)
      AAABR(2981) = EE**2/SW**2*Sqrt2*(cbth/cb*ctth*sa+ca
     &      /cb**2*cbth*ctth*sb-ca/cb**2*cbth*ctth*sb**3
     &      -cbth/cb*ctth*sa*sb**2+Mt**2/MW**2/cb*cbth*ctth
     &      *sa-Mb/MW**2*Mt/cb*sa*sbth*stth-Mb**2/MW**2*ca
     &      /cb**2*cbth*ctth*sb-Mt**2/MW**2/cb*cbth*ctth
     &      *sa/sb**2-Mb/MW**2*Mt*ca/cb**2/sb*sbth*stth+Mb
     &      /MW**2*Mt*ca/cb**2*sb*sbth*stth)
      AAABR(2982) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*ctth-ca
     &      /cb*cbth*ctth*sb**2-cbth/cb**2*ctth*sa*sb+cbth
     &      /cb**2*ctth*sa*sb**3+Mt**2/MW**2*ca/cb*cbth*ctth
     &      -Mb/MW**2*Mt*ca/cb*sbth*stth+Mb**2/MW**2/cb**2
     &      *cbth*ctth*sa*sb-Mt**2/MW**2*ca/cb*cbth*ctth
     &      /sb**2+Mb/MW**2*Mt/cb**2*sa/sb*sbth*stth-Mb/MW
     &      **2*Mt/cb**2*sa*sb*sbth*stth)
      AAABR(2983) = EE**2/SW**2*Sqrt2*cbth*ctth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2984) = EE**2/SW**2*Sqrt2*(ctth/cb*sa*sbth+ca
     &      /cb**2*ctth*sb*sbth-ca/cb**2*ctth*sb**3*sbth
     &      -ctth/cb*sa*sb**2*sbth+Mt**2/MW**2/cb*ctth*sa
     &      *sbth+Mb/MW**2*Mt/cb*cbth*sa*stth-Mb**2/MW**2
     &      *ca/cb**2*ctth*sb*sbth-Mt**2/MW**2/cb*ctth*sa
     &      /sb**2*sbth+Mb/MW**2*Mt*ca/cb**2*cbth/sb*stth
     &      -Mb/MW**2*Mt*ca/cb**2*cbth*sb*stth)
      AAABR(2985) = EE**2/SW**2*Sqrt2*(cbth/cb*sa*stth+ca
     &      /cb**2*cbth*sb*stth-ca/cb**2*cbth*sb**3*stth
     &      -cbth/cb*sa*sb**2*stth+Mt**2/MW**2/cb*cbth*sa
     &      *stth+Mb/MW**2*Mt/cb*ctth*sa*sbth-Mb**2/MW**2
     &      *ca/cb**2*cbth*sb*stth-Mt**2/MW**2/cb*cbth*sa
     &      /sb**2*stth+Mb/MW**2*Mt*ca/cb**2*ctth/sb*sbth
     &      -Mb/MW**2*Mt*ca/cb**2*ctth*sb*sbth)
      AAABR(2986) = EE**2/SW**2*Sqrt2*(cbth/cb*ctth*sa-cbth
     &      /cb*ctth*sa*sb**2+Mt**2/MW**2/cb*cbth*ctth*sa
     &      -Mt**2/MW**2/cb*cbth*ctth*sa/sb**2-Mb/MW**2*Mt
     &      *ca/cb**2/sb*sbth*stth+Mb/MW**2*Mt*ca/cb**2*sb
     &      *sbth*stth)
      AAABR(2987) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2/cb*cbth
     &      *ctth*sa-Mb*Mt/cb*sa*sbth*stth-Mb**2*ca/cb**2
     &      *cbth*ctth*sb-Mt**2/cb*cbth*ctth*sa/sb**2-Mb
     &      *Mt*ca/cb**2/sb*sbth*stth+Mb*Mt*ca/cb**2*sb*sbth
     &      *stth)
      AAABR(2988) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2/cb
     &      *cbth*ctth*sa-Mb*Mt/cb*sa*sbth*stth+2D0*Mb**2
     &      *ca/cb**2*cbth*ctth*sb**3-2D0*Mt**2/cb*cbth*ctth
     &      *sa/sb**2-2D0*Mt**2/cb*cbth*ctth*sa*sb**2-Mb
     &      *Mt*ca/cb**2/sb*sbth*stth+3D0*Mb*Mt*ca/cb**2
     &      *sb*sbth*stth-2D0*Mb*Mt*ca/cb**2*sb**3*sbth*stth
     &      +2D0*Mb*Mt/cb*sa*sb**2*sbth*stth)
      AAABR(2989) = EE**2/MW**2/SW**2*Sqrt2*(Mt/cb*sa*sbth
     &      *stth+2D0*Mb*ca/cb**2*cbth*ctth*sb+Mt*ca/cb**2
     &      /sb*sbth*stth-Mt*ca/cb**2*sb*sbth*stth)
      AAABR(2990) = EE**2/MW**2/SW**2*Sqrt2*(Mb/cb*sa*sbth
     &      *stth-2D0*Mt/cb*cbth*ctth*sa+Mb*ca/cb**2/sb*sbth
     &      *stth-Mb*ca/cb**2*sb*sbth*stth+2D0*Mt/cb*cbth
     &      *ctth*sa/sb**2)
      AAABR(2991) = EE**2/SW**2*Sqrt2*(ca/cb**2*cdth*cuth
     &      *sb-ca/cb**2*cdth*cuth*sb**3-Md/MW**2*Mu/cb*sa
     &      *sdth*suth-Md**2/MW**2*ca/cb**2*cdth*cuth*sb)
      AAABR(2992) = EE**2/SW**2*Sqrt2*(cdth/cb*cuth*sa+ca
     &      /cb**2*cdth*cuth*sb-ca/cb**2*cdth*cuth*sb**3
     &      -cdth/cb*cuth*sa*sb**2+Mu**2/MW**2/cb*cdth*cuth
     &      *sa-Md/MW**2*Mu/cb*sa*sdth*suth-Md**2/MW**2*ca
     &      /cb**2*cdth*cuth*sb-Mu**2/MW**2/cb*cdth*cuth
     &      *sa/sb**2-Md/MW**2*Mu*ca/cb**2/sb*sdth*suth+Md
     &      /MW**2*Mu*ca/cb**2*sb*sdth*suth)
      AAABR(2993) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*cuth-ca
     &      /cb*cdth*cuth*sb**2-cdth/cb**2*cuth*sa*sb+cdth
     &      /cb**2*cuth*sa*sb**3+Mu**2/MW**2*ca/cb*cdth*cuth
     &      -Md/MW**2*Mu*ca/cb*sdth*suth+Md**2/MW**2/cb**2
     &      *cdth*cuth*sa*sb-Mu**2/MW**2*ca/cb*cdth*cuth
     &      /sb**2+Md/MW**2*Mu/cb**2*sa/sb*sdth*suth-Md/MW
     &      **2*Mu/cb**2*sa*sb*sdth*suth)
      AAABR(2994) = EE**2/SW**2*Sqrt2*cdth*cuth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(2995) = EE**2/SW**2*Sqrt2*(cuth/cb*sa*sdth+ca
     &      /cb**2*cuth*sb*sdth-ca/cb**2*cuth*sb**3*sdth
     &      -cuth/cb*sa*sb**2*sdth+Mu**2/MW**2/cb*cuth*sa
     &      *sdth+Md/MW**2*Mu/cb*cdth*sa*suth-Md**2/MW**2
     &      *ca/cb**2*cuth*sb*sdth-Mu**2/MW**2/cb*cuth*sa
     &      /sb**2*sdth+Md/MW**2*Mu*ca/cb**2*cdth/sb*suth
     &      -Md/MW**2*Mu*ca/cb**2*cdth*sb*suth)
      AAABR(2996) = EE**2/SW**2*Sqrt2*(cdth/cb*sa*suth+ca
     &      /cb**2*cdth*sb*suth-ca/cb**2*cdth*sb**3*suth
     &      -cdth/cb*sa*sb**2*suth+Mu**2/MW**2/cb*cdth*sa
     &      *suth+Md/MW**2*Mu/cb*cuth*sa*sdth-Md**2/MW**2
     &      *ca/cb**2*cdth*sb*suth-Mu**2/MW**2/cb*cdth*sa
     &      /sb**2*suth+Md/MW**2*Mu*ca/cb**2*cuth/sb*sdth
     &      -Md/MW**2*Mu*ca/cb**2*cuth*sb*sdth)
      AAABR(2997) = EE**2/SW**2*Sqrt2*(cdth/cb*cuth*sa-cdth
     &      /cb*cuth*sa*sb**2+Mu**2/MW**2/cb*cdth*cuth*sa
     &      -Mu**2/MW**2/cb*cdth*cuth*sa/sb**2-Md/MW**2*Mu
     &      *ca/cb**2/sb*sdth*suth+Md/MW**2*Mu*ca/cb**2*sb
     &      *sdth*suth)
      AAABR(2998) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2/cb*cdth
     &      *cuth*sa-Md*Mu/cb*sa*sdth*suth-Md**2*ca/cb**2
     &      *cdth*cuth*sb-Mu**2/cb*cdth*cuth*sa/sb**2-Md
     &      *Mu*ca/cb**2/sb*sdth*suth+Md*Mu*ca/cb**2*sb*sdth
     &      *suth)
      AAABR(2999) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2/cb
     &      *cdth*cuth*sa-Md*Mu/cb*sa*sdth*suth+2D0*Md**2
     &      *ca/cb**2*cdth*cuth*sb**3-2D0*Mu**2/cb*cdth*cuth
     &      *sa/sb**2-2D0*Mu**2/cb*cdth*cuth*sa*sb**2-Md
     &      *Mu*ca/cb**2/sb*sdth*suth+3D0*Md*Mu*ca/cb**2
     &      *sb*sdth*suth-2D0*Md*Mu*ca/cb**2*sb**3*sdth*suth
     &      +2D0*Md*Mu/cb*sa*sb**2*sdth*suth)
      AAABR(3000) = EE**2/MW**2/SW**2*Sqrt2*(Mu/cb*sa*sdth
     &      *suth+2D0*Md*ca/cb**2*cdth*cuth*sb+Mu*ca/cb**2
     &      /sb*sdth*suth-Mu*ca/cb**2*sb*sdth*suth)
      AAABR(3001) = EE**2/MW**2/SW**2*Sqrt2*(Md/cb*sa*sdth
     &      *suth-2D0*Mu/cb*cdth*cuth*sa+Md*ca/cb**2/sb*sdth
     &      *suth-Md*ca/cb**2*sb*sdth*suth+2D0*Mu/cb*cdth
     &      *cuth*sa/sb**2)
      AAABR(3002) = EE**2/SW**2*Sqrt2*(ccth/cb**2*csth*sa
     &      *sb-ccth/cb**2*csth*sa*sb**3+Mc/MW**2*Ms*ca/cb
     &      *scth*ssth-Ms**2/MW**2/cb**2*ccth*csth*sa*sb)
      AAABR(3003) = EE**2/SW**2*Sqrt2*ccth*csth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3004) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*ssth-ca
     &      /cb*ccth*sb**2*ssth-ccth/cb**2*sa*sb*ssth+ccth
     &      /cb**2*sa*sb**3*ssth+Mc**2/MW**2*ca/cb*ccth*ssth
     &      +Mc/MW**2*Ms*ca/cb*csth*scth-Mc**2/MW**2*ca/cb
     &      *ccth/sb**2*ssth+Ms**2/MW**2/cb**2*ccth*sa*sb
     &      *ssth-Mc/MW**2*Ms/cb**2*csth*sa/sb*scth+Mc/MW
     &      **2*Ms/cb**2*csth*sa*sb*scth)
      AAABR(3005) = EE**2/SW**2*Sqrt2*(ca/cb*csth*scth-ca
     &      /cb*csth*sb**2*scth-csth/cb**2*sa*sb*scth+csth
     &      /cb**2*sa*sb**3*scth+Mc**2/MW**2*ca/cb*csth*scth
     &      +Mc/MW**2*Ms*ca/cb*ccth*ssth-Mc**2/MW**2*ca/cb
     &      *csth/sb**2*scth+Ms**2/MW**2/cb**2*csth*sa*sb
     &      *scth-Mc/MW**2*Ms/cb**2*ccth*sa/sb*ssth+Mc/MW
     &      **2*Ms/cb**2*ccth*sa*sb*ssth)
      AAABR(3006) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*csth-ca
     &      /cb*ccth*csth*sb**2+Mc**2/MW**2*ca/cb*ccth*csth
     &      -Mc**2/MW**2*ca/cb*ccth*csth/sb**2+Mc/MW**2*Ms
     &      /cb**2*sa/sb*scth*ssth-Mc/MW**2*Ms/cb**2*sa*sb
     &      *scth*ssth)
      AAABR(3007) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ca/cb
     &      *ccth*csth-Mc*Ms*ca/cb*scth*ssth-Mc**2*ca/cb
     &      *ccth*csth/sb**2+Ms**2/cb**2*ccth*csth*sa*sb
     &      +Mc*Ms/cb**2*sa/sb*scth*ssth-Mc*Ms/cb**2*sa*sb
     &      *scth*ssth)
      AAABR(3008) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2*ca
     &      /cb*ccth*csth-Mc*Ms*ca/cb*scth*ssth-2D0*Mc**2
     &      *ca/cb*ccth*csth/sb**2-2D0*Mc**2*ca/cb*ccth*csth
     &      *sb**2-2D0*Ms**2/cb**2*ccth*csth*sa*sb**3+2D0
     &      *Mc*Ms*ca/cb*sb**2*scth*ssth+Mc*Ms/cb**2*sa/sb
     &      *scth*ssth-3D0*Mc*Ms/cb**2*sa*sb*scth*ssth+2D0
     &      *Mc*Ms/cb**2*sa*sb**3*scth*ssth)
      AAABR(3009) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*scth
     &      *ssth-Mc/cb**2*sa/sb*scth*ssth+Mc/cb**2*sa*sb
     &      *scth*ssth-2D0*Ms/cb**2*ccth*csth*sa*sb)
      AAABR(3010) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ca/cb
     &      *ccth*csth-Ms*ca/cb*scth*ssth-2D0*Mc*ca/cb*ccth
     &      *csth/sb**2+Ms/cb**2*sa/sb*scth*ssth-Ms/cb**2
     &      *sa*sb*scth*ssth)
      AAABR(3011) = EE**2/SW**2*Sqrt2*(cdth/cb**2*cuth*sa
     &      *sb-cdth/cb**2*cuth*sa*sb**3+Md/MW**2*Mu*ca/cb
     &      *sdth*suth-Md**2/MW**2/cb**2*cdth*cuth*sa*sb)
      AAABR(3012) = EE**2/SW**2*Sqrt2*cdth*cuth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3013) = EE**2/SW**2*Sqrt2*(ca/cb*cuth*sdth-ca
     &      /cb*cuth*sb**2*sdth-cuth/cb**2*sa*sb*sdth+cuth
     &      /cb**2*sa*sb**3*sdth+Mu**2/MW**2*ca/cb*cuth*sdth
     &      +Md/MW**2*Mu*ca/cb*cdth*suth+Md**2/MW**2/cb**2
     &      *cuth*sa*sb*sdth-Mu**2/MW**2*ca/cb*cuth/sb**2
     &      *sdth-Md/MW**2*Mu/cb**2*cdth*sa/sb*suth+Md/MW
     &      **2*Mu/cb**2*cdth*sa*sb*suth)
      AAABR(3014) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*suth-ca
     &      /cb*cdth*sb**2*suth-cdth/cb**2*sa*sb*suth+cdth
     &      /cb**2*sa*sb**3*suth+Mu**2/MW**2*ca/cb*cdth*suth
     &      +Md/MW**2*Mu*ca/cb*cuth*sdth+Md**2/MW**2/cb**2
     &      *cdth*sa*sb*suth-Mu**2/MW**2*ca/cb*cdth/sb**2
     &      *suth-Md/MW**2*Mu/cb**2*cuth*sa/sb*sdth+Md/MW
     &      **2*Mu/cb**2*cuth*sa*sb*sdth)
      AAABR(3015) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*cuth-ca
     &      /cb*cdth*cuth*sb**2+Mu**2/MW**2*ca/cb*cdth*cuth
     &      -Mu**2/MW**2*ca/cb*cdth*cuth/sb**2+Md/MW**2*Mu
     &      /cb**2*sa/sb*sdth*suth-Md/MW**2*Mu/cb**2*sa*sb
     &      *sdth*suth)
      AAABR(3016) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2*ca/cb
     &      *cdth*cuth-Md*Mu*ca/cb*sdth*suth+Md**2/cb**2
     &      *cdth*cuth*sa*sb-Mu**2*ca/cb*cdth*cuth/sb**2
     &      +Md*Mu/cb**2*sa/sb*sdth*suth-Md*Mu/cb**2*sa*sb
     &      *sdth*suth)
      AAABR(3017) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2*ca
     &      /cb*cdth*cuth-Md*Mu*ca/cb*sdth*suth-2D0*Md**2
     &      /cb**2*cdth*cuth*sa*sb**3-2D0*Mu**2*ca/cb*cdth
     &      *cuth/sb**2-2D0*Mu**2*ca/cb*cdth*cuth*sb**2+2D0
     &      *Md*Mu*ca/cb*sb**2*sdth*suth+Md*Mu/cb**2*sa/sb
     &      *sdth*suth-3D0*Md*Mu/cb**2*sa*sb*sdth*suth+2D0
     &      *Md*Mu/cb**2*sa*sb**3*sdth*suth)
      AAABR(3018) = EE**2/MW**2/SW**2*Sqrt2*(Mu*ca/cb*sdth
     &      *suth-2D0*Md/cb**2*cdth*cuth*sa*sb-Mu/cb**2*sa
     &      /sb*sdth*suth+Mu/cb**2*sa*sb*sdth*suth)
      AAABR(3019) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/cb*sdth
     &      *suth-2D0*Mu*ca/cb*cdth*cuth-Md/cb**2*sa/sb*sdth
     &      *suth+Md/cb**2*sa*sb*sdth*suth+2D0*Mu*ca/cb*cdth
     &      *cuth/sb**2)
      AAABR(3020) = EE**2/SW**2*Sqrt2*(cbth/cb**2*ctth*sa
     &      *sb-cbth/cb**2*ctth*sa*sb**3+Mb/MW**2*Mt*ca/cb
     &      *sbth*stth-Mb**2/MW**2/cb**2*cbth*ctth*sa*sb)
      AAABR(3021) = EE**2/SW**2*Sqrt2*cbth*ctth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3022) = EE**2/SW**2*Sqrt2*(ca/cb*ctth*sbth-ca
     &      /cb*ctth*sb**2*sbth-ctth/cb**2*sa*sb*sbth+ctth
     &      /cb**2*sa*sb**3*sbth+Mt**2/MW**2*ca/cb*ctth*sbth
     &      +Mb/MW**2*Mt*ca/cb*cbth*stth+Mb**2/MW**2/cb**2
     &      *ctth*sa*sb*sbth-Mt**2/MW**2*ca/cb*ctth/sb**2
     &      *sbth-Mb/MW**2*Mt/cb**2*cbth*sa/sb*stth+Mb/MW
     &      **2*Mt/cb**2*cbth*sa*sb*stth)
      AAABR(3023) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*stth-ca
     &      /cb*cbth*sb**2*stth-cbth/cb**2*sa*sb*stth+cbth
     &      /cb**2*sa*sb**3*stth+Mt**2/MW**2*ca/cb*cbth*stth
     &      +Mb/MW**2*Mt*ca/cb*ctth*sbth+Mb**2/MW**2/cb**2
     &      *cbth*sa*sb*stth-Mt**2/MW**2*ca/cb*cbth/sb**2
     &      *stth-Mb/MW**2*Mt/cb**2*ctth*sa/sb*sbth+Mb/MW
     &      **2*Mt/cb**2*ctth*sa*sb*sbth)
      AAABR(3024) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*ctth-ca
     &      /cb*cbth*ctth*sb**2+Mt**2/MW**2*ca/cb*cbth*ctth
     &      -Mt**2/MW**2*ca/cb*cbth*ctth/sb**2+Mb/MW**2*Mt
     &      /cb**2*sa/sb*sbth*stth-Mb/MW**2*Mt/cb**2*sa*sb
     &      *sbth*stth)
      AAABR(3025) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2*ca/cb
     &      *cbth*ctth-Mb*Mt*ca/cb*sbth*stth+Mb**2/cb**2
     &      *cbth*ctth*sa*sb-Mt**2*ca/cb*cbth*ctth/sb**2
     &      +Mb*Mt/cb**2*sa/sb*sbth*stth-Mb*Mt/cb**2*sa*sb
     &      *sbth*stth)
      AAABR(3026) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2*ca
     &      /cb*cbth*ctth-Mb*Mt*ca/cb*sbth*stth-2D0*Mb**2
     &      /cb**2*cbth*ctth*sa*sb**3-2D0*Mt**2*ca/cb*cbth
     &      *ctth/sb**2-2D0*Mt**2*ca/cb*cbth*ctth*sb**2+2D0
     &      *Mb*Mt*ca/cb*sb**2*sbth*stth+Mb*Mt/cb**2*sa/sb
     &      *sbth*stth-3D0*Mb*Mt/cb**2*sa*sb*sbth*stth+2D0
     &      *Mb*Mt/cb**2*sa*sb**3*sbth*stth)
      AAABR(3027) = EE**2/MW**2/SW**2*Sqrt2*(Mt*ca/cb*sbth
     &      *stth-2D0*Mb/cb**2*cbth*ctth*sa*sb-Mt/cb**2*sa
     &      /sb*sbth*stth+Mt/cb**2*sa*sb*sbth*stth)
      AAABR(3028) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/cb*sbth
     &      *stth-2D0*Mt*ca/cb*cbth*ctth-Mb/cb**2*sa/sb*sbth
     &      *stth+Mb/cb**2*sa*sb*sbth*stth+2D0*Mt*ca/cb*cbth
     &      *ctth/sb**2)
      AAABR(3029) = EE**2/SW**2*Sqrt2*(cuth/cb**2*sa*sb*sdth
     &      -cuth/cb**2*sa*sb**3*sdth-Md/MW**2*Mu*ca/cb*cdth
     &      *suth-Md**2/MW**2/cb**2*cuth*sa*sb*sdth)
      AAABR(3030) = EE**2/SW**2*Sqrt2*cuth*sdth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3031) = EE**2/SW**2*Sqrt2*(ca/cb*sdth*suth-ca
     &      /cb*sb**2*sdth*suth-sa/cb**2*sb*sdth*suth+sa
     &      /cb**2*sb**3*sdth*suth+Mu**2/MW**2*ca/cb*sdth
     &      *suth-Md/MW**2*Mu*ca/cb*cdth*cuth+Md**2/MW**2
     &      /cb**2*sa*sb*sdth*suth-Mu**2/MW**2*ca/cb/sb**2
     &      *sdth*suth+Md/MW**2*Mu/cb**2*cdth*cuth*sa/sb
     &      -Md/MW**2*Mu/cb**2*cdth*cuth*sa*sb)
      AAABR(3032) = EE**2/SW**2*Sqrt2*(ca/cb*cuth*sdth-ca
     &      /cb*cuth*sb**2*sdth+Mu**2/MW**2*ca/cb*cuth*sdth
     &      -Mu**2/MW**2*ca/cb*cuth/sb**2*sdth-Md/MW**2*Mu
     &      /cb**2*cdth*sa/sb*suth+Md/MW**2*Mu/cb**2*cdth
     &      *sa*sb*suth)
      AAABR(3033) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2*ca/cb
     &      *cuth*sdth+Md*Mu*ca/cb*cdth*suth+Md**2/cb**2
     &      *cuth*sa*sb*sdth-Mu**2*ca/cb*cuth/sb**2*sdth
     &      -Md*Mu/cb**2*cdth*sa/sb*suth+Md*Mu/cb**2*cdth
     &      *sa*sb*suth)
      AAABR(3034) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2*ca
     &      /cb*cuth*sdth+Md*Mu*ca/cb*cdth*suth-2D0*Md**2
     &      /cb**2*cuth*sa*sb**3*sdth-2D0*Mu**2*ca/cb*cuth
     &      /sb**2*sdth-2D0*Mu**2*ca/cb*cuth*sb**2*sdth-2D0
     &      *Md*Mu*ca/cb*cdth*sb**2*suth-Md*Mu/cb**2*cdth
     &      *sa/sb*suth+3D0*Md*Mu/cb**2*cdth*sa*sb*suth-2D0
     &      *Md*Mu/cb**2*cdth*sa*sb**3*suth)
      AAABR(3035) = EE**2/MW**2/SW**2*Sqrt2*(Mu*ca/cb*cdth
     &      *suth+2D0*Md/cb**2*cuth*sa*sb*sdth-Mu/cb**2*cdth
     &      *sa/sb*suth+Mu/cb**2*cdth*sa*sb*suth)
      AAABR(3036) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/cb*cdth
     &      *suth+2D0*Mu*ca/cb*cuth*sdth-Md/cb**2*cdth*sa
     &      /sb*suth+Md/cb**2*cdth*sa*sb*suth-2D0*Mu*ca/cb
     &      *cuth/sb**2*sdth)
      AAABR(3037) = EE**2/SW**2*Sqrt2*(ca/cb**2*ccth*sb*ssth
     &      -ca/cb**2*ccth*sb**3*ssth+Mc/MW**2*Ms/cb*csth
     &      *sa*scth-Ms**2/MW**2*ca/cb**2*ccth*sb*ssth)
      AAABR(3038) = EE**2/SW**2*Sqrt2*ccth*ssth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3039) = EE**2/SW**2*Sqrt2*(sa/cb*scth*ssth+ca
     &      /cb**2*sb*scth*ssth-ca/cb**2*sb**3*scth*ssth
     &      -sa/cb*sb**2*scth*ssth+Mc**2/MW**2/cb*sa*scth
     &      *ssth-Mc/MW**2*Ms/cb*ccth*csth*sa-Mc**2/MW**2
     &      /cb*sa/sb**2*scth*ssth-Ms**2/MW**2*ca/cb**2*sb
     &      *scth*ssth-Mc/MW**2*Ms*ca/cb**2*ccth*csth/sb
     &      +Mc/MW**2*Ms*ca/cb**2*ccth*csth*sb)
      AAABR(3040) = EE**2/SW**2*Sqrt2*(ccth/cb*sa*ssth-ccth
     &      /cb*sa*sb**2*ssth+Mc**2/MW**2/cb*ccth*sa*ssth
     &      -Mc**2/MW**2/cb*ccth*sa/sb**2*ssth+Mc/MW**2*Ms
     &      *ca/cb**2*csth/sb*scth-Mc/MW**2*Ms*ca/cb**2*csth
     &      *sb*scth)
      AAABR(3041) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2/cb*ccth
     &      *sa*ssth+Mc*Ms/cb*csth*sa*scth-Mc**2/cb*ccth
     &      *sa/sb**2*ssth-Ms**2*ca/cb**2*ccth*sb*ssth+Mc
     &      *Ms*ca/cb**2*csth/sb*scth-Mc*Ms*ca/cb**2*csth
     &      *sb*scth)
      AAABR(3042) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2/cb
     &      *ccth*sa*ssth+Mc*Ms/cb*csth*sa*scth-2D0*Mc**2
     &      /cb*ccth*sa/sb**2*ssth-2D0*Mc**2/cb*ccth*sa*sb
     &      **2*ssth+2D0*Ms**2*ca/cb**2*ccth*sb**3*ssth+Mc
     &      *Ms*ca/cb**2*csth/sb*scth-3D0*Mc*Ms*ca/cb**2
     &      *csth*sb*scth+2D0*Mc*Ms*ca/cb**2*csth*sb**3*scth
     &      -2D0*Mc*Ms/cb*csth*sa*sb**2*scth)
      AAABR(3043) = EE**2/MW**2/SW**2*Sqrt2*(Mc/cb*csth*sa
     &      *scth+Mc*ca/cb**2*csth/sb*scth-Mc*ca/cb**2*csth
     &      *sb*scth-2D0*Ms*ca/cb**2*ccth*sb*ssth)
      AAABR(3044) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc/cb*ccth
     &      *sa*ssth+Ms/cb*csth*sa*scth-2D0*Mc/cb*ccth*sa
     &      /sb**2*ssth+Ms*ca/cb**2*csth/sb*scth-Ms*ca/cb
     &      **2*csth*sb*scth)
      AAABR(3045) = EE**2/SW**2*Sqrt2*(ccth/cb**2*sa*sb*ssth
     &      -ccth/cb**2*sa*sb**3*ssth-Mc/MW**2*Ms*ca/cb*csth
     &      *scth-Ms**2/MW**2/cb**2*ccth*sa*sb*ssth)
      AAABR(3046) = EE**2/SW**2*Sqrt2*ccth*ssth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3047) = EE**2/SW**2*Sqrt2*(ca/cb*scth*ssth-ca
     &      /cb*sb**2*scth*ssth-sa/cb**2*sb*scth*ssth+sa
     &      /cb**2*sb**3*scth*ssth+Mc**2/MW**2*ca/cb*scth
     &      *ssth-Mc/MW**2*Ms*ca/cb*ccth*csth-Mc**2/MW**2
     &      *ca/cb/sb**2*scth*ssth+Ms**2/MW**2/cb**2*sa*sb
     &      *scth*ssth+Mc/MW**2*Ms/cb**2*ccth*csth*sa/sb
     &      -Mc/MW**2*Ms/cb**2*ccth*csth*sa*sb)
      AAABR(3048) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*ssth-ca
     &      /cb*ccth*sb**2*ssth+Mc**2/MW**2*ca/cb*ccth*ssth
     &      -Mc**2/MW**2*ca/cb*ccth/sb**2*ssth-Mc/MW**2*Ms
     &      /cb**2*csth*sa/sb*scth+Mc/MW**2*Ms/cb**2*csth
     &      *sa*sb*scth)
      AAABR(3049) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ca/cb
     &      *ccth*ssth+Mc*Ms*ca/cb*csth*scth-Mc**2*ca/cb
     &      *ccth/sb**2*ssth+Ms**2/cb**2*ccth*sa*sb*ssth
     &      -Mc*Ms/cb**2*csth*sa/sb*scth+Mc*Ms/cb**2*csth
     &      *sa*sb*scth)
      AAABR(3050) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2*ca
     &      /cb*ccth*ssth+Mc*Ms*ca/cb*csth*scth-2D0*Mc**2
     &      *ca/cb*ccth/sb**2*ssth-2D0*Mc**2*ca/cb*ccth*sb
     &      **2*ssth-2D0*Ms**2/cb**2*ccth*sa*sb**3*ssth-2D0
     &      *Mc*Ms*ca/cb*csth*sb**2*scth-Mc*Ms/cb**2*csth
     &      *sa/sb*scth+3D0*Mc*Ms/cb**2*csth*sa*sb*scth-2D0
     &      *Mc*Ms/cb**2*csth*sa*sb**3*scth)
      AAABR(3051) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*csth
     &      *scth-Mc/cb**2*csth*sa/sb*scth+Mc/cb**2*csth
     &      *sa*sb*scth+2D0*Ms/cb**2*ccth*sa*sb*ssth)
      AAABR(3052) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ca/cb
     &      *ccth*ssth+Ms*ca/cb*csth*scth-2D0*Mc*ca/cb*ccth
     &      /sb**2*ssth-Ms/cb**2*csth*sa/sb*scth+Ms/cb**2
     &      *csth*sa*sb*scth)
      AAABR(3053) = EE**2/SW**2*Sqrt2*(ctth/cb**2*sa*sb*sbth
     &      -ctth/cb**2*sa*sb**3*sbth-Mb/MW**2*Mt*ca/cb*cbth
     &      *stth-Mb**2/MW**2/cb**2*ctth*sa*sb*sbth)
      AAABR(3054) = EE**2/SW**2*Sqrt2*ctth*sbth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3055) = EE**2/SW**2*Sqrt2*(ca/cb*sbth*stth-ca
     &      /cb*sb**2*sbth*stth-sa/cb**2*sb*sbth*stth+sa
     &      /cb**2*sb**3*sbth*stth+Mt**2/MW**2*ca/cb*sbth
     &      *stth-Mb/MW**2*Mt*ca/cb*cbth*ctth+Mb**2/MW**2
     &      /cb**2*sa*sb*sbth*stth-Mt**2/MW**2*ca/cb/sb**2
     &      *sbth*stth+Mb/MW**2*Mt/cb**2*cbth*ctth*sa/sb
     &      -Mb/MW**2*Mt/cb**2*cbth*ctth*sa*sb)
      AAABR(3056) = EE**2/SW**2*Sqrt2*(ca/cb*ctth*sbth-ca
     &      /cb*ctth*sb**2*sbth+Mt**2/MW**2*ca/cb*ctth*sbth
     &      -Mt**2/MW**2*ca/cb*ctth/sb**2*sbth-Mb/MW**2*Mt
     &      /cb**2*cbth*sa/sb*stth+Mb/MW**2*Mt/cb**2*cbth
     &      *sa*sb*stth)
      AAABR(3057) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2*ca/cb
     &      *ctth*sbth+Mb*Mt*ca/cb*cbth*stth+Mb**2/cb**2
     &      *ctth*sa*sb*sbth-Mt**2*ca/cb*ctth/sb**2*sbth
     &      -Mb*Mt/cb**2*cbth*sa/sb*stth+Mb*Mt/cb**2*cbth
     &      *sa*sb*stth)
      AAABR(3058) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2*ca
     &      /cb*ctth*sbth+Mb*Mt*ca/cb*cbth*stth-2D0*Mb**2
     &      /cb**2*ctth*sa*sb**3*sbth-2D0*Mt**2*ca/cb*ctth
     &      /sb**2*sbth-2D0*Mt**2*ca/cb*ctth*sb**2*sbth-2D0
     &      *Mb*Mt*ca/cb*cbth*sb**2*stth-Mb*Mt/cb**2*cbth
     &      *sa/sb*stth+3D0*Mb*Mt/cb**2*cbth*sa*sb*stth-2D0
     &      *Mb*Mt/cb**2*cbth*sa*sb**3*stth)
      AAABR(3059) = EE**2/MW**2/SW**2*Sqrt2*(Mt*ca/cb*cbth
     &      *stth+2D0*Mb/cb**2*ctth*sa*sb*sbth-Mt/cb**2*cbth
     &      *sa/sb*stth+Mt/cb**2*cbth*sa*sb*stth)
      AAABR(3060) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/cb*cbth
     &      *stth+2D0*Mt*ca/cb*ctth*sbth-Mb/cb**2*cbth*sa
     &      /sb*stth+Mb/cb**2*cbth*sa*sb*stth-2D0*Mt*ca/cb
     &      *ctth/sb**2*sbth)
      AAABR(3061) = EE**2/SW**2*Sqrt2*(ca/cb**2*cuth*sb*sdth
     &      -ca/cb**2*cuth*sb**3*sdth+Md/MW**2*Mu/cb*cdth
     &      *sa*suth-Md**2/MW**2*ca/cb**2*cuth*sb*sdth)
      AAABR(3062) = EE**2/SW**2*Sqrt2*cuth*sdth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3063) = EE**2/SW**2*Sqrt2*(sa/cb*sdth*suth+ca
     &      /cb**2*sb*sdth*suth-ca/cb**2*sb**3*sdth*suth
     &      -sa/cb*sb**2*sdth*suth+Mu**2/MW**2/cb*sa*sdth
     &      *suth-Md/MW**2*Mu/cb*cdth*cuth*sa-Md**2/MW**2
     &      *ca/cb**2*sb*sdth*suth-Mu**2/MW**2/cb*sa/sb**2
     &      *sdth*suth-Md/MW**2*Mu*ca/cb**2*cdth*cuth/sb
     &      +Md/MW**2*Mu*ca/cb**2*cdth*cuth*sb)
      AAABR(3064) = EE**2/SW**2*Sqrt2*(cuth/cb*sa*sdth-cuth
     &      /cb*sa*sb**2*sdth+Mu**2/MW**2/cb*cuth*sa*sdth
     &      -Mu**2/MW**2/cb*cuth*sa/sb**2*sdth+Md/MW**2*Mu
     &      *ca/cb**2*cdth/sb*suth-Md/MW**2*Mu*ca/cb**2*cdth
     &      *sb*suth)
      AAABR(3065) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2/cb*cuth
     &      *sa*sdth+Md*Mu/cb*cdth*sa*suth-Md**2*ca/cb**2
     &      *cuth*sb*sdth-Mu**2/cb*cuth*sa/sb**2*sdth+Md
     &      *Mu*ca/cb**2*cdth/sb*suth-Md*Mu*ca/cb**2*cdth
     &      *sb*suth)
      AAABR(3066) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2/cb
     &      *cuth*sa*sdth+Md*Mu/cb*cdth*sa*suth+2D0*Md**2
     &      *ca/cb**2*cuth*sb**3*sdth-2D0*Mu**2/cb*cuth*sa
     &      /sb**2*sdth-2D0*Mu**2/cb*cuth*sa*sb**2*sdth+Md
     &      *Mu*ca/cb**2*cdth/sb*suth-3D0*Md*Mu*ca/cb**2
     &      *cdth*sb*suth+2D0*Md*Mu*ca/cb**2*cdth*sb**3*suth
     &      -2D0*Md*Mu/cb*cdth*sa*sb**2*suth)
      AAABR(3067) = EE**2/MW**2/SW**2*Sqrt2*(Mu/cb*cdth*sa
     &      *suth-2D0*Md*ca/cb**2*cuth*sb*sdth+Mu*ca/cb**2
     &      *cdth/sb*suth-Mu*ca/cb**2*cdth*sb*suth)
      AAABR(3068) = EE**2/MW**2/SW**2*Sqrt2*(Md/cb*cdth*sa
     &      *suth+2D0*Mu/cb*cuth*sa*sdth+Md*ca/cb**2*cdth
     &      /sb*suth-Md*ca/cb**2*cdth*sb*suth-2D0*Mu/cb*cuth
     &      *sa/sb**2*sdth)
      AAABR(3069) = EE**2/SW**2*Sqrt2*(ca/cb**2*ctth*sb*sbth
     &      -ca/cb**2*ctth*sb**3*sbth+Mb/MW**2*Mt/cb*cbth
     &      *sa*stth-Mb**2/MW**2*ca/cb**2*ctth*sb*sbth)
      AAABR(3070) = EE**2/SW**2*Sqrt2*ctth*sbth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3071) = EE**2/SW**2*Sqrt2*(sa/cb*sbth*stth+ca
     &      /cb**2*sb*sbth*stth-ca/cb**2*sb**3*sbth*stth
     &      -sa/cb*sb**2*sbth*stth+Mt**2/MW**2/cb*sa*sbth
     &      *stth-Mb/MW**2*Mt/cb*cbth*ctth*sa-Mb**2/MW**2
     &      *ca/cb**2*sb*sbth*stth-Mt**2/MW**2/cb*sa/sb**2
     &      *sbth*stth-Mb/MW**2*Mt*ca/cb**2*cbth*ctth/sb
     &      +Mb/MW**2*Mt*ca/cb**2*cbth*ctth*sb)
      AAABR(3072) = EE**2/SW**2*Sqrt2*(ctth/cb*sa*sbth-ctth
     &      /cb*sa*sb**2*sbth+Mt**2/MW**2/cb*ctth*sa*sbth
     &      -Mt**2/MW**2/cb*ctth*sa/sb**2*sbth+Mb/MW**2*Mt
     &      *ca/cb**2*cbth/sb*stth-Mb/MW**2*Mt*ca/cb**2*cbth
     &      *sb*stth)
      AAABR(3073) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2/cb*ctth
     &      *sa*sbth+Mb*Mt/cb*cbth*sa*stth-Mb**2*ca/cb**2
     &      *ctth*sb*sbth-Mt**2/cb*ctth*sa/sb**2*sbth+Mb
     &      *Mt*ca/cb**2*cbth/sb*stth-Mb*Mt*ca/cb**2*cbth
     &      *sb*stth)
      AAABR(3074) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2/cb
     &      *ctth*sa*sbth+Mb*Mt/cb*cbth*sa*stth+2D0*Mb**2
     &      *ca/cb**2*ctth*sb**3*sbth-2D0*Mt**2/cb*ctth*sa
     &      /sb**2*sbth-2D0*Mt**2/cb*ctth*sa*sb**2*sbth+Mb
     &      *Mt*ca/cb**2*cbth/sb*stth-3D0*Mb*Mt*ca/cb**2
     &      *cbth*sb*stth+2D0*Mb*Mt*ca/cb**2*cbth*sb**3*stth
     &      -2D0*Mb*Mt/cb*cbth*sa*sb**2*stth)
      AAABR(3075) = EE**2/MW**2/SW**2*Sqrt2*(Mt/cb*cbth*sa
     &      *stth-2D0*Mb*ca/cb**2*ctth*sb*sbth+Mt*ca/cb**2
     &      *cbth/sb*stth-Mt*ca/cb**2*cbth*sb*stth)
      AAABR(3076) = EE**2/MW**2/SW**2*Sqrt2*(Mb/cb*cbth*sa
     &      *stth+2D0*Mt/cb*ctth*sa*sbth+Mb*ca/cb**2*cbth
     &      /sb*stth-Mb*ca/cb**2*cbth*sb*stth-2D0*Mt/cb*ctth
     &      *sa/sb**2*sbth)
      AAABR(3077) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*scth**2+5D0*sb**3/CW**2*scth**2
     &      -3D0*sb/SW**2*scth**2+3D0*sb**3/SW**2*scth**2
     &      +6D0*Ms**2/MW**2/SW**2*sb*scth**2)
      AAABR(3078) = EE**2/SW**2/cb*scth**2*(sb-sb**3)
      AAABR(3079) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*scth**2+5D0*sb**3/CW**2*scth**2
     &      -3D0*sb/SW**2*scth**2+3D0*sb**3/SW**2*scth**2
     &      -6D0*Mc**2/MW**2/SW**2/sb+6D0*Mc**2/MW**2/SW
     &      **2*sb+6D0*Mc**2/MW**2/SW**2/sb*scth**2-6D0*Mc
     &      **2/MW**2/SW**2*sb*scth**2)
      AAABR(3080) = EE**2/CW**2/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*scth**2+5D0*sb**3*scth**2)
      AAABR(3081) = EE**2/CW**3*SW/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*scth**2+5D0*sb**3*scth**2)
      AAABR(3082) = EE**2/MW**2/SW**2/cb*(Mc**2/sb-Mc**2
     &      *sb-Mc**2/sb*scth**2+Mc**2*sb*scth**2-Ms**2*sb
     &      *scth**2)
      AAABR(3083) = EE**2/MW**2/SW**2/cb*(Mc**2/sb-2D0*Mc
     &      **2*sb+Mc**2*sb**3-Mc**2/sb*scth**2+2D0*Mc**2
     &      *sb*scth**2-Mc**2*sb**3*scth**2+Ms**2*sb**3*scth
     &      **2)
      AAABR(3084) = EE**2/MW**2*Mc/SW**2/cb*(1D0/sb-sb-scth
     &      **2/sb+sb*scth**2)
      AAABR(3085) = EE**2/MW**2*Ms/SW**2/cb*sb*scth**2
      AAABR(3086) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*suth**2+5D0*sb**3/CW**2*suth**2
     &      -3D0*sb/SW**2*suth**2+3D0*sb**3/SW**2*suth**2
     &      +6D0*Md**2/MW**2/SW**2*sb*suth**2)
      AAABR(3087) = EE**2/SW**2/cb*suth**2*(sb-sb**3)
      AAABR(3088) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*suth**2+5D0*sb**3/CW**2*suth**2
     &      -3D0*sb/SW**2*suth**2+3D0*sb**3/SW**2*suth**2
     &      -6D0*Mu**2/MW**2/SW**2/sb+6D0*Mu**2/MW**2/SW
     &      **2*sb+6D0*Mu**2/MW**2/SW**2/sb*suth**2-6D0*Mu
     &      **2/MW**2/SW**2*sb*suth**2)
      AAABR(3089) = EE**2/CW**2/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*suth**2+5D0*sb**3*suth**2)
      AAABR(3090) = EE**2/CW**3*SW/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*suth**2+5D0*sb**3*suth**2)
      AAABR(3091) = EE**2/MW**2/SW**2/cb*(Mu**2/sb-Mu**2
     &      *sb-Md**2*sb*suth**2-Mu**2/sb*suth**2+Mu**2*sb
     &      *suth**2)
      AAABR(3092) = EE**2/MW**2/SW**2/cb*(Mu**2/sb-2D0*Mu
     &      **2*sb+Mu**2*sb**3+Md**2*sb**3*suth**2-Mu**2
     &      /sb*suth**2+2D0*Mu**2*sb*suth**2-Mu**2*sb**3
     &      *suth**2)
      AAABR(3093) = EE**2/MW**2*Mu/SW**2/cb*(1D0/sb-sb-suth
     &      **2/sb+sb*suth**2)
      AAABR(3094) = EE**2/MW**2*Md/SW**2/cb*sb*suth**2
      AAABR(3095) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*stth**2+5D0*sb**3/CW**2*stth**2
     &      -3D0*sb/SW**2*stth**2+3D0*sb**3/SW**2*stth**2
     &      +6D0*Mb**2/MW**2/SW**2*sb*stth**2)
      AAABR(3096) = EE**2/SW**2/cb*stth**2*(sb-sb**3)
      AAABR(3097) = EE**2/cb*(4D0*sb/CW**2-4D0*sb**3/CW**2
     &      -5D0*sb/CW**2*stth**2+5D0*sb**3/CW**2*stth**2
     &      -3D0*sb/SW**2*stth**2+3D0*sb**3/SW**2*stth**2
     &      -6D0*Mt**2/MW**2/SW**2/sb+6D0*Mt**2/MW**2/SW
     &      **2*sb+6D0*Mt**2/MW**2/SW**2/sb*stth**2-6D0*Mt
     &      **2/MW**2/SW**2*sb*stth**2)
      AAABR(3098) = EE**2/CW**2/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*stth**2+5D0*sb**3*stth**2)
      AAABR(3099) = EE**2/CW**3*SW/cb*(4D0*sb-4D0*sb**3-5D0
     &      *sb*stth**2+5D0*sb**3*stth**2)
      AAABR(3100) = EE**2/MW**2/SW**2/cb*(Mt**2/sb-Mt**2
     &      *sb-Mb**2*sb*stth**2-Mt**2/sb*stth**2+Mt**2*sb
     &      *stth**2)
      AAABR(3101) = EE**2/MW**2/SW**2/cb*(Mt**2/sb-2D0*Mt
     &      **2*sb+Mt**2*sb**3+Mb**2*sb**3*stth**2-Mt**2
     &      /sb*stth**2+2D0*Mt**2*sb*stth**2-Mt**2*sb**3
     &      *stth**2)
      AAABR(3102) = EE**2/MW**2*Mt/SW**2/cb*(1D0/sb-sb-stth
     &      **2/sb+sb*stth**2)
      AAABR(3103) = EE**2/MW**2*Mb/SW**2/cb*sb*stth**2
      AAABR(3104) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Md**2/MW**2*cdth*sb*suth-Md/MW**2
     &      *Mu*cuth*sb*sdth)
      AAABR(3105) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Md**2/MW**2*cdth*sb*suth-Md/MW**2
     &      *Mu*cuth/sb*sdth+Md/MW**2*Mu*cuth*sb*sdth)
      AAABR(3106) = EE**2/SW**2*Sqrt2/cb*cdth*suth*(sb-sb
     &      **3)
      AAABR(3107) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Mu**2/MW**2*cdth/sb*suth+Mu**2/MW
     &      **2*cdth*sb*suth-Md/MW**2*Mu*cuth*sb*sdth)
      AAABR(3108) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Mu**2/MW**2*cdth/sb*suth+Mu**2/MW
     &      **2*cdth*sb*suth-Md/MW**2*Mu*cuth/sb*sdth+Md
     &      /MW**2*Mu*cuth*sb*sdth)
      AAABR(3109) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cdth
     &      *sb*suth+Mu**2*cdth/sb*suth-Mu**2*cdth*sb*suth
     &      +Md*Mu*cuth/sb*sdth)
      AAABR(3110) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cdth
     &      *sb*suth+Mu*cuth/sb*sdth)
      AAABR(3111) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cdth*sb**3*suth-2D0*Mu**2*cdth/sb*suth+4D0*Mu
     &      **2*cdth*sb*suth-2D0*Mu**2*cdth*sb**3*suth-Md
     &      *Mu*cuth/sb*sdth+2D0*Md*Mu*cuth*sb*sdth)
      AAABR(3112) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cuth/sb
     &      *sdth+2D0*Mu*cdth/sb*suth-2D0*Mu*cdth*sb*suth)
      AAABR(3113) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mb**2/MW**2*cbth*sb*stth-Mb/MW**2
     &      *Mt*ctth*sb*sbth)
      AAABR(3114) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mb**2/MW**2*cbth*sb*stth-Mb/MW**2
     &      *Mt*ctth/sb*sbth+Mb/MW**2*Mt*ctth*sb*sbth)
      AAABR(3115) = EE**2/SW**2*Sqrt2/cb*cbth*stth*(sb-sb
     &      **3)
      AAABR(3116) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mt**2/MW**2*cbth/sb*stth+Mt**2/MW
     &      **2*cbth*sb*stth-Mb/MW**2*Mt*ctth*sb*sbth)
      AAABR(3117) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mt**2/MW**2*cbth/sb*stth+Mt**2/MW
     &      **2*cbth*sb*stth-Mb/MW**2*Mt*ctth/sb*sbth+Mb
     &      /MW**2*Mt*ctth*sb*sbth)
      AAABR(3118) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*cbth
     &      *sb*stth+Mt**2*cbth/sb*stth-Mt**2*cbth*sb*stth
     &      +Mb*Mt*ctth/sb*sbth)
      AAABR(3119) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*cbth
     &      *sb*stth+Mt*ctth/sb*sbth)
      AAABR(3120) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *cbth*sb**3*stth-2D0*Mt**2*cbth/sb*stth+4D0*Mt
     &      **2*cbth*sb*stth-2D0*Mt**2*cbth*sb**3*stth-Mb
     &      *Mt*ctth/sb*sbth+2D0*Mb*Mt*ctth*sb*sbth)
      AAABR(3121) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*ctth/sb
     &      *sbth+2D0*Mt*cbth/sb*stth-2D0*Mt*cbth*sb*stth)
      AAABR(3122) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Ms**2/MW**2*csth*sb*scth-Mc/MW**2
     &      *Ms*ccth*sb*ssth)
      AAABR(3123) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Ms**2/MW**2*csth*sb*scth-Mc/MW**2
     &      *Ms*ccth/sb*ssth+Mc/MW**2*Ms*ccth*sb*ssth)
      AAABR(3124) = EE**2/SW**2*Sqrt2/cb*csth*scth*(sb-sb
     &      **3)
      AAABR(3125) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Mc**2/MW**2*csth/sb*scth+Mc**2/MW
     &      **2*csth*sb*scth-Mc/MW**2*Ms*ccth*sb*ssth)
      AAABR(3126) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Mc**2/MW**2*csth/sb*scth+Mc**2/MW
     &      **2*csth*sb*scth-Mc/MW**2*Ms*ccth/sb*ssth+Mc
     &      /MW**2*Ms*ccth*sb*ssth)
      AAABR(3127) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*csth
     &      /sb*scth-Mc**2*csth*sb*scth+Ms**2*csth*sb*scth
     &      +Mc*Ms*ccth/sb*ssth)
      AAABR(3128) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*ccth/sb
     &      *ssth+2D0*Ms*csth*sb*scth)
      AAABR(3129) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *csth/sb*scth-4D0*Mc**2*csth*sb*scth+2D0*Mc**2
     &      *csth*sb**3*scth-2D0*Ms**2*csth*sb**3*scth+Mc
     &      *Ms*ccth/sb*ssth-2D0*Mc*Ms*ccth*sb*ssth)
      AAABR(3130) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*csth
     &      /sb*scth-2D0*Mc*csth*sb*scth+Ms*ccth/sb*ssth)
      AAABR(3131) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mb**2/MW**2*sb*sbth*stth+Mb/MW
     &      **2*Mt*cbth*ctth*sb)
      AAABR(3132) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mb**2/MW**2*sb*sbth*stth+Mb/MW
     &      **2*Mt*cbth*ctth/sb-Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3133) = EE**2/SW**2*Sqrt2/cb*sbth*stth*(sb-sb
     &      **3)
      AAABR(3134) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mt**2/MW**2/sb*sbth*stth+Mt**2
     &      /MW**2*sb*sbth*stth+Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3135) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mt**2/MW**2/sb*sbth*stth+Mt**2
     &      /MW**2*sb*sbth*stth+Mb/MW**2*Mt*cbth*ctth/sb
     &      -Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3136) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*sb
     &      *sbth*stth+Mt**2/sb*sbth*stth-Mt**2*sb*sbth*stth
     &      -Mb*Mt*cbth*ctth/sb)
      AAABR(3137) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*sb
     &      *sbth*stth-Mt*cbth*ctth/sb)
      AAABR(3138) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *sb**3*sbth*stth-2D0*Mt**2/sb*sbth*stth+4D0*Mt
     &      **2*sb*sbth*stth-2D0*Mt**2*sb**3*sbth*stth+Mb
     &      *Mt*cbth*ctth/sb-2D0*Mb*Mt*cbth*ctth*sb)
      AAABR(3139) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*cbth*ctth
     &      /sb-2D0*Mt/sb*sbth*stth+2D0*Mt*sb*sbth*stth)
      AAABR(3140) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Md**2/MW**2*sb*sdth*suth+Md/MW
     &      **2*Mu*cdth*cuth*sb)
      AAABR(3141) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Md**2/MW**2*sb*sdth*suth+Md/MW
     &      **2*Mu*cdth*cuth/sb-Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3142) = EE**2/SW**2*Sqrt2/cb*sdth*suth*(sb-sb
     &      **3)
      AAABR(3143) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Mu**2/MW**2/sb*sdth*suth+Mu**2
     &      /MW**2*sb*sdth*suth+Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3144) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Mu**2/MW**2/sb*sdth*suth+Mu**2
     &      /MW**2*sb*sdth*suth+Md/MW**2*Mu*cdth*cuth/sb
     &      -Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3145) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*sb
     &      *sdth*suth+Mu**2/sb*sdth*suth-Mu**2*sb*sdth*suth
     &      -Md*Mu*cdth*cuth/sb)
      AAABR(3146) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*sb
     &      *sdth*suth-Mu*cdth*cuth/sb)
      AAABR(3147) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *sb**3*sdth*suth-2D0*Mu**2/sb*sdth*suth+4D0*Mu
     &      **2*sb*sdth*suth-2D0*Mu**2*sb**3*sdth*suth+Md
     &      *Mu*cdth*cuth/sb-2D0*Md*Mu*cdth*cuth*sb)
      AAABR(3148) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cdth*cuth
     &      /sb-2D0*Mu/sb*sdth*suth+2D0*Mu*sb*sdth*suth)
      AAABR(3149) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Ms**2/MW**2*sb*scth*ssth+Mc/MW
     &      **2*Ms*ccth*csth*sb)
      AAABR(3150) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Ms**2/MW**2*sb*scth*ssth+Mc/MW
     &      **2*Ms*ccth*csth/sb-Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3151) = EE**2/SW**2*Sqrt2/cb*scth*ssth*(sb-sb
     &      **3)
      AAABR(3152) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Mc**2/MW**2/sb*scth*ssth+Mc**2
     &      /MW**2*sb*scth*ssth+Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3153) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Mc**2/MW**2/sb*scth*ssth+Mc**2
     &      /MW**2*sb*scth*ssth+Mc/MW**2*Ms*ccth*csth/sb
     &      -Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3154) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2/sb
     &      *scth*ssth-Mc**2*sb*scth*ssth+Ms**2*sb*scth*ssth
     &      -Mc*Ms*ccth*csth/sb)
      AAABR(3155) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*ccth*csth
     &      /sb-2D0*Ms*sb*scth*ssth)
      AAABR(3156) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      /sb*scth*ssth-4D0*Mc**2*sb*scth*ssth+2D0*Mc**2
     &      *sb**3*scth*ssth-2D0*Ms**2*sb**3*scth*ssth-Mc
     &      *Ms*ccth*csth/sb+2D0*Mc*Ms*ccth*csth*sb)
      AAABR(3157) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc/sb
     &      *scth*ssth-2D0*Mc*sb*scth*ssth-Ms*ccth*csth/sb)
      AAABR(3158) = EE**2/SW**2*Sqrt2*(ca/cb**2*cdth*sb*suth
     &      -ca/cb**2*cdth*sb**3*suth+Md/MW**2*Mu/cb*cuth
     &      *sa*sdth-Md**2/MW**2*ca/cb**2*cdth*sb*suth)
      AAABR(3159) = EE**2/SW**2*Sqrt2*cdth*suth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3160) = EE**2/SW**2*Sqrt2*(cdth/cb*sa*suth-cdth
     &      /cb*sa*sb**2*suth+Mu**2/MW**2/cb*cdth*sa*suth
     &      -Mu**2/MW**2/cb*cdth*sa/sb**2*suth+Md/MW**2*Mu
     &      *ca/cb**2*cuth/sb*sdth-Md/MW**2*Mu*ca/cb**2*cuth
     &      *sb*sdth)
      AAABR(3161) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2/cb*cdth
     &      *sa*suth+Md*Mu/cb*cuth*sa*sdth-Md**2*ca/cb**2
     &      *cdth*sb*suth-Mu**2/cb*cdth*sa/sb**2*suth+Md
     &      *Mu*ca/cb**2*cuth/sb*sdth-Md*Mu*ca/cb**2*cuth
     &      *sb*sdth)
      AAABR(3162) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2/cb
     &      *cdth*sa*suth+Md*Mu/cb*cuth*sa*sdth+2D0*Md**2
     &      *ca/cb**2*cdth*sb**3*suth-2D0*Mu**2/cb*cdth*sa
     &      /sb**2*suth-2D0*Mu**2/cb*cdth*sa*sb**2*suth+Md
     &      *Mu*ca/cb**2*cuth/sb*sdth-3D0*Md*Mu*ca/cb**2
     &      *cuth*sb*sdth+2D0*Md*Mu*ca/cb**2*cuth*sb**3*sdth
     &      -2D0*Md*Mu/cb*cuth*sa*sb**2*sdth)
      AAABR(3163) = EE**2/MW**2/SW**2*Sqrt2*(Mu/cb*cuth*sa
     &      *sdth-2D0*Md*ca/cb**2*cdth*sb*suth+Mu*ca/cb**2
     &      *cuth/sb*sdth-Mu*ca/cb**2*cuth*sb*sdth)
      AAABR(3164) = EE**2/MW**2/SW**2*Sqrt2*(Md/cb*cuth*sa
     &      *sdth+2D0*Mu/cb*cdth*sa*suth+Md*ca/cb**2*cuth
     &      /sb*sdth-Md*ca/cb**2*cuth*sb*sdth-2D0*Mu/cb*cdth
     &      *sa/sb**2*suth)
      AAABR(3165) = EE**2/SW**2*Sqrt2*(ca/cb**2*cbth*sb*stth
     &      -ca/cb**2*cbth*sb**3*stth+Mb/MW**2*Mt/cb*ctth
     &      *sa*sbth-Mb**2/MW**2*ca/cb**2*cbth*sb*stth)
      AAABR(3166) = EE**2/SW**2*Sqrt2*cbth*stth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3167) = EE**2/SW**2*Sqrt2*(cbth/cb*sa*stth-cbth
     &      /cb*sa*sb**2*stth+Mt**2/MW**2/cb*cbth*sa*stth
     &      -Mt**2/MW**2/cb*cbth*sa/sb**2*stth+Mb/MW**2*Mt
     &      *ca/cb**2*ctth/sb*sbth-Mb/MW**2*Mt*ca/cb**2*ctth
     &      *sb*sbth)
      AAABR(3168) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2/cb*cbth
     &      *sa*stth+Mb*Mt/cb*ctth*sa*sbth-Mb**2*ca/cb**2
     &      *cbth*sb*stth-Mt**2/cb*cbth*sa/sb**2*stth+Mb
     &      *Mt*ca/cb**2*ctth/sb*sbth-Mb*Mt*ca/cb**2*ctth
     &      *sb*sbth)
      AAABR(3169) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2/cb
     &      *cbth*sa*stth+Mb*Mt/cb*ctth*sa*sbth+2D0*Mb**2
     &      *ca/cb**2*cbth*sb**3*stth-2D0*Mt**2/cb*cbth*sa
     &      /sb**2*stth-2D0*Mt**2/cb*cbth*sa*sb**2*stth+Mb
     &      *Mt*ca/cb**2*ctth/sb*sbth-3D0*Mb*Mt*ca/cb**2
     &      *ctth*sb*sbth+2D0*Mb*Mt*ca/cb**2*ctth*sb**3*sbth
     &      -2D0*Mb*Mt/cb*ctth*sa*sb**2*sbth)
      AAABR(3170) = EE**2/MW**2/SW**2*Sqrt2*(Mt/cb*ctth*sa
     &      *sbth-2D0*Mb*ca/cb**2*cbth*sb*stth+Mt*ca/cb**2
     &      *ctth/sb*sbth-Mt*ca/cb**2*ctth*sb*sbth)
      AAABR(3171) = EE**2/MW**2/SW**2*Sqrt2*(Mb/cb*ctth*sa
     &      *sbth+2D0*Mt/cb*cbth*sa*stth+Mb*ca/cb**2*ctth
     &      /sb*sbth-Mb*ca/cb**2*ctth*sb*sbth-2D0*Mt/cb*cbth
     &      *sa/sb**2*stth)
      AAABR(3172) = EE**2/SW**2*Sqrt2*(cdth/cb**2*sa*sb*suth
     &      -cdth/cb**2*sa*sb**3*suth-Md/MW**2*Mu*ca/cb*cuth
     &      *sdth-Md**2/MW**2/cb**2*cdth*sa*sb*suth)
      AAABR(3173) = EE**2/SW**2*Sqrt2*cdth*suth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3174) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*suth-ca
     &      /cb*cdth*sb**2*suth+Mu**2/MW**2*ca/cb*cdth*suth
     &      -Mu**2/MW**2*ca/cb*cdth/sb**2*suth-Md/MW**2*Mu
     &      /cb**2*cuth*sa/sb*sdth+Md/MW**2*Mu/cb**2*cuth
     &      *sa*sb*sdth)
      AAABR(3175) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2*ca/cb
     &      *cdth*suth+Md*Mu*ca/cb*cuth*sdth+Md**2/cb**2
     &      *cdth*sa*sb*suth-Mu**2*ca/cb*cdth/sb**2*suth
     &      -Md*Mu/cb**2*cuth*sa/sb*sdth+Md*Mu/cb**2*cuth
     &      *sa*sb*sdth)
      AAABR(3176) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2*ca
     &      /cb*cdth*suth+Md*Mu*ca/cb*cuth*sdth-2D0*Md**2
     &      /cb**2*cdth*sa*sb**3*suth-2D0*Mu**2*ca/cb*cdth
     &      /sb**2*suth-2D0*Mu**2*ca/cb*cdth*sb**2*suth-2D0
     &      *Md*Mu*ca/cb*cuth*sb**2*sdth-Md*Mu/cb**2*cuth
     &      *sa/sb*sdth+3D0*Md*Mu/cb**2*cuth*sa*sb*sdth-2D0
     &      *Md*Mu/cb**2*cuth*sa*sb**3*sdth)
      AAABR(3177) = EE**2/MW**2/SW**2*Sqrt2*(Mu*ca/cb*cuth
     &      *sdth+2D0*Md/cb**2*cdth*sa*sb*suth-Mu/cb**2*cuth
     &      *sa/sb*sdth+Mu/cb**2*cuth*sa*sb*sdth)
      AAABR(3178) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/cb*cuth
     &      *sdth+2D0*Mu*ca/cb*cdth*suth-Md/cb**2*cuth*sa
     &      /sb*sdth+Md/cb**2*cuth*sa*sb*sdth-2D0*Mu*ca/cb
     &      *cdth/sb**2*suth)
      AAABR(3179) = EE**2/SW**2*Sqrt2*(cbth/cb**2*sa*sb*stth
     &      -cbth/cb**2*sa*sb**3*stth-Mb/MW**2*Mt*ca/cb*ctth
     &      *sbth-Mb**2/MW**2/cb**2*cbth*sa*sb*stth)
      AAABR(3180) = EE**2/SW**2*Sqrt2*cbth*stth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3181) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*stth-ca
     &      /cb*cbth*sb**2*stth+Mt**2/MW**2*ca/cb*cbth*stth
     &      -Mt**2/MW**2*ca/cb*cbth/sb**2*stth-Mb/MW**2*Mt
     &      /cb**2*ctth*sa/sb*sbth+Mb/MW**2*Mt/cb**2*ctth
     &      *sa*sb*sbth)
      AAABR(3182) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2*ca/cb
     &      *cbth*stth+Mb*Mt*ca/cb*ctth*sbth+Mb**2/cb**2
     &      *cbth*sa*sb*stth-Mt**2*ca/cb*cbth/sb**2*stth
     &      -Mb*Mt/cb**2*ctth*sa/sb*sbth+Mb*Mt/cb**2*ctth
     &      *sa*sb*sbth)
      AAABR(3183) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2*ca
     &      /cb*cbth*stth+Mb*Mt*ca/cb*ctth*sbth-2D0*Mb**2
     &      /cb**2*cbth*sa*sb**3*stth-2D0*Mt**2*ca/cb*cbth
     &      /sb**2*stth-2D0*Mt**2*ca/cb*cbth*sb**2*stth-2D0
     &      *Mb*Mt*ca/cb*ctth*sb**2*sbth-Mb*Mt/cb**2*ctth
     &      *sa/sb*sbth+3D0*Mb*Mt/cb**2*ctth*sa*sb*sbth-2D0
     &      *Mb*Mt/cb**2*ctth*sa*sb**3*sbth)
      AAABR(3184) = EE**2/MW**2/SW**2*Sqrt2*(Mt*ca/cb*ctth
     &      *sbth+2D0*Mb/cb**2*cbth*sa*sb*stth-Mt/cb**2*ctth
     &      *sa/sb*sbth+Mt/cb**2*ctth*sa*sb*sbth)
      AAABR(3185) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/cb*ctth
     &      *sbth+2D0*Mt*ca/cb*cbth*stth-Mb/cb**2*ctth*sa
     &      /sb*sbth+Mb/cb**2*ctth*sa*sb*sbth-2D0*Mt*ca/cb
     &      *cbth/sb**2*stth)
      AAABR(3186) = EE**2/SW**2*Sqrt2*(csth/cb**2*sa*sb*scth
     &      -csth/cb**2*sa*sb**3*scth-Mc/MW**2*Ms*ca/cb*ccth
     &      *ssth-Ms**2/MW**2/cb**2*csth*sa*sb*scth)
      AAABR(3187) = EE**2/SW**2*Sqrt2*csth*scth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3188) = EE**2/SW**2*Sqrt2*(ca/cb*csth*scth-ca
     &      /cb*csth*sb**2*scth+Mc**2/MW**2*ca/cb*csth*scth
     &      -Mc**2/MW**2*ca/cb*csth/sb**2*scth-Mc/MW**2*Ms
     &      /cb**2*ccth*sa/sb*ssth+Mc/MW**2*Ms/cb**2*ccth
     &      *sa*sb*ssth)
      AAABR(3189) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ca/cb
     &      *csth*scth+Mc*Ms*ca/cb*ccth*ssth-Mc**2*ca/cb
     &      *csth/sb**2*scth+Ms**2/cb**2*csth*sa*sb*scth
     &      -Mc*Ms/cb**2*ccth*sa/sb*ssth+Mc*Ms/cb**2*ccth
     &      *sa*sb*ssth)
      AAABR(3190) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2*ca
     &      /cb*csth*scth+Mc*Ms*ca/cb*ccth*ssth-2D0*Mc**2
     &      *ca/cb*csth/sb**2*scth-2D0*Mc**2*ca/cb*csth*sb
     &      **2*scth-2D0*Ms**2/cb**2*csth*sa*sb**3*scth-2D0
     &      *Mc*Ms*ca/cb*ccth*sb**2*ssth-Mc*Ms/cb**2*ccth
     &      *sa/sb*ssth+3D0*Mc*Ms/cb**2*ccth*sa*sb*ssth-2D0
     &      *Mc*Ms/cb**2*ccth*sa*sb**3*ssth)
      AAABR(3191) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*ccth
     &      *ssth-Mc/cb**2*ccth*sa/sb*ssth+Mc/cb**2*ccth
     &      *sa*sb*ssth+2D0*Ms/cb**2*csth*sa*sb*scth)
      AAABR(3192) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ca/cb
     &      *csth*scth+Ms*ca/cb*ccth*ssth-2D0*Mc*ca/cb*csth
     &      /sb**2*scth-Ms/cb**2*ccth*sa/sb*ssth+Ms/cb**2
     &      *ccth*sa*sb*ssth)
      AAABR(3193) = EE**2/SW**2*Sqrt2*(ca/cb**2*csth*sb*scth
     &      -ca/cb**2*csth*sb**3*scth+Mc/MW**2*Ms/cb*ccth
     &      *sa*ssth-Ms**2/MW**2*ca/cb**2*csth*sb*scth)
      AAABR(3194) = EE**2/SW**2*Sqrt2*csth*scth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3195) = EE**2/SW**2*Sqrt2*(csth/cb*sa*scth-csth
     &      /cb*sa*sb**2*scth+Mc**2/MW**2/cb*csth*sa*scth
     &      -Mc**2/MW**2/cb*csth*sa/sb**2*scth+Mc/MW**2*Ms
     &      *ca/cb**2*ccth/sb*ssth-Mc/MW**2*Ms*ca/cb**2*ccth
     &      *sb*ssth)
      AAABR(3196) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2/cb*csth
     &      *sa*scth+Mc*Ms/cb*ccth*sa*ssth-Mc**2/cb*csth
     &      *sa/sb**2*scth-Ms**2*ca/cb**2*csth*sb*scth+Mc
     &      *Ms*ca/cb**2*ccth/sb*ssth-Mc*Ms*ca/cb**2*ccth
     &      *sb*ssth)
      AAABR(3197) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2/cb
     &      *csth*sa*scth+Mc*Ms/cb*ccth*sa*ssth-2D0*Mc**2
     &      /cb*csth*sa/sb**2*scth-2D0*Mc**2/cb*csth*sa*sb
     &      **2*scth+2D0*Ms**2*ca/cb**2*csth*sb**3*scth+Mc
     &      *Ms*ca/cb**2*ccth/sb*ssth-3D0*Mc*Ms*ca/cb**2
     &      *ccth*sb*ssth+2D0*Mc*Ms*ca/cb**2*ccth*sb**3*ssth
     &      -2D0*Mc*Ms/cb*ccth*sa*sb**2*ssth)
      AAABR(3198) = EE**2/MW**2/SW**2*Sqrt2*(Mc/cb*ccth*sa
     &      *ssth+Mc*ca/cb**2*ccth/sb*ssth-Mc*ca/cb**2*ccth
     &      *sb*ssth-2D0*Ms*ca/cb**2*csth*sb*scth)
      AAABR(3199) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc/cb*csth
     &      *sa*scth+Ms/cb*ccth*sa*ssth-2D0*Mc/cb*csth*sa
     &      /sb**2*scth+Ms*ca/cb**2*ccth/sb*ssth-Ms*ca/cb
     &      **2*ccth*sb*ssth)
      AAABR(3200) = EE**2/SW**2*Sqrt2*(ca/cb**2*sb*scth*ssth
     &      -ca/cb**2*sb**3*scth*ssth-Mc/MW**2*Ms/cb*ccth
     &      *csth*sa-Ms**2/MW**2*ca/cb**2*sb*scth*ssth)
      AAABR(3201) = EE**2/SW**2*Sqrt2*scth*ssth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3202) = EE**2/SW**2*Sqrt2*(sa/cb*scth*ssth-sa
     &      /cb*sb**2*scth*ssth+Mc**2/MW**2/cb*sa*scth*ssth
     &      -Mc**2/MW**2/cb*sa/sb**2*scth*ssth-Mc/MW**2*Ms
     &      *ca/cb**2*ccth*csth/sb+Mc/MW**2*Ms*ca/cb**2*ccth
     &      *csth*sb)
      AAABR(3203) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2/cb*sa
     &      *scth*ssth-Mc*Ms/cb*ccth*csth*sa-Mc**2/cb*sa
     &      /sb**2*scth*ssth-Ms**2*ca/cb**2*sb*scth*ssth
     &      -Mc*Ms*ca/cb**2*ccth*csth/sb+Mc*Ms*ca/cb**2*ccth
     &      *csth*sb)
      AAABR(3204) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2/cb
     &      *sa*scth*ssth-Mc*Ms/cb*ccth*csth*sa-2D0*Mc**2
     &      /cb*sa/sb**2*scth*ssth-2D0*Mc**2/cb*sa*sb**2
     &      *scth*ssth+2D0*Ms**2*ca/cb**2*sb**3*scth*ssth
     &      -Mc*Ms*ca/cb**2*ccth*csth/sb+3D0*Mc*Ms*ca/cb
     &      **2*ccth*csth*sb-2D0*Mc*Ms*ca/cb**2*ccth*csth
     &      *sb**3+2D0*Mc*Ms/cb*ccth*csth*sa*sb**2)
      AAABR(3205) = EE**2/MW**2/SW**2*Sqrt2*(Mc/cb*ccth*csth
     &      *sa+Mc*ca/cb**2*ccth*csth/sb-Mc*ca/cb**2*ccth
     &      *csth*sb+2D0*Ms*ca/cb**2*sb*scth*ssth)
      AAABR(3206) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc/cb*sa
     &      *scth*ssth-Ms/cb*ccth*csth*sa-2D0*Mc/cb*sa/sb
     &      **2*scth*ssth-Ms*ca/cb**2*ccth*csth/sb+Ms*ca
     &      /cb**2*ccth*csth*sb)
      AAABR(3207) = EE**2/SW**2*Sqrt2*(ca/cb**2*sb*sbth*stth
     &      -ca/cb**2*sb**3*sbth*stth-Mb/MW**2*Mt/cb*cbth
     &      *ctth*sa-Mb**2/MW**2*ca/cb**2*sb*sbth*stth)
      AAABR(3208) = EE**2/SW**2*Sqrt2*sbth*stth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3209) = EE**2/SW**2*Sqrt2*(sa/cb*sbth*stth-sa
     &      /cb*sb**2*sbth*stth+Mt**2/MW**2/cb*sa*sbth*stth
     &      -Mt**2/MW**2/cb*sa/sb**2*sbth*stth-Mb/MW**2*Mt
     &      *ca/cb**2*cbth*ctth/sb+Mb/MW**2*Mt*ca/cb**2*cbth
     &      *ctth*sb)
      AAABR(3210) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2/cb*sa
     &      *sbth*stth-Mb*Mt/cb*cbth*ctth*sa-Mb**2*ca/cb
     &      **2*sb*sbth*stth-Mt**2/cb*sa/sb**2*sbth*stth
     &      -Mb*Mt*ca/cb**2*cbth*ctth/sb+Mb*Mt*ca/cb**2*cbth
     &      *ctth*sb)
      AAABR(3211) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2/cb
     &      *sa*sbth*stth-Mb*Mt/cb*cbth*ctth*sa+2D0*Mb**2
     &      *ca/cb**2*sb**3*sbth*stth-2D0*Mt**2/cb*sa/sb
     &      **2*sbth*stth-2D0*Mt**2/cb*sa*sb**2*sbth*stth
     &      -Mb*Mt*ca/cb**2*cbth*ctth/sb+3D0*Mb*Mt*ca/cb
     &      **2*cbth*ctth*sb-2D0*Mb*Mt*ca/cb**2*cbth*ctth
     &      *sb**3+2D0*Mb*Mt/cb*cbth*ctth*sa*sb**2)
      AAABR(3212) = EE**2/MW**2/SW**2*Sqrt2*(Mt/cb*cbth*ctth
     &      *sa+2D0*Mb*ca/cb**2*sb*sbth*stth+Mt*ca/cb**2
     &      *cbth*ctth/sb-Mt*ca/cb**2*cbth*ctth*sb)
      AAABR(3213) = EE**2/MW**2/SW**2*Sqrt2*(Mb/cb*cbth*ctth
     &      *sa-2D0*Mt/cb*sa*sbth*stth+Mb*ca/cb**2*cbth*ctth
     &      /sb-Mb*ca/cb**2*cbth*ctth*sb+2D0*Mt/cb*sa/sb
     &      **2*sbth*stth)
      AAABR(3214) = EE**2/SW**2*Sqrt2*(sa/cb**2*sb*sdth*suth
     &      -sa/cb**2*sb**3*sdth*suth+Md/MW**2*Mu*ca/cb*cdth
     &      *cuth-Md**2/MW**2/cb**2*sa*sb*sdth*suth)
      AAABR(3215) = EE**2/SW**2*Sqrt2*sdth*suth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3216) = EE**2/SW**2*Sqrt2*(ca/cb*sdth*suth-ca
     &      /cb*sb**2*sdth*suth+Mu**2/MW**2*ca/cb*sdth*suth
     &      -Mu**2/MW**2*ca/cb/sb**2*sdth*suth+Md/MW**2*Mu
     &      /cb**2*cdth*cuth*sa/sb-Md/MW**2*Mu/cb**2*cdth
     &      *cuth*sa*sb)
      AAABR(3217) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2*ca/cb
     &      *sdth*suth-Md*Mu*ca/cb*cdth*cuth+Md**2/cb**2
     &      *sa*sb*sdth*suth-Mu**2*ca/cb/sb**2*sdth*suth
     &      +Md*Mu/cb**2*cdth*cuth*sa/sb-Md*Mu/cb**2*cdth
     &      *cuth*sa*sb)
      AAABR(3218) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2*ca
     &      /cb*sdth*suth-Md*Mu*ca/cb*cdth*cuth-2D0*Md**2
     &      /cb**2*sa*sb**3*sdth*suth-2D0*Mu**2*ca/cb/sb
     &      **2*sdth*suth-2D0*Mu**2*ca/cb*sb**2*sdth*suth
     &      +2D0*Md*Mu*ca/cb*cdth*cuth*sb**2+Md*Mu/cb**2
     &      *cdth*cuth*sa/sb-3D0*Md*Mu/cb**2*cdth*cuth*sa
     &      *sb+2D0*Md*Mu/cb**2*cdth*cuth*sa*sb**3)
      AAABR(3219) = EE**2/MW**2/SW**2*Sqrt2*(Mu*ca/cb*cdth
     &      *cuth-2D0*Md/cb**2*sa*sb*sdth*suth-Mu/cb**2*cdth
     &      *cuth*sa/sb+Mu/cb**2*cdth*cuth*sa*sb)
      AAABR(3220) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/cb*cdth
     &      *cuth-2D0*Mu*ca/cb*sdth*suth-Md/cb**2*cdth*cuth
     &      *sa/sb+Md/cb**2*cdth*cuth*sa*sb+2D0*Mu*ca/cb
     &      /sb**2*sdth*suth)
      AAABR(3221) = EE**2/SW**2*Sqrt2*(sa/cb**2*sb*sbth*stth
     &      -sa/cb**2*sb**3*sbth*stth+Mb/MW**2*Mt*ca/cb*cbth
     &      *ctth-Mb**2/MW**2/cb**2*sa*sb*sbth*stth)
      AAABR(3222) = EE**2/SW**2*Sqrt2*sbth*stth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3223) = EE**2/SW**2*Sqrt2*(ca/cb*sbth*stth-ca
     &      /cb*sb**2*sbth*stth+Mt**2/MW**2*ca/cb*sbth*stth
     &      -Mt**2/MW**2*ca/cb/sb**2*sbth*stth+Mb/MW**2*Mt
     &      /cb**2*cbth*ctth*sa/sb-Mb/MW**2*Mt/cb**2*cbth
     &      *ctth*sa*sb)
      AAABR(3224) = EE**2/MW**2/SW**2*Sqrt2*(Mt**2*ca/cb
     &      *sbth*stth-Mb*Mt*ca/cb*cbth*ctth+Mb**2/cb**2
     &      *sa*sb*sbth*stth-Mt**2*ca/cb/sb**2*sbth*stth
     &      +Mb*Mt/cb**2*cbth*ctth*sa/sb-Mb*Mt/cb**2*cbth
     &      *ctth*sa*sb)
      AAABR(3225) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mt**2*ca
     &      /cb*sbth*stth-Mb*Mt*ca/cb*cbth*ctth-2D0*Mb**2
     &      /cb**2*sa*sb**3*sbth*stth-2D0*Mt**2*ca/cb/sb
     &      **2*sbth*stth-2D0*Mt**2*ca/cb*sb**2*sbth*stth
     &      +2D0*Mb*Mt*ca/cb*cbth*ctth*sb**2+Mb*Mt/cb**2
     &      *cbth*ctth*sa/sb-3D0*Mb*Mt/cb**2*cbth*ctth*sa
     &      *sb+2D0*Mb*Mt/cb**2*cbth*ctth*sa*sb**3)
      AAABR(3226) = EE**2/MW**2/SW**2*Sqrt2*(Mt*ca/cb*cbth
     &      *ctth-2D0*Mb/cb**2*sa*sb*sbth*stth-Mt/cb**2*cbth
     &      *ctth*sa/sb+Mt/cb**2*cbth*ctth*sa*sb)
      AAABR(3227) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/cb*cbth
     &      *ctth-2D0*Mt*ca/cb*sbth*stth-Mb/cb**2*cbth*ctth
     &      *sa/sb+Mb/cb**2*cbth*ctth*sa*sb+2D0*Mt*ca/cb
     &      /sb**2*sbth*stth)
      AAABR(3228) = EE**2/SW**2*Sqrt2*(sa/cb**2*sb*scth*ssth
     &      -sa/cb**2*sb**3*scth*ssth+Mc/MW**2*Ms*ca/cb*ccth
     &      *csth-Ms**2/MW**2/cb**2*sa*sb*scth*ssth)
      AAABR(3229) = EE**2/SW**2*Sqrt2*scth*ssth*(ca/cb-ca
     &      /cb*sb**2-sa/cb**2*sb+sa/cb**2*sb**3)
      AAABR(3230) = EE**2/SW**2*Sqrt2*(ca/cb*scth*ssth-ca
     &      /cb*sb**2*scth*ssth+Mc**2/MW**2*ca/cb*scth*ssth
     &      -Mc**2/MW**2*ca/cb/sb**2*scth*ssth+Mc/MW**2*Ms
     &      /cb**2*ccth*csth*sa/sb-Mc/MW**2*Ms/cb**2*ccth
     &      *csth*sa*sb)
      AAABR(3231) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ca/cb
     &      *scth*ssth-Mc*Ms*ca/cb*ccth*csth-Mc**2*ca/cb
     &      /sb**2*scth*ssth+Ms**2/cb**2*sa*sb*scth*ssth
     &      +Mc*Ms/cb**2*ccth*csth*sa/sb-Mc*Ms/cb**2*ccth
     &      *csth*sa*sb)
      AAABR(3232) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mc**2*ca
     &      /cb*scth*ssth-Mc*Ms*ca/cb*ccth*csth-2D0*Mc**2
     &      *ca/cb/sb**2*scth*ssth-2D0*Mc**2*ca/cb*sb**2
     &      *scth*ssth-2D0*Ms**2/cb**2*sa*sb**3*scth*ssth
     &      +2D0*Mc*Ms*ca/cb*ccth*csth*sb**2+Mc*Ms/cb**2
     &      *ccth*csth*sa/sb-3D0*Mc*Ms/cb**2*ccth*csth*sa
     &      *sb+2D0*Mc*Ms/cb**2*ccth*csth*sa*sb**3)
      AAABR(3233) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*ccth
     &      *csth-Mc/cb**2*ccth*csth*sa/sb+Mc/cb**2*ccth
     &      *csth*sa*sb-2D0*Ms/cb**2*sa*sb*scth*ssth)
      AAABR(3234) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ca/cb
     &      *scth*ssth-Ms*ca/cb*ccth*csth-2D0*Mc*ca/cb/sb
     &      **2*scth*ssth+Ms/cb**2*ccth*csth*sa/sb-Ms/cb
     &      **2*ccth*csth*sa*sb)
      AAABR(3235) = EE**2/SW**2*Sqrt2*(ca/cb**2*sb*sdth*suth
     &      -ca/cb**2*sb**3*sdth*suth-Md/MW**2*Mu/cb*cdth
     &      *cuth*sa-Md**2/MW**2*ca/cb**2*sb*sdth*suth)
      AAABR(3236) = EE**2/SW**2*Sqrt2*sdth*suth*(sa/cb+ca
     &      /cb**2*sb-ca/cb**2*sb**3-sa/cb*sb**2)
      AAABR(3237) = EE**2/SW**2*Sqrt2*(sa/cb*sdth*suth-sa
     &      /cb*sb**2*sdth*suth+Mu**2/MW**2/cb*sa*sdth*suth
     &      -Mu**2/MW**2/cb*sa/sb**2*sdth*suth-Md/MW**2*Mu
     &      *ca/cb**2*cdth*cuth/sb+Md/MW**2*Mu*ca/cb**2*cdth
     &      *cuth*sb)
      AAABR(3238) = EE**2/MW**2/SW**2*Sqrt2*(Mu**2/cb*sa
     &      *sdth*suth-Md*Mu/cb*cdth*cuth*sa-Md**2*ca/cb
     &      **2*sb*sdth*suth-Mu**2/cb*sa/sb**2*sdth*suth
     &      -Md*Mu*ca/cb**2*cdth*cuth/sb+Md*Mu*ca/cb**2*cdth
     &      *cuth*sb)
      AAABR(3239) = EE**2/MW**2/SW**2*Sqrt2*(4D0*Mu**2/cb
     &      *sa*sdth*suth-Md*Mu/cb*cdth*cuth*sa+2D0*Md**2
     &      *ca/cb**2*sb**3*sdth*suth-2D0*Mu**2/cb*sa/sb
     &      **2*sdth*suth-2D0*Mu**2/cb*sa*sb**2*sdth*suth
     &      -Md*Mu*ca/cb**2*cdth*cuth/sb+3D0*Md*Mu*ca/cb
     &      **2*cdth*cuth*sb-2D0*Md*Mu*ca/cb**2*cdth*cuth
     &      *sb**3+2D0*Md*Mu/cb*cdth*cuth*sa*sb**2)
      AAABR(3240) = EE**2/MW**2/SW**2*Sqrt2*(Mu/cb*cdth*cuth
     &      *sa+2D0*Md*ca/cb**2*sb*sdth*suth+Mu*ca/cb**2
     &      *cdth*cuth/sb-Mu*ca/cb**2*cdth*cuth*sb)
      AAABR(3241) = EE**2/MW**2/SW**2*Sqrt2*(Md/cb*cdth*cuth
     &      *sa-2D0*Mu/cb*sa*sdth*suth+Md*ca/cb**2*cdth*cuth
     &      /sb-Md*ca/cb**2*cdth*cuth*sb+2D0*Mu/cb*sa/sb
     &      **2*sdth*suth)
      AAABR(3242) = EE**2*(1D0/SW**2-2D0*sa**2/SW**2-2D0
     &      *sb**2/SW**2+4D0*sa**2/SW**2*sb**2-4D0*ca/CW
     &      **2*cb*sa*sb)
      AAABR(3243) = EE**2*(cb/CW**2*sb+ca/SW**2*sa-2D0*cb
     &      /CW**2*sa**2*sb-2D0*ca/SW**2*sa*sb**2)
      AAABR(3244) = EE**2*(cb/CW**2*sb+ca/SW**2*sa+cb/SW
     &      **2*sb-2D0*cb/CW**2*sa**2*sb-2D0*ca/SW**2*sa
     &      *sb**2)
      AAABR(3245) = EE**2/SW**2*ca*sa*(1D0-2D0*sb**2)
      AAABR(3246) = EE**2*(cb/CW**2*sb+ca/SW**2*sa-cb/SW
     &      **2*sb-2D0*cb/CW**2*sa**2*sb-2D0*ca/SW**2*sa
     &      *sb**2)
      AAABR(3247) = EE**2/CW**2*cb*sb*(1D0-2D0*sa**2)
      AAABR(3248) = EE**2/CW**3*SW*cb*sb*(1D0-2D0*sa**2)
      AAABR(3249) = EE**2/SW**2*(1D0-2D0*sa**2-2D0*sb**2
     &      +4D0*sa**2*sb**2)
      AAABR(3250) = EE**2/CW**2*ca*cb*sa*sb
      AAABR(3251) = EE**2/CW**3*SW*ca*cb*sa*sb
      AAABR(3252) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2-3D0*sb**2/CW**2*seth
     &      **2+3D0*sb**4/CW**2*seth**2+sb**2/SW**2*seth
     &      **2-sb**4/SW**2*seth**2+2D0*Me**2/MW**2/SW**2
     &      *sb**2)
      AAABR(3253) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*seth**2/CW**2
     &      +3D0*sb**2/SW**2-2D0*sb**4/SW**2+seth**2/SW**2
     &      +9D0*sb**2/CW**2*seth**2-6D0*sb**4/CW**2*seth
     &      **2-3D0*sb**2/SW**2*seth**2+2D0*sb**4/SW**2*seth
     &      **2-2D0*Me**2/MW**2/SW**2*sb**2)
      AAABR(3254) = EE**2/cb**2*ceth*seth*(3D0/CW**2-1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2+3D0*sb
     &      **2/SW**2-2D0*sb**4/SW**2)
      AAABR(3255) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*seth**2/CW**2+2D0
     &      *sb**2/SW**2-sb**4/SW**2+seth**2/SW**2+6D0*sb
     &      **2/CW**2*seth**2-3D0*sb**4/CW**2*seth**2-2D0
     &      *sb**2/SW**2*seth**2+sb**4/SW**2*seth**2)
      AAABR(3256) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2-3D0*sb**2/CW**2*smuth
     &      **2+3D0*sb**4/CW**2*smuth**2+sb**2/SW**2*smuth
     &      **2-sb**4/SW**2*smuth**2+2D0*Mm**2/MW**2/SW**2
     &      *sb**2)
      AAABR(3257) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*smuth**2/CW
     &      **2+3D0*sb**2/SW**2-2D0*sb**4/SW**2+smuth**2
     &      /SW**2+9D0*sb**2/CW**2*smuth**2-6D0*sb**4/CW
     &      **2*smuth**2-3D0*sb**2/SW**2*smuth**2+2D0*sb
     &      **4/SW**2*smuth**2-2D0*Mm**2/MW**2/SW**2*sb**2)
      AAABR(3258) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2-1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2+3D0*sb
     &      **2/SW**2-2D0*sb**4/SW**2)
      AAABR(3259) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*smuth**2/CW**2+2D0
     &      *sb**2/SW**2-sb**4/SW**2+smuth**2/SW**2+6D0*sb
     &      **2/CW**2*smuth**2-3D0*sb**4/CW**2*smuth**2-2D0
     &      *sb**2/SW**2*smuth**2+sb**4/SW**2*smuth**2)
      AAABR(3260) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      -sb**2/SW**2+sb**4/SW**2-3D0*sb**2/CW**2*slth
     &      **2+3D0*sb**4/CW**2*slth**2+sb**2/SW**2*slth
     &      **2-sb**4/SW**2*slth**2+2D0*Ml**2/MW**2/SW**2
     &      *sb**2)
      AAABR(3261) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2-3D0*slth**2/CW**2
     &      +3D0*sb**2/SW**2-2D0*sb**4/SW**2+slth**2/SW**2
     &      +9D0*sb**2/CW**2*slth**2-6D0*sb**4/CW**2*slth
     &      **2-3D0*sb**2/SW**2*slth**2+2D0*sb**4/SW**2*slth
     &      **2-2D0*Ml**2/MW**2/SW**2*sb**2)
      AAABR(3262) = EE**2/cb**2*clth*slth*(3D0/CW**2-1D0
     &      /SW**2-9D0*sb**2/CW**2+6D0*sb**4/CW**2+3D0*sb
     &      **2/SW**2-2D0*sb**4/SW**2)
      AAABR(3263) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2-3D0*slth**2/CW**2+2D0
     &      *sb**2/SW**2-sb**4/SW**2+slth**2/SW**2+6D0*sb
     &      **2/CW**2*slth**2-3D0*sb**4/CW**2*slth**2-2D0
     &      *sb**2/SW**2*slth**2+sb**4/SW**2*slth**2)
      AAABR(3264) = EE**2/cb**2*cmuth*smuth*(3D0*sb**2/CW
     &      **2-3D0*sb**4/CW**2-sb**2/SW**2+sb**4/SW**2)
      AAABR(3265) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*smuth**2/CW**2+smuth**2
     &      /SW**2+9D0*sb**2/CW**2*smuth**2-6D0*sb**4/CW
     &      **2*smuth**2-3D0*sb**2/SW**2*smuth**2+2D0*sb
     &      **4/SW**2*smuth**2+2D0*Mm**2/MW**2/SW**2*sb**2)
      AAABR(3266) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2+2D0*sb
     &      **2/SW**2-sb**4/SW**2)
      AAABR(3267) = EE**2/cb**2*clth*slth*(3D0*sb**2/CW**2
     &      -3D0*sb**4/CW**2-sb**2/SW**2+sb**4/SW**2)
      AAABR(3268) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*slth**2/CW**2+slth**2/SW
     &      **2+9D0*sb**2/CW**2*slth**2-6D0*sb**4/CW**2*slth
     &      **2-3D0*sb**2/SW**2*slth**2+2D0*sb**4/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*sb**2)
      AAABR(3269) = EE**2/cb**2*clth*slth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2+2D0*sb
     &      **2/SW**2-sb**4/SW**2)
      AAABR(3270) = EE**2/cb**2*ceth*seth*(3D0*sb**2/CW**2
     &      -3D0*sb**4/CW**2-sb**2/SW**2+sb**4/SW**2)
      AAABR(3271) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-3D0*seth**2/CW**2+seth**2/SW
     &      **2+9D0*sb**2/CW**2*seth**2-6D0*sb**4/CW**2*seth
     &      **2-3D0*sb**2/SW**2*seth**2+2D0*sb**4/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*sb**2)
      AAABR(3272) = EE**2/cb**2*ceth*seth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sb**2/CW**2+3D0*sb**4/CW**2+2D0*sb
     &      **2/SW**2-sb**4/SW**2)
      AAABR(3273) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*seth**2+3D0*sb**4/CW**2
     &      *seth**2+sb**2/SW**2*seth**2-sb**4/SW**2*seth
     &      **2-2D0*Me**2/MW**2/SW**2*sb**2)
      AAABR(3274) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*seth**2/CW**2+seth**2/SW
     &      **2+6D0*sb**2/CW**2*seth**2-3D0*sb**4/CW**2*seth
     &      **2-2D0*sb**2/SW**2*seth**2+sb**4/SW**2*seth**2)
      AAABR(3275) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*slth**2+3D0*sb**4/CW**2
     &      *slth**2+sb**2/SW**2*slth**2-sb**4/SW**2*slth
     &      **2-2D0*Ml**2/MW**2/SW**2*sb**2)
      AAABR(3276) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*slth**2/CW**2+slth**2/SW
     &      **2+6D0*sb**2/CW**2*slth**2-3D0*sb**4/CW**2*slth
     &      **2-2D0*sb**2/SW**2*slth**2+sb**4/SW**2*slth**2)
      AAABR(3277) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-3D0*sb**2/CW**2*smuth**2+3D0*sb**4/CW
     &      **2*smuth**2+sb**2/SW**2*smuth**2-sb**4/SW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2*sb**2)
      AAABR(3278) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-3D0*smuth**2/CW**2+smuth**2
     &      /SW**2+6D0*sb**2/CW**2*smuth**2-3D0*sb**4/CW
     &      **2*smuth**2-2D0*sb**2/SW**2*smuth**2+sb**4/SW
     &      **2*smuth**2)
      AAABR(3279) = EE**2*sb**2*(1D0/CW**2+1D0/SW**2)
      AAABR(3280) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sb**2
     &      /CW**2-2D0*sb**2/SW**2)
      AAABR(3281) = EE**2/SW**2*(1D0-2D0*sb**2)
      AAABR(3282) = EE**2*(1D0/CW**2+1D0/SW**2-sb**2/CW**2
     &      -sb**2/SW**2)
      AAABR(3283) = EE**2/CW**2*(1D0-2D0*sb**2)
      AAABR(3284) = EE**2/CW**3*SW*(1D0-2D0*sb**2)
      AAABR(3285) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2+sb**2/CW**2
     &      *sbth**2-sb**4/CW**2*sbth**2-3D0*sb**2/SW**2
     &      *sbth**2+3D0*sb**4/SW**2*sbth**2-6D0*Mb**2/MW
     &      **2/SW**2*sb**2)
      AAABR(3286) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+sbth**2/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2-3D0*sbth**2/SW**2
     &      -3D0*sb**2/CW**2*sbth**2+2D0*sb**4/CW**2*sbth
     &      **2+9D0*sb**2/SW**2*sbth**2-6D0*sb**4/SW**2*sbth
     &      **2+6D0*Mb**2/MW**2/SW**2*sb**2)
      AAABR(3287) = EE**2/cb**2*cbth*sbth*(1D0/CW**2-3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2+9D0*sb
     &      **2/SW**2-6D0*sb**4/SW**2)
      AAABR(3288) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+sbth**2/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2-3D0*sbth**2/SW**2-2D0
     &      *sb**2/CW**2*sbth**2+sb**4/CW**2*sbth**2+6D0
     &      *sb**2/SW**2*sbth**2-3D0*sb**4/SW**2*sbth**2)
      AAABR(3289) = EE**2/MW**2*Mb**2/SW**2/cb**2*sb**2
      AAABR(3290) = EE**2/MW**2*Mb**2/SW**2/cb**2*sb**4
      AAABR(3291) = EE**2/MW**2*Mb/SW**2/cb**2*sb**2
      AAABR(3292) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2+sb**2/CW**2
     &      *sdth**2-sb**4/CW**2*sdth**2-3D0*sb**2/SW**2
     &      *sdth**2+3D0*sb**4/SW**2*sdth**2-6D0*Md**2/MW
     &      **2/SW**2*sb**2)
      AAABR(3293) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+sdth**2/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2-3D0*sdth**2/SW**2
     &      -3D0*sb**2/CW**2*sdth**2+2D0*sb**4/CW**2*sdth
     &      **2+9D0*sb**2/SW**2*sdth**2-6D0*sb**4/SW**2*sdth
     &      **2+6D0*Md**2/MW**2/SW**2*sb**2)
      AAABR(3294) = EE**2/cb**2*cdth*sdth*(1D0/CW**2-3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2+9D0*sb
     &      **2/SW**2-6D0*sb**4/SW**2)
      AAABR(3295) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+sdth**2/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2-3D0*sdth**2/SW**2-2D0
     &      *sb**2/CW**2*sdth**2+sb**4/CW**2*sdth**2+6D0
     &      *sb**2/SW**2*sdth**2-3D0*sb**4/SW**2*sdth**2)
      AAABR(3296) = EE**2/MW**2*Md**2/SW**2/cb**2*sb**2
      AAABR(3297) = EE**2/MW**2*Md**2/SW**2/cb**2*sb**4
      AAABR(3298) = EE**2/MW**2*Md/SW**2/cb**2*sb**2
      AAABR(3299) = EE**2/cb**2*(sb**2/CW**2-sb**4/CW**2
     &      +3D0*sb**2/SW**2-3D0*sb**4/SW**2+sb**2/CW**2
     &      *ssth**2-sb**4/CW**2*ssth**2-3D0*sb**2/SW**2
     &      *ssth**2+3D0*sb**4/SW**2*ssth**2-6D0*Ms**2/MW
     &      **2/SW**2*sb**2)
      AAABR(3300) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-3D0
     &      *sb**2/CW**2+2D0*sb**4/CW**2+ssth**2/CW**2-9D0
     &      *sb**2/SW**2+6D0*sb**4/SW**2-3D0*ssth**2/SW**2
     &      -3D0*sb**2/CW**2*ssth**2+2D0*sb**4/CW**2*ssth
     &      **2+9D0*sb**2/SW**2*ssth**2-6D0*sb**4/SW**2*ssth
     &      **2+6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(3301) = EE**2/cb**2*csth*ssth*(1D0/CW**2-3D0
     &      /SW**2-3D0*sb**2/CW**2+2D0*sb**4/CW**2+9D0*sb
     &      **2/SW**2-6D0*sb**4/SW**2)
      AAABR(3302) = EE**2/cb**2*(1D0/CW**2+3D0/SW**2-2D0
     &      *sb**2/CW**2+sb**4/CW**2+ssth**2/CW**2-6D0*sb
     &      **2/SW**2+3D0*sb**4/SW**2-3D0*ssth**2/SW**2-2D0
     &      *sb**2/CW**2*ssth**2+sb**4/CW**2*ssth**2+6D0
     &      *sb**2/SW**2*ssth**2-3D0*sb**4/SW**2*ssth**2)
      AAABR(3303) = EE**2/MW**2*Ms**2/SW**2/cb**2*sb**2
      AAABR(3304) = EE**2/MW**2*Ms**2/SW**2/cb**2*sb**4
      AAABR(3305) = EE**2/MW**2*Ms/SW**2/cb**2*sb**2
      AAABR(3306) = EE**2/cb**2*cbth*sbth*(sb**2/CW**2-sb
     &      **4/CW**2-3D0*sb**2/SW**2+3D0*sb**4/SW**2)
      AAABR(3307) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-sbth**2/CW**2+3D0*sbth**2/SW
     &      **2+3D0*sb**2/CW**2*sbth**2-2D0*sb**4/CW**2*sbth
     &      **2-9D0*sb**2/SW**2*sbth**2+6D0*sb**4/SW**2*sbth
     &      **2+6D0*Mb**2/MW**2/SW**2*sb**2)
      AAABR(3308) = EE**2/cb**2*cbth*sbth*(1D0/CW**2-3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2+6D0*sb**2
     &      /SW**2-3D0*sb**4/SW**2)
      AAABR(3309) = EE**2/cb**2*cdth*sdth*(sb**2/CW**2-sb
     &      **4/CW**2-3D0*sb**2/SW**2+3D0*sb**4/SW**2)
      AAABR(3310) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-sdth**2/CW**2+3D0*sdth**2/SW
     &      **2+3D0*sb**2/CW**2*sdth**2-2D0*sb**4/CW**2*sdth
     &      **2-9D0*sb**2/SW**2*sdth**2+6D0*sb**4/SW**2*sdth
     &      **2+6D0*Md**2/MW**2/SW**2*sb**2)
      AAABR(3311) = EE**2/cb**2*cdth*sdth*(1D0/CW**2-3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2+6D0*sb**2
     &      /SW**2-3D0*sb**4/SW**2)
      AAABR(3312) = EE**2/cb**2*csth*ssth*(sb**2/CW**2-sb
     &      **4/CW**2-3D0*sb**2/SW**2+3D0*sb**4/SW**2)
      AAABR(3313) = EE**2/cb**2*(2D0/CW**2-6D0*sb**2/CW**2
     &      +4D0*sb**4/CW**2-ssth**2/CW**2+3D0*ssth**2/SW
     &      **2+3D0*sb**2/CW**2*ssth**2-2D0*sb**4/CW**2*ssth
     &      **2-9D0*sb**2/SW**2*ssth**2+6D0*sb**4/SW**2*ssth
     &      **2+6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(3314) = EE**2/cb**2*csth*ssth*(1D0/CW**2-3D0
     &      /SW**2-2D0*sb**2/CW**2+sb**4/CW**2+6D0*sb**2
     &      /SW**2-3D0*sb**4/SW**2)
      AAABR(3315) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*sdth**2+sb**4/CW**2*sdth**2
     &      +3D0*sb**2/SW**2*sdth**2-3D0*sb**4/SW**2*sdth
     &      **2-6D0*Md**2/MW**2/SW**2*sb**2)
      AAABR(3316) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-sdth**2/CW**2+3D0*sdth**2/SW
     &      **2+2D0*sb**2/CW**2*sdth**2-sb**4/CW**2*sdth
     &      **2-6D0*sb**2/SW**2*sdth**2+3D0*sb**4/SW**2*sdth
     &      **2)
      AAABR(3317) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*sbth**2+sb**4/CW**2*sbth**2
     &      +3D0*sb**2/SW**2*sbth**2-3D0*sb**4/SW**2*sbth
     &      **2-6D0*Mb**2/MW**2/SW**2*sb**2)
      AAABR(3318) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-sbth**2/CW**2+3D0*sbth**2/SW
     &      **2+2D0*sb**2/CW**2*sbth**2-sb**4/CW**2*sbth
     &      **2-6D0*sb**2/SW**2*sbth**2+3D0*sb**4/SW**2*sbth
     &      **2)
      AAABR(3319) = EE**2/cb**2*(2D0*sb**2/CW**2-2D0*sb**4
     &      /CW**2-sb**2/CW**2*ssth**2+sb**4/CW**2*ssth**2
     &      +3D0*sb**2/SW**2*ssth**2-3D0*sb**4/SW**2*ssth
     &      **2-6D0*Ms**2/MW**2/SW**2*sb**2)
      AAABR(3320) = EE**2/cb**2*(2D0/CW**2-4D0*sb**2/CW**2
     &      +2D0*sb**4/CW**2-ssth**2/CW**2+3D0*ssth**2/SW
     &      **2+2D0*sb**2/CW**2*ssth**2-sb**4/CW**2*ssth
     &      **2-6D0*sb**2/SW**2*ssth**2+3D0*sb**4/SW**2*ssth
     &      **2)
      AAABR(3321) = EE**2*sb**2*(1D0/CW**2-3D0/SW**2-5D0
     &      *stth**2/CW**2+3D0*stth**2/SW**2)
      AAABR(3322) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2-5D0*stth**2/CW**2+6D0*sb**2/SW**2+3D0
     &      *stth**2/SW**2+10D0*sb**2/CW**2*stth**2-6D0*Mt
     &      **2/MW**2/SW**2-6D0*sb**2/SW**2*stth**2+6D0*Mt
     &      **2/MW**2/SW**2/sb**2)
      AAABR(3323) = EE**2/SW**2*(1D0-2D0*sb**2-stth**2+2D0
     &      *sb**2*stth**2)
      AAABR(3324) = EE**2*ctth*stth*(5D0/CW**2-3D0/SW**2
     &      -10D0*sb**2/CW**2+6D0*sb**2/SW**2)
      AAABR(3325) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      -5D0*stth**2/CW**2+3D0*sb**2/SW**2+3D0*stth**2
     &      /SW**2+5D0*sb**2/CW**2*stth**2-6D0*Mt**2/MW**2
     &      /SW**2-3D0*sb**2/SW**2*stth**2+6D0*Mt**2/MW**2
     &      /SW**2/sb**2)
      AAABR(3326) = EE**2/CW**2*(1D0-2D0*sb**2-5D0*stth**2
     &      +10D0*sb**2*stth**2)
      AAABR(3327) = EE**2/CW**3*SW*(1D0-2D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(3328) = EE**2/MW**2*Mt**2/SW**2*(1D0-1D0/sb**2)
      AAABR(3329) = EE**2/MW**2*Mt**2/SW**2*(2D0-1D0/sb**2
     &      -sb**2)
      AAABR(3330) = EE**2/MW**2*Mt/SW**2*(1D0-1D0/sb**2)
      AAABR(3331) = EE**2*sb**2*(1D0/CW**2-3D0/SW**2-5D0
     &      *scth**2/CW**2+3D0*scth**2/SW**2)
      AAABR(3332) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2-5D0*scth**2/CW**2+6D0*sb**2/SW**2+3D0
     &      *scth**2/SW**2+10D0*sb**2/CW**2*scth**2-6D0*Mc
     &      **2/MW**2/SW**2-6D0*sb**2/SW**2*scth**2+6D0*Mc
     &      **2/MW**2/SW**2/sb**2)
      AAABR(3333) = EE**2/SW**2*(1D0-2D0*sb**2-scth**2+2D0
     &      *sb**2*scth**2)
      AAABR(3334) = EE**2*ccth*scth*(5D0/CW**2-3D0/SW**2
     &      -10D0*sb**2/CW**2+6D0*sb**2/SW**2)
      AAABR(3335) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      -5D0*scth**2/CW**2+3D0*sb**2/SW**2+3D0*scth**2
     &      /SW**2+5D0*sb**2/CW**2*scth**2-6D0*Mc**2/MW**2
     &      /SW**2-3D0*sb**2/SW**2*scth**2+6D0*Mc**2/MW**2
     &      /SW**2/sb**2)
      AAABR(3336) = EE**2/CW**2*(1D0-2D0*sb**2-5D0*scth**2
     &      +10D0*sb**2*scth**2)
      AAABR(3337) = EE**2/CW**3*SW*(1D0-2D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(3338) = EE**2/MW**2*Mc**2/SW**2*(1D0-1D0/sb**2)
      AAABR(3339) = EE**2/MW**2*Mc**2/SW**2*(2D0-1D0/sb**2
     &      -sb**2)
      AAABR(3340) = EE**2/MW**2*Mc/SW**2*(1D0-1D0/sb**2)
      AAABR(3341) = EE**2*sb**2*(1D0/CW**2-3D0/SW**2-5D0
     &      *suth**2/CW**2+3D0*suth**2/SW**2)
      AAABR(3342) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2-5D0*suth**2/CW**2+6D0*sb**2/SW**2+3D0
     &      *suth**2/SW**2+10D0*sb**2/CW**2*suth**2-6D0*Mu
     &      **2/MW**2/SW**2-6D0*sb**2/SW**2*suth**2+6D0*Mu
     &      **2/MW**2/SW**2/sb**2)
      AAABR(3343) = EE**2/SW**2*(1D0-2D0*sb**2-suth**2+2D0
     &      *sb**2*suth**2)
      AAABR(3344) = EE**2*cuth*suth*(5D0/CW**2-3D0/SW**2
     &      -10D0*sb**2/CW**2+6D0*sb**2/SW**2)
      AAABR(3345) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      -5D0*suth**2/CW**2+3D0*sb**2/SW**2+3D0*suth**2
     &      /SW**2+5D0*sb**2/CW**2*suth**2-6D0*Mu**2/MW**2
     &      /SW**2-3D0*sb**2/SW**2*suth**2+6D0*Mu**2/MW**2
     &      /SW**2/sb**2)
      AAABR(3346) = EE**2/CW**2*(1D0-2D0*sb**2-5D0*suth**2
     &      +10D0*sb**2*suth**2)
      AAABR(3347) = EE**2/CW**3*SW*(1D0-2D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(3348) = EE**2/MW**2*Mu**2/SW**2*(1D0-1D0/sb**2)
      AAABR(3349) = EE**2/MW**2*Mu**2/SW**2*(2D0-1D0/sb**2
     &      -sb**2)
      AAABR(3350) = EE**2/MW**2*Mu/SW**2*(1D0-1D0/sb**2)
      AAABR(3351) = EE**2*ctth*sb**2*stth*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3352) = EE**2/SW**2*ctth*stth*(1D0-2D0*sb**2)
      AAABR(3353) = EE**2*(4D0/CW**2-8D0*sb**2/CW**2-5D0
     &      *stth**2/CW**2+3D0*stth**2/SW**2+10D0*sb**2/CW
     &      **2*stth**2+6D0*Mt**2/MW**2/SW**2-6D0*sb**2/SW
     &      **2*stth**2-6D0*Mt**2/MW**2/SW**2/sb**2)
      AAABR(3354) = EE**2*ctth*stth*(5D0/CW**2-3D0/SW**2
     &      -5D0*sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3355) = EE**2/CW**2*ctth*stth*(1D0-2D0*sb**2)
      AAABR(3356) = EE**2/CW**3*SW*ctth*stth*(1D0-2D0*sb**2)
      AAABR(3357) = EE**2*cuth*sb**2*suth*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3358) = EE**2/SW**2*cuth*suth*(1D0-2D0*sb**2)
      AAABR(3359) = EE**2*(4D0/CW**2-8D0*sb**2/CW**2-5D0
     &      *suth**2/CW**2+3D0*suth**2/SW**2+10D0*sb**2/CW
     &      **2*suth**2+6D0*Mu**2/MW**2/SW**2-6D0*sb**2/SW
     &      **2*suth**2-6D0*Mu**2/MW**2/SW**2/sb**2)
      AAABR(3360) = EE**2*cuth*suth*(5D0/CW**2-3D0/SW**2
     &      -5D0*sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3361) = EE**2/CW**2*cuth*suth*(1D0-2D0*sb**2)
      AAABR(3362) = EE**2/CW**3*SW*cuth*suth*(1D0-2D0*sb**2)
      AAABR(3363) = EE**2*ccth*sb**2*scth*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3364) = EE**2/SW**2*ccth*scth*(1D0-2D0*sb**2)
      AAABR(3365) = EE**2*(4D0/CW**2-8D0*sb**2/CW**2-5D0
     &      *scth**2/CW**2+3D0*scth**2/SW**2+10D0*sb**2/CW
     &      **2*scth**2+6D0*Mc**2/MW**2/SW**2-6D0*sb**2/SW
     &      **2*scth**2-6D0*Mc**2/MW**2/SW**2/sb**2)
      AAABR(3366) = EE**2*ccth*scth*(5D0/CW**2-3D0/SW**2
     &      -5D0*sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3367) = EE**2/CW**2*ccth*scth*(1D0-2D0*sb**2)
      AAABR(3368) = EE**2/CW**3*SW*ccth*scth*(1D0-2D0*sb**2)
      AAABR(3369) = EE**2*sb**2*(4D0/CW**2-5D0*scth**2/CW
     &      **2+3D0*scth**2/SW**2)
      AAABR(3370) = EE**2/SW**2*scth**2*(1D0-2D0*sb**2)
      AAABR(3371) = EE**2*(4D0/CW**2-4D0*sb**2/CW**2-5D0
     &      *scth**2/CW**2+3D0*scth**2/SW**2+5D0*sb**2/CW
     &      **2*scth**2+6D0*Mc**2/MW**2/SW**2-3D0*sb**2/SW
     &      **2*scth**2-6D0*Mc**2/MW**2/SW**2/sb**2)
      AAABR(3372) = EE**2/CW**2*(4D0-8D0*sb**2-5D0*scth**2
     &      +10D0*sb**2*scth**2)
      AAABR(3373) = EE**2/CW**3*SW*(4D0-8D0*sb**2-5D0*scth
     &      **2+10D0*sb**2*scth**2)
      AAABR(3374) = EE**2*sb**2*(4D0/CW**2-5D0*stth**2/CW
     &      **2+3D0*stth**2/SW**2)
      AAABR(3375) = EE**2/SW**2*stth**2*(1D0-2D0*sb**2)
      AAABR(3376) = EE**2*(4D0/CW**2-4D0*sb**2/CW**2-5D0
     &      *stth**2/CW**2+3D0*stth**2/SW**2+5D0*sb**2/CW
     &      **2*stth**2+6D0*Mt**2/MW**2/SW**2-3D0*sb**2/SW
     &      **2*stth**2-6D0*Mt**2/MW**2/SW**2/sb**2)
      AAABR(3377) = EE**2/CW**2*(4D0-8D0*sb**2-5D0*stth**2
     &      +10D0*sb**2*stth**2)
      AAABR(3378) = EE**2/CW**3*SW*(4D0-8D0*sb**2-5D0*stth
     &      **2+10D0*sb**2*stth**2)
      AAABR(3379) = EE**2*sb**2*(4D0/CW**2-5D0*suth**2/CW
     &      **2+3D0*suth**2/SW**2)
      AAABR(3380) = EE**2/SW**2*suth**2*(1D0-2D0*sb**2)
      AAABR(3381) = EE**2*(4D0/CW**2-4D0*sb**2/CW**2-5D0
     &      *suth**2/CW**2+3D0*suth**2/SW**2+5D0*sb**2/CW
     &      **2*suth**2+6D0*Mu**2/MW**2/SW**2-3D0*sb**2/SW
     &      **2*suth**2-6D0*Mu**2/MW**2/SW**2/sb**2)
      AAABR(3382) = EE**2/CW**2*(4D0-8D0*sb**2-5D0*suth**2
     &      +10D0*sb**2*suth**2)
      AAABR(3383) = EE**2/CW**3*SW*(4D0-8D0*sb**2-5D0*suth
     &      **2+10D0*sb**2*suth**2)
      AAABR(3384) = EE**2*(1D0/CW**2-1D0/SW**2-4D0*sb**2
     &      /CW**2+4D0*sb**4/CW**2-2D0*nlr**2/SW**2-4D0*sb
     &      **2/SW**2+4D0*sb**4/SW**2)
      AAABR(3385) = EE**2*(1D0/CW**2+1D0/SW**2-12D0*sb**2
     &      /CW**2+12D0*sb**4/CW**2-12D0*sb**2/SW**2+12D0
     &      *sb**4/SW**2)
      AAABR(3386) = EE**2/SW**2*(1D0-12D0*sb**2+12D0*sb**4)
      AAABR(3387) = EE**2/CW**2*(1D0-12D0*sb**2+12D0*sb**4)
      AAABR(3388) = EE**2/CW**3*SW*(1D0-12D0*sb**2+12D0*sb
     &      **4)
      AAABR(3389) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sa**2
     &      /CW**2-2D0*sb**2/CW**2-2D0*sa**2/SW**2-2D0*sb
     &      **2/SW**2+4D0*sa**2/CW**2*sb**2+4D0*sa**2/SW
     &      **2*sb**2)
      AAABR(3390) = EE**2*ca*sa*sb**2*(1D0/CW**2+1D0/SW**2)
      AAABR(3391) = EE**2*ca*sa*(1D0/CW**2+1D0/SW**2-2D0
     &      *sb**2/CW**2-2D0*sb**2/SW**2)
      AAABR(3392) = EE**2*ca*sa*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-sb**2/SW**2)
      AAABR(3393) = EE**2*sb**2*(1D0/CW**2+1D0/SW**2-2D0
     &      *sa**2/CW**2-2D0*sa**2/SW**2)
      AAABR(3394) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sa**2
     &      /CW**2-sb**2/CW**2-2D0*sa**2/SW**2-sb**2/SW**2
     &      +2D0*sa**2/CW**2*sb**2+2D0*sa**2/SW**2*sb**2)
      AAABR(3395) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2+sb**2/SW**2+slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2+2D0*Ml**2/MW**2/SW
     &      **2-sb**2/SW**2*slth**2)
      AAABR(3396) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2+sb**2/SW**2+slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2+Ml**2/MW**2/SW**2
     &      -sb**2/SW**2*slth**2)
      AAABR(3397) = EE**2*clth*slth*tb*(3D0/CW**2-1D0/SW
     &      **2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(3398) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*slth**2/CW**2+sb**2/SW**2+slth**2/SW
     &      **2+3D0*sb**2/CW**2*slth**2-sb**2/SW**2*slth**2)
      AAABR(3399) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2+sb**2/SW**2+smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2+2D0*Mm**2/MW**2
     &      /SW**2-sb**2/SW**2*smuth**2)
      AAABR(3400) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2+sb**2/SW**2+smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2+Mm**2/MW**2/SW**2
     &      -sb**2/SW**2*smuth**2)
      AAABR(3401) = EE**2*cmuth*smuth*tb*(3D0/CW**2-1D0/SW
     &      **2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(3402) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*smuth**2/CW**2+sb**2/SW**2+smuth**2/SW
     &      **2+3D0*sb**2/CW**2*smuth**2-sb**2/SW**2*smuth
     &      **2)
      AAABR(3403) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2+sb**2/SW**2+seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2+2D0*Me**2/MW**2/SW
     &      **2-sb**2/SW**2*seth**2)
      AAABR(3404) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2+sb**2/SW**2+seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2+Me**2/MW**2/SW**2
     &      -sb**2/SW**2*seth**2)
      AAABR(3405) = EE**2*ceth*seth*tb*(3D0/CW**2-1D0/SW
     &      **2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(3406) = EE**2*tb*(1D0/CW**2-1D0/SW**2-sb**2/CW
     &      **2-3D0*seth**2/CW**2+sb**2/SW**2+seth**2/SW
     &      **2+3D0*sb**2/CW**2*seth**2-sb**2/SW**2*seth**2)
      AAABR(3407) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-Mm**2/MW**2/SW**2-sb**2/SW**2*smuth
     &      **2)
      AAABR(3408) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-Me**2/MW**2/SW**2-sb**2/SW**2*seth**2)
      AAABR(3409) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-Ml**2/MW**2/SW**2-sb**2/SW**2*slth**2)
      AAABR(3410) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2-sb**2/SW**2*seth
     &      **2)
      AAABR(3411) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-sb**2/SW**2*seth**2)
      AAABR(3412) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2-sb**2/SW**2*slth
     &      **2)
      AAABR(3413) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-sb**2/SW**2*slth**2)
      AAABR(3414) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2-sb**2/SW**2*smuth
     &      **2)
      AAABR(3415) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-sb**2/SW**2*smuth**2)
      AAABR(3416) = EE**2*cb*sb*(1D0/CW**2+1D0/SW**2)
      AAABR(3417) = EE**2/SW**2*cb*sb
      AAABR(3418) = EE**2/CW**2*cb*sb
      AAABR(3419) = EE**2/CW**3*SW*cb*sb
      AAABR(3420) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Md**2/MW**2*cdth*cuth*sb-Md/MW**2
     &      *Mu*sb*sdth*suth)
      AAABR(3421) = EE**2/SW**2*Sqrt2/cb*(2D0*cdth*cuth*sb
     &      -2D0*cdth*cuth*sb**3-Md**2/MW**2*cdth*cuth*sb
     &      -Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW**2*cdth*cuth
     &      *sb-Md/MW**2*Mu/sb*sdth*suth)
      AAABR(3422) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Md**2/MW**2*cdth*cuth*sb-Md/MW**2
     &      *Mu/sb*sdth*suth+Md/MW**2*Mu*sb*sdth*suth)
      AAABR(3423) = EE**2/SW**2*Sqrt2/cb*(2D0*cdth*sb*suth
     &      -2D0*cdth*sb**3*suth-Md**2/MW**2*cdth*sb*suth
     &      -Mu**2/MW**2*cdth/sb*suth+Mu**2/MW**2*cdth*sb
     &      *suth+Md/MW**2*Mu*cuth/sb*sdth)
      AAABR(3424) = EE**2/SW**2*Sqrt2/cb*(2D0*cuth*sb*sdth
     &      -2D0*cuth*sb**3*sdth-Md**2/MW**2*cuth*sb*sdth
     &      -Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW**2*cuth*sb
     &      *sdth+Md/MW**2*Mu*cdth/sb*suth)
      AAABR(3425) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW
     &      **2*cdth*cuth*sb-Md/MW**2*Mu/sb*sdth*suth+Md
     &      /MW**2*Mu*sb*sdth*suth)
      AAABR(3426) = EE**2/SW**2*Sqrt2/cb*(cdth*cuth*sb-cdth
     &      *cuth*sb**3-Mu**2/MW**2*cdth*cuth/sb+Mu**2/MW
     &      **2*cdth*cuth*sb-Md/MW**2*Mu*sb*sdth*suth)
      AAABR(3427) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cdth
     &      *cuth*sb+Mu**2*cdth*cuth/sb-Mu**2*cdth*cuth*sb
     &      +Md*Mu/sb*sdth*suth)
      AAABR(3428) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cdth*cuth*sb**3-2D0*Mu**2*cdth*cuth/sb+4D0*Mu
     &      **2*cdth*cuth*sb-2D0*Mu**2*cdth*cuth*sb**3-Md
     &      *Mu/sb*sdth*suth+2D0*Md*Mu*sb*sdth*suth)
      AAABR(3429) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md/sb*sdth
     &      *suth+2D0*Mu*cdth*cuth/sb-2D0*Mu*cdth*cuth*sb)
      AAABR(3430) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cdth
     &      *cuth*sb+Mu/sb*sdth*suth)
      AAABR(3431) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Ms**2/MW**2*ccth*csth*sb-Mc/MW**2
     &      *Ms*sb*scth*ssth)
      AAABR(3432) = EE**2/SW**2*Sqrt2/cb*(2D0*ccth*csth*sb
     &      -2D0*ccth*csth*sb**3-Mc**2/MW**2*ccth*csth/sb
     &      +Mc**2/MW**2*ccth*csth*sb-Ms**2/MW**2*ccth*csth
     &      *sb-Mc/MW**2*Ms/sb*scth*ssth)
      AAABR(3433) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Ms**2/MW**2*ccth*csth*sb-Mc/MW**2
     &      *Ms/sb*scth*ssth+Mc/MW**2*Ms*sb*scth*ssth)
      AAABR(3434) = EE**2/SW**2*Sqrt2/cb*(2D0*csth*sb*scth
     &      -2D0*csth*sb**3*scth-Mc**2/MW**2*csth/sb*scth
     &      +Mc**2/MW**2*csth*sb*scth-Ms**2/MW**2*csth*sb
     &      *scth+Mc/MW**2*Ms*ccth/sb*ssth)
      AAABR(3435) = EE**2/SW**2*Sqrt2/cb*(2D0*ccth*sb*ssth
     &      -2D0*ccth*sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth
     &      +Mc**2/MW**2*ccth*sb*ssth-Ms**2/MW**2*ccth*sb
     &      *ssth+Mc/MW**2*Ms*csth/sb*scth)
      AAABR(3436) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Mc**2/MW**2*ccth*csth/sb+Mc**2/MW
     &      **2*ccth*csth*sb-Mc/MW**2*Ms/sb*scth*ssth+Mc
     &      /MW**2*Ms*sb*scth*ssth)
      AAABR(3437) = EE**2/SW**2*Sqrt2/cb*(ccth*csth*sb-ccth
     &      *csth*sb**3-Mc**2/MW**2*ccth*csth/sb+Mc**2/MW
     &      **2*ccth*csth*sb-Mc/MW**2*Ms*sb*scth*ssth)
      AAABR(3438) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*ccth
     &      *csth/sb-Mc**2*ccth*csth*sb+Ms**2*ccth*csth*sb
     &      +Mc*Ms/sb*scth*ssth)
      AAABR(3439) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *ccth*csth/sb-4D0*Mc**2*ccth*csth*sb+2D0*Mc**2
     &      *ccth*csth*sb**3-2D0*Ms**2*ccth*csth*sb**3+Mc
     &      *Ms/sb*scth*ssth-2D0*Mc*Ms*sb*scth*ssth)
      AAABR(3440) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*ccth
     &      *csth/sb-2D0*Mc*ccth*csth*sb+Ms/sb*scth*ssth)
      AAABR(3441) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc/sb*scth
     &      *ssth+2D0*Ms*ccth*csth*sb)
      AAABR(3442) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb-Mb/MW**2
     &      *Mt*sb*sbth*stth)
      AAABR(3443) = EE**2/SW**2*Sqrt2/cb*(2D0*cbth*ctth*sb
     &      -2D0*cbth*ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb
     &      -Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW**2*cbth*ctth
     &      *sb-Mb/MW**2*Mt/sb*sbth*stth)
      AAABR(3444) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mb**2/MW**2*cbth*ctth*sb-Mb/MW**2
     &      *Mt/sb*sbth*stth+Mb/MW**2*Mt*sb*sbth*stth)
      AAABR(3445) = EE**2/SW**2*Sqrt2/cb*(2D0*cbth*sb*stth
     &      -2D0*cbth*sb**3*stth-Mb**2/MW**2*cbth*sb*stth
     &      -Mt**2/MW**2*cbth/sb*stth+Mt**2/MW**2*cbth*sb
     &      *stth+Mb/MW**2*Mt*ctth/sb*sbth)
      AAABR(3446) = EE**2/SW**2*Sqrt2/cb*(2D0*ctth*sb*sbth
     &      -2D0*ctth*sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth
     &      -Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW**2*ctth*sb
     &      *sbth+Mb/MW**2*Mt*cbth/sb*stth)
      AAABR(3447) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW
     &      **2*cbth*ctth*sb-Mb/MW**2*Mt/sb*sbth*stth+Mb
     &      /MW**2*Mt*sb*sbth*stth)
      AAABR(3448) = EE**2/SW**2*Sqrt2/cb*(cbth*ctth*sb-cbth
     &      *ctth*sb**3-Mt**2/MW**2*cbth*ctth/sb+Mt**2/MW
     &      **2*cbth*ctth*sb-Mb/MW**2*Mt*sb*sbth*stth)
      AAABR(3449) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*cbth
     &      *ctth*sb+Mt**2*cbth*ctth/sb-Mt**2*cbth*ctth*sb
     &      +Mb*Mt/sb*sbth*stth)
      AAABR(3450) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *cbth*ctth*sb**3-2D0*Mt**2*cbth*ctth/sb+4D0*Mt
     &      **2*cbth*ctth*sb-2D0*Mt**2*cbth*ctth*sb**3-Mb
     &      *Mt/sb*sbth*stth+2D0*Mb*Mt*sb*sbth*stth)
      AAABR(3451) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb/sb*sbth
     &      *stth+2D0*Mt*cbth*ctth/sb-2D0*Mt*cbth*ctth*sb)
      AAABR(3452) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*cbth
     &      *ctth*sb+Mt/sb*sbth*stth)
      AAABR(3453) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Ms**2/MW**2*csth*sb*scth+Mc/MW**2
     &      *Ms*ccth*sb*ssth)
      AAABR(3454) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Ms**2/MW**2*csth*sb*scth+Mc/MW**2
     &      *Ms*ccth/sb*ssth-Mc/MW**2*Ms*ccth*sb*ssth)
      AAABR(3455) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*scth*ssth
     &      -2D0*sb**3*scth*ssth-Mc**2/MW**2/sb*scth*ssth
     &      +Mc**2/MW**2*sb*scth*ssth-Ms**2/MW**2*sb*scth
     &      *ssth-Mc/MW**2*Ms*ccth*csth/sb)
      AAABR(3456) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Mc**2/MW**2*csth/sb*scth+Mc**2/MW
     &      **2*csth*sb*scth+Mc/MW**2*Ms*ccth/sb*ssth-Mc
     &      /MW**2*Ms*ccth*sb*ssth)
      AAABR(3457) = EE**2/SW**2*Sqrt2/cb*(csth*sb*scth-csth
     &      *sb**3*scth-Mc**2/MW**2*csth/sb*scth+Mc**2/MW
     &      **2*csth*sb*scth+Mc/MW**2*Ms*ccth*sb*ssth)
      AAABR(3458) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*csth
     &      /sb*scth-Mc**2*csth*sb*scth+Ms**2*csth*sb*scth
     &      -Mc*Ms*ccth/sb*ssth)
      AAABR(3459) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *csth/sb*scth-4D0*Mc**2*csth*sb*scth+2D0*Mc**2
     &      *csth*sb**3*scth-2D0*Ms**2*csth*sb**3*scth-Mc
     &      *Ms*ccth/sb*ssth+2D0*Mc*Ms*ccth*sb*ssth)
      AAABR(3460) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*csth
     &      /sb*scth-2D0*Mc*csth*sb*scth-Ms*ccth/sb*ssth)
      AAABR(3461) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*ccth/sb
     &      *ssth-2D0*Ms*csth*sb*scth)
      AAABR(3462) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mb**2/MW**2*cbth*sb*stth+Mb/MW**2
     &      *Mt*ctth*sb*sbth)
      AAABR(3463) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mb**2/MW**2*cbth*sb*stth+Mb/MW**2
     &      *Mt*ctth/sb*sbth-Mb/MW**2*Mt*ctth*sb*sbth)
      AAABR(3464) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*sbth*stth
     &      -2D0*sb**3*sbth*stth-Mb**2/MW**2*sb*sbth*stth
     &      -Mt**2/MW**2/sb*sbth*stth+Mt**2/MW**2*sb*sbth
     &      *stth-Mb/MW**2*Mt*cbth*ctth/sb)
      AAABR(3465) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mt**2/MW**2*cbth/sb*stth+Mt**2/MW
     &      **2*cbth*sb*stth+Mb/MW**2*Mt*ctth/sb*sbth-Mb
     &      /MW**2*Mt*ctth*sb*sbth)
      AAABR(3466) = EE**2/SW**2*Sqrt2/cb*(cbth*sb*stth-cbth
     &      *sb**3*stth-Mt**2/MW**2*cbth/sb*stth+Mt**2/MW
     &      **2*cbth*sb*stth+Mb/MW**2*Mt*ctth*sb*sbth)
      AAABR(3467) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*cbth
     &      *sb*stth+Mt**2*cbth/sb*stth-Mt**2*cbth*sb*stth
     &      -Mb*Mt*ctth/sb*sbth)
      AAABR(3468) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *cbth*sb**3*stth-2D0*Mt**2*cbth/sb*stth+4D0*Mt
     &      **2*cbth*sb*stth-2D0*Mt**2*cbth*sb**3*stth+Mb
     &      *Mt*ctth/sb*sbth-2D0*Mb*Mt*ctth*sb*sbth)
      AAABR(3469) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*ctth/sb
     &      *sbth-2D0*Mt*cbth/sb*stth+2D0*Mt*cbth*sb*stth)
      AAABR(3470) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*cbth
     &      *sb*stth-Mt*ctth/sb*sbth)
      AAABR(3471) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Md**2/MW**2*cdth*sb*suth+Md/MW**2
     &      *Mu*cuth*sb*sdth)
      AAABR(3472) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Md**2/MW**2*cdth*sb*suth+Md/MW**2
     &      *Mu*cuth/sb*sdth-Md/MW**2*Mu*cuth*sb*sdth)
      AAABR(3473) = EE**2/SW**2*Sqrt2/cb*(2D0*sb*sdth*suth
     &      -2D0*sb**3*sdth*suth-Md**2/MW**2*sb*sdth*suth
     &      -Mu**2/MW**2/sb*sdth*suth+Mu**2/MW**2*sb*sdth
     &      *suth-Md/MW**2*Mu*cdth*cuth/sb)
      AAABR(3474) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Mu**2/MW**2*cdth/sb*suth+Mu**2/MW
     &      **2*cdth*sb*suth+Md/MW**2*Mu*cuth/sb*sdth-Md
     &      /MW**2*Mu*cuth*sb*sdth)
      AAABR(3475) = EE**2/SW**2*Sqrt2/cb*(cdth*sb*suth-cdth
     &      *sb**3*suth-Mu**2/MW**2*cdth/sb*suth+Mu**2/MW
     &      **2*cdth*sb*suth+Md/MW**2*Mu*cuth*sb*sdth)
      AAABR(3476) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cdth
     &      *sb*suth+Mu**2*cdth/sb*suth-Mu**2*cdth*sb*suth
     &      -Md*Mu*cuth/sb*sdth)
      AAABR(3477) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cdth*sb**3*suth-2D0*Mu**2*cdth/sb*suth+4D0*Mu
     &      **2*cdth*sb*suth-2D0*Mu**2*cdth*sb**3*suth+Md
     &      *Mu*cuth/sb*sdth-2D0*Md*Mu*cuth*sb*sdth)
      AAABR(3478) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cuth/sb
     &      *sdth-2D0*Mu*cdth/sb*suth+2D0*Mu*cdth*sb*suth)
      AAABR(3479) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cdth
     &      *sb*suth-Mu*cuth/sb*sdth)
      AAABR(3480) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sdth**2/CW**2-3D0*sb**2/SW**2-3D0*sdth**2
     &      /SW**2-sb**2/CW**2*sdth**2-6D0*Md**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*sdth**2)
      AAABR(3481) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sdth**2/CW**2-3D0*sb**2/SW**2-3D0*sdth**2
     &      /SW**2-sb**2/CW**2*sdth**2-3D0*Md**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*sdth**2)
      AAABR(3482) = EE**2/SW**2*tb*(1D0-sb**2-sdth**2+sb
     &      **2*sdth**2)
      AAABR(3483) = EE**2*cdth*sdth*tb*(1D0/CW**2-3D0/SW
     &      **2-sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3484) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sdth**2/CW**2-3D0*sb**2/SW**2-3D0*sdth**2
     &      /SW**2-sb**2/CW**2*sdth**2+3D0*sb**2/SW**2*sdth
     &      **2)
      AAABR(3485) = EE**2/CW**2*tb*(1D0-sb**2+sdth**2-sb
     &      **2*sdth**2)
      AAABR(3486) = EE**2/CW**3*SW*tb*(1D0-sb**2+sdth**2
     &      -sb**2*sdth**2)
      AAABR(3487) = EE**2/MW**2*Md**2/SW**2*tb
      AAABR(3488) = EE**2/MW**2*Md**2/SW**2*sb**2*tb
      AAABR(3489) = EE**2/MW**2*Md/SW**2*tb
      AAABR(3490) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sbth**2/CW**2-3D0*sb**2/SW**2-3D0*sbth**2
     &      /SW**2-sb**2/CW**2*sbth**2-6D0*Mb**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*sbth**2)
      AAABR(3491) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sbth**2/CW**2-3D0*sb**2/SW**2-3D0*sbth**2
     &      /SW**2-sb**2/CW**2*sbth**2-3D0*Mb**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*sbth**2)
      AAABR(3492) = EE**2/SW**2*tb*(1D0-sb**2-sbth**2+sb
     &      **2*sbth**2)
      AAABR(3493) = EE**2*cbth*sbth*tb*(1D0/CW**2-3D0/SW
     &      **2-sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3494) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+sbth**2/CW**2-3D0*sb**2/SW**2-3D0*sbth**2
     &      /SW**2-sb**2/CW**2*sbth**2+3D0*sb**2/SW**2*sbth
     &      **2)
      AAABR(3495) = EE**2/CW**2*tb*(1D0-sb**2+sbth**2-sb
     &      **2*sbth**2)
      AAABR(3496) = EE**2/CW**3*SW*tb*(1D0-sb**2+sbth**2
     &      -sb**2*sbth**2)
      AAABR(3497) = EE**2/MW**2*Mb**2/SW**2*tb
      AAABR(3498) = EE**2/MW**2*Mb**2/SW**2*sb**2*tb
      AAABR(3499) = EE**2/MW**2*Mb/SW**2*tb
      AAABR(3500) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+ssth**2/CW**2-3D0*sb**2/SW**2-3D0*ssth**2
     &      /SW**2-sb**2/CW**2*ssth**2-6D0*Ms**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*ssth**2)
      AAABR(3501) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+ssth**2/CW**2-3D0*sb**2/SW**2-3D0*ssth**2
     &      /SW**2-sb**2/CW**2*ssth**2-3D0*Ms**2/MW**2/SW
     &      **2+3D0*sb**2/SW**2*ssth**2)
      AAABR(3502) = EE**2/SW**2*tb*(1D0-sb**2-ssth**2+sb
     &      **2*ssth**2)
      AAABR(3503) = EE**2*csth*ssth*tb*(1D0/CW**2-3D0/SW
     &      **2-sb**2/CW**2+3D0*sb**2/SW**2)
      AAABR(3504) = EE**2*tb*(1D0/CW**2+3D0/SW**2-sb**2/CW
     &      **2+ssth**2/CW**2-3D0*sb**2/SW**2-3D0*ssth**2
     &      /SW**2-sb**2/CW**2*ssth**2+3D0*sb**2/SW**2*ssth
     &      **2)
      AAABR(3505) = EE**2/CW**2*tb*(1D0-sb**2+ssth**2-sb
     &      **2*ssth**2)
      AAABR(3506) = EE**2/CW**3*SW*tb*(1D0-sb**2+ssth**2
     &      -sb**2*ssth**2)
      AAABR(3507) = EE**2/MW**2*Ms**2/SW**2*tb
      AAABR(3508) = EE**2/MW**2*Ms**2/SW**2*sb**2*tb
      AAABR(3509) = EE**2/MW**2*Ms/SW**2*tb
      AAABR(3510) = EE**2/SW**2*cdth*sdth*tb*(1D0-sb**2)
      AAABR(3511) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sdth
     &      **2/CW**2+3D0*sdth**2/SW**2+sb**2/CW**2*sdth
     &      **2-3D0*Md**2/MW**2/SW**2-3D0*sb**2/SW**2*sdth
     &      **2)
      AAABR(3512) = EE**2/CW**2*cdth*sdth*tb*(1D0-sb**2)
      AAABR(3513) = EE**2/CW**3*SW*cdth*sdth*tb*(1D0-sb**2)
      AAABR(3514) = EE**2/SW**2*cbth*sbth*tb*(1D0-sb**2)
      AAABR(3515) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sbth
     &      **2/CW**2+3D0*sbth**2/SW**2+sb**2/CW**2*sbth
     &      **2-3D0*Mb**2/MW**2/SW**2-3D0*sb**2/SW**2*sbth
     &      **2)
      AAABR(3516) = EE**2/CW**2*cbth*sbth*tb*(1D0-sb**2)
      AAABR(3517) = EE**2/CW**3*SW*cbth*sbth*tb*(1D0-sb**2)
      AAABR(3518) = EE**2/SW**2*csth*ssth*tb*(1D0-sb**2)
      AAABR(3519) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-ssth
     &      **2/CW**2+3D0*ssth**2/SW**2+sb**2/CW**2*ssth
     &      **2-3D0*Ms**2/MW**2/SW**2-3D0*sb**2/SW**2*ssth
     &      **2)
      AAABR(3520) = EE**2/CW**2*csth*ssth*tb*(1D0-sb**2)
      AAABR(3521) = EE**2/CW**3*SW*csth*ssth*tb*(1D0-sb**2)
      AAABR(3522) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Ms**2/MW**2*ccth*sb*ssth+Mc/MW**2
     &      *Ms*csth*sb*scth)
      AAABR(3523) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Ms**2/MW**2*ccth*sb*ssth+Mc/MW**2
     &      *Ms*csth/sb*scth-Mc/MW**2*Ms*csth*sb*scth)
      AAABR(3524) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth+Mc**2/MW
     &      **2*ccth*sb*ssth+Mc/MW**2*Ms*csth/sb*scth-Mc
     &      /MW**2*Ms*csth*sb*scth)
      AAABR(3525) = EE**2/SW**2*Sqrt2/cb*(ccth*sb*ssth-ccth
     &      *sb**3*ssth-Mc**2/MW**2*ccth/sb*ssth+Mc**2/MW
     &      **2*ccth*sb*ssth+Mc/MW**2*Ms*csth*sb*scth)
      AAABR(3526) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2*ccth
     &      /sb*ssth-Mc**2*ccth*sb*ssth+Ms**2*ccth*sb*ssth
     &      -Mc*Ms*csth/sb*scth)
      AAABR(3527) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      *ccth/sb*ssth-4D0*Mc**2*ccth*sb*ssth+2D0*Mc**2
     &      *ccth*sb**3*ssth-2D0*Ms**2*ccth*sb**3*ssth-Mc
     &      *Ms*csth/sb*scth+2D0*Mc*Ms*csth*sb*scth)
      AAABR(3528) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc*ccth
     &      /sb*ssth-2D0*Mc*ccth*sb*ssth-Ms*csth/sb*scth)
      AAABR(3529) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*csth/sb
     &      *scth-2D0*Ms*ccth*sb*ssth)
      AAABR(3530) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth+Mb/MW**2
     &      *Mt*cbth*sb*stth)
      AAABR(3531) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mb**2/MW**2*ctth*sb*sbth+Mb/MW**2
     &      *Mt*cbth/sb*stth-Mb/MW**2*Mt*cbth*sb*stth)
      AAABR(3532) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW
     &      **2*ctth*sb*sbth+Mb/MW**2*Mt*cbth/sb*stth-Mb
     &      /MW**2*Mt*cbth*sb*stth)
      AAABR(3533) = EE**2/SW**2*Sqrt2/cb*(ctth*sb*sbth-ctth
     &      *sb**3*sbth-Mt**2/MW**2*ctth/sb*sbth+Mt**2/MW
     &      **2*ctth*sb*sbth+Mb/MW**2*Mt*cbth*sb*stth)
      AAABR(3534) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*ctth
     &      *sb*sbth+Mt**2*ctth/sb*sbth-Mt**2*ctth*sb*sbth
     &      -Mb*Mt*cbth/sb*stth)
      AAABR(3535) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *ctth*sb**3*sbth-2D0*Mt**2*ctth/sb*sbth+4D0*Mt
     &      **2*ctth*sb*sbth-2D0*Mt**2*ctth*sb**3*sbth+Mb
     &      *Mt*cbth/sb*stth-2D0*Mb*Mt*cbth*sb*stth)
      AAABR(3536) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*cbth/sb
     &      *stth-2D0*Mt*ctth/sb*sbth+2D0*Mt*ctth*sb*sbth)
      AAABR(3537) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*ctth
     &      *sb*sbth-Mt*cbth/sb*stth)
      AAABR(3538) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Md**2/MW**2*cuth*sb*sdth+Md/MW**2
     &      *Mu*cdth*sb*suth)
      AAABR(3539) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Md**2/MW**2*cuth*sb*sdth+Md/MW**2
     &      *Mu*cdth/sb*suth-Md/MW**2*Mu*cdth*sb*suth)
      AAABR(3540) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW
     &      **2*cuth*sb*sdth+Md/MW**2*Mu*cdth/sb*suth-Md
     &      /MW**2*Mu*cdth*sb*suth)
      AAABR(3541) = EE**2/SW**2*Sqrt2/cb*(cuth*sb*sdth-cuth
     &      *sb**3*sdth-Mu**2/MW**2*cuth/sb*sdth+Mu**2/MW
     &      **2*cuth*sb*sdth+Md/MW**2*Mu*cdth*sb*suth)
      AAABR(3542) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*cuth
     &      *sb*sdth+Mu**2*cuth/sb*sdth-Mu**2*cuth*sb*sdth
     &      -Md*Mu*cdth/sb*suth)
      AAABR(3543) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *cuth*sb**3*sdth-2D0*Mu**2*cuth/sb*sdth+4D0*Mu
     &      **2*cuth*sb*sdth-2D0*Mu**2*cuth*sb**3*sdth+Md
     &      *Mu*cdth/sb*suth-2D0*Md*Mu*cdth*sb*suth)
      AAABR(3544) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cdth/sb
     &      *suth-2D0*Mu*cuth/sb*sdth+2D0*Mu*cuth*sb*sdth)
      AAABR(3545) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*cuth
     &      *sb*sdth-Mu*cdth/sb*suth)
      AAABR(3546) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Ms**2/MW**2*sb*scth*ssth-Mc/MW
     &      **2*Ms*ccth*csth*sb)
      AAABR(3547) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Ms**2/MW**2*sb*scth*ssth-Mc/MW
     &      **2*Ms*ccth*csth/sb+Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3548) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Mc**2/MW**2/sb*scth*ssth+Mc**2
     &      /MW**2*sb*scth*ssth-Mc/MW**2*Ms*ccth*csth/sb
     &      +Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3549) = EE**2/SW**2*Sqrt2/cb*(sb*scth*ssth-sb
     &      **3*scth*ssth-Mc**2/MW**2/sb*scth*ssth+Mc**2
     &      /MW**2*sb*scth*ssth-Mc/MW**2*Ms*ccth*csth*sb)
      AAABR(3550) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc**2/sb
     &      *scth*ssth-Mc**2*sb*scth*ssth+Ms**2*sb*scth*ssth
     &      +Mc*Ms*ccth*csth/sb)
      AAABR(3551) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc**2
     &      /sb*scth*ssth-4D0*Mc**2*sb*scth*ssth+2D0*Mc**2
     &      *sb**3*scth*ssth-2D0*Ms**2*sb**3*scth*ssth+Mc
     &      *Ms*ccth*csth/sb-2D0*Mc*Ms*ccth*csth*sb)
      AAABR(3552) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mc/sb
     &      *scth*ssth-2D0*Mc*sb*scth*ssth+Ms*ccth*csth/sb)
      AAABR(3553) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mc*ccth*csth
     &      /sb+2D0*Ms*sb*scth*ssth)
      AAABR(3554) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Md**2/MW**2*sb*sdth*suth-Md/MW
     &      **2*Mu*cdth*cuth*sb)
      AAABR(3555) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Md**2/MW**2*sb*sdth*suth-Md/MW
     &      **2*Mu*cdth*cuth/sb+Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3556) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Mu**2/MW**2/sb*sdth*suth+Mu**2
     &      /MW**2*sb*sdth*suth-Md/MW**2*Mu*cdth*cuth/sb
     &      +Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3557) = EE**2/SW**2*Sqrt2/cb*(sb*sdth*suth-sb
     &      **3*sdth*suth-Mu**2/MW**2/sb*sdth*suth+Mu**2
     &      /MW**2*sb*sdth*suth-Md/MW**2*Mu*cdth*cuth*sb)
      AAABR(3558) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md**2*sb
     &      *sdth*suth+Mu**2/sb*sdth*suth-Mu**2*sb*sdth*suth
     &      +Md*Mu*cdth*cuth/sb)
      AAABR(3559) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md**2
     &      *sb**3*sdth*suth-2D0*Mu**2/sb*sdth*suth+4D0*Mu
     &      **2*sb*sdth*suth-2D0*Mu**2*sb**3*sdth*suth-Md
     &      *Mu*cdth*cuth/sb+2D0*Md*Mu*cdth*cuth*sb)
      AAABR(3560) = EE**2/MW**2/SW**2*Sqrt2/cb*(Md*cdth*cuth
     &      /sb+2D0*Mu/sb*sdth*suth-2D0*Mu*sb*sdth*suth)
      AAABR(3561) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Md*sb
     &      *sdth*suth+Mu*cdth*cuth/sb)
      AAABR(3562) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mb**2/MW**2*sb*sbth*stth-Mb/MW
     &      **2*Mt*cbth*ctth*sb)
      AAABR(3563) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mb**2/MW**2*sb*sbth*stth-Mb/MW
     &      **2*Mt*cbth*ctth/sb+Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3564) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mt**2/MW**2/sb*sbth*stth+Mt**2
     &      /MW**2*sb*sbth*stth-Mb/MW**2*Mt*cbth*ctth/sb
     &      +Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3565) = EE**2/SW**2*Sqrt2/cb*(sb*sbth*stth-sb
     &      **3*sbth*stth-Mt**2/MW**2/sb*sbth*stth+Mt**2
     &      /MW**2*sb*sbth*stth-Mb/MW**2*Mt*cbth*ctth*sb)
      AAABR(3566) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb**2*sb
     &      *sbth*stth+Mt**2/sb*sbth*stth-Mt**2*sb*sbth*stth
     &      +Mb*Mt*cbth*ctth/sb)
      AAABR(3567) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb**2
     &      *sb**3*sbth*stth-2D0*Mt**2/sb*sbth*stth+4D0*Mt
     &      **2*sb*sbth*stth-2D0*Mt**2*sb**3*sbth*stth-Mb
     &      *Mt*cbth*ctth/sb+2D0*Mb*Mt*cbth*ctth*sb)
      AAABR(3568) = EE**2/MW**2/SW**2*Sqrt2/cb*(Mb*cbth*ctth
     &      /sb+2D0*Mt/sb*sbth*stth-2D0*Mt*sb*sbth*stth)
      AAABR(3569) = EE**2/MW**2/SW**2*Sqrt2/cb*(2D0*Mb*sb
     &      *sbth*stth+Mt*cbth*ctth/sb)
      AAABR(3570) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sbth
     &      **2/CW**2+3D0*sbth**2/SW**2+sb**2/CW**2*sbth
     &      **2-6D0*Mb**2/MW**2/SW**2-3D0*sb**2/SW**2*sbth
     &      **2)
      AAABR(3571) = EE**2/SW**2*sbth**2*tb*(1D0-sb**2)
      AAABR(3572) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sbth
     &      **2/CW**2+3D0*sbth**2/SW**2+sb**2/CW**2*sbth
     &      **2-3D0*sb**2/SW**2*sbth**2)
      AAABR(3573) = EE**2/CW**2*tb*(2D0-2D0*sb**2-sbth**2
     &      +sb**2*sbth**2)
      AAABR(3574) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-sbth
     &      **2+sb**2*sbth**2)
      AAABR(3575) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-ssth
     &      **2/CW**2+3D0*ssth**2/SW**2+sb**2/CW**2*ssth
     &      **2-6D0*Ms**2/MW**2/SW**2-3D0*sb**2/SW**2*ssth
     &      **2)
      AAABR(3576) = EE**2/SW**2*ssth**2*tb*(1D0-sb**2)
      AAABR(3577) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-ssth
     &      **2/CW**2+3D0*ssth**2/SW**2+sb**2/CW**2*ssth
     &      **2-3D0*sb**2/SW**2*ssth**2)
      AAABR(3578) = EE**2/CW**2*tb*(2D0-2D0*sb**2-ssth**2
     &      +sb**2*ssth**2)
      AAABR(3579) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-ssth
     &      **2+sb**2*ssth**2)
      AAABR(3580) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sdth
     &      **2/CW**2+3D0*sdth**2/SW**2+sb**2/CW**2*sdth
     &      **2-6D0*Md**2/MW**2/SW**2-3D0*sb**2/SW**2*sdth
     &      **2)
      AAABR(3581) = EE**2/SW**2*sdth**2*tb*(1D0-sb**2)
      AAABR(3582) = EE**2*tb*(2D0/CW**2-2D0*sb**2/CW**2-sdth
     &      **2/CW**2+3D0*sdth**2/SW**2+sb**2/CW**2*sdth
     &      **2-3D0*sb**2/SW**2*sdth**2)
      AAABR(3583) = EE**2/CW**2*tb*(2D0-2D0*sb**2-sdth**2
     &      +sb**2*sdth**2)
      AAABR(3584) = EE**2/CW**3*SW*tb*(2D0-2D0*sb**2-sdth
     &      **2+sb**2*sdth**2)
      AAABR(3585) = EE**2*sb**2/tb*(1D0/CW**2-3D0/SW**2-5D0
     &      *scth**2/CW**2+3D0*scth**2/SW**2)
      AAABR(3586) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*scth**2+3D0*Mc**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*scth**2)
      AAABR(3587) = EE**2/SW**2*sb**2/tb*(1D0-scth**2)
      AAABR(3588) = EE**2*ccth*sb**2*scth/tb*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3589) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*scth**2+6D0*Mc**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*scth**2)
      AAABR(3590) = EE**2/CW**2*sb**2/tb*(1D0-5D0*scth**2)
      AAABR(3591) = EE**2/CW**3*SW*sb**2/tb*(1D0-5D0*scth
     &      **2)
      AAABR(3592) = EE**2/MW**2*Mc**2/SW**2/tb
      AAABR(3593) = EE**2/MW**2*Mc**2/SW**2/tb*(1D0-sb**2)
      AAABR(3594) = EE**2/MW**2*Mc/SW**2/tb
      AAABR(3595) = EE**2*sb**2/tb*(1D0/CW**2-3D0/SW**2-5D0
     &      *suth**2/CW**2+3D0*suth**2/SW**2)
      AAABR(3596) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*suth**2+3D0*Mu**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*suth**2)
      AAABR(3597) = EE**2/SW**2*sb**2/tb*(1D0-suth**2)
      AAABR(3598) = EE**2*cuth*sb**2*suth/tb*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3599) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*suth**2+6D0*Mu**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*suth**2)
      AAABR(3600) = EE**2/CW**2*sb**2/tb*(1D0-5D0*suth**2)
      AAABR(3601) = EE**2/CW**3*SW*sb**2/tb*(1D0-5D0*suth
     &      **2)
      AAABR(3602) = EE**2/MW**2*Mu**2/SW**2/tb
      AAABR(3603) = EE**2/MW**2*Mu**2/SW**2/tb*(1D0-sb**2)
      AAABR(3604) = EE**2/MW**2*Mu/SW**2/tb
      AAABR(3605) = EE**2*sb**2/tb*(1D0/CW**2-3D0/SW**2-5D0
     &      *stth**2/CW**2+3D0*stth**2/SW**2)
      AAABR(3606) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*stth**2+3D0*Mt**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*stth**2)
      AAABR(3607) = EE**2/SW**2*sb**2/tb*(1D0-stth**2)
      AAABR(3608) = EE**2*ctth*sb**2*stth/tb*(5D0/CW**2-3D0
     &      /SW**2)
      AAABR(3609) = EE**2/tb*(sb**2/CW**2-3D0*sb**2/SW**2
     &      -5D0*sb**2/CW**2*stth**2+6D0*Mt**2/MW**2/SW**2
     &      +3D0*sb**2/SW**2*stth**2)
      AAABR(3610) = EE**2/CW**2*sb**2/tb*(1D0-5D0*stth**2)
      AAABR(3611) = EE**2/CW**3*SW*sb**2/tb*(1D0-5D0*stth
     &      **2)
      AAABR(3612) = EE**2/MW**2*Mt**2/SW**2/tb
      AAABR(3613) = EE**2/MW**2*Mt**2/SW**2/tb*(1D0-sb**2)
      AAABR(3614) = EE**2/MW**2*Mt/SW**2/tb
      AAABR(3615) = EE**2/SW**2*cuth*sb**2*suth/tb
      AAABR(3616) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*suth**2-3D0*Mu**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*suth**2)
      AAABR(3617) = EE**2/CW**2*cuth*sb**2*suth/tb
      AAABR(3618) = EE**2/CW**3*SW*cuth*sb**2*suth/tb
      AAABR(3619) = EE**2/SW**2*ctth*sb**2*stth/tb
      AAABR(3620) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*stth**2-3D0*Mt**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*stth**2)
      AAABR(3621) = EE**2/CW**2*ctth*sb**2*stth/tb
      AAABR(3622) = EE**2/CW**3*SW*ctth*sb**2*stth/tb
      AAABR(3623) = EE**2/SW**2*ccth*sb**2*scth/tb
      AAABR(3624) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*scth**2-3D0*Mc**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*scth**2)
      AAABR(3625) = EE**2/CW**2*ccth*sb**2*scth/tb
      AAABR(3626) = EE**2/CW**3*SW*ccth*sb**2*scth/tb
      AAABR(3627) = EE**2*sb**2/tb*(4D0/CW**2-5D0*scth**2
     &      /CW**2+3D0*scth**2/SW**2)
      AAABR(3628) = EE**2/SW**2*sb**2*scth**2/tb
      AAABR(3629) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*scth**2-6D0*Mc**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*scth**2)
      AAABR(3630) = EE**2/CW**2*sb**2/tb*(4D0-5D0*scth**2)
      AAABR(3631) = EE**2/CW**3*SW*sb**2/tb*(4D0-5D0*scth
     &      **2)
      AAABR(3632) = EE**2*sb**2/tb*(4D0/CW**2-5D0*suth**2
     &      /CW**2+3D0*suth**2/SW**2)
      AAABR(3633) = EE**2/SW**2*sb**2*suth**2/tb
      AAABR(3634) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*suth**2-6D0*Mu**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*suth**2)
      AAABR(3635) = EE**2/CW**2*sb**2/tb*(4D0-5D0*suth**2)
      AAABR(3636) = EE**2/CW**3*SW*sb**2/tb*(4D0-5D0*suth
     &      **2)
      AAABR(3637) = EE**2*sb**2/tb*(4D0/CW**2-5D0*stth**2
     &      /CW**2+3D0*stth**2/SW**2)
      AAABR(3638) = EE**2/SW**2*sb**2*stth**2/tb
      AAABR(3639) = EE**2/tb*(4D0*sb**2/CW**2-5D0*sb**2/CW
     &      **2*stth**2-6D0*Mt**2/MW**2/SW**2+3D0*sb**2/SW
     &      **2*stth**2)
      AAABR(3640) = EE**2/CW**2*sb**2/tb*(4D0-5D0*stth**2)
      AAABR(3641) = EE**2/CW**3*SW*sb**2/tb*(4D0-5D0*stth
     &      **2)
      AAABR(3642) = EE**2*(cb/CW**2*sb-2D0*cb/CW**2*sb**3
     &      +cb/SW**2*sb-2D0*cb/SW**2*sb**3-nlk/SW**2*nlr)
      AAABR(3643) = EE**2*cb*sb*(1D0/CW**2+1D0/SW**2-2D0
     &      *sa**2/CW**2-2D0*sa**2/SW**2)
      AAABR(3644) = EE**2*ca*cb*sa*sb*(1D0/CW**2+1D0/SW**2)
      AAABR(3645) = EE**2/SW**2*ca*cb*sa*sb
      AAABR(3646) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-6D0*smuth**2/CW**2+9D0*smuth**4/CW**2
     &      -sb**2/SW**2-2D0*smuth**2/SW**2+smuth**4/SW**2
     &      +6D0*sb**2/CW**2*smuth**2-9D0*sb**2/CW**2*smuth
     &      **4+2D0*sb**2/SW**2*smuth**2-sb**2/SW**2*smuth
     &      **4+4D0*Mm**2/MW**2/SW**2*smuth**2-4D0*Mm**2
     &      /MW**2/SW**2*smuth**4)
      AAABR(3647) = EE**2/cb**2*cmuth*(3D0*smuth/CW**2-9D0
     &      *smuth**3/CW**2+smuth/SW**2-smuth**3/SW**2-3D0
     &      *sb**2/CW**2*smuth+9D0*sb**2/CW**2*smuth**3-sb
     &      **2/SW**2*smuth+sb**2/SW**2*smuth**3-2D0*Mm**2
     &      /MW**2/SW**2*smuth+4D0*Mm**2/MW**2/SW**2*smuth
     &      **3)
      AAABR(3648) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*smuth
     &      **2+smuth**4+2D0*sb**2*smuth**2-sb**2*smuth**4)
      AAABR(3649) = EE**2/CW**2/cb**2*(1D0-sb**2-6D0*smuth
     &      **2+9D0*smuth**4+6D0*sb**2*smuth**2-9D0*sb**2
     &      *smuth**4)
      AAABR(3650) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-6D0*smuth
     &      **2+9D0*smuth**4+6D0*sb**2*smuth**2-9D0*sb**2
     &      *smuth**4)
      AAABR(3651) = EE**2/MW**2*Mm**2/SW**2/cb**2*(smuth
     &      **2-smuth**4)
      AAABR(3652) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2*(smuth
     &      **2-smuth**4)
      AAABR(3653) = EE**2/MW**2*Mm/SW**2/cb**2*(smuth**2
     &      -smuth**4)
      AAABR(3654) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-6D0*seth**2/CW**2+9D0*seth**4/CW**2-sb
     &      **2/SW**2-2D0*seth**2/SW**2+seth**4/SW**2+6D0
     &      *sb**2/CW**2*seth**2-9D0*sb**2/CW**2*seth**4
     &      +2D0*sb**2/SW**2*seth**2-sb**2/SW**2*seth**4
     &      +4D0*Me**2/MW**2/SW**2*seth**2-4D0*Me**2/MW**2
     &      /SW**2*seth**4)
      AAABR(3655) = EE**2/cb**2*ceth*(3D0*seth/CW**2-9D0
     &      *seth**3/CW**2+seth/SW**2-seth**3/SW**2-3D0*sb
     &      **2/CW**2*seth+9D0*sb**2/CW**2*seth**3-sb**2
     &      /SW**2*seth+sb**2/SW**2*seth**3-2D0*Me**2/MW
     &      **2/SW**2*seth+4D0*Me**2/MW**2/SW**2*seth**3)
      AAABR(3656) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*seth
     &      **2+seth**4+2D0*sb**2*seth**2-sb**2*seth**4)
      AAABR(3657) = EE**2/CW**2/cb**2*(1D0-sb**2-6D0*seth
     &      **2+9D0*seth**4+6D0*sb**2*seth**2-9D0*sb**2*seth
     &      **4)
      AAABR(3658) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-6D0*seth
     &      **2+9D0*seth**4+6D0*sb**2*seth**2-9D0*sb**2*seth
     &      **4)
      AAABR(3659) = EE**2/MW**2*Me**2/SW**2/cb**2*(seth**2
     &      -seth**4)
      AAABR(3660) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2*(seth
     &      **2-seth**4)
      AAABR(3661) = EE**2/MW**2*Me/SW**2/cb**2*(seth**2-seth
     &      **4)
      AAABR(3662) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*seth**2/CW**2-3D0*slth**2/CW**2-sb
     &      **2/SW**2-seth**2/SW**2-slth**2/SW**2+3D0*sb
     &      **2/CW**2*seth**2+3D0*sb**2/CW**2*slth**2+9D0
     &      *seth**2/CW**2*slth**2+sb**2/SW**2*seth**2+sb
     &      **2/SW**2*slth**2+seth**2/SW**2*slth**2-9D0*sb
     &      **2/CW**2*seth**2*slth**2-sb**2/SW**2*seth**2
     &      *slth**2+4D0*Me/MW**2*Ml/SW**2*ceth*clth*seth
     &      *slth)
      AAABR(3663) = EE**2/cb**2*(3D0*clth/CW**2*slth+clth
     &      /SW**2*slth-3D0*clth/CW**2*sb**2*slth-9D0*clth
     &      /CW**2*seth**2*slth-clth/SW**2*sb**2*slth-clth
     &      /SW**2*seth**2*slth+9D0*clth/CW**2*sb**2*seth
     &      **2*slth+clth/SW**2*sb**2*seth**2*slth-2D0*Me
     &      /MW**2*Ml/SW**2*ceth*seth+4D0*Me/MW**2*Ml/SW
     &      **2*ceth*seth*slth**2)
      AAABR(3664) = EE**2/SW**2/cb**2*(1D0-sb**2-seth**2
     &      -slth**2+sb**2*seth**2+sb**2*slth**2+seth**2
     &      *slth**2-sb**2*seth**2*slth**2)
      AAABR(3665) = EE**2/cb**2*(3D0*ceth/CW**2*seth+ceth
     &      /SW**2*seth-3D0*ceth/CW**2*sb**2*seth-9D0*ceth
     &      /CW**2*seth*slth**2-ceth/SW**2*sb**2*seth-ceth
     &      /SW**2*seth*slth**2+9D0*ceth/CW**2*sb**2*seth
     &      *slth**2+ceth/SW**2*sb**2*seth*slth**2-2D0*Me
     &      /MW**2*Ml/SW**2*clth*slth+4D0*Me/MW**2*Ml/SW
     &      **2*clth*seth**2*slth)
      AAABR(3666) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*seth
     &      **2-3D0*slth**2+3D0*sb**2*seth**2+3D0*sb**2*slth
     &      **2+9D0*seth**2*slth**2-9D0*sb**2*seth**2*slth
     &      **2)
      AAABR(3667) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*seth
     &      **2-3D0*slth**2+3D0*sb**2*seth**2+3D0*sb**2*slth
     &      **2+9D0*seth**2*slth**2-9D0*sb**2*seth**2*slth
     &      **2)
      AAABR(3668) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*clth
     &      *seth*slth
      AAABR(3669) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*clth
     &      *sb**2*seth*slth
      AAABR(3670) = EE**2/MW**2*Me/SW**2/cb**2*ceth*clth
     &      *seth*slth
      AAABR(3671) = EE**2/MW**2*Ml/SW**2/cb**2*ceth*clth
     &      *seth*slth
      AAABR(3672) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-6D0*slth**2/CW**2+9D0*slth**4/CW**2-sb
     &      **2/SW**2-2D0*slth**2/SW**2+slth**4/SW**2+6D0
     &      *sb**2/CW**2*slth**2-9D0*sb**2/CW**2*slth**4
     &      +2D0*sb**2/SW**2*slth**2-sb**2/SW**2*slth**4
     &      +4D0*Ml**2/MW**2/SW**2*slth**2-4D0*Ml**2/MW**2
     &      /SW**2*slth**4)
      AAABR(3673) = EE**2/cb**2*clth*(3D0*slth/CW**2-9D0
     &      *slth**3/CW**2+slth/SW**2-slth**3/SW**2-3D0*sb
     &      **2/CW**2*slth+9D0*sb**2/CW**2*slth**3-sb**2
     &      /SW**2*slth+sb**2/SW**2*slth**3-2D0*Ml**2/MW
     &      **2/SW**2*slth+4D0*Ml**2/MW**2/SW**2*slth**3)
      AAABR(3674) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*slth
     &      **2+slth**4+2D0*sb**2*slth**2-sb**2*slth**4)
      AAABR(3675) = EE**2/CW**2/cb**2*(1D0-sb**2-6D0*slth
     &      **2+9D0*slth**4+6D0*sb**2*slth**2-9D0*sb**2*slth
     &      **4)
      AAABR(3676) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-6D0*slth
     &      **2+9D0*slth**4+6D0*sb**2*slth**2-9D0*sb**2*slth
     &      **4)
      AAABR(3677) = EE**2/MW**2*Ml**2/SW**2/cb**2*(slth**2
     &      -slth**4)
      AAABR(3678) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2*(slth
     &      **2-slth**4)
      AAABR(3679) = EE**2/MW**2*Ml/SW**2/cb**2*(slth**2-slth
     &      **4)
      AAABR(3680) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*seth**2/CW**2-3D0*smuth**2/CW**2-sb
     &      **2/SW**2-seth**2/SW**2-smuth**2/SW**2+3D0*sb
     &      **2/CW**2*seth**2+3D0*sb**2/CW**2*smuth**2+9D0
     &      *seth**2/CW**2*smuth**2+sb**2/SW**2*seth**2+sb
     &      **2/SW**2*smuth**2+seth**2/SW**2*smuth**2-9D0
     &      *sb**2/CW**2*seth**2*smuth**2-sb**2/SW**2*seth
     &      **2*smuth**2+4D0*Me/MW**2*Mm/SW**2*ceth*cmuth
     &      *seth*smuth)
      AAABR(3681) = EE**2/cb**2*(3D0*cmuth/CW**2*smuth+cmuth
     &      /SW**2*smuth-3D0*cmuth/CW**2*sb**2*smuth-9D0
     &      *cmuth/CW**2*seth**2*smuth-cmuth/SW**2*sb**2
     &      *smuth-cmuth/SW**2*seth**2*smuth+9D0*cmuth/CW
     &      **2*sb**2*seth**2*smuth+cmuth/SW**2*sb**2*seth
     &      **2*smuth-2D0*Me/MW**2*Mm/SW**2*ceth*seth+4D0
     &      *Me/MW**2*Mm/SW**2*ceth*seth*smuth**2)
      AAABR(3682) = EE**2/SW**2/cb**2*(1D0-sb**2-seth**2
     &      -smuth**2+sb**2*seth**2+sb**2*smuth**2+seth**2
     &      *smuth**2-sb**2*seth**2*smuth**2)
      AAABR(3683) = EE**2/cb**2*(3D0*ceth/CW**2*seth+ceth
     &      /SW**2*seth-3D0*ceth/CW**2*sb**2*seth-9D0*ceth
     &      /CW**2*seth*smuth**2-ceth/SW**2*sb**2*seth-ceth
     &      /SW**2*seth*smuth**2+9D0*ceth/CW**2*sb**2*seth
     &      *smuth**2+ceth/SW**2*sb**2*seth*smuth**2-2D0
     &      *Me/MW**2*Mm/SW**2*cmuth*smuth+4D0*Me/MW**2*Mm
     &      /SW**2*cmuth*seth**2*smuth)
      AAABR(3684) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*seth
     &      **2-3D0*smuth**2+3D0*sb**2*seth**2+3D0*sb**2
     &      *smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3685) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*seth
     &      **2-3D0*smuth**2+3D0*sb**2*seth**2+3D0*sb**2
     &      *smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3686) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*cmuth
     &      *seth*smuth
      AAABR(3687) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*cmuth
     &      *sb**2*seth*smuth
      AAABR(3688) = EE**2/MW**2*Me/SW**2/cb**2*ceth*cmuth
     &      *seth*smuth
      AAABR(3689) = EE**2/MW**2*Mm/SW**2/cb**2*ceth*cmuth
     &      *seth*smuth
      AAABR(3690) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*slth**2/CW**2-3D0*smuth**2/CW**2-sb
     &      **2/SW**2-slth**2/SW**2-smuth**2/SW**2+3D0*sb
     &      **2/CW**2*slth**2+3D0*sb**2/CW**2*smuth**2+9D0
     &      *slth**2/CW**2*smuth**2+sb**2/SW**2*slth**2+sb
     &      **2/SW**2*smuth**2+slth**2/SW**2*smuth**2-9D0
     &      *sb**2/CW**2*slth**2*smuth**2-sb**2/SW**2*slth
     &      **2*smuth**2+4D0*Ml/MW**2*Mm/SW**2*clth*cmuth
     &      *slth*smuth)
      AAABR(3691) = EE**2/cb**2*(3D0*clth/CW**2*slth+clth
     &      /SW**2*slth-3D0*clth/CW**2*sb**2*slth-9D0*clth
     &      /CW**2*slth*smuth**2-clth/SW**2*sb**2*slth-clth
     &      /SW**2*slth*smuth**2+9D0*clth/CW**2*sb**2*slth
     &      *smuth**2+clth/SW**2*sb**2*slth*smuth**2-2D0
     &      *Ml/MW**2*Mm/SW**2*cmuth*smuth+4D0*Ml/MW**2*Mm
     &      /SW**2*cmuth*slth**2*smuth)
      AAABR(3692) = EE**2/SW**2/cb**2*(1D0-sb**2-slth**2
     &      -smuth**2+sb**2*slth**2+sb**2*smuth**2+slth**2
     &      *smuth**2-sb**2*slth**2*smuth**2)
      AAABR(3693) = EE**2/cb**2*(3D0*cmuth/CW**2*smuth+cmuth
     &      /SW**2*smuth-3D0*cmuth/CW**2*sb**2*smuth-9D0
     &      *cmuth/CW**2*slth**2*smuth-cmuth/SW**2*sb**2
     &      *smuth-cmuth/SW**2*slth**2*smuth+9D0*cmuth/CW
     &      **2*sb**2*slth**2*smuth+cmuth/SW**2*sb**2*slth
     &      **2*smuth-2D0*Ml/MW**2*Mm/SW**2*clth*slth+4D0
     &      *Ml/MW**2*Mm/SW**2*clth*slth*smuth**2)
      AAABR(3694) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*slth
     &      **2-3D0*smuth**2+3D0*sb**2*slth**2+3D0*sb**2
     &      *smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3695) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*slth
     &      **2-3D0*smuth**2+3D0*sb**2*slth**2+3D0*sb**2
     &      *smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3696) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*cmuth
     &      *slth*smuth
      AAABR(3697) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*cmuth
     &      *sb**2*slth*smuth
      AAABR(3698) = EE**2/MW**2*Mm/SW**2/cb**2*clth*cmuth
     &      *slth*smuth
      AAABR(3699) = EE**2/MW**2*Ml/SW**2/cb**2*clth*cmuth
     &      *slth*smuth
      AAABR(3700) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -27D0*slth**2/CW**2+27D0*slth**4/CW**2-3D0*slth
     &      **2/SW**2+3D0*slth**4/SW**2+27D0*sb**2/CW**2
     &      *slth**2-27D0*sb**2/CW**2*slth**4-2D0*Ml**2/MW
     &      **2/SW**2+3D0*sb**2/SW**2*slth**2-3D0*sb**2/SW
     &      **2*slth**4+12D0*Ml**2/MW**2/SW**2*slth**2-12D0
     &      *Ml**2/MW**2/SW**2*slth**4)
      AAABR(3701) = EE**2/SW**2/cb**2*clth*(slth-slth**3
     &      -sb**2*slth+sb**2*slth**3)
      AAABR(3702) = EE**2/CW**2/cb**2*clth*(slth-3D0*slth
     &      **3-sb**2*slth+3D0*sb**2*slth**3)
      AAABR(3703) = EE**2/CW**3*SW/cb**2*clth*(slth-3D0*slth
     &      **3-sb**2*slth+3D0*sb**2*slth**3)
      AAABR(3704) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth*(slth
     &      -2D0*slth**3)
      AAABR(3705) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth*sb
     &      **2*(slth-2D0*slth**3)
      AAABR(3706) = EE**2/MW**2*Ml/SW**2/cb**2*clth*(slth
     &      -2D0*slth**3)
      AAABR(3707) = EE**2/cb**2*(Ml/MW**2*Mm/SW**2+9D0*clth
     &      /CW**2*cmuth*slth*smuth-2D0*Ml/MW**2*Mm/SW**2
     &      *slth**2-2D0*Ml/MW**2*Mm/SW**2*smuth**2+clth
     &      /SW**2*cmuth*slth*smuth-9D0*clth/CW**2*cmuth
     &      *sb**2*slth*smuth+4D0*Ml/MW**2*Mm/SW**2*slth
     &      **2*smuth**2-clth/SW**2*cmuth*sb**2*slth*smuth)
      AAABR(3708) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-slth**2+sb**2*slth**2)
      AAABR(3709) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*slth**2/CW**2-3D0*smuth**2/CW**2-smuth**2
     &      /SW**2+6D0*sb**2/CW**2*slth**2+3D0*sb**2/CW**2
     &      *smuth**2+9D0*slth**2/CW**2*smuth**2+sb**2/SW
     &      **2*smuth**2+slth**2/SW**2*smuth**2-9D0*sb**2
     &      /CW**2*slth**2*smuth**2-sb**2/SW**2*slth**2*smuth
     &      **2+4D0*Ml/MW**2*Mm/SW**2*clth*cmuth*slth*smuth)
      AAABR(3710) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3711) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3712) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*smuth**2)
      AAABR(3713) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*sb
     &      **2*slth*(1D0-2D0*smuth**2)
      AAABR(3714) = EE**2/MW**2*Mm/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*smuth**2)
      AAABR(3715) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*smuth**2)
      AAABR(3716) = EE**2/cb**2*(Me/MW**2*Mm/SW**2+9D0*ceth
     &      /CW**2*cmuth*seth*smuth-2D0*Me/MW**2*Mm/SW**2
     &      *seth**2-2D0*Me/MW**2*Mm/SW**2*smuth**2+ceth
     &      /SW**2*cmuth*seth*smuth-9D0*ceth/CW**2*cmuth
     &      *sb**2*seth*smuth+4D0*Me/MW**2*Mm/SW**2*seth
     &      **2*smuth**2-ceth/SW**2*cmuth*sb**2*seth*smuth)
      AAABR(3717) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(3718) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*seth**2/CW**2-6D0*smuth**2/CW**2-seth**2
     &      /SW**2+3D0*sb**2/CW**2*seth**2+6D0*sb**2/CW**2
     &      *smuth**2+9D0*seth**2/CW**2*smuth**2+sb**2/SW
     &      **2*seth**2+seth**2/SW**2*smuth**2-9D0*sb**2
     &      /CW**2*seth**2*smuth**2-sb**2/SW**2*seth**2*smuth
     &      **2+4D0*Me/MW**2*Mm/SW**2*ceth*cmuth*seth*smuth)
      AAABR(3719) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3720) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3721) = EE**2/MW**2*Me*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*seth**2)
      AAABR(3722) = EE**2/MW**2*Me*Mm/SW**2/cb**2*cmuth*sb
     &      **2*smuth*(1D0-2D0*seth**2)
      AAABR(3723) = EE**2/MW**2*Me/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*seth**2)
      AAABR(3724) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*seth**2)
      AAABR(3725) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-3D0*smuth**2/CW**2-smuth**2
     &      /SW**2+6D0*sb**2/CW**2*seth**2+3D0*sb**2/CW**2
     &      *smuth**2+9D0*seth**2/CW**2*smuth**2+sb**2/SW
     &      **2*smuth**2+seth**2/SW**2*smuth**2-9D0*sb**2
     &      /CW**2*seth**2*smuth**2-sb**2/SW**2*seth**2*smuth
     &      **2+4D0*Me/MW**2*Mm/SW**2*ceth*cmuth*seth*smuth)
      AAABR(3726) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-seth**2+sb**2*seth**2)
      AAABR(3727) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3728) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3729) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*smuth**2)
      AAABR(3730) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*sb
     &      **2*seth*(1D0-2D0*smuth**2)
      AAABR(3731) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*smuth**2)
      AAABR(3732) = EE**2/MW**2*Mm/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*smuth**2)
      AAABR(3733) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -27D0*smuth**2/CW**2+27D0*smuth**4/CW**2-3D0
     &      *smuth**2/SW**2+3D0*smuth**4/SW**2+27D0*sb**2
     &      /CW**2*smuth**2-27D0*sb**2/CW**2*smuth**4-2D0
     &      *Mm**2/MW**2/SW**2+3D0*sb**2/SW**2*smuth**2-3D0
     &      *sb**2/SW**2*smuth**4+12D0*Mm**2/MW**2/SW**2
     &      *smuth**2-12D0*Mm**2/MW**2/SW**2*smuth**4)
      AAABR(3734) = EE**2/SW**2/cb**2*cmuth*(smuth-smuth
     &      **3-sb**2*smuth+sb**2*smuth**3)
      AAABR(3735) = EE**2/CW**2/cb**2*cmuth*(smuth-3D0*smuth
     &      **3-sb**2*smuth+3D0*sb**2*smuth**3)
      AAABR(3736) = EE**2/CW**3*SW/cb**2*cmuth*(smuth-3D0
     &      *smuth**3-sb**2*smuth+3D0*sb**2*smuth**3)
      AAABR(3737) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth*(smuth
     &      -2D0*smuth**3)
      AAABR(3738) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth*sb
     &      **2*(smuth-2D0*smuth**3)
      AAABR(3739) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*(smuth
     &      -2D0*smuth**3)
      AAABR(3740) = EE**2/cb**2*(Me/MW**2*Ml/SW**2+9D0*ceth
     &      /CW**2*clth*seth*slth-2D0*Me/MW**2*Ml/SW**2*seth
     &      **2-2D0*Me/MW**2*Ml/SW**2*slth**2+ceth/SW**2
     &      *clth*seth*slth-9D0*ceth/CW**2*clth*sb**2*seth
     &      *slth+4D0*Me/MW**2*Ml/SW**2*seth**2*slth**2-ceth
     &      /SW**2*clth*sb**2*seth*slth)
      AAABR(3741) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(3742) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*seth**2/CW**2-6D0*slth**2/CW**2-seth**2
     &      /SW**2+3D0*sb**2/CW**2*seth**2+6D0*sb**2/CW**2
     &      *slth**2+9D0*seth**2/CW**2*slth**2+sb**2/SW**2
     &      *seth**2+seth**2/SW**2*slth**2-9D0*sb**2/CW**2
     &      *seth**2*slth**2-sb**2/SW**2*seth**2*slth**2
     &      +4D0*Me/MW**2*Ml/SW**2*ceth*clth*seth*slth)
      AAABR(3743) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3744) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3745) = EE**2/MW**2*Me*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*seth**2)
      AAABR(3746) = EE**2/MW**2*Me*Ml/SW**2/cb**2*clth*sb
     &      **2*slth*(1D0-2D0*seth**2)
      AAABR(3747) = EE**2/MW**2*Me/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*seth**2)
      AAABR(3748) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*seth**2)
      AAABR(3749) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*slth**2/CW**2-6D0*smuth**2/CW**2-slth**2
     &      /SW**2+3D0*sb**2/CW**2*slth**2+6D0*sb**2/CW**2
     &      *smuth**2+9D0*slth**2/CW**2*smuth**2+sb**2/SW
     &      **2*slth**2+slth**2/SW**2*smuth**2-9D0*sb**2
     &      /CW**2*slth**2*smuth**2-sb**2/SW**2*slth**2*smuth
     &      **2+4D0*Ml/MW**2*Mm/SW**2*clth*cmuth*slth*smuth)
      AAABR(3750) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(3751) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3752) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3753) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*slth**2)
      AAABR(3754) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*cmuth*sb
     &      **2*smuth*(1D0-2D0*slth**2)
      AAABR(3755) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*slth**2)
      AAABR(3756) = EE**2/MW**2*Ml/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*slth**2)
      AAABR(3757) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-3D0*slth**2/CW**2-slth**2
     &      /SW**2+6D0*sb**2/CW**2*seth**2+3D0*sb**2/CW**2
     &      *slth**2+9D0*seth**2/CW**2*slth**2+sb**2/SW**2
     &      *slth**2+seth**2/SW**2*slth**2-9D0*sb**2/CW**2
     &      *seth**2*slth**2-sb**2/SW**2*seth**2*slth**2
     &      +4D0*Me/MW**2*Ml/SW**2*ceth*clth*seth*slth)
      AAABR(3758) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(3759) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3760) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3761) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*slth**2)
      AAABR(3762) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*sb
     &      **2*seth*(1D0-2D0*slth**2)
      AAABR(3763) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*slth**2)
      AAABR(3764) = EE**2/MW**2*Ml/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*slth**2)
      AAABR(3765) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -27D0*seth**2/CW**2+27D0*seth**4/CW**2-3D0*seth
     &      **2/SW**2+3D0*seth**4/SW**2+27D0*sb**2/CW**2
     &      *seth**2-27D0*sb**2/CW**2*seth**4-2D0*Me**2/MW
     &      **2/SW**2+3D0*sb**2/SW**2*seth**2-3D0*sb**2/SW
     &      **2*seth**4+12D0*Me**2/MW**2/SW**2*seth**2-12D0
     &      *Me**2/MW**2/SW**2*seth**4)
      AAABR(3766) = EE**2/SW**2/cb**2*ceth*(seth-seth**3
     &      -sb**2*seth+sb**2*seth**3)
      AAABR(3767) = EE**2/CW**2/cb**2*ceth*(seth-3D0*seth
     &      **3-sb**2*seth+3D0*sb**2*seth**3)
      AAABR(3768) = EE**2/CW**3*SW/cb**2*ceth*(seth-3D0*seth
     &      **3-sb**2*seth+3D0*sb**2*seth**3)
      AAABR(3769) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth*(seth
     &      -2D0*seth**3)
      AAABR(3770) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth*sb
     &      **2*(seth-2D0*seth**3)
      AAABR(3771) = EE**2/MW**2*Me/SW**2/cb**2*ceth*(seth
     &      -2D0*seth**3)
      AAABR(3772) = EE**2/cb**2*(9D0*ceth/CW**2*clth*seth
     &      *slth-2D0*Me/MW**2*Ml/SW**2*seth**2-2D0*Me/MW
     &      **2*Ml/SW**2*slth**2+ceth/SW**2*clth*seth*slth
     &      -9D0*ceth/CW**2*clth*sb**2*seth*slth+4D0*Me/MW
     &      **2*Ml/SW**2*seth**2*slth**2-ceth/SW**2*clth
     &      *sb**2*seth*slth)
      AAABR(3773) = EE**2/cb**2*(6D0*ceth/CW**2*seth-6D0
     &      *ceth/CW**2*sb**2*seth-9D0*ceth/CW**2*seth*slth
     &      **2-ceth/SW**2*seth*slth**2+9D0*ceth/CW**2*sb
     &      **2*seth*slth**2+ceth/SW**2*sb**2*seth*slth**2
     &      -2D0*Me/MW**2*Ml/SW**2*clth*slth+4D0*Me/MW**2
     &      *Ml/SW**2*clth*seth**2*slth)
      AAABR(3774) = EE**2/SW**2/cb**2*ceth*clth*seth*slth
     &      *(1D0-sb**2)
      AAABR(3775) = EE**2/cb**2*(6D0*clth/CW**2*slth-6D0
     &      *clth/CW**2*sb**2*slth-9D0*clth/CW**2*seth**2
     &      *slth-clth/SW**2*seth**2*slth+9D0*clth/CW**2
     &      *sb**2*seth**2*slth+clth/SW**2*sb**2*seth**2
     &      *slth-2D0*Me/MW**2*Ml/SW**2*ceth*seth+4D0*Me
     &      /MW**2*Ml/SW**2*ceth*seth*slth**2)
      AAABR(3776) = EE**2/CW**2/cb**2*ceth*clth*seth*slth
     &      *(1D0-sb**2)
      AAABR(3777) = EE**2/CW**3*SW/cb**2*ceth*clth*seth*slth
     &      *(1D0-sb**2)
      AAABR(3778) = EE**2/MW**2*Me*Ml/SW**2/cb**2*(seth**2
     &      +slth**2-2D0*seth**2*slth**2)
      AAABR(3779) = EE**2/MW**2*Me*Ml/SW**2/cb**2*sb**2*(seth
     &      **2+slth**2-2D0*seth**2*slth**2)
      AAABR(3780) = EE**2/MW**2*Me/SW**2/cb**2*(seth**2+slth
     &      **2-2D0*seth**2*slth**2)
      AAABR(3781) = EE**2/MW**2*Ml/SW**2/cb**2*(seth**2+slth
     &      **2-2D0*seth**2*slth**2)
      AAABR(3782) = EE**2/cb**2*(9D0*clth/CW**2*cmuth*slth
     &      *smuth-2D0*Ml/MW**2*Mm/SW**2*slth**2-2D0*Ml/MW
     &      **2*Mm/SW**2*smuth**2+clth/SW**2*cmuth*slth*smuth
     &      -9D0*clth/CW**2*cmuth*sb**2*slth*smuth+4D0*Ml
     &      /MW**2*Mm/SW**2*slth**2*smuth**2-clth/SW**2*cmuth
     &      *sb**2*slth*smuth)
      AAABR(3783) = EE**2/cb**2*(6D0*cmuth/CW**2*smuth-6D0
     &      *cmuth/CW**2*sb**2*smuth-9D0*cmuth/CW**2*slth
     &      **2*smuth-cmuth/SW**2*slth**2*smuth+9D0*cmuth
     &      /CW**2*sb**2*slth**2*smuth+cmuth/SW**2*sb**2
     &      *slth**2*smuth-2D0*Ml/MW**2*Mm/SW**2*clth*slth
     &      +4D0*Ml/MW**2*Mm/SW**2*clth*slth*smuth**2)
      AAABR(3784) = EE**2/SW**2/cb**2*clth*cmuth*slth*smuth
     &      *(1D0-sb**2)
      AAABR(3785) = EE**2/cb**2*(6D0*clth/CW**2*slth-6D0
     &      *clth/CW**2*sb**2*slth-9D0*clth/CW**2*slth*smuth
     &      **2-clth/SW**2*slth*smuth**2+9D0*clth/CW**2*sb
     &      **2*slth*smuth**2+clth/SW**2*sb**2*slth*smuth
     &      **2-2D0*Ml/MW**2*Mm/SW**2*cmuth*smuth+4D0*Ml
     &      /MW**2*Mm/SW**2*cmuth*slth**2*smuth)
      AAABR(3786) = EE**2/CW**2/cb**2*clth*cmuth*slth*smuth
     &      *(1D0-sb**2)
      AAABR(3787) = EE**2/CW**3*SW/cb**2*clth*cmuth*slth
     &      *smuth*(1D0-sb**2)
      AAABR(3788) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*(slth**2
     &      +smuth**2-2D0*slth**2*smuth**2)
      AAABR(3789) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*sb**2*(slth
     &      **2+smuth**2-2D0*slth**2*smuth**2)
      AAABR(3790) = EE**2/MW**2*Mm/SW**2/cb**2*(slth**2+smuth
     &      **2-2D0*slth**2*smuth**2)
      AAABR(3791) = EE**2/MW**2*Ml/SW**2/cb**2*(slth**2+smuth
     &      **2-2D0*slth**2*smuth**2)
      AAABR(3792) = EE**2/cb**2*ceth**2*seth**2*(9D0/CW**2
     &      +1D0/SW**2-9D0*sb**2/CW**2-sb**2/SW**2-4D0*Me
     &      **2/MW**2/SW**2)
      AAABR(3793) = EE**2/cb**2*ceth*(6D0*seth/CW**2-9D0
     &      *seth**3/CW**2-seth**3/SW**2-6D0*sb**2/CW**2
     &      *seth+9D0*sb**2/CW**2*seth**3+sb**2/SW**2*seth
     &      **3-2D0*Me**2/MW**2/SW**2*seth+4D0*Me**2/MW**2
     &      /SW**2*seth**3)
      AAABR(3794) = EE**2/SW**2/cb**2*ceth**2*seth**2*(1D0
     &      -sb**2)
      AAABR(3795) = EE**2/CW**2/cb**2*ceth**2*seth**2*(1D0
     &      -sb**2)
      AAABR(3796) = EE**2/CW**3*SW/cb**2*ceth**2*seth**2
     &      *(1D0-sb**2)
      AAABR(3797) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth**2
     &      *seth**2
      AAABR(3798) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth**2
     &      *sb**2*seth**2
      AAABR(3799) = EE**2/MW**2*Me/SW**2/cb**2*ceth**2*seth
     &      **2
      AAABR(3800) = EE**2/cb**2*(9D0*ceth/CW**2*cmuth*seth
     &      *smuth-2D0*Me/MW**2*Mm/SW**2*seth**2-2D0*Me/MW
     &      **2*Mm/SW**2*smuth**2+ceth/SW**2*cmuth*seth*smuth
     &      -9D0*ceth/CW**2*cmuth*sb**2*seth*smuth+4D0*Me
     &      /MW**2*Mm/SW**2*seth**2*smuth**2-ceth/SW**2*cmuth
     &      *sb**2*seth*smuth)
      AAABR(3801) = EE**2/cb**2*(6D0*ceth/CW**2*seth-6D0
     &      *ceth/CW**2*sb**2*seth-9D0*ceth/CW**2*seth*smuth
     &      **2-ceth/SW**2*seth*smuth**2+9D0*ceth/CW**2*sb
     &      **2*seth*smuth**2+ceth/SW**2*sb**2*seth*smuth
     &      **2-2D0*Me/MW**2*Mm/SW**2*cmuth*smuth+4D0*Me
     &      /MW**2*Mm/SW**2*cmuth*seth**2*smuth)
      AAABR(3802) = EE**2/SW**2/cb**2*ceth*cmuth*seth*smuth
     &      *(1D0-sb**2)
      AAABR(3803) = EE**2/cb**2*(6D0*cmuth/CW**2*smuth-6D0
     &      *cmuth/CW**2*sb**2*smuth-9D0*cmuth/CW**2*seth
     &      **2*smuth-cmuth/SW**2*seth**2*smuth+9D0*cmuth
     &      /CW**2*sb**2*seth**2*smuth+cmuth/SW**2*sb**2
     &      *seth**2*smuth-2D0*Me/MW**2*Mm/SW**2*ceth*seth
     &      +4D0*Me/MW**2*Mm/SW**2*ceth*seth*smuth**2)
      AAABR(3804) = EE**2/CW**2/cb**2*ceth*cmuth*seth*smuth
     &      *(1D0-sb**2)
      AAABR(3805) = EE**2/CW**3*SW/cb**2*ceth*cmuth*seth
     &      *smuth*(1D0-sb**2)
      AAABR(3806) = EE**2/MW**2*Me*Mm/SW**2/cb**2*(seth**2
     &      +smuth**2-2D0*seth**2*smuth**2)
      AAABR(3807) = EE**2/MW**2*Me*Mm/SW**2/cb**2*sb**2*(seth
     &      **2+smuth**2-2D0*seth**2*smuth**2)
      AAABR(3808) = EE**2/MW**2*Me/SW**2/cb**2*(seth**2+smuth
     &      **2-2D0*seth**2*smuth**2)
      AAABR(3809) = EE**2/MW**2*Mm/SW**2/cb**2*(seth**2+smuth
     &      **2-2D0*seth**2*smuth**2)
      AAABR(3810) = EE**2/cb**2*clth**2*slth**2*(9D0/CW**2
     &      +1D0/SW**2-9D0*sb**2/CW**2-sb**2/SW**2-4D0*Ml
     &      **2/MW**2/SW**2)
      AAABR(3811) = EE**2/cb**2*clth*(6D0*slth/CW**2-9D0
     &      *slth**3/CW**2-slth**3/SW**2-6D0*sb**2/CW**2
     &      *slth+9D0*sb**2/CW**2*slth**3+sb**2/SW**2*slth
     &      **3-2D0*Ml**2/MW**2/SW**2*slth+4D0*Ml**2/MW**2
     &      /SW**2*slth**3)
      AAABR(3812) = EE**2/SW**2/cb**2*clth**2*slth**2*(1D0
     &      -sb**2)
      AAABR(3813) = EE**2/CW**2/cb**2*clth**2*slth**2*(1D0
     &      -sb**2)
      AAABR(3814) = EE**2/CW**3*SW/cb**2*clth**2*slth**2
     &      *(1D0-sb**2)
      AAABR(3815) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth**2
     &      *slth**2
      AAABR(3816) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth**2
     &      *sb**2*slth**2
      AAABR(3817) = EE**2/MW**2*Ml/SW**2/cb**2*clth**2*slth
     &      **2
      AAABR(3818) = EE**2/cb**2*cmuth**2*smuth**2*(9D0/CW
     &      **2+1D0/SW**2-9D0*sb**2/CW**2-sb**2/SW**2-4D0
     &      *Mm**2/MW**2/SW**2)
      AAABR(3819) = EE**2/cb**2*cmuth*(6D0*smuth/CW**2-9D0
     &      *smuth**3/CW**2-smuth**3/SW**2-6D0*sb**2/CW**2
     &      *smuth+9D0*sb**2/CW**2*smuth**3+sb**2/SW**2*smuth
     &      **3-2D0*Mm**2/MW**2/SW**2*smuth+4D0*Mm**2/MW
     &      **2/SW**2*smuth**3)
      AAABR(3820) = EE**2/SW**2/cb**2*cmuth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(3821) = EE**2/CW**2/cb**2*cmuth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(3822) = EE**2/CW**3*SW/cb**2*cmuth**2*smuth**2
     &      *(1D0-sb**2)
      AAABR(3823) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth**2
     &      *smuth**2
      AAABR(3824) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth**2
     &      *sb**2*smuth**2
      AAABR(3825) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth**2*smuth
     &      **2
      AAABR(3826) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(3827) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2-6D0*slth**2+3D0*sb**2*seth**2+6D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(3828) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2-6D0*slth**2+3D0*sb**2*seth**2+6D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(3829) = EE**2/cb**2*(2D0*Ml/MW**2*Mm/SW**2+9D0
     &      *clth/CW**2*cmuth*slth*smuth-2D0*Ml/MW**2*Mm
     &      /SW**2*slth**2-2D0*Ml/MW**2*Mm/SW**2*smuth**2
     &      +clth/SW**2*cmuth*slth*smuth-9D0*clth/CW**2*cmuth
     &      *sb**2*slth*smuth+4D0*Ml/MW**2*Mm/SW**2*slth
     &      **2*smuth**2-clth/SW**2*cmuth*sb**2*slth*smuth)
      AAABR(3830) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*(1D0-slth
     &      **2-smuth**2+2D0*slth**2*smuth**2)
      AAABR(3831) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*sb**2*(1D0
     &      -slth**2-smuth**2+2D0*slth**2*smuth**2)
      AAABR(3832) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-slth
     &      **2-smuth**2+2D0*slth**2*smuth**2)
      AAABR(3833) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-slth
     &      **2-smuth**2+2D0*slth**2*smuth**2)
      AAABR(3834) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(3835) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-3D0*smuth**2+6D0*sb**2*seth**2+3D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3836) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-3D0*smuth**2+6D0*sb**2*seth**2+3D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3837) = EE**2/cb**2*(1D0/CW**2-sb**2/CW**2-9D0
     &      *smuth**2/CW**2+9D0*smuth**4/CW**2-smuth**2/SW
     &      **2+smuth**4/SW**2+9D0*sb**2/CW**2*smuth**2-9D0
     &      *sb**2/CW**2*smuth**4-Mm**2/MW**2/SW**2+sb**2
     &      /SW**2*smuth**2-sb**2/SW**2*smuth**4+4D0*Mm**2
     &      /MW**2/SW**2*smuth**2-4D0*Mm**2/MW**2/SW**2*smuth
     &      **4)
      AAABR(3838) = EE**2/SW**2/cb**2*(smuth**2-smuth**4
     &      -sb**2*smuth**2+sb**2*smuth**4)
      AAABR(3839) = EE**2/CW**2/cb**2*(1D0-sb**2-9D0*smuth
     &      **2+9D0*smuth**4+9D0*sb**2*smuth**2-9D0*sb**2
     &      *smuth**4)
      AAABR(3840) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-9D0*smuth
     &      **2+9D0*smuth**4+9D0*sb**2*smuth**2-9D0*sb**2
     &      *smuth**4)
      AAABR(3841) = EE**2/MW**2*Mm**2/SW**2/cb**2*(1D0-4D0
     &      *smuth**2+4D0*smuth**4)
      AAABR(3842) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2*(1D0
     &      -4D0*smuth**2+4D0*smuth**4)
      AAABR(3843) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-4D0*smuth
     &      **2+4D0*smuth**4)
      AAABR(3844) = EE**2/cb**2*(2D0*Me/MW**2*Ml/SW**2+9D0
     &      *ceth/CW**2*clth*seth*slth-2D0*Me/MW**2*Ml/SW
     &      **2*seth**2-2D0*Me/MW**2*Ml/SW**2*slth**2+ceth
     &      /SW**2*clth*seth*slth-9D0*ceth/CW**2*clth*sb
     &      **2*seth*slth+4D0*Me/MW**2*Ml/SW**2*seth**2*slth
     &      **2-ceth/SW**2*clth*sb**2*seth*slth)
      AAABR(3845) = EE**2/MW**2*Me*Ml/SW**2/cb**2*(1D0-seth
     &      **2-slth**2+2D0*seth**2*slth**2)
      AAABR(3846) = EE**2/MW**2*Me*Ml/SW**2/cb**2*sb**2*(1D0
     &      -seth**2-slth**2+2D0*seth**2*slth**2)
      AAABR(3847) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-seth
     &      **2-slth**2+2D0*seth**2*slth**2)
      AAABR(3848) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-seth
     &      **2-slth**2+2D0*seth**2*slth**2)
      AAABR(3849) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(3850) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *slth**2-3D0*smuth**2+6D0*sb**2*slth**2+3D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3851) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *slth**2-3D0*smuth**2+6D0*sb**2*slth**2+3D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3852) = EE**2/cb**2*(1D0/CW**2-sb**2/CW**2-9D0
     &      *slth**2/CW**2+9D0*slth**4/CW**2-slth**2/SW**2
     &      +slth**4/SW**2+9D0*sb**2/CW**2*slth**2-9D0*sb
     &      **2/CW**2*slth**4-Ml**2/MW**2/SW**2+sb**2/SW
     &      **2*slth**2-sb**2/SW**2*slth**4+4D0*Ml**2/MW
     &      **2/SW**2*slth**2-4D0*Ml**2/MW**2/SW**2*slth**4)
      AAABR(3853) = EE**2/SW**2/cb**2*(slth**2-slth**4-sb
     &      **2*slth**2+sb**2*slth**4)
      AAABR(3854) = EE**2/CW**2/cb**2*(1D0-sb**2-9D0*slth
     &      **2+9D0*slth**4+9D0*sb**2*slth**2-9D0*sb**2*slth
     &      **4)
      AAABR(3855) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-9D0*slth
     &      **2+9D0*slth**4+9D0*sb**2*slth**2-9D0*sb**2*slth
     &      **4)
      AAABR(3856) = EE**2/MW**2*Ml**2/SW**2/cb**2*(1D0-4D0
     &      *slth**2+4D0*slth**4)
      AAABR(3857) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2*(1D0
     &      -4D0*slth**2+4D0*slth**4)
      AAABR(3858) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-4D0*slth
     &      **2+4D0*slth**4)
      AAABR(3859) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(3860) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-3D0*slth**2+6D0*sb**2*seth**2+3D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(3861) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-3D0*slth**2+6D0*sb**2*seth**2+3D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(3862) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(3863) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2-6D0*smuth**2+3D0*sb**2*seth**2+6D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3864) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2-6D0*smuth**2+3D0*sb**2*seth**2+6D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(3865) = EE**2/cb**2*(2D0*Me/MW**2*Mm/SW**2+9D0
     &      *ceth/CW**2*cmuth*seth*smuth-2D0*Me/MW**2*Mm
     &      /SW**2*seth**2-2D0*Me/MW**2*Mm/SW**2*smuth**2
     &      +ceth/SW**2*cmuth*seth*smuth-9D0*ceth/CW**2*cmuth
     &      *sb**2*seth*smuth+4D0*Me/MW**2*Mm/SW**2*seth
     &      **2*smuth**2-ceth/SW**2*cmuth*sb**2*seth*smuth)
      AAABR(3866) = EE**2/MW**2*Me*Mm/SW**2/cb**2*(1D0-seth
     &      **2-smuth**2+2D0*seth**2*smuth**2)
      AAABR(3867) = EE**2/MW**2*Me*Mm/SW**2/cb**2*sb**2*(1D0
     &      -seth**2-smuth**2+2D0*seth**2*smuth**2)
      AAABR(3868) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-seth
     &      **2-smuth**2+2D0*seth**2*smuth**2)
      AAABR(3869) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-seth
     &      **2-smuth**2+2D0*seth**2*smuth**2)
      AAABR(3870) = EE**2/cb**2*(1D0/CW**2-sb**2/CW**2-9D0
     &      *seth**2/CW**2+9D0*seth**4/CW**2-seth**2/SW**2
     &      +seth**4/SW**2+9D0*sb**2/CW**2*seth**2-9D0*sb
     &      **2/CW**2*seth**4-Me**2/MW**2/SW**2+sb**2/SW
     &      **2*seth**2-sb**2/SW**2*seth**4+4D0*Me**2/MW
     &      **2/SW**2*seth**2-4D0*Me**2/MW**2/SW**2*seth**4)
      AAABR(3871) = EE**2/SW**2/cb**2*(seth**2-seth**4-sb
     &      **2*seth**2+sb**2*seth**4)
      AAABR(3872) = EE**2/CW**2/cb**2*(1D0-sb**2-9D0*seth
     &      **2+9D0*seth**4+9D0*sb**2*seth**2-9D0*sb**2*seth
     &      **4)
      AAABR(3873) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-9D0*seth
     &      **2+9D0*seth**4+9D0*sb**2*seth**2-9D0*sb**2*seth
     &      **4)
      AAABR(3874) = EE**2/MW**2*Me**2/SW**2/cb**2*(1D0-4D0
     &      *seth**2+4D0*seth**4)
      AAABR(3875) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2*(1D0
     &      -4D0*seth**2+4D0*seth**4)
      AAABR(3876) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-4D0*seth
     &      **2+4D0*seth**4)
      AAABR(3877) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(3878) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2-6D0*smuth**2+3D0*sb**2*slth**2+6D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3879) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2-6D0*smuth**2+3D0*sb**2*slth**2+6D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(3880) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*slth**2/CW**2-6D0*smuth**2/CW**2+6D0*sb
     &      **2/CW**2*slth**2+6D0*sb**2/CW**2*smuth**2+9D0
     &      *slth**2/CW**2*smuth**2+slth**2/SW**2*smuth**2
     &      -9D0*sb**2/CW**2*slth**2*smuth**2-sb**2/SW**2
     &      *slth**2*smuth**2+4D0*Ml/MW**2*Mm/SW**2*clth
     &      *cmuth*slth*smuth)
      AAABR(3881) = EE**2/SW**2/cb**2*clth*slth*smuth**2
     &      *(1D0-sb**2)
      AAABR(3882) = EE**2/CW**2/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3883) = EE**2/CW**3*SW/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3884) = EE**2/SW**2/cb**2*ceth*seth*smuth**2
     &      *(1D0-sb**2)
      AAABR(3885) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-6D0*smuth**2/CW**2+6D0*sb
     &      **2/CW**2*seth**2+6D0*sb**2/CW**2*smuth**2+9D0
     &      *seth**2/CW**2*smuth**2+seth**2/SW**2*smuth**2
     &      -9D0*sb**2/CW**2*seth**2*smuth**2-sb**2/SW**2
     &      *seth**2*smuth**2+4D0*Me/MW**2*Mm/SW**2*ceth
     &      *cmuth*seth*smuth)
      AAABR(3886) = EE**2/CW**2/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3887) = EE**2/CW**3*SW/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(3888) = EE**2/SW**2/cb**2*ceth*seth**3*(1D0-sb
     &      **2)
      AAABR(3889) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -12D0*seth**2/CW**2+9D0*seth**4/CW**2+seth**4
     &      /SW**2+12D0*sb**2/CW**2*seth**2-9D0*sb**2/CW
     &      **2*seth**4-sb**2/SW**2*seth**4+4D0*Me**2/MW
     &      **2/SW**2*seth**2-4D0*Me**2/MW**2/SW**2*seth**4)
      AAABR(3890) = EE**2/CW**2/cb**2*ceth*(2D0*seth-3D0
     &      *seth**3-2D0*sb**2*seth+3D0*sb**2*seth**3)
      AAABR(3891) = EE**2/CW**3*SW/cb**2*ceth*(2D0*seth-3D0
     &      *seth**3-2D0*sb**2*seth+3D0*sb**2*seth**3)
      AAABR(3892) = EE**2/SW**2/cb**2*cmuth*smuth**3*(1D0
     &      -sb**2)
      AAABR(3893) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -12D0*smuth**2/CW**2+9D0*smuth**4/CW**2+smuth
     &      **4/SW**2+12D0*sb**2/CW**2*smuth**2-9D0*sb**2
     &      /CW**2*smuth**4-sb**2/SW**2*smuth**4+4D0*Mm**2
     &      /MW**2/SW**2*smuth**2-4D0*Mm**2/MW**2/SW**2*smuth
     &      **4)
      AAABR(3894) = EE**2/CW**2/cb**2*cmuth*(2D0*smuth-3D0
     &      *smuth**3-2D0*sb**2*smuth+3D0*sb**2*smuth**3)
      AAABR(3895) = EE**2/CW**3*SW/cb**2*cmuth*(2D0*smuth
     &      -3D0*smuth**3-2D0*sb**2*smuth+3D0*sb**2*smuth
     &      **3)
      AAABR(3896) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-6D0*slth**2/CW**2+6D0*sb**2
     &      /CW**2*seth**2+6D0*sb**2/CW**2*slth**2+9D0*seth
     &      **2/CW**2*slth**2+seth**2/SW**2*slth**2-9D0*sb
     &      **2/CW**2*seth**2*slth**2-sb**2/SW**2*seth**2
     &      *slth**2+4D0*Me/MW**2*Ml/SW**2*ceth*clth*seth
     &      *slth)
      AAABR(3897) = EE**2/SW**2/cb**2*clth*seth**2*slth*(1D0
     &      -sb**2)
      AAABR(3898) = EE**2/CW**2/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3899) = EE**2/CW**3*SW/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3900) = EE**2/SW**2/cb**2*ceth*seth*slth**2*(1D0
     &      -sb**2)
      AAABR(3901) = EE**2/CW**2/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3902) = EE**2/CW**3*SW/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3903) = EE**2/SW**2/cb**2*cmuth*seth**2*smuth
     &      *(1D0-sb**2)
      AAABR(3904) = EE**2/CW**2/cb**2*cmuth*smuth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3905) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(2D0
     &      -2D0*sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(3906) = EE**2/SW**2/cb**2*cmuth*slth**2*smuth
     &      *(1D0-sb**2)
      AAABR(3907) = EE**2/CW**2/cb**2*cmuth*smuth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3908) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(2D0
     &      -2D0*sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(3909) = EE**2/SW**2/cb**2*clth*slth**3*(1D0-sb
     &      **2)
      AAABR(3910) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -12D0*slth**2/CW**2+9D0*slth**4/CW**2+slth**4
     &      /SW**2+12D0*sb**2/CW**2*slth**2-9D0*sb**2/CW
     &      **2*slth**4-sb**2/SW**2*slth**4+4D0*Ml**2/MW
     &      **2/SW**2*slth**2-4D0*Ml**2/MW**2/SW**2*slth**4)
      AAABR(3911) = EE**2/CW**2/cb**2*clth*(2D0*slth-3D0
     &      *slth**3-2D0*sb**2*slth+3D0*sb**2*slth**3)
      AAABR(3912) = EE**2/CW**3*SW/cb**2*clth*(2D0*slth-3D0
     &      *slth**3-2D0*sb**2*slth+3D0*sb**2*slth**3)
      AAABR(3913) = EE**2/SW**2/cb**2*(clth*cmuth-clth*cmuth
     &      *sb**2+Ml/MW**2*Mm*slth*smuth)
      AAABR(3914) = EE**2/SW**2/cb**2*(cmuth*slth-cmuth*sb
     &      **2*slth-Ml/MW**2*Mm*clth*smuth)
      AAABR(3915) = EE**2/SW**2/cb**2*clth*cmuth*(1D0-sb**2)
      AAABR(3916) = EE**2/SW**2/cb**2*(clth*smuth-clth*sb
     &      **2*smuth-Ml/MW**2*Mm*cmuth*slth)
      AAABR(3917) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*slth*smuth
      AAABR(3918) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*sb**2*slth
     &      *smuth
      AAABR(3919) = EE**2/MW**2*Ml/SW**2/cb**2*slth*smuth
      AAABR(3920) = EE**2/MW**2*Mm/SW**2/cb**2*slth*smuth
      AAABR(3921) = EE**2*(1D0/CW**2-1D0/SW**2-3D0*seth**2
     &      /CW**2+seth**2/SW**2)
      AAABR(3922) = EE**2/SW**2*(1D0-seth**2)
      AAABR(3923) = EE**2*ceth*seth*(3D0/CW**2-1D0/SW**2)
      AAABR(3924) = EE**2/CW**2*(1D0-3D0*seth**2)
      end

      subroutine aaini06
      implicit none
#include "model.h"

      AAABR(3925) = EE**2/CW**3*SW*(1D0-3D0*seth**2)
      AAABR(3926) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*seth**2/CW**2-sb**2/SW**2-seth**2
     &      /SW**2+3D0*sb**2/CW**2*seth**2+sb**2/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(3927) = EE**2/SW**2/cb**2*(1D0-sb**2-seth**2
     &      +sb**2*seth**2)
      AAABR(3928) = EE**2/cb**2*ceth*seth*(3D0/CW**2+1D0
     &      /SW**2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Me**2
     &      /MW**2/SW**2)
      AAABR(3929) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*seth
     &      **2+3D0*sb**2*seth**2)
      AAABR(3930) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*seth
     &      **2+3D0*sb**2*seth**2)
      AAABR(3931) = EE**2/MW**2*Me**2/SW**2/cb**2*seth**2
      AAABR(3932) = EE**2/MW**2*Me/SW**2/cb**2*seth**2
      AAABR(3933) = EE**2*(1D0/CW**2-1D0/SW**2-3D0*smuth
     &      **2/CW**2+smuth**2/SW**2)
      AAABR(3934) = EE**2/SW**2*(1D0-smuth**2)
      AAABR(3935) = EE**2*cmuth*smuth*(3D0/CW**2-1D0/SW**2)
      AAABR(3936) = EE**2/CW**2*(1D0-3D0*smuth**2)
      AAABR(3937) = EE**2/CW**3*SW*(1D0-3D0*smuth**2)
      AAABR(3938) = EE**2/SW**2/cb**2*(ceth*cmuth-ceth*cmuth
     &      *sb**2+Me/MW**2*Mm*seth*smuth)
      AAABR(3939) = EE**2/SW**2/cb**2*(ceth*smuth-ceth*sb
     &      **2*smuth-Me/MW**2*Mm*cmuth*seth)
      AAABR(3940) = EE**2/SW**2/cb**2*ceth*cmuth*(1D0-sb**2)
      AAABR(3941) = EE**2/SW**2/cb**2*(cmuth*seth-cmuth*sb
     &      **2*seth-Me/MW**2*Mm*ceth*smuth)
      AAABR(3942) = EE**2/MW**2*Me*Mm/SW**2/cb**2*seth*smuth
      AAABR(3943) = EE**2/MW**2*Me*Mm/SW**2/cb**2*sb**2*seth
     &      *smuth
      AAABR(3944) = EE**2/MW**2*Mm/SW**2/cb**2*seth*smuth
      AAABR(3945) = EE**2/MW**2*Me/SW**2/cb**2*seth*smuth
      AAABR(3946) = EE**2*(1D0/CW**2-1D0/SW**2-3D0*slth**2
     &      /CW**2+slth**2/SW**2)
      AAABR(3947) = EE**2*clth*slth*(3D0/CW**2-1D0/SW**2)
      AAABR(3948) = EE**2/SW**2*(1D0-slth**2)
      AAABR(3949) = EE**2/CW**2*(1D0-3D0*slth**2)
      AAABR(3950) = EE**2/CW**3*SW*(1D0-3D0*slth**2)
      AAABR(3951) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*smuth**2/CW**2-sb**2/SW**2-smuth**2
     &      /SW**2+3D0*sb**2/CW**2*smuth**2+sb**2/SW**2*smuth
     &      **2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(3952) = EE**2/SW**2/cb**2*(1D0-sb**2-smuth**2
     &      +sb**2*smuth**2)
      AAABR(3953) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2+1D0
     &      /SW**2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Mm**2
     &      /MW**2/SW**2)
      AAABR(3954) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*smuth
     &      **2+3D0*sb**2*smuth**2)
      AAABR(3955) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*smuth
     &      **2+3D0*sb**2*smuth**2)
      AAABR(3956) = EE**2/MW**2*Mm**2/SW**2/cb**2*smuth**2
      AAABR(3957) = EE**2/MW**2*Mm/SW**2/cb**2*smuth**2
      AAABR(3958) = EE**2/SW**2/cb**2*(ceth*clth-ceth*clth
     &      *sb**2+Me/MW**2*Ml*seth*slth)
      AAABR(3959) = EE**2/SW**2/cb**2*(ceth*slth-ceth*sb
     &      **2*slth-Me/MW**2*Ml*clth*seth)
      AAABR(3960) = EE**2/SW**2/cb**2*ceth*clth*(1D0-sb**2)
      AAABR(3961) = EE**2/SW**2/cb**2*(clth*seth-clth*sb
     &      **2*seth-Me/MW**2*Ml*ceth*slth)
      AAABR(3962) = EE**2/MW**2*Me*Ml/SW**2/cb**2*seth*slth
      AAABR(3963) = EE**2/MW**2*Me*Ml/SW**2/cb**2*sb**2*seth
     &      *slth
      AAABR(3964) = EE**2/MW**2*Me/SW**2/cb**2*seth*slth
      AAABR(3965) = EE**2/MW**2*Ml/SW**2/cb**2*seth*slth
      AAABR(3966) = EE**2/cb**2*(1D0/CW**2+1D0/SW**2-sb**2
     &      /CW**2-3D0*slth**2/CW**2-sb**2/SW**2-slth**2
     &      /SW**2+3D0*sb**2/CW**2*slth**2+sb**2/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(3967) = EE**2/SW**2/cb**2*(1D0-sb**2-slth**2
     &      +sb**2*slth**2)
      AAABR(3968) = EE**2/cb**2*clth*slth*(3D0/CW**2+1D0
     &      /SW**2-3D0*sb**2/CW**2-sb**2/SW**2-2D0*Ml**2
     &      /MW**2/SW**2)
      AAABR(3969) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*slth
     &      **2+3D0*sb**2*slth**2)
      AAABR(3970) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*slth
     &      **2+3D0*sb**2*slth**2)
      AAABR(3971) = EE**2/MW**2*Ml**2/SW**2/cb**2*slth**2
      AAABR(3972) = EE**2/MW**2*Ml/SW**2/cb**2*slth**2
      AAABR(3973) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*smuth**2/CW**2-smuth**2/SW**2+3D0*sb**2
     &      /CW**2*smuth**2-2D0*Mm**2/MW**2/SW**2+sb**2/SW
     &      **2*smuth**2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(3974) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2)
      AAABR(3975) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2)
      AAABR(3976) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2)
      AAABR(3977) = EE**2/MW**2*Mm**2/SW**2/cb**2*cmuth*smuth
     &      
      AAABR(3978) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
      AAABR(3979) = EE**2*(2D0/CW**2-3D0*slth**2/CW**2+slth
     &      **2/SW**2)
      AAABR(3980) = EE**2/SW**2*clth*slth
      AAABR(3981) = EE**2/CW**2*clth*slth
      AAABR(3982) = EE**2/CW**3*SW*clth*slth
      AAABR(3983) = EE**2/SW**2/cb**2*cmuth*slth*(1D0-sb**2)
      AAABR(3984) = EE**2/SW**2/cb**2*(slth*smuth-sb**2*slth
     &      *smuth+Ml/MW**2*Mm*clth*cmuth)
      AAABR(3985) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*smuth
      AAABR(3986) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*sb
     &      **2*smuth
      AAABR(3987) = EE**2/MW**2*Mm/SW**2/cb**2*clth*smuth
      AAABR(3988) = EE**2/MW**2*Ml/SW**2/cb**2*clth*smuth
      AAABR(3989) = EE**2/SW**2/cb**2*(seth*smuth-sb**2*seth
     &      *smuth+Me/MW**2*Mm*ceth*cmuth)
      AAABR(3990) = EE**2/SW**2/cb**2*cmuth*seth*(1D0-sb**2)
      AAABR(3991) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*smuth
      AAABR(3992) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*sb
     &      **2*smuth
      AAABR(3993) = EE**2/MW**2*Mm/SW**2/cb**2*ceth*smuth
      AAABR(3994) = EE**2/MW**2*Me/SW**2/cb**2*ceth*smuth
      AAABR(3995) = EE**2/SW**2/cb**2*ceth*slth*(1D0-sb**2)
      AAABR(3996) = EE**2/SW**2/cb**2*(seth*slth-sb**2*seth
     &      *slth+Me/MW**2*Ml*ceth*clth)
      AAABR(3997) = EE**2/MW**2*Me*Ml/SW**2/cb**2*clth*seth
      AAABR(3998) = EE**2/MW**2*Me*Ml/SW**2/cb**2*clth*sb
     &      **2*seth
      AAABR(3999) = EE**2/MW**2*Me/SW**2/cb**2*clth*seth
      AAABR(4000) = EE**2/MW**2*Ml/SW**2/cb**2*clth*seth
      AAABR(4001) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*slth**2/CW**2-slth**2/SW**2+3D0*sb**2/CW
     &      **2*slth**2-2D0*Ml**2/MW**2/SW**2+sb**2/SW**2
     &      *slth**2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(4002) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2)
      AAABR(4003) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2)
      AAABR(4004) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2)
      AAABR(4005) = EE**2/MW**2*Ml**2/SW**2/cb**2*clth*slth
      AAABR(4006) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
      AAABR(4007) = EE**2/SW**2*ceth*seth
      AAABR(4008) = EE**2*(2D0/CW**2-3D0*seth**2/CW**2+seth
     &      **2/SW**2)
      AAABR(4009) = EE**2/CW**2*ceth*seth
      AAABR(4010) = EE**2/CW**3*SW*ceth*seth
      AAABR(4011) = EE**2*(2D0/CW**2-3D0*smuth**2/CW**2+smuth
     &      **2/SW**2)
      AAABR(4012) = EE**2/SW**2*cmuth*smuth
      AAABR(4013) = EE**2/CW**2*cmuth*smuth
      AAABR(4014) = EE**2/CW**3*SW*cmuth*smuth
      AAABR(4015) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*seth**2/CW**2-seth**2/SW**2+3D0*sb**2/CW
     &      **2*seth**2-2D0*Me**2/MW**2/SW**2+sb**2/SW**2
     &      *seth**2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(4016) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2)
      AAABR(4017) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2)
      AAABR(4018) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2)
      AAABR(4019) = EE**2/MW**2*Me**2/SW**2/cb**2*ceth*seth
      AAABR(4020) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
      AAABR(4021) = EE**2/SW**2/cb**2*ceth*smuth*(1D0-sb**2)
      AAABR(4022) = EE**2/MW**2*Me*Mm/SW**2/cb**2*cmuth*seth
      AAABR(4023) = EE**2/MW**2*Me*Mm/SW**2/cb**2*cmuth*sb
     &      **2*seth
      AAABR(4024) = EE**2/MW**2*Me/SW**2/cb**2*cmuth*seth
      AAABR(4025) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*seth
      AAABR(4026) = EE**2/SW**2/cb**2*clth*seth*(1D0-sb**2)
      AAABR(4027) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*slth
      AAABR(4028) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*sb
     &      **2*slth
      AAABR(4029) = EE**2/MW**2*Ml/SW**2/cb**2*ceth*slth
      AAABR(4030) = EE**2/MW**2*Me/SW**2/cb**2*ceth*slth
      AAABR(4031) = EE**2/SW**2/cb**2*clth*smuth*(1D0-sb**2)
      AAABR(4032) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*cmuth*slth
      AAABR(4033) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*cmuth*sb
     &      **2*slth
      AAABR(4034) = EE**2/MW**2*Ml/SW**2/cb**2*cmuth*slth
      AAABR(4035) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*slth
      AAABR(4036) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2-3D0*slth**2/CW**2+ssth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*slth**2/SW**2+3D0*ssth**2/SW**2
     &      +3D0*sb**2/CW**2*slth**2-sb**2/CW**2*ssth**2
     &      -3D0*slth**2/CW**2*ssth**2-3D0*sb**2/SW**2*slth
     &      **2-3D0*sb**2/SW**2*ssth**2-3D0*slth**2/SW**2
     &      *ssth**2+3D0*sb**2/CW**2*slth**2*ssth**2+3D0
     &      *sb**2/SW**2*slth**2*ssth**2-12D0*Ml/MW**2*Ms
     &      /SW**2*clth*csth*slth*ssth)
      AAABR(4037) = EE**2/cb**2*(clth/CW**2*slth-clth/SW
     &      **2*slth-clth/CW**2*sb**2*slth+clth/CW**2*slth
     &      *ssth**2+clth/SW**2*sb**2*slth+clth/SW**2*slth
     &      *ssth**2-clth/CW**2*sb**2*slth*ssth**2-clth/SW
     &      **2*sb**2*slth*ssth**2+2D0*Ml/MW**2*Ms/SW**2
     &      *csth*ssth-4D0*Ml/MW**2*Ms/SW**2*csth*slth**2
     &      *ssth)
      AAABR(4038) = EE**2/SW**2/cb**2*(1D0-sb**2-slth**2
     &      -ssth**2+sb**2*slth**2+sb**2*ssth**2+slth**2
     &      *ssth**2-sb**2*slth**2*ssth**2)
      AAABR(4039) = EE**2/cb**2*(csth/CW**2*ssth+3D0*csth
     &      /SW**2*ssth-csth/CW**2*sb**2*ssth-3D0*csth/CW
     &      **2*slth**2*ssth-3D0*csth/SW**2*sb**2*ssth-3D0
     &      *csth/SW**2*slth**2*ssth+3D0*csth/CW**2*sb**2
     &      *slth**2*ssth+3D0*csth/SW**2*sb**2*slth**2*ssth
     &      -6D0*Ml/MW**2*Ms/SW**2*clth*slth+12D0*Ml/MW**2
     &      *Ms/SW**2*clth*slth*ssth**2)
      AAABR(4040) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*slth
     &      **2+ssth**2+3D0*sb**2*slth**2-sb**2*ssth**2-3D0
     &      *slth**2*ssth**2+3D0*sb**2*slth**2*ssth**2)
      AAABR(4041) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*slth
     &      **2+ssth**2+3D0*sb**2*slth**2-sb**2*ssth**2-3D0
     &      *slth**2*ssth**2+3D0*sb**2*slth**2*ssth**2)
      AAABR(4042) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*csth
     &      *slth*ssth
      AAABR(4043) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*csth
     &      *sb**2*slth*ssth
      AAABR(4044) = EE**2/MW**2*Ml/SW**2/cb**2*clth*csth
     &      *slth*ssth
      AAABR(4045) = EE**2/MW**2*Ms/SW**2/cb**2*clth*csth
     &      *slth*ssth
      AAABR(4046) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2-3D0*smuth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sbth**2/SW**2+3D0*smuth**2/SW**2
     &      -sb**2/CW**2*sbth**2+3D0*sb**2/CW**2*smuth**2
     &      -3D0*sbth**2/CW**2*smuth**2-3D0*sb**2/SW**2*sbth
     &      **2-3D0*sb**2/SW**2*smuth**2-3D0*sbth**2/SW**2
     &      *smuth**2+3D0*sb**2/CW**2*sbth**2*smuth**2+3D0
     &      *sb**2/SW**2*sbth**2*smuth**2-12D0*Mb/MW**2*Mm
     &      /SW**2*cbth*cmuth*sbth*smuth)
      AAABR(4047) = EE**2/cb**2*(cmuth/CW**2*smuth-cmuth
     &      /SW**2*smuth-cmuth/CW**2*sb**2*smuth+cmuth/CW
     &      **2*sbth**2*smuth+cmuth/SW**2*sb**2*smuth+cmuth
     &      /SW**2*sbth**2*smuth-cmuth/CW**2*sb**2*sbth**2
     &      *smuth-cmuth/SW**2*sb**2*sbth**2*smuth+2D0*Mb
     &      /MW**2*Mm/SW**2*cbth*sbth-4D0*Mb/MW**2*Mm/SW
     &      **2*cbth*sbth*smuth**2)
      AAABR(4048) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -smuth**2+sb**2*sbth**2+sb**2*smuth**2+sbth**2
     &      *smuth**2-sb**2*sbth**2*smuth**2)
      AAABR(4049) = EE**2/cb**2*(cbth/CW**2*sbth+3D0*cbth
     &      /SW**2*sbth-cbth/CW**2*sb**2*sbth-3D0*cbth/CW
     &      **2*sbth*smuth**2-3D0*cbth/SW**2*sb**2*sbth-3D0
     &      *cbth/SW**2*sbth*smuth**2+3D0*cbth/CW**2*sb**2
     &      *sbth*smuth**2+3D0*cbth/SW**2*sb**2*sbth*smuth
     &      **2-6D0*Mb/MW**2*Mm/SW**2*cmuth*smuth+12D0*Mb
     &      /MW**2*Mm/SW**2*cmuth*sbth**2*smuth)
      AAABR(4050) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      -3D0*smuth**2-sb**2*sbth**2+3D0*sb**2*smuth**2
     &      -3D0*sbth**2*smuth**2+3D0*sb**2*sbth**2*smuth
     &      **2)
      AAABR(4051) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2-3D0*smuth**2-sb**2*sbth**2+3D0*sb**2*smuth
     &      **2-3D0*sbth**2*smuth**2+3D0*sb**2*sbth**2*smuth
     &      **2)
      AAABR(4052) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *sbth*smuth
      AAABR(4053) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *sb**2*sbth*smuth
      AAABR(4054) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*cmuth
     &      *sbth*smuth
      AAABR(4055) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*cmuth
     &      *sbth*smuth
      AAABR(4056) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sdth**2/CW**2-3D0*smuth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sdth**2/SW**2+3D0*smuth**2/SW**2
     &      -sb**2/CW**2*sdth**2+3D0*sb**2/CW**2*smuth**2
     &      -3D0*sdth**2/CW**2*smuth**2-3D0*sb**2/SW**2*sdth
     &      **2-3D0*sb**2/SW**2*smuth**2-3D0*sdth**2/SW**2
     &      *smuth**2+3D0*sb**2/CW**2*sdth**2*smuth**2+3D0
     &      *sb**2/SW**2*sdth**2*smuth**2-12D0*Md/MW**2*Mm
     &      /SW**2*cdth*cmuth*sdth*smuth)
      AAABR(4057) = EE**2/cb**2*(cmuth/CW**2*smuth-cmuth
     &      /SW**2*smuth-cmuth/CW**2*sb**2*smuth+cmuth/CW
     &      **2*sdth**2*smuth+cmuth/SW**2*sb**2*smuth+cmuth
     &      /SW**2*sdth**2*smuth-cmuth/CW**2*sb**2*sdth**2
     &      *smuth-cmuth/SW**2*sb**2*sdth**2*smuth+2D0*Md
     &      /MW**2*Mm/SW**2*cdth*sdth-4D0*Md/MW**2*Mm/SW
     &      **2*cdth*sdth*smuth**2)
      AAABR(4058) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -smuth**2+sb**2*sdth**2+sb**2*smuth**2+sdth**2
     &      *smuth**2-sb**2*sdth**2*smuth**2)
      AAABR(4059) = EE**2/cb**2*(cdth/CW**2*sdth+3D0*cdth
     &      /SW**2*sdth-cdth/CW**2*sb**2*sdth-3D0*cdth/CW
     &      **2*sdth*smuth**2-3D0*cdth/SW**2*sb**2*sdth-3D0
     &      *cdth/SW**2*sdth*smuth**2+3D0*cdth/CW**2*sb**2
     &      *sdth*smuth**2+3D0*cdth/SW**2*sb**2*sdth*smuth
     &      **2-6D0*Md/MW**2*Mm/SW**2*cmuth*smuth+12D0*Md
     &      /MW**2*Mm/SW**2*cmuth*sdth**2*smuth)
      AAABR(4060) = EE**2/CW**2/cb**2*(1D0-sb**2+sdth**2
     &      -3D0*smuth**2-sb**2*sdth**2+3D0*sb**2*smuth**2
     &      -3D0*sdth**2*smuth**2+3D0*sb**2*sdth**2*smuth
     &      **2)
      AAABR(4061) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sdth
     &      **2-3D0*smuth**2-sb**2*sdth**2+3D0*sb**2*smuth
     &      **2-3D0*sdth**2*smuth**2+3D0*sb**2*sdth**2*smuth
     &      **2)
      AAABR(4062) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *sdth*smuth
      AAABR(4063) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *sb**2*sdth*smuth
      AAABR(4064) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*cmuth
     &      *sdth*smuth
      AAABR(4065) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cmuth
     &      *sdth*smuth
      AAABR(4066) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sdth**2/CW**2-3D0*seth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sdth**2/SW**2+3D0*seth**2/SW**2
     &      -sb**2/CW**2*sdth**2+3D0*sb**2/CW**2*seth**2
     &      -3D0*sdth**2/CW**2*seth**2-3D0*sb**2/SW**2*sdth
     &      **2-3D0*sb**2/SW**2*seth**2-3D0*sdth**2/SW**2
     &      *seth**2+3D0*sb**2/CW**2*sdth**2*seth**2+3D0
     &      *sb**2/SW**2*sdth**2*seth**2-12D0*Md/MW**2*Me
     &      /SW**2*cdth*ceth*sdth*seth)
      AAABR(4067) = EE**2/cb**2*(ceth/CW**2*seth-ceth/SW
     &      **2*seth-ceth/CW**2*sb**2*seth+ceth/CW**2*sdth
     &      **2*seth+ceth/SW**2*sb**2*seth+ceth/SW**2*sdth
     &      **2*seth-ceth/CW**2*sb**2*sdth**2*seth-ceth/SW
     &      **2*sb**2*sdth**2*seth+2D0*Md/MW**2*Me/SW**2
     &      *cdth*sdth-4D0*Md/MW**2*Me/SW**2*cdth*sdth*seth
     &      **2)
      AAABR(4068) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -seth**2+sb**2*sdth**2+sb**2*seth**2+sdth**2
     &      *seth**2-sb**2*sdth**2*seth**2)
      AAABR(4069) = EE**2/cb**2*(cdth/CW**2*sdth+3D0*cdth
     &      /SW**2*sdth-cdth/CW**2*sb**2*sdth-3D0*cdth/CW
     &      **2*sdth*seth**2-3D0*cdth/SW**2*sb**2*sdth-3D0
     &      *cdth/SW**2*sdth*seth**2+3D0*cdth/CW**2*sb**2
     &      *sdth*seth**2+3D0*cdth/SW**2*sb**2*sdth*seth
     &      **2-6D0*Md/MW**2*Me/SW**2*ceth*seth+12D0*Md/MW
     &      **2*Me/SW**2*ceth*sdth**2*seth)
      AAABR(4070) = EE**2/CW**2/cb**2*(1D0-sb**2+sdth**2
     &      -3D0*seth**2-sb**2*sdth**2+3D0*sb**2*seth**2
     &      -3D0*sdth**2*seth**2+3D0*sb**2*sdth**2*seth**2)
      AAABR(4071) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sdth
     &      **2-3D0*seth**2-sb**2*sdth**2+3D0*sb**2*seth
     &      **2-3D0*sdth**2*seth**2+3D0*sb**2*sdth**2*seth
     &      **2)
      AAABR(4072) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *sdth*seth
      AAABR(4073) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *sb**2*sdth*seth
      AAABR(4074) = EE**2/MW**2*Me/SW**2/cb**2*cdth*ceth
     &      *sdth*seth
      AAABR(4075) = EE**2/MW**2*Md/SW**2/cb**2*cdth*ceth
     &      *sdth*seth
      AAABR(4076) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2-3D0*seth**2/CW**2+ssth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*seth**2/SW**2+3D0*ssth**2/SW**2
     &      +3D0*sb**2/CW**2*seth**2-sb**2/CW**2*ssth**2
     &      -3D0*seth**2/CW**2*ssth**2-3D0*sb**2/SW**2*seth
     &      **2-3D0*sb**2/SW**2*ssth**2-3D0*seth**2/SW**2
     &      *ssth**2+3D0*sb**2/CW**2*seth**2*ssth**2+3D0
     &      *sb**2/SW**2*seth**2*ssth**2-12D0*Me/MW**2*Ms
     &      /SW**2*ceth*csth*seth*ssth)
      AAABR(4077) = EE**2/cb**2*(ceth/CW**2*seth-ceth/SW
     &      **2*seth-ceth/CW**2*sb**2*seth+ceth/CW**2*seth
     &      *ssth**2+ceth/SW**2*sb**2*seth+ceth/SW**2*seth
     &      *ssth**2-ceth/CW**2*sb**2*seth*ssth**2-ceth/SW
     &      **2*sb**2*seth*ssth**2+2D0*Me/MW**2*Ms/SW**2
     &      *csth*ssth-4D0*Me/MW**2*Ms/SW**2*csth*seth**2
     &      *ssth)
      AAABR(4078) = EE**2/SW**2/cb**2*(1D0-sb**2-seth**2
     &      -ssth**2+sb**2*seth**2+sb**2*ssth**2+seth**2
     &      *ssth**2-sb**2*seth**2*ssth**2)
      AAABR(4079) = EE**2/cb**2*(csth/CW**2*ssth+3D0*csth
     &      /SW**2*ssth-csth/CW**2*sb**2*ssth-3D0*csth/CW
     &      **2*seth**2*ssth-3D0*csth/SW**2*sb**2*ssth-3D0
     &      *csth/SW**2*seth**2*ssth+3D0*csth/CW**2*sb**2
     &      *seth**2*ssth+3D0*csth/SW**2*sb**2*seth**2*ssth
     &      -6D0*Me/MW**2*Ms/SW**2*ceth*seth+12D0*Me/MW**2
     &      *Ms/SW**2*ceth*seth*ssth**2)
      AAABR(4080) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*seth
     &      **2+ssth**2+3D0*sb**2*seth**2-sb**2*ssth**2-3D0
     &      *seth**2*ssth**2+3D0*sb**2*seth**2*ssth**2)
      AAABR(4081) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*seth
     &      **2+ssth**2+3D0*sb**2*seth**2-sb**2*ssth**2-3D0
     &      *seth**2*ssth**2+3D0*sb**2*seth**2*ssth**2)
      AAABR(4082) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*csth
     &      *seth*ssth
      AAABR(4083) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*csth
     &      *sb**2*seth*ssth
      AAABR(4084) = EE**2/MW**2*Me/SW**2/cb**2*ceth*csth
     &      *seth*ssth
      AAABR(4085) = EE**2/MW**2*Ms/SW**2/cb**2*ceth*csth
     &      *seth*ssth
      AAABR(4086) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2-3D0*smuth**2/CW**2+ssth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*smuth**2/SW**2+3D0*ssth**2/SW**2
     &      +3D0*sb**2/CW**2*smuth**2-sb**2/CW**2*ssth**2
     &      -3D0*smuth**2/CW**2*ssth**2-3D0*sb**2/SW**2*smuth
     &      **2-3D0*sb**2/SW**2*ssth**2-3D0*smuth**2/SW**2
     &      *ssth**2+3D0*sb**2/CW**2*smuth**2*ssth**2+3D0
     &      *sb**2/SW**2*smuth**2*ssth**2-12D0*Mm/MW**2*Ms
     &      /SW**2*cmuth*csth*smuth*ssth)
      AAABR(4087) = EE**2/cb**2*(cmuth/CW**2*smuth-cmuth
     &      /SW**2*smuth-cmuth/CW**2*sb**2*smuth+cmuth/CW
     &      **2*smuth*ssth**2+cmuth/SW**2*sb**2*smuth+cmuth
     &      /SW**2*smuth*ssth**2-cmuth/CW**2*sb**2*smuth
     &      *ssth**2-cmuth/SW**2*sb**2*smuth*ssth**2+2D0
     &      *Mm/MW**2*Ms/SW**2*csth*ssth-4D0*Mm/MW**2*Ms
     &      /SW**2*csth*smuth**2*ssth)
      AAABR(4088) = EE**2/SW**2/cb**2*(1D0-sb**2-smuth**2
     &      -ssth**2+sb**2*smuth**2+sb**2*ssth**2+smuth**2
     &      *ssth**2-sb**2*smuth**2*ssth**2)
      AAABR(4089) = EE**2/cb**2*(csth/CW**2*ssth+3D0*csth
     &      /SW**2*ssth-csth/CW**2*sb**2*ssth-3D0*csth/CW
     &      **2*smuth**2*ssth-3D0*csth/SW**2*sb**2*ssth-3D0
     &      *csth/SW**2*smuth**2*ssth+3D0*csth/CW**2*sb**2
     &      *smuth**2*ssth+3D0*csth/SW**2*sb**2*smuth**2
     &      *ssth-6D0*Mm/MW**2*Ms/SW**2*cmuth*smuth+12D0
     &      *Mm/MW**2*Ms/SW**2*cmuth*smuth*ssth**2)
      AAABR(4090) = EE**2/CW**2/cb**2*(1D0-sb**2-3D0*smuth
     &      **2+ssth**2+3D0*sb**2*smuth**2-sb**2*ssth**2
     &      -3D0*smuth**2*ssth**2+3D0*sb**2*smuth**2*ssth
     &      **2)
      AAABR(4091) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-3D0*smuth
     &      **2+ssth**2+3D0*sb**2*smuth**2-sb**2*ssth**2
     &      -3D0*smuth**2*ssth**2+3D0*sb**2*smuth**2*ssth
     &      **2)
      AAABR(4092) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*csth
     &      *smuth*ssth
      AAABR(4093) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*csth
     &      *sb**2*smuth*ssth
      AAABR(4094) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*csth
     &      *smuth*ssth
      AAABR(4095) = EE**2/MW**2*Ms/SW**2/cb**2*cmuth*csth
     &      *smuth*ssth
      AAABR(4096) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2-3D0*seth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sbth**2/SW**2+3D0*seth**2/SW**2
     &      -sb**2/CW**2*sbth**2+3D0*sb**2/CW**2*seth**2
     &      -3D0*sbth**2/CW**2*seth**2-3D0*sb**2/SW**2*sbth
     &      **2-3D0*sb**2/SW**2*seth**2-3D0*sbth**2/SW**2
     &      *seth**2+3D0*sb**2/CW**2*sbth**2*seth**2+3D0
     &      *sb**2/SW**2*sbth**2*seth**2-12D0*Mb/MW**2*Me
     &      /SW**2*cbth*ceth*sbth*seth)
      AAABR(4097) = EE**2/cb**2*(ceth/CW**2*seth-ceth/SW
     &      **2*seth-ceth/CW**2*sb**2*seth+ceth/CW**2*sbth
     &      **2*seth+ceth/SW**2*sb**2*seth+ceth/SW**2*sbth
     &      **2*seth-ceth/CW**2*sb**2*sbth**2*seth-ceth/SW
     &      **2*sb**2*sbth**2*seth+2D0*Mb/MW**2*Me/SW**2
     &      *cbth*sbth-4D0*Mb/MW**2*Me/SW**2*cbth*sbth*seth
     &      **2)
      AAABR(4098) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -seth**2+sb**2*sbth**2+sb**2*seth**2+sbth**2
     &      *seth**2-sb**2*sbth**2*seth**2)
      AAABR(4099) = EE**2/cb**2*(cbth/CW**2*sbth+3D0*cbth
     &      /SW**2*sbth-cbth/CW**2*sb**2*sbth-3D0*cbth/CW
     &      **2*sbth*seth**2-3D0*cbth/SW**2*sb**2*sbth-3D0
     &      *cbth/SW**2*sbth*seth**2+3D0*cbth/CW**2*sb**2
     &      *sbth*seth**2+3D0*cbth/SW**2*sb**2*sbth*seth
     &      **2-6D0*Mb/MW**2*Me/SW**2*ceth*seth+12D0*Mb/MW
     &      **2*Me/SW**2*ceth*sbth**2*seth)
      AAABR(4100) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      -3D0*seth**2-sb**2*sbth**2+3D0*sb**2*seth**2
     &      -3D0*sbth**2*seth**2+3D0*sb**2*sbth**2*seth**2)
      AAABR(4101) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2-3D0*seth**2-sb**2*sbth**2+3D0*sb**2*seth
     &      **2-3D0*sbth**2*seth**2+3D0*sb**2*sbth**2*seth
     &      **2)
      AAABR(4102) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *sbth*seth
      AAABR(4103) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *sb**2*sbth*seth
      AAABR(4104) = EE**2/MW**2*Me/SW**2/cb**2*cbth*ceth
     &      *sbth*seth
      AAABR(4105) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ceth
     &      *sbth*seth
      AAABR(4106) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2-3D0*slth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sbth**2/SW**2+3D0*slth**2/SW**2
     &      -sb**2/CW**2*sbth**2+3D0*sb**2/CW**2*slth**2
     &      -3D0*sbth**2/CW**2*slth**2-3D0*sb**2/SW**2*sbth
     &      **2-3D0*sb**2/SW**2*slth**2-3D0*sbth**2/SW**2
     &      *slth**2+3D0*sb**2/CW**2*sbth**2*slth**2+3D0
     &      *sb**2/SW**2*sbth**2*slth**2-12D0*Mb/MW**2*Ml
     &      /SW**2*cbth*clth*sbth*slth)
      AAABR(4107) = EE**2/cb**2*(clth/CW**2*slth-clth/SW
     &      **2*slth-clth/CW**2*sb**2*slth+clth/CW**2*sbth
     &      **2*slth+clth/SW**2*sb**2*slth+clth/SW**2*sbth
     &      **2*slth-clth/CW**2*sb**2*sbth**2*slth-clth/SW
     &      **2*sb**2*sbth**2*slth+2D0*Mb/MW**2*Ml/SW**2
     &      *cbth*sbth-4D0*Mb/MW**2*Ml/SW**2*cbth*sbth*slth
     &      **2)
      AAABR(4108) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -slth**2+sb**2*sbth**2+sb**2*slth**2+sbth**2
     &      *slth**2-sb**2*sbth**2*slth**2)
      AAABR(4109) = EE**2/cb**2*(cbth/CW**2*sbth+3D0*cbth
     &      /SW**2*sbth-cbth/CW**2*sb**2*sbth-3D0*cbth/CW
     &      **2*sbth*slth**2-3D0*cbth/SW**2*sb**2*sbth-3D0
     &      *cbth/SW**2*sbth*slth**2+3D0*cbth/CW**2*sb**2
     &      *sbth*slth**2+3D0*cbth/SW**2*sb**2*sbth*slth
     &      **2-6D0*Mb/MW**2*Ml/SW**2*clth*slth+12D0*Mb/MW
     &      **2*Ml/SW**2*clth*sbth**2*slth)
      AAABR(4110) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      -3D0*slth**2-sb**2*sbth**2+3D0*sb**2*slth**2
     &      -3D0*sbth**2*slth**2+3D0*sb**2*sbth**2*slth**2)
      AAABR(4111) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2-3D0*slth**2-sb**2*sbth**2+3D0*sb**2*slth
     &      **2-3D0*sbth**2*slth**2+3D0*sb**2*sbth**2*slth
     &      **2)
      AAABR(4112) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *sbth*slth
      AAABR(4113) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *sb**2*sbth*slth
      AAABR(4114) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*clth
     &      *sbth*slth
      AAABR(4115) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*clth
     &      *sbth*slth
      AAABR(4116) = EE**2/cb**2*(1D0/CW**2-3D0/SW**2-sb**2
     &      /CW**2+sdth**2/CW**2-3D0*slth**2/CW**2+3D0*sb
     &      **2/SW**2+3D0*sdth**2/SW**2+3D0*slth**2/SW**2
     &      -sb**2/CW**2*sdth**2+3D0*sb**2/CW**2*slth**2
     &      -3D0*sdth**2/CW**2*slth**2-3D0*sb**2/SW**2*sdth
     &      **2-3D0*sb**2/SW**2*slth**2-3D0*sdth**2/SW**2
     &      *slth**2+3D0*sb**2/CW**2*sdth**2*slth**2+3D0
     &      *sb**2/SW**2*sdth**2*slth**2-12D0*Md/MW**2*Ml
     &      /SW**2*cdth*clth*sdth*slth)
      AAABR(4117) = EE**2/cb**2*(clth/CW**2*slth-clth/SW
     &      **2*slth-clth/CW**2*sb**2*slth+clth/CW**2*sdth
     &      **2*slth+clth/SW**2*sb**2*slth+clth/SW**2*sdth
     &      **2*slth-clth/CW**2*sb**2*sdth**2*slth-clth/SW
     &      **2*sb**2*sdth**2*slth+2D0*Md/MW**2*Ml/SW**2
     &      *cdth*sdth-4D0*Md/MW**2*Ml/SW**2*cdth*sdth*slth
     &      **2)
      AAABR(4118) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -slth**2+sb**2*sdth**2+sb**2*slth**2+sdth**2
     &      *slth**2-sb**2*sdth**2*slth**2)
      AAABR(4119) = EE**2/cb**2*(cdth/CW**2*sdth+3D0*cdth
     &      /SW**2*sdth-cdth/CW**2*sb**2*sdth-3D0*cdth/CW
     &      **2*sdth*slth**2-3D0*cdth/SW**2*sb**2*sdth-3D0
     &      *cdth/SW**2*sdth*slth**2+3D0*cdth/CW**2*sb**2
     &      *sdth*slth**2+3D0*cdth/SW**2*sb**2*sdth*slth
     &      **2-6D0*Md/MW**2*Ml/SW**2*clth*slth+12D0*Md/MW
     &      **2*Ml/SW**2*clth*sdth**2*slth)
      AAABR(4120) = EE**2/CW**2/cb**2*(1D0-sb**2+sdth**2
     &      -3D0*slth**2-sb**2*sdth**2+3D0*sb**2*slth**2
     &      -3D0*sdth**2*slth**2+3D0*sb**2*sdth**2*slth**2)
      AAABR(4121) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sdth
     &      **2-3D0*slth**2-sb**2*sdth**2+3D0*sb**2*slth
     &      **2-3D0*sdth**2*slth**2+3D0*sb**2*sdth**2*slth
     &      **2)
      AAABR(4122) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *sdth*slth
      AAABR(4123) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *sb**2*sdth*slth
      AAABR(4124) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*clth
     &      *sdth*slth
      AAABR(4125) = EE**2/MW**2*Md/SW**2/cb**2*cdth*clth
     &      *sdth*slth
      AAABR(4126) = EE**2/cb**2*(Mb/MW**2*Me/SW**2+cbth/CW
     &      **2*ceth*sbth*seth-2D0*Mb/MW**2*Me/SW**2*sbth
     &      **2-2D0*Mb/MW**2*Me/SW**2*seth**2+cbth/SW**2
     &      *ceth*sbth*seth-cbth/CW**2*ceth*sb**2*sbth*seth
     &      +4D0*Mb/MW**2*Me/SW**2*sbth**2*seth**2-cbth/SW
     &      **2*ceth*sb**2*sbth*seth)
      AAABR(4127) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4128) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2-6D0*seth**2/CW**2-3D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2+6D0*sb**2/CW**2*seth
     &      **2+3D0*sbth**2/CW**2*seth**2+3D0*sb**2/SW**2
     &      *sbth**2+3D0*sbth**2/SW**2*seth**2-3D0*sb**2
     &      /CW**2*sbth**2*seth**2-3D0*sb**2/SW**2*sbth**2
     &      *seth**2+12D0*Mb/MW**2*Me/SW**2*cbth*ceth*sbth
     &      *seth)
      AAABR(4129) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4130) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4131) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sbth**2)
      AAABR(4132) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*sb
     &      **2*seth*(1D0-2D0*sbth**2)
      AAABR(4133) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sbth**2)
      AAABR(4134) = EE**2/MW**2*Mb/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sbth**2)
      AAABR(4135) = EE**2/cb**2*(Mm/MW**2*Ms/SW**2+cmuth
     &      /CW**2*csth*smuth*ssth-2D0*Mm/MW**2*Ms/SW**2
     &      *smuth**2-2D0*Mm/MW**2*Ms/SW**2*ssth**2+cmuth
     &      /SW**2*csth*smuth*ssth-cmuth/CW**2*csth*sb**2
     &      *smuth*ssth+4D0*Mm/MW**2*Ms/SW**2*smuth**2*ssth
     &      **2-cmuth/SW**2*csth*sb**2*smuth*ssth)
      AAABR(4136) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4137) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*smuth**2/CW**2-ssth**2/CW**2-3D0*ssth**2
     &      /SW**2+6D0*sb**2/CW**2*smuth**2+sb**2/CW**2*ssth
     &      **2+3D0*smuth**2/CW**2*ssth**2+3D0*sb**2/SW**2
     &      *ssth**2+3D0*smuth**2/SW**2*ssth**2-3D0*sb**2
     &      /CW**2*smuth**2*ssth**2-3D0*sb**2/SW**2*smuth
     &      **2*ssth**2+12D0*Mm/MW**2*Ms/SW**2*cmuth*csth
     &      *smuth*ssth)
      AAABR(4138) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4139) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4140) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*ssth**2)
      AAABR(4141) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*sb
     &      **2*smuth*(1D0-2D0*ssth**2)
      AAABR(4142) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*ssth**2)
      AAABR(4143) = EE**2/MW**2*Ms/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*ssth**2)
      AAABR(4144) = EE**2/cb**2*(Mb/MW**2*Ml/SW**2+cbth/CW
     &      **2*clth*sbth*slth-2D0*Mb/MW**2*Ml/SW**2*sbth
     &      **2-2D0*Mb/MW**2*Ml/SW**2*slth**2+cbth/SW**2
     &      *clth*sbth*slth-cbth/CW**2*clth*sb**2*sbth*slth
     &      +4D0*Mb/MW**2*Ml/SW**2*sbth**2*slth**2-cbth/SW
     &      **2*clth*sb**2*sbth*slth)
      AAABR(4145) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4146) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2-6D0*slth**2/CW**2-3D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2+6D0*sb**2/CW**2*slth
     &      **2+3D0*sbth**2/CW**2*slth**2+3D0*sb**2/SW**2
     &      *sbth**2+3D0*sbth**2/SW**2*slth**2-3D0*sb**2
     &      /CW**2*sbth**2*slth**2-3D0*sb**2/SW**2*sbth**2
     &      *slth**2+12D0*Mb/MW**2*Ml/SW**2*cbth*clth*sbth
     &      *slth)
      AAABR(4147) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4148) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4149) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sbth**2)
      AAABR(4150) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*sb
     &      **2*slth*(1D0-2D0*sbth**2)
      AAABR(4151) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sbth**2)
      AAABR(4152) = EE**2/MW**2*Mb/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sbth**2)
      AAABR(4153) = EE**2/cb**2*(Mb/MW**2*Mm/SW**2+cbth/CW
     &      **2*cmuth*sbth*smuth-2D0*Mb/MW**2*Mm/SW**2*sbth
     &      **2-2D0*Mb/MW**2*Mm/SW**2*smuth**2+cbth/SW**2
     &      *cmuth*sbth*smuth-cbth/CW**2*cmuth*sb**2*sbth
     &      *smuth+4D0*Mb/MW**2*Mm/SW**2*sbth**2*smuth**2
     &      -cbth/SW**2*cmuth*sb**2*sbth*smuth)
      AAABR(4154) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4155) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2-6D0*smuth**2/CW**2-3D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2+6D0*sb**2/CW**2*smuth
     &      **2+3D0*sbth**2/CW**2*smuth**2+3D0*sb**2/SW**2
     &      *sbth**2+3D0*sbth**2/SW**2*smuth**2-3D0*sb**2
     &      /CW**2*sbth**2*smuth**2-3D0*sb**2/SW**2*sbth
     &      **2*smuth**2+12D0*Mb/MW**2*Mm/SW**2*cbth*cmuth
     &      *sbth*smuth)
      AAABR(4156) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4157) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4158) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sbth**2)
      AAABR(4159) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*sb
     &      **2*smuth*(1D0-2D0*sbth**2)
      AAABR(4160) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sbth**2)
      AAABR(4161) = EE**2/MW**2*Mb/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sbth**2)
      AAABR(4162) = EE**2/cb**2*(Md/MW**2*Me/SW**2+cdth/CW
     &      **2*ceth*sdth*seth-2D0*Md/MW**2*Me/SW**2*sdth
     &      **2-2D0*Md/MW**2*Me/SW**2*seth**2+cdth/SW**2
     &      *ceth*sdth*seth-cdth/CW**2*ceth*sb**2*sdth*seth
     &      +4D0*Md/MW**2*Me/SW**2*sdth**2*seth**2-cdth/SW
     &      **2*ceth*sb**2*sdth*seth)
      AAABR(4163) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4164) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sdth**2/CW**2-6D0*seth**2/CW**2-3D0*sdth**2
     &      /SW**2+sb**2/CW**2*sdth**2+6D0*sb**2/CW**2*seth
     &      **2+3D0*sdth**2/CW**2*seth**2+3D0*sb**2/SW**2
     &      *sdth**2+3D0*sdth**2/SW**2*seth**2-3D0*sb**2
     &      /CW**2*sdth**2*seth**2-3D0*sb**2/SW**2*sdth**2
     &      *seth**2+12D0*Md/MW**2*Me/SW**2*cdth*ceth*sdth
     &      *seth)
      AAABR(4165) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4166) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4167) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sdth**2)
      AAABR(4168) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*sb
     &      **2*seth*(1D0-2D0*sdth**2)
      AAABR(4169) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sdth**2)
      AAABR(4170) = EE**2/MW**2*Md/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*sdth**2)
      AAABR(4171) = EE**2/cb**2*(Me/MW**2*Ms/SW**2+ceth/CW
     &      **2*csth*seth*ssth-2D0*Me/MW**2*Ms/SW**2*seth
     &      **2-2D0*Me/MW**2*Ms/SW**2*ssth**2+ceth/SW**2
     &      *csth*seth*ssth-ceth/CW**2*csth*sb**2*seth*ssth
     &      +4D0*Me/MW**2*Ms/SW**2*seth**2*ssth**2-ceth/SW
     &      **2*csth*sb**2*seth*ssth)
      AAABR(4172) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4173) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-ssth**2/CW**2-3D0*ssth**2
     &      /SW**2+6D0*sb**2/CW**2*seth**2+sb**2/CW**2*ssth
     &      **2+3D0*seth**2/CW**2*ssth**2+3D0*sb**2/SW**2
     &      *ssth**2+3D0*seth**2/SW**2*ssth**2-3D0*sb**2
     &      /CW**2*seth**2*ssth**2-3D0*sb**2/SW**2*seth**2
     &      *ssth**2+12D0*Me/MW**2*Ms/SW**2*ceth*csth*seth
     &      *ssth)
      AAABR(4174) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4175) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(4176) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*ssth**2)
      AAABR(4177) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*sb
     &      **2*seth*(1D0-2D0*ssth**2)
      AAABR(4178) = EE**2/MW**2*Me/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*ssth**2)
      AAABR(4179) = EE**2/MW**2*Ms/SW**2/cb**2*ceth*seth
     &      *(1D0-2D0*ssth**2)
      AAABR(4180) = EE**2/cb**2*(Md/MW**2*Mm/SW**2+cdth/CW
     &      **2*cmuth*sdth*smuth-2D0*Md/MW**2*Mm/SW**2*sdth
     &      **2-2D0*Md/MW**2*Mm/SW**2*smuth**2+cdth/SW**2
     &      *cmuth*sdth*smuth-cdth/CW**2*cmuth*sb**2*sdth
     &      *smuth+4D0*Md/MW**2*Mm/SW**2*sdth**2*smuth**2
     &      -cdth/SW**2*cmuth*sb**2*sdth*smuth)
      AAABR(4181) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4182) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sdth**2/CW**2-6D0*smuth**2/CW**2-3D0*sdth**2
     &      /SW**2+sb**2/CW**2*sdth**2+6D0*sb**2/CW**2*smuth
     &      **2+3D0*sdth**2/CW**2*smuth**2+3D0*sb**2/SW**2
     &      *sdth**2+3D0*sdth**2/SW**2*smuth**2-3D0*sb**2
     &      /CW**2*sdth**2*smuth**2-3D0*sb**2/SW**2*sdth
     &      **2*smuth**2+12D0*Md/MW**2*Mm/SW**2*cdth*cmuth
     &      *sdth*smuth)
      AAABR(4183) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4184) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(4185) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sdth**2)
      AAABR(4186) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*sb
     &      **2*smuth*(1D0-2D0*sdth**2)
      AAABR(4187) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sdth**2)
      AAABR(4188) = EE**2/MW**2*Md/SW**2/cb**2*cmuth*smuth
     &      *(1D0-2D0*sdth**2)
      AAABR(4189) = EE**2/cb**2*(Ml/MW**2*Ms/SW**2+clth/CW
     &      **2*csth*slth*ssth-2D0*Ml/MW**2*Ms/SW**2*slth
     &      **2-2D0*Ml/MW**2*Ms/SW**2*ssth**2+clth/SW**2
     &      *csth*slth*ssth-clth/CW**2*csth*sb**2*slth*ssth
     &      +4D0*Ml/MW**2*Ms/SW**2*slth**2*ssth**2-clth/SW
     &      **2*csth*sb**2*slth*ssth)
      AAABR(4190) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4191) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -6D0*slth**2/CW**2-ssth**2/CW**2-3D0*ssth**2
     &      /SW**2+6D0*sb**2/CW**2*slth**2+sb**2/CW**2*ssth
     &      **2+3D0*slth**2/CW**2*ssth**2+3D0*sb**2/SW**2
     &      *ssth**2+3D0*slth**2/SW**2*ssth**2-3D0*sb**2
     &      /CW**2*slth**2*ssth**2-3D0*sb**2/SW**2*slth**2
     &      *ssth**2+12D0*Ml/MW**2*Ms/SW**2*clth*csth*slth
     &      *ssth)
      AAABR(4192) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4193) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4194) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*ssth**2)
      AAABR(4195) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*sb
     &      **2*slth*(1D0-2D0*ssth**2)
      AAABR(4196) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*ssth**2)
      AAABR(4197) = EE**2/MW**2*Ms/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*ssth**2)
      AAABR(4198) = EE**2/cb**2*(Md/MW**2*Ml/SW**2+cdth/CW
     &      **2*clth*sdth*slth-2D0*Md/MW**2*Ml/SW**2*sdth
     &      **2-2D0*Md/MW**2*Ml/SW**2*slth**2+cdth/SW**2
     &      *clth*sdth*slth-cdth/CW**2*clth*sb**2*sdth*slth
     &      +4D0*Md/MW**2*Ml/SW**2*sdth**2*slth**2-cdth/SW
     &      **2*clth*sb**2*sdth*slth)
      AAABR(4199) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4200) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sdth**2/CW**2-6D0*slth**2/CW**2-3D0*sdth**2
     &      /SW**2+sb**2/CW**2*sdth**2+6D0*sb**2/CW**2*slth
     &      **2+3D0*sdth**2/CW**2*slth**2+3D0*sb**2/SW**2
     &      *sdth**2+3D0*sdth**2/SW**2*slth**2-3D0*sb**2
     &      /CW**2*sdth**2*slth**2-3D0*sb**2/SW**2*sdth**2
     &      *slth**2+12D0*Md/MW**2*Ml/SW**2*cdth*clth*sdth
     &      *slth)
      AAABR(4201) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4202) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(4203) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sdth**2)
      AAABR(4204) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*sb
     &      **2*slth*(1D0-2D0*sdth**2)
      AAABR(4205) = EE**2/MW**2*Ml/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sdth**2)
      AAABR(4206) = EE**2/MW**2*Md/SW**2/cb**2*clth*slth
     &      *(1D0-2D0*sdth**2)
      AAABR(4207) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sbth**2/CW**2-3D0*seth**2/CW**2+3D0*seth
     &      **2/SW**2-2D0*sb**2/CW**2*sbth**2+3D0*sb**2/CW
     &      **2*seth**2-3D0*sbth**2/CW**2*seth**2-3D0*sb
     &      **2/SW**2*seth**2-3D0*sbth**2/SW**2*seth**2+3D0
     &      *sb**2/CW**2*sbth**2*seth**2+3D0*sb**2/SW**2
     &      *sbth**2*seth**2-12D0*Mb/MW**2*Me/SW**2*cbth
     &      *ceth*sbth*seth)
      AAABR(4208) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(4209) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2
     &      +sbth**2-sb**2*sbth**2)
      AAABR(4210) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(4211) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*seth**2)
      AAABR(4212) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*sb
     &      **2*sbth*(1D0-2D0*seth**2)
      AAABR(4213) = EE**2/MW**2*Me/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*seth**2)
      AAABR(4214) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*seth**2)
      AAABR(4215) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*seth**2/CW**2+2D0*ssth**2/CW**2+3D0*seth
     &      **2/SW**2+3D0*sb**2/CW**2*seth**2-2D0*sb**2/CW
     &      **2*ssth**2-3D0*seth**2/CW**2*ssth**2-3D0*sb
     &      **2/SW**2*seth**2-3D0*seth**2/SW**2*ssth**2+3D0
     &      *sb**2/CW**2*seth**2*ssth**2+3D0*sb**2/SW**2
     &      *seth**2*ssth**2-12D0*Me/MW**2*Ms/SW**2*ceth
     &      *csth*seth*ssth)
      AAABR(4216) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(4217) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2
     &      +ssth**2-sb**2*ssth**2)
      AAABR(4218) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(4219) = EE**2/MW**2*Me*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*seth**2)
      AAABR(4220) = EE**2/MW**2*Me*Ms/SW**2/cb**2*csth*sb
     &      **2*ssth*(1D0-2D0*seth**2)
      AAABR(4221) = EE**2/MW**2*Me/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*seth**2)
      AAABR(4222) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*seth**2)
      AAABR(4223) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*smuth**2/CW**2+2D0*ssth**2/CW**2+3D0*smuth
     &      **2/SW**2+3D0*sb**2/CW**2*smuth**2-2D0*sb**2
     &      /CW**2*ssth**2-3D0*smuth**2/CW**2*ssth**2-3D0
     &      *sb**2/SW**2*smuth**2-3D0*smuth**2/SW**2*ssth
     &      **2+3D0*sb**2/CW**2*smuth**2*ssth**2+3D0*sb**2
     &      /SW**2*smuth**2*ssth**2-12D0*Mm/MW**2*Ms/SW**2
     &      *cmuth*csth*smuth*ssth)
      AAABR(4224) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-ssth**2+sb**2*ssth**2)
      AAABR(4225) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(4226) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2+ssth**2-sb**2*ssth**2)
      AAABR(4227) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*smuth**2)
      AAABR(4228) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*csth*sb
     &      **2*ssth*(1D0-2D0*smuth**2)
      AAABR(4229) = EE**2/MW**2*Mm/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*smuth**2)
      AAABR(4230) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*smuth**2)
      AAABR(4231) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sbth**2/CW**2-3D0*slth**2/CW**2+3D0*slth
     &      **2/SW**2-2D0*sb**2/CW**2*sbth**2+3D0*sb**2/CW
     &      **2*slth**2-3D0*sbth**2/CW**2*slth**2-3D0*sb
     &      **2/SW**2*slth**2-3D0*sbth**2/SW**2*slth**2+3D0
     &      *sb**2/CW**2*sbth**2*slth**2+3D0*sb**2/SW**2
     &      *sbth**2*slth**2-12D0*Mb/MW**2*Ml/SW**2*cbth
     &      *clth*sbth*slth)
      AAABR(4232) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(4233) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2
     &      +sbth**2-sb**2*sbth**2)
      AAABR(4234) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(4235) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*slth**2)
      AAABR(4236) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*sb
     &      **2*sbth*(1D0-2D0*slth**2)
      AAABR(4237) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*slth**2)
      AAABR(4238) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*slth**2)
      AAABR(4239) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sdth**2/CW**2-3D0*smuth**2/CW**2+3D0*smuth
     &      **2/SW**2-2D0*sb**2/CW**2*sdth**2+3D0*sb**2/CW
     &      **2*smuth**2-3D0*sdth**2/CW**2*smuth**2-3D0*sb
     &      **2/SW**2*smuth**2-3D0*sdth**2/SW**2*smuth**2
     &      +3D0*sb**2/CW**2*sdth**2*smuth**2+3D0*sb**2/SW
     &      **2*sdth**2*smuth**2-12D0*Md/MW**2*Mm/SW**2*cdth
     &      *cmuth*sdth*smuth)
      AAABR(4240) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-sdth**2+sb**2*sdth**2)
      AAABR(4241) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(4242) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2+sdth**2-sb**2*sdth**2)
      AAABR(4243) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*smuth**2)
      AAABR(4244) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*sb
     &      **2*sdth*(1D0-2D0*smuth**2)
      AAABR(4245) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*smuth**2)
      AAABR(4246) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*smuth**2)
      AAABR(4247) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sdth**2/CW**2-3D0*slth**2/CW**2+3D0*slth
     &      **2/SW**2-2D0*sb**2/CW**2*sdth**2+3D0*sb**2/CW
     &      **2*slth**2-3D0*sdth**2/CW**2*slth**2-3D0*sb
     &      **2/SW**2*slth**2-3D0*sdth**2/SW**2*slth**2+3D0
     &      *sb**2/CW**2*sdth**2*slth**2+3D0*sb**2/SW**2
     &      *sdth**2*slth**2-12D0*Md/MW**2*Ml/SW**2*cdth
     &      *clth*sdth*slth)
      AAABR(4248) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(4249) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2
     &      +sdth**2-sb**2*sdth**2)
      AAABR(4250) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(4251) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*slth**2)
      AAABR(4252) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*sb
     &      **2*sdth*(1D0-2D0*slth**2)
      AAABR(4253) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*slth**2)
      AAABR(4254) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*slth**2)
      AAABR(4255) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sbth**2/CW**2-3D0*smuth**2/CW**2+3D0*smuth
     &      **2/SW**2-2D0*sb**2/CW**2*sbth**2+3D0*sb**2/CW
     &      **2*smuth**2-3D0*sbth**2/CW**2*smuth**2-3D0*sb
     &      **2/SW**2*smuth**2-3D0*sbth**2/SW**2*smuth**2
     &      +3D0*sb**2/CW**2*sbth**2*smuth**2+3D0*sb**2/SW
     &      **2*sbth**2*smuth**2-12D0*Mb/MW**2*Mm/SW**2*cbth
     &      *cmuth*sbth*smuth)
      AAABR(4256) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2-sbth**2+sb**2*sbth**2)
      AAABR(4257) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(4258) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -sb**2+sbth**2-sb**2*sbth**2)
      AAABR(4259) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*smuth**2)
      AAABR(4260) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*sb
     &      **2*sbth*(1D0-2D0*smuth**2)
      AAABR(4261) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*smuth**2)
      AAABR(4262) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*smuth**2)
      AAABR(4263) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sdth**2/CW**2-3D0*seth**2/CW**2+3D0*seth
     &      **2/SW**2-2D0*sb**2/CW**2*sdth**2+3D0*sb**2/CW
     &      **2*seth**2-3D0*sdth**2/CW**2*seth**2-3D0*sb
     &      **2/SW**2*seth**2-3D0*sdth**2/SW**2*seth**2+3D0
     &      *sb**2/CW**2*sdth**2*seth**2+3D0*sb**2/SW**2
     &      *sdth**2*seth**2-12D0*Md/MW**2*Me/SW**2*cdth
     &      *ceth*sdth*seth)
      AAABR(4264) = EE**2/SW**2/cb**2*ceth*seth*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(4265) = EE**2/CW**2/cb**2*ceth*seth*(1D0-sb**2
     &      +sdth**2-sb**2*sdth**2)
      AAABR(4266) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(4267) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*seth**2)
      AAABR(4268) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*sb
     &      **2*sdth*(1D0-2D0*seth**2)
      AAABR(4269) = EE**2/MW**2*Me/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*seth**2)
      AAABR(4270) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*seth**2)
      AAABR(4271) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -3D0*slth**2/CW**2+2D0*ssth**2/CW**2+3D0*slth
     &      **2/SW**2+3D0*sb**2/CW**2*slth**2-2D0*sb**2/CW
     &      **2*ssth**2-3D0*slth**2/CW**2*ssth**2-3D0*sb
     &      **2/SW**2*slth**2-3D0*slth**2/SW**2*ssth**2+3D0
     &      *sb**2/CW**2*slth**2*ssth**2+3D0*sb**2/SW**2
     &      *slth**2*ssth**2-12D0*Ml/MW**2*Ms/SW**2*clth
     &      *csth*slth*ssth)
      AAABR(4272) = EE**2/SW**2/cb**2*clth*slth*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(4273) = EE**2/CW**2/cb**2*clth*slth*(1D0-sb**2
     &      +ssth**2-sb**2*ssth**2)
      AAABR(4274) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(4275) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*slth**2)
      AAABR(4276) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*csth*sb
     &      **2*ssth*(1D0-2D0*slth**2)
      AAABR(4277) = EE**2/MW**2*Ml/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*slth**2)
      AAABR(4278) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*slth**2)
      AAABR(4279) = EE**2/cb**2*(cmuth/CW**2*csth*smuth*ssth
     &      -2D0*Mm/MW**2*Ms/SW**2*smuth**2-2D0*Mm/MW**2
     &      *Ms/SW**2*ssth**2+cmuth/SW**2*csth*smuth*ssth
     &      -cmuth/CW**2*csth*sb**2*smuth*ssth+4D0*Mm/MW
     &      **2*Ms/SW**2*smuth**2*ssth**2-cmuth/SW**2*csth
     &      *sb**2*smuth*ssth)
      AAABR(4280) = EE**2/cb**2*(2D0*csth/CW**2*ssth-2D0
     &      *csth/CW**2*sb**2*ssth-3D0*csth/CW**2*smuth**2
     &      *ssth-3D0*csth/SW**2*smuth**2*ssth+3D0*csth/CW
     &      **2*sb**2*smuth**2*ssth+3D0*csth/SW**2*sb**2
     &      *smuth**2*ssth-6D0*Mm/MW**2*Ms/SW**2*cmuth*smuth
     &      +12D0*Mm/MW**2*Ms/SW**2*cmuth*smuth*ssth**2)
      AAABR(4281) = EE**2/SW**2/cb**2*cmuth*csth*smuth*ssth
     &      *(1D0-sb**2)
      AAABR(4282) = EE**2/cb**2*(2D0*cmuth/CW**2*smuth-2D0
     &      *cmuth/CW**2*sb**2*smuth-cmuth/CW**2*smuth*ssth
     &      **2-cmuth/SW**2*smuth*ssth**2+cmuth/CW**2*sb
     &      **2*smuth*ssth**2+cmuth/SW**2*sb**2*smuth*ssth
     &      **2-2D0*Mm/MW**2*Ms/SW**2*csth*ssth+4D0*Mm/MW
     &      **2*Ms/SW**2*csth*smuth**2*ssth)
      AAABR(4283) = EE**2/CW**2/cb**2*cmuth*csth*smuth*ssth
     &      *(1D0-sb**2)
      AAABR(4284) = EE**2/CW**3*SW/cb**2*cmuth*csth*smuth
     &      *ssth*(1D0-sb**2)
      AAABR(4285) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*(smuth
     &      **2+ssth**2-2D0*smuth**2*ssth**2)
      AAABR(4286) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*sb**2*(smuth
     &      **2+ssth**2-2D0*smuth**2*ssth**2)
      AAABR(4287) = EE**2/MW**2*Mm/SW**2/cb**2*(smuth**2
     &      +ssth**2-2D0*smuth**2*ssth**2)
      AAABR(4288) = EE**2/MW**2*Ms/SW**2/cb**2*(smuth**2
     &      +ssth**2-2D0*smuth**2*ssth**2)
      AAABR(4289) = EE**2/cb**2*(cdth/CW**2*ceth*sdth*seth
     &      -2D0*Md/MW**2*Me/SW**2*sdth**2-2D0*Md/MW**2*Me
     &      /SW**2*seth**2+cdth/SW**2*ceth*sdth*seth-cdth
     &      /CW**2*ceth*sb**2*sdth*seth+4D0*Md/MW**2*Me/SW
     &      **2*sdth**2*seth**2-cdth/SW**2*ceth*sb**2*sdth
     &      *seth)
      AAABR(4290) = EE**2/cb**2*(2D0*cdth/CW**2*sdth-2D0
     &      *cdth/CW**2*sb**2*sdth-3D0*cdth/CW**2*sdth*seth
     &      **2-3D0*cdth/SW**2*sdth*seth**2+3D0*cdth/CW**2
     &      *sb**2*sdth*seth**2+3D0*cdth/SW**2*sb**2*sdth
     &      *seth**2-6D0*Md/MW**2*Me/SW**2*ceth*seth+12D0
     &      *Md/MW**2*Me/SW**2*ceth*sdth**2*seth)
      AAABR(4291) = EE**2/SW**2/cb**2*cdth*ceth*sdth*seth
     &      *(1D0-sb**2)
      AAABR(4292) = EE**2/cb**2*(2D0*ceth/CW**2*seth-2D0
     &      *ceth/CW**2*sb**2*seth-ceth/CW**2*sdth**2*seth
     &      -ceth/SW**2*sdth**2*seth+ceth/CW**2*sb**2*sdth
     &      **2*seth+ceth/SW**2*sb**2*sdth**2*seth-2D0*Md
     &      /MW**2*Me/SW**2*cdth*sdth+4D0*Md/MW**2*Me/SW
     &      **2*cdth*sdth*seth**2)
      AAABR(4293) = EE**2/CW**2/cb**2*cdth*ceth*sdth*seth
     &      *(1D0-sb**2)
      AAABR(4294) = EE**2/CW**3*SW/cb**2*cdth*ceth*sdth*seth
     &      *(1D0-sb**2)
      AAABR(4295) = EE**2/MW**2*Md*Me/SW**2/cb**2*(sdth**2
     &      +seth**2-2D0*sdth**2*seth**2)
      AAABR(4296) = EE**2/MW**2*Md*Me/SW**2/cb**2*sb**2*(sdth
     &      **2+seth**2-2D0*sdth**2*seth**2)
      AAABR(4297) = EE**2/MW**2*Me/SW**2/cb**2*(sdth**2+seth
     &      **2-2D0*sdth**2*seth**2)
      AAABR(4298) = EE**2/MW**2*Md/SW**2/cb**2*(sdth**2+seth
     &      **2-2D0*sdth**2*seth**2)
      AAABR(4299) = EE**2/cb**2*(cdth/CW**2*cmuth*sdth*smuth
     &      -2D0*Md/MW**2*Mm/SW**2*sdth**2-2D0*Md/MW**2*Mm
     &      /SW**2*smuth**2+cdth/SW**2*cmuth*sdth*smuth-cdth
     &      /CW**2*cmuth*sb**2*sdth*smuth+4D0*Md/MW**2*Mm
     &      /SW**2*sdth**2*smuth**2-cdth/SW**2*cmuth*sb**2
     &      *sdth*smuth)
      AAABR(4300) = EE**2/cb**2*(2D0*cdth/CW**2*sdth-2D0
     &      *cdth/CW**2*sb**2*sdth-3D0*cdth/CW**2*sdth*smuth
     &      **2-3D0*cdth/SW**2*sdth*smuth**2+3D0*cdth/CW
     &      **2*sb**2*sdth*smuth**2+3D0*cdth/SW**2*sb**2
     &      *sdth*smuth**2-6D0*Md/MW**2*Mm/SW**2*cmuth*smuth
     &      +12D0*Md/MW**2*Mm/SW**2*cmuth*sdth**2*smuth)
      AAABR(4301) = EE**2/SW**2/cb**2*cdth*cmuth*sdth*smuth
     &      *(1D0-sb**2)
      AAABR(4302) = EE**2/cb**2*(2D0*cmuth/CW**2*smuth-2D0
     &      *cmuth/CW**2*sb**2*smuth-cmuth/CW**2*sdth**2
     &      *smuth-cmuth/SW**2*sdth**2*smuth+cmuth/CW**2
     &      *sb**2*sdth**2*smuth+cmuth/SW**2*sb**2*sdth**2
     &      *smuth-2D0*Md/MW**2*Mm/SW**2*cdth*sdth+4D0*Md
     &      /MW**2*Mm/SW**2*cdth*sdth*smuth**2)
      AAABR(4303) = EE**2/CW**2/cb**2*cdth*cmuth*sdth*smuth
     &      *(1D0-sb**2)
      AAABR(4304) = EE**2/CW**3*SW/cb**2*cdth*cmuth*sdth
     &      *smuth*(1D0-sb**2)
      AAABR(4305) = EE**2/MW**2*Md*Mm/SW**2/cb**2*(sdth**2
     &      +smuth**2-2D0*sdth**2*smuth**2)
      AAABR(4306) = EE**2/MW**2*Md*Mm/SW**2/cb**2*sb**2*(sdth
     &      **2+smuth**2-2D0*sdth**2*smuth**2)
      AAABR(4307) = EE**2/MW**2*Mm/SW**2/cb**2*(sdth**2+smuth
     &      **2-2D0*sdth**2*smuth**2)
      AAABR(4308) = EE**2/MW**2*Md/SW**2/cb**2*(sdth**2+smuth
     &      **2-2D0*sdth**2*smuth**2)
      AAABR(4309) = EE**2/cb**2*(cbth/CW**2*cmuth*sbth*smuth
     &      -2D0*Mb/MW**2*Mm/SW**2*sbth**2-2D0*Mb/MW**2*Mm
     &      /SW**2*smuth**2+cbth/SW**2*cmuth*sbth*smuth-cbth
     &      /CW**2*cmuth*sb**2*sbth*smuth+4D0*Mb/MW**2*Mm
     &      /SW**2*sbth**2*smuth**2-cbth/SW**2*cmuth*sb**2
     &      *sbth*smuth)
      AAABR(4310) = EE**2/cb**2*(2D0*cbth/CW**2*sbth-2D0
     &      *cbth/CW**2*sb**2*sbth-3D0*cbth/CW**2*sbth*smuth
     &      **2-3D0*cbth/SW**2*sbth*smuth**2+3D0*cbth/CW
     &      **2*sb**2*sbth*smuth**2+3D0*cbth/SW**2*sb**2
     &      *sbth*smuth**2-6D0*Mb/MW**2*Mm/SW**2*cmuth*smuth
     &      +12D0*Mb/MW**2*Mm/SW**2*cmuth*sbth**2*smuth)
      AAABR(4311) = EE**2/SW**2/cb**2*cbth*cmuth*sbth*smuth
     &      *(1D0-sb**2)
      AAABR(4312) = EE**2/cb**2*(2D0*cmuth/CW**2*smuth-2D0
     &      *cmuth/CW**2*sb**2*smuth-cmuth/CW**2*sbth**2
     &      *smuth-cmuth/SW**2*sbth**2*smuth+cmuth/CW**2
     &      *sb**2*sbth**2*smuth+cmuth/SW**2*sb**2*sbth**2
     &      *smuth-2D0*Mb/MW**2*Mm/SW**2*cbth*sbth+4D0*Mb
     &      /MW**2*Mm/SW**2*cbth*sbth*smuth**2)
      AAABR(4313) = EE**2/CW**2/cb**2*cbth*cmuth*sbth*smuth
     &      *(1D0-sb**2)
      AAABR(4314) = EE**2/CW**3*SW/cb**2*cbth*cmuth*sbth
     &      *smuth*(1D0-sb**2)
      AAABR(4315) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*(sbth**2
     &      +smuth**2-2D0*sbth**2*smuth**2)
      AAABR(4316) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*sb**2*(sbth
     &      **2+smuth**2-2D0*sbth**2*smuth**2)
      AAABR(4317) = EE**2/MW**2*Mm/SW**2/cb**2*(sbth**2+smuth
     &      **2-2D0*sbth**2*smuth**2)
      AAABR(4318) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2+smuth
     &      **2-2D0*sbth**2*smuth**2)
      AAABR(4319) = EE**2/cb**2*(ceth/CW**2*csth*seth*ssth
     &      -2D0*Me/MW**2*Ms/SW**2*seth**2-2D0*Me/MW**2*Ms
     &      /SW**2*ssth**2+ceth/SW**2*csth*seth*ssth-ceth
     &      /CW**2*csth*sb**2*seth*ssth+4D0*Me/MW**2*Ms/SW
     &      **2*seth**2*ssth**2-ceth/SW**2*csth*sb**2*seth
     &      *ssth)
      AAABR(4320) = EE**2/cb**2*(2D0*csth/CW**2*ssth-2D0
     &      *csth/CW**2*sb**2*ssth-3D0*csth/CW**2*seth**2
     &      *ssth-3D0*csth/SW**2*seth**2*ssth+3D0*csth/CW
     &      **2*sb**2*seth**2*ssth+3D0*csth/SW**2*sb**2*seth
     &      **2*ssth-6D0*Me/MW**2*Ms/SW**2*ceth*seth+12D0
     &      *Me/MW**2*Ms/SW**2*ceth*seth*ssth**2)
      AAABR(4321) = EE**2/SW**2/cb**2*ceth*csth*seth*ssth
     &      *(1D0-sb**2)
      AAABR(4322) = EE**2/cb**2*(2D0*ceth/CW**2*seth-2D0
     &      *ceth/CW**2*sb**2*seth-ceth/CW**2*seth*ssth**2
     &      -ceth/SW**2*seth*ssth**2+ceth/CW**2*sb**2*seth
     &      *ssth**2+ceth/SW**2*sb**2*seth*ssth**2-2D0*Me
     &      /MW**2*Ms/SW**2*csth*ssth+4D0*Me/MW**2*Ms/SW
     &      **2*csth*seth**2*ssth)
      AAABR(4323) = EE**2/CW**2/cb**2*ceth*csth*seth*ssth
     &      *(1D0-sb**2)
      AAABR(4324) = EE**2/CW**3*SW/cb**2*ceth*csth*seth*ssth
     &      *(1D0-sb**2)
      AAABR(4325) = EE**2/MW**2*Me*Ms/SW**2/cb**2*(seth**2
     &      +ssth**2-2D0*seth**2*ssth**2)
      AAABR(4326) = EE**2/MW**2*Me*Ms/SW**2/cb**2*sb**2*(seth
     &      **2+ssth**2-2D0*seth**2*ssth**2)
      AAABR(4327) = EE**2/MW**2*Me/SW**2/cb**2*(seth**2+ssth
     &      **2-2D0*seth**2*ssth**2)
      AAABR(4328) = EE**2/MW**2*Ms/SW**2/cb**2*(seth**2+ssth
     &      **2-2D0*seth**2*ssth**2)
      AAABR(4329) = EE**2/cb**2*(cdth/CW**2*clth*sdth*slth
     &      -2D0*Md/MW**2*Ml/SW**2*sdth**2-2D0*Md/MW**2*Ml
     &      /SW**2*slth**2+cdth/SW**2*clth*sdth*slth-cdth
     &      /CW**2*clth*sb**2*sdth*slth+4D0*Md/MW**2*Ml/SW
     &      **2*sdth**2*slth**2-cdth/SW**2*clth*sb**2*sdth
     &      *slth)
      AAABR(4330) = EE**2/cb**2*(2D0*cdth/CW**2*sdth-2D0
     &      *cdth/CW**2*sb**2*sdth-3D0*cdth/CW**2*sdth*slth
     &      **2-3D0*cdth/SW**2*sdth*slth**2+3D0*cdth/CW**2
     &      *sb**2*sdth*slth**2+3D0*cdth/SW**2*sb**2*sdth
     &      *slth**2-6D0*Md/MW**2*Ml/SW**2*clth*slth+12D0
     &      *Md/MW**2*Ml/SW**2*clth*sdth**2*slth)
      AAABR(4331) = EE**2/SW**2/cb**2*cdth*clth*sdth*slth
     &      *(1D0-sb**2)
      AAABR(4332) = EE**2/cb**2*(2D0*clth/CW**2*slth-2D0
     &      *clth/CW**2*sb**2*slth-clth/CW**2*sdth**2*slth
     &      -clth/SW**2*sdth**2*slth+clth/CW**2*sb**2*sdth
     &      **2*slth+clth/SW**2*sb**2*sdth**2*slth-2D0*Md
     &      /MW**2*Ml/SW**2*cdth*sdth+4D0*Md/MW**2*Ml/SW
     &      **2*cdth*sdth*slth**2)
      AAABR(4333) = EE**2/CW**2/cb**2*cdth*clth*sdth*slth
     &      *(1D0-sb**2)
      AAABR(4334) = EE**2/CW**3*SW/cb**2*cdth*clth*sdth*slth
     &      *(1D0-sb**2)
      AAABR(4335) = EE**2/MW**2*Md*Ml/SW**2/cb**2*(sdth**2
     &      +slth**2-2D0*sdth**2*slth**2)
      AAABR(4336) = EE**2/MW**2*Md*Ml/SW**2/cb**2*sb**2*(sdth
     &      **2+slth**2-2D0*sdth**2*slth**2)
      AAABR(4337) = EE**2/MW**2*Ml/SW**2/cb**2*(sdth**2+slth
     &      **2-2D0*sdth**2*slth**2)
      AAABR(4338) = EE**2/MW**2*Md/SW**2/cb**2*(sdth**2+slth
     &      **2-2D0*sdth**2*slth**2)
      AAABR(4339) = EE**2/cb**2*(cbth/CW**2*clth*sbth*slth
     &      -2D0*Mb/MW**2*Ml/SW**2*sbth**2-2D0*Mb/MW**2*Ml
     &      /SW**2*slth**2+cbth/SW**2*clth*sbth*slth-cbth
     &      /CW**2*clth*sb**2*sbth*slth+4D0*Mb/MW**2*Ml/SW
     &      **2*sbth**2*slth**2-cbth/SW**2*clth*sb**2*sbth
     &      *slth)
      AAABR(4340) = EE**2/cb**2*(2D0*cbth/CW**2*sbth-2D0
     &      *cbth/CW**2*sb**2*sbth-3D0*cbth/CW**2*sbth*slth
     &      **2-3D0*cbth/SW**2*sbth*slth**2+3D0*cbth/CW**2
     &      *sb**2*sbth*slth**2+3D0*cbth/SW**2*sb**2*sbth
     &      *slth**2-6D0*Mb/MW**2*Ml/SW**2*clth*slth+12D0
     &      *Mb/MW**2*Ml/SW**2*clth*sbth**2*slth)
      AAABR(4341) = EE**2/SW**2/cb**2*cbth*clth*sbth*slth
     &      *(1D0-sb**2)
      AAABR(4342) = EE**2/cb**2*(2D0*clth/CW**2*slth-2D0
     &      *clth/CW**2*sb**2*slth-clth/CW**2*sbth**2*slth
     &      -clth/SW**2*sbth**2*slth+clth/CW**2*sb**2*sbth
     &      **2*slth+clth/SW**2*sb**2*sbth**2*slth-2D0*Mb
     &      /MW**2*Ml/SW**2*cbth*sbth+4D0*Mb/MW**2*Ml/SW
     &      **2*cbth*sbth*slth**2)
      AAABR(4343) = EE**2/CW**2/cb**2*cbth*clth*sbth*slth
     &      *(1D0-sb**2)
      AAABR(4344) = EE**2/CW**3*SW/cb**2*cbth*clth*sbth*slth
     &      *(1D0-sb**2)
      AAABR(4345) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*(sbth**2
     &      +slth**2-2D0*sbth**2*slth**2)
      AAABR(4346) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*sb**2*(sbth
     &      **2+slth**2-2D0*sbth**2*slth**2)
      AAABR(4347) = EE**2/MW**2*Ml/SW**2/cb**2*(sbth**2+slth
     &      **2-2D0*sbth**2*slth**2)
      AAABR(4348) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2+slth
     &      **2-2D0*sbth**2*slth**2)
      AAABR(4349) = EE**2/cb**2*(cbth/CW**2*ceth*sbth*seth
     &      -2D0*Mb/MW**2*Me/SW**2*sbth**2-2D0*Mb/MW**2*Me
     &      /SW**2*seth**2+cbth/SW**2*ceth*sbth*seth-cbth
     &      /CW**2*ceth*sb**2*sbth*seth+4D0*Mb/MW**2*Me/SW
     &      **2*sbth**2*seth**2-cbth/SW**2*ceth*sb**2*sbth
     &      *seth)
      AAABR(4350) = EE**2/cb**2*(2D0*cbth/CW**2*sbth-2D0
     &      *cbth/CW**2*sb**2*sbth-3D0*cbth/CW**2*sbth*seth
     &      **2-3D0*cbth/SW**2*sbth*seth**2+3D0*cbth/CW**2
     &      *sb**2*sbth*seth**2+3D0*cbth/SW**2*sb**2*sbth
     &      *seth**2-6D0*Mb/MW**2*Me/SW**2*ceth*seth+12D0
     &      *Mb/MW**2*Me/SW**2*ceth*sbth**2*seth)
      AAABR(4351) = EE**2/SW**2/cb**2*cbth*ceth*sbth*seth
     &      *(1D0-sb**2)
      AAABR(4352) = EE**2/cb**2*(2D0*ceth/CW**2*seth-2D0
     &      *ceth/CW**2*sb**2*seth-ceth/CW**2*sbth**2*seth
     &      -ceth/SW**2*sbth**2*seth+ceth/CW**2*sb**2*sbth
     &      **2*seth+ceth/SW**2*sb**2*sbth**2*seth-2D0*Mb
     &      /MW**2*Me/SW**2*cbth*sbth+4D0*Mb/MW**2*Me/SW
     &      **2*cbth*sbth*seth**2)
      AAABR(4353) = EE**2/CW**2/cb**2*cbth*ceth*sbth*seth
     &      *(1D0-sb**2)
      AAABR(4354) = EE**2/CW**3*SW/cb**2*cbth*ceth*sbth*seth
     &      *(1D0-sb**2)
      AAABR(4355) = EE**2/MW**2*Mb*Me/SW**2/cb**2*(sbth**2
     &      +seth**2-2D0*sbth**2*seth**2)
      AAABR(4356) = EE**2/MW**2*Mb*Me/SW**2/cb**2*sb**2*(sbth
     &      **2+seth**2-2D0*sbth**2*seth**2)
      AAABR(4357) = EE**2/MW**2*Me/SW**2/cb**2*(sbth**2+seth
     &      **2-2D0*sbth**2*seth**2)
      AAABR(4358) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2+seth
     &      **2-2D0*sbth**2*seth**2)
      AAABR(4359) = EE**2/cb**2*(clth/CW**2*csth*slth*ssth
     &      -2D0*Ml/MW**2*Ms/SW**2*slth**2-2D0*Ml/MW**2*Ms
     &      /SW**2*ssth**2+clth/SW**2*csth*slth*ssth-clth
     &      /CW**2*csth*sb**2*slth*ssth+4D0*Ml/MW**2*Ms/SW
     &      **2*slth**2*ssth**2-clth/SW**2*csth*sb**2*slth
     &      *ssth)
      AAABR(4360) = EE**2/cb**2*(2D0*csth/CW**2*ssth-2D0
     &      *csth/CW**2*sb**2*ssth-3D0*csth/CW**2*slth**2
     &      *ssth-3D0*csth/SW**2*slth**2*ssth+3D0*csth/CW
     &      **2*sb**2*slth**2*ssth+3D0*csth/SW**2*sb**2*slth
     &      **2*ssth-6D0*Ml/MW**2*Ms/SW**2*clth*slth+12D0
     &      *Ml/MW**2*Ms/SW**2*clth*slth*ssth**2)
      AAABR(4361) = EE**2/SW**2/cb**2*clth*csth*slth*ssth
     &      *(1D0-sb**2)
      AAABR(4362) = EE**2/cb**2*(2D0*clth/CW**2*slth-2D0
     &      *clth/CW**2*sb**2*slth-clth/CW**2*slth*ssth**2
     &      -clth/SW**2*slth*ssth**2+clth/CW**2*sb**2*slth
     &      *ssth**2+clth/SW**2*sb**2*slth*ssth**2-2D0*Ml
     &      /MW**2*Ms/SW**2*csth*ssth+4D0*Ml/MW**2*Ms/SW
     &      **2*csth*slth**2*ssth)
      AAABR(4363) = EE**2/CW**2/cb**2*clth*csth*slth*ssth
     &      *(1D0-sb**2)
      AAABR(4364) = EE**2/CW**3*SW/cb**2*clth*csth*slth*ssth
     &      *(1D0-sb**2)
      AAABR(4365) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*(slth**2
     &      +ssth**2-2D0*slth**2*ssth**2)
      AAABR(4366) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*sb**2*(slth
     &      **2+ssth**2-2D0*slth**2*ssth**2)
      AAABR(4367) = EE**2/MW**2*Ml/SW**2/cb**2*(slth**2+ssth
     &      **2-2D0*slth**2*ssth**2)
      AAABR(4368) = EE**2/MW**2*Ms/SW**2/cb**2*(slth**2+ssth
     &      **2-2D0*slth**2*ssth**2)
      AAABR(4369) = EE**2/SW**2/cb**2*ssth**2*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4370) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-ssth**2+6D0*sb**2*seth**2+sb**2*ssth
     &      **2+3D0*seth**2*ssth**2-3D0*sb**2*seth**2*ssth
     &      **2)
      AAABR(4371) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *seth**2-ssth**2+6D0*sb**2*seth**2+sb**2*ssth
     &      **2+3D0*seth**2*ssth**2-3D0*sb**2*seth**2*ssth
     &      **2)
      AAABR(4372) = EE**2/SW**2/cb**2*sbth**2*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4373) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*seth**2+sb**2*sbth**2+6D0*sb**2*seth
     &      **2+3D0*sbth**2*seth**2-3D0*sb**2*sbth**2*seth
     &      **2)
      AAABR(4374) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*seth**2+sb**2*sbth**2+6D0*sb**2*seth
     &      **2+3D0*sbth**2*seth**2-3D0*sb**2*sbth**2*seth
     &      **2)
      AAABR(4375) = EE**2/SW**2/cb**2*sbth**2*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4376) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*slth**2+sb**2*sbth**2+6D0*sb**2*slth
     &      **2+3D0*sbth**2*slth**2-3D0*sb**2*sbth**2*slth
     &      **2)
      AAABR(4377) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*slth**2+sb**2*sbth**2+6D0*sb**2*slth
     &      **2+3D0*sbth**2*slth**2-3D0*sb**2*sbth**2*slth
     &      **2)
      AAABR(4378) = EE**2/SW**2/cb**2*ssth**2*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4379) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *slth**2-ssth**2+6D0*sb**2*slth**2+sb**2*ssth
     &      **2+3D0*slth**2*ssth**2-3D0*sb**2*slth**2*ssth
     &      **2)
      AAABR(4380) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *slth**2-ssth**2+6D0*sb**2*slth**2+sb**2*ssth
     &      **2+3D0*slth**2*ssth**2-3D0*sb**2*slth**2*ssth
     &      **2)
      AAABR(4381) = EE**2/SW**2/cb**2*sbth**2*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4382) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*smuth**2+sb**2*sbth**2+6D0*sb**2*smuth
     &      **2+3D0*sbth**2*smuth**2-3D0*sb**2*sbth**2*smuth
     &      **2)
      AAABR(4383) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sbth
     &      **2-6D0*smuth**2+sb**2*sbth**2+6D0*sb**2*smuth
     &      **2+3D0*sbth**2*smuth**2-3D0*sb**2*sbth**2*smuth
     &      **2)
      AAABR(4384) = EE**2/SW**2/cb**2*ssth**2*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4385) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-6D0
     &      *smuth**2-ssth**2+6D0*sb**2*smuth**2+sb**2*ssth
     &      **2+3D0*smuth**2*ssth**2-3D0*sb**2*smuth**2*ssth
     &      **2)
      AAABR(4386) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-6D0
     &      *smuth**2-ssth**2+6D0*sb**2*smuth**2+sb**2*ssth
     &      **2+3D0*smuth**2*ssth**2-3D0*sb**2*smuth**2*ssth
     &      **2)
      AAABR(4387) = EE**2/SW**2/cb**2*sdth**2*(1D0-sb**2
     &      -slth**2+sb**2*slth**2)
      AAABR(4388) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*slth**2+sb**2*sdth**2+6D0*sb**2*slth
     &      **2+3D0*sdth**2*slth**2-3D0*sb**2*sdth**2*slth
     &      **2)
      AAABR(4389) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*slth**2+sb**2*sdth**2+6D0*sb**2*slth
     &      **2+3D0*sdth**2*slth**2-3D0*sb**2*sdth**2*slth
     &      **2)
      AAABR(4390) = EE**2/SW**2/cb**2*sdth**2*(1D0-sb**2
     &      -smuth**2+sb**2*smuth**2)
      AAABR(4391) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*smuth**2+sb**2*sdth**2+6D0*sb**2*smuth
     &      **2+3D0*sdth**2*smuth**2-3D0*sb**2*sdth**2*smuth
     &      **2)
      AAABR(4392) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*smuth**2+sb**2*sdth**2+6D0*sb**2*smuth
     &      **2+3D0*sdth**2*smuth**2-3D0*sb**2*sdth**2*smuth
     &      **2)
      AAABR(4393) = EE**2/SW**2/cb**2*sdth**2*(1D0-sb**2
     &      -seth**2+sb**2*seth**2)
      AAABR(4394) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*seth**2+sb**2*sdth**2+6D0*sb**2*seth
     &      **2+3D0*sdth**2*seth**2-3D0*sb**2*sdth**2*seth
     &      **2)
      AAABR(4395) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sdth
     &      **2-6D0*seth**2+sb**2*sdth**2+6D0*sb**2*seth
     &      **2+3D0*sdth**2*seth**2-3D0*sb**2*sdth**2*seth
     &      **2)
      AAABR(4396) = EE**2/cb**2*(2D0*Me/MW**2*Ms/SW**2+ceth
     &      /CW**2*csth*seth*ssth-2D0*Me/MW**2*Ms/SW**2*seth
     &      **2-2D0*Me/MW**2*Ms/SW**2*ssth**2+ceth/SW**2
     &      *csth*seth*ssth-ceth/CW**2*csth*sb**2*seth*ssth
     &      +4D0*Me/MW**2*Ms/SW**2*seth**2*ssth**2-ceth/SW
     &      **2*csth*sb**2*seth*ssth)
      AAABR(4397) = EE**2/MW**2*Me*Ms/SW**2/cb**2*(1D0-seth
     &      **2-ssth**2+2D0*seth**2*ssth**2)
      AAABR(4398) = EE**2/MW**2*Me*Ms/SW**2/cb**2*sb**2*(1D0
     &      -seth**2-ssth**2+2D0*seth**2*ssth**2)
      AAABR(4399) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-seth
     &      **2-ssth**2+2D0*seth**2*ssth**2)
      AAABR(4400) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-seth
     &      **2-ssth**2+2D0*seth**2*ssth**2)
      AAABR(4401) = EE**2/cb**2*(2D0*Md/MW**2*Ml/SW**2+cdth
     &      /CW**2*clth*sdth*slth-2D0*Md/MW**2*Ml/SW**2*sdth
     &      **2-2D0*Md/MW**2*Ml/SW**2*slth**2+cdth/SW**2
     &      *clth*sdth*slth-cdth/CW**2*clth*sb**2*sdth*slth
     &      +4D0*Md/MW**2*Ml/SW**2*sdth**2*slth**2-cdth/SW
     &      **2*clth*sb**2*sdth*slth)
      AAABR(4402) = EE**2/MW**2*Md*Ml/SW**2/cb**2*(1D0-sdth
     &      **2-slth**2+2D0*sdth**2*slth**2)
      AAABR(4403) = EE**2/MW**2*Md*Ml/SW**2/cb**2*sb**2*(1D0
     &      -sdth**2-slth**2+2D0*sdth**2*slth**2)
      AAABR(4404) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-sdth
     &      **2-slth**2+2D0*sdth**2*slth**2)
      AAABR(4405) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-sdth
     &      **2-slth**2+2D0*sdth**2*slth**2)
      AAABR(4406) = EE**2/cb**2*(2D0*Ml/MW**2*Ms/SW**2+clth
     &      /CW**2*csth*slth*ssth-2D0*Ml/MW**2*Ms/SW**2*slth
     &      **2-2D0*Ml/MW**2*Ms/SW**2*ssth**2+clth/SW**2
     &      *csth*slth*ssth-clth/CW**2*csth*sb**2*slth*ssth
     &      +4D0*Ml/MW**2*Ms/SW**2*slth**2*ssth**2-clth/SW
     &      **2*csth*sb**2*slth*ssth)
      AAABR(4407) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*(1D0-slth
     &      **2-ssth**2+2D0*slth**2*ssth**2)
      AAABR(4408) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*sb**2*(1D0
     &      -slth**2-ssth**2+2D0*slth**2*ssth**2)
      AAABR(4409) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-slth
     &      **2-ssth**2+2D0*slth**2*ssth**2)
      AAABR(4410) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-slth
     &      **2-ssth**2+2D0*slth**2*ssth**2)
      AAABR(4411) = EE**2/cb**2*(2D0*Mb/MW**2*Ml/SW**2+cbth
     &      /CW**2*clth*sbth*slth-2D0*Mb/MW**2*Ml/SW**2*sbth
     &      **2-2D0*Mb/MW**2*Ml/SW**2*slth**2+cbth/SW**2
     &      *clth*sbth*slth-cbth/CW**2*clth*sb**2*sbth*slth
     &      +4D0*Mb/MW**2*Ml/SW**2*sbth**2*slth**2-cbth/SW
     &      **2*clth*sb**2*sbth*slth)
      AAABR(4412) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*(1D0-sbth
     &      **2-slth**2+2D0*sbth**2*slth**2)
      AAABR(4413) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2-slth**2+2D0*sbth**2*slth**2)
      AAABR(4414) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-sbth
     &      **2-slth**2+2D0*sbth**2*slth**2)
      AAABR(4415) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-sbth
     &      **2-slth**2+2D0*sbth**2*slth**2)
      AAABR(4416) = EE**2/cb**2*(2D0*Md/MW**2*Me/SW**2+cdth
     &      /CW**2*ceth*sdth*seth-2D0*Md/MW**2*Me/SW**2*sdth
     &      **2-2D0*Md/MW**2*Me/SW**2*seth**2+cdth/SW**2
     &      *ceth*sdth*seth-cdth/CW**2*ceth*sb**2*sdth*seth
     &      +4D0*Md/MW**2*Me/SW**2*sdth**2*seth**2-cdth/SW
     &      **2*ceth*sb**2*sdth*seth)
      AAABR(4417) = EE**2/MW**2*Md*Me/SW**2/cb**2*(1D0-sdth
     &      **2-seth**2+2D0*sdth**2*seth**2)
      AAABR(4418) = EE**2/MW**2*Md*Me/SW**2/cb**2*sb**2*(1D0
     &      -sdth**2-seth**2+2D0*sdth**2*seth**2)
      AAABR(4419) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-sdth
     &      **2-seth**2+2D0*sdth**2*seth**2)
      AAABR(4420) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-sdth
     &      **2-seth**2+2D0*sdth**2*seth**2)
      AAABR(4421) = EE**2/cb**2*(2D0*Mb/MW**2*Me/SW**2+cbth
     &      /CW**2*ceth*sbth*seth-2D0*Mb/MW**2*Me/SW**2*sbth
     &      **2-2D0*Mb/MW**2*Me/SW**2*seth**2+cbth/SW**2
     &      *ceth*sbth*seth-cbth/CW**2*ceth*sb**2*sbth*seth
     &      +4D0*Mb/MW**2*Me/SW**2*sbth**2*seth**2-cbth/SW
     &      **2*ceth*sb**2*sbth*seth)
      AAABR(4422) = EE**2/MW**2*Mb*Me/SW**2/cb**2*(1D0-sbth
     &      **2-seth**2+2D0*sbth**2*seth**2)
      AAABR(4423) = EE**2/MW**2*Mb*Me/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2-seth**2+2D0*sbth**2*seth**2)
      AAABR(4424) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-sbth
     &      **2-seth**2+2D0*sbth**2*seth**2)
      AAABR(4425) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-sbth
     &      **2-seth**2+2D0*sbth**2*seth**2)
      AAABR(4426) = EE**2/cb**2*(2D0*Mm/MW**2*Ms/SW**2+cmuth
     &      /CW**2*csth*smuth*ssth-2D0*Mm/MW**2*Ms/SW**2
     &      *smuth**2-2D0*Mm/MW**2*Ms/SW**2*ssth**2+cmuth
     &      /SW**2*csth*smuth*ssth-cmuth/CW**2*csth*sb**2
     &      *smuth*ssth+4D0*Mm/MW**2*Ms/SW**2*smuth**2*ssth
     &      **2-cmuth/SW**2*csth*sb**2*smuth*ssth)
      AAABR(4427) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*(1D0-smuth
     &      **2-ssth**2+2D0*smuth**2*ssth**2)
      AAABR(4428) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*sb**2*(1D0
     &      -smuth**2-ssth**2+2D0*smuth**2*ssth**2)
      AAABR(4429) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-smuth
     &      **2-ssth**2+2D0*smuth**2*ssth**2)
      AAABR(4430) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-smuth
     &      **2-ssth**2+2D0*smuth**2*ssth**2)
      AAABR(4431) = EE**2/cb**2*(2D0*Md/MW**2*Mm/SW**2+cdth
     &      /CW**2*cmuth*sdth*smuth-2D0*Md/MW**2*Mm/SW**2
     &      *sdth**2-2D0*Md/MW**2*Mm/SW**2*smuth**2+cdth
     &      /SW**2*cmuth*sdth*smuth-cdth/CW**2*cmuth*sb**2
     &      *sdth*smuth+4D0*Md/MW**2*Mm/SW**2*sdth**2*smuth
     &      **2-cdth/SW**2*cmuth*sb**2*sdth*smuth)
      AAABR(4432) = EE**2/MW**2*Md*Mm/SW**2/cb**2*(1D0-sdth
     &      **2-smuth**2+2D0*sdth**2*smuth**2)
      AAABR(4433) = EE**2/MW**2*Md*Mm/SW**2/cb**2*sb**2*(1D0
     &      -sdth**2-smuth**2+2D0*sdth**2*smuth**2)
      AAABR(4434) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-sdth
     &      **2-smuth**2+2D0*sdth**2*smuth**2)
      AAABR(4435) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-sdth
     &      **2-smuth**2+2D0*sdth**2*smuth**2)
      AAABR(4436) = EE**2/cb**2*(2D0*Mb/MW**2*Mm/SW**2+cbth
     &      /CW**2*cmuth*sbth*smuth-2D0*Mb/MW**2*Mm/SW**2
     &      *sbth**2-2D0*Mb/MW**2*Mm/SW**2*smuth**2+cbth
     &      /SW**2*cmuth*sbth*smuth-cbth/CW**2*cmuth*sb**2
     &      *sbth*smuth+4D0*Mb/MW**2*Mm/SW**2*sbth**2*smuth
     &      **2-cbth/SW**2*cmuth*sb**2*sbth*smuth)
      AAABR(4437) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*(1D0-sbth
     &      **2-smuth**2+2D0*sbth**2*smuth**2)
      AAABR(4438) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2-smuth**2+2D0*sbth**2*smuth**2)
      AAABR(4439) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-sbth
     &      **2-smuth**2+2D0*sbth**2*smuth**2)
      AAABR(4440) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-sbth
     &      **2-smuth**2+2D0*sbth**2*smuth**2)
      AAABR(4441) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sdth**2/CW**2-6D0*slth**2/CW**2+2D0*sb**2
     &      /CW**2*sdth**2+6D0*sb**2/CW**2*slth**2+3D0*sdth
     &      **2/CW**2*slth**2+3D0*sdth**2/SW**2*slth**2-3D0
     &      *sb**2/CW**2*sdth**2*slth**2-3D0*sb**2/SW**2
     &      *sdth**2*slth**2+12D0*Md/MW**2*Ml/SW**2*cdth
     &      *clth*sdth*slth)
      AAABR(4442) = EE**2/SW**2/cb**2*clth*sdth**2*slth*(1D0
     &      -sb**2)
      AAABR(4443) = EE**2/CW**2/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4444) = EE**2/CW**3*SW/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4445) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*smuth**2/CW**2-2D0*ssth**2/CW**2+6D0*sb
     &      **2/CW**2*smuth**2+2D0*sb**2/CW**2*ssth**2+3D0
     &      *smuth**2/CW**2*ssth**2+3D0*smuth**2/SW**2*ssth
     &      **2-3D0*sb**2/CW**2*smuth**2*ssth**2-3D0*sb**2
     &      /SW**2*smuth**2*ssth**2+12D0*Mm/MW**2*Ms/SW**2
     &      *cmuth*csth*smuth*ssth)
      AAABR(4446) = EE**2/SW**2/cb**2*cmuth*smuth*ssth**2
     &      *(1D0-sb**2)
      AAABR(4447) = EE**2/CW**2/cb**2*cmuth*smuth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4448) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(2D0
     &      -2D0*sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4449) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sdth**2/CW**2-6D0*smuth**2/CW**2+2D0*sb
     &      **2/CW**2*sdth**2+6D0*sb**2/CW**2*smuth**2+3D0
     &      *sdth**2/CW**2*smuth**2+3D0*sdth**2/SW**2*smuth
     &      **2-3D0*sb**2/CW**2*sdth**2*smuth**2-3D0*sb**2
     &      /SW**2*sdth**2*smuth**2+12D0*Md/MW**2*Mm/SW**2
     &      *cdth*cmuth*sdth*smuth)
      AAABR(4450) = EE**2/SW**2/cb**2*cmuth*sdth**2*smuth
     &      *(1D0-sb**2)
      AAABR(4451) = EE**2/CW**2/cb**2*cmuth*smuth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4452) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(2D0
     &      -2D0*sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4453) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*seth**2/CW**2-2D0*ssth**2/CW**2+6D0*sb**2
     &      /CW**2*seth**2+2D0*sb**2/CW**2*ssth**2+3D0*seth
     &      **2/CW**2*ssth**2+3D0*seth**2/SW**2*ssth**2-3D0
     &      *sb**2/CW**2*seth**2*ssth**2-3D0*sb**2/SW**2
     &      *seth**2*ssth**2+12D0*Me/MW**2*Ms/SW**2*ceth
     &      *csth*seth*ssth)
      AAABR(4454) = EE**2/SW**2/cb**2*ceth*seth*ssth**2*(1D0
     &      -sb**2)
      AAABR(4455) = EE**2/CW**2/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4456) = EE**2/CW**3*SW/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4457) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sbth**2/CW**2-6D0*smuth**2/CW**2+2D0*sb
     &      **2/CW**2*sbth**2+6D0*sb**2/CW**2*smuth**2+3D0
     &      *sbth**2/CW**2*smuth**2+3D0*sbth**2/SW**2*smuth
     &      **2-3D0*sb**2/CW**2*sbth**2*smuth**2-3D0*sb**2
     &      /SW**2*sbth**2*smuth**2+12D0*Mb/MW**2*Mm/SW**2
     &      *cbth*cmuth*sbth*smuth)
      AAABR(4458) = EE**2/SW**2/cb**2*cmuth*sbth**2*smuth
     &      *(1D0-sb**2)
      AAABR(4459) = EE**2/CW**2/cb**2*cmuth*smuth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4460) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(2D0
     &      -2D0*sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4461) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -6D0*slth**2/CW**2-2D0*ssth**2/CW**2+6D0*sb**2
     &      /CW**2*slth**2+2D0*sb**2/CW**2*ssth**2+3D0*slth
     &      **2/CW**2*ssth**2+3D0*slth**2/SW**2*ssth**2-3D0
     &      *sb**2/CW**2*slth**2*ssth**2-3D0*sb**2/SW**2
     &      *slth**2*ssth**2+12D0*Ml/MW**2*Ms/SW**2*clth
     &      *csth*slth*ssth)
      AAABR(4462) = EE**2/SW**2/cb**2*clth*slth*ssth**2*(1D0
     &      -sb**2)
      AAABR(4463) = EE**2/CW**2/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4464) = EE**2/CW**3*SW/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(4465) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sbth**2/CW**2-6D0*slth**2/CW**2+2D0*sb**2
     &      /CW**2*sbth**2+6D0*sb**2/CW**2*slth**2+3D0*sbth
     &      **2/CW**2*slth**2+3D0*sbth**2/SW**2*slth**2-3D0
     &      *sb**2/CW**2*sbth**2*slth**2-3D0*sb**2/SW**2
     &      *sbth**2*slth**2+12D0*Mb/MW**2*Ml/SW**2*cbth
     &      *clth*sbth*slth)
      AAABR(4466) = EE**2/SW**2/cb**2*clth*sbth**2*slth*(1D0
     &      -sb**2)
      AAABR(4467) = EE**2/CW**2/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4468) = EE**2/CW**3*SW/cb**2*clth*slth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4469) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sdth**2/CW**2-6D0*seth**2/CW**2+2D0*sb**2
     &      /CW**2*sdth**2+6D0*sb**2/CW**2*seth**2+3D0*sdth
     &      **2/CW**2*seth**2+3D0*sdth**2/SW**2*seth**2-3D0
     &      *sb**2/CW**2*sdth**2*seth**2-3D0*sb**2/SW**2
     &      *sdth**2*seth**2+12D0*Md/MW**2*Me/SW**2*cdth
     &      *ceth*sdth*seth)
      AAABR(4470) = EE**2/SW**2/cb**2*ceth*sdth**2*seth*(1D0
     &      -sb**2)
      AAABR(4471) = EE**2/CW**2/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4472) = EE**2/CW**3*SW/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(4473) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sbth**2/CW**2-6D0*seth**2/CW**2+2D0*sb**2
     &      /CW**2*sbth**2+6D0*sb**2/CW**2*seth**2+3D0*sbth
     &      **2/CW**2*seth**2+3D0*sbth**2/SW**2*seth**2-3D0
     &      *sb**2/CW**2*sbth**2*seth**2-3D0*sb**2/SW**2
     &      *sbth**2*seth**2+12D0*Mb/MW**2*Me/SW**2*cbth
     &      *ceth*sbth*seth)
      AAABR(4474) = EE**2/SW**2/cb**2*ceth*sbth**2*seth*(1D0
     &      -sb**2)
      AAABR(4475) = EE**2/CW**2/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4476) = EE**2/CW**3*SW/cb**2*ceth*seth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(4477) = EE**2*(1D0/CW**2+3D0/SW**2-5D0*scth**2
     &      /CW**2-3D0*slth**2/CW**2-3D0*scth**2/SW**2-3D0
     &      *slth**2/SW**2+15D0*scth**2/CW**2*slth**2+3D0
     &      *scth**2/SW**2*slth**2)
      AAABR(4478) = EE**2*clth*slth*(1D0/CW**2+1D0/SW**2
     &      -5D0*scth**2/CW**2-scth**2/SW**2)
      AAABR(4479) = EE**2/SW**2*(1D0-scth**2-slth**2+scth
     &      **2*slth**2)
      AAABR(4480) = EE**2*ccth*scth*(5D0/CW**2+3D0/SW**2
     &      -15D0*slth**2/CW**2-3D0*slth**2/SW**2)
      AAABR(4481) = EE**2/CW**2*(1D0-5D0*scth**2-3D0*slth
     &      **2+15D0*scth**2*slth**2)
      AAABR(4482) = EE**2/CW**3*SW*(1D0-5D0*scth**2-3D0*slth
     &      **2+15D0*scth**2*slth**2)
      AAABR(4483) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*seth**2
     &      /CW**2-5D0*stth**2/CW**2-3D0*seth**2/SW**2-3D0
     &      *stth**2/SW**2+15D0*seth**2/CW**2*stth**2+3D0
     &      *seth**2/SW**2*stth**2)
      AAABR(4484) = EE**2*ceth*seth*(1D0/CW**2+1D0/SW**2
     &      -5D0*stth**2/CW**2-stth**2/SW**2)
      AAABR(4485) = EE**2/SW**2*(1D0-seth**2-stth**2+seth
     &      **2*stth**2)
      AAABR(4486) = EE**2*ctth*stth*(5D0/CW**2+3D0/SW**2
     &      -15D0*seth**2/CW**2-3D0*seth**2/SW**2)
      AAABR(4487) = EE**2/CW**2*(1D0-3D0*seth**2-5D0*stth
     &      **2+15D0*seth**2*stth**2)
      AAABR(4488) = EE**2/CW**3*SW*(1D0-3D0*seth**2-5D0*stth
     &      **2+15D0*seth**2*stth**2)
      AAABR(4489) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*seth**2
     &      /CW**2-5D0*suth**2/CW**2-3D0*seth**2/SW**2-3D0
     &      *suth**2/SW**2+15D0*seth**2/CW**2*suth**2+3D0
     &      *seth**2/SW**2*suth**2)
      AAABR(4490) = EE**2*ceth*seth*(1D0/CW**2+1D0/SW**2
     &      -5D0*suth**2/CW**2-suth**2/SW**2)
      AAABR(4491) = EE**2/SW**2*(1D0-seth**2-suth**2+seth
     &      **2*suth**2)
      AAABR(4492) = EE**2*cuth*suth*(5D0/CW**2+3D0/SW**2
     &      -15D0*seth**2/CW**2-3D0*seth**2/SW**2)
      AAABR(4493) = EE**2/CW**2*(1D0-3D0*seth**2-5D0*suth
     &      **2+15D0*seth**2*suth**2)
      AAABR(4494) = EE**2/CW**3*SW*(1D0-3D0*seth**2-5D0*suth
     &      **2+15D0*seth**2*suth**2)
      AAABR(4495) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*smuth
     &      **2/CW**2-5D0*suth**2/CW**2-3D0*smuth**2/SW**2
     &      -3D0*suth**2/SW**2+15D0*smuth**2/CW**2*suth**2
     &      +3D0*smuth**2/SW**2*suth**2)
      AAABR(4496) = EE**2*cmuth*smuth*(1D0/CW**2+1D0/SW**2
     &      -5D0*suth**2/CW**2-suth**2/SW**2)
      AAABR(4497) = EE**2/SW**2*(1D0-smuth**2-suth**2+smuth
     &      **2*suth**2)
      AAABR(4498) = EE**2*cuth*suth*(5D0/CW**2+3D0/SW**2
     &      -15D0*smuth**2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4499) = EE**2/CW**2*(1D0-3D0*smuth**2-5D0*suth
     &      **2+15D0*smuth**2*suth**2)
      AAABR(4500) = EE**2/CW**3*SW*(1D0-3D0*smuth**2-5D0
     &      *suth**2+15D0*smuth**2*suth**2)
      AAABR(4501) = EE**2*(1D0/CW**2+3D0/SW**2-5D0*scth**2
     &      /CW**2-3D0*smuth**2/CW**2-3D0*scth**2/SW**2-3D0
     &      *smuth**2/SW**2+15D0*scth**2/CW**2*smuth**2+3D0
     &      *scth**2/SW**2*smuth**2)
      AAABR(4502) = EE**2*cmuth*smuth*(1D0/CW**2+1D0/SW**2
     &      -5D0*scth**2/CW**2-scth**2/SW**2)
      AAABR(4503) = EE**2/SW**2*(1D0-scth**2-smuth**2+scth
     &      **2*smuth**2)
      AAABR(4504) = EE**2*ccth*scth*(5D0/CW**2+3D0/SW**2
     &      -15D0*smuth**2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4505) = EE**2/CW**2*(1D0-5D0*scth**2-3D0*smuth
     &      **2+15D0*scth**2*smuth**2)
      AAABR(4506) = EE**2/CW**3*SW*(1D0-5D0*scth**2-3D0*smuth
     &      **2+15D0*scth**2*smuth**2)
      AAABR(4507) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*smuth
     &      **2/CW**2-5D0*stth**2/CW**2-3D0*smuth**2/SW**2
     &      -3D0*stth**2/SW**2+15D0*smuth**2/CW**2*stth**2
     &      +3D0*smuth**2/SW**2*stth**2)
      AAABR(4508) = EE**2*cmuth*smuth*(1D0/CW**2+1D0/SW**2
     &      -5D0*stth**2/CW**2-stth**2/SW**2)
      AAABR(4509) = EE**2/SW**2*(1D0-smuth**2-stth**2+smuth
     &      **2*stth**2)
      AAABR(4510) = EE**2*ctth*stth*(5D0/CW**2+3D0/SW**2
     &      -15D0*smuth**2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4511) = EE**2/CW**2*(1D0-3D0*smuth**2-5D0*stth
     &      **2+15D0*smuth**2*stth**2)
      AAABR(4512) = EE**2/CW**3*SW*(1D0-3D0*smuth**2-5D0
     &      *stth**2+15D0*smuth**2*stth**2)
      AAABR(4513) = EE**2*(1D0/CW**2+3D0/SW**2-5D0*scth**2
     &      /CW**2-3D0*seth**2/CW**2-3D0*scth**2/SW**2-3D0
     &      *seth**2/SW**2+15D0*scth**2/CW**2*seth**2+3D0
     &      *scth**2/SW**2*seth**2)
      AAABR(4514) = EE**2*ceth*seth*(1D0/CW**2+1D0/SW**2
     &      -5D0*scth**2/CW**2-scth**2/SW**2)
      AAABR(4515) = EE**2/SW**2*(1D0-scth**2-seth**2+scth
     &      **2*seth**2)
      AAABR(4516) = EE**2*ccth*scth*(5D0/CW**2+3D0/SW**2
     &      -15D0*seth**2/CW**2-3D0*seth**2/SW**2)
      AAABR(4517) = EE**2/CW**2*(1D0-5D0*scth**2-3D0*seth
     &      **2+15D0*scth**2*seth**2)
      AAABR(4518) = EE**2/CW**3*SW*(1D0-5D0*scth**2-3D0*seth
     &      **2+15D0*scth**2*seth**2)
      AAABR(4519) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*slth**2
     &      /CW**2-5D0*suth**2/CW**2-3D0*slth**2/SW**2-3D0
     &      *suth**2/SW**2+15D0*slth**2/CW**2*suth**2+3D0
     &      *slth**2/SW**2*suth**2)
      AAABR(4520) = EE**2*clth*slth*(1D0/CW**2+1D0/SW**2
     &      -5D0*suth**2/CW**2-suth**2/SW**2)
      AAABR(4521) = EE**2/SW**2*(1D0-slth**2-suth**2+slth
     &      **2*suth**2)
      AAABR(4522) = EE**2*cuth*suth*(5D0/CW**2+3D0/SW**2
     &      -15D0*slth**2/CW**2-3D0*slth**2/SW**2)
      AAABR(4523) = EE**2/CW**2*(1D0-3D0*slth**2-5D0*suth
     &      **2+15D0*slth**2*suth**2)
      AAABR(4524) = EE**2/CW**3*SW*(1D0-3D0*slth**2-5D0*suth
     &      **2+15D0*slth**2*suth**2)
      AAABR(4525) = EE**2*(1D0/CW**2+3D0/SW**2-3D0*slth**2
     &      /CW**2-5D0*stth**2/CW**2-3D0*slth**2/SW**2-3D0
     &      *stth**2/SW**2+15D0*slth**2/CW**2*stth**2+3D0
     &      *slth**2/SW**2*stth**2)
      AAABR(4526) = EE**2*clth*slth*(1D0/CW**2+1D0/SW**2
     &      -5D0*stth**2/CW**2-stth**2/SW**2)
      AAABR(4527) = EE**2/SW**2*(1D0-slth**2-stth**2+slth
     &      **2*stth**2)
      AAABR(4528) = EE**2*ctth*stth*(5D0/CW**2+3D0/SW**2
     &      -15D0*slth**2/CW**2-3D0*slth**2/SW**2)
      AAABR(4529) = EE**2/CW**2*(1D0-3D0*slth**2-5D0*stth
     &      **2+15D0*slth**2*stth**2)
      AAABR(4530) = EE**2/CW**3*SW*(1D0-3D0*slth**2-5D0*stth
     &      **2+15D0*slth**2*stth**2)
      AAABR(4531) = EE**2*clth*ctth*slth*stth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4532) = EE**2/SW**2*ctth*stth*(1D0-slth**2)
      AAABR(4533) = EE**2*(4D0/CW**2-12D0*slth**2/CW**2-5D0
     &      *stth**2/CW**2-3D0*stth**2/SW**2+15D0*slth**2
     &      /CW**2*stth**2+3D0*slth**2/SW**2*stth**2)
      AAABR(4534) = EE**2/CW**2*ctth*stth*(1D0-3D0*slth**2)
      AAABR(4535) = EE**2/CW**3*SW*ctth*stth*(1D0-3D0*slth
     &      **2)
      AAABR(4536) = EE**2*ceth*cuth*seth*suth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4537) = EE**2/SW**2*cuth*suth*(1D0-seth**2)
      AAABR(4538) = EE**2*(4D0/CW**2-12D0*seth**2/CW**2-5D0
     &      *suth**2/CW**2-3D0*suth**2/SW**2+15D0*seth**2
     &      /CW**2*suth**2+3D0*seth**2/SW**2*suth**2)
      AAABR(4539) = EE**2/CW**2*cuth*suth*(1D0-3D0*seth**2)
      AAABR(4540) = EE**2/CW**3*SW*cuth*suth*(1D0-3D0*seth
     &      **2)
      AAABR(4541) = EE**2*clth*cuth*slth*suth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4542) = EE**2/SW**2*cuth*suth*(1D0-slth**2)
      AAABR(4543) = EE**2*(4D0/CW**2-12D0*slth**2/CW**2-5D0
     &      *suth**2/CW**2-3D0*suth**2/SW**2+15D0*slth**2
     &      /CW**2*suth**2+3D0*slth**2/SW**2*suth**2)
      AAABR(4544) = EE**2/CW**2*cuth*suth*(1D0-3D0*slth**2)
      AAABR(4545) = EE**2/CW**3*SW*cuth*suth*(1D0-3D0*slth
     &      **2)
      AAABR(4546) = EE**2*ccth*clth*scth*slth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4547) = EE**2/SW**2*ccth*scth*(1D0-slth**2)
      AAABR(4548) = EE**2*(4D0/CW**2-5D0*scth**2/CW**2-12D0
     &      *slth**2/CW**2-3D0*scth**2/SW**2+15D0*scth**2
     &      /CW**2*slth**2+3D0*scth**2/SW**2*slth**2)
      AAABR(4549) = EE**2/CW**2*ccth*scth*(1D0-3D0*slth**2)
      AAABR(4550) = EE**2/CW**3*SW*ccth*scth*(1D0-3D0*slth
     &      **2)
      AAABR(4551) = EE**2*ceth*ctth*seth*stth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4552) = EE**2/SW**2*ctth*stth*(1D0-seth**2)
      AAABR(4553) = EE**2*(4D0/CW**2-12D0*seth**2/CW**2-5D0
     &      *stth**2/CW**2-3D0*stth**2/SW**2+15D0*seth**2
     &      /CW**2*stth**2+3D0*seth**2/SW**2*stth**2)
      AAABR(4554) = EE**2/CW**2*ctth*stth*(1D0-3D0*seth**2)
      AAABR(4555) = EE**2/CW**3*SW*ctth*stth*(1D0-3D0*seth
     &      **2)
      AAABR(4556) = EE**2*cmuth*ctth*smuth*stth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4557) = EE**2/SW**2*ctth*stth*(1D0-smuth**2)
      AAABR(4558) = EE**2*(4D0/CW**2-12D0*smuth**2/CW**2
     &      -5D0*stth**2/CW**2-3D0*stth**2/SW**2+15D0*smuth
     &      **2/CW**2*stth**2+3D0*smuth**2/SW**2*stth**2)
      AAABR(4559) = EE**2/CW**2*ctth*stth*(1D0-3D0*smuth**2)
      AAABR(4560) = EE**2/CW**3*SW*ctth*stth*(1D0-3D0*smuth
     &      **2)
      AAABR(4561) = EE**2*ccth*cmuth*scth*smuth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4562) = EE**2/SW**2*ccth*scth*(1D0-smuth**2)
      AAABR(4563) = EE**2*(4D0/CW**2-5D0*scth**2/CW**2-12D0
     &      *smuth**2/CW**2-3D0*scth**2/SW**2+15D0*scth**2
     &      /CW**2*smuth**2+3D0*scth**2/SW**2*smuth**2)
      AAABR(4564) = EE**2/CW**2*ccth*scth*(1D0-3D0*smuth**2)
      AAABR(4565) = EE**2/CW**3*SW*ccth*scth*(1D0-3D0*smuth
     &      **2)
      AAABR(4566) = EE**2*ccth*ceth*scth*seth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4567) = EE**2/SW**2*ccth*scth*(1D0-seth**2)
      AAABR(4568) = EE**2*(4D0/CW**2-5D0*scth**2/CW**2-12D0
     &      *seth**2/CW**2-3D0*scth**2/SW**2+15D0*scth**2
     &      /CW**2*seth**2+3D0*scth**2/SW**2*seth**2)
      AAABR(4569) = EE**2/CW**2*ccth*scth*(1D0-3D0*seth**2)
      AAABR(4570) = EE**2/CW**3*SW*ccth*scth*(1D0-3D0*seth
     &      **2)
      AAABR(4571) = EE**2*cmuth*cuth*smuth*suth*(5D0/CW**2
     &      +1D0/SW**2)
      AAABR(4572) = EE**2/SW**2*cuth*suth*(1D0-smuth**2)
      AAABR(4573) = EE**2*(4D0/CW**2-12D0*smuth**2/CW**2
     &      -5D0*suth**2/CW**2-3D0*suth**2/SW**2+15D0*smuth
     &      **2/CW**2*suth**2+3D0*smuth**2/SW**2*suth**2)
      AAABR(4574) = EE**2/CW**2*cuth*suth*(1D0-3D0*smuth**2)
      AAABR(4575) = EE**2/CW**3*SW*cuth*suth*(1D0-3D0*smuth
     &      **2)
      AAABR(4576) = EE**2*(2D0/CW**2-3D0*slth**2/CW**2-10D0
     &      *stth**2/CW**2-3D0*slth**2/SW**2+15D0*slth**2
     &      /CW**2*stth**2+3D0*slth**2/SW**2*stth**2)
      AAABR(4577) = EE**2/SW**2*clth*slth*(1D0-stth**2)
      AAABR(4578) = EE**2/CW**2*clth*slth*(1D0-5D0*stth**2)
      AAABR(4579) = EE**2/CW**3*SW*clth*slth*(1D0-5D0*stth
     &      **2)
      AAABR(4580) = EE**2*(2D0/CW**2-3D0*seth**2/CW**2-10D0
     &      *stth**2/CW**2-3D0*seth**2/SW**2+15D0*seth**2
     &      /CW**2*stth**2+3D0*seth**2/SW**2*stth**2)
      AAABR(4581) = EE**2/SW**2*ceth*seth*(1D0-stth**2)
      AAABR(4582) = EE**2/CW**2*ceth*seth*(1D0-5D0*stth**2)
      AAABR(4583) = EE**2/CW**3*SW*ceth*seth*(1D0-5D0*stth
     &      **2)
      AAABR(4584) = EE**2*(2D0/CW**2-3D0*smuth**2/CW**2-10D0
     &      *stth**2/CW**2-3D0*smuth**2/SW**2+15D0*smuth
     &      **2/CW**2*stth**2+3D0*smuth**2/SW**2*stth**2)
      AAABR(4585) = EE**2/SW**2*cmuth*smuth*(1D0-stth**2)
      AAABR(4586) = EE**2/CW**2*cmuth*smuth*(1D0-5D0*stth
     &      **2)
      AAABR(4587) = EE**2/CW**3*SW*cmuth*smuth*(1D0-5D0*stth
     &      **2)
      AAABR(4588) = EE**2*(2D0/CW**2-10D0*scth**2/CW**2-3D0
     &      *smuth**2/CW**2-3D0*smuth**2/SW**2+15D0*scth
     &      **2/CW**2*smuth**2+3D0*scth**2/SW**2*smuth**2)
      AAABR(4589) = EE**2/SW**2*cmuth*smuth*(1D0-scth**2)
      AAABR(4590) = EE**2/CW**2*cmuth*smuth*(1D0-5D0*scth
     &      **2)
      AAABR(4591) = EE**2/CW**3*SW*cmuth*smuth*(1D0-5D0*scth
     &      **2)
      AAABR(4592) = EE**2*(2D0/CW**2-3D0*seth**2/CW**2-10D0
     &      *suth**2/CW**2-3D0*seth**2/SW**2+15D0*seth**2
     &      /CW**2*suth**2+3D0*seth**2/SW**2*suth**2)
      AAABR(4593) = EE**2/SW**2*ceth*seth*(1D0-suth**2)
      AAABR(4594) = EE**2/CW**2*ceth*seth*(1D0-5D0*suth**2)
      AAABR(4595) = EE**2/CW**3*SW*ceth*seth*(1D0-5D0*suth
     &      **2)
      AAABR(4596) = EE**2*(2D0/CW**2-3D0*slth**2/CW**2-10D0
     &      *suth**2/CW**2-3D0*slth**2/SW**2+15D0*slth**2
     &      /CW**2*suth**2+3D0*slth**2/SW**2*suth**2)
      AAABR(4597) = EE**2/SW**2*clth*slth*(1D0-suth**2)
      AAABR(4598) = EE**2/CW**2*clth*slth*(1D0-5D0*suth**2)
      AAABR(4599) = EE**2/CW**3*SW*clth*slth*(1D0-5D0*suth
     &      **2)
      AAABR(4600) = EE**2*(2D0/CW**2-3D0*smuth**2/CW**2-10D0
     &      *suth**2/CW**2-3D0*smuth**2/SW**2+15D0*smuth
     &      **2/CW**2*suth**2+3D0*smuth**2/SW**2*suth**2)
      AAABR(4601) = EE**2/SW**2*cmuth*smuth*(1D0-suth**2)
      AAABR(4602) = EE**2/CW**2*cmuth*smuth*(1D0-5D0*suth
     &      **2)
      AAABR(4603) = EE**2/CW**3*SW*cmuth*smuth*(1D0-5D0*suth
     &      **2)
      AAABR(4604) = EE**2*(2D0/CW**2-10D0*scth**2/CW**2-3D0
     &      *seth**2/CW**2-3D0*seth**2/SW**2+15D0*scth**2
     &      /CW**2*seth**2+3D0*scth**2/SW**2*seth**2)
      AAABR(4605) = EE**2/SW**2*ceth*seth*(1D0-scth**2)
      AAABR(4606) = EE**2/CW**2*ceth*seth*(1D0-5D0*scth**2)
      AAABR(4607) = EE**2/CW**3*SW*ceth*seth*(1D0-5D0*scth
     &      **2)
      AAABR(4608) = EE**2*(2D0/CW**2-10D0*scth**2/CW**2-3D0
     &      *slth**2/CW**2-3D0*slth**2/SW**2+15D0*scth**2
     &      /CW**2*slth**2+3D0*scth**2/SW**2*slth**2)
      AAABR(4609) = EE**2/SW**2*clth*slth*(1D0-scth**2)
      AAABR(4610) = EE**2/CW**2*clth*slth*(1D0-5D0*scth**2)
      AAABR(4611) = EE**2/CW**3*SW*clth*slth*(1D0-5D0*scth
     &      **2)
      AAABR(4612) = EE**2*cuth*suth*(10D0/CW**2-15D0*slth
     &      **2/CW**2-3D0*slth**2/SW**2)
      AAABR(4613) = EE**2/SW**2*clth*cuth*slth*suth
      AAABR(4614) = EE**2*clth*slth*(4D0/CW**2-5D0*suth**2
     &      /CW**2-suth**2/SW**2)
      AAABR(4615) = EE**2/CW**2*clth*cuth*slth*suth
      AAABR(4616) = EE**2/CW**3*SW*clth*cuth*slth*suth
      AAABR(4617) = EE**2*ctth*stth*(10D0/CW**2-15D0*smuth
     &      **2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4618) = EE**2/SW**2*cmuth*ctth*smuth*stth
      AAABR(4619) = EE**2*cmuth*smuth*(4D0/CW**2-5D0*stth
     &      **2/CW**2-stth**2/SW**2)
      AAABR(4620) = EE**2/CW**2*cmuth*ctth*smuth*stth
      AAABR(4621) = EE**2/CW**3*SW*cmuth*ctth*smuth*stth
      AAABR(4622) = EE**2*ctth*stth*(10D0/CW**2-15D0*seth
     &      **2/CW**2-3D0*seth**2/SW**2)
      AAABR(4623) = EE**2/SW**2*ceth*ctth*seth*stth
      AAABR(4624) = EE**2*ceth*seth*(4D0/CW**2-5D0*stth**2
     &      /CW**2-stth**2/SW**2)
      AAABR(4625) = EE**2/CW**2*ceth*ctth*seth*stth
      AAABR(4626) = EE**2/CW**3*SW*ceth*ctth*seth*stth
      AAABR(4627) = EE**2*ctth*stth*(10D0/CW**2-15D0*slth
     &      **2/CW**2-3D0*slth**2/SW**2)
      AAABR(4628) = EE**2/SW**2*clth*ctth*slth*stth
      AAABR(4629) = EE**2*clth*slth*(4D0/CW**2-5D0*stth**2
     &      /CW**2-stth**2/SW**2)
      AAABR(4630) = EE**2/CW**2*clth*ctth*slth*stth
      AAABR(4631) = EE**2/CW**3*SW*clth*ctth*slth*stth
      AAABR(4632) = EE**2*ccth*scth*(10D0/CW**2-15D0*slth
     &      **2/CW**2-3D0*slth**2/SW**2)
      AAABR(4633) = EE**2/SW**2*ccth*clth*scth*slth
      AAABR(4634) = EE**2*clth*slth*(4D0/CW**2-5D0*scth**2
     &      /CW**2-scth**2/SW**2)
      AAABR(4635) = EE**2/CW**2*ccth*clth*scth*slth
      AAABR(4636) = EE**2/CW**3*SW*ccth*clth*scth*slth
      AAABR(4637) = EE**2*cuth*suth*(10D0/CW**2-15D0*smuth
     &      **2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4638) = EE**2/SW**2*cmuth*cuth*smuth*suth
      AAABR(4639) = EE**2*cmuth*smuth*(4D0/CW**2-5D0*suth
     &      **2/CW**2-suth**2/SW**2)
      AAABR(4640) = EE**2/CW**2*cmuth*cuth*smuth*suth
      AAABR(4641) = EE**2/CW**3*SW*cmuth*cuth*smuth*suth
      AAABR(4642) = EE**2*ccth*scth*(10D0/CW**2-15D0*seth
     &      **2/CW**2-3D0*seth**2/SW**2)
      AAABR(4643) = EE**2/SW**2*ccth*ceth*scth*seth
      AAABR(4644) = EE**2*ceth*seth*(4D0/CW**2-5D0*scth**2
     &      /CW**2-scth**2/SW**2)
      AAABR(4645) = EE**2/CW**2*ccth*ceth*scth*seth
      AAABR(4646) = EE**2/CW**3*SW*ccth*ceth*scth*seth
      AAABR(4647) = EE**2*ccth*scth*(10D0/CW**2-15D0*smuth
     &      **2/CW**2-3D0*smuth**2/SW**2)
      AAABR(4648) = EE**2/SW**2*ccth*cmuth*scth*smuth
      AAABR(4649) = EE**2*cmuth*smuth*(4D0/CW**2-5D0*scth
     &      **2/CW**2-scth**2/SW**2)
      AAABR(4650) = EE**2/CW**2*ccth*cmuth*scth*smuth
      AAABR(4651) = EE**2/CW**3*SW*ccth*cmuth*scth*smuth
      AAABR(4652) = EE**2*cuth*suth*(10D0/CW**2-15D0*seth
     &      **2/CW**2-3D0*seth**2/SW**2)
      AAABR(4653) = EE**2/SW**2*ceth*cuth*seth*suth
      AAABR(4654) = EE**2*ceth*seth*(4D0/CW**2-5D0*suth**2
     &      /CW**2-suth**2/SW**2)
      AAABR(4655) = EE**2/CW**2*ceth*cuth*seth*suth
      AAABR(4656) = EE**2/CW**3*SW*ceth*cuth*seth*suth
      AAABR(4657) = EE**2/SW**2/cb**2*ccth*(clth*csth-clth
     &      *csth*sb**2+Ml/MW**2*Ms*slth*ssth)
      AAABR(4658) = EE**2/SW**2/cb**2*ccth*(csth*slth-csth
     &      *sb**2*slth-Ml/MW**2*Ms*clth*ssth)
      AAABR(4659) = EE**2/SW**2/cb**2*ccth*clth*csth*(1D0
     &      -sb**2)
      AAABR(4660) = EE**2/SW**2/cb**2*ccth*(clth*ssth-clth
     &      *sb**2*ssth-Ml/MW**2*Ms*csth*slth)
      AAABR(4661) = EE**2/SW**2/cb**2*scth*(clth*csth-clth
     &      *csth*sb**2+Ml/MW**2*Ms*slth*ssth)
      AAABR(4662) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*slth
     &      *ssth
      AAABR(4663) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*sb
     &      **2*slth*ssth
      AAABR(4664) = EE**2/MW**2*Ml/SW**2/cb**2*ccth*slth
     &      *ssth
      AAABR(4665) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*slth
     &      *ssth
      AAABR(4666) = EE**2/SW**2/cb**2*cuth*(cdth*clth-cdth
     &      *clth*sb**2+Md/MW**2*Ml*sdth*slth)
      AAABR(4667) = EE**2/SW**2/cb**2*cuth*(cdth*slth-cdth
     &      *sb**2*slth-Md/MW**2*Ml*clth*sdth)
      AAABR(4668) = EE**2/SW**2/cb**2*cdth*clth*cuth*(1D0
     &      -sb**2)
      AAABR(4669) = EE**2/SW**2/cb**2*cuth*(clth*sdth-clth
     &      *sb**2*sdth-Md/MW**2*Ml*cdth*slth)
      AAABR(4670) = EE**2/SW**2/cb**2*suth*(cdth*clth-cdth
     &      *clth*sb**2+Md/MW**2*Ml*sdth*slth)
      AAABR(4671) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cuth*sdth
     &      *slth
      AAABR(4672) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cuth*sb
     &      **2*sdth*slth
      AAABR(4673) = EE**2/MW**2*Ml/SW**2/cb**2*cuth*sdth
     &      *slth
      AAABR(4674) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sdth
     &      *slth
      AAABR(4675) = EE**2/SW**2/cb**2*ctth*(cbth*clth-cbth
     &      *clth*sb**2+Mb/MW**2*Ml*sbth*slth)
      AAABR(4676) = EE**2/SW**2/cb**2*ctth*(cbth*slth-cbth
     &      *sb**2*slth-Mb/MW**2*Ml*clth*sbth)
      AAABR(4677) = EE**2/SW**2/cb**2*cbth*clth*ctth*(1D0
     &      -sb**2)
      AAABR(4678) = EE**2/SW**2/cb**2*ctth*(clth*sbth-clth
     &      *sb**2*sbth-Mb/MW**2*Ml*cbth*slth)
      AAABR(4679) = EE**2/SW**2/cb**2*stth*(cbth*clth-cbth
     &      *clth*sb**2+Mb/MW**2*Ml*sbth*slth)
      AAABR(4680) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*ctth*sbth
     &      *slth
      AAABR(4681) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*ctth*sb
     &      **2*sbth*slth
      AAABR(4682) = EE**2/MW**2*Ml/SW**2/cb**2*ctth*sbth
     &      *slth
      AAABR(4683) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      *slth
      AAABR(4684) = EE**2/SW**2/cb**2*cuth*(cdth*cmuth-cdth
     &      *cmuth*sb**2+Md/MW**2*Mm*sdth*smuth)
      AAABR(4685) = EE**2/SW**2/cb**2*cuth*(cdth*smuth-cdth
     &      *sb**2*smuth-Md/MW**2*Mm*cmuth*sdth)
      AAABR(4686) = EE**2/SW**2/cb**2*cdth*cmuth*cuth*(1D0
     &      -sb**2)
      AAABR(4687) = EE**2/SW**2/cb**2*cuth*(cmuth*sdth-cmuth
     &      *sb**2*sdth-Md/MW**2*Mm*cdth*smuth)
      AAABR(4688) = EE**2/SW**2/cb**2*suth*(cdth*cmuth-cdth
     &      *cmuth*sb**2+Md/MW**2*Mm*sdth*smuth)
      AAABR(4689) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cuth*sdth
     &      *smuth
      AAABR(4690) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cuth*sb
     &      **2*sdth*smuth
      AAABR(4691) = EE**2/MW**2*Mm/SW**2/cb**2*cuth*sdth
     &      *smuth
      AAABR(4692) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sdth
     &      *smuth
      AAABR(4693) = EE**2/SW**2/cb**2*ctth*(cbth*ceth-cbth
     &      *ceth*sb**2+Mb/MW**2*Me*sbth*seth)
      AAABR(4694) = EE**2/SW**2/cb**2*ctth*(cbth*seth-cbth
     &      *sb**2*seth-Mb/MW**2*Me*ceth*sbth)
      AAABR(4695) = EE**2/SW**2/cb**2*cbth*ceth*ctth*(1D0
     &      -sb**2)
      AAABR(4696) = EE**2/SW**2/cb**2*ctth*(ceth*sbth-ceth
     &      *sb**2*sbth-Mb/MW**2*Me*cbth*seth)
      AAABR(4697) = EE**2/SW**2/cb**2*stth*(cbth*ceth-cbth
     &      *ceth*sb**2+Mb/MW**2*Me*sbth*seth)
      AAABR(4698) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ctth*sbth
     &      *seth
      AAABR(4699) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ctth*sb
     &      **2*sbth*seth
      AAABR(4700) = EE**2/MW**2*Me/SW**2/cb**2*ctth*sbth
     &      *seth
      AAABR(4701) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      *seth
      AAABR(4702) = EE**2/SW**2/cb**2*ctth*(cbth*cmuth-cbth
     &      *cmuth*sb**2+Mb/MW**2*Mm*sbth*smuth)
      AAABR(4703) = EE**2/SW**2/cb**2*ctth*(cbth*smuth-cbth
     &      *sb**2*smuth-Mb/MW**2*Mm*cmuth*sbth)
      AAABR(4704) = EE**2/SW**2/cb**2*cbth*cmuth*ctth*(1D0
     &      -sb**2)
      AAABR(4705) = EE**2/SW**2/cb**2*ctth*(cmuth*sbth-cmuth
     &      *sb**2*sbth-Mb/MW**2*Mm*cbth*smuth)
      AAABR(4706) = EE**2/SW**2/cb**2*stth*(cbth*cmuth-cbth
     &      *cmuth*sb**2+Mb/MW**2*Mm*sbth*smuth)
      AAABR(4707) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*ctth*sbth
     &      *smuth
      AAABR(4708) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*ctth*sb
     &      **2*sbth*smuth
      AAABR(4709) = EE**2/MW**2*Mm/SW**2/cb**2*ctth*sbth
     &      *smuth
      AAABR(4710) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      *smuth
      AAABR(4711) = EE**2/SW**2/cb**2*cuth*(cdth*ceth-cdth
     &      *ceth*sb**2+Md/MW**2*Me*sdth*seth)
      AAABR(4712) = EE**2/SW**2/cb**2*cuth*(cdth*seth-cdth
     &      *sb**2*seth-Md/MW**2*Me*ceth*sdth)
      AAABR(4713) = EE**2/SW**2/cb**2*cdth*ceth*cuth*(1D0
     &      -sb**2)
      AAABR(4714) = EE**2/SW**2/cb**2*cuth*(ceth*sdth-ceth
     &      *sb**2*sdth-Md/MW**2*Me*cdth*seth)
      AAABR(4715) = EE**2/SW**2/cb**2*suth*(cdth*ceth-cdth
     &      *ceth*sb**2+Md/MW**2*Me*sdth*seth)
      AAABR(4716) = EE**2/MW**2*Md*Me/SW**2/cb**2*cuth*sdth
     &      *seth
      AAABR(4717) = EE**2/MW**2*Md*Me/SW**2/cb**2*cuth*sb
     &      **2*sdth*seth
      AAABR(4718) = EE**2/MW**2*Me/SW**2/cb**2*cuth*sdth
     &      *seth
      AAABR(4719) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sdth
     &      *seth
      AAABR(4720) = EE**2/SW**2/cb**2*ccth*(cmuth*csth-cmuth
     &      *csth*sb**2+Mm/MW**2*Ms*smuth*ssth)
      AAABR(4721) = EE**2/SW**2/cb**2*ccth*(csth*smuth-csth
     &      *sb**2*smuth-Mm/MW**2*Ms*cmuth*ssth)
      AAABR(4722) = EE**2/SW**2/cb**2*ccth*cmuth*csth*(1D0
     &      -sb**2)
      AAABR(4723) = EE**2/SW**2/cb**2*ccth*(cmuth*ssth-cmuth
     &      *sb**2*ssth-Mm/MW**2*Ms*csth*smuth)
      AAABR(4724) = EE**2/SW**2/cb**2*scth*(cmuth*csth-cmuth
     &      *csth*sb**2+Mm/MW**2*Ms*smuth*ssth)
      AAABR(4725) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*smuth
     &      *ssth
      AAABR(4726) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*sb
     &      **2*smuth*ssth
      AAABR(4727) = EE**2/MW**2*Mm/SW**2/cb**2*ccth*smuth
     &      *ssth
      AAABR(4728) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*smuth
     &      *ssth
      AAABR(4729) = EE**2/SW**2/cb**2*ccth*(ceth*csth-ceth
     &      *csth*sb**2+Me/MW**2*Ms*seth*ssth)
      AAABR(4730) = EE**2/SW**2/cb**2*ccth*(csth*seth-csth
     &      *sb**2*seth-Me/MW**2*Ms*ceth*ssth)
      AAABR(4731) = EE**2/SW**2/cb**2*ccth*ceth*csth*(1D0
     &      -sb**2)
      AAABR(4732) = EE**2/SW**2/cb**2*ccth*(ceth*ssth-ceth
     &      *sb**2*ssth-Me/MW**2*Ms*csth*seth)
      AAABR(4733) = EE**2/SW**2/cb**2*scth*(ceth*csth-ceth
     &      *csth*sb**2+Me/MW**2*Ms*seth*ssth)
      AAABR(4734) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*seth
     &      *ssth
      AAABR(4735) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*sb
     &      **2*seth*ssth
      AAABR(4736) = EE**2/MW**2*Me/SW**2/cb**2*ccth*seth
     &      *ssth
      AAABR(4737) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*seth
     &      *ssth
      AAABR(4738) = EE**2/SW**2/cb**2*cuth*(sdth*slth-sb
     &      **2*sdth*slth+Md/MW**2*Ml*cdth*clth)
      AAABR(4739) = EE**2/SW**2/cb**2*clth*cuth*sdth*(1D0
     &      -sb**2)
      AAABR(4740) = EE**2/SW**2/cb**2*suth*(clth*sdth-clth
     &      *sb**2*sdth-Md/MW**2*Ml*cdth*slth)
      AAABR(4741) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*cuth
     &      *slth
      AAABR(4742) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*cuth
     &      *sb**2*slth
      AAABR(4743) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*cuth
     &      *slth
      AAABR(4744) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *slth
      AAABR(4745) = EE**2/SW**2/cb**2*ctth*(sbth*smuth-sb
     &      **2*sbth*smuth+Mb/MW**2*Mm*cbth*cmuth)
      AAABR(4746) = EE**2/SW**2/cb**2*cmuth*ctth*sbth*(1D0
     &      -sb**2)
      AAABR(4747) = EE**2/SW**2/cb**2*stth*(cmuth*sbth-cmuth
     &      *sb**2*sbth-Mb/MW**2*Mm*cbth*smuth)
      AAABR(4748) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*ctth
     &      *smuth
      AAABR(4749) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*ctth
     &      *sb**2*smuth
      AAABR(4750) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*ctth
     &      *smuth
      AAABR(4751) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *smuth
      AAABR(4752) = EE**2/SW**2/cb**2*cuth*(sdth*seth-sb
     &      **2*sdth*seth+Md/MW**2*Me*cdth*ceth)
      AAABR(4753) = EE**2/SW**2/cb**2*ceth*cuth*sdth*(1D0
     &      -sb**2)
      AAABR(4754) = EE**2/SW**2/cb**2*suth*(ceth*sdth-ceth
     &      *sb**2*sdth-Md/MW**2*Me*cdth*seth)
      AAABR(4755) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*cuth
     &      *seth
      AAABR(4756) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*cuth
     &      *sb**2*seth
      AAABR(4757) = EE**2/MW**2*Me/SW**2/cb**2*cdth*cuth
     &      *seth
      AAABR(4758) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *seth
      AAABR(4759) = EE**2/SW**2/cb**2*ctth*(sbth*seth-sb
     &      **2*sbth*seth+Mb/MW**2*Me*cbth*ceth)
      AAABR(4760) = EE**2/SW**2/cb**2*ceth*ctth*sbth*(1D0
     &      -sb**2)
      AAABR(4761) = EE**2/SW**2/cb**2*stth*(ceth*sbth-ceth
     &      *sb**2*sbth-Mb/MW**2*Me*cbth*seth)
      AAABR(4762) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ctth
     &      *seth
      AAABR(4763) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ctth
     &      *sb**2*seth
      AAABR(4764) = EE**2/MW**2*Me/SW**2/cb**2*cbth*ctth
     &      *seth
      AAABR(4765) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *seth
      AAABR(4766) = EE**2/SW**2/cb**2*cuth*(sdth*smuth-sb
     &      **2*sdth*smuth+Md/MW**2*Mm*cdth*cmuth)
      AAABR(4767) = EE**2/SW**2/cb**2*cmuth*cuth*sdth*(1D0
     &      -sb**2)
      AAABR(4768) = EE**2/SW**2/cb**2*suth*(cmuth*sdth-cmuth
     &      *sb**2*sdth-Md/MW**2*Mm*cdth*smuth)
      AAABR(4769) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cuth
     &      *smuth
      AAABR(4770) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cuth
     &      *sb**2*smuth
      AAABR(4771) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*cuth
     &      *smuth
      AAABR(4772) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *smuth
      AAABR(4773) = EE**2/SW**2/cb**2*ctth*(sbth*slth-sb
     &      **2*sbth*slth+Mb/MW**2*Ml*cbth*clth)
      AAABR(4774) = EE**2/SW**2/cb**2*clth*ctth*sbth*(1D0
     &      -sb**2)
      AAABR(4775) = EE**2/SW**2/cb**2*stth*(clth*sbth-clth
     &      *sb**2*sbth-Mb/MW**2*Ml*cbth*slth)
      AAABR(4776) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*ctth
     &      *slth
      AAABR(4777) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*ctth
     &      *sb**2*slth
      AAABR(4778) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*ctth
     &      *slth
      AAABR(4779) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *slth
      AAABR(4780) = EE**2/SW**2/cb**2*ccth*(smuth*ssth-sb
     &      **2*smuth*ssth+Mm/MW**2*Ms*cmuth*csth)
      AAABR(4781) = EE**2/SW**2/cb**2*ccth*cmuth*ssth*(1D0
     &      -sb**2)
      AAABR(4782) = EE**2/SW**2/cb**2*scth*(cmuth*ssth-cmuth
     &      *sb**2*ssth-Mm/MW**2*Ms*csth*smuth)
      AAABR(4783) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*csth
     &      *smuth
      AAABR(4784) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*csth
     &      *sb**2*smuth
      AAABR(4785) = EE**2/MW**2*Mm/SW**2/cb**2*ccth*csth
     &      *smuth
      AAABR(4786) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *smuth
      AAABR(4787) = EE**2/SW**2/cb**2*ccth*(slth*ssth-sb
     &      **2*slth*ssth+Ml/MW**2*Ms*clth*csth)
      AAABR(4788) = EE**2/SW**2/cb**2*ccth*clth*ssth*(1D0
     &      -sb**2)
      AAABR(4789) = EE**2/SW**2/cb**2*scth*(clth*ssth-clth
     &      *sb**2*ssth-Ml/MW**2*Ms*csth*slth)
      AAABR(4790) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*csth
     &      *slth
      AAABR(4791) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*csth
     &      *sb**2*slth
      AAABR(4792) = EE**2/MW**2*Ml/SW**2/cb**2*ccth*csth
     &      *slth
      AAABR(4793) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *slth
      AAABR(4794) = EE**2/SW**2/cb**2*ccth*(seth*ssth-sb
     &      **2*seth*ssth+Me/MW**2*Ms*ceth*csth)
      AAABR(4795) = EE**2/SW**2/cb**2*ccth*ceth*ssth*(1D0
     &      -sb**2)
      AAABR(4796) = EE**2/SW**2/cb**2*scth*(ceth*ssth-ceth
     &      *sb**2*ssth-Me/MW**2*Ms*csth*seth)
      AAABR(4797) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*csth
     &      *seth
      AAABR(4798) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*csth
     &      *sb**2*seth
      AAABR(4799) = EE**2/MW**2*Me/SW**2/cb**2*ccth*csth
     &      *seth
      AAABR(4800) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *seth
      AAABR(4801) = EE**2/SW**2*stth**2*(1D0-slth**2)
      AAABR(4802) = EE**2/CW**2*(4D0-12D0*slth**2-5D0*stth
     &      **2+15D0*slth**2*stth**2)
      AAABR(4803) = EE**2/CW**3*SW*(4D0-12D0*slth**2-5D0
     &      *stth**2+15D0*slth**2*stth**2)
      AAABR(4804) = EE**2/SW**2*scth**2*(1D0-slth**2)
      AAABR(4805) = EE**2/CW**2*(4D0-5D0*scth**2-12D0*slth
     &      **2+15D0*scth**2*slth**2)
      AAABR(4806) = EE**2/CW**3*SW*(4D0-5D0*scth**2-12D0
     &      *slth**2+15D0*scth**2*slth**2)
      AAABR(4807) = EE**2/SW**2*stth**2*(1D0-smuth**2)
      AAABR(4808) = EE**2/CW**2*(4D0-12D0*smuth**2-5D0*stth
     &      **2+15D0*smuth**2*stth**2)
      AAABR(4809) = EE**2/CW**3*SW*(4D0-12D0*smuth**2-5D0
     &      *stth**2+15D0*smuth**2*stth**2)
      AAABR(4810) = EE**2/SW**2*suth**2*(1D0-smuth**2)
      AAABR(4811) = EE**2/CW**2*(4D0-12D0*smuth**2-5D0*suth
     &      **2+15D0*smuth**2*suth**2)
      AAABR(4812) = EE**2/CW**3*SW*(4D0-12D0*smuth**2-5D0
     &      *suth**2+15D0*smuth**2*suth**2)
      AAABR(4813) = EE**2/SW**2*suth**2*(1D0-seth**2)
      AAABR(4814) = EE**2/CW**2*(4D0-12D0*seth**2-5D0*suth
     &      **2+15D0*seth**2*suth**2)
      AAABR(4815) = EE**2/CW**3*SW*(4D0-12D0*seth**2-5D0
     &      *suth**2+15D0*seth**2*suth**2)
      AAABR(4816) = EE**2/SW**2*suth**2*(1D0-slth**2)
      AAABR(4817) = EE**2/CW**2*(4D0-12D0*slth**2-5D0*suth
     &      **2+15D0*slth**2*suth**2)
      AAABR(4818) = EE**2/CW**3*SW*(4D0-12D0*slth**2-5D0
     &      *suth**2+15D0*slth**2*suth**2)
      AAABR(4819) = EE**2/SW**2*scth**2*(1D0-seth**2)
      AAABR(4820) = EE**2/CW**2*(4D0-5D0*scth**2-12D0*seth
     &      **2+15D0*scth**2*seth**2)
      AAABR(4821) = EE**2/CW**3*SW*(4D0-5D0*scth**2-12D0
     &      *seth**2+15D0*scth**2*seth**2)
      AAABR(4822) = EE**2/SW**2*scth**2*(1D0-smuth**2)
      AAABR(4823) = EE**2/CW**2*(4D0-5D0*scth**2-12D0*smuth
     &      **2+15D0*scth**2*smuth**2)
      AAABR(4824) = EE**2/CW**3*SW*(4D0-5D0*scth**2-12D0
     &      *smuth**2+15D0*scth**2*smuth**2)
      AAABR(4825) = EE**2/SW**2*stth**2*(1D0-seth**2)
      AAABR(4826) = EE**2/CW**2*(4D0-12D0*seth**2-5D0*stth
     &      **2+15D0*seth**2*stth**2)
      AAABR(4827) = EE**2/CW**3*SW*(4D0-12D0*seth**2-5D0
     &      *stth**2+15D0*seth**2*stth**2)
      AAABR(4828) = EE**2*(8D0/CW**2-12D0*smuth**2/CW**2
     &      -10D0*stth**2/CW**2+15D0*smuth**2/CW**2*stth
     &      **2+3D0*smuth**2/SW**2*stth**2)
      AAABR(4829) = EE**2/SW**2*cmuth*smuth*stth**2
      AAABR(4830) = EE**2/CW**2*cmuth*smuth*(4D0-5D0*stth
     &      **2)
      AAABR(4831) = EE**2/CW**3*SW*cmuth*smuth*(4D0-5D0*stth
     &      **2)
      AAABR(4832) = EE**2*(8D0/CW**2-12D0*seth**2/CW**2-10D0
     &      *stth**2/CW**2+15D0*seth**2/CW**2*stth**2+3D0
     &      *seth**2/SW**2*stth**2)
      AAABR(4833) = EE**2/SW**2*ceth*seth*stth**2
      AAABR(4834) = EE**2/CW**2*ceth*seth*(4D0-5D0*stth**2)
      AAABR(4835) = EE**2/CW**3*SW*ceth*seth*(4D0-5D0*stth
     &      **2)
      AAABR(4836) = EE**2*(8D0/CW**2-10D0*scth**2/CW**2-12D0
     &      *seth**2/CW**2+15D0*scth**2/CW**2*seth**2+3D0
     &      *scth**2/SW**2*seth**2)
      AAABR(4837) = EE**2/SW**2*ceth*scth**2*seth
      AAABR(4838) = EE**2/CW**2*ceth*seth*(4D0-5D0*scth**2)
      AAABR(4839) = EE**2/CW**3*SW*ceth*seth*(4D0-5D0*scth
     &      **2)
      AAABR(4840) = EE**2*(8D0/CW**2-12D0*slth**2/CW**2-10D0
     &      *suth**2/CW**2+15D0*slth**2/CW**2*suth**2+3D0
     &      *slth**2/SW**2*suth**2)
      AAABR(4841) = EE**2/SW**2*clth*slth*suth**2
      AAABR(4842) = EE**2/CW**2*clth*slth*(4D0-5D0*suth**2)
      AAABR(4843) = EE**2/CW**3*SW*clth*slth*(4D0-5D0*suth
     &      **2)
      AAABR(4844) = EE**2*(8D0/CW**2-10D0*scth**2/CW**2-12D0
     &      *smuth**2/CW**2+15D0*scth**2/CW**2*smuth**2+3D0
     &      *scth**2/SW**2*smuth**2)
      AAABR(4845) = EE**2/SW**2*cmuth*scth**2*smuth
      AAABR(4846) = EE**2/CW**2*cmuth*smuth*(4D0-5D0*scth
     &      **2)
      AAABR(4847) = EE**2/CW**3*SW*cmuth*smuth*(4D0-5D0*scth
     &      **2)
      AAABR(4848) = EE**2*(8D0/CW**2-12D0*slth**2/CW**2-10D0
     &      *stth**2/CW**2+15D0*slth**2/CW**2*stth**2+3D0
     &      *slth**2/SW**2*stth**2)
      AAABR(4849) = EE**2/SW**2*clth*slth*stth**2
      AAABR(4850) = EE**2/CW**2*clth*slth*(4D0-5D0*stth**2)
      AAABR(4851) = EE**2/CW**3*SW*clth*slth*(4D0-5D0*stth
     &      **2)
      AAABR(4852) = EE**2*(8D0/CW**2-10D0*scth**2/CW**2-12D0
     &      *slth**2/CW**2+15D0*scth**2/CW**2*slth**2+3D0
     &      *scth**2/SW**2*slth**2)
      AAABR(4853) = EE**2/SW**2*clth*scth**2*slth
      AAABR(4854) = EE**2/CW**2*clth*slth*(4D0-5D0*scth**2)
      AAABR(4855) = EE**2/CW**3*SW*clth*slth*(4D0-5D0*scth
     &      **2)
      AAABR(4856) = EE**2*(8D0/CW**2-12D0*seth**2/CW**2-10D0
     &      *suth**2/CW**2+15D0*seth**2/CW**2*suth**2+3D0
     &      *seth**2/SW**2*suth**2)
      AAABR(4857) = EE**2/SW**2*ceth*seth*suth**2
      AAABR(4858) = EE**2/CW**2*ceth*seth*(4D0-5D0*suth**2)
      AAABR(4859) = EE**2/CW**3*SW*ceth*seth*(4D0-5D0*suth
     &      **2)
      AAABR(4860) = EE**2*(8D0/CW**2-12D0*smuth**2/CW**2
     &      -10D0*suth**2/CW**2+15D0*smuth**2/CW**2*suth
     &      **2+3D0*smuth**2/SW**2*suth**2)
      AAABR(4861) = EE**2/SW**2*cmuth*smuth*suth**2
      AAABR(4862) = EE**2/CW**2*cmuth*smuth*(4D0-5D0*suth
     &      **2)
      AAABR(4863) = EE**2/CW**3*SW*cmuth*smuth*(4D0-5D0*suth
     &      **2)
      AAABR(4864) = EE**2/SW**2/cb**2*suth*(cdth*seth-cdth
     &      *sb**2*seth-Md/MW**2*Me*ceth*sdth)
      AAABR(4865) = EE**2/SW**2/cb**2*cdth*ceth*suth*(1D0
     &      -sb**2)
      AAABR(4866) = EE**2/MW**2*Md*Me/SW**2/cb**2*sdth*seth
     &      *suth
      AAABR(4867) = EE**2/MW**2*Md*Me/SW**2/cb**2*sb**2*sdth
     &      *seth*suth
      AAABR(4868) = EE**2/MW**2*Me/SW**2/cb**2*sdth*seth
     &      *suth
      AAABR(4869) = EE**2/MW**2*Md/SW**2/cb**2*sdth*seth
     &      *suth
      AAABR(4870) = EE**2/SW**2/cb**2*stth*(cbth*smuth-cbth
     &      *sb**2*smuth-Mb/MW**2*Mm*cmuth*sbth)
      AAABR(4871) = EE**2/SW**2/cb**2*cbth*cmuth*stth*(1D0
     &      -sb**2)
      AAABR(4872) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*sbth*smuth
     &      *stth
      AAABR(4873) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*sb**2*sbth
     &      *smuth*stth
      AAABR(4874) = EE**2/MW**2*Mm/SW**2/cb**2*sbth*smuth
     &      *stth
      AAABR(4875) = EE**2/MW**2*Mb/SW**2/cb**2*sbth*smuth
     &      *stth
      AAABR(4876) = EE**2/SW**2/cb**2*stth*(cbth*seth-cbth
     &      *sb**2*seth-Mb/MW**2*Me*ceth*sbth)
      AAABR(4877) = EE**2/SW**2/cb**2*cbth*ceth*stth*(1D0
     &      -sb**2)
      AAABR(4878) = EE**2/MW**2*Mb*Me/SW**2/cb**2*sbth*seth
     &      *stth
      AAABR(4879) = EE**2/MW**2*Mb*Me/SW**2/cb**2*sb**2*sbth
     &      *seth*stth
      AAABR(4880) = EE**2/MW**2*Me/SW**2/cb**2*sbth*seth
     &      *stth
      AAABR(4881) = EE**2/MW**2*Mb/SW**2/cb**2*sbth*seth
     &      *stth
      AAABR(4882) = EE**2/SW**2/cb**2*suth*(cdth*smuth-cdth
     &      *sb**2*smuth-Md/MW**2*Mm*cmuth*sdth)
      AAABR(4883) = EE**2/SW**2/cb**2*cdth*cmuth*suth*(1D0
     &      -sb**2)
      AAABR(4884) = EE**2/MW**2*Md*Mm/SW**2/cb**2*sdth*smuth
     &      *suth
      AAABR(4885) = EE**2/MW**2*Md*Mm/SW**2/cb**2*sb**2*sdth
     &      *smuth*suth
      AAABR(4886) = EE**2/MW**2*Mm/SW**2/cb**2*sdth*smuth
     &      *suth
      AAABR(4887) = EE**2/MW**2*Md/SW**2/cb**2*sdth*smuth
     &      *suth
      AAABR(4888) = EE**2/SW**2/cb**2*scth*(csth*smuth-csth
     &      *sb**2*smuth-Mm/MW**2*Ms*cmuth*ssth)
      AAABR(4889) = EE**2/SW**2/cb**2*cmuth*csth*scth*(1D0
     &      -sb**2)
      AAABR(4890) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*scth*smuth
     &      *ssth
      AAABR(4891) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*sb**2*scth
     &      *smuth*ssth
      AAABR(4892) = EE**2/MW**2*Mm/SW**2/cb**2*scth*smuth
     &      *ssth
      AAABR(4893) = EE**2/MW**2*Ms/SW**2/cb**2*scth*smuth
     &      *ssth
      AAABR(4894) = EE**2/SW**2/cb**2*scth*(csth*seth-csth
     &      *sb**2*seth-Me/MW**2*Ms*ceth*ssth)
      AAABR(4895) = EE**2/SW**2/cb**2*ceth*csth*scth*(1D0
     &      -sb**2)
      AAABR(4896) = EE**2/MW**2*Me*Ms/SW**2/cb**2*scth*seth
     &      *ssth
      AAABR(4897) = EE**2/MW**2*Me*Ms/SW**2/cb**2*sb**2*scth
     &      *seth*ssth
      AAABR(4898) = EE**2/MW**2*Me/SW**2/cb**2*scth*seth
     &      *ssth
      AAABR(4899) = EE**2/MW**2*Ms/SW**2/cb**2*scth*seth
     &      *ssth
      AAABR(4900) = EE**2/SW**2/cb**2*scth*(csth*slth-csth
     &      *sb**2*slth-Ml/MW**2*Ms*clth*ssth)
      AAABR(4901) = EE**2/SW**2/cb**2*clth*csth*scth*(1D0
     &      -sb**2)
      AAABR(4902) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*scth*slth
     &      *ssth
      AAABR(4903) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*sb**2*scth
     &      *slth*ssth
      AAABR(4904) = EE**2/MW**2*Ml/SW**2/cb**2*scth*slth
     &      *ssth
      AAABR(4905) = EE**2/MW**2*Ms/SW**2/cb**2*scth*slth
     &      *ssth
      AAABR(4906) = EE**2/SW**2/cb**2*suth*(cdth*slth-cdth
     &      *sb**2*slth-Md/MW**2*Ml*clth*sdth)
      AAABR(4907) = EE**2/SW**2/cb**2*cdth*clth*suth*(1D0
     &      -sb**2)
      AAABR(4908) = EE**2/MW**2*Md*Ml/SW**2/cb**2*sdth*slth
     &      *suth
      AAABR(4909) = EE**2/MW**2*Md*Ml/SW**2/cb**2*sb**2*sdth
     &      *slth*suth
      AAABR(4910) = EE**2/MW**2*Ml/SW**2/cb**2*sdth*slth
     &      *suth
      AAABR(4911) = EE**2/MW**2*Md/SW**2/cb**2*sdth*slth
     &      *suth
      AAABR(4912) = EE**2/SW**2/cb**2*stth*(cbth*slth-cbth
     &      *sb**2*slth-Mb/MW**2*Ml*clth*sbth)
      AAABR(4913) = EE**2/SW**2/cb**2*cbth*clth*stth*(1D0
     &      -sb**2)
      AAABR(4914) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*sbth*slth
     &      *stth
      AAABR(4915) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*sb**2*sbth
     &      *slth*stth
      AAABR(4916) = EE**2/MW**2*Ml/SW**2/cb**2*sbth*slth
     &      *stth
      AAABR(4917) = EE**2/MW**2*Mb/SW**2/cb**2*sbth*slth
     &      *stth
      AAABR(4918) = EE**2/SW**2/cb**2*suth*(sdth*seth-sb
     &      **2*sdth*seth+Md/MW**2*Me*cdth*ceth)
      AAABR(4919) = EE**2/SW**2/cb**2*ceth*sdth*suth*(1D0
     &      -sb**2)
      AAABR(4920) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*seth
     &      *suth
      AAABR(4921) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*sb
     &      **2*seth*suth
      AAABR(4922) = EE**2/MW**2*Me/SW**2/cb**2*cdth*seth
     &      *suth
      AAABR(4923) = EE**2/MW**2*Md/SW**2/cb**2*cdth*seth
     &      *suth
      AAABR(4924) = EE**2/SW**2/cb**2*stth*(sbth*slth-sb
     &      **2*sbth*slth+Mb/MW**2*Ml*cbth*clth)
      end

      subroutine aaini07
      implicit none
#include "model.h"

      AAABR(4925) = EE**2/SW**2/cb**2*clth*sbth*stth*(1D0
     &      -sb**2)
      AAABR(4926) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*slth
     &      *stth
      AAABR(4927) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*sb
     &      **2*slth*stth
      AAABR(4928) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*slth
     &      *stth
      AAABR(4929) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*slth
     &      *stth
      AAABR(4930) = EE**2/SW**2/cb**2*stth*(sbth*seth-sb
     &      **2*sbth*seth+Mb/MW**2*Me*cbth*ceth)
      AAABR(4931) = EE**2/SW**2/cb**2*ceth*sbth*stth*(1D0
     &      -sb**2)
      AAABR(4932) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*seth
     &      *stth
      AAABR(4933) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*sb
     &      **2*seth*stth
      AAABR(4934) = EE**2/MW**2*Me/SW**2/cb**2*cbth*seth
     &      *stth
      AAABR(4935) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*seth
     &      *stth
      AAABR(4936) = EE**2/SW**2/cb**2*scth*(seth*ssth-sb
     &      **2*seth*ssth+Me/MW**2*Ms*ceth*csth)
      AAABR(4937) = EE**2/SW**2/cb**2*ceth*scth*ssth*(1D0
     &      -sb**2)
      AAABR(4938) = EE**2/MW**2*Me*Ms/SW**2/cb**2*csth*scth
     &      *seth
      AAABR(4939) = EE**2/MW**2*Me*Ms/SW**2/cb**2*csth*sb
     &      **2*scth*seth
      AAABR(4940) = EE**2/MW**2*Me/SW**2/cb**2*csth*scth
     &      *seth
      AAABR(4941) = EE**2/MW**2*Ms/SW**2/cb**2*csth*scth
     &      *seth
      AAABR(4942) = EE**2/SW**2/cb**2*scth*(slth*ssth-sb
     &      **2*slth*ssth+Ml/MW**2*Ms*clth*csth)
      AAABR(4943) = EE**2/SW**2/cb**2*clth*scth*ssth*(1D0
     &      -sb**2)
      AAABR(4944) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*csth*scth
     &      *slth
      AAABR(4945) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*csth*sb
     &      **2*scth*slth
      AAABR(4946) = EE**2/MW**2*Ml/SW**2/cb**2*csth*scth
     &      *slth
      AAABR(4947) = EE**2/MW**2*Ms/SW**2/cb**2*csth*scth
     &      *slth
      AAABR(4948) = EE**2/SW**2/cb**2*suth*(sdth*smuth-sb
     &      **2*sdth*smuth+Md/MW**2*Mm*cdth*cmuth)
      AAABR(4949) = EE**2/SW**2/cb**2*cmuth*sdth*suth*(1D0
     &      -sb**2)
      AAABR(4950) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*smuth
     &      *suth
      AAABR(4951) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*sb
     &      **2*smuth*suth
      AAABR(4952) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*smuth
     &      *suth
      AAABR(4953) = EE**2/MW**2*Md/SW**2/cb**2*cdth*smuth
     &      *suth
      AAABR(4954) = EE**2/SW**2/cb**2*scth*(smuth*ssth-sb
     &      **2*smuth*ssth+Mm/MW**2*Ms*cmuth*csth)
      AAABR(4955) = EE**2/SW**2/cb**2*cmuth*scth*ssth*(1D0
     &      -sb**2)
      AAABR(4956) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*csth*scth
     &      *smuth
      AAABR(4957) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*csth*sb
     &      **2*scth*smuth
      AAABR(4958) = EE**2/MW**2*Mm/SW**2/cb**2*csth*scth
     &      *smuth
      AAABR(4959) = EE**2/MW**2*Ms/SW**2/cb**2*csth*scth
     &      *smuth
      AAABR(4960) = EE**2/SW**2/cb**2*suth*(sdth*slth-sb
     &      **2*sdth*slth+Md/MW**2*Ml*cdth*clth)
      AAABR(4961) = EE**2/SW**2/cb**2*clth*sdth*suth*(1D0
     &      -sb**2)
      AAABR(4962) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*slth
     &      *suth
      AAABR(4963) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*sb
     &      **2*slth*suth
      AAABR(4964) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*slth
     &      *suth
      AAABR(4965) = EE**2/MW**2*Md/SW**2/cb**2*cdth*slth
     &      *suth
      AAABR(4966) = EE**2/SW**2/cb**2*stth*(sbth*smuth-sb
     &      **2*sbth*smuth+Mb/MW**2*Mm*cbth*cmuth)
      AAABR(4967) = EE**2/SW**2/cb**2*cmuth*sbth*stth*(1D0
     &      -sb**2)
      AAABR(4968) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*smuth
     &      *stth
      AAABR(4969) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*sb
     &      **2*smuth*stth
      AAABR(4970) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*smuth
     &      *stth
      AAABR(4971) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*smuth
     &      *stth
      AAABR(4972) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*slth**2/CW**2-2D0*sb**2/SW**2-slth
     &      **2/SW**2+6D0*sb**2/CW**2*slth**2+2D0*sb**2/SW
     &      **2*slth**2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(4973) = EE**2*(1D0/CW**2+1D0/SW**2-sb**2/CW**2
     &      -3D0*slth**2/CW**2-sb**2/SW**2-slth**2/SW**2
     &      +3D0*sb**2/CW**2*slth**2+sb**2/SW**2*slth**2
     &      +2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(4974) = EE**2/SW**2*(1D0-2D0*sb**2-slth**2+2D0
     &      *sb**2*slth**2)
      AAABR(4975) = EE**2*clth*slth*(3D0/CW**2+1D0/SW**2
     &      -6D0*sb**2/CW**2-2D0*sb**2/SW**2-2D0*Ml**2/MW
     &      **2/SW**2)
      AAABR(4976) = EE**2*sb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2)
      AAABR(4977) = EE**2/CW**2*(1D0-2D0*sb**2-3D0*slth**2
     &      +6D0*sb**2*slth**2)
      AAABR(4978) = EE**2/CW**3*SW*(1D0-2D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(4979) = EE**2/MW**2*Ml**2/SW**2*slth**2
      AAABR(4980) = EE**2/MW**2*Ml**2/SW**2*sb**2*slth**2
      AAABR(4981) = EE**2/MW**2*Ml/SW**2*slth**2
      AAABR(4982) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*smuth**2/CW**2-2D0*sb**2/SW**2-smuth
     &      **2/SW**2+6D0*sb**2/CW**2*smuth**2+2D0*sb**2
     &      /SW**2*smuth**2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(4983) = EE**2*(1D0/CW**2+1D0/SW**2-sb**2/CW**2
     &      -3D0*smuth**2/CW**2-sb**2/SW**2-smuth**2/SW**2
     &      +3D0*sb**2/CW**2*smuth**2+sb**2/SW**2*smuth**2
     &      +2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(4984) = EE**2/SW**2*(1D0-2D0*sb**2-smuth**2+2D0
     &      *sb**2*smuth**2)
      AAABR(4985) = EE**2*cmuth*smuth*(3D0/CW**2+1D0/SW**2
     &      -6D0*sb**2/CW**2-2D0*sb**2/SW**2-2D0*Mm**2/MW
     &      **2/SW**2)
      AAABR(4986) = EE**2*sb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2)
      AAABR(4987) = EE**2/CW**2*(1D0-2D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(4988) = EE**2/CW**3*SW*(1D0-2D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(4989) = EE**2/MW**2*Mm**2/SW**2*smuth**2
      AAABR(4990) = EE**2/MW**2*Mm**2/SW**2*sb**2*smuth**2
      AAABR(4991) = EE**2/MW**2*Mm/SW**2*smuth**2
      AAABR(4992) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*seth**2/CW**2-2D0*sb**2/SW**2-seth
     &      **2/SW**2+6D0*sb**2/CW**2*seth**2+2D0*sb**2/SW
     &      **2*seth**2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(4993) = EE**2*(1D0/CW**2+1D0/SW**2-sb**2/CW**2
     &      -3D0*seth**2/CW**2-sb**2/SW**2-seth**2/SW**2
     &      +3D0*sb**2/CW**2*seth**2+sb**2/SW**2*seth**2
     &      +2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(4994) = EE**2/SW**2*(1D0-2D0*sb**2-seth**2+2D0
     &      *sb**2*seth**2)
      AAABR(4995) = EE**2*ceth*seth*(3D0/CW**2+1D0/SW**2
     &      -6D0*sb**2/CW**2-2D0*sb**2/SW**2-2D0*Me**2/MW
     &      **2/SW**2)
      AAABR(4996) = EE**2*sb**2*(1D0/CW**2+1D0/SW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2)
      AAABR(4997) = EE**2/CW**2*(1D0-2D0*sb**2-3D0*seth**2
     &      +6D0*sb**2*seth**2)
      AAABR(4998) = EE**2/CW**3*SW*(1D0-2D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(4999) = EE**2/MW**2*Me**2/SW**2*seth**2
      AAABR(5000) = EE**2/MW**2*Me**2/SW**2*sb**2*seth**2
      AAABR(5001) = EE**2/MW**2*Me/SW**2*seth**2
      AAABR(5002) = EE**2*clth*slth*(3D0/CW**2+1D0/SW**2
     &      -3D0*sb**2/CW**2-sb**2/SW**2-2D0*Ml**2/MW**2
     &      /SW**2)
      AAABR(5003) = EE**2/SW**2*clth*slth*(1D0-2D0*sb**2)
      AAABR(5004) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2+6D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2+2D0*sb**2/SW**2
     &      *slth**2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(5005) = EE**2*clth*sb**2*slth*(3D0/CW**2+1D0
     &      /SW**2)
      AAABR(5006) = EE**2/CW**2*clth*slth*(1D0-2D0*sb**2)
      AAABR(5007) = EE**2/CW**3*SW*clth*slth*(1D0-2D0*sb**2)
      AAABR(5008) = EE**2/MW**2*Ml**2/SW**2*clth*slth
      AAABR(5009) = EE**2/MW**2*Ml**2/SW**2*clth*sb**2*slth
      AAABR(5010) = EE**2/MW**2*Ml/SW**2*clth*slth
      AAABR(5011) = EE**2*ceth*seth*(3D0/CW**2+1D0/SW**2
     &      -3D0*sb**2/CW**2-sb**2/SW**2-2D0*Me**2/MW**2
     &      /SW**2)
      AAABR(5012) = EE**2/SW**2*ceth*seth*(1D0-2D0*sb**2)
      AAABR(5013) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2+6D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2+2D0*sb**2/SW**2
     &      *seth**2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(5014) = EE**2*ceth*sb**2*seth*(3D0/CW**2+1D0
     &      /SW**2)
      AAABR(5015) = EE**2/CW**2*ceth*seth*(1D0-2D0*sb**2)
      AAABR(5016) = EE**2/CW**3*SW*ceth*seth*(1D0-2D0*sb**2)
      AAABR(5017) = EE**2/MW**2*Me**2/SW**2*ceth*seth
      AAABR(5018) = EE**2/MW**2*Me**2/SW**2*ceth*sb**2*seth
      AAABR(5019) = EE**2/MW**2*Me/SW**2*ceth*seth
      AAABR(5020) = EE**2*cmuth*smuth*(3D0/CW**2+1D0/SW**2
     &      -3D0*sb**2/CW**2-sb**2/SW**2-2D0*Mm**2/MW**2
     &      /SW**2)
      AAABR(5021) = EE**2/SW**2*cmuth*smuth*(1D0-2D0*sb**2)
      AAABR(5022) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2+6D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2+2D0*sb**2/SW
     &      **2*smuth**2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(5023) = EE**2*cmuth*sb**2*smuth*(3D0/CW**2+1D0
     &      /SW**2)
      AAABR(5024) = EE**2/CW**2*cmuth*smuth*(1D0-2D0*sb**2)
      AAABR(5025) = EE**2/CW**3*SW*cmuth*smuth*(1D0-2D0*sb
     &      **2)
      AAABR(5026) = EE**2/MW**2*Mm**2/SW**2*cmuth*smuth
      AAABR(5027) = EE**2/MW**2*Mm**2/SW**2*cmuth*sb**2*smuth
     &      
      AAABR(5028) = EE**2/MW**2*Mm/SW**2*cmuth*smuth
      AAABR(5029) = EE**2/SW**2*Sqrt2*ceth*(1D0-2D0*sb**2
     &      -Me**2/MW**2)
      AAABR(5030) = EE**2/SW**2*Sqrt2*ceth*(1D0-sb**2-Me
     &      **2/MW**2)
      AAABR(5031) = EE**2/SW**2*Sqrt2*ceth*(1D0-2D0*sb**2)
      AAABR(5032) = EE**2/SW**2*Sqrt2*seth*(1D0-2D0*sb**2
     &      -Me**2/MW**2)
      AAABR(5033) = EE**2/SW**2*Sqrt2*ceth*sb**2
      AAABR(5034) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ceth
      AAABR(5035) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ceth*sb**2
      AAABR(5036) = EE**2/MW**2*Me/SW**2*Sqrt2*ceth
      AAABR(5037) = EE**2/SW**2*Sqrt2*clth*(1D0-2D0*sb**2
     &      -Ml**2/MW**2)
      AAABR(5038) = EE**2/SW**2*Sqrt2*clth*(1D0-sb**2-Ml
     &      **2/MW**2)
      AAABR(5039) = EE**2/SW**2*Sqrt2*clth*(1D0-2D0*sb**2)
      AAABR(5040) = EE**2/SW**2*Sqrt2*slth*(1D0-2D0*sb**2
     &      -Ml**2/MW**2)
      AAABR(5041) = EE**2/SW**2*Sqrt2*clth*sb**2
      AAABR(5042) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*clth
      AAABR(5043) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*clth*sb**2
      AAABR(5044) = EE**2/MW**2*Ml/SW**2*Sqrt2*clth
      AAABR(5045) = EE**2/SW**2*Sqrt2*cmuth*(1D0-2D0*sb**2
     &      -Mm**2/MW**2)
      AAABR(5046) = EE**2/SW**2*Sqrt2*cmuth*(1D0-sb**2-Mm
     &      **2/MW**2)
      AAABR(5047) = EE**2/SW**2*Sqrt2*cmuth*(1D0-2D0*sb**2)
      AAABR(5048) = EE**2/SW**2*Sqrt2*smuth*(1D0-2D0*sb**2
     &      -Mm**2/MW**2)
      AAABR(5049) = EE**2/SW**2*Sqrt2*cmuth*sb**2
      AAABR(5050) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*cmuth
      AAABR(5051) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*cmuth*sb
     &      **2
      AAABR(5052) = EE**2/MW**2*Mm/SW**2*Sqrt2*cmuth
      AAABR(5053) = EE**2/SW**2*Sqrt2*clth*(ca/cb-sa*sb-ca
     &      /cb*sb**2-Ml**2/MW**2*ca/cb)
      AAABR(5054) = EE**2/SW**2*Sqrt2*clth*(ca*sb+sa/cb-sa
     &      /cb*sb**2-Ml**2/MW**2/cb*sa)
      AAABR(5055) = EE**2/SW**2*Sqrt2/cb*clth*sa*(1D0-sb
     &      **2-Ml**2/MW**2)
      AAABR(5056) = EE**2/SW**2*Sqrt2*clth*(ca*sb+sa/cb-sa
     &      /cb*sb**2)
      AAABR(5057) = EE**2/SW**2*Sqrt2*slth*(ca*sb+sa/cb-sa
     &      /cb*sb**2-Ml**2/MW**2/cb*sa)
      AAABR(5058) = EE**2/SW**2*Sqrt2*ca*clth*sb
      AAABR(5059) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb*clth*sa
      AAABR(5060) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb*clth
     &      *sa*sb**2
      AAABR(5061) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb*clth*sa
      AAABR(5062) = EE**2/SW**2*Sqrt2*ceth*(ca/cb-sa*sb-ca
     &      /cb*sb**2-Me**2/MW**2*ca/cb)
      AAABR(5063) = EE**2/SW**2*Sqrt2*ca/cb*ceth*(1D0-sb
     &      **2-Me**2/MW**2)
      AAABR(5064) = EE**2/SW**2*Sqrt2*ceth*(ca*sb+sa/cb-sa
     &      /cb*sb**2-Me**2/MW**2/cb*sa)
      AAABR(5065) = EE**2/SW**2*Sqrt2*ceth*(ca/cb-sa*sb-ca
     &      /cb*sb**2)
      AAABR(5066) = EE**2/SW**2*Sqrt2*seth*(ca/cb-sa*sb-ca
     &      /cb*sb**2-Me**2/MW**2*ca/cb)
      AAABR(5067) = EE**2/SW**2*Sqrt2*ceth*sa*sb
      AAABR(5068) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb*ceth
      AAABR(5069) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb*ceth
     &      *sb**2
      AAABR(5070) = EE**2/MW**2*Me/SW**2*Sqrt2*ca/cb*ceth
      AAABR(5071) = EE**2/SW**2*Sqrt2*cmuth*(ca/cb-sa*sb
     &      -ca/cb*sb**2-Mm**2/MW**2*ca/cb)
      AAABR(5072) = EE**2/SW**2*Sqrt2*ca/cb*cmuth*(1D0-sb
     &      **2-Mm**2/MW**2)
      AAABR(5073) = EE**2/SW**2*Sqrt2*cmuth*(ca*sb+sa/cb
     &      -sa/cb*sb**2-Mm**2/MW**2/cb*sa)
      AAABR(5074) = EE**2/SW**2*Sqrt2*cmuth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(5075) = EE**2/SW**2*Sqrt2*smuth*(ca/cb-sa*sb
     &      -ca/cb*sb**2-Mm**2/MW**2*ca/cb)
      AAABR(5076) = EE**2/SW**2*Sqrt2*cmuth*sa*sb
      AAABR(5077) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb*cmuth
     &      
      AAABR(5078) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb*cmuth
     &      *sb**2
      AAABR(5079) = EE**2/MW**2*Mm/SW**2*Sqrt2*ca/cb*cmuth
      AAABR(5080) = EE**2/SW**2*Sqrt2/cb*ceth*sa*(1D0-sb
     &      **2-Me**2/MW**2)
      AAABR(5081) = EE**2/SW**2*Sqrt2*ceth*(ca*sb+sa/cb-sa
     &      /cb*sb**2)
      AAABR(5082) = EE**2/SW**2*Sqrt2*seth*(ca*sb+sa/cb-sa
     &      /cb*sb**2-Me**2/MW**2/cb*sa)
      AAABR(5083) = EE**2/SW**2*Sqrt2*ca*ceth*sb
      AAABR(5084) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb*ceth*sa
      AAABR(5085) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb*ceth
     &      *sa*sb**2
      AAABR(5086) = EE**2/MW**2*Me/SW**2*Sqrt2/cb*ceth*sa
      AAABR(5087) = EE**2/SW**2*Sqrt2*ca/cb*clth*(1D0-sb
     &      **2-Ml**2/MW**2)
      AAABR(5088) = EE**2/SW**2*Sqrt2*clth*(ca/cb-sa*sb-ca
     &      /cb*sb**2)
      AAABR(5089) = EE**2/SW**2*Sqrt2*slth*(ca/cb-sa*sb-ca
     &      /cb*sb**2-Ml**2/MW**2*ca/cb)
      AAABR(5090) = EE**2/SW**2*Sqrt2*clth*sa*sb
      AAABR(5091) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb*clth
      AAABR(5092) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb*clth
     &      *sb**2
      AAABR(5093) = EE**2/MW**2*Ml/SW**2*Sqrt2*ca/cb*clth
      AAABR(5094) = EE**2/SW**2*Sqrt2/cb*cmuth*sa*(1D0-sb
     &      **2-Mm**2/MW**2)
      AAABR(5095) = EE**2/SW**2*Sqrt2*cmuth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(5096) = EE**2/SW**2*Sqrt2*smuth*(ca*sb+sa/cb
     &      -sa/cb*sb**2-Mm**2/MW**2/cb*sa)
      AAABR(5097) = EE**2/SW**2*Sqrt2*ca*cmuth*sb
      AAABR(5098) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb*cmuth
     &      *sa
      AAABR(5099) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb*cmuth
     &      *sa*sb**2
      AAABR(5100) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb*cmuth*sa
      AAABR(5101) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*smuth**2/CW**2+2D0*sb**2/SW**2+smuth
     &      **2/SW**2+6D0*sb**2/CW**2*smuth**2+2D0*Mm**2
     &      /MW**2/SW**2-2D0*sb**2/SW**2*smuth**2)
      AAABR(5102) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      -3D0*smuth**2/CW**2+sb**2/SW**2+smuth**2/SW**2
     &      +3D0*sb**2/CW**2*smuth**2+2D0*Mm**2/MW**2/SW
     &      **2-sb**2/SW**2*smuth**2)
      AAABR(5103) = EE**2*cmuth*smuth*(3D0/CW**2-1D0/SW**2
     &      -6D0*sb**2/CW**2+2D0*sb**2/SW**2)
      AAABR(5104) = EE**2*sb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2)
      AAABR(5105) = EE**2/MW**2*Mm**2/SW**2
      AAABR(5106) = EE**2/MW**2*Mm**2/SW**2*sb**2
      AAABR(5107) = EE**2/MW**2*Mm/SW**2
      AAABR(5108) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*slth**2/CW**2+2D0*sb**2/SW**2+slth
     &      **2/SW**2+6D0*sb**2/CW**2*slth**2+2D0*Ml**2/MW
     &      **2/SW**2-2D0*sb**2/SW**2*slth**2)
      AAABR(5109) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      -3D0*slth**2/CW**2+sb**2/SW**2+slth**2/SW**2
     &      +3D0*sb**2/CW**2*slth**2+2D0*Ml**2/MW**2/SW**2
     &      -sb**2/SW**2*slth**2)
      AAABR(5110) = EE**2*clth*slth*(3D0/CW**2-1D0/SW**2
     &      -6D0*sb**2/CW**2+2D0*sb**2/SW**2)
      AAABR(5111) = EE**2*sb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2)
      AAABR(5112) = EE**2/MW**2*Ml**2/SW**2
      AAABR(5113) = EE**2/MW**2*Ml**2/SW**2*sb**2
      AAABR(5114) = EE**2/MW**2*Ml/SW**2
      AAABR(5115) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2-3D0*seth**2/CW**2+2D0*sb**2/SW**2+seth
     &      **2/SW**2+6D0*sb**2/CW**2*seth**2+2D0*Me**2/MW
     &      **2/SW**2-2D0*sb**2/SW**2*seth**2)
      AAABR(5116) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      -3D0*seth**2/CW**2+sb**2/SW**2+seth**2/SW**2
     &      +3D0*sb**2/CW**2*seth**2+2D0*Me**2/MW**2/SW**2
     &      -sb**2/SW**2*seth**2)
      AAABR(5117) = EE**2*ceth*seth*(3D0/CW**2-1D0/SW**2
     &      -6D0*sb**2/CW**2+2D0*sb**2/SW**2)
      AAABR(5118) = EE**2*sb**2*(1D0/CW**2-1D0/SW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2)
      AAABR(5119) = EE**2/MW**2*Me**2/SW**2
      AAABR(5120) = EE**2/MW**2*Me**2/SW**2*sb**2
      AAABR(5121) = EE**2/MW**2*Me/SW**2
      AAABR(5122) = EE**2*cmuth*smuth*(3D0/CW**2-1D0/SW**2
     &      -3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5123) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2+6D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2-2D0*sb**2/SW
     &      **2*smuth**2)
      AAABR(5124) = EE**2*cmuth*sb**2*smuth*(3D0/CW**2-1D0
     &      /SW**2)
      AAABR(5125) = EE**2*ceth*seth*(3D0/CW**2-1D0/SW**2
     &      -3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5126) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2+6D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2-2D0*sb**2/SW**2
     &      *seth**2)
      AAABR(5127) = EE**2*ceth*sb**2*seth*(3D0/CW**2-1D0
     &      /SW**2)
      AAABR(5128) = EE**2*clth*slth*(3D0/CW**2-1D0/SW**2
     &      -3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5129) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2+6D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2-2D0*sb**2/SW**2
     &      *slth**2)
      AAABR(5130) = EE**2*clth*sb**2*slth*(3D0/CW**2-1D0
     &      /SW**2)
      AAABR(5131) = EE**2*ca/cb**2*sa*(1D0/CW**2-1D0/SW**2
     &      -sb**2/CW**2-3D0*slth**2/CW**2+sb**2/SW**2+slth
     &      **2/SW**2+3D0*sb**2/CW**2*slth**2+Ml**2/MW**2
     &      /SW**2-sb**2/SW**2*slth**2)
      AAABR(5132) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*slth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+slth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*slth**2+3D0*sb
     &      **2/CW**2*slth**2-2D0*sa**2/SW**2*sb**2-2D0*sa
     &      **2/SW**2*slth**2-sb**2/SW**2*slth**2-6D0*sa
     &      **2/CW**2*sb**2*slth**2-2D0*Ml**2/MW**2/SW**2
     &      *sa**2+2D0*sa**2/SW**2*sb**2*slth**2)
      AAABR(5133) = EE**2/SW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -slth**2+2D0*sa**2*sb**2+2D0*sa**2*slth**2+sb
     &      **2*slth**2-2D0*sa**2*sb**2*slth**2)
      AAABR(5134) = EE**2/cb**2*clth*slth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sa**2/CW**2-3D0*sb**2/CW**2+2D0*sa
     &      **2/SW**2+sb**2/SW**2+6D0*sa**2/CW**2*sb**2-2D0
     &      *sa**2/SW**2*sb**2)
      AAABR(5135) = EE**2/CW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -3D0*slth**2+2D0*sa**2*sb**2+6D0*sa**2*slth**2
     &      +3D0*sb**2*slth**2-6D0*sa**2*sb**2*slth**2)
      AAABR(5136) = EE**2/CW**3*SW/cb**2*(1D0-2D0*sa**2-sb
     &      **2-3D0*slth**2+2D0*sa**2*sb**2+6D0*sa**2*slth
     &      **2+3D0*sb**2*slth**2-6D0*sa**2*sb**2*slth**2)
      AAABR(5137) = EE**2/MW**2*Ml**2/SW**2/cb**2*sa**2
      AAABR(5138) = EE**2/MW**2*Ml**2/SW**2/cb**2*sa**2*sb
     &      **2
      AAABR(5139) = EE**2/MW**2*Ml/SW**2/cb**2*sa**2
      AAABR(5140) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*seth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+seth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*seth**2+3D0*sb
     &      **2/CW**2*seth**2+2D0*Me**2/MW**2/SW**2-2D0*sa
     &      **2/SW**2*sb**2-2D0*sa**2/SW**2*seth**2-sb**2
     &      /SW**2*seth**2-6D0*sa**2/CW**2*sb**2*seth**2
     &      -2D0*Me**2/MW**2/SW**2*sa**2+2D0*sa**2/SW**2
     &      *sb**2*seth**2)
      AAABR(5141) = EE**2*ca/cb**2*sa*(1D0/CW**2-1D0/SW**2
     &      -sb**2/CW**2-3D0*seth**2/CW**2+sb**2/SW**2+seth
     &      **2/SW**2+3D0*sb**2/CW**2*seth**2+Me**2/MW**2
     &      /SW**2-sb**2/SW**2*seth**2)
      AAABR(5142) = EE**2/SW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -seth**2+2D0*sa**2*sb**2+2D0*sa**2*seth**2+sb
     &      **2*seth**2-2D0*sa**2*sb**2*seth**2)
      AAABR(5143) = EE**2/cb**2*ceth*seth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sa**2/CW**2-3D0*sb**2/CW**2+2D0*sa
     &      **2/SW**2+sb**2/SW**2+6D0*sa**2/CW**2*sb**2-2D0
     &      *sa**2/SW**2*sb**2)
      AAABR(5144) = EE**2/CW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -3D0*seth**2+2D0*sa**2*sb**2+6D0*sa**2*seth**2
     &      +3D0*sb**2*seth**2-6D0*sa**2*sb**2*seth**2)
      AAABR(5145) = EE**2/CW**3*SW/cb**2*(1D0-2D0*sa**2-sb
     &      **2-3D0*seth**2+2D0*sa**2*sb**2+6D0*sa**2*seth
     &      **2+3D0*sb**2*seth**2-6D0*sa**2*sb**2*seth**2)
      AAABR(5146) = EE**2/MW**2*Me**2/SW**2/cb**2*(1D0-sa
     &      **2)
      AAABR(5147) = EE**2/MW**2*Me**2/SW**2/cb**2*sb**2*(1D0
     &      -sa**2)
      AAABR(5148) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-sa**2)
      AAABR(5149) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*slth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+slth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*slth**2+3D0*sb
     &      **2/CW**2*slth**2+2D0*Ml**2/MW**2/SW**2-2D0*sa
     &      **2/SW**2*sb**2-2D0*sa**2/SW**2*slth**2-sb**2
     &      /SW**2*slth**2-6D0*sa**2/CW**2*sb**2*slth**2
     &      -2D0*Ml**2/MW**2/SW**2*sa**2+2D0*sa**2/SW**2
     &      *sb**2*slth**2)
      AAABR(5150) = EE**2/MW**2*Ml**2/SW**2/cb**2*(1D0-sa
     &      **2)
      AAABR(5151) = EE**2/MW**2*Ml**2/SW**2/cb**2*sb**2*(1D0
     &      -sa**2)
      AAABR(5152) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-sa**2)
      AAABR(5153) = EE**2/SW**2*ca/cb**2*sa*(1D0-sb**2-slth
     &      **2+sb**2*slth**2)
      AAABR(5154) = EE**2*ca/cb**2*clth*sa*slth*(3D0/CW**2
     &      -1D0/SW**2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5155) = EE**2/CW**2*ca/cb**2*sa*(1D0-sb**2-3D0
     &      *slth**2+3D0*sb**2*slth**2)
      AAABR(5156) = EE**2/CW**3*SW*ca/cb**2*sa*(1D0-sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5157) = EE**2/MW**2*Ml**2/SW**2*ca/cb**2*sa
      AAABR(5158) = EE**2/MW**2*Ml**2/SW**2*ca/cb**2*sa*sb
     &      **2
      AAABR(5159) = EE**2/MW**2*Ml/SW**2*ca/cb**2*sa
      AAABR(5160) = EE**2*ca/cb**2*sa*(1D0/CW**2-1D0/SW**2
     &      -sb**2/CW**2-3D0*smuth**2/CW**2+sb**2/SW**2+smuth
     &      **2/SW**2+3D0*sb**2/CW**2*smuth**2+Mm**2/MW**2
     &      /SW**2-sb**2/SW**2*smuth**2)
      AAABR(5161) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*smuth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+smuth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*smuth**2+3D0
     &      *sb**2/CW**2*smuth**2-2D0*sa**2/SW**2*sb**2-2D0
     &      *sa**2/SW**2*smuth**2-sb**2/SW**2*smuth**2-6D0
     &      *sa**2/CW**2*sb**2*smuth**2-2D0*Mm**2/MW**2/SW
     &      **2*sa**2+2D0*sa**2/SW**2*sb**2*smuth**2)
      AAABR(5162) = EE**2/SW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -smuth**2+2D0*sa**2*sb**2+2D0*sa**2*smuth**2
     &      +sb**2*smuth**2-2D0*sa**2*sb**2*smuth**2)
      AAABR(5163) = EE**2/cb**2*cmuth*smuth*(3D0/CW**2-1D0
     &      /SW**2-6D0*sa**2/CW**2-3D0*sb**2/CW**2+2D0*sa
     &      **2/SW**2+sb**2/SW**2+6D0*sa**2/CW**2*sb**2-2D0
     &      *sa**2/SW**2*sb**2)
      AAABR(5164) = EE**2/CW**2/cb**2*(1D0-2D0*sa**2-sb**2
     &      -3D0*smuth**2+2D0*sa**2*sb**2+6D0*sa**2*smuth
     &      **2+3D0*sb**2*smuth**2-6D0*sa**2*sb**2*smuth**2)
      AAABR(5165) = EE**2/CW**3*SW/cb**2*(1D0-2D0*sa**2-sb
     &      **2-3D0*smuth**2+2D0*sa**2*sb**2+6D0*sa**2*smuth
     &      **2+3D0*sb**2*smuth**2-6D0*sa**2*sb**2*smuth**2)
      AAABR(5166) = EE**2/MW**2*Mm**2/SW**2/cb**2*sa**2
      AAABR(5167) = EE**2/MW**2*Mm**2/SW**2/cb**2*sa**2*sb
     &      **2
      AAABR(5168) = EE**2/MW**2*Mm/SW**2/cb**2*sa**2
      AAABR(5169) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*seth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+seth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*seth**2+3D0*sb
     &      **2/CW**2*seth**2-2D0*sa**2/SW**2*sb**2-2D0*sa
     &      **2/SW**2*seth**2-sb**2/SW**2*seth**2-6D0*sa
     &      **2/CW**2*sb**2*seth**2-2D0*Me**2/MW**2/SW**2
     &      *sa**2+2D0*sa**2/SW**2*sb**2*seth**2)
      AAABR(5170) = EE**2/SW**2*ca/cb**2*sa*(1D0-sb**2-seth
     &      **2+sb**2*seth**2)
      AAABR(5171) = EE**2*ca/cb**2*ceth*sa*seth*(3D0/CW**2
     &      -1D0/SW**2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5172) = EE**2/CW**2*ca/cb**2*sa*(1D0-sb**2-3D0
     &      *seth**2+3D0*sb**2*seth**2)
      AAABR(5173) = EE**2/CW**3*SW*ca/cb**2*sa*(1D0-sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5174) = EE**2/MW**2*Me**2/SW**2*ca/cb**2*sa
      AAABR(5175) = EE**2/MW**2*Me**2/SW**2*ca/cb**2*sa*sb
     &      **2
      AAABR(5176) = EE**2/MW**2*Me/SW**2*ca/cb**2*sa
      AAABR(5177) = EE**2/MW**2*Me**2/SW**2/cb**2*sa**2
      AAABR(5178) = EE**2/MW**2*Me**2/SW**2/cb**2*sa**2*sb
     &      **2
      AAABR(5179) = EE**2/MW**2*Me/SW**2/cb**2*sa**2
      AAABR(5180) = EE**2/cb**2*(1D0/CW**2-1D0/SW**2-2D0
     &      *sa**2/CW**2-sb**2/CW**2-3D0*smuth**2/CW**2+2D0
     &      *sa**2/SW**2+sb**2/SW**2+smuth**2/SW**2+2D0*sa
     &      **2/CW**2*sb**2+6D0*sa**2/CW**2*smuth**2+3D0
     &      *sb**2/CW**2*smuth**2+2D0*Mm**2/MW**2/SW**2-2D0
     &      *sa**2/SW**2*sb**2-2D0*sa**2/SW**2*smuth**2-sb
     &      **2/SW**2*smuth**2-6D0*sa**2/CW**2*sb**2*smuth
     &      **2-2D0*Mm**2/MW**2/SW**2*sa**2+2D0*sa**2/SW
     &      **2*sb**2*smuth**2)
      AAABR(5181) = EE**2/MW**2*Mm**2/SW**2/cb**2*(1D0-sa
     &      **2)
      AAABR(5182) = EE**2/MW**2*Mm**2/SW**2/cb**2*sb**2*(1D0
     &      -sa**2)
      AAABR(5183) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-sa**2)
      AAABR(5184) = EE**2/SW**2*ca/cb**2*sa*(1D0-sb**2-smuth
     &      **2+sb**2*smuth**2)
      AAABR(5185) = EE**2*ca/cb**2*cmuth*sa*smuth*(3D0/CW
     &      **2-1D0/SW**2-3D0*sb**2/CW**2+sb**2/SW**2)
      AAABR(5186) = EE**2/CW**2*ca/cb**2*sa*(1D0-sb**2-3D0
     &      *smuth**2+3D0*sb**2*smuth**2)
      AAABR(5187) = EE**2/CW**3*SW*ca/cb**2*sa*(1D0-sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5188) = EE**2/MW**2*Mm**2/SW**2*ca/cb**2*sa
      AAABR(5189) = EE**2/MW**2*Mm**2/SW**2*ca/cb**2*sa*sb
     &      **2
      AAABR(5190) = EE**2/MW**2*Mm/SW**2*ca/cb**2*sa
      AAABR(5191) = EE**2/SW**2/cb**2*ceth*seth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5192) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*seth**2/CW**2+seth**2/SW
     &      **2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2*seth
     &      **2+3D0*sb**2/CW**2*seth**2-2D0*sa**2/SW**2*seth
     &      **2-sb**2/SW**2*seth**2-6D0*sa**2/CW**2*sb**2
     &      *seth**2+2D0*Me**2/MW**2/SW**2*sa**2+2D0*sa**2
     &      /SW**2*sb**2*seth**2)
      AAABR(5193) = EE**2/CW**2/cb**2*ceth*seth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5194) = EE**2/CW**3*SW/cb**2*ceth*seth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5195) = EE**2/SW**2/cb**2*clth*slth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5196) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*slth**2/CW**2+slth**2/SW
     &      **2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2*slth
     &      **2+3D0*sb**2/CW**2*slth**2-2D0*sa**2/SW**2*slth
     &      **2-sb**2/SW**2*slth**2-6D0*sa**2/CW**2*sb**2
     &      *slth**2+2D0*Ml**2/MW**2/SW**2*sa**2+2D0*sa**2
     &      /SW**2*sb**2*slth**2)
      AAABR(5197) = EE**2/CW**2/cb**2*clth*slth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5198) = EE**2/CW**3*SW/cb**2*clth*slth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5199) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*seth**2/CW**2+seth**2/SW
     &      **2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2*seth
     &      **2+3D0*sb**2/CW**2*seth**2-2D0*Me**2/MW**2/SW
     &      **2-2D0*sa**2/SW**2*seth**2-sb**2/SW**2*seth
     &      **2-6D0*sa**2/CW**2*sb**2*seth**2+2D0*Me**2/MW
     &      **2/SW**2*sa**2+2D0*sa**2/SW**2*sb**2*seth**2)
      AAABR(5200) = EE**2/SW**2/cb**2*cmuth*smuth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5201) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*smuth**2/CW**2+smuth**2
     &      /SW**2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2
     &      *smuth**2+3D0*sb**2/CW**2*smuth**2-2D0*Mm**2
     &      /MW**2/SW**2-2D0*sa**2/SW**2*smuth**2-sb**2/SW
     &      **2*smuth**2-6D0*sa**2/CW**2*sb**2*smuth**2+2D0
     &      *Mm**2/MW**2/SW**2*sa**2+2D0*sa**2/SW**2*sb**2
     &      *smuth**2)
      AAABR(5202) = EE**2/CW**2/cb**2*cmuth*smuth*(1D0-2D0
     &      *sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5203) = EE**2/CW**3*SW/cb**2*cmuth*smuth*(1D0
     &      -2D0*sa**2-sb**2+2D0*sa**2*sb**2)
      AAABR(5204) = EE**2/SW**2*ca/cb**2*clth*sa*slth*(1D0
     &      -sb**2)
      AAABR(5205) = EE**2*ca/cb**2*sa*(2D0/CW**2-2D0*sb**2
     &      /CW**2-3D0*slth**2/CW**2+slth**2/SW**2+3D0*sb
     &      **2/CW**2*slth**2-Ml**2/MW**2/SW**2-sb**2/SW
     &      **2*slth**2)
      AAABR(5206) = EE**2/CW**2*ca/cb**2*clth*sa*slth*(1D0
     &      -sb**2)
      AAABR(5207) = EE**2/CW**3*SW*ca/cb**2*clth*sa*slth
     &      *(1D0-sb**2)
      AAABR(5208) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*smuth**2/CW**2+smuth**2
     &      /SW**2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2
     &      *smuth**2+3D0*sb**2/CW**2*smuth**2-2D0*sa**2
     &      /SW**2*smuth**2-sb**2/SW**2*smuth**2-6D0*sa**2
     &      /CW**2*sb**2*smuth**2+2D0*Mm**2/MW**2/SW**2*sa
     &      **2+2D0*sa**2/SW**2*sb**2*smuth**2)
      AAABR(5209) = EE**2/SW**2*ca/cb**2*cmuth*sa*smuth*(1D0
     &      -sb**2)
      AAABR(5210) = EE**2*ca/cb**2*sa*(2D0/CW**2-2D0*sb**2
     &      /CW**2-3D0*smuth**2/CW**2+smuth**2/SW**2+3D0
     &      *sb**2/CW**2*smuth**2-Mm**2/MW**2/SW**2-sb**2
     &      /SW**2*smuth**2)
      AAABR(5211) = EE**2/CW**2*ca/cb**2*cmuth*sa*smuth*(1D0
     &      -sb**2)
      AAABR(5212) = EE**2/CW**3*SW*ca/cb**2*cmuth*sa*smuth
     &      *(1D0-sb**2)
      AAABR(5213) = EE**2/cb**2*(2D0/CW**2-4D0*sa**2/CW**2
     &      -2D0*sb**2/CW**2-3D0*slth**2/CW**2+slth**2/SW
     &      **2+4D0*sa**2/CW**2*sb**2+6D0*sa**2/CW**2*slth
     &      **2+3D0*sb**2/CW**2*slth**2-2D0*Ml**2/MW**2/SW
     &      **2-2D0*sa**2/SW**2*slth**2-sb**2/SW**2*slth
     &      **2-6D0*sa**2/CW**2*sb**2*slth**2+2D0*Ml**2/MW
     &      **2/SW**2*sa**2+2D0*sa**2/SW**2*sb**2*slth**2)
      AAABR(5214) = EE**2/SW**2*ca/cb**2*ceth*sa*seth*(1D0
     &      -sb**2)
      AAABR(5215) = EE**2*ca/cb**2*sa*(2D0/CW**2-2D0*sb**2
     &      /CW**2-3D0*seth**2/CW**2+seth**2/SW**2+3D0*sb
     &      **2/CW**2*seth**2-Me**2/MW**2/SW**2-sb**2/SW
     &      **2*seth**2)
      AAABR(5216) = EE**2/CW**2*ca/cb**2*ceth*sa*seth*(1D0
     &      -sb**2)
      AAABR(5217) = EE**2/CW**3*SW*ca/cb**2*ceth*sa*seth
     &      *(1D0-sb**2)
      AAABR(5218) = EE**2/SW**2/cb**2*seth**2*slth**2*(1D0
     &      -sb**2)
      AAABR(5219) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-6D0*slth**2+6D0*sb**2*seth**2+6D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(5220) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-6D0*slth**2+6D0*sb**2*seth**2+6D0*sb
     &      **2*slth**2+9D0*seth**2*slth**2-9D0*sb**2*seth
     &      **2*slth**2)
      AAABR(5221) = EE**2/SW**2/cb**2*slth**4*(1D0-sb**2)
      AAABR(5222) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-12D0
     &      *slth**2+9D0*slth**4+12D0*sb**2*slth**2-9D0*sb
     &      **2*slth**4)
      AAABR(5223) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-12D0
     &      *slth**2+9D0*slth**4+12D0*sb**2*slth**2-9D0*sb
     &      **2*slth**4)
      AAABR(5224) = EE**2/SW**2/cb**2*smuth**4*(1D0-sb**2)
      AAABR(5225) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-12D0
     &      *smuth**2+9D0*smuth**4+12D0*sb**2*smuth**2-9D0
     &      *sb**2*smuth**4)
      AAABR(5226) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-12D0
     &      *smuth**2+9D0*smuth**4+12D0*sb**2*smuth**2-9D0
     &      *sb**2*smuth**4)
      AAABR(5227) = EE**2/SW**2/cb**2*slth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(5228) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *slth**2-6D0*smuth**2+6D0*sb**2*slth**2+6D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(5229) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *slth**2-6D0*smuth**2+6D0*sb**2*slth**2+6D0*sb
     &      **2*smuth**2+9D0*slth**2*smuth**2-9D0*sb**2*slth
     &      **2*smuth**2)
      AAABR(5230) = EE**2/SW**2/cb**2*seth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(5231) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-6D0*smuth**2+6D0*sb**2*seth**2+6D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(5232) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-6D0*smuth**2+6D0*sb**2*seth**2+6D0*sb
     &      **2*smuth**2+9D0*seth**2*smuth**2-9D0*sb**2*seth
     &      **2*smuth**2)
      AAABR(5233) = EE**2/SW**2/cb**2*seth**4*(1D0-sb**2)
      AAABR(5234) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-12D0
     &      *seth**2+9D0*seth**4+12D0*sb**2*seth**2-9D0*sb
     &      **2*seth**4)
      AAABR(5235) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-12D0
     &      *seth**2+9D0*seth**4+12D0*sb**2*seth**2-9D0*sb
     &      **2*seth**4)
      AAABR(5236) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2)
      AAABR(5237) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *smuth**2+3D0*sb**2*smuth**2)
      AAABR(5238) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *smuth**2+3D0*sb**2*smuth**2)
      AAABR(5239) = EE**2/MW**2*Mm**2/SW**2/cb**2*(1D0-smuth
     &      **2)
      AAABR(5240) = EE**2/MW**2*Mm/SW**2/cb**2*(1D0-smuth
     &      **2)
      AAABR(5241) = EE**2/SW**2*smuth**2
      AAABR(5242) = EE**2/CW**2*(2D0-3D0*smuth**2)
      AAABR(5243) = EE**2/CW**3*SW*(2D0-3D0*smuth**2)
      AAABR(5244) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2)
      AAABR(5245) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2+3D0*sb**2*slth**2)
      AAABR(5246) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2+3D0*sb**2*slth**2)
      AAABR(5247) = EE**2/MW**2*Ml**2/SW**2/cb**2*(1D0-slth
     &      **2)
      AAABR(5248) = EE**2/MW**2*Ml/SW**2/cb**2*(1D0-slth**2)
      AAABR(5249) = EE**2/SW**2/cb**2*slth*smuth*(1D0-sb**2)
      AAABR(5250) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*cmuth
      AAABR(5251) = EE**2/MW**2*Ml*Mm/SW**2/cb**2*clth*cmuth
     &      *sb**2
      AAABR(5252) = EE**2/MW**2*Ml/SW**2/cb**2*clth*cmuth
      AAABR(5253) = EE**2/MW**2*Mm/SW**2/cb**2*clth*cmuth
      AAABR(5254) = EE**2/SW**2/cb**2*seth*slth*(1D0-sb**2)
      AAABR(5255) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*clth
      AAABR(5256) = EE**2/MW**2*Me*Ml/SW**2/cb**2*ceth*clth
     &      *sb**2
      AAABR(5257) = EE**2/MW**2*Me/SW**2/cb**2*ceth*clth
      AAABR(5258) = EE**2/MW**2*Ml/SW**2/cb**2*ceth*clth
      AAABR(5259) = EE**2/SW**2*seth**2
      AAABR(5260) = EE**2/CW**2*(2D0-3D0*seth**2)
      AAABR(5261) = EE**2/CW**3*SW*(2D0-3D0*seth**2)
      AAABR(5262) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2)
      AAABR(5263) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2+3D0*sb**2*seth**2)
      AAABR(5264) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2+3D0*sb**2*seth**2)
      AAABR(5265) = EE**2/MW**2*Me**2/SW**2/cb**2*(1D0-seth
     &      **2)
      AAABR(5266) = EE**2/MW**2*Me/SW**2/cb**2*(1D0-seth**2)
      AAABR(5267) = EE**2/SW**2/cb**2*seth*smuth*(1D0-sb**2)
      AAABR(5268) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*cmuth
      AAABR(5269) = EE**2/MW**2*Me*Mm/SW**2/cb**2*ceth*cmuth
     &      *sb**2
      AAABR(5270) = EE**2/MW**2*Me/SW**2/cb**2*ceth*cmuth
      AAABR(5271) = EE**2/MW**2*Mm/SW**2/cb**2*ceth*cmuth
      AAABR(5272) = EE**2/SW**2*slth**2
      AAABR(5273) = EE**2/CW**2*(2D0-3D0*slth**2)
      AAABR(5274) = EE**2/CW**3*SW*(2D0-3D0*slth**2)
      AAABR(5275) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(5276) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*smuth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*smuth**2-3D0*sbth**2*smuth**2+3D0*sb**2*sbth
     &      **2*smuth**2)
      AAABR(5277) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*smuth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*smuth**2-3D0*sbth**2*smuth**2+3D0*sb**2*sbth
     &      **2*smuth**2)
      AAABR(5278) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(5279) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *smuth**2+2D0*ssth**2+3D0*sb**2*smuth**2-2D0
     &      *sb**2*ssth**2-3D0*smuth**2*ssth**2+3D0*sb**2
     &      *smuth**2*ssth**2)
      AAABR(5280) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *smuth**2+2D0*ssth**2+3D0*sb**2*smuth**2-2D0
     &      *sb**2*ssth**2-3D0*smuth**2*ssth**2+3D0*sb**2
     &      *smuth**2*ssth**2)
      AAABR(5281) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(5282) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*slth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*slth**2-3D0*sdth**2*slth**2+3D0*sb**2*sdth
     &      **2*slth**2)
      AAABR(5283) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*slth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*slth**2-3D0*sdth**2*slth**2+3D0*sb**2*sdth
     &      **2*slth**2)
      AAABR(5284) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(5285) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*seth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*seth**2-3D0*sbth**2*seth**2+3D0*sb**2*sbth
     &      **2*seth**2)
      AAABR(5286) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*seth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*seth**2-3D0*sbth**2*seth**2+3D0*sb**2*sbth
     &      **2*seth**2)
      AAABR(5287) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(5288) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*slth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*slth**2-3D0*sbth**2*slth**2+3D0*sb**2*sbth
     &      **2*slth**2)
      AAABR(5289) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-3D0*slth**2-2D0*sb**2*sbth**2+3D0*sb
     &      **2*slth**2-3D0*sbth**2*slth**2+3D0*sb**2*sbth
     &      **2*slth**2)
      AAABR(5290) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(5291) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2+2D0*ssth**2+3D0*sb**2*seth**2-2D0*sb
     &      **2*ssth**2-3D0*seth**2*ssth**2+3D0*sb**2*seth
     &      **2*ssth**2)
      AAABR(5292) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *seth**2+2D0*ssth**2+3D0*sb**2*seth**2-2D0*sb
     &      **2*ssth**2-3D0*seth**2*ssth**2+3D0*sb**2*seth
     &      **2*ssth**2)
      AAABR(5293) = EE**2/SW**2/cb**2*slth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(5294) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2+2D0*ssth**2+3D0*sb**2*slth**2-2D0*sb
     &      **2*ssth**2-3D0*slth**2*ssth**2+3D0*sb**2*slth
     &      **2*ssth**2)
      AAABR(5295) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-3D0
     &      *slth**2+2D0*ssth**2+3D0*sb**2*slth**2-2D0*sb
     &      **2*ssth**2-3D0*slth**2*ssth**2+3D0*sb**2*slth
     &      **2*ssth**2)
      AAABR(5296) = EE**2/SW**2/cb**2*seth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(5297) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*seth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*seth**2-3D0*sdth**2*seth**2+3D0*sb**2*sdth
     &      **2*seth**2)
      AAABR(5298) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*seth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*seth**2-3D0*sdth**2*seth**2+3D0*sb**2*sdth
     &      **2*seth**2)
      AAABR(5299) = EE**2/SW**2/cb**2*smuth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(5300) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*smuth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*smuth**2-3D0*sdth**2*smuth**2+3D0*sb**2*sdth
     &      **2*smuth**2)
      AAABR(5301) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-3D0*smuth**2-2D0*sb**2*sdth**2+3D0*sb
     &      **2*smuth**2-3D0*sdth**2*smuth**2+3D0*sb**2*sdth
     &      **2*smuth**2)
      AAABR(5302) = EE**2/SW**2/cb**2*csth*seth**2*ssth*(1D0
     &      -sb**2)
      AAABR(5303) = EE**2/CW**2/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5304) = EE**2/CW**3*SW/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5305) = EE**2/SW**2/cb**2*cdth*sdth*slth**2*(1D0
     &      -sb**2)
      AAABR(5306) = EE**2/CW**2/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5307) = EE**2/CW**3*SW/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5308) = EE**2/SW**2/cb**2*csth*smuth**2*ssth
     &      *(1D0-sb**2)
      AAABR(5309) = EE**2/CW**2/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5310) = EE**2/CW**3*SW/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5311) = EE**2/SW**2/cb**2*cdth*sdth*seth**2*(1D0
     &      -sb**2)
      AAABR(5312) = EE**2/CW**2/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5313) = EE**2/CW**3*SW/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5314) = EE**2/SW**2/cb**2*csth*slth**2*ssth*(1D0
     &      -sb**2)
      AAABR(5315) = EE**2/CW**2/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5316) = EE**2/CW**3*SW/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5317) = EE**2/SW**2/cb**2*cbth*sbth*slth**2*(1D0
     &      -sb**2)
      AAABR(5318) = EE**2/CW**2/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5319) = EE**2/CW**3*SW/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5320) = EE**2/SW**2/cb**2*cbth*sbth*smuth**2
     &      *(1D0-sb**2)
      AAABR(5321) = EE**2/CW**2/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5322) = EE**2/CW**3*SW/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5323) = EE**2/SW**2/cb**2*cbth*sbth*seth**2*(1D0
     &      -sb**2)
      AAABR(5324) = EE**2/CW**2/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5325) = EE**2/CW**3*SW/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5326) = EE**2/SW**2/cb**2*cdth*sdth*smuth**2
     &      *(1D0-sb**2)
      AAABR(5327) = EE**2/CW**2/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5328) = EE**2/CW**3*SW/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5329) = EE**2/SW**2/cb**2*seth**2*ssth**2*(1D0
     &      -sb**2)
      AAABR(5330) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-2D0*ssth**2+6D0*sb**2*seth**2+2D0*sb
     &      **2*ssth**2+3D0*seth**2*ssth**2-3D0*sb**2*seth
     &      **2*ssth**2)
      AAABR(5331) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *seth**2-2D0*ssth**2+6D0*sb**2*seth**2+2D0*sb
     &      **2*ssth**2+3D0*seth**2*ssth**2-3D0*sb**2*seth
     &      **2*ssth**2)
      AAABR(5332) = EE**2/SW**2/cb**2*sdth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(5333) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*smuth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*smuth**2+3D0*sdth**2*smuth**2-3D0*sb**2*sdth
     &      **2*smuth**2)
      AAABR(5334) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*smuth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*smuth**2+3D0*sdth**2*smuth**2-3D0*sb**2*sdth
     &      **2*smuth**2)
      AAABR(5335) = EE**2/SW**2/cb**2*slth**2*ssth**2*(1D0
     &      -sb**2)
      AAABR(5336) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *slth**2-2D0*ssth**2+6D0*sb**2*slth**2+2D0*sb
     &      **2*ssth**2+3D0*slth**2*ssth**2-3D0*sb**2*slth
     &      **2*ssth**2)
      AAABR(5337) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *slth**2-2D0*ssth**2+6D0*sb**2*slth**2+2D0*sb
     &      **2*ssth**2+3D0*slth**2*ssth**2-3D0*sb**2*slth
     &      **2*ssth**2)
      AAABR(5338) = EE**2/SW**2/cb**2*sbth**2*seth**2*(1D0
     &      -sb**2)
      AAABR(5339) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*seth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*seth**2+3D0*sbth**2*seth**2-3D0*sb**2*sbth
     &      **2*seth**2)
      AAABR(5340) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*seth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*seth**2+3D0*sbth**2*seth**2-3D0*sb**2*sbth
     &      **2*seth**2)
      AAABR(5341) = EE**2/SW**2/cb**2*sbth**2*slth**2*(1D0
     &      -sb**2)
      AAABR(5342) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*slth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*slth**2+3D0*sbth**2*slth**2-3D0*sb**2*sbth
     &      **2*slth**2)
      AAABR(5343) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*slth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*slth**2+3D0*sbth**2*slth**2-3D0*sb**2*sbth
     &      **2*slth**2)
      AAABR(5344) = EE**2/SW**2/cb**2*sbth**2*smuth**2*(1D0
     &      -sb**2)
      AAABR(5345) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*smuth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*smuth**2+3D0*sbth**2*smuth**2-3D0*sb**2*sbth
     &      **2*smuth**2)
      AAABR(5346) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sbth**2-6D0*smuth**2+2D0*sb**2*sbth**2+6D0*sb
     &      **2*smuth**2+3D0*sbth**2*smuth**2-3D0*sb**2*sbth
     &      **2*smuth**2)
      AAABR(5347) = EE**2/SW**2/cb**2*sdth**2*slth**2*(1D0
     &      -sb**2)
      AAABR(5348) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*slth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*slth**2+3D0*sdth**2*slth**2-3D0*sb**2*sdth
     &      **2*slth**2)
      AAABR(5349) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*slth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*slth**2+3D0*sdth**2*slth**2-3D0*sb**2*sdth
     &      **2*slth**2)
      AAABR(5350) = EE**2/SW**2/cb**2*sdth**2*seth**2*(1D0
     &      -sb**2)
      AAABR(5351) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*seth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*seth**2+3D0*sdth**2*seth**2-3D0*sb**2*sdth
     &      **2*seth**2)
      AAABR(5352) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-2D0
     &      *sdth**2-6D0*seth**2+2D0*sb**2*sdth**2+6D0*sb
     &      **2*seth**2+3D0*sdth**2*seth**2-3D0*sb**2*sdth
     &      **2*seth**2)
      AAABR(5353) = EE**2/SW**2/cb**2*smuth**2*ssth**2*(1D0
     &      -sb**2)
      AAABR(5354) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-6D0
     &      *smuth**2-2D0*ssth**2+6D0*sb**2*smuth**2+2D0
     &      *sb**2*ssth**2+3D0*smuth**2*ssth**2-3D0*sb**2
     &      *smuth**2*ssth**2)
      AAABR(5355) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-6D0
     &      *smuth**2-2D0*ssth**2+6D0*sb**2*smuth**2+2D0
     &      *sb**2*ssth**2+3D0*smuth**2*ssth**2-3D0*sb**2
     &      *smuth**2*ssth**2)
      AAABR(5356) = EE**2/SW**2*slth**2*(1D0-scth**2)
      AAABR(5357) = EE**2/CW**2*(2D0-10D0*scth**2-3D0*slth
     &      **2+15D0*scth**2*slth**2)
      AAABR(5358) = EE**2/CW**3*SW*(2D0-10D0*scth**2-3D0
     &      *slth**2+15D0*scth**2*slth**2)
      AAABR(5359) = EE**2/SW**2*smuth**2*(1D0-stth**2)
      AAABR(5360) = EE**2/CW**2*(2D0-3D0*smuth**2-10D0*stth
     &      **2+15D0*smuth**2*stth**2)
      AAABR(5361) = EE**2/CW**3*SW*(2D0-3D0*smuth**2-10D0
     &      *stth**2+15D0*smuth**2*stth**2)
      AAABR(5362) = EE**2/SW**2*smuth**2*(1D0-scth**2)
      AAABR(5363) = EE**2/CW**2*(2D0-10D0*scth**2-3D0*smuth
     &      **2+15D0*scth**2*smuth**2)
      AAABR(5364) = EE**2/CW**3*SW*(2D0-10D0*scth**2-3D0
     &      *smuth**2+15D0*scth**2*smuth**2)
      AAABR(5365) = EE**2/SW**2*seth**2*(1D0-scth**2)
      AAABR(5366) = EE**2/CW**2*(2D0-10D0*scth**2-3D0*seth
     &      **2+15D0*scth**2*seth**2)
      AAABR(5367) = EE**2/CW**3*SW*(2D0-10D0*scth**2-3D0
     &      *seth**2+15D0*scth**2*seth**2)
      AAABR(5368) = EE**2/SW**2*slth**2*(1D0-suth**2)
      AAABR(5369) = EE**2/CW**2*(2D0-3D0*slth**2-10D0*suth
     &      **2+15D0*slth**2*suth**2)
      AAABR(5370) = EE**2/CW**3*SW*(2D0-3D0*slth**2-10D0
     &      *suth**2+15D0*slth**2*suth**2)
      AAABR(5371) = EE**2/SW**2*seth**2*(1D0-suth**2)
      AAABR(5372) = EE**2/CW**2*(2D0-3D0*seth**2-10D0*suth
     &      **2+15D0*seth**2*suth**2)
      AAABR(5373) = EE**2/CW**3*SW*(2D0-3D0*seth**2-10D0
     &      *suth**2+15D0*seth**2*suth**2)
      AAABR(5374) = EE**2/SW**2*seth**2*(1D0-stth**2)
      AAABR(5375) = EE**2/CW**2*(2D0-3D0*seth**2-10D0*stth
     &      **2+15D0*seth**2*stth**2)
      AAABR(5376) = EE**2/CW**3*SW*(2D0-3D0*seth**2-10D0
     &      *stth**2+15D0*seth**2*stth**2)
      AAABR(5377) = EE**2/SW**2*slth**2*(1D0-stth**2)
      AAABR(5378) = EE**2/CW**2*(2D0-3D0*slth**2-10D0*stth
     &      **2+15D0*slth**2*stth**2)
      AAABR(5379) = EE**2/CW**3*SW*(2D0-3D0*slth**2-10D0
     &      *stth**2+15D0*slth**2*stth**2)
      AAABR(5380) = EE**2/SW**2*smuth**2*(1D0-suth**2)
      AAABR(5381) = EE**2/CW**2*(2D0-3D0*smuth**2-10D0*suth
     &      **2+15D0*smuth**2*suth**2)
      AAABR(5382) = EE**2/CW**3*SW*(2D0-3D0*smuth**2-10D0
     &      *suth**2+15D0*smuth**2*suth**2)
      AAABR(5383) = EE**2/SW**2*ctth*smuth**2*stth
      AAABR(5384) = EE**2/CW**2*ctth*stth*(2D0-3D0*smuth**2)
      AAABR(5385) = EE**2/CW**3*SW*ctth*stth*(2D0-3D0*smuth
     &      **2)
      AAABR(5386) = EE**2/SW**2*ctth*seth**2*stth
      AAABR(5387) = EE**2/CW**2*ctth*stth*(2D0-3D0*seth**2)
      AAABR(5388) = EE**2/CW**3*SW*ctth*stth*(2D0-3D0*seth
     &      **2)
      AAABR(5389) = EE**2/SW**2*cuth*seth**2*suth
      AAABR(5390) = EE**2/CW**2*cuth*suth*(2D0-3D0*seth**2)
      AAABR(5391) = EE**2/CW**3*SW*cuth*suth*(2D0-3D0*seth
     &      **2)
      AAABR(5392) = EE**2/SW**2*cuth*slth**2*suth
      AAABR(5393) = EE**2/CW**2*cuth*suth*(2D0-3D0*slth**2)
      AAABR(5394) = EE**2/CW**3*SW*cuth*suth*(2D0-3D0*slth
     &      **2)
      AAABR(5395) = EE**2/SW**2*ccth*scth*slth**2
      AAABR(5396) = EE**2/CW**2*ccth*scth*(2D0-3D0*slth**2)
      AAABR(5397) = EE**2/CW**3*SW*ccth*scth*(2D0-3D0*slth
     &      **2)
      AAABR(5398) = EE**2/SW**2*ccth*scth*seth**2
      AAABR(5399) = EE**2/CW**2*ccth*scth*(2D0-3D0*seth**2)
      AAABR(5400) = EE**2/CW**3*SW*ccth*scth*(2D0-3D0*seth
     &      **2)
      AAABR(5401) = EE**2/SW**2*cuth*smuth**2*suth
      AAABR(5402) = EE**2/CW**2*cuth*suth*(2D0-3D0*smuth**2)
      AAABR(5403) = EE**2/CW**3*SW*cuth*suth*(2D0-3D0*smuth
     &      **2)
      AAABR(5404) = EE**2/SW**2*ccth*scth*smuth**2
      AAABR(5405) = EE**2/CW**2*ccth*scth*(2D0-3D0*smuth**2)
      AAABR(5406) = EE**2/CW**3*SW*ccth*scth*(2D0-3D0*smuth
     &      **2)
      AAABR(5407) = EE**2/SW**2*ctth*slth**2*stth
      AAABR(5408) = EE**2/CW**2*ctth*stth*(2D0-3D0*slth**2)
      AAABR(5409) = EE**2/CW**3*SW*ctth*stth*(2D0-3D0*slth
     &      **2)
      AAABR(5410) = EE**2/SW**2/cb**2*cdth*cuth*slth*(1D0
     &      -sb**2)
      AAABR(5411) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*cuth
     &      *sdth
      AAABR(5412) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*cuth
     &      *sb**2*sdth
      AAABR(5413) = EE**2/MW**2*Ml/SW**2/cb**2*clth*cuth
     &      *sdth
      AAABR(5414) = EE**2/MW**2*Md/SW**2/cb**2*clth*cuth
     &      *sdth
      AAABR(5415) = EE**2/SW**2/cb**2*cbth*ctth*smuth*(1D0
     &      -sb**2)
      AAABR(5416) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*ctth
     &      *sbth
      AAABR(5417) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*ctth
     &      *sb**2*sbth
      AAABR(5418) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*ctth
     &      *sbth
      AAABR(5419) = EE**2/MW**2*Mb/SW**2/cb**2*cmuth*ctth
     &      *sbth
      AAABR(5420) = EE**2/SW**2/cb**2*ccth*csth*smuth*(1D0
     &      -sb**2)
      AAABR(5421) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*cmuth
     &      *ssth
      AAABR(5422) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*cmuth
     &      *sb**2*ssth
      AAABR(5423) = EE**2/MW**2*Mm/SW**2/cb**2*ccth*cmuth
     &      *ssth
      AAABR(5424) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*cmuth
     &      *ssth
      AAABR(5425) = EE**2/SW**2/cb**2*cdth*cuth*seth*(1D0
     &      -sb**2)
      AAABR(5426) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*cuth
     &      *sdth
      AAABR(5427) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*cuth
     &      *sb**2*sdth
      AAABR(5428) = EE**2/MW**2*Me/SW**2/cb**2*ceth*cuth
     &      *sdth
      AAABR(5429) = EE**2/MW**2*Md/SW**2/cb**2*ceth*cuth
     &      *sdth
      AAABR(5430) = EE**2/SW**2/cb**2*cdth*cuth*smuth*(1D0
     &      -sb**2)
      AAABR(5431) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*cuth
     &      *sdth
      AAABR(5432) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*cuth
     &      *sb**2*sdth
      AAABR(5433) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*cuth
     &      *sdth
      AAABR(5434) = EE**2/MW**2*Md/SW**2/cb**2*cmuth*cuth
     &      *sdth
      AAABR(5435) = EE**2/SW**2/cb**2*ccth*csth*seth*(1D0
     &      -sb**2)
      AAABR(5436) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*ceth
     &      *ssth
      AAABR(5437) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*ceth
     &      *sb**2*ssth
      AAABR(5438) = EE**2/MW**2*Me/SW**2/cb**2*ccth*ceth
     &      *ssth
      AAABR(5439) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*ceth
     &      *ssth
      AAABR(5440) = EE**2/SW**2/cb**2*cbth*ctth*slth*(1D0
     &      -sb**2)
      AAABR(5441) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*ctth
     &      *sbth
      AAABR(5442) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*ctth
     &      *sb**2*sbth
      AAABR(5443) = EE**2/MW**2*Ml/SW**2/cb**2*clth*ctth
     &      *sbth
      AAABR(5444) = EE**2/MW**2*Mb/SW**2/cb**2*clth*ctth
     &      *sbth
      AAABR(5445) = EE**2/SW**2/cb**2*ccth*csth*slth*(1D0
     &      -sb**2)
      AAABR(5446) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*clth
     &      *ssth
      AAABR(5447) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*clth
     &      *sb**2*ssth
      AAABR(5448) = EE**2/MW**2*Ml/SW**2/cb**2*ccth*clth
     &      *ssth
      AAABR(5449) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*clth
     &      *ssth
      AAABR(5450) = EE**2/SW**2/cb**2*cbth*ctth*seth*(1D0
     &      -sb**2)
      AAABR(5451) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*ctth
     &      *sbth
      AAABR(5452) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*ctth
     &      *sb**2*sbth
      AAABR(5453) = EE**2/MW**2*Me/SW**2/cb**2*ceth*ctth
     &      *sbth
      AAABR(5454) = EE**2/MW**2*Mb/SW**2/cb**2*ceth*ctth
     &      *sbth
      AAABR(5455) = EE**2/SW**2/cb**2*ctth*sbth*seth*(1D0
     &      -sb**2)
      AAABR(5456) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *ctth
      AAABR(5457) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *ctth*sb**2
      AAABR(5458) = EE**2/MW**2*Me/SW**2/cb**2*cbth*ceth
     &      *ctth
      AAABR(5459) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ceth
     &      *ctth
      AAABR(5460) = EE**2/SW**2/cb**2*ctth*sbth*smuth*(1D0
     &      -sb**2)
      AAABR(5461) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *ctth
      AAABR(5462) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *ctth*sb**2
      AAABR(5463) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*cmuth
     &      *ctth
      AAABR(5464) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*cmuth
     &      *ctth
      AAABR(5465) = EE**2/SW**2/cb**2*ccth*seth*ssth*(1D0
     &      -sb**2)
      AAABR(5466) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*ceth
     &      *csth
      AAABR(5467) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ccth*ceth
     &      *csth*sb**2
      AAABR(5468) = EE**2/MW**2*Me/SW**2/cb**2*ccth*ceth
     &      *csth
      AAABR(5469) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*ceth
     &      *csth
      AAABR(5470) = EE**2/SW**2/cb**2*cuth*sdth*seth*(1D0
     &      -sb**2)
      AAABR(5471) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *cuth
      AAABR(5472) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *cuth*sb**2
      AAABR(5473) = EE**2/MW**2*Me/SW**2/cb**2*cdth*ceth
     &      *cuth
      AAABR(5474) = EE**2/MW**2*Md/SW**2/cb**2*cdth*ceth
     &      *cuth
      AAABR(5475) = EE**2/SW**2/cb**2*ccth*smuth*ssth*(1D0
     &      -sb**2)
      AAABR(5476) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*cmuth
     &      *csth
      AAABR(5477) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*ccth*cmuth
     &      *csth*sb**2
      AAABR(5478) = EE**2/MW**2*Mm/SW**2/cb**2*ccth*cmuth
     &      *csth
      AAABR(5479) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*cmuth
     &      *csth
      AAABR(5480) = EE**2/SW**2/cb**2*ctth*sbth*slth*(1D0
     &      -sb**2)
      AAABR(5481) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *ctth
      AAABR(5482) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *ctth*sb**2
      AAABR(5483) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*clth
     &      *ctth
      AAABR(5484) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*clth
     &      *ctth
      AAABR(5485) = EE**2/SW**2/cb**2*cuth*sdth*slth*(1D0
     &      -sb**2)
      AAABR(5486) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *cuth
      AAABR(5487) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *cuth*sb**2
      AAABR(5488) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*clth
     &      *cuth
      AAABR(5489) = EE**2/MW**2*Md/SW**2/cb**2*cdth*clth
     &      *cuth
      AAABR(5490) = EE**2/SW**2/cb**2*cuth*sdth*smuth*(1D0
     &      -sb**2)
      AAABR(5491) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *cuth
      AAABR(5492) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *cuth*sb**2
      AAABR(5493) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*cmuth
     &      *cuth
      AAABR(5494) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cmuth
     &      *cuth
      AAABR(5495) = EE**2/SW**2/cb**2*ccth*slth*ssth*(1D0
     &      -sb**2)
      AAABR(5496) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*clth
     &      *csth
      AAABR(5497) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*ccth*clth
     &      *csth*sb**2
      AAABR(5498) = EE**2/MW**2*Ml/SW**2/cb**2*ccth*clth
     &      *csth
      AAABR(5499) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*clth
     &      *csth
      AAABR(5500) = EE**2/SW**2*scth**2*slth**2
      AAABR(5501) = EE**2/CW**2*(8D0-10D0*scth**2-12D0*slth
     &      **2+15D0*scth**2*slth**2)
      AAABR(5502) = EE**2/CW**3*SW*(8D0-10D0*scth**2-12D0
     &      *slth**2+15D0*scth**2*slth**2)
      AAABR(5503) = EE**2/SW**2*slth**2*stth**2
      AAABR(5504) = EE**2/CW**2*(8D0-12D0*slth**2-10D0*stth
     &      **2+15D0*slth**2*stth**2)
      AAABR(5505) = EE**2/CW**3*SW*(8D0-12D0*slth**2-10D0
     &      *stth**2+15D0*slth**2*stth**2)
      AAABR(5506) = EE**2/SW**2*scth**2*seth**2
      AAABR(5507) = EE**2/CW**2*(8D0-10D0*scth**2-12D0*seth
     &      **2+15D0*scth**2*seth**2)
      AAABR(5508) = EE**2/CW**3*SW*(8D0-10D0*scth**2-12D0
     &      *seth**2+15D0*scth**2*seth**2)
      AAABR(5509) = EE**2/SW**2*scth**2*smuth**2
      AAABR(5510) = EE**2/CW**2*(8D0-10D0*scth**2-12D0*smuth
     &      **2+15D0*scth**2*smuth**2)
      AAABR(5511) = EE**2/CW**3*SW*(8D0-10D0*scth**2-12D0
     &      *smuth**2+15D0*scth**2*smuth**2)
      AAABR(5512) = EE**2/SW**2*seth**2*suth**2
      AAABR(5513) = EE**2/CW**2*(8D0-12D0*seth**2-10D0*suth
     &      **2+15D0*seth**2*suth**2)
      AAABR(5514) = EE**2/CW**3*SW*(8D0-12D0*seth**2-10D0
     &      *suth**2+15D0*seth**2*suth**2)
      AAABR(5515) = EE**2/SW**2*seth**2*stth**2
      AAABR(5516) = EE**2/CW**2*(8D0-12D0*seth**2-10D0*stth
     &      **2+15D0*seth**2*stth**2)
      AAABR(5517) = EE**2/CW**3*SW*(8D0-12D0*seth**2-10D0
     &      *stth**2+15D0*seth**2*stth**2)
      AAABR(5518) = EE**2/SW**2*smuth**2*suth**2
      AAABR(5519) = EE**2/CW**2*(8D0-12D0*smuth**2-10D0*suth
     &      **2+15D0*smuth**2*suth**2)
      AAABR(5520) = EE**2/CW**3*SW*(8D0-12D0*smuth**2-10D0
     &      *suth**2+15D0*smuth**2*suth**2)
      AAABR(5521) = EE**2/SW**2*slth**2*suth**2
      AAABR(5522) = EE**2/CW**2*(8D0-12D0*slth**2-10D0*suth
     &      **2+15D0*slth**2*suth**2)
      AAABR(5523) = EE**2/CW**3*SW*(8D0-12D0*slth**2-10D0
     &      *suth**2+15D0*slth**2*suth**2)
      AAABR(5524) = EE**2/SW**2*smuth**2*stth**2
      AAABR(5525) = EE**2/CW**2*(8D0-12D0*smuth**2-10D0*stth
     &      **2+15D0*smuth**2*stth**2)
      AAABR(5526) = EE**2/CW**3*SW*(8D0-12D0*smuth**2-10D0
     &      *stth**2+15D0*smuth**2*stth**2)
      AAABR(5527) = EE**2/SW**2/cb**2*cdth*smuth*suth*(1D0
     &      -sb**2)
      AAABR(5528) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*sdth
     &      *suth
      AAABR(5529) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cmuth*sb
     &      **2*sdth*suth
      AAABR(5530) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*sdth
     &      *suth
      AAABR(5531) = EE**2/MW**2*Md/SW**2/cb**2*cmuth*sdth
     &      *suth
      AAABR(5532) = EE**2/SW**2/cb**2*cbth*seth*stth*(1D0
     &      -sb**2)
      AAABR(5533) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*sbth
     &      *stth
      AAABR(5534) = EE**2/MW**2*Mb*Me/SW**2/cb**2*ceth*sb
     &      **2*sbth*stth
      AAABR(5535) = EE**2/MW**2*Me/SW**2/cb**2*ceth*sbth
     &      *stth
      AAABR(5536) = EE**2/MW**2*Mb/SW**2/cb**2*ceth*sbth
     &      *stth
      AAABR(5537) = EE**2/SW**2/cb**2*cbth*smuth*stth*(1D0
     &      -sb**2)
      AAABR(5538) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*sbth
     &      *stth
      AAABR(5539) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cmuth*sb
     &      **2*sbth*stth
      AAABR(5540) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*sbth
     &      *stth
      AAABR(5541) = EE**2/MW**2*Mb/SW**2/cb**2*cmuth*sbth
     &      *stth
      AAABR(5542) = EE**2/SW**2/cb**2*csth*scth*smuth*(1D0
     &      -sb**2)
      AAABR(5543) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*scth
     &      *ssth
      AAABR(5544) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*sb
     &      **2*scth*ssth
      AAABR(5545) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*scth
     &      *ssth
      AAABR(5546) = EE**2/MW**2*Ms/SW**2/cb**2*cmuth*scth
     &      *ssth
      AAABR(5547) = EE**2/SW**2/cb**2*cdth*slth*suth*(1D0
     &      -sb**2)
      AAABR(5548) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*sdth
     &      *suth
      AAABR(5549) = EE**2/MW**2*Md*Ml/SW**2/cb**2*clth*sb
     &      **2*sdth*suth
      AAABR(5550) = EE**2/MW**2*Ml/SW**2/cb**2*clth*sdth
     &      *suth
      AAABR(5551) = EE**2/MW**2*Md/SW**2/cb**2*clth*sdth
     &      *suth
      AAABR(5552) = EE**2/SW**2/cb**2*cdth*seth*suth*(1D0
     &      -sb**2)
      AAABR(5553) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*sdth
     &      *suth
      AAABR(5554) = EE**2/MW**2*Md*Me/SW**2/cb**2*ceth*sb
     &      **2*sdth*suth
      AAABR(5555) = EE**2/MW**2*Me/SW**2/cb**2*ceth*sdth
     &      *suth
      AAABR(5556) = EE**2/MW**2*Md/SW**2/cb**2*ceth*sdth
     &      *suth
      AAABR(5557) = EE**2/SW**2/cb**2*csth*scth*seth*(1D0
     &      -sb**2)
      AAABR(5558) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*scth
     &      *ssth
      AAABR(5559) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*sb
     &      **2*scth*ssth
      AAABR(5560) = EE**2/MW**2*Me/SW**2/cb**2*ceth*scth
     &      *ssth
      AAABR(5561) = EE**2/MW**2*Ms/SW**2/cb**2*ceth*scth
     &      *ssth
      AAABR(5562) = EE**2/SW**2/cb**2*cbth*slth*stth*(1D0
     &      -sb**2)
      AAABR(5563) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*sbth
     &      *stth
      AAABR(5564) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*clth*sb
     &      **2*sbth*stth
      AAABR(5565) = EE**2/MW**2*Ml/SW**2/cb**2*clth*sbth
     &      *stth
      AAABR(5566) = EE**2/MW**2*Mb/SW**2/cb**2*clth*sbth
     &      *stth
      AAABR(5567) = EE**2/SW**2/cb**2*csth*scth*slth*(1D0
     &      -sb**2)
      AAABR(5568) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*scth
     &      *ssth
      AAABR(5569) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*sb
     &      **2*scth*ssth
      AAABR(5570) = EE**2/MW**2*Ml/SW**2/cb**2*clth*scth
     &      *ssth
      AAABR(5571) = EE**2/MW**2*Ms/SW**2/cb**2*clth*scth
     &      *ssth
      AAABR(5572) = EE**2/SW**2/cb**2*sbth*seth*stth*(1D0
     &      -sb**2)
      AAABR(5573) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *stth
      AAABR(5574) = EE**2/MW**2*Mb*Me/SW**2/cb**2*cbth*ceth
     &      *sb**2*stth
      AAABR(5575) = EE**2/MW**2*Me/SW**2/cb**2*cbth*ceth
     &      *stth
      AAABR(5576) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ceth
     &      *stth
      AAABR(5577) = EE**2/SW**2/cb**2*sdth*slth*suth*(1D0
     &      -sb**2)
      AAABR(5578) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *suth
      AAABR(5579) = EE**2/MW**2*Md*Ml/SW**2/cb**2*cdth*clth
     &      *sb**2*suth
      AAABR(5580) = EE**2/MW**2*Ml/SW**2/cb**2*cdth*clth
     &      *suth
      AAABR(5581) = EE**2/MW**2*Md/SW**2/cb**2*cdth*clth
     &      *suth
      AAABR(5582) = EE**2/SW**2/cb**2*sdth*smuth*suth*(1D0
     &      -sb**2)
      AAABR(5583) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *suth
      AAABR(5584) = EE**2/MW**2*Md*Mm/SW**2/cb**2*cdth*cmuth
     &      *sb**2*suth
      AAABR(5585) = EE**2/MW**2*Mm/SW**2/cb**2*cdth*cmuth
     &      *suth
      AAABR(5586) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cmuth
     &      *suth
      AAABR(5587) = EE**2/SW**2/cb**2*sbth*slth*stth*(1D0
     &      -sb**2)
      AAABR(5588) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *stth
      AAABR(5589) = EE**2/MW**2*Mb*Ml/SW**2/cb**2*cbth*clth
     &      *sb**2*stth
      AAABR(5590) = EE**2/MW**2*Ml/SW**2/cb**2*cbth*clth
     &      *stth
      AAABR(5591) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*clth
     &      *stth
      AAABR(5592) = EE**2/SW**2/cb**2*scth*seth*ssth*(1D0
     &      -sb**2)
      AAABR(5593) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*csth
     &      *scth
      AAABR(5594) = EE**2/MW**2*Me*Ms/SW**2/cb**2*ceth*csth
     &      *sb**2*scth
      AAABR(5595) = EE**2/MW**2*Me/SW**2/cb**2*ceth*csth
     &      *scth
      AAABR(5596) = EE**2/MW**2*Ms/SW**2/cb**2*ceth*csth
     &      *scth
      AAABR(5597) = EE**2/SW**2/cb**2*scth*smuth*ssth*(1D0
     &      -sb**2)
      AAABR(5598) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*csth
     &      *scth
      AAABR(5599) = EE**2/MW**2*Mm*Ms/SW**2/cb**2*cmuth*csth
     &      *sb**2*scth
      AAABR(5600) = EE**2/MW**2*Mm/SW**2/cb**2*cmuth*csth
     &      *scth
      AAABR(5601) = EE**2/MW**2*Ms/SW**2/cb**2*cmuth*csth
     &      *scth
      AAABR(5602) = EE**2/SW**2/cb**2*scth*slth*ssth*(1D0
     &      -sb**2)
      AAABR(5603) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*csth
     &      *scth
      AAABR(5604) = EE**2/MW**2*Ml*Ms/SW**2/cb**2*clth*csth
     &      *sb**2*scth
      AAABR(5605) = EE**2/MW**2*Ml/SW**2/cb**2*clth*csth
     &      *scth
      AAABR(5606) = EE**2/MW**2*Ms/SW**2/cb**2*clth*csth
     &      *scth
      AAABR(5607) = EE**2/SW**2/cb**2*sbth*smuth*stth*(1D0
     &      -sb**2)
      AAABR(5608) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *stth
      AAABR(5609) = EE**2/MW**2*Mb*Mm/SW**2/cb**2*cbth*cmuth
     &      *sb**2*stth
      AAABR(5610) = EE**2/MW**2*Mm/SW**2/cb**2*cbth*cmuth
     &      *stth
      AAABR(5611) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*cmuth
     &      *stth
      AAABR(5612) = EE**2/SW**2/cb**2*sdth*seth*suth*(1D0
     &      -sb**2)
      AAABR(5613) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *suth
      AAABR(5614) = EE**2/MW**2*Md*Me/SW**2/cb**2*cdth*ceth
     &      *sb**2*suth
      AAABR(5615) = EE**2/MW**2*Me/SW**2/cb**2*cdth*ceth
     &      *suth
      AAABR(5616) = EE**2/MW**2*Md/SW**2/cb**2*cdth*ceth
     &      *suth
      AAABR(5617) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2-smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2+sb**2/SW**2*smuth
     &      **2+2D0*Mm**2/MW**2/SW**2*smuth**2)
      AAABR(5618) = EE**2/SW**2*smuth**2*(1D0-2D0*sb**2)
      AAABR(5619) = EE**2*sb**2*(2D0/CW**2-3D0*smuth**2/CW
     &      **2-smuth**2/SW**2)
      AAABR(5620) = EE**2/CW**2*(2D0-4D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(5621) = EE**2/CW**3*SW*(2D0-4D0*sb**2-3D0*smuth
     &      **2+6D0*sb**2*smuth**2)
      AAABR(5622) = EE**2/MW**2*Mm**2/SW**2*(1D0-smuth**2)
      AAABR(5623) = EE**2/MW**2*Mm**2/SW**2*sb**2*(1D0-smuth
     &      **2)
      AAABR(5624) = EE**2/MW**2*Mm/SW**2*(1D0-smuth**2)
      AAABR(5625) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2-seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2+sb**2/SW**2*seth
     &      **2+2D0*Me**2/MW**2/SW**2*seth**2)
      AAABR(5626) = EE**2/SW**2*seth**2*(1D0-2D0*sb**2)
      AAABR(5627) = EE**2*sb**2*(2D0/CW**2-3D0*seth**2/CW
     &      **2-seth**2/SW**2)
      AAABR(5628) = EE**2/CW**2*(2D0-4D0*sb**2-3D0*seth**2
     &      +6D0*sb**2*seth**2)
      AAABR(5629) = EE**2/CW**3*SW*(2D0-4D0*sb**2-3D0*seth
     &      **2+6D0*sb**2*seth**2)
      AAABR(5630) = EE**2/MW**2*Me**2/SW**2*(1D0-seth**2)
      AAABR(5631) = EE**2/MW**2*Me**2/SW**2*sb**2*(1D0-seth
     &      **2)
      AAABR(5632) = EE**2/MW**2*Me/SW**2*(1D0-seth**2)
      AAABR(5633) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2-slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2+sb**2/SW**2*slth
     &      **2+2D0*Ml**2/MW**2/SW**2*slth**2)
      AAABR(5634) = EE**2/SW**2*slth**2*(1D0-2D0*sb**2)
      AAABR(5635) = EE**2*sb**2*(2D0/CW**2-3D0*slth**2/CW
     &      **2-slth**2/SW**2)
      AAABR(5636) = EE**2/CW**2*(2D0-4D0*sb**2-3D0*slth**2
     &      +6D0*sb**2*slth**2)
      AAABR(5637) = EE**2/CW**3*SW*(2D0-4D0*sb**2-3D0*slth
     &      **2+6D0*sb**2*slth**2)
      AAABR(5638) = EE**2/MW**2*Ml**2/SW**2*(1D0-slth**2)
      AAABR(5639) = EE**2/MW**2*Ml**2/SW**2*sb**2*(1D0-slth
     &      **2)
      AAABR(5640) = EE**2/MW**2*Ml/SW**2*(1D0-slth**2)
      AAABR(5641) = EE**2/SW**2*Sqrt2*smuth*(1D0-sb**2-Mm
     &      **2/MW**2)
      AAABR(5642) = EE**2/SW**2*Sqrt2*smuth*(1D0-2D0*sb**2)
      AAABR(5643) = EE**2/SW**2*Sqrt2*sb**2*smuth
      AAABR(5644) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*smuth
      AAABR(5645) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*sb**2*smuth
     &      
      AAABR(5646) = EE**2/MW**2*Mm/SW**2*Sqrt2*smuth
      AAABR(5647) = EE**2/SW**2*Sqrt2*slth*(1D0-sb**2-Ml
     &      **2/MW**2)
      AAABR(5648) = EE**2/SW**2*Sqrt2*slth*(1D0-2D0*sb**2)
      AAABR(5649) = EE**2/SW**2*Sqrt2*sb**2*slth
      AAABR(5650) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*slth
      AAABR(5651) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*sb**2*slth
      AAABR(5652) = EE**2/MW**2*Ml/SW**2*Sqrt2*slth
      AAABR(5653) = EE**2/SW**2*Sqrt2*seth*(1D0-sb**2-Me
     &      **2/MW**2)
      AAABR(5654) = EE**2/SW**2*Sqrt2*seth*(1D0-2D0*sb**2)
      AAABR(5655) = EE**2/SW**2*Sqrt2*sb**2*seth
      AAABR(5656) = EE**2/MW**2*Me**2/SW**2*Sqrt2*seth
      AAABR(5657) = EE**2/MW**2*Me**2/SW**2*Sqrt2*sb**2*seth
      AAABR(5658) = EE**2/MW**2*Me/SW**2*Sqrt2*seth
      AAABR(5659) = EE**2/SW**2*Sqrt2*ca/cb*smuth*(1D0-sb
     &      **2-Mm**2/MW**2)
      AAABR(5660) = EE**2/SW**2*Sqrt2*smuth*(ca/cb-sa*sb
     &      -ca/cb*sb**2)
      AAABR(5661) = EE**2/SW**2*Sqrt2*sa*sb*smuth
      AAABR(5662) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb*smuth
     &      
      AAABR(5663) = EE**2/MW**2*Mm**2/SW**2*Sqrt2*ca/cb*sb
     &      **2*smuth
      AAABR(5664) = EE**2/MW**2*Mm/SW**2*Sqrt2*ca/cb*smuth
      AAABR(5665) = EE**2/SW**2*Sqrt2/cb*sa*seth*(1D0-sb
     &      **2-Me**2/MW**2)
      AAABR(5666) = EE**2/SW**2*Sqrt2*seth*(ca*sb+sa/cb-sa
     &      /cb*sb**2)
      AAABR(5667) = EE**2/SW**2*Sqrt2*ca*sb*seth
      AAABR(5668) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb*sa*seth
      AAABR(5669) = EE**2/MW**2*Me**2/SW**2*Sqrt2/cb*sa*sb
     &      **2*seth
      AAABR(5670) = EE**2/MW**2*Me/SW**2*Sqrt2/cb*sa*seth
      AAABR(5671) = EE**2/SW**2*Sqrt2*ca/cb*seth*(1D0-sb
     &      **2-Me**2/MW**2)
      AAABR(5672) = EE**2/SW**2*Sqrt2*seth*(ca/cb-sa*sb-ca
     &      /cb*sb**2)
      AAABR(5673) = EE**2/SW**2*Sqrt2*sa*sb*seth
      AAABR(5674) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb*seth
      AAABR(5675) = EE**2/MW**2*Me**2/SW**2*Sqrt2*ca/cb*sb
     &      **2*seth
      AAABR(5676) = EE**2/MW**2*Me/SW**2*Sqrt2*ca/cb*seth
      AAABR(5677) = EE**2/SW**2*Sqrt2/cb*sa*slth*(1D0-sb
     &      **2-Ml**2/MW**2)
      AAABR(5678) = EE**2/SW**2*Sqrt2*slth*(ca*sb+sa/cb-sa
     &      /cb*sb**2)
      AAABR(5679) = EE**2/SW**2*Sqrt2*ca*sb*slth
      AAABR(5680) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb*sa*slth
      AAABR(5681) = EE**2/MW**2*Ml**2/SW**2*Sqrt2/cb*sa*sb
     &      **2*slth
      AAABR(5682) = EE**2/MW**2*Ml/SW**2*Sqrt2/cb*sa*slth
      AAABR(5683) = EE**2/SW**2*Sqrt2/cb*sa*smuth*(1D0-sb
     &      **2-Mm**2/MW**2)
      AAABR(5684) = EE**2/SW**2*Sqrt2*smuth*(ca*sb+sa/cb
     &      -sa/cb*sb**2)
      AAABR(5685) = EE**2/SW**2*Sqrt2*ca*sb*smuth
      AAABR(5686) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb*sa*smuth
     &      
      AAABR(5687) = EE**2/MW**2*Mm**2/SW**2*Sqrt2/cb*sa*sb
     &      **2*smuth
      AAABR(5688) = EE**2/MW**2*Mm/SW**2*Sqrt2/cb*sa*smuth
      AAABR(5689) = EE**2/SW**2*Sqrt2*ca/cb*slth*(1D0-sb
     &      **2-Ml**2/MW**2)
      AAABR(5690) = EE**2/SW**2*Sqrt2*slth*(ca/cb-sa*sb-ca
     &      /cb*sb**2)
      AAABR(5691) = EE**2/SW**2*Sqrt2*sa*sb*slth
      AAABR(5692) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb*slth
      AAABR(5693) = EE**2/MW**2*Ml**2/SW**2*Sqrt2*ca/cb*sb
     &      **2*slth
      AAABR(5694) = EE**2/MW**2*Ml/SW**2*Sqrt2*ca/cb*slth
      AAABR(5695) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *seth**2/CW**2+seth**2/SW**2+3D0*sb**2/CW**2
     &      *seth**2-2D0*Me**2/MW**2/SW**2-sb**2/SW**2*seth
     &      **2)
      AAABR(5696) = EE**2*sb**2*(2D0/CW**2-3D0*seth**2/CW
     &      **2+seth**2/SW**2)
      AAABR(5697) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *slth**2/CW**2+slth**2/SW**2+3D0*sb**2/CW**2
     &      *slth**2-2D0*Ml**2/MW**2/SW**2-sb**2/SW**2*slth
     &      **2)
      AAABR(5698) = EE**2*sb**2*(2D0/CW**2-3D0*slth**2/CW
     &      **2+slth**2/SW**2)
      AAABR(5699) = EE**2*(2D0/CW**2-2D0*sb**2/CW**2-3D0
     &      *smuth**2/CW**2+smuth**2/SW**2+3D0*sb**2/CW**2
     &      *smuth**2-2D0*Mm**2/MW**2/SW**2-sb**2/SW**2*smuth
     &      **2)
      AAABR(5700) = EE**2*sb**2*(2D0/CW**2-3D0*smuth**2/CW
     &      **2+smuth**2/SW**2)
      AAABR(5701) = EE**2/SW**2/cb**2*seth**2*(1D0-2D0*sa
     &      **2-sb**2+2D0*sa**2*sb**2)
      AAABR(5702) = EE**2/CW**2/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*seth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *seth**2+3D0*sb**2*seth**2-6D0*sa**2*sb**2*seth
     &      **2)
      AAABR(5703) = EE**2/CW**3*SW/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*seth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *seth**2+3D0*sb**2*seth**2-6D0*sa**2*sb**2*seth
     &      **2)
      AAABR(5704) = EE**2/SW**2/cb**2*smuth**2*(1D0-2D0*sa
     &      **2-sb**2+2D0*sa**2*sb**2)
      AAABR(5705) = EE**2/CW**2/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*smuth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *smuth**2+3D0*sb**2*smuth**2-6D0*sa**2*sb**2
     &      *smuth**2)
      AAABR(5706) = EE**2/CW**3*SW/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*smuth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *smuth**2+3D0*sb**2*smuth**2-6D0*sa**2*sb**2
     &      *smuth**2)
      AAABR(5707) = EE**2/SW**2/cb**2*slth**2*(1D0-2D0*sa
     &      **2-sb**2+2D0*sa**2*sb**2)
      AAABR(5708) = EE**2/CW**2/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*slth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *slth**2+3D0*sb**2*slth**2-6D0*sa**2*sb**2*slth
     &      **2)
      AAABR(5709) = EE**2/CW**3*SW/cb**2*(2D0-4D0*sa**2-2D0
     &      *sb**2-3D0*slth**2+4D0*sa**2*sb**2+6D0*sa**2
     &      *slth**2+3D0*sb**2*slth**2-6D0*sa**2*sb**2*slth
     &      **2)
      AAABR(5710) = EE**2/SW**2*ca/cb**2*sa*seth**2*(1D0
     &      -sb**2)
      AAABR(5711) = EE**2/CW**2*ca/cb**2*sa*(2D0-2D0*sb**2
     &      -3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5712) = EE**2/CW**3*SW*ca/cb**2*sa*(2D0-2D0*sb
     &      **2-3D0*seth**2+3D0*sb**2*seth**2)
      AAABR(5713) = EE**2/SW**2*ca/cb**2*sa*slth**2*(1D0
     &      -sb**2)
      AAABR(5714) = EE**2/CW**2*ca/cb**2*sa*(2D0-2D0*sb**2
     &      -3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5715) = EE**2/CW**3*SW*ca/cb**2*sa*(2D0-2D0*sb
     &      **2-3D0*slth**2+3D0*sb**2*slth**2)
      AAABR(5716) = EE**2/SW**2*ca/cb**2*sa*smuth**2*(1D0
     &      -sb**2)
      AAABR(5717) = EE**2/CW**2*ca/cb**2*sa*(2D0-2D0*sb**2
     &      -3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5718) = EE**2/CW**3*SW*ca/cb**2*sa*(2D0-2D0*sb
     &      **2-3D0*smuth**2+3D0*sb**2*smuth**2)
      AAABR(5719) = EE**2*(1D0/CW**2+1D0/SW**2)
      AAABR(5720) = EE**2/SW**2
      AAABR(5721) = EE**2/CW**2
      AAABR(5722) = EE**2/CW**3*SW
      AAABR(5723) = EE**2*(1D0/CW**2+3D0/SW**2+sdth**2/CW
     &      **2-3D0*sdth**2/SW**2)
      AAABR(5724) = EE**2/SW**2*(1D0-sdth**2)
      AAABR(5725) = EE**2*cdth*sdth*(1D0/CW**2-3D0/SW**2)
      AAABR(5726) = EE**2/CW**2*(1D0+sdth**2)
      AAABR(5727) = EE**2/CW**3*SW*(1D0+sdth**2)
      AAABR(5728) = EE**2*(1D0/CW**2+3D0/SW**2+ssth**2/CW
     &      **2-3D0*ssth**2/SW**2)
      AAABR(5729) = EE**2/SW**2*(1D0-ssth**2)
      AAABR(5730) = EE**2*csth*ssth*(1D0/CW**2-3D0/SW**2)
      AAABR(5731) = EE**2/CW**2*(1D0+ssth**2)
      AAABR(5732) = EE**2/CW**3*SW*(1D0+ssth**2)
      AAABR(5733) = EE**2*(1D0/CW**2+3D0/SW**2+sbth**2/CW
     &      **2-3D0*sbth**2/SW**2)
      AAABR(5734) = EE**2/SW**2*(1D0-sbth**2)
      AAABR(5735) = EE**2*cbth*sbth*(1D0/CW**2-3D0/SW**2)
      AAABR(5736) = EE**2/CW**2*(1D0+sbth**2)
      AAABR(5737) = EE**2/CW**3*SW*(1D0+sbth**2)
      AAABR(5738) = EE**2/SW**2*cbth*sbth
      AAABR(5739) = EE**2*(2D0/CW**2-sbth**2/CW**2+3D0*sbth
     &      **2/SW**2)
      AAABR(5740) = EE**2/CW**2*cbth*sbth
      AAABR(5741) = EE**2/CW**3*SW*cbth*sbth
      AAABR(5742) = EE**2/SW**2*csth*ssth
      AAABR(5743) = EE**2*(2D0/CW**2-ssth**2/CW**2+3D0*ssth
     &      **2/SW**2)
      AAABR(5744) = EE**2/CW**2*csth*ssth
      AAABR(5745) = EE**2/CW**3*SW*csth*ssth
      AAABR(5746) = EE**2/SW**2*cdth*sdth
      AAABR(5747) = EE**2*(2D0/CW**2-sdth**2/CW**2+3D0*sdth
     &      **2/SW**2)
      AAABR(5748) = EE**2/CW**2*cdth*sdth
      AAABR(5749) = EE**2/CW**3*SW*cdth*sdth
      AAABR(5750) = EE**2/SW**2*ssth**2
      AAABR(5751) = EE**2/CW**2*(2D0-ssth**2)
      AAABR(5752) = EE**2/CW**3*SW*(2D0-ssth**2)
      AAABR(5753) = EE**2/SW**2*sdth**2
      AAABR(5754) = EE**2/CW**2*(2D0-sdth**2)
      AAABR(5755) = EE**2/CW**3*SW*(2D0-sdth**2)
      AAABR(5756) = EE**2/SW**2*sbth**2
      AAABR(5757) = EE**2/CW**2*(2D0-sbth**2)
      AAABR(5758) = EE**2/CW**3*SW*(2D0-sbth**2)
      AAABR(5759) = EE**2*(1D0/CW**2-3D0/SW**2-5D0*stth**2
     &      /CW**2+3D0*stth**2/SW**2)
      AAABR(5760) = EE**2/SW**2*(1D0-stth**2)
      AAABR(5761) = EE**2*ctth*stth*(5D0/CW**2-3D0/SW**2)
      AAABR(5762) = EE**2/CW**2*(1D0-5D0*stth**2)
      AAABR(5763) = EE**2/CW**3*SW*(1D0-5D0*stth**2)
      AAABR(5764) = EE**2*(1D0/CW**2-3D0/SW**2-5D0*scth**2
     &      /CW**2+3D0*scth**2/SW**2)
      AAABR(5765) = EE**2/SW**2*(1D0-scth**2)
      AAABR(5766) = EE**2*ccth*scth*(5D0/CW**2-3D0/SW**2)
      AAABR(5767) = EE**2/CW**2*(1D0-5D0*scth**2)
      AAABR(5768) = EE**2/CW**3*SW*(1D0-5D0*scth**2)
      AAABR(5769) = EE**2*(1D0/CW**2-3D0/SW**2-5D0*suth**2
     &      /CW**2+3D0*suth**2/SW**2)
      AAABR(5770) = EE**2/SW**2*(1D0-suth**2)
      AAABR(5771) = EE**2*cuth*suth*(5D0/CW**2-3D0/SW**2)
      AAABR(5772) = EE**2/CW**2*(1D0-5D0*suth**2)
      AAABR(5773) = EE**2/CW**3*SW*(1D0-5D0*suth**2)
      AAABR(5774) = EE**2/SW**2*ctth*stth
      AAABR(5775) = EE**2*(4D0/CW**2-5D0*stth**2/CW**2+3D0
     &      *stth**2/SW**2)
      AAABR(5776) = EE**2/CW**2*ctth*stth
      AAABR(5777) = EE**2/CW**3*SW*ctth*stth
      AAABR(5778) = EE**2/SW**2*ccth*scth
      AAABR(5779) = EE**2*(4D0/CW**2-5D0*scth**2/CW**2+3D0
     &      *scth**2/SW**2)
      AAABR(5780) = EE**2/CW**2*ccth*scth
      AAABR(5781) = EE**2/CW**3*SW*ccth*scth
      AAABR(5782) = EE**2/SW**2*cuth*suth
      AAABR(5783) = EE**2*(4D0/CW**2-5D0*suth**2/CW**2+3D0
     &      *suth**2/SW**2)
      AAABR(5784) = EE**2/CW**2*cuth*suth
      AAABR(5785) = EE**2/CW**3*SW*cuth*suth
      AAABR(5786) = EE**2/SW**2*stth**2
      AAABR(5787) = EE**2/CW**2*(4D0-5D0*stth**2)
      AAABR(5788) = EE**2/CW**3*SW*(4D0-5D0*stth**2)
      AAABR(5789) = EE**2/SW**2*suth**2
      AAABR(5790) = EE**2/CW**2*(4D0-5D0*suth**2)
      AAABR(5791) = EE**2/CW**3*SW*(4D0-5D0*suth**2)
      AAABR(5792) = EE**2/SW**2*scth**2
      AAABR(5793) = EE**2/CW**2*(4D0-5D0*scth**2)
      AAABR(5794) = EE**2/CW**3*SW*(4D0-5D0*scth**2)
      AAABR(5795) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2+2D0*sb**2/SW**2+2D0*Ml**2/MW**2/SW**2)
      AAABR(5796) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      +sb**2/SW**2+2D0*Ml**2/MW**2/SW**2)
      AAABR(5797) = EE**2*sb**2*(1D0/CW**2-1D0/SW**2)
      AAABR(5798) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2+2D0*sb**2/SW**2+2D0*Me**2/MW**2/SW**2)
      AAABR(5799) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      +sb**2/SW**2+2D0*Me**2/MW**2/SW**2)
      AAABR(5800) = EE**2*(1D0/CW**2-1D0/SW**2-2D0*sb**2
     &      /CW**2+2D0*sb**2/SW**2+2D0*Mm**2/MW**2/SW**2)
      AAABR(5801) = EE**2*(1D0/CW**2-1D0/SW**2-sb**2/CW**2
     &      +sb**2/SW**2+2D0*Mm**2/MW**2/SW**2)
      AAABR(5802) = EE**2*ca*sa*(1D0/CW**2+1D0/SW**2)
      AAABR(5803) = EE**2*(1D0/CW**2+1D0/SW**2-2D0*sa**2
     &      /CW**2-2D0*sa**2/SW**2)
      AAABR(5804) = EE**2/SW**2*(1D0-2D0*sa**2)
      AAABR(5805) = EE**2/CW**2*(1D0-2D0*sa**2)
      AAABR(5806) = EE**2/CW**3*SW*(1D0-2D0*sa**2)
      AAABR(5807) = EE**2/SW**2*ca*sa
      AAABR(5808) = EE**2/CW**2*ca*sa
      AAABR(5809) = EE**2/CW**3*SW*ca*sa
      AAABR(5810) = GG**2/cb**2*(1D0-sb**2-2D0*sdth**2-2D0
     &      *ssth**2+2D0*sb**2*sdth**2+2D0*sb**2*ssth**2
     &      +4D0*sdth**2*ssth**2-4D0*sb**2*sdth**2*ssth**2)
      AAABR(5811) = GG**2/cb**2*csth*ssth*(1D0-sb**2-2D0
     &      *sdth**2+2D0*sb**2*sdth**2)
      AAABR(5812) = GG**2/cb**2*cdth*sdth*(1D0-sb**2-2D0
     &      *ssth**2+2D0*sb**2*ssth**2)
      AAABR(5813) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+sdth**2/CW**2+ssth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*sdth**2/SW**2-9D0*ssth**2/SW**2-sb
     &      **2/CW**2*sdth**2-sb**2/CW**2*ssth**2+sdth**2
     &      /CW**2*ssth**2+9D0*sb**2/SW**2*sdth**2+9D0*sb
     &      **2/SW**2*ssth**2+9D0*sdth**2/SW**2*ssth**2-sb
     &      **2/CW**2*sdth**2*ssth**2-9D0*sb**2/SW**2*sdth
     &      **2*ssth**2+36D0*Md/MW**2*Ms/SW**2*cdth*csth
     &      *sdth*ssth)
      AAABR(5814) = EE**2/cb**2*(csth/CW**2*ssth-9D0*csth
     &      /SW**2*ssth-csth/CW**2*sb**2*ssth+csth/CW**2
     &      *sdth**2*ssth+9D0*csth/SW**2*sb**2*ssth+9D0*csth
     &      /SW**2*sdth**2*ssth-csth/CW**2*sb**2*sdth**2
     &      *ssth-9D0*csth/SW**2*sb**2*sdth**2*ssth+18D0
     &      *Md/MW**2*Ms/SW**2*cdth*sdth-36D0*Md/MW**2*Ms
     &      /SW**2*cdth*sdth*ssth**2)
      AAABR(5815) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -ssth**2+sb**2*sdth**2+sb**2*ssth**2+sdth**2
     &      *ssth**2-sb**2*sdth**2*ssth**2)
      AAABR(5816) = EE**2/cb**2*(cdth/CW**2*sdth-9D0*cdth
     &      /SW**2*sdth-cdth/CW**2*sb**2*sdth+cdth/CW**2
     &      *sdth*ssth**2+9D0*cdth/SW**2*sb**2*sdth+9D0*cdth
     &      /SW**2*sdth*ssth**2-cdth/CW**2*sb**2*sdth*ssth
     &      **2-9D0*cdth/SW**2*sb**2*sdth*ssth**2+18D0*Md
     &      /MW**2*Ms/SW**2*csth*ssth-36D0*Md/MW**2*Ms/SW
     &      **2*csth*sdth**2*ssth)
      AAABR(5817) = EE**2/CW**2/cb**2*(1D0-sb**2+sdth**2
     &      +ssth**2-sb**2*sdth**2-sb**2*ssth**2+sdth**2
     &      *ssth**2-sb**2*sdth**2*ssth**2)
      AAABR(5818) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sdth
     &      **2+ssth**2-sb**2*sdth**2-sb**2*ssth**2+sdth
     &      **2*ssth**2-sb**2*sdth**2*ssth**2)
      AAABR(5819) = EE**2/MW**2*Md*Ms/SW**2/cb**2*cdth*csth
     &      *sdth*ssth
      AAABR(5820) = EE**2/MW**2*Md*Ms/SW**2/cb**2*cdth*csth
     &      *sb**2*sdth*ssth
      AAABR(5821) = EE**2/MW**2*Md/SW**2/cb**2*cdth*csth
     &      *sdth*ssth
      AAABR(5822) = EE**2/MW**2*Ms/SW**2/cb**2*cdth*csth
     &      *sdth*ssth
      AAABR(5823) = GG**2/cb**2*(1D0-sb**2-2D0*sbth**2-2D0
     &      *sdth**2+2D0*sb**2*sbth**2+2D0*sb**2*sdth**2
     &      +4D0*sbth**2*sdth**2-4D0*sb**2*sbth**2*sdth**2)
      AAABR(5824) = GG**2/cb**2*cbth*sbth*(1D0-sb**2-2D0
     &      *sdth**2+2D0*sb**2*sdth**2)
      AAABR(5825) = GG**2/cb**2*cdth*sdth*(1D0-sb**2-2D0
     &      *sbth**2+2D0*sb**2*sbth**2)
      AAABR(5826) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2+sdth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*sbth**2/SW**2-9D0*sdth**2/SW**2-sb
     &      **2/CW**2*sbth**2-sb**2/CW**2*sdth**2+sbth**2
     &      /CW**2*sdth**2+9D0*sb**2/SW**2*sbth**2+9D0*sb
     &      **2/SW**2*sdth**2+9D0*sbth**2/SW**2*sdth**2-sb
     &      **2/CW**2*sbth**2*sdth**2-9D0*sb**2/SW**2*sbth
     &      **2*sdth**2+36D0*Mb/MW**2*Md/SW**2*cbth*cdth
     &      *sbth*sdth)
      AAABR(5827) = EE**2/cb**2*(cbth/CW**2*sbth-9D0*cbth
     &      /SW**2*sbth-cbth/CW**2*sb**2*sbth+cbth/CW**2
     &      *sbth*sdth**2+9D0*cbth/SW**2*sb**2*sbth+9D0*cbth
     &      /SW**2*sbth*sdth**2-cbth/CW**2*sb**2*sbth*sdth
     &      **2-9D0*cbth/SW**2*sb**2*sbth*sdth**2+18D0*Mb
     &      /MW**2*Md/SW**2*cdth*sdth-36D0*Mb/MW**2*Md/SW
     &      **2*cdth*sbth**2*sdth)
      AAABR(5828) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -sdth**2+sb**2*sbth**2+sb**2*sdth**2+sbth**2
     &      *sdth**2-sb**2*sbth**2*sdth**2)
      AAABR(5829) = EE**2/cb**2*(cdth/CW**2*sdth-9D0*cdth
     &      /SW**2*sdth-cdth/CW**2*sb**2*sdth+cdth/CW**2
     &      *sbth**2*sdth+9D0*cdth/SW**2*sb**2*sdth+9D0*cdth
     &      /SW**2*sbth**2*sdth-cdth/CW**2*sb**2*sbth**2
     &      *sdth-9D0*cdth/SW**2*sb**2*sbth**2*sdth+18D0
     &      *Mb/MW**2*Md/SW**2*cbth*sbth-36D0*Mb/MW**2*Md
     &      /SW**2*cbth*sbth*sdth**2)
      AAABR(5830) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      +sdth**2-sb**2*sbth**2-sb**2*sdth**2+sbth**2
     &      *sdth**2-sb**2*sbth**2*sdth**2)
      AAABR(5831) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2+sdth**2-sb**2*sbth**2-sb**2*sdth**2+sbth
     &      **2*sdth**2-sb**2*sbth**2*sdth**2)
      AAABR(5832) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cbth*cdth
     &      *sbth*sdth
      AAABR(5833) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cbth*cdth
     &      *sb**2*sbth*sdth
      AAABR(5834) = EE**2/MW**2*Md/SW**2/cb**2*cbth*cdth
     &      *sbth*sdth
      AAABR(5835) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*cdth
     &      *sbth*sdth
      AAABR(5836) = GG**2/cb**2*(1D0-sb**2-4D0*ssth**2+4D0
     &      *ssth**4+4D0*sb**2*ssth**2-4D0*sb**2*ssth**4)
      AAABR(5837) = GG**2/cb**2*csth*(ssth-2D0*ssth**3-sb
     &      **2*ssth+2D0*sb**2*ssth**3)
      AAABR(5838) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+2D0*ssth**2/CW**2+ssth**4/CW**2-9D0*sb
     &      **2/SW**2-18D0*ssth**2/SW**2+9D0*ssth**4/SW**2
     &      -2D0*sb**2/CW**2*ssth**2-sb**2/CW**2*ssth**4
     &      +18D0*sb**2/SW**2*ssth**2-9D0*sb**2/SW**2*ssth
     &      **4+36D0*Ms**2/MW**2/SW**2*ssth**2-36D0*Ms**2
     &      /MW**2/SW**2*ssth**4)
      AAABR(5839) = EE**2/cb**2*csth*(ssth/CW**2+ssth**3
     &      /CW**2-9D0*ssth/SW**2+9D0*ssth**3/SW**2-sb**2
     &      /CW**2*ssth-sb**2/CW**2*ssth**3+9D0*sb**2/SW
     &      **2*ssth-9D0*sb**2/SW**2*ssth**3+18D0*Ms**2/MW
     &      **2/SW**2*ssth-36D0*Ms**2/MW**2/SW**2*ssth**3)
      AAABR(5840) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*ssth
     &      **2+ssth**4+2D0*sb**2*ssth**2-sb**2*ssth**4)
      AAABR(5841) = EE**2/CW**2/cb**2*(1D0-sb**2+2D0*ssth
     &      **2+ssth**4-2D0*sb**2*ssth**2-sb**2*ssth**4)
      AAABR(5842) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+2D0*ssth
     &      **2+ssth**4-2D0*sb**2*ssth**2-sb**2*ssth**4)
      AAABR(5843) = EE**2/MW**2*Ms**2/SW**2/cb**2*(ssth**2
     &      -ssth**4)
      AAABR(5844) = EE**2/MW**2*Ms**2/SW**2/cb**2*sb**2*(ssth
     &      **2-ssth**4)
      AAABR(5845) = EE**2/MW**2*Ms/SW**2/cb**2*(ssth**2-ssth
     &      **4)
      AAABR(5846) = GG**2/cb**2*(1D0-sb**2-4D0*sbth**2+4D0
     &      *sbth**4+4D0*sb**2*sbth**2-4D0*sb**2*sbth**4)
      AAABR(5847) = GG**2/cb**2*cbth*(sbth-2D0*sbth**3-sb
     &      **2*sbth+2D0*sb**2*sbth**3)
      AAABR(5848) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+2D0*sbth**2/CW**2+sbth**4/CW**2-9D0*sb
     &      **2/SW**2-18D0*sbth**2/SW**2+9D0*sbth**4/SW**2
     &      -2D0*sb**2/CW**2*sbth**2-sb**2/CW**2*sbth**4
     &      +18D0*sb**2/SW**2*sbth**2-9D0*sb**2/SW**2*sbth
     &      **4+36D0*Mb**2/MW**2/SW**2*sbth**2-36D0*Mb**2
     &      /MW**2/SW**2*sbth**4)
      AAABR(5849) = EE**2/cb**2*cbth*(sbth/CW**2+sbth**3
     &      /CW**2-9D0*sbth/SW**2+9D0*sbth**3/SW**2-sb**2
     &      /CW**2*sbth-sb**2/CW**2*sbth**3+9D0*sb**2/SW
     &      **2*sbth-9D0*sb**2/SW**2*sbth**3+18D0*Mb**2/MW
     &      **2/SW**2*sbth-36D0*Mb**2/MW**2/SW**2*sbth**3)
      AAABR(5850) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*sbth
     &      **2+sbth**4+2D0*sb**2*sbth**2-sb**2*sbth**4)
      AAABR(5851) = EE**2/CW**2/cb**2*(1D0-sb**2+2D0*sbth
     &      **2+sbth**4-2D0*sb**2*sbth**2-sb**2*sbth**4)
      AAABR(5852) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+2D0*sbth
     &      **2+sbth**4-2D0*sb**2*sbth**2-sb**2*sbth**4)
      AAABR(5853) = EE**2/MW**2*Mb**2/SW**2/cb**2*(sbth**2
     &      -sbth**4)
      AAABR(5854) = EE**2/MW**2*Mb**2/SW**2/cb**2*sb**2*(sbth
     &      **2-sbth**4)
      AAABR(5855) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2-sbth
     &      **4)
      AAABR(5856) = GG**2/cb**2*(1D0-sb**2-2D0*sbth**2-2D0
     &      *ssth**2+2D0*sb**2*sbth**2+2D0*sb**2*ssth**2
     &      +4D0*sbth**2*ssth**2-4D0*sb**2*sbth**2*ssth**2)
      AAABR(5857) = GG**2/cb**2*cbth*sbth*(1D0-sb**2-2D0
     &      *ssth**2+2D0*sb**2*ssth**2)
      AAABR(5858) = GG**2/cb**2*csth*ssth*(1D0-sb**2-2D0
     &      *sbth**2+2D0*sb**2*sbth**2)
      AAABR(5859) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2+ssth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*sbth**2/SW**2-9D0*ssth**2/SW**2-sb
     &      **2/CW**2*sbth**2-sb**2/CW**2*ssth**2+sbth**2
     &      /CW**2*ssth**2+9D0*sb**2/SW**2*sbth**2+9D0*sb
     &      **2/SW**2*ssth**2+9D0*sbth**2/SW**2*ssth**2-sb
     &      **2/CW**2*sbth**2*ssth**2-9D0*sb**2/SW**2*sbth
     &      **2*ssth**2+36D0*Mb/MW**2*Ms/SW**2*cbth*csth
     &      *sbth*ssth)
      AAABR(5860) = EE**2/cb**2*(cbth/CW**2*sbth-9D0*cbth
     &      /SW**2*sbth-cbth/CW**2*sb**2*sbth+cbth/CW**2
     &      *sbth*ssth**2+9D0*cbth/SW**2*sb**2*sbth+9D0*cbth
     &      /SW**2*sbth*ssth**2-cbth/CW**2*sb**2*sbth*ssth
     &      **2-9D0*cbth/SW**2*sb**2*sbth*ssth**2+18D0*Mb
     &      /MW**2*Ms/SW**2*csth*ssth-36D0*Mb/MW**2*Ms/SW
     &      **2*csth*sbth**2*ssth)
      AAABR(5861) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -ssth**2+sb**2*sbth**2+sb**2*ssth**2+sbth**2
     &      *ssth**2-sb**2*sbth**2*ssth**2)
      AAABR(5862) = EE**2/cb**2*(csth/CW**2*ssth-9D0*csth
     &      /SW**2*ssth-csth/CW**2*sb**2*ssth+csth/CW**2
     &      *sbth**2*ssth+9D0*csth/SW**2*sb**2*ssth+9D0*csth
     &      /SW**2*sbth**2*ssth-csth/CW**2*sb**2*sbth**2
     &      *ssth-9D0*csth/SW**2*sb**2*sbth**2*ssth+18D0
     &      *Mb/MW**2*Ms/SW**2*cbth*sbth-36D0*Mb/MW**2*Ms
     &      /SW**2*cbth*sbth*ssth**2)
      AAABR(5863) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      +ssth**2-sb**2*sbth**2-sb**2*ssth**2+sbth**2
     &      *ssth**2-sb**2*sbth**2*ssth**2)
      AAABR(5864) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2+ssth**2-sb**2*sbth**2-sb**2*ssth**2+sbth
     &      **2*ssth**2-sb**2*sbth**2*ssth**2)
      AAABR(5865) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*cbth*csth
     &      *sbth*ssth
      AAABR(5866) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*cbth*csth
     &      *sb**2*sbth*ssth
      AAABR(5867) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*csth
     &      *sbth*ssth
      AAABR(5868) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*csth
     &      *sbth*ssth
      AAABR(5869) = GG**2/cb**2*(1D0-sb**2-4D0*sdth**2+4D0
     &      *sdth**4+4D0*sb**2*sdth**2-4D0*sb**2*sdth**4)
      AAABR(5870) = GG**2/cb**2*cdth*(sdth-2D0*sdth**3-sb
     &      **2*sdth+2D0*sb**2*sdth**3)
      AAABR(5871) = EE**2/cb**2*(1D0/CW**2+9D0/SW**2-sb**2
     &      /CW**2+2D0*sdth**2/CW**2+sdth**4/CW**2-9D0*sb
     &      **2/SW**2-18D0*sdth**2/SW**2+9D0*sdth**4/SW**2
     &      -2D0*sb**2/CW**2*sdth**2-sb**2/CW**2*sdth**4
     &      +18D0*sb**2/SW**2*sdth**2-9D0*sb**2/SW**2*sdth
     &      **4+36D0*Md**2/MW**2/SW**2*sdth**2-36D0*Md**2
     &      /MW**2/SW**2*sdth**4)
      AAABR(5872) = EE**2/cb**2*cdth*(sdth/CW**2+sdth**3
     &      /CW**2-9D0*sdth/SW**2+9D0*sdth**3/SW**2-sb**2
     &      /CW**2*sdth-sb**2/CW**2*sdth**3+9D0*sb**2/SW
     &      **2*sdth-9D0*sb**2/SW**2*sdth**3+18D0*Md**2/MW
     &      **2/SW**2*sdth-36D0*Md**2/MW**2/SW**2*sdth**3)
      AAABR(5873) = EE**2/SW**2/cb**2*(1D0-sb**2-2D0*sdth
     &      **2+sdth**4+2D0*sb**2*sdth**2-sb**2*sdth**4)
      AAABR(5874) = EE**2/CW**2/cb**2*(1D0-sb**2+2D0*sdth
     &      **2+sdth**4-2D0*sb**2*sdth**2-sb**2*sdth**4)
      AAABR(5875) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+2D0*sdth
     &      **2+sdth**4-2D0*sb**2*sdth**2-sb**2*sdth**4)
      AAABR(5876) = EE**2/MW**2*Md**2/SW**2/cb**2*(sdth**2
     &      -sdth**4)
      AAABR(5877) = EE**2/MW**2*Md**2/SW**2/cb**2*sb**2*(sdth
     &      **2-sdth**4)
      AAABR(5878) = EE**2/MW**2*Md/SW**2/cb**2*(sdth**2-sdth
     &      **4)
      AAABR(5879) = GG**2/cb**2*cbth*cdth*sbth*sdth*(1D0
     &      -sb**2)
      AAABR(5880) = EE**2/cb**2*(9D0*Mb/MW**2*Md/SW**2+cbth
     &      /CW**2*cdth*sbth*sdth-18D0*Mb/MW**2*Md/SW**2
     &      *sbth**2-18D0*Mb/MW**2*Md/SW**2*sdth**2+9D0*cbth
     &      /SW**2*cdth*sbth*sdth-cbth/CW**2*cdth*sb**2*sbth
     &      *sdth+36D0*Mb/MW**2*Md/SW**2*sbth**2*sdth**2
     &      -9D0*cbth/SW**2*cdth*sb**2*sbth*sdth)
      AAABR(5881) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(5882) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sbth**2/CW**2-sdth**2/CW**2+9D0*sdth**2
     &      /SW**2-2D0*sb**2/CW**2*sbth**2+sb**2/CW**2*sdth
     &      **2-sbth**2/CW**2*sdth**2-9D0*sb**2/SW**2*sdth
     &      **2-9D0*sbth**2/SW**2*sdth**2+sb**2/CW**2*sbth
     &      **2*sdth**2+9D0*sb**2/SW**2*sbth**2*sdth**2-36D0
     &      *Mb/MW**2*Md/SW**2*cbth*cdth*sbth*sdth)
      AAABR(5883) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      +sbth**2-sb**2*sbth**2)
      AAABR(5884) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(5885) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*sdth**2)
      AAABR(5886) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cbth*sb
     &      **2*sbth*(1D0-2D0*sdth**2)
      AAABR(5887) = EE**2/MW**2*Md/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*sdth**2)
      AAABR(5888) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*sdth**2)
      AAABR(5889) = GG**2/cb**2*cbth*csth*sbth*ssth*(1D0
     &      -sb**2)
      AAABR(5890) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2+2D0*ssth**2/CW**2+9D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2-2D0*sb**2/CW**2*ssth
     &      **2-sbth**2/CW**2*ssth**2-9D0*sb**2/SW**2*sbth
     &      **2-9D0*sbth**2/SW**2*ssth**2+sb**2/CW**2*sbth
     &      **2*ssth**2+9D0*sb**2/SW**2*sbth**2*ssth**2-36D0
     &      *Mb/MW**2*Ms/SW**2*cbth*csth*sbth*ssth)
      AAABR(5891) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(5892) = EE**2/cb**2*(9D0*Mb/MW**2*Ms/SW**2+cbth
     &      /CW**2*csth*sbth*ssth-18D0*Mb/MW**2*Ms/SW**2
     &      *sbth**2-18D0*Mb/MW**2*Ms/SW**2*ssth**2+9D0*cbth
     &      /SW**2*csth*sbth*ssth-cbth/CW**2*csth*sb**2*sbth
     &      *ssth+36D0*Mb/MW**2*Ms/SW**2*sbth**2*ssth**2
     &      -9D0*cbth/SW**2*csth*sb**2*sbth*ssth)
      AAABR(5893) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      +ssth**2-sb**2*ssth**2)
      AAABR(5894) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(5895) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sbth**2)
      AAABR(5896) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*csth*sb
     &      **2*ssth*(1D0-2D0*sbth**2)
      AAABR(5897) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sbth**2)
      AAABR(5898) = EE**2/MW**2*Mb/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sbth**2)
      AAABR(5899) = GG**2/cb**2*(1D0-sb**2-12D0*sbth**2+12D0
     &      *sbth**4+12D0*sb**2*sbth**2-12D0*sb**2*sbth**4)
      AAABR(5900) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +3D0*sbth**2/CW**2-3D0*sbth**4/CW**2+27D0*sbth
     &      **2/SW**2-27D0*sbth**4/SW**2-3D0*sb**2/CW**2
     &      *sbth**2+3D0*sb**2/CW**2*sbth**4+18D0*Mb**2/MW
     &      **2/SW**2-27D0*sb**2/SW**2*sbth**2+27D0*sb**2
     &      /SW**2*sbth**4-108D0*Mb**2/MW**2/SW**2*sbth**2
     &      +108D0*Mb**2/MW**2/SW**2*sbth**4)
      AAABR(5901) = EE**2/SW**2/cb**2*cbth*(sbth-sbth**3
     &      -sb**2*sbth+sb**2*sbth**3)
      AAABR(5902) = EE**2/CW**2/cb**2*cbth*(sbth+sbth**3
     &      -sb**2*sbth-sb**2*sbth**3)
      AAABR(5903) = EE**2/CW**3*SW/cb**2*cbth*(sbth+sbth
     &      **3-sb**2*sbth-sb**2*sbth**3)
      AAABR(5904) = EE**2/MW**2*Mb**2/SW**2/cb**2*cbth*(sbth
     &      -2D0*sbth**3)
      AAABR(5905) = EE**2/MW**2*Mb**2/SW**2/cb**2*cbth*sb
     &      **2*(sbth-2D0*sbth**3)
      AAABR(5906) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*(sbth
     &      -2D0*sbth**3)
      AAABR(5907) = GG**2/cb**2*(1D0-sb**2-12D0*sdth**2+12D0
     &      *sdth**4+12D0*sb**2*sdth**2-12D0*sb**2*sdth**4)
      AAABR(5908) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +3D0*sdth**2/CW**2-3D0*sdth**4/CW**2+27D0*sdth
     &      **2/SW**2-27D0*sdth**4/SW**2-3D0*sb**2/CW**2
     &      *sdth**2+3D0*sb**2/CW**2*sdth**4+18D0*Md**2/MW
     &      **2/SW**2-27D0*sb**2/SW**2*sdth**2+27D0*sb**2
     &      /SW**2*sdth**4-108D0*Md**2/MW**2/SW**2*sdth**2
     &      +108D0*Md**2/MW**2/SW**2*sdth**4)
      AAABR(5909) = EE**2/SW**2/cb**2*cdth*(sdth-sdth**3
     &      -sb**2*sdth+sb**2*sdth**3)
      AAABR(5910) = EE**2/CW**2/cb**2*cdth*(sdth+sdth**3
     &      -sb**2*sdth-sb**2*sdth**3)
      AAABR(5911) = EE**2/CW**3*SW/cb**2*cdth*(sdth+sdth
     &      **3-sb**2*sdth-sb**2*sdth**3)
      AAABR(5912) = EE**2/MW**2*Md**2/SW**2/cb**2*cdth*(sdth
     &      -2D0*sdth**3)
      AAABR(5913) = EE**2/MW**2*Md**2/SW**2/cb**2*cdth*sb
     &      **2*(sdth-2D0*sdth**3)
      AAABR(5914) = EE**2/MW**2*Md/SW**2/cb**2*cdth*(sdth
     &      -2D0*sdth**3)
      AAABR(5915) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(5916) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sbth**2/CW**2-ssth**2/CW**2+9D0*ssth**2
     &      /SW**2-2D0*sb**2/CW**2*sbth**2+sb**2/CW**2*ssth
     &      **2-sbth**2/CW**2*ssth**2-9D0*sb**2/SW**2*ssth
     &      **2-9D0*sbth**2/SW**2*ssth**2+sb**2/CW**2*sbth
     &      **2*ssth**2+9D0*sb**2/SW**2*sbth**2*ssth**2-36D0
     &      *Mb/MW**2*Ms/SW**2*cbth*csth*sbth*ssth)
      AAABR(5917) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      +sbth**2-sb**2*sbth**2)
      AAABR(5918) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(5919) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*ssth**2)
      AAABR(5920) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*cbth*sb
     &      **2*sbth*(1D0-2D0*ssth**2)
      AAABR(5921) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*ssth**2)
      AAABR(5922) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-2D0*ssth**2)
      AAABR(5923) = GG**2/cb**2*(1D0-sb**2-12D0*ssth**2+12D0
     &      *ssth**4+12D0*sb**2*ssth**2-12D0*sb**2*ssth**4)
      AAABR(5924) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +3D0*ssth**2/CW**2-3D0*ssth**4/CW**2+27D0*ssth
     &      **2/SW**2-27D0*ssth**4/SW**2-3D0*sb**2/CW**2
     &      *ssth**2+3D0*sb**2/CW**2*ssth**4+18D0*Ms**2/MW
     &      **2/SW**2-27D0*sb**2/SW**2*ssth**2+27D0*sb**2
     &      /SW**2*ssth**4-108D0*Ms**2/MW**2/SW**2*ssth**2
     &      +108D0*Ms**2/MW**2/SW**2*ssth**4)
      end

      subroutine aaini08
      implicit none
#include "model.h"

      AAABR(5925) = EE**2/SW**2/cb**2*csth*(ssth-ssth**3
     &      -sb**2*ssth+sb**2*ssth**3)
      AAABR(5926) = EE**2/CW**2/cb**2*csth*(ssth+ssth**3
     &      -sb**2*ssth-sb**2*ssth**3)
      AAABR(5927) = EE**2/CW**3*SW/cb**2*csth*(ssth+ssth
     &      **3-sb**2*ssth-sb**2*ssth**3)
      AAABR(5928) = EE**2/MW**2*Ms**2/SW**2/cb**2*csth*(ssth
     &      -2D0*ssth**3)
      AAABR(5929) = EE**2/MW**2*Ms**2/SW**2/cb**2*csth*sb
     &      **2*(ssth-2D0*ssth**3)
      AAABR(5930) = EE**2/MW**2*Ms/SW**2/cb**2*csth*(ssth
     &      -2D0*ssth**3)
      AAABR(5931) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2+2D0*sdth**2/CW**2+9D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2-2D0*sb**2/CW**2*sdth
     &      **2-sbth**2/CW**2*sdth**2-9D0*sb**2/SW**2*sbth
     &      **2-9D0*sbth**2/SW**2*sdth**2+sb**2/CW**2*sbth
     &      **2*sdth**2+9D0*sb**2/SW**2*sbth**2*sdth**2-36D0
     &      *Mb/MW**2*Md/SW**2*cbth*cdth*sbth*sdth)
      AAABR(5932) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(5933) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      +sdth**2-sb**2*sdth**2)
      AAABR(5934) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(5935) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*sbth**2)
      AAABR(5936) = EE**2/MW**2*Mb*Md/SW**2/cb**2*cdth*sb
     &      **2*sdth*(1D0-2D0*sbth**2)
      AAABR(5937) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*sbth**2)
      AAABR(5938) = EE**2/MW**2*Mb/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*sbth**2)
      AAABR(5939) = GG**2/cb**2*cdth*csth*sdth*ssth*(1D0
     &      -sb**2)
      AAABR(5940) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +2D0*sdth**2/CW**2-ssth**2/CW**2+9D0*ssth**2
     &      /SW**2-2D0*sb**2/CW**2*sdth**2+sb**2/CW**2*ssth
     &      **2-sdth**2/CW**2*ssth**2-9D0*sb**2/SW**2*ssth
     &      **2-9D0*sdth**2/SW**2*ssth**2+sb**2/CW**2*sdth
     &      **2*ssth**2+9D0*sb**2/SW**2*sdth**2*ssth**2-36D0
     &      *Md/MW**2*Ms/SW**2*cdth*csth*sdth*ssth)
      AAABR(5941) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(5942) = EE**2/cb**2*(9D0*Md/MW**2*Ms/SW**2+cdth
     &      /CW**2*csth*sdth*ssth-18D0*Md/MW**2*Ms/SW**2
     &      *sdth**2-18D0*Md/MW**2*Ms/SW**2*ssth**2+9D0*cdth
     &      /SW**2*csth*sdth*ssth-cdth/CW**2*csth*sb**2*sdth
     &      *ssth+36D0*Md/MW**2*Ms/SW**2*sdth**2*ssth**2
     &      -9D0*cdth/SW**2*csth*sb**2*sdth*ssth)
      AAABR(5943) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      +sdth**2-sb**2*sdth**2)
      AAABR(5944) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(5945) = EE**2/MW**2*Md*Ms/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*ssth**2)
      AAABR(5946) = EE**2/MW**2*Md*Ms/SW**2/cb**2*cdth*sb
     &      **2*sdth*(1D0-2D0*ssth**2)
      AAABR(5947) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*ssth**2)
      AAABR(5948) = EE**2/MW**2*Ms/SW**2/cb**2*cdth*sdth
     &      *(1D0-2D0*ssth**2)
      AAABR(5949) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(5950) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sdth**2/CW**2+2D0*ssth**2/CW**2+9D0*sdth**2
     &      /SW**2+sb**2/CW**2*sdth**2-2D0*sb**2/CW**2*ssth
     &      **2-sdth**2/CW**2*ssth**2-9D0*sb**2/SW**2*sdth
     &      **2-9D0*sdth**2/SW**2*ssth**2+sb**2/CW**2*sdth
     &      **2*ssth**2+9D0*sb**2/SW**2*sdth**2*ssth**2-36D0
     &      *Md/MW**2*Ms/SW**2*cdth*csth*sdth*ssth)
      AAABR(5951) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      +ssth**2-sb**2*ssth**2)
      AAABR(5952) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(5953) = EE**2/MW**2*Md*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sdth**2)
      AAABR(5954) = EE**2/MW**2*Md*Ms/SW**2/cb**2*csth*sb
     &      **2*ssth*(1D0-2D0*sdth**2)
      AAABR(5955) = EE**2/MW**2*Md/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sdth**2)
      AAABR(5956) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-2D0*sdth**2)
      AAABR(5957) = GG**2/cb**2*cdth**2*sdth**2*(1D0-sb**2)
      AAABR(5958) = EE**2/cb**2*cdth**2*sdth**2*(1D0/CW**2
     &      +9D0/SW**2-sb**2/CW**2-9D0*sb**2/SW**2-36D0*Md
     &      **2/MW**2/SW**2)
      AAABR(5959) = EE**2/cb**2*cdth*(2D0*sdth/CW**2-sdth
     &      **3/CW**2-9D0*sdth**3/SW**2-2D0*sb**2/CW**2*sdth
     &      +sb**2/CW**2*sdth**3+9D0*sb**2/SW**2*sdth**3
     &      -18D0*Md**2/MW**2/SW**2*sdth+36D0*Md**2/MW**2
     &      /SW**2*sdth**3)
      AAABR(5960) = EE**2/SW**2/cb**2*cdth**2*sdth**2*(1D0
     &      -sb**2)
      AAABR(5961) = EE**2/CW**2/cb**2*cdth**2*sdth**2*(1D0
     &      -sb**2)
      AAABR(5962) = EE**2/CW**3*SW/cb**2*cdth**2*sdth**2
     &      *(1D0-sb**2)
      AAABR(5963) = EE**2/MW**2*Md**2/SW**2/cb**2*cdth**2
     &      *sdth**2
      AAABR(5964) = EE**2/MW**2*Md**2/SW**2/cb**2*cdth**2
     &      *sb**2*sdth**2
      AAABR(5965) = EE**2/MW**2*Md/SW**2/cb**2*cdth**2*sdth
     &      **2
      AAABR(5966) = GG**2/cb**2*cbth**2*sbth**2*(1D0-sb**2)
      AAABR(5967) = EE**2/cb**2*cbth**2*sbth**2*(1D0/CW**2
     &      +9D0/SW**2-sb**2/CW**2-9D0*sb**2/SW**2-36D0*Mb
     &      **2/MW**2/SW**2)
      AAABR(5968) = EE**2/cb**2*cbth*(2D0*sbth/CW**2-sbth
     &      **3/CW**2-9D0*sbth**3/SW**2-2D0*sb**2/CW**2*sbth
     &      +sb**2/CW**2*sbth**3+9D0*sb**2/SW**2*sbth**3
     &      -18D0*Mb**2/MW**2/SW**2*sbth+36D0*Mb**2/MW**2
     &      /SW**2*sbth**3)
      AAABR(5969) = EE**2/SW**2/cb**2*cbth**2*sbth**2*(1D0
     &      -sb**2)
      AAABR(5970) = EE**2/CW**2/cb**2*cbth**2*sbth**2*(1D0
     &      -sb**2)
      AAABR(5971) = EE**2/CW**3*SW/cb**2*cbth**2*sbth**2
     &      *(1D0-sb**2)
      AAABR(5972) = EE**2/MW**2*Mb**2/SW**2/cb**2*cbth**2
     &      *sbth**2
      AAABR(5973) = EE**2/MW**2*Mb**2/SW**2/cb**2*cbth**2
     &      *sb**2*sbth**2
      AAABR(5974) = EE**2/MW**2*Mb/SW**2/cb**2*cbth**2*sbth
     &      **2
      AAABR(5975) = EE**2/cb**2*(cbth/CW**2*csth*sbth*ssth
     &      -18D0*Mb/MW**2*Ms/SW**2*sbth**2-18D0*Mb/MW**2
     &      *Ms/SW**2*ssth**2+9D0*cbth/SW**2*csth*sbth*ssth
     &      -cbth/CW**2*csth*sb**2*sbth*ssth+36D0*Mb/MW**2
     &      *Ms/SW**2*sbth**2*ssth**2-9D0*cbth/SW**2*csth
     &      *sb**2*sbth*ssth)
      AAABR(5976) = EE**2/cb**2*(2D0*csth/CW**2*ssth-2D0
     &      *csth/CW**2*sb**2*ssth-csth/CW**2*sbth**2*ssth
     &      -9D0*csth/SW**2*sbth**2*ssth+csth/CW**2*sb**2
     &      *sbth**2*ssth+9D0*csth/SW**2*sb**2*sbth**2*ssth
     &      -18D0*Mb/MW**2*Ms/SW**2*cbth*sbth+36D0*Mb/MW
     &      **2*Ms/SW**2*cbth*sbth*ssth**2)
      AAABR(5977) = EE**2/SW**2/cb**2*cbth*csth*sbth*ssth
     &      *(1D0-sb**2)
      AAABR(5978) = EE**2/cb**2*(2D0*cbth/CW**2*sbth-2D0
     &      *cbth/CW**2*sb**2*sbth-cbth/CW**2*sbth*ssth**2
     &      -9D0*cbth/SW**2*sbth*ssth**2+cbth/CW**2*sb**2
     &      *sbth*ssth**2+9D0*cbth/SW**2*sb**2*sbth*ssth
     &      **2-18D0*Mb/MW**2*Ms/SW**2*csth*ssth+36D0*Mb
     &      /MW**2*Ms/SW**2*csth*sbth**2*ssth)
      AAABR(5979) = EE**2/CW**2/cb**2*cbth*csth*sbth*ssth
     &      *(1D0-sb**2)
      AAABR(5980) = EE**2/CW**3*SW/cb**2*cbth*csth*sbth*ssth
     &      *(1D0-sb**2)
      AAABR(5981) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*(sbth**2
     &      +ssth**2-2D0*sbth**2*ssth**2)
      AAABR(5982) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*sb**2*(sbth
     &      **2+ssth**2-2D0*sbth**2*ssth**2)
      AAABR(5983) = EE**2/MW**2*Ms/SW**2/cb**2*(sbth**2+ssth
     &      **2-2D0*sbth**2*ssth**2)
      AAABR(5984) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2+ssth
     &      **2-2D0*sbth**2*ssth**2)
      AAABR(5985) = EE**2/cb**2*(cbth/CW**2*cdth*sbth*sdth
     &      -18D0*Mb/MW**2*Md/SW**2*sbth**2-18D0*Mb/MW**2
     &      *Md/SW**2*sdth**2+9D0*cbth/SW**2*cdth*sbth*sdth
     &      -cbth/CW**2*cdth*sb**2*sbth*sdth+36D0*Mb/MW**2
     &      *Md/SW**2*sbth**2*sdth**2-9D0*cbth/SW**2*cdth
     &      *sb**2*sbth*sdth)
      AAABR(5986) = EE**2/cb**2*(2D0*cdth/CW**2*sdth-2D0
     &      *cdth/CW**2*sb**2*sdth-cdth/CW**2*sbth**2*sdth
     &      -9D0*cdth/SW**2*sbth**2*sdth+cdth/CW**2*sb**2
     &      *sbth**2*sdth+9D0*cdth/SW**2*sb**2*sbth**2*sdth
     &      -18D0*Mb/MW**2*Md/SW**2*cbth*sbth+36D0*Mb/MW
     &      **2*Md/SW**2*cbth*sbth*sdth**2)
      AAABR(5987) = EE**2/SW**2/cb**2*cbth*cdth*sbth*sdth
     &      *(1D0-sb**2)
      AAABR(5988) = EE**2/cb**2*(2D0*cbth/CW**2*sbth-2D0
     &      *cbth/CW**2*sb**2*sbth-cbth/CW**2*sbth*sdth**2
     &      -9D0*cbth/SW**2*sbth*sdth**2+cbth/CW**2*sb**2
     &      *sbth*sdth**2+9D0*cbth/SW**2*sb**2*sbth*sdth
     &      **2-18D0*Mb/MW**2*Md/SW**2*cdth*sdth+36D0*Mb
     &      /MW**2*Md/SW**2*cdth*sbth**2*sdth)
      AAABR(5989) = EE**2/CW**2/cb**2*cbth*cdth*sbth*sdth
     &      *(1D0-sb**2)
      AAABR(5990) = EE**2/CW**3*SW/cb**2*cbth*cdth*sbth*sdth
     &      *(1D0-sb**2)
      AAABR(5991) = EE**2/MW**2*Mb*Md/SW**2/cb**2*(sbth**2
     &      +sdth**2-2D0*sbth**2*sdth**2)
      AAABR(5992) = EE**2/MW**2*Mb*Md/SW**2/cb**2*sb**2*(sbth
     &      **2+sdth**2-2D0*sbth**2*sdth**2)
      AAABR(5993) = EE**2/MW**2*Md/SW**2/cb**2*(sbth**2+sdth
     &      **2-2D0*sbth**2*sdth**2)
      AAABR(5994) = EE**2/MW**2*Mb/SW**2/cb**2*(sbth**2+sdth
     &      **2-2D0*sbth**2*sdth**2)
      AAABR(5995) = GG**2/cb**2*csth**2*ssth**2*(1D0-sb**2)
      AAABR(5996) = EE**2/cb**2*csth**2*ssth**2*(1D0/CW**2
     &      +9D0/SW**2-sb**2/CW**2-9D0*sb**2/SW**2-36D0*Ms
     &      **2/MW**2/SW**2)
      AAABR(5997) = EE**2/cb**2*csth*(2D0*ssth/CW**2-ssth
     &      **3/CW**2-9D0*ssth**3/SW**2-2D0*sb**2/CW**2*ssth
     &      +sb**2/CW**2*ssth**3+9D0*sb**2/SW**2*ssth**3
     &      -18D0*Ms**2/MW**2/SW**2*ssth+36D0*Ms**2/MW**2
     &      /SW**2*ssth**3)
      AAABR(5998) = EE**2/SW**2/cb**2*csth**2*ssth**2*(1D0
     &      -sb**2)
      AAABR(5999) = EE**2/CW**2/cb**2*csth**2*ssth**2*(1D0
     &      -sb**2)
      AAABR(6000) = EE**2/CW**3*SW/cb**2*csth**2*ssth**2
     &      *(1D0-sb**2)
      AAABR(6001) = EE**2/MW**2*Ms**2/SW**2/cb**2*csth**2
     &      *ssth**2
      AAABR(6002) = EE**2/MW**2*Ms**2/SW**2/cb**2*csth**2
     &      *sb**2*ssth**2
      AAABR(6003) = EE**2/MW**2*Ms/SW**2/cb**2*csth**2*ssth
     &      **2
      AAABR(6004) = EE**2/cb**2*(cdth/CW**2*csth*sdth*ssth
     &      -18D0*Md/MW**2*Ms/SW**2*sdth**2-18D0*Md/MW**2
     &      *Ms/SW**2*ssth**2+9D0*cdth/SW**2*csth*sdth*ssth
     &      -cdth/CW**2*csth*sb**2*sdth*ssth+36D0*Md/MW**2
     &      *Ms/SW**2*sdth**2*ssth**2-9D0*cdth/SW**2*csth
     &      *sb**2*sdth*ssth)
      AAABR(6005) = EE**2/cb**2*(2D0*cdth/CW**2*sdth-2D0
     &      *cdth/CW**2*sb**2*sdth-cdth/CW**2*sdth*ssth**2
     &      -9D0*cdth/SW**2*sdth*ssth**2+cdth/CW**2*sb**2
     &      *sdth*ssth**2+9D0*cdth/SW**2*sb**2*sdth*ssth
     &      **2-18D0*Md/MW**2*Ms/SW**2*csth*ssth+36D0*Md
     &      /MW**2*Ms/SW**2*csth*sdth**2*ssth)
      AAABR(6006) = EE**2/SW**2/cb**2*cdth*csth*sdth*ssth
     &      *(1D0-sb**2)
      AAABR(6007) = EE**2/cb**2*(2D0*csth/CW**2*ssth-2D0
     &      *csth/CW**2*sb**2*ssth-csth/CW**2*sdth**2*ssth
     &      -9D0*csth/SW**2*sdth**2*ssth+csth/CW**2*sb**2
     &      *sdth**2*ssth+9D0*csth/SW**2*sb**2*sdth**2*ssth
     &      -18D0*Md/MW**2*Ms/SW**2*cdth*sdth+36D0*Md/MW
     &      **2*Ms/SW**2*cdth*sdth*ssth**2)
      AAABR(6008) = EE**2/CW**2/cb**2*cdth*csth*sdth*ssth
     &      *(1D0-sb**2)
      AAABR(6009) = EE**2/CW**3*SW/cb**2*cdth*csth*sdth*ssth
     &      *(1D0-sb**2)
      AAABR(6010) = EE**2/MW**2*Md*Ms/SW**2/cb**2*(sdth**2
     &      +ssth**2-2D0*sdth**2*ssth**2)
      AAABR(6011) = EE**2/MW**2*Md*Ms/SW**2/cb**2*sb**2*(sdth
     &      **2+ssth**2-2D0*sdth**2*ssth**2)
      AAABR(6012) = EE**2/MW**2*Md/SW**2/cb**2*(sdth**2+ssth
     &      **2-2D0*sdth**2*ssth**2)
      AAABR(6013) = EE**2/MW**2*Ms/SW**2/cb**2*(sdth**2+ssth
     &      **2-2D0*sdth**2*ssth**2)
      AAABR(6014) = EE**2/SW**2/cb**2*sbth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(6015) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sbth
     &      **2+2D0*ssth**2+sb**2*sbth**2-2D0*sb**2*ssth
     &      **2-sbth**2*ssth**2+sb**2*sbth**2*ssth**2)
      AAABR(6016) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sbth
     &      **2+2D0*ssth**2+sb**2*sbth**2-2D0*sb**2*ssth
     &      **2-sbth**2*ssth**2+sb**2*sbth**2*ssth**2)
      AAABR(6017) = EE**2/cb**2*(18D0*Mb/MW**2*Ms/SW**2+cbth
     &      /CW**2*csth*sbth*ssth-18D0*Mb/MW**2*Ms/SW**2
     &      *sbth**2-18D0*Mb/MW**2*Ms/SW**2*ssth**2+9D0*cbth
     &      /SW**2*csth*sbth*ssth-cbth/CW**2*csth*sb**2*sbth
     &      *ssth+36D0*Mb/MW**2*Ms/SW**2*sbth**2*ssth**2
     &      -9D0*cbth/SW**2*csth*sb**2*sbth*ssth)
      AAABR(6018) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*(1D0-sbth
     &      **2-ssth**2+2D0*sbth**2*ssth**2)
      AAABR(6019) = EE**2/MW**2*Mb*Ms/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2-ssth**2+2D0*sbth**2*ssth**2)
      AAABR(6020) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-sbth
     &      **2-ssth**2+2D0*sbth**2*ssth**2)
      AAABR(6021) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-sbth
     &      **2-ssth**2+2D0*sbth**2*ssth**2)
      AAABR(6022) = EE**2/SW**2/cb**2*sdth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(6023) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-sdth**2-2D0*sb**2*sbth**2+sb**2*sdth
     &      **2-sbth**2*sdth**2+sb**2*sbth**2*sdth**2)
      AAABR(6024) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-sdth**2-2D0*sb**2*sbth**2+sb**2*sdth
     &      **2-sbth**2*sdth**2+sb**2*sbth**2*sdth**2)
      AAABR(6025) = EE**2/SW**2/cb**2*ssth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(6026) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-ssth**2-2D0*sb**2*sbth**2+sb**2*ssth
     &      **2-sbth**2*ssth**2+sb**2*sbth**2*ssth**2)
      AAABR(6027) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sbth**2-ssth**2-2D0*sb**2*sbth**2+sb**2*ssth
     &      **2-sbth**2*ssth**2+sb**2*sbth**2*ssth**2)
      AAABR(6028) = EE**2/cb**2*(18D0*Md/MW**2*Ms/SW**2+cdth
     &      /CW**2*csth*sdth*ssth-18D0*Md/MW**2*Ms/SW**2
     &      *sdth**2-18D0*Md/MW**2*Ms/SW**2*ssth**2+9D0*cdth
     &      /SW**2*csth*sdth*ssth-cdth/CW**2*csth*sb**2*sdth
     &      *ssth+36D0*Md/MW**2*Ms/SW**2*sdth**2*ssth**2
     &      -9D0*cdth/SW**2*csth*sb**2*sdth*ssth)
      AAABR(6029) = EE**2/MW**2*Md*Ms/SW**2/cb**2*(1D0-sdth
     &      **2-ssth**2+2D0*sdth**2*ssth**2)
      AAABR(6030) = EE**2/MW**2*Md*Ms/SW**2/cb**2*sb**2*(1D0
     &      -sdth**2-ssth**2+2D0*sdth**2*ssth**2)
      AAABR(6031) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-sdth
     &      **2-ssth**2+2D0*sdth**2*ssth**2)
      AAABR(6032) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-sdth
     &      **2-ssth**2+2D0*sdth**2*ssth**2)
      AAABR(6033) = EE**2/cb**2*(18D0*Mb/MW**2*Md/SW**2+cbth
     &      /CW**2*cdth*sbth*sdth-18D0*Mb/MW**2*Md/SW**2
     &      *sbth**2-18D0*Mb/MW**2*Md/SW**2*sdth**2+9D0*cbth
     &      /SW**2*cdth*sbth*sdth-cbth/CW**2*cdth*sb**2*sbth
     &      *sdth+36D0*Mb/MW**2*Md/SW**2*sbth**2*sdth**2
     &      -9D0*cbth/SW**2*cdth*sb**2*sbth*sdth)
      AAABR(6034) = EE**2/MW**2*Mb*Md/SW**2/cb**2*(1D0-sbth
     &      **2-sdth**2+2D0*sbth**2*sdth**2)
      AAABR(6035) = EE**2/MW**2*Mb*Md/SW**2/cb**2*sb**2*(1D0
     &      -sbth**2-sdth**2+2D0*sbth**2*sdth**2)
      AAABR(6036) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-sbth
     &      **2-sdth**2+2D0*sbth**2*sdth**2)
      AAABR(6037) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-sbth
     &      **2-sdth**2+2D0*sbth**2*sdth**2)
      AAABR(6038) = EE**2/SW**2/cb**2*sdth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(6039) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sdth
     &      **2+2D0*ssth**2+sb**2*sdth**2-2D0*sb**2*ssth
     &      **2-sdth**2*ssth**2+sb**2*sdth**2*ssth**2)
      AAABR(6040) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sdth
     &      **2+2D0*ssth**2+sb**2*sdth**2-2D0*sb**2*ssth
     &      **2-sdth**2*ssth**2+sb**2*sdth**2*ssth**2)
      AAABR(6041) = EE**2/SW**2/cb**2*sbth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(6042) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2-sbth
     &      **2+2D0*sdth**2+sb**2*sbth**2-2D0*sb**2*sdth
     &      **2-sbth**2*sdth**2+sb**2*sbth**2*sdth**2)
      AAABR(6043) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2-sbth
     &      **2+2D0*sdth**2+sb**2*sbth**2-2D0*sb**2*sdth
     &      **2-sbth**2*sdth**2+sb**2*sbth**2*sdth**2)
      AAABR(6044) = EE**2/SW**2/cb**2*ssth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(6045) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-ssth**2-2D0*sb**2*sdth**2+sb**2*ssth
     &      **2-sdth**2*ssth**2+sb**2*sdth**2*ssth**2)
      AAABR(6046) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+2D0
     &      *sdth**2-ssth**2-2D0*sb**2*sdth**2+sb**2*ssth
     &      **2-sdth**2*ssth**2+sb**2*sdth**2*ssth**2)
      AAABR(6047) = GG**2/cb**2*(sbth**2-sbth**4-sb**2*sbth
     &      **2+sb**2*sbth**4)
      AAABR(6048) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +sbth**2/CW**2-sbth**4/CW**2+9D0*sbth**2/SW**2
     &      -9D0*sbth**4/SW**2-sb**2/CW**2*sbth**2+sb**2
     &      /CW**2*sbth**4-9D0*sb**2/SW**2*sbth**2+9D0*sb
     &      **2/SW**2*sbth**4-36D0*Mb**2/MW**2/SW**2*sbth
     &      **2+36D0*Mb**2/MW**2/SW**2*sbth**4)
      AAABR(6049) = EE**2/SW**2/cb**2*(sbth**2-sbth**4-sb
     &      **2*sbth**2+sb**2*sbth**4)
      AAABR(6050) = EE**2/cb**2*(sbth**2/CW**2-sbth**4/CW
     &      **2+9D0*sbth**2/SW**2-9D0*sbth**4/SW**2-sb**2
     &      /CW**2*sbth**2+sb**2/CW**2*sbth**4+18D0*Mb**2
     &      /MW**2/SW**2-9D0*sb**2/SW**2*sbth**2+9D0*sb**2
     &      /SW**2*sbth**4-36D0*Mb**2/MW**2/SW**2*sbth**2
     &      +36D0*Mb**2/MW**2/SW**2*sbth**4)
      AAABR(6051) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+sbth
     &      **2-sbth**4-sb**2*sbth**2+sb**2*sbth**4)
      AAABR(6052) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+sbth
     &      **2-sbth**4-sb**2*sbth**2+sb**2*sbth**4)
      AAABR(6053) = EE**2/CW**2/cb**2*(sbth**2-sbth**4-sb
     &      **2*sbth**2+sb**2*sbth**4)
      AAABR(6054) = EE**2/CW**3*SW/cb**2*(sbth**2-sbth**4
     &      -sb**2*sbth**2+sb**2*sbth**4)
      AAABR(6055) = EE**2/MW**2*Mb**2/SW**2/cb**2*(1D0-2D0
     &      *sbth**2+2D0*sbth**4)
      AAABR(6056) = EE**2/MW**2*Mb**2/SW**2/cb**2*sb**2*(1D0
     &      -2D0*sbth**2+2D0*sbth**4)
      AAABR(6057) = EE**2/MW**2*Mb/SW**2/cb**2*(1D0-2D0*sbth
     &      **2+2D0*sbth**4)
      AAABR(6058) = GG**2/cb**2*(sdth**2-sdth**4-sb**2*sdth
     &      **2+sb**2*sdth**4)
      AAABR(6059) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +sdth**2/CW**2-sdth**4/CW**2+9D0*sdth**2/SW**2
     &      -9D0*sdth**4/SW**2-sb**2/CW**2*sdth**2+sb**2
     &      /CW**2*sdth**4-9D0*sb**2/SW**2*sdth**2+9D0*sb
     &      **2/SW**2*sdth**4-36D0*Md**2/MW**2/SW**2*sdth
     &      **2+36D0*Md**2/MW**2/SW**2*sdth**4)
      AAABR(6060) = EE**2/SW**2/cb**2*(sdth**2-sdth**4-sb
     &      **2*sdth**2+sb**2*sdth**4)
      AAABR(6061) = EE**2/cb**2*(sdth**2/CW**2-sdth**4/CW
     &      **2+9D0*sdth**2/SW**2-9D0*sdth**4/SW**2-sb**2
     &      /CW**2*sdth**2+sb**2/CW**2*sdth**4+18D0*Md**2
     &      /MW**2/SW**2-9D0*sb**2/SW**2*sdth**2+9D0*sb**2
     &      /SW**2*sdth**4-36D0*Md**2/MW**2/SW**2*sdth**2
     &      +36D0*Md**2/MW**2/SW**2*sdth**4)
      AAABR(6062) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+sdth
     &      **2-sdth**4-sb**2*sdth**2+sb**2*sdth**4)
      AAABR(6063) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+sdth
     &      **2-sdth**4-sb**2*sdth**2+sb**2*sdth**4)
      AAABR(6064) = EE**2/CW**2/cb**2*(sdth**2-sdth**4-sb
     &      **2*sdth**2+sb**2*sdth**4)
      AAABR(6065) = EE**2/CW**3*SW/cb**2*(sdth**2-sdth**4
     &      -sb**2*sdth**2+sb**2*sdth**4)
      AAABR(6066) = EE**2/MW**2*Md**2/SW**2/cb**2*(1D0-2D0
     &      *sdth**2+2D0*sdth**4)
      AAABR(6067) = EE**2/MW**2*Md**2/SW**2/cb**2*sb**2*(1D0
     &      -2D0*sdth**2+2D0*sdth**4)
      AAABR(6068) = EE**2/MW**2*Md/SW**2/cb**2*(1D0-2D0*sdth
     &      **2+2D0*sdth**4)
      AAABR(6069) = GG**2/cb**2*(ssth**2-ssth**4-sb**2*ssth
     &      **2+sb**2*ssth**4)
      AAABR(6070) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      +ssth**2/CW**2-ssth**4/CW**2+9D0*ssth**2/SW**2
     &      -9D0*ssth**4/SW**2-sb**2/CW**2*ssth**2+sb**2
     &      /CW**2*ssth**4-9D0*sb**2/SW**2*ssth**2+9D0*sb
     &      **2/SW**2*ssth**4-36D0*Ms**2/MW**2/SW**2*ssth
     &      **2+36D0*Ms**2/MW**2/SW**2*ssth**4)
      AAABR(6071) = EE**2/SW**2/cb**2*(ssth**2-ssth**4-sb
     &      **2*ssth**2+sb**2*ssth**4)
      AAABR(6072) = EE**2/cb**2*(ssth**2/CW**2-ssth**4/CW
     &      **2+9D0*ssth**2/SW**2-9D0*ssth**4/SW**2-sb**2
     &      /CW**2*ssth**2+sb**2/CW**2*ssth**4+18D0*Ms**2
     &      /MW**2/SW**2-9D0*sb**2/SW**2*ssth**2+9D0*sb**2
     &      /SW**2*ssth**4-36D0*Ms**2/MW**2/SW**2*ssth**2
     &      +36D0*Ms**2/MW**2/SW**2*ssth**4)
      AAABR(6073) = EE**2/CW**2/cb**2*(2D0-2D0*sb**2+ssth
     &      **2-ssth**4-sb**2*ssth**2+sb**2*ssth**4)
      AAABR(6074) = EE**2/CW**3*SW/cb**2*(2D0-2D0*sb**2+ssth
     &      **2-ssth**4-sb**2*ssth**2+sb**2*ssth**4)
      AAABR(6075) = EE**2/CW**2/cb**2*(ssth**2-ssth**4-sb
     &      **2*ssth**2+sb**2*ssth**4)
      AAABR(6076) = EE**2/CW**3*SW/cb**2*(ssth**2-ssth**4
     &      -sb**2*ssth**2+sb**2*ssth**4)
      AAABR(6077) = EE**2/MW**2*Ms**2/SW**2/cb**2*(1D0-2D0
     &      *ssth**2+2D0*ssth**4)
      AAABR(6078) = EE**2/MW**2*Ms**2/SW**2/cb**2*sb**2*(1D0
     &      -2D0*ssth**2+2D0*ssth**4)
      AAABR(6079) = EE**2/MW**2*Ms/SW**2/cb**2*(1D0-2D0*ssth
     &      **2+2D0*ssth**4)
      AAABR(6080) = EE**2/SW**2/cb**2*cdth*sdth*ssth**2*(1D0
     &      -sb**2)
      AAABR(6081) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sdth**2/CW**2-2D0*ssth**2/CW**2+2D0*sb**2
     &      /CW**2*sdth**2+2D0*sb**2/CW**2*ssth**2+sdth**2
     &      /CW**2*ssth**2+9D0*sdth**2/SW**2*ssth**2-sb**2
     &      /CW**2*sdth**2*ssth**2-9D0*sb**2/SW**2*sdth**2
     &      *ssth**2+36D0*Md/MW**2*Ms/SW**2*cdth*csth*sdth
     &      *ssth)
      AAABR(6082) = EE**2/CW**2/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(6083) = EE**2/CW**3*SW/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(6084) = EE**2/SW**2/cb**2*cbth*sbth**3*(1D0-sb
     &      **2)
      AAABR(6085) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -4D0*sbth**2/CW**2+sbth**4/CW**2+9D0*sbth**4
     &      /SW**2+4D0*sb**2/CW**2*sbth**2-sb**2/CW**2*sbth
     &      **4-9D0*sb**2/SW**2*sbth**4+36D0*Mb**2/MW**2
     &      /SW**2*sbth**2-36D0*Mb**2/MW**2/SW**2*sbth**4)
      AAABR(6086) = EE**2/CW**2/cb**2*cbth*(2D0*sbth-sbth
     &      **3-2D0*sb**2*sbth+sb**2*sbth**3)
      AAABR(6087) = EE**2/CW**3*SW/cb**2*cbth*(2D0*sbth-sbth
     &      **3-2D0*sb**2*sbth+sb**2*sbth**3)
      AAABR(6088) = EE**2/SW**2/cb**2*cdth*sbth**2*sdth*(1D0
     &      -sb**2)
      AAABR(6089) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sbth**2/CW**2-2D0*sdth**2/CW**2+2D0*sb**2
     &      /CW**2*sbth**2+2D0*sb**2/CW**2*sdth**2+sbth**2
     &      /CW**2*sdth**2+9D0*sbth**2/SW**2*sdth**2-sb**2
     &      /CW**2*sbth**2*sdth**2-9D0*sb**2/SW**2*sbth**2
     &      *sdth**2+36D0*Mb/MW**2*Md/SW**2*cbth*cdth*sbth
     &      *sdth)
      AAABR(6090) = EE**2/CW**2/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(6091) = EE**2/CW**3*SW/cb**2*cdth*sdth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(6092) = EE**2/SW**2/cb**2*csth*sdth**2*ssth*(1D0
     &      -sb**2)
      AAABR(6093) = EE**2/CW**2/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(6094) = EE**2/CW**3*SW/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(6095) = EE**2/SW**2/cb**2*csth*sbth**2*ssth*(1D0
     &      -sb**2)
      AAABR(6096) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -2D0*sbth**2/CW**2-2D0*ssth**2/CW**2+2D0*sb**2
     &      /CW**2*sbth**2+2D0*sb**2/CW**2*ssth**2+sbth**2
     &      /CW**2*ssth**2+9D0*sbth**2/SW**2*ssth**2-sb**2
     &      /CW**2*sbth**2*ssth**2-9D0*sb**2/SW**2*sbth**2
     &      *ssth**2+36D0*Mb/MW**2*Ms/SW**2*cbth*csth*sbth
     &      *ssth)
      AAABR(6097) = EE**2/CW**2/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(6098) = EE**2/CW**3*SW/cb**2*csth*ssth*(2D0-2D0
     &      *sb**2-sbth**2+sb**2*sbth**2)
      AAABR(6099) = EE**2/SW**2/cb**2*cbth*sbth*sdth**2*(1D0
     &      -sb**2)
      AAABR(6100) = EE**2/CW**2/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(6101) = EE**2/CW**3*SW/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-sdth**2+sb**2*sdth**2)
      AAABR(6102) = EE**2/SW**2/cb**2*cbth*sbth*ssth**2*(1D0
     &      -sb**2)
      AAABR(6103) = EE**2/CW**2/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(6104) = EE**2/CW**3*SW/cb**2*cbth*sbth*(2D0-2D0
     &      *sb**2-ssth**2+sb**2*ssth**2)
      AAABR(6105) = EE**2/SW**2/cb**2*cdth*sdth**3*(1D0-sb
     &      **2)
      AAABR(6106) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -4D0*sdth**2/CW**2+sdth**4/CW**2+9D0*sdth**4
     &      /SW**2+4D0*sb**2/CW**2*sdth**2-sb**2/CW**2*sdth
     &      **4-9D0*sb**2/SW**2*sdth**4+36D0*Md**2/MW**2
     &      /SW**2*sdth**2-36D0*Md**2/MW**2/SW**2*sdth**4)
      AAABR(6107) = EE**2/CW**2/cb**2*cdth*(2D0*sdth-sdth
     &      **3-2D0*sb**2*sdth+sb**2*sdth**3)
      AAABR(6108) = EE**2/CW**3*SW/cb**2*cdth*(2D0*sdth-sdth
     &      **3-2D0*sb**2*sdth+sb**2*sdth**3)
      AAABR(6109) = EE**2/SW**2/cb**2*csth*ssth**3*(1D0-sb
     &      **2)
      AAABR(6110) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -4D0*ssth**2/CW**2+ssth**4/CW**2+9D0*ssth**4
     &      /SW**2+4D0*sb**2/CW**2*ssth**2-sb**2/CW**2*ssth
     &      **4-9D0*sb**2/SW**2*ssth**4+36D0*Ms**2/MW**2
     &      /SW**2*ssth**2-36D0*Ms**2/MW**2/SW**2*ssth**4)
      AAABR(6111) = EE**2/CW**2/cb**2*csth*(2D0*ssth-ssth
     &      **3-2D0*sb**2*ssth+sb**2*ssth**3)
      AAABR(6112) = EE**2/CW**3*SW/cb**2*csth*(2D0*ssth-ssth
     &      **3-2D0*sb**2*ssth+sb**2*ssth**3)
      AAABR(6113) = GG**2*(1D0-2D0*scth**2-2D0*sdth**2+4D0
     &      *scth**2*sdth**2)
      AAABR(6114) = GG**2*ccth*scth*(1D0-2D0*sdth**2)
      AAABR(6115) = GG**2*cdth*sdth*(1D0-2D0*scth**2)
      AAABR(6116) = EE**2*(1D0/CW**2-9D0/SW**2-5D0*scth**2
     &      /CW**2+sdth**2/CW**2+9D0*scth**2/SW**2+9D0*sdth
     &      **2/SW**2-5D0*scth**2/CW**2*sdth**2-9D0*scth
     &      **2/SW**2*sdth**2)
      AAABR(6117) = EE**2*ccth*scth*(5D0/CW**2-9D0/SW**2
     &      +5D0*sdth**2/CW**2+9D0*sdth**2/SW**2)
      AAABR(6118) = EE**2/SW**2*(1D0-scth**2-sdth**2+scth
     &      **2*sdth**2)
      AAABR(6119) = EE**2*cdth*sdth*(1D0/CW**2+9D0/SW**2
     &      -5D0*scth**2/CW**2-9D0*scth**2/SW**2)
      AAABR(6120) = EE**2/CW**2*(1D0-5D0*scth**2+sdth**2
     &      -5D0*scth**2*sdth**2)
      AAABR(6121) = EE**2/CW**3*SW*(1D0-5D0*scth**2+sdth
     &      **2-5D0*scth**2*sdth**2)
      AAABR(6122) = GG**2/cb**2*(1D0-sb**2-2D0*scth**2-2D0
     &      *ssth**2+2D0*sb**2*scth**2+2D0*sb**2*ssth**2
     &      +4D0*scth**2*ssth**2-4D0*sb**2*scth**2*ssth**2)
      AAABR(6123) = GG**2/cb**2*csth*ssth*(1D0-sb**2-2D0
     &      *scth**2+2D0*sb**2*scth**2)
      AAABR(6124) = GG**2/cb**2*ccth*scth*(1D0-sb**2-2D0
     &      *ssth**2+2D0*sb**2*ssth**2)
      AAABR(6125) = EE**2/cb**2*(1D0/CW**2-9D0/SW**2-sb**2
     &      /CW**2-5D0*scth**2/CW**2+ssth**2/CW**2+9D0*sb
     &      **2/SW**2+9D0*scth**2/SW**2+9D0*ssth**2/SW**2
     &      +5D0*sb**2/CW**2*scth**2-sb**2/CW**2*ssth**2
     &      -5D0*scth**2/CW**2*ssth**2-9D0*sb**2/SW**2*scth
     &      **2-9D0*sb**2/SW**2*ssth**2-9D0*scth**2/SW**2
     &      *ssth**2+5D0*sb**2/CW**2*scth**2*ssth**2+9D0
     &      *sb**2/SW**2*scth**2*ssth**2)
      AAABR(6126) = EE**2/cb**2*csth*ssth*(1D0/CW**2+9D0
     &      /SW**2-sb**2/CW**2-5D0*scth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*scth**2/SW**2+5D0*sb**2/CW**2*scth
     &      **2+9D0*sb**2/SW**2*scth**2)
      AAABR(6127) = EE**2/SW**2/cb**2*(1D0-sb**2-scth**2
     &      -ssth**2+sb**2*scth**2+sb**2*ssth**2+scth**2
     &      *ssth**2-sb**2*scth**2*ssth**2)
      AAABR(6128) = EE**2/cb**2*ccth*scth*(5D0/CW**2-9D0
     &      /SW**2-5D0*sb**2/CW**2+5D0*ssth**2/CW**2+9D0
     &      *sb**2/SW**2+9D0*ssth**2/SW**2-5D0*sb**2/CW**2
     &      *ssth**2-9D0*sb**2/SW**2*ssth**2)
      AAABR(6129) = EE**2/SW**2/cb**2*(1D0-sb**2-scth**2
     &      -ssth**2+sb**2*scth**2+sb**2*ssth**2+scth**2
     &      *ssth**2-Mc**2/MW**2*scth**2+Ms**2/MW**2*ssth
     &      **2-sb**2*scth**2*ssth**2+Mc**2/MW**2/sb**2*scth
     &      **2+Mc**2/MW**2*scth**2*ssth**2-Ms**2/MW**2*scth
     &      **2*ssth**2-Mc**2/MW**2/sb**2*scth**2*ssth**2)
      AAABR(6130) = EE**2/SW**2/cb**2*ccth*scth*(1D0-sb**2
     &      -ssth**2+Mc**2/MW**2+sb**2*ssth**2-Mc**2/MW**2
     &      /sb**2-Mc**2/MW**2*ssth**2+Ms**2/MW**2*ssth**2
     &      +Mc**2/MW**2/sb**2*ssth**2)
      AAABR(6131) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -scth**2-Ms**2/MW**2+sb**2*scth**2-Mc**2/MW**2
     &      *scth**2+Ms**2/MW**2*scth**2+Mc**2/MW**2/sb**2
     &      *scth**2)
      AAABR(6132) = EE**2/CW**2/cb**2*(1D0-sb**2-5D0*scth
     &      **2+ssth**2+5D0*sb**2*scth**2-sb**2*ssth**2-5D0
     &      *scth**2*ssth**2+5D0*sb**2*scth**2*ssth**2)
      AAABR(6133) = EE**2/CW**3*SW/cb**2*(1D0-sb**2-5D0*scth
     &      **2+ssth**2+5D0*sb**2*scth**2-sb**2*ssth**2-5D0
     &      *scth**2*ssth**2+5D0*sb**2*scth**2*ssth**2)
      AAABR(6134) = EE**2/MW**2/SW**2/cb**2*(Mc**2*scth**2
     &      -Ms**2*ssth**2-Mc**2/sb**2*scth**2-Mc**2*scth
     &      **2*ssth**2+Ms**2*scth**2*ssth**2+Mc**2/sb**2
     &      *scth**2*ssth**2)
      AAABR(6135) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2*scth
     &      **2-Mc**2/sb**2*scth**2-Mc**2*sb**2*scth**2-2D0
     &      *Mc**2*scth**2*ssth**2+Ms**2*sb**2*ssth**2+Mc
     &      **2/sb**2*scth**2*ssth**2+Mc**2*sb**2*scth**2
     &      *ssth**2-Ms**2*sb**2*scth**2*ssth**2)
      AAABR(6136) = EE**2/MW**2*Ms/SW**2/cb**2*ssth**2*(1D0
     &      -scth**2)
      AAABR(6137) = EE**2/MW**2*Mc/SW**2/cb**2*scth**2*(1D0
     &      -1D0/sb**2-ssth**2+ssth**2/sb**2)
      AAABR(6138) = GG**2*(1D0-2D0*ssth**2-2D0*stth**2+4D0
     &      *ssth**2*stth**2)
      AAABR(6139) = GG**2*ctth*stth*(1D0-2D0*ssth**2)
      AAABR(6140) = GG**2*csth*ssth*(1D0-2D0*stth**2)
      AAABR(6141) = EE**2*(1D0/CW**2-9D0/SW**2+ssth**2/CW
     &      **2-5D0*stth**2/CW**2+9D0*ssth**2/SW**2+9D0*stth
     &      **2/SW**2-5D0*ssth**2/CW**2*stth**2-9D0*ssth
     &      **2/SW**2*stth**2)
      AAABR(6142) = EE**2*ctth*stth*(5D0/CW**2-9D0/SW**2
     &      +5D0*ssth**2/CW**2+9D0*ssth**2/SW**2)
      AAABR(6143) = EE**2/SW**2*(1D0-ssth**2-stth**2+ssth
     &      **2*stth**2)
      AAABR(6144) = EE**2*csth*ssth*(1D0/CW**2+9D0/SW**2
     &      -5D0*stth**2/CW**2-9D0*stth**2/SW**2)
      AAABR(6145) = EE**2/CW**2*(1D0+ssth**2-5D0*stth**2
     &      -5D0*ssth**2*stth**2)
      AAABR(6146) = EE**2/CW**3*SW*(1D0+ssth**2-5D0*stth
     &      **2-5D0*ssth**2*stth**2)
      AAABR(6147) = EE**2/SW**2/cb**2*(ccth*cdth*csth*cuth
     &      -ccth*cdth*csth*cuth*sb**2-Mc/MW**2*Mu*cdth*csth
     &      *scth*suth+Md/MW**2*Ms*ccth*cuth*sdth*ssth+Mc
     &      /MW**2*Mu*cdth*csth/sb**2*scth*suth)
      AAABR(6148) = EE**2/SW**2/cb**2*(cdth*csth*cuth*scth
     &      -cdth*csth*cuth*sb**2*scth+Mc/MW**2*Mu*ccth*cdth
     &      *csth*suth+Md/MW**2*Ms*cuth*scth*sdth*ssth-Mc
     &      /MW**2*Mu*ccth*cdth*csth/sb**2*suth)
      AAABR(6149) = EE**2/SW**2/cb**2*(ccth*cdth*cuth*ssth
     &      -ccth*cdth*cuth*sb**2*ssth-Mc/MW**2*Mu*cdth*scth
     &      *ssth*suth-Md/MW**2*Ms*ccth*csth*cuth*sdth+Mc
     &      /MW**2*Mu*cdth/sb**2*scth*ssth*suth)
      AAABR(6150) = EE**2/SW**2/cb**2*ccth*cdth*csth*cuth
     &      *(1D0-sb**2)
      AAABR(6151) = EE**2/SW**2/cb**2*(ccth*csth*cuth*sdth
     &      -ccth*csth*cuth*sb**2*sdth-Mc/MW**2*Mu*csth*scth
     &      *sdth*suth-Md/MW**2*Ms*ccth*cdth*cuth*ssth+Mc
     &      /MW**2*Mu*csth/sb**2*scth*sdth*suth)
      AAABR(6152) = EE**2/SW**2/cb**2*(ccth*cdth*csth*suth
     &      -ccth*cdth*csth*sb**2*suth+Mc/MW**2*Mu*cdth*csth
     &      *cuth*scth+Md/MW**2*Ms*ccth*sdth*ssth*suth-Mc
     &      /MW**2*Mu*cdth*csth*cuth/sb**2*scth)
      AAABR(6153) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*cdth*csth
     &      *scth*suth-Md*Ms*ccth*cuth*sdth*ssth-Mc*Mu*cdth
     &      *csth/sb**2*scth*suth)
      AAABR(6154) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*cdth
     &      *csth*scth*suth-Mc*Mu*cdth*csth/sb**2*scth*suth
     &      -Mc*Mu*cdth*csth*sb**2*scth*suth+Md*Ms*ccth*cuth
     &      *sb**2*sdth*ssth)
      AAABR(6155) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*cuth
     &      *sdth*ssth
      AAABR(6156) = EE**2/MW**2*Md/SW**2/cb**2*ccth*cuth
     &      *sdth*ssth
      AAABR(6157) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*csth
     &      *scth*suth*(1D0-1D0/sb**2)
      AAABR(6158) = EE**2/MW**2*Mc/SW**2/cb**2*cdth*csth
     &      *scth*suth*(1D0-1D0/sb**2)
      AAABR(6159) = EE**2/SW**2/cb**2*(cbth*ccth*csth*ctth
     &      -cbth*ccth*csth*ctth*sb**2+Mb/MW**2*Ms*ccth*ctth
     &      *sbth*ssth-Mc/MW**2*Mt*cbth*csth*scth*stth+Mc
     &      /MW**2*Mt*cbth*csth/sb**2*scth*stth)
      AAABR(6160) = EE**2/SW**2/cb**2*(cbth*ccth*csth*stth
     &      -cbth*ccth*csth*sb**2*stth+Mb/MW**2*Ms*ccth*sbth
     &      *ssth*stth+Mc/MW**2*Mt*cbth*csth*ctth*scth-Mc
     &      /MW**2*Mt*cbth*csth*ctth/sb**2*scth)
      AAABR(6161) = EE**2/SW**2/cb**2*(ccth*csth*ctth*sbth
     &      -ccth*csth*ctth*sb**2*sbth-Mb/MW**2*Ms*cbth*ccth
     &      *ctth*ssth-Mc/MW**2*Mt*csth*sbth*scth*stth+Mc
     &      /MW**2*Mt*csth/sb**2*sbth*scth*stth)
      AAABR(6162) = EE**2/SW**2/cb**2*cbth*ccth*csth*ctth
     &      *(1D0-sb**2)
      AAABR(6163) = EE**2/SW**2/cb**2*(cbth*ccth*ctth*ssth
     &      -cbth*ccth*ctth*sb**2*ssth-Mb/MW**2*Ms*ccth*csth
     &      *ctth*sbth-Mc/MW**2*Mt*cbth*scth*ssth*stth+Mc
     &      /MW**2*Mt*cbth/sb**2*scth*ssth*stth)
      AAABR(6164) = EE**2/SW**2/cb**2*(cbth*csth*ctth*scth
     &      -cbth*csth*ctth*sb**2*scth+Mb/MW**2*Ms*ctth*sbth
     &      *scth*ssth+Mc/MW**2*Mt*cbth*ccth*csth*stth-Mc
     &      /MW**2*Mt*cbth*ccth*csth/sb**2*stth)
      AAABR(6165) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*ccth*ctth
     &      *sbth*ssth-Mc*Mt*cbth*csth*scth*stth+Mc*Mt*cbth
     &      *csth/sb**2*scth*stth)
      AAABR(6166) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *csth*scth*stth+Mb*Ms*ccth*ctth*sb**2*sbth*ssth
     &      -Mc*Mt*cbth*csth/sb**2*scth*stth-Mc*Mt*cbth*csth
     &      *sb**2*scth*stth)
      AAABR(6167) = EE**2/MW**2*Mb/SW**2/cb**2*ccth*ctth
     &      *sbth*ssth
      AAABR(6168) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*ctth
     &      *sbth*ssth
      AAABR(6169) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*csth
     &      *scth*stth*(1D0-1D0/sb**2)
      AAABR(6170) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*csth
     &      *scth*stth*(1D0-1D0/sb**2)
      AAABR(6171) = GG**2/cb**2*(1D0-sb**2-2D0*sdth**2-2D0
     &      *suth**2+2D0*sb**2*sdth**2+2D0*sb**2*suth**2
     &      +4D0*sdth**2*suth**2-4D0*sb**2*sdth**2*suth**2)
      AAABR(6172) = GG**2/cb**2*cdth*sdth*(1D0-sb**2-2D0
     &      *suth**2+2D0*sb**2*suth**2)
      AAABR(6173) = GG**2/cb**2*cuth*suth*(1D0-sb**2-2D0
     &      *sdth**2+2D0*sb**2*sdth**2)
      AAABR(6174) = EE**2/cb**2*(1D0/CW**2-9D0/SW**2-sb**2
     &      /CW**2+sdth**2/CW**2-5D0*suth**2/CW**2+9D0*sb
     &      **2/SW**2+9D0*sdth**2/SW**2+9D0*suth**2/SW**2
     &      -sb**2/CW**2*sdth**2+5D0*sb**2/CW**2*suth**2
     &      -5D0*sdth**2/CW**2*suth**2-9D0*sb**2/SW**2*sdth
     &      **2-9D0*sb**2/SW**2*suth**2-9D0*sdth**2/SW**2
     &      *suth**2+5D0*sb**2/CW**2*sdth**2*suth**2+9D0
     &      *sb**2/SW**2*sdth**2*suth**2)
      AAABR(6175) = EE**2/cb**2*cdth*sdth*(1D0/CW**2+9D0
     &      /SW**2-sb**2/CW**2-5D0*suth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*suth**2/SW**2+5D0*sb**2/CW**2*suth
     &      **2+9D0*sb**2/SW**2*suth**2)
      AAABR(6176) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -suth**2+sb**2*sdth**2+sb**2*suth**2+sdth**2
     &      *suth**2-sb**2*sdth**2*suth**2)
      AAABR(6177) = EE**2/cb**2*cuth*suth*(5D0/CW**2-9D0
     &      /SW**2-5D0*sb**2/CW**2+5D0*sdth**2/CW**2+9D0
     &      *sb**2/SW**2+9D0*sdth**2/SW**2-5D0*sb**2/CW**2
     &      *sdth**2-9D0*sb**2/SW**2*sdth**2)
      AAABR(6178) = EE**2/SW**2/cb**2*(1D0-sb**2-sdth**2
     &      -suth**2+sb**2*sdth**2+sb**2*suth**2+sdth**2
     &      *suth**2+Md**2/MW**2*sdth**2-Mu**2/MW**2*suth
     &      **2-sb**2*sdth**2*suth**2-Md**2/MW**2*sdth**2
     &      *suth**2+Mu**2/MW**2/sb**2*suth**2+Mu**2/MW**2
     &      *sdth**2*suth**2-Mu**2/MW**2/sb**2*sdth**2*suth
     &      **2)
      AAABR(6179) = EE**2/SW**2/cb**2*cuth*suth*(1D0-sb**2
     &      -sdth**2+Mu**2/MW**2+sb**2*sdth**2+Md**2/MW**2
     &      *sdth**2-Mu**2/MW**2/sb**2-Mu**2/MW**2*sdth**2
     &      +Mu**2/MW**2/sb**2*sdth**2)
      AAABR(6180) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -suth**2-Md**2/MW**2+sb**2*suth**2+Md**2/MW**2
     &      *suth**2-Mu**2/MW**2*suth**2+Mu**2/MW**2/sb**2
     &      *suth**2)
      AAABR(6181) = EE**2/CW**2/cb**2*(1D0-sb**2+sdth**2
     &      -5D0*suth**2-sb**2*sdth**2+5D0*sb**2*suth**2
     &      -5D0*sdth**2*suth**2+5D0*sb**2*sdth**2*suth**2)
      AAABR(6182) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sdth
     &      **2-5D0*suth**2-sb**2*sdth**2+5D0*sb**2*suth
     &      **2-5D0*sdth**2*suth**2+5D0*sb**2*sdth**2*suth
     &      **2)
      AAABR(6183) = EE**2/MW**2/SW**2/cb**2*(Md**2*sdth**2
     &      -Mu**2*suth**2-Md**2*sdth**2*suth**2+Mu**2/sb
     &      **2*suth**2+Mu**2*sdth**2*suth**2-Mu**2/sb**2
     &      *sdth**2*suth**2)
      AAABR(6184) = EE**2/MW**2/SW**2/cb**2*(2D0*Mu**2*suth
     &      **2+Md**2*sb**2*sdth**2-Mu**2/sb**2*suth**2-Mu
     &      **2*sb**2*suth**2-2D0*Mu**2*sdth**2*suth**2-Md
     &      **2*sb**2*sdth**2*suth**2+Mu**2/sb**2*sdth**2
     &      *suth**2+Mu**2*sb**2*sdth**2*suth**2)
      AAABR(6185) = EE**2/MW**2*Md/SW**2/cb**2*sdth**2*(1D0
     &      -suth**2)
      AAABR(6186) = EE**2/MW**2*Mu/SW**2/cb**2*suth**2*(1D0
     &      -1D0/sb**2-sdth**2+sdth**2/sb**2)
      AAABR(6187) = GG**2*(1D0-2D0*sdth**2-2D0*stth**2+4D0
     &      *sdth**2*stth**2)
      AAABR(6188) = GG**2*ctth*stth*(1D0-2D0*sdth**2)
      AAABR(6189) = GG**2*cdth*sdth*(1D0-2D0*stth**2)
      AAABR(6190) = EE**2*(1D0/CW**2-9D0/SW**2+sdth**2/CW
     &      **2-5D0*stth**2/CW**2+9D0*sdth**2/SW**2+9D0*stth
     &      **2/SW**2-5D0*sdth**2/CW**2*stth**2-9D0*sdth
     &      **2/SW**2*stth**2)
      AAABR(6191) = EE**2*ctth*stth*(5D0/CW**2-9D0/SW**2
     &      +5D0*sdth**2/CW**2+9D0*sdth**2/SW**2)
      AAABR(6192) = EE**2/SW**2*(1D0-sdth**2-stth**2+sdth
     &      **2*stth**2)
      AAABR(6193) = EE**2*cdth*sdth*(1D0/CW**2+9D0/SW**2
     &      -5D0*stth**2/CW**2-9D0*stth**2/SW**2)
      AAABR(6194) = EE**2/CW**2*(1D0+sdth**2-5D0*stth**2
     &      -5D0*sdth**2*stth**2)
      AAABR(6195) = EE**2/CW**3*SW*(1D0+sdth**2-5D0*stth
     &      **2-5D0*sdth**2*stth**2)
      AAABR(6196) = EE**2/SW**2/cb**2*(cbth*cdth*ctth*cuth
     &      -cbth*cdth*ctth*cuth*sb**2+Mb/MW**2*Md*ctth*cuth
     &      *sbth*sdth-Mt/MW**2*Mu*cbth*cdth*stth*suth+Mt
     &      /MW**2*Mu*cbth*cdth/sb**2*stth*suth)
      AAABR(6197) = EE**2/SW**2/cb**2*(cdth*ctth*cuth*sbth
     &      -cdth*ctth*cuth*sb**2*sbth-Mb/MW**2*Md*cbth*ctth
     &      *cuth*sdth-Mt/MW**2*Mu*cdth*sbth*stth*suth+Mt
     &      /MW**2*Mu*cdth/sb**2*sbth*stth*suth)
      AAABR(6198) = EE**2/SW**2/cb**2*(cbth*cdth*cuth*stth
     &      -cbth*cdth*cuth*sb**2*stth+Mb/MW**2*Md*cuth*sbth
     &      *sdth*stth+Mt/MW**2*Mu*cbth*cdth*ctth*suth-Mt
     &      /MW**2*Mu*cbth*cdth*ctth/sb**2*suth)
      AAABR(6199) = EE**2/SW**2/cb**2*cbth*cdth*ctth*cuth
     &      *(1D0-sb**2)
      AAABR(6200) = EE**2/SW**2/cb**2*(cbth*cdth*ctth*suth
     &      -cbth*cdth*ctth*sb**2*suth+Mb/MW**2*Md*ctth*sbth
     &      *sdth*suth+Mt/MW**2*Mu*cbth*cdth*cuth*stth-Mt
     &      /MW**2*Mu*cbth*cdth*cuth/sb**2*stth)
      AAABR(6201) = EE**2/SW**2/cb**2*(cbth*ctth*cuth*sdth
     &      -cbth*ctth*cuth*sb**2*sdth-Mb/MW**2*Md*cdth*ctth
     &      *cuth*sbth-Mt/MW**2*Mu*cbth*sdth*stth*suth+Mt
     &      /MW**2*Mu*cbth/sb**2*sdth*stth*suth)
      AAABR(6202) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*ctth*cuth
     &      *sbth*sdth-Mt*Mu*cbth*cdth*stth*suth+Mt*Mu*cbth
     &      *cdth/sb**2*stth*suth)
      AAABR(6203) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *cdth*stth*suth+Mb*Md*ctth*cuth*sb**2*sbth*sdth
     &      -Mt*Mu*cbth*cdth/sb**2*stth*suth-Mt*Mu*cbth*cdth
     &      *sb**2*stth*suth)
      AAABR(6204) = EE**2/MW**2*Md/SW**2/cb**2*ctth*cuth
     &      *sbth*sdth
      AAABR(6205) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*cuth
     &      *sbth*sdth
      AAABR(6206) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*cdth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6207) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*cdth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6208) = GG**2*(1D0-2D0*sbth**2-2D0*scth**2+4D0
     &      *sbth**2*scth**2)
      AAABR(6209) = GG**2*cbth*sbth*(1D0-2D0*scth**2)
      AAABR(6210) = GG**2*ccth*scth*(1D0-2D0*sbth**2)
      AAABR(6211) = EE**2*(1D0/CW**2-9D0/SW**2+sbth**2/CW
     &      **2-5D0*scth**2/CW**2+9D0*sbth**2/SW**2+9D0*scth
     &      **2/SW**2-5D0*sbth**2/CW**2*scth**2-9D0*sbth
     &      **2/SW**2*scth**2)
      AAABR(6212) = EE**2*cbth*sbth*(1D0/CW**2+9D0/SW**2
     &      -5D0*scth**2/CW**2-9D0*scth**2/SW**2)
      AAABR(6213) = EE**2/SW**2*(1D0-sbth**2-scth**2+sbth
     &      **2*scth**2)
      AAABR(6214) = EE**2*ccth*scth*(5D0/CW**2-9D0/SW**2
     &      +5D0*sbth**2/CW**2+9D0*sbth**2/SW**2)
      AAABR(6215) = EE**2/CW**2*(1D0+sbth**2-5D0*scth**2
     &      -5D0*sbth**2*scth**2)
      AAABR(6216) = EE**2/CW**3*SW*(1D0+sbth**2-5D0*scth
     &      **2-5D0*sbth**2*scth**2)
      AAABR(6217) = GG**2*(1D0-2D0*ssth**2-2D0*suth**2+4D0
     &      *ssth**2*suth**2)
      AAABR(6218) = GG**2*csth*ssth*(1D0-2D0*suth**2)
      AAABR(6219) = GG**2*cuth*suth*(1D0-2D0*ssth**2)
      AAABR(6220) = EE**2*(1D0/CW**2-9D0/SW**2+ssth**2/CW
     &      **2-5D0*suth**2/CW**2+9D0*ssth**2/SW**2+9D0*suth
     &      **2/SW**2-5D0*ssth**2/CW**2*suth**2-9D0*ssth
     &      **2/SW**2*suth**2)
      AAABR(6221) = EE**2*csth*ssth*(1D0/CW**2+9D0/SW**2
     &      -5D0*suth**2/CW**2-9D0*suth**2/SW**2)
      AAABR(6222) = EE**2/SW**2*(1D0-ssth**2-suth**2+ssth
     &      **2*suth**2)
      AAABR(6223) = EE**2*cuth*suth*(5D0/CW**2-9D0/SW**2
     &      +5D0*ssth**2/CW**2+9D0*ssth**2/SW**2)
      AAABR(6224) = EE**2/CW**2*(1D0+ssth**2-5D0*suth**2
     &      -5D0*ssth**2*suth**2)
      AAABR(6225) = EE**2/CW**3*SW*(1D0+ssth**2-5D0*suth
     &      **2-5D0*ssth**2*suth**2)
      AAABR(6226) = GG**2/cb**2*(1D0-sb**2-2D0*sbth**2-2D0
     &      *stth**2+2D0*sb**2*sbth**2+2D0*sb**2*stth**2
     &      +4D0*sbth**2*stth**2-4D0*sb**2*sbth**2*stth**2)
      AAABR(6227) = GG**2/cb**2*cbth*sbth*(1D0-sb**2-2D0
     &      *stth**2+2D0*sb**2*stth**2)
      AAABR(6228) = GG**2/cb**2*ctth*stth*(1D0-sb**2-2D0
     &      *sbth**2+2D0*sb**2*sbth**2)
      AAABR(6229) = EE**2/cb**2*(1D0/CW**2-9D0/SW**2-sb**2
     &      /CW**2+sbth**2/CW**2-5D0*stth**2/CW**2+9D0*sb
     &      **2/SW**2+9D0*sbth**2/SW**2+9D0*stth**2/SW**2
     &      -sb**2/CW**2*sbth**2+5D0*sb**2/CW**2*stth**2
     &      -5D0*sbth**2/CW**2*stth**2-9D0*sb**2/SW**2*sbth
     &      **2-9D0*sb**2/SW**2*stth**2-9D0*sbth**2/SW**2
     &      *stth**2+5D0*sb**2/CW**2*sbth**2*stth**2+9D0
     &      *sb**2/SW**2*sbth**2*stth**2)
      AAABR(6230) = EE**2/cb**2*cbth*sbth*(1D0/CW**2+9D0
     &      /SW**2-sb**2/CW**2-5D0*stth**2/CW**2-9D0*sb**2
     &      /SW**2-9D0*stth**2/SW**2+5D0*sb**2/CW**2*stth
     &      **2+9D0*sb**2/SW**2*stth**2)
      AAABR(6231) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -stth**2+sb**2*sbth**2+sb**2*stth**2+sbth**2
     &      *stth**2-sb**2*sbth**2*stth**2)
      AAABR(6232) = EE**2/cb**2*ctth*stth*(5D0/CW**2-9D0
     &      /SW**2-5D0*sb**2/CW**2+5D0*sbth**2/CW**2+9D0
     &      *sb**2/SW**2+9D0*sbth**2/SW**2-5D0*sb**2/CW**2
     &      *sbth**2-9D0*sb**2/SW**2*sbth**2)
      AAABR(6233) = EE**2/SW**2/cb**2*(1D0-sb**2-sbth**2
     &      -stth**2+sb**2*sbth**2+sb**2*stth**2+sbth**2
     &      *stth**2+Mb**2/MW**2*sbth**2-Mt**2/MW**2*stth
     &      **2-sb**2*sbth**2*stth**2-Mb**2/MW**2*sbth**2
     &      *stth**2+Mt**2/MW**2/sb**2*stth**2+Mt**2/MW**2
     &      *sbth**2*stth**2-Mt**2/MW**2/sb**2*sbth**2*stth
     &      **2)
      AAABR(6234) = EE**2/SW**2/cb**2*ctth*stth*(1D0-sb**2
     &      -sbth**2+Mt**2/MW**2+sb**2*sbth**2+Mb**2/MW**2
     &      *sbth**2-Mt**2/MW**2/sb**2-Mt**2/MW**2*sbth**2
     &      +Mt**2/MW**2/sb**2*sbth**2)
      AAABR(6235) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -stth**2-Mb**2/MW**2+sb**2*stth**2+Mb**2/MW**2
     &      *stth**2-Mt**2/MW**2*stth**2+Mt**2/MW**2/sb**2
     &      *stth**2)
      AAABR(6236) = EE**2/CW**2/cb**2*(1D0-sb**2+sbth**2
     &      -5D0*stth**2-sb**2*sbth**2+5D0*sb**2*stth**2
     &      -5D0*sbth**2*stth**2+5D0*sb**2*sbth**2*stth**2)
      AAABR(6237) = EE**2/CW**3*SW/cb**2*(1D0-sb**2+sbth
     &      **2-5D0*stth**2-sb**2*sbth**2+5D0*sb**2*stth
     &      **2-5D0*sbth**2*stth**2+5D0*sb**2*sbth**2*stth
     &      **2)
      AAABR(6238) = EE**2/MW**2/SW**2/cb**2*(Mb**2*sbth**2
     &      -Mt**2*stth**2-Mb**2*sbth**2*stth**2+Mt**2/sb
     &      **2*stth**2+Mt**2*sbth**2*stth**2-Mt**2/sb**2
     &      *sbth**2*stth**2)
      AAABR(6239) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt**2*stth
     &      **2+Mb**2*sb**2*sbth**2-Mt**2/sb**2*stth**2-Mt
     &      **2*sb**2*stth**2-2D0*Mt**2*sbth**2*stth**2-Mb
     &      **2*sb**2*sbth**2*stth**2+Mt**2/sb**2*sbth**2
     &      *stth**2+Mt**2*sb**2*sbth**2*stth**2)
      AAABR(6240) = EE**2/MW**2*Mb/SW**2/cb**2*sbth**2*(1D0
     &      -stth**2)
      AAABR(6241) = EE**2/MW**2*Mt/SW**2/cb**2*stth**2*(1D0
     &      -1D0/sb**2-sbth**2+sbth**2/sb**2)
      AAABR(6242) = GG**2*(1D0-2D0*sbth**2-2D0*suth**2+4D0
     &      *sbth**2*suth**2)
      AAABR(6243) = GG**2*cbth*sbth*(1D0-2D0*suth**2)
      AAABR(6244) = GG**2*cuth*suth*(1D0-2D0*sbth**2)
      AAABR(6245) = EE**2*(1D0/CW**2-9D0/SW**2+sbth**2/CW
     &      **2-5D0*suth**2/CW**2+9D0*sbth**2/SW**2+9D0*suth
     &      **2/SW**2-5D0*sbth**2/CW**2*suth**2-9D0*sbth
     &      **2/SW**2*suth**2)
      AAABR(6246) = EE**2*cbth*sbth*(1D0/CW**2+9D0/SW**2
     &      -5D0*suth**2/CW**2-9D0*suth**2/SW**2)
      AAABR(6247) = EE**2/SW**2*(1D0-sbth**2-suth**2+sbth
     &      **2*suth**2)
      AAABR(6248) = EE**2*cuth*suth*(5D0/CW**2-9D0/SW**2
     &      +5D0*sbth**2/CW**2+9D0*sbth**2/SW**2)
      AAABR(6249) = EE**2/CW**2*(1D0+sbth**2-5D0*suth**2
     &      -5D0*sbth**2*suth**2)
      AAABR(6250) = EE**2/CW**3*SW*(1D0+sbth**2-5D0*suth
     &      **2-5D0*sbth**2*suth**2)
      AAABR(6251) = GG**2/cb**2*ccth*csth*scth*ssth*(1D0
     &      -sb**2)
      AAABR(6252) = EE**2/cb**2*ccth*csth*scth*ssth*(5D0
     &      /CW**2+9D0/SW**2-5D0*sb**2/CW**2-9D0*sb**2/SW
     &      **2)
      AAABR(6253) = EE**2/SW**2/cb**2*ccth*scth*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(6254) = EE**2/SW**2/cb**2*ccth*csth*scth*ssth
     &      *(1D0-sb**2+Mc**2/MW**2-Ms**2/MW**2-Mc**2/MW
     &      **2/sb**2)
      AAABR(6255) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      -5D0*scth**2/CW**2+4D0*ssth**2/CW**2+9D0*scth
     &      **2/SW**2+5D0*sb**2/CW**2*scth**2-4D0*sb**2/CW
     &      **2*ssth**2-5D0*scth**2/CW**2*ssth**2-9D0*sb
     &      **2/SW**2*scth**2-9D0*scth**2/SW**2*ssth**2+5D0
     &      *sb**2/CW**2*scth**2*ssth**2+9D0*sb**2/SW**2
     &      *scth**2*ssth**2)
      AAABR(6256) = EE**2/SW**2/cb**2*(scth**2-Mc**2/MW**2
     &      -sb**2*scth**2-scth**2*ssth**2+Mc**2/MW**2/sb
     &      **2+Mc**2/MW**2*scth**2+Mc**2/MW**2*ssth**2+sb
     &      **2*scth**2*ssth**2-Mc**2/MW**2/sb**2*scth**2
     &      -Mc**2/MW**2/sb**2*ssth**2-Mc**2/MW**2*scth**2
     &      *ssth**2+Ms**2/MW**2*scth**2*ssth**2+Mc**2/MW
     &      **2/sb**2*scth**2*ssth**2)
      AAABR(6257) = EE**2/CW**2/cb**2*ccth*scth*(1D0-sb**2
     &      +ssth**2-sb**2*ssth**2)
      AAABR(6258) = EE**2/CW**3*SW/cb**2*ccth*scth*(1D0-sb
     &      **2+ssth**2-sb**2*ssth**2)
      AAABR(6259) = EE**2/MW**2/SW**2/cb**2*ccth*scth*(Mc
     &      **2-Mc**2/sb**2-Mc**2*ssth**2+Ms**2*ssth**2+Mc
     &      **2/sb**2*ssth**2)
      AAABR(6260) = EE**2/MW**2/SW**2/cb**2*ccth*scth*(2D0
     &      *Mc**2-Mc**2/sb**2-Mc**2*sb**2-2D0*Mc**2*ssth
     &      **2+Mc**2/sb**2*ssth**2+Mc**2*sb**2*ssth**2-Ms
     &      **2*sb**2*ssth**2)
      AAABR(6261) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*scth
     &      *ssth**2
      AAABR(6262) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*scth
     &      *(1D0-1D0/sb**2-ssth**2+ssth**2/sb**2)
      AAABR(6263) = EE**2/SW**2/cb**2*(ccth*csth*sbth*stth
     &      -ccth*csth*sb**2*sbth*stth-Mb/MW**2*Ms*cbth*ccth
     &      *ssth*stth+Mc/MW**2*Mt*csth*ctth*sbth*scth-Mc
     &      /MW**2*Mt*csth*ctth/sb**2*sbth*scth)
      AAABR(6264) = EE**2/SW**2/cb**2*cbth*ccth*csth*stth
     &      *(1D0-sb**2)
      AAABR(6265) = EE**2/SW**2/cb**2*(cbth*ccth*ssth*stth
     &      -cbth*ccth*sb**2*ssth*stth-Mb/MW**2*Ms*ccth*csth
     &      *sbth*stth+Mc/MW**2*Mt*cbth*ctth*scth*ssth-Mc
     &      /MW**2*Mt*cbth*ctth/sb**2*scth*ssth)
      AAABR(6266) = EE**2/SW**2/cb**2*(cbth*csth*scth*stth
     &      -cbth*csth*sb**2*scth*stth+Mb/MW**2*Ms*sbth*scth
     &      *ssth*stth-Mc/MW**2*Mt*cbth*ccth*csth*ctth+Mc
     &      /MW**2*Mt*cbth*ccth*csth*ctth/sb**2)
      AAABR(6267) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*ccth*sbth
     &      *ssth*stth+Mc*Mt*cbth*csth*ctth*scth-Mc*Mt*cbth
     &      *csth*ctth/sb**2*scth)
      AAABR(6268) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *csth*ctth*scth-Mb*Ms*ccth*sb**2*sbth*ssth*stth
     &      -Mc*Mt*cbth*csth*ctth/sb**2*scth-Mc*Mt*cbth*csth
     &      *ctth*sb**2*scth)
      AAABR(6269) = EE**2/MW**2*Mb/SW**2/cb**2*ccth*sbth
     &      *ssth*stth
      AAABR(6270) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*sbth
     &      *ssth*stth
      AAABR(6271) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*csth
     &      *ctth*scth*(1D0-1D0/sb**2)
      AAABR(6272) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*csth
     &      *ctth*scth*(1D0-1D0/sb**2)
      AAABR(6273) = EE**2/SW**2/cb**2*(cdth*cuth*scth*ssth
     &      -cdth*cuth*sb**2*scth*ssth+Mc/MW**2*Mu*ccth*cdth
     &      *ssth*suth-Md/MW**2*Ms*csth*cuth*scth*sdth-Mc
     &      /MW**2*Mu*ccth*cdth/sb**2*ssth*suth)
      AAABR(6274) = EE**2/SW**2/cb**2*cdth*csth*cuth*scth
     &      *(1D0-sb**2)
      AAABR(6275) = EE**2/SW**2/cb**2*(csth*cuth*scth*sdth
     &      -csth*cuth*sb**2*scth*sdth+Mc/MW**2*Mu*ccth*csth
     &      *sdth*suth-Md/MW**2*Ms*cdth*cuth*scth*ssth-Mc
     &      /MW**2*Mu*ccth*csth/sb**2*sdth*suth)
      AAABR(6276) = EE**2/SW**2/cb**2*(cdth*csth*scth*suth
     &      -cdth*csth*sb**2*scth*suth-Mc/MW**2*Mu*ccth*cdth
     &      *csth*cuth+Md/MW**2*Ms*scth*sdth*ssth*suth+Mc
     &      /MW**2*Mu*ccth*cdth*csth*cuth/sb**2)
      AAABR(6277) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*cdth
     &      *csth*suth+Md*Ms*cuth*scth*sdth*ssth-Mc*Mu*ccth
     &      *cdth*csth/sb**2*suth)
      AAABR(6278) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *cdth*csth*suth-Mc*Mu*ccth*cdth*csth/sb**2*suth
     &      -Mc*Mu*ccth*cdth*csth*sb**2*suth-Md*Ms*cuth*sb
     &      **2*scth*sdth*ssth)
      AAABR(6279) = EE**2/MW**2*Ms/SW**2/cb**2*cuth*scth
     &      *sdth*ssth
      AAABR(6280) = EE**2/MW**2*Md/SW**2/cb**2*cuth*scth
     &      *sdth*ssth
      AAABR(6281) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*cdth
     &      *csth*suth*(1D0-1D0/sb**2)
      AAABR(6282) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*cdth
     &      *csth*suth*(1D0-1D0/sb**2)
      AAABR(6283) = EE**2/SW**2/cb**2*(cdth*cuth*sbth*stth
     &      -cdth*cuth*sb**2*sbth*stth-Mb/MW**2*Md*cbth*cuth
     &      *sdth*stth+Mt/MW**2*Mu*cdth*ctth*sbth*suth-Mt
     &      /MW**2*Mu*cdth*ctth/sb**2*sbth*suth)
      AAABR(6284) = EE**2/SW**2/cb**2*cbth*cdth*cuth*stth
     &      *(1D0-sb**2)
      AAABR(6285) = EE**2/SW**2/cb**2*(cbth*cuth*sdth*stth
     &      -cbth*cuth*sb**2*sdth*stth-Mb/MW**2*Md*cdth*cuth
     &      *sbth*stth+Mt/MW**2*Mu*cbth*ctth*sdth*suth-Mt
     &      /MW**2*Mu*cbth*ctth/sb**2*sdth*suth)
      AAABR(6286) = EE**2/SW**2/cb**2*(cbth*cdth*stth*suth
     &      -cbth*cdth*sb**2*stth*suth+Mb/MW**2*Md*sbth*sdth
     &      *stth*suth-Mt/MW**2*Mu*cbth*cdth*ctth*cuth+Mt
     &      /MW**2*Mu*cbth*cdth*ctth*cuth/sb**2)
      AAABR(6287) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cuth*sbth
     &      *sdth*stth+Mt*Mu*cbth*cdth*ctth*suth-Mt*Mu*cbth
     &      *cdth*ctth/sb**2*suth)
      AAABR(6288) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *cdth*ctth*suth-Mb*Md*cuth*sb**2*sbth*sdth*stth
     &      -Mt*Mu*cbth*cdth*ctth/sb**2*suth-Mt*Mu*cbth*cdth
     &      *ctth*sb**2*suth)
      AAABR(6289) = EE**2/MW**2*Mb/SW**2/cb**2*cuth*sbth
     &      *sdth*stth
      AAABR(6290) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sbth
     &      *sdth*stth
      AAABR(6291) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*cdth
     &      *ctth*suth*(1D0-1D0/sb**2)
      AAABR(6292) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*cdth
     &      *ctth*suth*(1D0-1D0/sb**2)
      AAABR(6293) = EE**2/SW**2/cb**2*(csth*ctth*sbth*scth
     &      -csth*ctth*sb**2*sbth*scth-Mb/MW**2*Ms*cbth*ctth
     &      *scth*ssth+Mc/MW**2*Mt*ccth*csth*sbth*stth-Mc
     &      /MW**2*Mt*ccth*csth/sb**2*sbth*stth)
      AAABR(6294) = EE**2/SW**2/cb**2*cbth*csth*ctth*scth
     &      *(1D0-sb**2)
      AAABR(6295) = EE**2/SW**2/cb**2*(cbth*ctth*scth*ssth
     &      -cbth*ctth*sb**2*scth*ssth-Mb/MW**2*Ms*csth*ctth
     &      *sbth*scth+Mc/MW**2*Mt*cbth*ccth*ssth*stth-Mc
     &      /MW**2*Mt*cbth*ccth/sb**2*ssth*stth)
      AAABR(6296) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*ctth*sbth
     &      *scth*ssth+Mc*Mt*cbth*ccth*csth*stth-Mc*Mt*cbth
     &      *ccth*csth/sb**2*stth)
      AAABR(6297) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *ccth*csth*stth-Mb*Ms*ctth*sb**2*sbth*scth*ssth
     &      -Mc*Mt*cbth*ccth*csth/sb**2*stth-Mc*Mt*cbth*ccth
     &      *csth*sb**2*stth)
      AAABR(6298) = EE**2/MW**2*Ms/SW**2/cb**2*ctth*sbth
     &      *scth*ssth
      AAABR(6299) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      *scth*ssth
      AAABR(6300) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ccth
     &      *csth*stth*(1D0-1D0/sb**2)
      AAABR(6301) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*ccth
     &      *csth*stth*(1D0-1D0/sb**2)
      AAABR(6302) = GG**2*cdth*ctth*sdth*stth
      AAABR(6303) = EE**2*(4D0/CW**2+4D0*sdth**2/CW**2-5D0
     &      *stth**2/CW**2+9D0*stth**2/SW**2-5D0*sdth**2
     &      /CW**2*stth**2-9D0*sdth**2/SW**2*stth**2)
      AAABR(6304) = EE**2/SW**2*ctth*stth*(1D0-sdth**2)
      AAABR(6305) = EE**2*cdth*ctth*sdth*stth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6306) = EE**2/CW**2*ctth*stth*(1D0+sdth**2)
      AAABR(6307) = EE**2/CW**3*SW*ctth*stth*(1D0+sdth**2)
      AAABR(6308) = GG**2*csth*cuth*ssth*suth
      AAABR(6309) = EE**2*csth*cuth*ssth*suth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6310) = EE**2/SW**2*cuth*suth*(1D0-ssth**2)
      AAABR(6311) = EE**2*(4D0/CW**2+4D0*ssth**2/CW**2-5D0
     &      *suth**2/CW**2+9D0*suth**2/SW**2-5D0*ssth**2
     &      /CW**2*suth**2-9D0*ssth**2/SW**2*suth**2)
      AAABR(6312) = EE**2/CW**2*cuth*suth*(1D0+ssth**2)
      AAABR(6313) = EE**2/CW**3*SW*cuth*suth*(1D0+ssth**2)
      AAABR(6314) = GG**2*csth*ctth*ssth*stth
      AAABR(6315) = EE**2*(4D0/CW**2+4D0*ssth**2/CW**2-5D0
     &      *stth**2/CW**2+9D0*stth**2/SW**2-5D0*ssth**2
     &      /CW**2*stth**2-9D0*ssth**2/SW**2*stth**2)
      AAABR(6316) = EE**2/SW**2*ctth*stth*(1D0-ssth**2)
      AAABR(6317) = EE**2*csth*ctth*ssth*stth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6318) = EE**2/CW**2*ctth*stth*(1D0+ssth**2)
      AAABR(6319) = EE**2/CW**3*SW*ctth*stth*(1D0+ssth**2)
      AAABR(6320) = EE**2/SW**2/cb**2*(ccth*cdth*ssth*suth
     &      -ccth*cdth*sb**2*ssth*suth+Mc/MW**2*Mu*cdth*cuth
     &      *scth*ssth-Md/MW**2*Ms*ccth*csth*sdth*suth-Mc
     &      /MW**2*Mu*cdth*cuth/sb**2*scth*ssth)
      AAABR(6321) = EE**2/SW**2/cb**2*ccth*cdth*csth*suth
     &      *(1D0-sb**2)
      AAABR(6322) = EE**2/SW**2/cb**2*(ccth*csth*sdth*suth
     &      -ccth*csth*sb**2*sdth*suth+Mc/MW**2*Mu*csth*cuth
     &      *scth*sdth-Md/MW**2*Ms*ccth*cdth*ssth*suth-Mc
     &      /MW**2*Mu*csth*cuth/sb**2*scth*sdth)
      AAABR(6323) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*cdth*csth
     &      *cuth*scth+Md*Ms*ccth*sdth*ssth*suth-Mc*Mu*cdth
     &      *csth*cuth/sb**2*scth)
      AAABR(6324) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*cdth
     &      *csth*cuth*scth-Mc*Mu*cdth*csth*cuth/sb**2*scth
     &      -Mc*Mu*cdth*csth*cuth*sb**2*scth-Md*Ms*ccth*sb
     &      **2*sdth*ssth*suth)
      AAABR(6325) = EE**2/MW**2*Md/SW**2/cb**2*ccth*sdth
     &      *ssth*suth
      AAABR(6326) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*sdth
     &      *ssth*suth
      AAABR(6327) = EE**2/MW**2*Mc/SW**2/cb**2*cdth*csth
     &      *cuth*scth*(1D0-1D0/sb**2)
      AAABR(6328) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*csth
     &      *cuth*scth*(1D0-1D0/sb**2)
      AAABR(6329) = GG**2*cbth*cuth*sbth*suth
      AAABR(6330) = EE**2*cbth*cuth*sbth*suth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6331) = EE**2/SW**2*cuth*suth*(1D0-sbth**2)
      AAABR(6332) = EE**2*(4D0/CW**2+4D0*sbth**2/CW**2-5D0
     &      *suth**2/CW**2+9D0*suth**2/SW**2-5D0*sbth**2
     &      /CW**2*suth**2-9D0*sbth**2/SW**2*suth**2)
      AAABR(6333) = EE**2/CW**2*cuth*suth*(1D0+sbth**2)
      AAABR(6334) = EE**2/CW**3*SW*cuth*suth*(1D0+sbth**2)
      AAABR(6335) = GG**2*cbth*ccth*sbth*scth
      AAABR(6336) = EE**2*cbth*ccth*sbth*scth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6337) = EE**2/SW**2*ccth*scth*(1D0-sbth**2)
      AAABR(6338) = EE**2*(4D0/CW**2+4D0*sbth**2/CW**2-5D0
     &      *scth**2/CW**2+9D0*scth**2/SW**2-5D0*sbth**2
     &      /CW**2*scth**2-9D0*sbth**2/SW**2*scth**2)
      AAABR(6339) = EE**2/CW**2*ccth*scth*(1D0+sbth**2)
      AAABR(6340) = EE**2/CW**3*SW*ccth*scth*(1D0+sbth**2)
      AAABR(6341) = GG**2*ccth*cdth*scth*sdth
      AAABR(6342) = EE**2*(4D0/CW**2-5D0*scth**2/CW**2+4D0
     &      *sdth**2/CW**2+9D0*scth**2/SW**2-5D0*scth**2
     &      /CW**2*sdth**2-9D0*scth**2/SW**2*sdth**2)
      AAABR(6343) = EE**2/SW**2*ccth*scth*(1D0-sdth**2)
      AAABR(6344) = EE**2*ccth*cdth*scth*sdth*(5D0/CW**2
     &      +9D0/SW**2)
      AAABR(6345) = EE**2/CW**2*ccth*scth*(1D0+sdth**2)
      AAABR(6346) = EE**2/CW**3*SW*ccth*scth*(1D0+sdth**2)
      AAABR(6347) = EE**2/SW**2/cb**2*(cdth*ctth*sbth*suth
     &      -cdth*ctth*sb**2*sbth*suth-Mb/MW**2*Md*cbth*ctth
     &      *sdth*suth+Mt/MW**2*Mu*cdth*cuth*sbth*stth-Mt
     &      /MW**2*Mu*cdth*cuth/sb**2*sbth*stth)
      AAABR(6348) = EE**2/SW**2/cb**2*cbth*cdth*ctth*suth
     &      *(1D0-sb**2)
      AAABR(6349) = EE**2/SW**2/cb**2*(cbth*ctth*sdth*suth
     &      -cbth*ctth*sb**2*sdth*suth-Mb/MW**2*Md*cdth*ctth
     &      *sbth*suth+Mt/MW**2*Mu*cbth*cuth*sdth*stth-Mt
     &      /MW**2*Mu*cbth*cuth/sb**2*sdth*stth)
      AAABR(6350) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*ctth*sbth
     &      *sdth*suth+Mt*Mu*cbth*cdth*cuth*stth-Mt*Mu*cbth
     &      *cdth*cuth/sb**2*stth)
      AAABR(6351) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *cdth*cuth*stth-Mb*Md*ctth*sb**2*sbth*sdth*suth
     &      -Mt*Mu*cbth*cdth*cuth/sb**2*stth-Mt*Mu*cbth*cdth
     &      *cuth*sb**2*stth)
      AAABR(6352) = EE**2/MW**2*Md/SW**2/cb**2*ctth*sbth
     &      *sdth*suth
      AAABR(6353) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      *sdth*suth
      AAABR(6354) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*cdth
     &      *cuth*stth*(1D0-1D0/sb**2)
      AAABR(6355) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*cdth
     &      *cuth*stth*(1D0-1D0/sb**2)
      AAABR(6356) = GG**2/cb**2*cbth*ctth*sbth*stth*(1D0
     &      -sb**2)
      AAABR(6357) = EE**2/cb**2*cbth*ctth*sbth*stth*(5D0
     &      /CW**2+9D0/SW**2-5D0*sb**2/CW**2-9D0*sb**2/SW
     &      **2)
      AAABR(6358) = EE**2/SW**2/cb**2*ctth*stth*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(6359) = EE**2/SW**2/cb**2*cbth*ctth*sbth*stth
     &      *(1D0-sb**2-Mb**2/MW**2+Mt**2/MW**2-Mt**2/MW
     &      **2/sb**2)
      AAABR(6360) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      +4D0*sbth**2/CW**2-5D0*stth**2/CW**2+9D0*stth
     &      **2/SW**2-4D0*sb**2/CW**2*sbth**2+5D0*sb**2/CW
     &      **2*stth**2-5D0*sbth**2/CW**2*stth**2-9D0*sb
     &      **2/SW**2*stth**2-9D0*sbth**2/SW**2*stth**2+5D0
     &      *sb**2/CW**2*sbth**2*stth**2+9D0*sb**2/SW**2
     &      *sbth**2*stth**2)
      AAABR(6361) = EE**2/SW**2/cb**2*(stth**2-Mt**2/MW**2
     &      -sb**2*stth**2-sbth**2*stth**2+Mt**2/MW**2/sb
     &      **2+Mt**2/MW**2*sbth**2+Mt**2/MW**2*stth**2+sb
     &      **2*sbth**2*stth**2+Mb**2/MW**2*sbth**2*stth
     &      **2-Mt**2/MW**2/sb**2*sbth**2-Mt**2/MW**2/sb
     &      **2*stth**2-Mt**2/MW**2*sbth**2*stth**2+Mt**2
     &      /MW**2/sb**2*sbth**2*stth**2)
      AAABR(6362) = EE**2/CW**2/cb**2*ctth*stth*(1D0-sb**2
     &      +sbth**2-sb**2*sbth**2)
      AAABR(6363) = EE**2/CW**3*SW/cb**2*ctth*stth*(1D0-sb
     &      **2+sbth**2-sb**2*sbth**2)
      AAABR(6364) = EE**2/MW**2/SW**2/cb**2*ctth*stth*(Mt
     &      **2+Mb**2*sbth**2-Mt**2/sb**2-Mt**2*sbth**2+Mt
     &      **2/sb**2*sbth**2)
      AAABR(6365) = EE**2/MW**2/SW**2/cb**2*ctth*stth*(2D0
     &      *Mt**2-Mt**2/sb**2-Mt**2*sb**2-2D0*Mt**2*sbth
     &      **2-Mb**2*sb**2*sbth**2+Mt**2/sb**2*sbth**2+Mt
     &      **2*sb**2*sbth**2)
      AAABR(6366) = EE**2/MW**2*Mb/SW**2/cb**2*ctth*sbth
     &      **2*stth
      AAABR(6367) = EE**2/MW**2*Mt/SW**2/cb**2*ctth*stth
     &      *(1D0-1D0/sb**2-sbth**2+sbth**2/sb**2)
      AAABR(6368) = GG**2/cb**2*cdth*cuth*sdth*suth*(1D0
     &      -sb**2)
      AAABR(6369) = EE**2/cb**2*cdth*cuth*sdth*suth*(5D0
     &      /CW**2+9D0/SW**2-5D0*sb**2/CW**2-9D0*sb**2/SW
     &      **2)
      AAABR(6370) = EE**2/SW**2/cb**2*cuth*suth*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(6371) = EE**2/SW**2/cb**2*cdth*cuth*sdth*suth
     &      *(1D0-sb**2-Md**2/MW**2+Mu**2/MW**2-Mu**2/MW
     &      **2/sb**2)
      AAABR(6372) = EE**2/cb**2*(4D0/CW**2-4D0*sb**2/CW**2
     &      +4D0*sdth**2/CW**2-5D0*suth**2/CW**2+9D0*suth
     &      **2/SW**2-4D0*sb**2/CW**2*sdth**2+5D0*sb**2/CW
     &      **2*suth**2-5D0*sdth**2/CW**2*suth**2-9D0*sb
     &      **2/SW**2*suth**2-9D0*sdth**2/SW**2*suth**2+5D0
     &      *sb**2/CW**2*sdth**2*suth**2+9D0*sb**2/SW**2
     &      *sdth**2*suth**2)
      AAABR(6373) = EE**2/SW**2/cb**2*(suth**2-Mu**2/MW**2
     &      -sb**2*suth**2-sdth**2*suth**2+Mu**2/MW**2/sb
     &      **2+Mu**2/MW**2*sdth**2+Mu**2/MW**2*suth**2+sb
     &      **2*sdth**2*suth**2+Md**2/MW**2*sdth**2*suth
     &      **2-Mu**2/MW**2/sb**2*sdth**2-Mu**2/MW**2/sb
     &      **2*suth**2-Mu**2/MW**2*sdth**2*suth**2+Mu**2
     &      /MW**2/sb**2*sdth**2*suth**2)
      AAABR(6374) = EE**2/CW**2/cb**2*cuth*suth*(1D0-sb**2
     &      +sdth**2-sb**2*sdth**2)
      AAABR(6375) = EE**2/CW**3*SW/cb**2*cuth*suth*(1D0-sb
     &      **2+sdth**2-sb**2*sdth**2)
      AAABR(6376) = EE**2/MW**2/SW**2/cb**2*cuth*suth*(Mu
     &      **2+Md**2*sdth**2-Mu**2/sb**2-Mu**2*sdth**2+Mu
     &      **2/sb**2*sdth**2)
      AAABR(6377) = EE**2/MW**2/SW**2/cb**2*cuth*suth*(2D0
     &      *Mu**2-Mu**2/sb**2-Mu**2*sb**2-2D0*Mu**2*sdth
     &      **2-Md**2*sb**2*sdth**2+Mu**2/sb**2*sdth**2+Mu
     &      **2*sb**2*sdth**2)
      AAABR(6378) = EE**2/MW**2*Md/SW**2/cb**2*cuth*sdth
     &      **2*suth
      AAABR(6379) = EE**2/MW**2*Mu/SW**2/cb**2*cuth*suth
     &      *(1D0-1D0/sb**2-sdth**2+sdth**2/sb**2)
      AAABR(6380) = EE**2*(2D0/CW**2-sbth**2/CW**2-10D0*suth
     &      **2/CW**2-9D0*sbth**2/SW**2+5D0*sbth**2/CW**2
     &      *suth**2+9D0*sbth**2/SW**2*suth**2)
      AAABR(6381) = EE**2/SW**2*cbth*sbth*(1D0-suth**2)
      AAABR(6382) = EE**2/CW**2*cbth*sbth*(1D0-5D0*suth**2)
      AAABR(6383) = EE**2/CW**3*SW*cbth*sbth*(1D0-5D0*suth
     &      **2)
      AAABR(6384) = EE**2/SW**2/cb**2*cdth*ctth*cuth*sbth
     &      *(1D0-sb**2)
      AAABR(6385) = EE**2/SW**2/cb**2*(ctth*cuth*sbth*sdth
     &      -ctth*cuth*sb**2*sbth*sdth+Mb/MW**2*Md*cbth*cdth
     &      *ctth*cuth-Mt/MW**2*Mu*sbth*sdth*stth*suth+Mt
     &      /MW**2*Mu/sb**2*sbth*sdth*stth*suth)
      AAABR(6386) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cbth*ctth
     &      *cuth*sdth+Mt*Mu*cdth*sbth*stth*suth-Mt*Mu*cdth
     &      /sb**2*sbth*stth*suth)
      AAABR(6387) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cdth
     &      *sbth*stth*suth-Mb*Md*cbth*ctth*cuth*sb**2*sdth
     &      -Mt*Mu*cdth/sb**2*sbth*stth*suth-Mt*Mu*cdth*sb
     &      **2*sbth*stth*suth)
      AAABR(6388) = EE**2/MW**2*Md/SW**2/cb**2*cbth*ctth
     &      *cuth*sdth
      AAABR(6389) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *cuth*sdth
      AAABR(6390) = EE**2/MW**2*Mt/SW**2/cb**2*cdth*sbth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6391) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*sbth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6392) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -10D0*scth**2/CW**2-ssth**2/CW**2-9D0*ssth**2
     &      /SW**2+10D0*sb**2/CW**2*scth**2+sb**2/CW**2*ssth
     &      **2+5D0*scth**2/CW**2*ssth**2+9D0*sb**2/SW**2
     &      *ssth**2+9D0*scth**2/SW**2*ssth**2-5D0*sb**2
     &      /CW**2*scth**2*ssth**2-9D0*sb**2/SW**2*scth**2
     &      *ssth**2)
      AAABR(6393) = EE**2/SW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -scth**2+sb**2*scth**2)
      AAABR(6394) = EE**2/SW**2/cb**2*(ssth**2+Ms**2/MW**2
     &      -sb**2*ssth**2-scth**2*ssth**2-Ms**2/MW**2*scth
     &      **2-Ms**2/MW**2*ssth**2+sb**2*scth**2*ssth**2
     &      -Mc**2/MW**2*scth**2*ssth**2+Ms**2/MW**2*scth
     &      **2*ssth**2+Mc**2/MW**2/sb**2*scth**2*ssth**2)
      AAABR(6395) = EE**2/CW**2/cb**2*csth*ssth*(1D0-sb**2
     &      -5D0*scth**2+5D0*sb**2*scth**2)
      AAABR(6396) = EE**2/CW**3*SW/cb**2*csth*ssth*(1D0-sb
     &      **2-5D0*scth**2+5D0*sb**2*scth**2)
      AAABR(6397) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(Ms
     &      **2+Mc**2*scth**2-Ms**2*scth**2-Mc**2/sb**2*scth
     &      **2)
      AAABR(6398) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(2D0
     &      *Mc**2*scth**2-Ms**2*sb**2-Mc**2/sb**2*scth**2
     &      -Mc**2*sb**2*scth**2+Ms**2*sb**2*scth**2)
      AAABR(6399) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ssth
     &      *(1D0-scth**2)
      AAABR(6400) = EE**2/MW**2*Mc/SW**2/cb**2*csth*scth
     &      **2*ssth*(1D0-1D0/sb**2)
      AAABR(6401) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sbth**2/CW**2-10D0*stth**2/CW**2-9D0*sbth**2
     &      /SW**2+sb**2/CW**2*sbth**2+10D0*sb**2/CW**2*stth
     &      **2+5D0*sbth**2/CW**2*stth**2+9D0*sb**2/SW**2
     &      *sbth**2+9D0*sbth**2/SW**2*stth**2-5D0*sb**2
     &      /CW**2*sbth**2*stth**2-9D0*sb**2/SW**2*sbth**2
     &      *stth**2)
      AAABR(6402) = EE**2/SW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -stth**2+sb**2*stth**2)
      AAABR(6403) = EE**2/SW**2/cb**2*(sbth**2+Mb**2/MW**2
     &      -sb**2*sbth**2-sbth**2*stth**2-Mb**2/MW**2*sbth
     &      **2-Mb**2/MW**2*stth**2+sb**2*sbth**2*stth**2
     &      +Mb**2/MW**2*sbth**2*stth**2-Mt**2/MW**2*sbth
     &      **2*stth**2+Mt**2/MW**2/sb**2*sbth**2*stth**2)
      AAABR(6404) = EE**2/CW**2/cb**2*cbth*sbth*(1D0-sb**2
     &      -5D0*stth**2+5D0*sb**2*stth**2)
      AAABR(6405) = EE**2/CW**3*SW/cb**2*cbth*sbth*(1D0-sb
     &      **2-5D0*stth**2+5D0*sb**2*stth**2)
      AAABR(6406) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(Mb
     &      **2-Mb**2*stth**2+Mt**2*stth**2-Mt**2/sb**2*stth
     &      **2)
      AAABR(6407) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(Mb
     &      **2*sb**2-2D0*Mt**2*stth**2-Mb**2*sb**2*stth
     &      **2+Mt**2/sb**2*stth**2+Mt**2*sb**2*stth**2)
      AAABR(6408) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *(1D0-stth**2)
      AAABR(6409) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*sbth
     &      *stth**2*(1D0-1D0/sb**2)
      AAABR(6410) = EE**2*(2D0/CW**2-ssth**2/CW**2-10D0*suth
     &      **2/CW**2-9D0*ssth**2/SW**2+5D0*ssth**2/CW**2
     &      *suth**2+9D0*ssth**2/SW**2*suth**2)
      AAABR(6411) = EE**2/SW**2*csth*ssth*(1D0-suth**2)
      AAABR(6412) = EE**2/CW**2*csth*ssth*(1D0-5D0*suth**2)
      AAABR(6413) = EE**2/CW**3*SW*csth*ssth*(1D0-5D0*suth
     &      **2)
      AAABR(6414) = EE**2/SW**2*cdth*sdth*(1D0-scth**2)
      AAABR(6415) = EE**2*(2D0/CW**2-10D0*scth**2/CW**2-sdth
     &      **2/CW**2-9D0*sdth**2/SW**2+5D0*scth**2/CW**2
     &      *sdth**2+9D0*scth**2/SW**2*sdth**2)
      AAABR(6416) = EE**2/CW**2*cdth*sdth*(1D0-5D0*scth**2)
      AAABR(6417) = EE**2/CW**3*SW*cdth*sdth*(1D0-5D0*scth
     &      **2)
      AAABR(6418) = EE**2/SW**2*cdth*sdth*(1D0-stth**2)
      AAABR(6419) = EE**2*(2D0/CW**2-sdth**2/CW**2-10D0*stth
     &      **2/CW**2-9D0*sdth**2/SW**2+5D0*sdth**2/CW**2
     &      *stth**2+9D0*sdth**2/SW**2*stth**2)
      AAABR(6420) = EE**2/CW**2*cdth*sdth*(1D0-5D0*stth**2)
      AAABR(6421) = EE**2/CW**3*SW*cdth*sdth*(1D0-5D0*stth
     &      **2)
      AAABR(6422) = EE**2/cb**2*(2D0/CW**2-2D0*sb**2/CW**2
     &      -sdth**2/CW**2-10D0*suth**2/CW**2-9D0*sdth**2
     &      /SW**2+sb**2/CW**2*sdth**2+10D0*sb**2/CW**2*suth
     &      **2+5D0*sdth**2/CW**2*suth**2+9D0*sb**2/SW**2
     &      *sdth**2+9D0*sdth**2/SW**2*suth**2-5D0*sb**2
     &      /CW**2*sdth**2*suth**2-9D0*sb**2/SW**2*sdth**2
     &      *suth**2)
      AAABR(6423) = EE**2/SW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -suth**2+sb**2*suth**2)
      AAABR(6424) = EE**2/SW**2/cb**2*(sdth**2+Md**2/MW**2
     &      -sb**2*sdth**2-sdth**2*suth**2-Md**2/MW**2*sdth
     &      **2-Md**2/MW**2*suth**2+sb**2*sdth**2*suth**2
     &      +Md**2/MW**2*sdth**2*suth**2-Mu**2/MW**2*sdth
     &      **2*suth**2+Mu**2/MW**2/sb**2*sdth**2*suth**2)
      AAABR(6425) = EE**2/CW**2/cb**2*cdth*sdth*(1D0-sb**2
     &      -5D0*suth**2+5D0*sb**2*suth**2)
      AAABR(6426) = EE**2/CW**3*SW/cb**2*cdth*sdth*(1D0-sb
     &      **2-5D0*suth**2+5D0*sb**2*suth**2)
      AAABR(6427) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(Md
     &      **2-Md**2*suth**2+Mu**2*suth**2-Mu**2/sb**2*suth
     &      **2)
      AAABR(6428) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(Md
     &      **2*sb**2-2D0*Mu**2*suth**2-Md**2*sb**2*suth
     &      **2+Mu**2/sb**2*suth**2+Mu**2*sb**2*suth**2)
      AAABR(6429) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *(1D0-suth**2)
      AAABR(6430) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*sdth
     &      *suth**2*(1D0-1D0/sb**2)
      AAABR(6431) = EE**2/SW**2/cb**2*(ccth*cuth*sdth*ssth
     &      -ccth*cuth*sb**2*sdth*ssth-Mc/MW**2*Mu*scth*sdth
     &      *ssth*suth+Md/MW**2*Ms*ccth*cdth*csth*cuth+Mc
     &      /MW**2*Mu/sb**2*scth*sdth*ssth*suth)
      AAABR(6432) = EE**2/SW**2/cb**2*ccth*csth*cuth*sdth
     &      *(1D0-sb**2)
      AAABR(6433) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*csth*scth
     &      *sdth*suth+Md*Ms*ccth*cdth*cuth*ssth-Mc*Mu*csth
     &      /sb**2*scth*sdth*suth)
      AAABR(6434) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*csth
     &      *scth*sdth*suth-Mc*Mu*csth/sb**2*scth*sdth*suth
     &      -Mc*Mu*csth*sb**2*scth*sdth*suth-Md*Ms*ccth*cdth
     &      *cuth*sb**2*ssth)
      AAABR(6435) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*cdth
     &      *cuth*ssth
      AAABR(6436) = EE**2/MW**2*Md/SW**2/cb**2*ccth*cdth
     &      *cuth*ssth
      AAABR(6437) = EE**2/MW**2*Mu/SW**2/cb**2*csth*scth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6438) = EE**2/MW**2*Mc/SW**2/cb**2*csth*scth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6439) = EE**2/SW**2/cb**2*ccth*csth*ctth*sbth
     &      *(1D0-sb**2)
      AAABR(6440) = EE**2/SW**2/cb**2*(ccth*ctth*sbth*ssth
     &      -ccth*ctth*sb**2*sbth*ssth+Mb/MW**2*Ms*cbth*ccth
     &      *csth*ctth-Mc/MW**2*Mt*sbth*scth*ssth*stth+Mc
     &      /MW**2*Mt/sb**2*sbth*scth*ssth*stth)
      AAABR(6441) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*cbth*ccth
     &      *ctth*ssth+Mc*Mt*csth*sbth*scth*stth-Mc*Mt*csth
     &      /sb**2*sbth*scth*stth)
      AAABR(6442) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*csth
     &      *sbth*scth*stth-Mb*Ms*cbth*ccth*ctth*sb**2*ssth
     &      -Mc*Mt*csth/sb**2*sbth*scth*stth-Mc*Mt*csth*sb
     &      **2*sbth*scth*stth)
      AAABR(6443) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*ccth
     &      *ctth*ssth
      AAABR(6444) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ccth
     &      *ctth*ssth
      AAABR(6445) = EE**2/MW**2*Mt/SW**2/cb**2*csth*sbth
     &      *scth*stth*(1D0-1D0/sb**2)
      AAABR(6446) = EE**2/MW**2*Mc/SW**2/cb**2*csth*sbth
     &      *scth*stth*(1D0-1D0/sb**2)
      AAABR(6447) = EE**2*(2D0/CW**2-sbth**2/CW**2-10D0*scth
     &      **2/CW**2-9D0*sbth**2/SW**2+5D0*sbth**2/CW**2
     &      *scth**2+9D0*sbth**2/SW**2*scth**2)
      AAABR(6448) = EE**2/SW**2*cbth*sbth*(1D0-scth**2)
      AAABR(6449) = EE**2/CW**2*cbth*sbth*(1D0-5D0*scth**2)
      AAABR(6450) = EE**2/CW**3*SW*cbth*sbth*(1D0-5D0*scth
     &      **2)
      AAABR(6451) = EE**2/SW**2/cb**2*ccth*cdth*cuth*ssth
     &      *(1D0-sb**2)
      AAABR(6452) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*cdth*scth
     &      *ssth*suth+Md*Ms*ccth*csth*cuth*sdth-Mc*Mu*cdth
     &      /sb**2*scth*ssth*suth)
      AAABR(6453) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*cdth
     &      *scth*ssth*suth-Mc*Mu*cdth/sb**2*scth*ssth*suth
     &      -Mc*Mu*cdth*sb**2*scth*ssth*suth-Md*Ms*ccth*csth
     &      *cuth*sb**2*sdth)
      AAABR(6454) = EE**2/MW**2*Md/SW**2/cb**2*ccth*csth
     &      *cuth*sdth
      AAABR(6455) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *cuth*sdth
      AAABR(6456) = EE**2/MW**2*Mc/SW**2/cb**2*cdth*scth
     &      *ssth*suth*(1D0-1D0/sb**2)
      AAABR(6457) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*scth
     &      *ssth*suth*(1D0-1D0/sb**2)
      AAABR(6458) = EE**2/SW**2/cb**2*cbth*ccth*ctth*ssth
     &      *(1D0-sb**2)
      AAABR(6459) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*ccth*csth
     &      *ctth*sbth+Mc*Mt*cbth*scth*ssth*stth-Mc*Mt*cbth
     &      /sb**2*scth*ssth*stth)
      AAABR(6460) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *scth*ssth*stth-Mb*Ms*ccth*csth*ctth*sb**2*sbth
     &      -Mc*Mt*cbth/sb**2*scth*ssth*stth-Mc*Mt*cbth*sb
     &      **2*scth*ssth*stth)
      AAABR(6461) = EE**2/MW**2*Mb/SW**2/cb**2*ccth*csth
     &      *ctth*sbth
      AAABR(6462) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *ctth*sbth
      AAABR(6463) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*scth
     &      *ssth*stth*(1D0-1D0/sb**2)
      AAABR(6464) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*scth
     &      *ssth*stth*(1D0-1D0/sb**2)
      AAABR(6465) = EE**2/SW**2*csth*ssth*(1D0-stth**2)
      AAABR(6466) = EE**2*(2D0/CW**2-ssth**2/CW**2-10D0*stth
     &      **2/CW**2-9D0*ssth**2/SW**2+5D0*ssth**2/CW**2
     &      *stth**2+9D0*ssth**2/SW**2*stth**2)
      AAABR(6467) = EE**2/CW**2*csth*ssth*(1D0-5D0*stth**2)
      AAABR(6468) = EE**2/CW**3*SW*csth*ssth*(1D0-5D0*stth
     &      **2)
      AAABR(6469) = EE**2/SW**2/cb**2*cbth*ctth*cuth*sdth
     &      *(1D0-sb**2)
      AAABR(6470) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cdth*ctth
     &      *cuth*sbth+Mt*Mu*cbth*sdth*stth*suth-Mt*Mu*cbth
     &      /sb**2*sdth*stth*suth)
      AAABR(6471) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *sdth*stth*suth-Mb*Md*cdth*ctth*cuth*sb**2*sbth
     &      -Mt*Mu*cbth/sb**2*sdth*stth*suth-Mt*Mu*cbth*sb
     &      **2*sdth*stth*suth)
      AAABR(6472) = EE**2/MW**2*Mb/SW**2/cb**2*cdth*ctth
     &      *cuth*sbth
      AAABR(6473) = EE**2/MW**2*Md/SW**2/cb**2*cdth*ctth
     &      *cuth*sbth
      AAABR(6474) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*sdth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6475) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*sdth
     &      *stth*suth*(1D0-1D0/sb**2)
      AAABR(6476) = EE**2/cb**2*ccth*scth*(10D0/CW**2-10D0
     &      *sb**2/CW**2-5D0*ssth**2/CW**2-9D0*ssth**2/SW
     &      **2+5D0*sb**2/CW**2*ssth**2+9D0*sb**2/SW**2*ssth
     &      **2)
      AAABR(6477) = EE**2/SW**2/cb**2*ccth*csth*scth*ssth
     &      *(1D0-sb**2)
      AAABR(6478) = EE**2/SW**2/cb**2*ccth*scth*(ssth**2
     &      +Ms**2/MW**2-sb**2*ssth**2+Mc**2/MW**2*ssth**2
     &      -Ms**2/MW**2*ssth**2-Mc**2/MW**2/sb**2*ssth**2)
      AAABR(6479) = EE**2/cb**2*csth*ssth*(4D0/CW**2-4D0
     &      *sb**2/CW**2-5D0*scth**2/CW**2-9D0*scth**2/SW
     &      **2+5D0*sb**2/CW**2*scth**2+9D0*sb**2/SW**2*scth
     &      **2)
      AAABR(6480) = EE**2/SW**2/cb**2*csth*ssth*(scth**2
     &      -Mc**2/MW**2-sb**2*scth**2+Mc**2/MW**2/sb**2
     &      +Mc**2/MW**2*scth**2-Ms**2/MW**2*scth**2-Mc**2
     &      /MW**2/sb**2*scth**2)
      AAABR(6481) = EE**2/CW**2/cb**2*ccth*csth*scth*ssth
     &      *(1D0-sb**2)
      AAABR(6482) = EE**2/CW**3*SW/cb**2*ccth*csth*scth*ssth
     &      *(1D0-sb**2)
      AAABR(6483) = EE**2/MW**2/SW**2/cb**2*ccth*csth*scth
     &      *ssth*(Mc**2-Ms**2-Mc**2/sb**2)
      AAABR(6484) = EE**2/MW**2/SW**2/cb**2*ccth*csth*scth
     &      *ssth*(2D0*Mc**2-Mc**2/sb**2-Mc**2*sb**2+Ms**2
     &      *sb**2)
      AAABR(6485) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *scth*ssth
      AAABR(6486) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*csth
     &      *scth*ssth*(1D0-1D0/sb**2)
      AAABR(6487) = EE**2/SW**2/cb**2*(ccth*sbth*ssth*stth
     &      -ccth*sb**2*sbth*ssth*stth+Mb/MW**2*Ms*cbth*ccth
     &      *csth*stth+Mc/MW**2*Mt*ctth*sbth*scth*ssth-Mc
     &      /MW**2*Mt*ctth/sb**2*sbth*scth*ssth)
      AAABR(6488) = EE**2/SW**2/cb**2*cbth*ccth*ssth*stth
     &      *(1D0-sb**2)
      AAABR(6489) = EE**2/SW**2/cb**2*(cbth*scth*ssth*stth
     &      -cbth*sb**2*scth*ssth*stth-Mb/MW**2*Ms*csth*sbth
     &      *scth*stth-Mc/MW**2*Mt*cbth*ccth*ctth*ssth+Mc
     &      /MW**2*Mt*cbth*ccth*ctth/sb**2*ssth)
      AAABR(6490) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*ccth*csth
     &      *sbth*stth-Mc*Mt*cbth*ctth*scth*ssth+Mc*Mt*cbth
     &      *ctth/sb**2*scth*ssth)
      AAABR(6491) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *ctth*scth*ssth+Mb*Ms*ccth*csth*sb**2*sbth*stth
     &      -Mc*Mt*cbth*ctth/sb**2*scth*ssth-Mc*Mt*cbth*ctth
     &      *sb**2*scth*ssth)
      AAABR(6492) = EE**2/MW**2*Mb/SW**2/cb**2*ccth*csth
     &      *sbth*stth
      AAABR(6493) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *sbth*stth
      AAABR(6494) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*ctth
     &      *scth*ssth*(1D0-1D0/sb**2)
      AAABR(6495) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ctth
     &      *scth*ssth*(1D0-1D0/sb**2)
      AAABR(6496) = EE**2/SW**2/cb**2*(cdth*scth*ssth*suth
     &      -cdth*sb**2*scth*ssth*suth-Mc/MW**2*Mu*ccth*cdth
     &      *cuth*ssth-Md/MW**2*Ms*csth*scth*sdth*suth+Mc
     &      /MW**2*Mu*ccth*cdth*cuth/sb**2*ssth)
      AAABR(6497) = EE**2/SW**2/cb**2*ccth*cdth*ssth*suth
     &      *(1D0-sb**2)
      AAABR(6498) = EE**2/SW**2/cb**2*(ccth*sdth*ssth*suth
     &      -ccth*sb**2*sdth*ssth*suth+Mc/MW**2*Mu*cuth*scth
     &      *sdth*ssth+Md/MW**2*Ms*ccth*cdth*csth*suth-Mc
     &      /MW**2*Mu*cuth/sb**2*scth*sdth*ssth)
      AAABR(6499) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*cdth*cuth
     &      *scth*ssth-Md*Ms*ccth*csth*sdth*suth-Mc*Mu*cdth
     &      *cuth/sb**2*scth*ssth)
      AAABR(6500) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*cdth
     &      *cuth*scth*ssth-Mc*Mu*cdth*cuth/sb**2*scth*ssth
     &      -Mc*Mu*cdth*cuth*sb**2*scth*ssth+Md*Ms*ccth*csth
     &      *sb**2*sdth*suth)
      AAABR(6501) = EE**2/MW**2*Md/SW**2/cb**2*ccth*csth
     &      *sdth*suth
      AAABR(6502) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*csth
     &      *sdth*suth
      AAABR(6503) = EE**2/MW**2*Mc/SW**2/cb**2*cdth*cuth
     &      *scth*ssth*(1D0-1D0/sb**2)
      AAABR(6504) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*cuth
     &      *scth*ssth*(1D0-1D0/sb**2)
      AAABR(6505) = EE**2*csth*ssth*(4D0/CW**2-5D0*stth**2
     &      /CW**2-9D0*stth**2/SW**2)
      AAABR(6506) = EE**2/SW**2*csth*ctth*ssth*stth
      AAABR(6507) = EE**2*ctth*stth*(10D0/CW**2-5D0*ssth
     &      **2/CW**2-9D0*ssth**2/SW**2)
      AAABR(6508) = EE**2/CW**2*csth*ctth*ssth*stth
      AAABR(6509) = EE**2/CW**3*SW*csth*ctth*ssth*stth
      AAABR(6510) = EE**2*cdth*sdth*(4D0/CW**2-5D0*stth**2
     &      /CW**2-9D0*stth**2/SW**2)
      AAABR(6511) = EE**2/SW**2*cdth*ctth*sdth*stth
      AAABR(6512) = EE**2*ctth*stth*(10D0/CW**2-5D0*sdth
     &      **2/CW**2-9D0*sdth**2/SW**2)
      AAABR(6513) = EE**2/CW**2*cdth*ctth*sdth*stth
      AAABR(6514) = EE**2/CW**3*SW*cdth*ctth*sdth*stth
      AAABR(6515) = EE**2/SW**2/cb**2*(csth*sbth*scth*stth
     &      -csth*sb**2*sbth*scth*stth-Mb/MW**2*Ms*cbth*scth
     &      *ssth*stth-Mc/MW**2*Mt*ccth*csth*ctth*sbth+Mc
     &      /MW**2*Mt*ccth*csth*ctth/sb**2*sbth)
      AAABR(6516) = EE**2/SW**2/cb**2*csth*ctth*sbth*scth
     &      *(1D0-sb**2)
      AAABR(6517) = EE**2/SW**2/cb**2*(ctth*sbth*scth*ssth
     &      -ctth*sb**2*sbth*scth*ssth+Mb/MW**2*Ms*cbth*csth
     &      *ctth*scth+Mc/MW**2*Mt*ccth*sbth*ssth*stth-Mc
     &      /MW**2*Mt*ccth/sb**2*sbth*ssth*stth)
      AAABR(6518) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*cbth*ctth
     &      *scth*ssth-Mc*Mt*ccth*csth*sbth*stth+Mc*Mt*ccth
     &      *csth/sb**2*sbth*stth)
      AAABR(6519) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*ccth
     &      *csth*sbth*stth+Mb*Ms*cbth*ctth*sb**2*scth*ssth
     &      -Mc*Mt*ccth*csth/sb**2*sbth*stth-Mc*Mt*ccth*csth
     &      *sb**2*sbth*stth)
      AAABR(6520) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*ctth
     &      *scth*ssth
      AAABR(6521) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *scth*ssth
      AAABR(6522) = EE**2/MW**2*Mt/SW**2/cb**2*ccth*csth
     &      *sbth*stth*(1D0-1D0/sb**2)
      AAABR(6523) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*csth
     &      *sbth*stth*(1D0-1D0/sb**2)
      AAABR(6524) = EE**2/cb**2*cuth*suth*(10D0/CW**2-10D0
     &      *sb**2/CW**2-5D0*sdth**2/CW**2-9D0*sdth**2/SW
     &      **2+5D0*sb**2/CW**2*sdth**2+9D0*sb**2/SW**2*sdth
     &      **2)
      AAABR(6525) = EE**2/SW**2/cb**2*cdth*cuth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6526) = EE**2/SW**2/cb**2*cuth*suth*(sdth**2
     &      +Md**2/MW**2-sb**2*sdth**2-Md**2/MW**2*sdth**2
     &      +Mu**2/MW**2*sdth**2-Mu**2/MW**2/sb**2*sdth**2)
      AAABR(6527) = EE**2/cb**2*cdth*sdth*(4D0/CW**2-4D0
     &      *sb**2/CW**2-5D0*suth**2/CW**2-9D0*suth**2/SW
     &      **2+5D0*sb**2/CW**2*suth**2+9D0*sb**2/SW**2*suth
     &      **2)
      AAABR(6528) = EE**2/SW**2/cb**2*cdth*sdth*(suth**2
     &      -Mu**2/MW**2-sb**2*suth**2-Md**2/MW**2*suth**2
     &      +Mu**2/MW**2/sb**2+Mu**2/MW**2*suth**2-Mu**2
     &      /MW**2/sb**2*suth**2)
      AAABR(6529) = EE**2/CW**2/cb**2*cdth*cuth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6530) = EE**2/CW**3*SW/cb**2*cdth*cuth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6531) = EE**2/MW**2/SW**2/cb**2*cdth*cuth*sdth
     &      *suth*(Md**2-Mu**2+Mu**2/sb**2)
      AAABR(6532) = EE**2/MW**2/SW**2/cb**2*cdth*cuth*sdth
     &      *suth*(2D0*Mu**2+Md**2*sb**2-Mu**2/sb**2-Mu**2
     &      *sb**2)
      AAABR(6533) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *sdth*suth
      AAABR(6534) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*cuth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6535) = EE**2/SW**2/cb**2*(cdth*sbth*stth*suth
     &      -cdth*sb**2*sbth*stth*suth-Mb/MW**2*Md*cbth*sdth
     &      *stth*suth-Mt/MW**2*Mu*cdth*ctth*cuth*sbth+Mt
     &      /MW**2*Mu*cdth*ctth*cuth/sb**2*sbth)
      AAABR(6536) = EE**2/SW**2/cb**2*cdth*ctth*sbth*suth
     &      *(1D0-sb**2)
      AAABR(6537) = EE**2/SW**2/cb**2*(ctth*sbth*sdth*suth
     &      -ctth*sb**2*sbth*sdth*suth+Mb/MW**2*Md*cbth*cdth
     &      *ctth*suth+Mt/MW**2*Mu*cuth*sbth*sdth*stth-Mt
     &      /MW**2*Mu*cuth/sb**2*sbth*sdth*stth)
      AAABR(6538) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cbth*ctth
     &      *sdth*suth-Mt*Mu*cdth*cuth*sbth*stth+Mt*Mu*cdth
     &      *cuth/sb**2*sbth*stth)
      AAABR(6539) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cdth
     &      *cuth*sbth*stth+Mb*Md*cbth*ctth*sb**2*sdth*suth
     &      -Mt*Mu*cdth*cuth/sb**2*sbth*stth-Mt*Mu*cdth*cuth
     &      *sb**2*sbth*stth)
      AAABR(6540) = EE**2/MW**2*Md/SW**2/cb**2*cbth*ctth
     &      *sdth*suth
      AAABR(6541) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *sdth*suth
      AAABR(6542) = EE**2/MW**2*Mt/SW**2/cb**2*cdth*cuth
     &      *sbth*stth*(1D0-1D0/sb**2)
      AAABR(6543) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*cuth
     &      *sbth*stth*(1D0-1D0/sb**2)
      AAABR(6544) = EE**2/cb**2*ctth*stth*(10D0/CW**2-10D0
     &      *sb**2/CW**2-5D0*sbth**2/CW**2-9D0*sbth**2/SW
     &      **2+5D0*sb**2/CW**2*sbth**2+9D0*sb**2/SW**2*sbth
     &      **2)
      AAABR(6545) = EE**2/SW**2/cb**2*cbth*ctth*sbth*stth
     &      *(1D0-sb**2)
      AAABR(6546) = EE**2/SW**2/cb**2*ctth*stth*(sbth**2
     &      +Mb**2/MW**2-sb**2*sbth**2-Mb**2/MW**2*sbth**2
     &      +Mt**2/MW**2*sbth**2-Mt**2/MW**2/sb**2*sbth**2)
      AAABR(6547) = EE**2/cb**2*cbth*sbth*(4D0/CW**2-4D0
     &      *sb**2/CW**2-5D0*stth**2/CW**2-9D0*stth**2/SW
     &      **2+5D0*sb**2/CW**2*stth**2+9D0*sb**2/SW**2*stth
     &      **2)
      AAABR(6548) = EE**2/SW**2/cb**2*cbth*sbth*(stth**2
     &      -Mt**2/MW**2-sb**2*stth**2-Mb**2/MW**2*stth**2
     &      +Mt**2/MW**2/sb**2+Mt**2/MW**2*stth**2-Mt**2
     &      /MW**2/sb**2*stth**2)
      AAABR(6549) = EE**2/CW**2/cb**2*cbth*ctth*sbth*stth
     &      *(1D0-sb**2)
      AAABR(6550) = EE**2/CW**3*SW/cb**2*cbth*ctth*sbth*stth
     &      *(1D0-sb**2)
      AAABR(6551) = EE**2/MW**2/SW**2/cb**2*cbth*ctth*sbth
     &      *stth*(Mb**2-Mt**2+Mt**2/sb**2)
      AAABR(6552) = EE**2/MW**2/SW**2/cb**2*cbth*ctth*sbth
     &      *stth*(2D0*Mt**2+Mb**2*sb**2-Mt**2/sb**2-Mt**2
     &      *sb**2)
      AAABR(6553) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ctth
     &      *sbth*stth
      AAABR(6554) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ctth
     &      *sbth*stth*(1D0-1D0/sb**2)
      AAABR(6555) = EE**2*cuth*suth*(10D0/CW**2-5D0*sbth
     &      **2/CW**2-9D0*sbth**2/SW**2)
      AAABR(6556) = EE**2/SW**2*cbth*cuth*sbth*suth
      AAABR(6557) = EE**2*cbth*sbth*(4D0/CW**2-5D0*suth**2
     &      /CW**2-9D0*suth**2/SW**2)
      AAABR(6558) = EE**2/CW**2*cbth*cuth*sbth*suth
      AAABR(6559) = EE**2/CW**3*SW*cbth*cuth*sbth*suth
      AAABR(6560) = EE**2*cdth*sdth*(4D0/CW**2-5D0*scth**2
     &      /CW**2-9D0*scth**2/SW**2)
      AAABR(6561) = EE**2/SW**2*ccth*cdth*scth*sdth
      AAABR(6562) = EE**2*ccth*scth*(10D0/CW**2-5D0*sdth
     &      **2/CW**2-9D0*sdth**2/SW**2)
      AAABR(6563) = EE**2/CW**2*ccth*cdth*scth*sdth
      AAABR(6564) = EE**2/CW**3*SW*ccth*cdth*scth*sdth
      AAABR(6565) = EE**2*cuth*suth*(10D0/CW**2-5D0*ssth
     &      **2/CW**2-9D0*ssth**2/SW**2)
      AAABR(6566) = EE**2/SW**2*csth*cuth*ssth*suth
      AAABR(6567) = EE**2*csth*ssth*(4D0/CW**2-5D0*suth**2
     &      /CW**2-9D0*suth**2/SW**2)
      AAABR(6568) = EE**2/CW**2*csth*cuth*ssth*suth
      AAABR(6569) = EE**2/CW**3*SW*csth*cuth*ssth*suth
      AAABR(6570) = EE**2*ccth*scth*(10D0/CW**2-5D0*sbth
     &      **2/CW**2-9D0*sbth**2/SW**2)
      AAABR(6571) = EE**2/SW**2*cbth*ccth*sbth*scth
      AAABR(6572) = EE**2*cbth*sbth*(4D0/CW**2-5D0*scth**2
     &      /CW**2-9D0*scth**2/SW**2)
      AAABR(6573) = EE**2/CW**2*cbth*ccth*sbth*scth
      AAABR(6574) = EE**2/CW**3*SW*cbth*ccth*sbth*scth
      AAABR(6575) = EE**2/SW**2/cb**2*(cuth*scth*sdth*ssth
     &      -cuth*sb**2*scth*sdth*ssth+Mc/MW**2*Mu*ccth*sdth
     &      *ssth*suth+Md/MW**2*Ms*cdth*csth*cuth*scth-Mc
     &      /MW**2*Mu*ccth/sb**2*sdth*ssth*suth)
      AAABR(6576) = EE**2/SW**2/cb**2*csth*cuth*scth*sdth
     &      *(1D0-sb**2)
      AAABR(6577) = EE**2/SW**2/cb**2*(csth*scth*sdth*suth
     &      -csth*sb**2*scth*sdth*suth-Mc/MW**2*Mu*ccth*csth
     &      *cuth*sdth-Md/MW**2*Ms*cdth*scth*ssth*suth+Mc
     &      /MW**2*Mu*ccth*csth*cuth/sb**2*sdth)
      AAABR(6578) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*csth
     &      *sdth*suth-Md*Ms*cdth*cuth*scth*ssth-Mc*Mu*ccth
     &      *csth/sb**2*sdth*suth)
      AAABR(6579) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *csth*sdth*suth-Mc*Mu*ccth*csth/sb**2*sdth*suth
     &      -Mc*Mu*ccth*csth*sb**2*sdth*suth+Md*Ms*cdth*cuth
     &      *sb**2*scth*ssth)
      AAABR(6580) = EE**2/MW**2*Ms/SW**2/cb**2*cdth*cuth
     &      *scth*ssth
      AAABR(6581) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *scth*ssth
      AAABR(6582) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*csth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6583) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*csth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6584) = EE**2/SW**2/cb**2*(cuth*sbth*sdth*stth
     &      -cuth*sb**2*sbth*sdth*stth+Mb/MW**2*Md*cbth*cdth
     &      *cuth*stth+Mt/MW**2*Mu*ctth*sbth*sdth*suth-Mt
     &      /MW**2*Mu*ctth/sb**2*sbth*sdth*suth)
      AAABR(6585) = EE**2/SW**2/cb**2*cbth*cuth*sdth*stth
     &      *(1D0-sb**2)
      AAABR(6586) = EE**2/SW**2/cb**2*(cbth*sdth*stth*suth
     &      -cbth*sb**2*sdth*stth*suth-Mb/MW**2*Md*cdth*sbth
     &      *stth*suth-Mt/MW**2*Mu*cbth*ctth*cuth*sdth+Mt
     &      /MW**2*Mu*cbth*ctth*cuth/sb**2*sdth)
      AAABR(6587) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cdth*cuth
     &      *sbth*stth-Mt*Mu*cbth*ctth*sdth*suth+Mt*Mu*cbth
     &      *ctth/sb**2*sdth*suth)
      AAABR(6588) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *ctth*sdth*suth+Mb*Md*cdth*cuth*sb**2*sbth*stth
     &      -Mt*Mu*cbth*ctth/sb**2*sdth*suth-Mt*Mu*cbth*ctth
     &      *sb**2*sdth*suth)
      AAABR(6589) = EE**2/MW**2*Mb/SW**2/cb**2*cdth*cuth
     &      *sbth*stth
      AAABR(6590) = EE**2/MW**2*Md/SW**2/cb**2*cdth*cuth
     &      *sbth*stth
      AAABR(6591) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*ctth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6592) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ctth
     &      *sdth*suth*(1D0-1D0/sb**2)
      AAABR(6593) = EE**2/SW**2/cb**2*cbth*cdth*stth*suth
     &      *(1D0-sb**2)
      AAABR(6594) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*sbth*sdth
     &      *stth*suth-Mt*Mu*cbth*cdth*ctth*cuth+Mt*Mu*cbth
     &      *cdth*ctth*cuth/sb**2)
      AAABR(6595) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *cdth*ctth*cuth+Mb*Md*sb**2*sbth*sdth*stth*suth
     &      -Mt*Mu*cbth*cdth*ctth*cuth/sb**2-Mt*Mu*cbth*cdth
     &      *ctth*cuth*sb**2)
      AAABR(6596) = EE**2/MW**2*Md/SW**2/cb**2*sbth*sdth
     &      *stth*suth
      AAABR(6597) = EE**2/MW**2*Mb/SW**2/cb**2*sbth*sdth
     &      *stth*suth
      AAABR(6598) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*cdth
     &      *ctth*cuth*(1D0-1D0/sb**2)
      AAABR(6599) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*cdth
     &      *ctth*cuth*(1D0-1D0/sb**2)
      AAABR(6600) = EE**2/SW**2/cb**2*suth**2*(1D0-sb**2
     &      -sdth**2+sb**2*sdth**2)
      AAABR(6601) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2+4D0
     &      *sdth**2-5D0*suth**2-4D0*sb**2*sdth**2+5D0*sb
     &      **2*suth**2-5D0*sdth**2*suth**2+5D0*sb**2*sdth
     &      **2*suth**2)
      AAABR(6602) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2+4D0
     &      *sdth**2-5D0*suth**2-4D0*sb**2*sdth**2+5D0*sb
     &      **2*suth**2-5D0*sdth**2*suth**2+5D0*sb**2*sdth
     &      **2*suth**2)
      AAABR(6603) = EE**2/MW**2/SW**2/cb**2*(Mu**2-Mu**2
     &      /sb**2-Mu**2*sdth**2-Mu**2*suth**2-Md**2*sdth
     &      **2*suth**2+Mu**2/sb**2*sdth**2+Mu**2/sb**2*suth
     &      **2+Mu**2*sdth**2*suth**2-Mu**2/sb**2*sdth**2
     &      *suth**2)
      AAABR(6604) = EE**2/MW**2/SW**2/cb**2*(2D0*Mu**2-Mu
     &      **2/sb**2-Mu**2*sb**2-2D0*Mu**2*sdth**2-2D0*Mu
     &      **2*suth**2+Mu**2/sb**2*sdth**2+Mu**2/sb**2*suth
     &      **2+Mu**2*sb**2*sdth**2+Mu**2*sb**2*suth**2+2D0
     &      *Mu**2*sdth**2*suth**2+Md**2*sb**2*sdth**2*suth
     &      **2-Mu**2/sb**2*sdth**2*suth**2-Mu**2*sb**2*sdth
     &      **2*suth**2)
      AAABR(6605) = EE**2/MW**2*Md/SW**2/cb**2*sdth**2*suth
     &      **2
      AAABR(6606) = EE**2/MW**2*Mu/SW**2/cb**2*(1D0-1D0/sb
     &      **2-sdth**2-suth**2+sdth**2/sb**2+suth**2/sb
     &      **2+sdth**2*suth**2-sdth**2/sb**2*suth**2)
      AAABR(6607) = EE**2/SW**2/cb**2*cbth*csth*scth*stth
     &      *(1D0-sb**2)
      AAABR(6608) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*sbth*scth
     &      *ssth*stth-Mc*Mt*cbth*ccth*csth*ctth+Mc*Mt*cbth
     &      *ccth*csth*ctth/sb**2)
      AAABR(6609) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *ccth*csth*ctth+Mb*Ms*sb**2*sbth*scth*ssth*stth
     &      -Mc*Mt*cbth*ccth*csth*ctth/sb**2-Mc*Mt*cbth*ccth
     &      *csth*ctth*sb**2)
      AAABR(6610) = EE**2/MW**2*Ms/SW**2/cb**2*sbth*scth
     &      *ssth*stth
      AAABR(6611) = EE**2/MW**2*Mb/SW**2/cb**2*sbth*scth
     &      *ssth*stth
      AAABR(6612) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ccth
     &      *csth*ctth*(1D0-1D0/sb**2)
      AAABR(6613) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*ccth
     &      *csth*ctth*(1D0-1D0/sb**2)
      AAABR(6614) = EE**2/SW**2*scth**2*(1D0-sdth**2)
      AAABR(6615) = EE**2/CW**2*(4D0-5D0*scth**2+4D0*sdth
     &      **2-5D0*scth**2*sdth**2)
      AAABR(6616) = EE**2/CW**3*SW*(4D0-5D0*scth**2+4D0*sdth
     &      **2-5D0*scth**2*sdth**2)
      AAABR(6617) = EE**2/SW**2*stth**2*(1D0-ssth**2)
      AAABR(6618) = EE**2/CW**2*(4D0+4D0*ssth**2-5D0*stth
     &      **2-5D0*ssth**2*stth**2)
      AAABR(6619) = EE**2/CW**3*SW*(4D0+4D0*ssth**2-5D0*stth
     &      **2-5D0*ssth**2*stth**2)
      AAABR(6620) = EE**2/SW**2*stth**2*(1D0-sdth**2)
      AAABR(6621) = EE**2/CW**2*(4D0+4D0*sdth**2-5D0*stth
     &      **2-5D0*sdth**2*stth**2)
      AAABR(6622) = EE**2/CW**3*SW*(4D0+4D0*sdth**2-5D0*stth
     &      **2-5D0*sdth**2*stth**2)
      AAABR(6623) = EE**2/SW**2*suth**2*(1D0-ssth**2)
      AAABR(6624) = EE**2/CW**2*(4D0+4D0*ssth**2-5D0*suth
     &      **2-5D0*ssth**2*suth**2)
      AAABR(6625) = EE**2/CW**3*SW*(4D0+4D0*ssth**2-5D0*suth
     &      **2-5D0*ssth**2*suth**2)
      AAABR(6626) = EE**2/SW**2*suth**2*(1D0-sbth**2)
      AAABR(6627) = EE**2/CW**2*(4D0+4D0*sbth**2-5D0*suth
     &      **2-5D0*sbth**2*suth**2)
      AAABR(6628) = EE**2/CW**3*SW*(4D0+4D0*sbth**2-5D0*suth
     &      **2-5D0*sbth**2*suth**2)
      AAABR(6629) = EE**2/SW**2/cb**2*cdth*csth*scth*suth
     &      *(1D0-sb**2)
      AAABR(6630) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*cdth
     &      *csth*cuth-Md*Ms*scth*sdth*ssth*suth-Mc*Mu*ccth
     &      *cdth*csth*cuth/sb**2)
      AAABR(6631) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *cdth*csth*cuth-Mc*Mu*ccth*cdth*csth*cuth/sb
     &      **2-Mc*Mu*ccth*cdth*csth*cuth*sb**2+Md*Ms*sb
     &      **2*scth*sdth*ssth*suth)
      AAABR(6632) = EE**2/MW**2*Md/SW**2/cb**2*scth*sdth
     &      *ssth*suth
      AAABR(6633) = EE**2/MW**2*Ms/SW**2/cb**2*scth*sdth
     &      *ssth*suth
      AAABR(6634) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*cdth
     &      *csth*cuth*(1D0-1D0/sb**2)
      AAABR(6635) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*cdth
     &      *csth*cuth*(1D0-1D0/sb**2)
      AAABR(6636) = EE**2/SW**2/cb**2*scth**2*(1D0-sb**2
     &      -ssth**2+sb**2*ssth**2)
      AAABR(6637) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2-5D0
     &      *scth**2+4D0*ssth**2+5D0*sb**2*scth**2-4D0*sb
     &      **2*ssth**2-5D0*scth**2*ssth**2+5D0*sb**2*scth
     &      **2*ssth**2)
      AAABR(6638) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2-5D0
     &      *scth**2+4D0*ssth**2+5D0*sb**2*scth**2-4D0*sb
     &      **2*ssth**2-5D0*scth**2*ssth**2+5D0*sb**2*scth
     &      **2*ssth**2)
      AAABR(6639) = EE**2/MW**2/SW**2/cb**2*(Mc**2-Mc**2
     &      /sb**2-Mc**2*scth**2-Mc**2*ssth**2+Mc**2/sb**2
     &      *scth**2+Mc**2/sb**2*ssth**2+Mc**2*scth**2*ssth
     &      **2-Ms**2*scth**2*ssth**2-Mc**2/sb**2*scth**2
     &      *ssth**2)
      AAABR(6640) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc**2-Mc
     &      **2/sb**2-Mc**2*sb**2-2D0*Mc**2*scth**2-2D0*Mc
     &      **2*ssth**2+Mc**2/sb**2*scth**2+Mc**2/sb**2*ssth
     &      **2+Mc**2*sb**2*scth**2+Mc**2*sb**2*ssth**2+2D0
     &      *Mc**2*scth**2*ssth**2-Mc**2/sb**2*scth**2*ssth
     &      **2-Mc**2*sb**2*scth**2*ssth**2+Ms**2*sb**2*scth
     &      **2*ssth**2)
      AAABR(6641) = EE**2/MW**2*Ms/SW**2/cb**2*scth**2*ssth
     &      **2
      AAABR(6642) = EE**2/MW**2*Mc/SW**2/cb**2*(1D0-1D0/sb
     &      **2-scth**2-ssth**2+scth**2/sb**2+ssth**2/sb
     &      **2+scth**2*ssth**2-scth**2/sb**2*ssth**2)
      AAABR(6643) = EE**2/SW**2*scth**2*(1D0-sbth**2)
      AAABR(6644) = EE**2/CW**2*(4D0+4D0*sbth**2-5D0*scth
     &      **2-5D0*sbth**2*scth**2)
      AAABR(6645) = EE**2/CW**3*SW*(4D0+4D0*sbth**2-5D0*scth
     &      **2-5D0*sbth**2*scth**2)
      AAABR(6646) = EE**2/SW**2/cb**2*stth**2*(1D0-sb**2
     &      -sbth**2+sb**2*sbth**2)
      AAABR(6647) = EE**2/CW**2/cb**2*(4D0-4D0*sb**2+4D0
     &      *sbth**2-5D0*stth**2-4D0*sb**2*sbth**2+5D0*sb
     &      **2*stth**2-5D0*sbth**2*stth**2+5D0*sb**2*sbth
     &      **2*stth**2)
      AAABR(6648) = EE**2/CW**3*SW/cb**2*(4D0-4D0*sb**2+4D0
     &      *sbth**2-5D0*stth**2-4D0*sb**2*sbth**2+5D0*sb
     &      **2*stth**2-5D0*sbth**2*stth**2+5D0*sb**2*sbth
     &      **2*stth**2)
      AAABR(6649) = EE**2/MW**2/SW**2/cb**2*(Mt**2-Mt**2
     &      /sb**2-Mt**2*sbth**2-Mt**2*stth**2-Mb**2*sbth
     &      **2*stth**2+Mt**2/sb**2*sbth**2+Mt**2/sb**2*stth
     &      **2+Mt**2*sbth**2*stth**2-Mt**2/sb**2*sbth**2
     &      *stth**2)
      AAABR(6650) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt**2-Mt
     &      **2/sb**2-Mt**2*sb**2-2D0*Mt**2*sbth**2-2D0*Mt
     &      **2*stth**2+Mt**2/sb**2*sbth**2+Mt**2/sb**2*stth
     &      **2+Mt**2*sb**2*sbth**2+Mt**2*sb**2*stth**2+2D0
     &      *Mt**2*sbth**2*stth**2+Mb**2*sb**2*sbth**2*stth
     &      **2-Mt**2/sb**2*sbth**2*stth**2-Mt**2*sb**2*sbth
     &      **2*stth**2)
      AAABR(6651) = EE**2/MW**2*Mb/SW**2/cb**2*sbth**2*stth
     &      **2
      AAABR(6652) = EE**2/MW**2*Mt/SW**2/cb**2*(1D0-1D0/sb
     &      **2-sbth**2-stth**2+sbth**2/sb**2+stth**2/sb
     &      **2+sbth**2*stth**2-sbth**2/sb**2*stth**2)
      AAABR(6653) = EE**2/SW**2/cb**2*cdth*cuth*scth*ssth
     &      *(1D0-sb**2)
      AAABR(6654) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*cdth
     &      *ssth*suth-Md*Ms*csth*cuth*scth*sdth-Mc*Mu*ccth
     &      *cdth/sb**2*ssth*suth)
      AAABR(6655) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *cdth*ssth*suth-Mc*Mu*ccth*cdth/sb**2*ssth*suth
     &      -Mc*Mu*ccth*cdth*sb**2*ssth*suth+Md*Ms*csth*cuth
     &      *sb**2*scth*sdth)
      AAABR(6656) = EE**2/MW**2*Md/SW**2/cb**2*csth*cuth
     &      *scth*sdth
      AAABR(6657) = EE**2/MW**2*Ms/SW**2/cb**2*csth*cuth
     &      *scth*sdth
      AAABR(6658) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*cdth
     &      *ssth*suth*(1D0-1D0/sb**2)
      AAABR(6659) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*cdth
     &      *ssth*suth*(1D0-1D0/sb**2)
      AAABR(6660) = EE**2/SW**2/cb**2*cbth*ctth*scth*ssth
     &      *(1D0-sb**2)
      AAABR(6661) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*csth*ctth
     &      *sbth*scth-Mc*Mt*cbth*ccth*ssth*stth+Mc*Mt*cbth
     &      *ccth/sb**2*ssth*stth)
      AAABR(6662) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *ccth*ssth*stth+Mb*Ms*csth*ctth*sb**2*sbth*scth
     &      -Mc*Mt*cbth*ccth/sb**2*ssth*stth-Mc*Mt*cbth*ccth
     &      *sb**2*ssth*stth)
      AAABR(6663) = EE**2/MW**2*Mb/SW**2/cb**2*csth*ctth
     &      *sbth*scth
      AAABR(6664) = EE**2/MW**2*Ms/SW**2/cb**2*csth*ctth
     &      *sbth*scth
      AAABR(6665) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*ccth
     &      *ssth*stth*(1D0-1D0/sb**2)
      AAABR(6666) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ccth
     &      *ssth*stth*(1D0-1D0/sb**2)
      AAABR(6667) = EE**2/SW**2/cb**2*cbth*ctth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6668) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cdth*ctth
     &      *sbth*suth-Mt*Mu*cbth*cuth*sdth*stth+Mt*Mu*cbth
     &      *cuth/sb**2*sdth*stth)
      AAABR(6669) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *cuth*sdth*stth+Mb*Md*cdth*ctth*sb**2*sbth*suth
     &      -Mt*Mu*cbth*cuth/sb**2*sdth*stth-Mt*Mu*cbth*cuth
     &      *sb**2*sdth*stth)
      AAABR(6670) = EE**2/MW**2*Mb/SW**2/cb**2*cdth*ctth
     &      *sbth*suth
      AAABR(6671) = EE**2/MW**2*Md/SW**2/cb**2*cdth*ctth
     &      *sbth*suth
      AAABR(6672) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*cuth
     &      *sdth*stth*(1D0-1D0/sb**2)
      AAABR(6673) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*cuth
     &      *sdth*stth*(1D0-1D0/sb**2)
      AAABR(6674) = EE**2/SW**2/cb**2*ccth*csth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6675) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*csth*cuth
     &      *scth*sdth-Md*Ms*ccth*cdth*ssth*suth-Mc*Mu*csth
     &      *cuth/sb**2*scth*sdth)
      AAABR(6676) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*csth
     &      *cuth*scth*sdth-Mc*Mu*csth*cuth/sb**2*scth*sdth
     &      -Mc*Mu*csth*cuth*sb**2*scth*sdth+Md*Ms*ccth*cdth
     &      *sb**2*ssth*suth)
      AAABR(6677) = EE**2/MW**2*Ms/SW**2/cb**2*ccth*cdth
     &      *ssth*suth
      AAABR(6678) = EE**2/MW**2*Md/SW**2/cb**2*ccth*cdth
     &      *ssth*suth
      AAABR(6679) = EE**2/MW**2*Mu/SW**2/cb**2*csth*cuth
     &      *scth*sdth*(1D0-1D0/sb**2)
      AAABR(6680) = EE**2/MW**2*Mc/SW**2/cb**2*csth*cuth
     &      *scth*sdth*(1D0-1D0/sb**2)
      AAABR(6681) = EE**2/SW**2/cb**2*cdth*cuth*sbth*stth
     &      *(1D0-sb**2)
      AAABR(6682) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cbth*cuth
     &      *sdth*stth-Mt*Mu*cdth*ctth*sbth*suth+Mt*Mu*cdth
     &      *ctth/sb**2*sbth*suth)
      AAABR(6683) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cdth
     &      *ctth*sbth*suth+Mb*Md*cbth*cuth*sb**2*sdth*stth
     &      -Mt*Mu*cdth*ctth/sb**2*sbth*suth-Mt*Mu*cdth*ctth
     &      *sb**2*sbth*suth)
      AAABR(6684) = EE**2/MW**2*Md/SW**2/cb**2*cbth*cuth
     &      *sdth*stth
      AAABR(6685) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*cuth
     &      *sdth*stth
      AAABR(6686) = EE**2/MW**2*Mt/SW**2/cb**2*cdth*ctth
     &      *sbth*suth*(1D0-1D0/sb**2)
      AAABR(6687) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*ctth
     &      *sbth*suth*(1D0-1D0/sb**2)
      AAABR(6688) = EE**2/SW**2/cb**2*ccth*csth*sbth*stth
     &      *(1D0-sb**2)
      AAABR(6689) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*cbth*ccth
     &      *ssth*stth-Mc*Mt*csth*ctth*sbth*scth+Mc*Mt*csth
     &      *ctth/sb**2*sbth*scth)
      AAABR(6690) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*csth
     &      *ctth*sbth*scth+Mb*Ms*cbth*ccth*sb**2*ssth*stth
     &      -Mc*Mt*csth*ctth/sb**2*sbth*scth-Mc*Mt*csth*ctth
     &      *sb**2*sbth*scth)
      AAABR(6691) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*ccth
     &      *ssth*stth
      AAABR(6692) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*ccth
     &      *ssth*stth
      AAABR(6693) = EE**2/MW**2*Mt/SW**2/cb**2*csth*ctth
     &      *sbth*scth*(1D0-1D0/sb**2)
      AAABR(6694) = EE**2/MW**2*Mc/SW**2/cb**2*csth*ctth
     &      *sbth*scth*(1D0-1D0/sb**2)
      AAABR(6695) = EE**2/SW**2/cb**2*(sbth*scth*ssth*stth
     &      -sb**2*sbth*scth*ssth*stth+Mb/MW**2*Ms*cbth*csth
     &      *scth*stth-Mc/MW**2*Mt*ccth*ctth*sbth*ssth+Mc
     &      /MW**2*Mt*ccth*ctth/sb**2*sbth*ssth)
      AAABR(6696) = EE**2/SW**2/cb**2*cbth*scth*ssth*stth
     &      *(1D0-sb**2)
      AAABR(6697) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*csth*sbth
     &      *scth*stth+Mc*Mt*cbth*ccth*ctth*ssth-Mc*Mt*cbth
     &      *ccth*ctth/sb**2*ssth)
      AAABR(6698) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*cbth
     &      *ccth*ctth*ssth-Mb*Ms*csth*sb**2*sbth*scth*stth
     &      -Mc*Mt*cbth*ccth*ctth/sb**2*ssth-Mc*Mt*cbth*ccth
     &      *ctth*sb**2*ssth)
      AAABR(6699) = EE**2/MW**2*Mb/SW**2/cb**2*csth*sbth
     &      *scth*stth
      AAABR(6700) = EE**2/MW**2*Ms/SW**2/cb**2*csth*sbth
     &      *scth*stth
      AAABR(6701) = EE**2/MW**2*Mc/SW**2/cb**2*cbth*ccth
     &      *ctth*ssth*(1D0-1D0/sb**2)
      AAABR(6702) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ccth
     &      *ctth*ssth*(1D0-1D0/sb**2)
      AAABR(6703) = EE**2/SW**2*csth*ssth*stth**2
      AAABR(6704) = EE**2*(8D0/CW**2-4D0*ssth**2/CW**2-10D0
     &      *stth**2/CW**2+5D0*ssth**2/CW**2*stth**2+9D0
     &      *ssth**2/SW**2*stth**2)
      AAABR(6705) = EE**2/CW**2*csth*ssth*(4D0-5D0*stth**2)
      AAABR(6706) = EE**2/CW**3*SW*csth*ssth*(4D0-5D0*stth
     &      **2)
      AAABR(6707) = EE**2/cb**2*(8D0/CW**2-8D0*sb**2/CW**2
     &      -4D0*sbth**2/CW**2-10D0*stth**2/CW**2+4D0*sb
     &      **2/CW**2*sbth**2+10D0*sb**2/CW**2*stth**2+5D0
     &      *sbth**2/CW**2*stth**2+9D0*sbth**2/SW**2*stth
     &      **2-5D0*sb**2/CW**2*sbth**2*stth**2-9D0*sb**2
     &      /SW**2*sbth**2*stth**2)
      AAABR(6708) = EE**2/SW**2/cb**2*cbth*sbth*stth**2*(1D0
     &      -sb**2)
      AAABR(6709) = EE**2/SW**2/cb**2*(sbth**2*stth**2+Mb
     &      **2/MW**2*stth**2-Mt**2/MW**2*sbth**2-sb**2*sbth
     &      **2*stth**2-Mb**2/MW**2*sbth**2*stth**2+Mt**2
     &      /MW**2/sb**2*sbth**2+Mt**2/MW**2*sbth**2*stth
     &      **2-Mt**2/MW**2/sb**2*sbth**2*stth**2)
      AAABR(6710) = EE**2/CW**2/cb**2*cbth*sbth*(4D0-4D0
     &      *sb**2-5D0*stth**2+5D0*sb**2*stth**2)
      AAABR(6711) = EE**2/CW**3*SW/cb**2*cbth*sbth*(4D0-4D0
     &      *sb**2-5D0*stth**2+5D0*sb**2*stth**2)
      AAABR(6712) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(Mt
     &      **2+Mb**2*stth**2-Mt**2/sb**2-Mt**2*stth**2+Mt
     &      **2/sb**2*stth**2)
      AAABR(6713) = EE**2/MW**2/SW**2/cb**2*cbth*sbth*(2D0
     &      *Mt**2-Mt**2/sb**2-Mt**2*sb**2-2D0*Mt**2*stth
     &      **2-Mb**2*sb**2*stth**2+Mt**2/sb**2*stth**2+Mt
     &      **2*sb**2*stth**2)
      AAABR(6714) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sbth
     &      *stth**2
      AAABR(6715) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*sbth
     &      *(1D0-1D0/sb**2-stth**2+stth**2/sb**2)
      AAABR(6716) = EE**2/SW**2*cdth*scth**2*sdth
      AAABR(6717) = EE**2*(8D0/CW**2-10D0*scth**2/CW**2-4D0
     &      *sdth**2/CW**2+5D0*scth**2/CW**2*sdth**2+9D0
     &      *scth**2/SW**2*sdth**2)
      AAABR(6718) = EE**2/CW**2*cdth*sdth*(4D0-5D0*scth**2)
      AAABR(6719) = EE**2/CW**3*SW*cdth*sdth*(4D0-5D0*scth
     &      **2)
      AAABR(6720) = EE**2/cb**2*(8D0/CW**2-8D0*sb**2/CW**2
     &      -4D0*sdth**2/CW**2-10D0*suth**2/CW**2+4D0*sb
     &      **2/CW**2*sdth**2+10D0*sb**2/CW**2*suth**2+5D0
     &      *sdth**2/CW**2*suth**2+9D0*sdth**2/SW**2*suth
     &      **2-5D0*sb**2/CW**2*sdth**2*suth**2-9D0*sb**2
     &      /SW**2*sdth**2*suth**2)
      AAABR(6721) = EE**2/SW**2/cb**2*cdth*sdth*suth**2*(1D0
     &      -sb**2)
      AAABR(6722) = EE**2/SW**2/cb**2*(sdth**2*suth**2+Md
     &      **2/MW**2*suth**2-Mu**2/MW**2*sdth**2-sb**2*sdth
     &      **2*suth**2-Md**2/MW**2*sdth**2*suth**2+Mu**2
     &      /MW**2/sb**2*sdth**2+Mu**2/MW**2*sdth**2*suth
     &      **2-Mu**2/MW**2/sb**2*sdth**2*suth**2)
      AAABR(6723) = EE**2/CW**2/cb**2*cdth*sdth*(4D0-4D0
     &      *sb**2-5D0*suth**2+5D0*sb**2*suth**2)
      AAABR(6724) = EE**2/CW**3*SW/cb**2*cdth*sdth*(4D0-4D0
     &      *sb**2-5D0*suth**2+5D0*sb**2*suth**2)
      AAABR(6725) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(Mu
     &      **2+Md**2*suth**2-Mu**2/sb**2-Mu**2*suth**2+Mu
     &      **2/sb**2*suth**2)
      AAABR(6726) = EE**2/MW**2/SW**2/cb**2*cdth*sdth*(2D0
     &      *Mu**2-Mu**2/sb**2-Mu**2*sb**2-2D0*Mu**2*suth
     &      **2-Md**2*sb**2*suth**2+Mu**2/sb**2*suth**2+Mu
     &      **2*sb**2*suth**2)
      AAABR(6727) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sdth
     &      *suth**2
      AAABR(6728) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*sdth
     &      *(1D0-1D0/sb**2-suth**2+suth**2/sb**2)
      AAABR(6729) = EE**2/SW**2/cb**2*cdth*scth*ssth*suth
     &      *(1D0-sb**2)
      AAABR(6730) = EE**2/SW**2/cb**2*(scth*sdth*ssth*suth
     &      -sb**2*scth*sdth*ssth*suth-Mc/MW**2*Mu*ccth*cuth
     &      *sdth*ssth+Md/MW**2*Ms*cdth*csth*scth*suth+Mc
     &      /MW**2*Mu*ccth*cuth/sb**2*sdth*ssth)
      AAABR(6731) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*cdth
     &      *cuth*ssth+Md*Ms*csth*scth*sdth*suth-Mc*Mu*ccth
     &      *cdth*cuth/sb**2*ssth)
      AAABR(6732) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *cdth*cuth*ssth-Mc*Mu*ccth*cdth*cuth/sb**2*ssth
     &      -Mc*Mu*ccth*cdth*cuth*sb**2*ssth-Md*Ms*csth*sb
     &      **2*scth*sdth*suth)
      AAABR(6733) = EE**2/MW**2*Md/SW**2/cb**2*csth*scth
     &      *sdth*suth
      AAABR(6734) = EE**2/MW**2*Ms/SW**2/cb**2*csth*scth
     &      *sdth*suth
      AAABR(6735) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*cdth
     &      *cuth*ssth*(1D0-1D0/sb**2)
      AAABR(6736) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*cdth
     &      *cuth*ssth*(1D0-1D0/sb**2)
      AAABR(6737) = EE**2/cb**2*(8D0/CW**2-8D0*sb**2/CW**2
     &      -10D0*scth**2/CW**2-4D0*ssth**2/CW**2+10D0*sb
     &      **2/CW**2*scth**2+4D0*sb**2/CW**2*ssth**2+5D0
     &      *scth**2/CW**2*ssth**2+9D0*scth**2/SW**2*ssth
     &      **2-5D0*sb**2/CW**2*scth**2*ssth**2-9D0*sb**2
     &      /SW**2*scth**2*ssth**2)
      AAABR(6738) = EE**2/SW**2/cb**2*csth*scth**2*ssth*(1D0
     &      -sb**2)
      AAABR(6739) = EE**2/SW**2/cb**2*(scth**2*ssth**2-Mc
     &      **2/MW**2*ssth**2+Ms**2/MW**2*scth**2-sb**2*scth
     &      **2*ssth**2+Mc**2/MW**2/sb**2*ssth**2+Mc**2/MW
     &      **2*scth**2*ssth**2-Ms**2/MW**2*scth**2*ssth
     &      **2-Mc**2/MW**2/sb**2*scth**2*ssth**2)
      AAABR(6740) = EE**2/CW**2/cb**2*csth*ssth*(4D0-4D0
     &      *sb**2-5D0*scth**2+5D0*sb**2*scth**2)
      AAABR(6741) = EE**2/CW**3*SW/cb**2*csth*ssth*(4D0-4D0
     &      *sb**2-5D0*scth**2+5D0*sb**2*scth**2)
      AAABR(6742) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(Mc
     &      **2-Mc**2/sb**2-Mc**2*scth**2+Ms**2*scth**2+Mc
     &      **2/sb**2*scth**2)
      AAABR(6743) = EE**2/MW**2/SW**2/cb**2*csth*ssth*(2D0
     &      *Mc**2-Mc**2/sb**2-Mc**2*sb**2-2D0*Mc**2*scth
     &      **2+Mc**2/sb**2*scth**2+Mc**2*sb**2*scth**2-Ms
     &      **2*sb**2*scth**2)
      AAABR(6744) = EE**2/MW**2*Ms/SW**2/cb**2*csth*scth
     &      **2*ssth
      AAABR(6745) = EE**2/MW**2*Mc/SW**2/cb**2*csth*ssth
     &      *(1D0-1D0/sb**2-scth**2+scth**2/sb**2)
      AAABR(6746) = EE**2/SW**2/cb**2*csth*scth*sdth*suth
     &      *(1D0-sb**2)
      AAABR(6747) = EE**2/MW**2/SW**2/cb**2*(Mc*Mu*ccth*csth
     &      *cuth*sdth+Md*Ms*cdth*scth*ssth*suth-Mc*Mu*ccth
     &      *csth*cuth/sb**2*sdth)
      AAABR(6748) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mu*ccth
     &      *csth*cuth*sdth-Mc*Mu*ccth*csth*cuth/sb**2*sdth
     &      -Mc*Mu*ccth*csth*cuth*sb**2*sdth-Md*Ms*cdth*sb
     &      **2*scth*ssth*suth)
      AAABR(6749) = EE**2/MW**2*Ms/SW**2/cb**2*cdth*scth
     &      *ssth*suth
      AAABR(6750) = EE**2/MW**2*Md/SW**2/cb**2*cdth*scth
     &      *ssth*suth
      AAABR(6751) = EE**2/MW**2*Mu/SW**2/cb**2*ccth*csth
     &      *cuth*sdth*(1D0-1D0/sb**2)
      AAABR(6752) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*csth
     &      *cuth*sdth*(1D0-1D0/sb**2)
      AAABR(6753) = EE**2/SW**2*cdth*sdth*stth**2
      AAABR(6754) = EE**2*(8D0/CW**2-4D0*sdth**2/CW**2-10D0
     &      *stth**2/CW**2+5D0*sdth**2/CW**2*stth**2+9D0
     &      *sdth**2/SW**2*stth**2)
      AAABR(6755) = EE**2/CW**2*cdth*sdth*(4D0-5D0*stth**2)
      AAABR(6756) = EE**2/CW**3*SW*cdth*sdth*(4D0-5D0*stth
     &      **2)
      AAABR(6757) = EE**2/SW**2/cb**2*csth*sbth*scth*stth
     &      *(1D0-sb**2)
      AAABR(6758) = EE**2/MW**2/SW**2/cb**2*(Mb*Ms*cbth*scth
     &      *ssth*stth+Mc*Mt*ccth*csth*ctth*sbth-Mc*Mt*ccth
     &      *csth*ctth/sb**2*sbth)
      AAABR(6759) = EE**2/MW**2/SW**2/cb**2*(2D0*Mc*Mt*ccth
     &      *csth*ctth*sbth-Mb*Ms*cbth*sb**2*scth*ssth*stth
     &      -Mc*Mt*ccth*csth*ctth/sb**2*sbth-Mc*Mt*ccth*csth
     &      *ctth*sb**2*sbth)
      AAABR(6760) = EE**2/MW**2*Ms/SW**2/cb**2*cbth*scth
     &      *ssth*stth
      AAABR(6761) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*scth
     &      *ssth*stth
      AAABR(6762) = EE**2/MW**2*Mt/SW**2/cb**2*ccth*csth
     &      *ctth*sbth*(1D0-1D0/sb**2)
      AAABR(6763) = EE**2/MW**2*Mc/SW**2/cb**2*ccth*csth
     &      *ctth*sbth*(1D0-1D0/sb**2)
      AAABR(6764) = EE**2*(8D0/CW**2-4D0*sbth**2/CW**2-10D0
     &      *suth**2/CW**2+5D0*sbth**2/CW**2*suth**2+9D0
     &      *sbth**2/SW**2*suth**2)
      AAABR(6765) = EE**2/SW**2*cbth*sbth*suth**2
      AAABR(6766) = EE**2/CW**2*cbth*sbth*(4D0-5D0*suth**2)
      AAABR(6767) = EE**2/CW**3*SW*cbth*sbth*(4D0-5D0*suth
     &      **2)
      AAABR(6768) = EE**2*(8D0/CW**2-4D0*sbth**2/CW**2-10D0
     &      *scth**2/CW**2+5D0*sbth**2/CW**2*scth**2+9D0
     &      *sbth**2/SW**2*scth**2)
      AAABR(6769) = EE**2/SW**2*cbth*sbth*scth**2
      AAABR(6770) = EE**2/CW**2*cbth*sbth*(4D0-5D0*scth**2)
      AAABR(6771) = EE**2/CW**3*SW*cbth*sbth*(4D0-5D0*scth
     &      **2)
      AAABR(6772) = EE**2/SW**2/cb**2*(sbth*sdth*stth*suth
     &      -sb**2*sbth*sdth*stth*suth+Mb/MW**2*Md*cbth*cdth
     &      *stth*suth-Mt/MW**2*Mu*ctth*cuth*sbth*sdth+Mt
     &      /MW**2*Mu*ctth*cuth/sb**2*sbth*sdth)
      AAABR(6773) = EE**2/SW**2/cb**2*cbth*sdth*stth*suth
     &      *(1D0-sb**2)
      AAABR(6774) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cdth*sbth
     &      *stth*suth+Mt*Mu*cbth*ctth*cuth*sdth-Mt*Mu*cbth
     &      *ctth*cuth/sb**2*sdth)
      AAABR(6775) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cbth
     &      *ctth*cuth*sdth-Mb*Md*cdth*sb**2*sbth*stth*suth
     &      -Mt*Mu*cbth*ctth*cuth/sb**2*sdth-Mt*Mu*cbth*ctth
     &      *cuth*sb**2*sdth)
      AAABR(6776) = EE**2/MW**2*Mb/SW**2/cb**2*cdth*sbth
     &      *stth*suth
      AAABR(6777) = EE**2/MW**2*Md/SW**2/cb**2*cdth*sbth
     &      *stth*suth
      AAABR(6778) = EE**2/MW**2*Mu/SW**2/cb**2*cbth*ctth
     &      *cuth*sdth*(1D0-1D0/sb**2)
      AAABR(6779) = EE**2/MW**2*Mt/SW**2/cb**2*cbth*ctth
     &      *cuth*sdth*(1D0-1D0/sb**2)
      AAABR(6780) = EE**2/SW**2/cb**2*cdth*sbth*stth*suth
     &      *(1D0-sb**2)
      AAABR(6781) = EE**2/MW**2/SW**2/cb**2*(Mb*Md*cbth*sdth
     &      *stth*suth+Mt*Mu*cdth*ctth*cuth*sbth-Mt*Mu*cdth
     &      *ctth*cuth/sb**2*sbth)
      AAABR(6782) = EE**2/MW**2/SW**2/cb**2*(2D0*Mt*Mu*cdth
     &      *ctth*cuth*sbth-Mb*Md*cbth*sb**2*sdth*stth*suth
     &      -Mt*Mu*cdth*ctth*cuth/sb**2*sbth-Mt*Mu*cdth*ctth
     &      *cuth*sb**2*sbth)
      AAABR(6783) = EE**2/MW**2*Md/SW**2/cb**2*cbth*sdth
     &      *stth*suth
      AAABR(6784) = EE**2/MW**2*Mb/SW**2/cb**2*cbth*sdth
     &      *stth*suth
      AAABR(6785) = EE**2/MW**2*Mt/SW**2/cb**2*cdth*ctth
     &      *cuth*sbth*(1D0-1D0/sb**2)
      AAABR(6786) = EE**2/MW**2*Mu/SW**2/cb**2*cdth*ctth
     &      *cuth*sbth*(1D0-1D0/sb**2)
      AAABR(6787) = EE**2*(8D0/CW**2-4D0*ssth**2/CW**2-10D0
     &      *suth**2/CW**2+5D0*ssth**2/CW**2*suth**2+9D0
     &      *ssth**2/SW**2*suth**2)
      AAABR(6788) = EE**2/SW**2*csth*ssth*suth**2
      AAABR(6789) = EE**2/CW**2*csth*ssth*(4D0-5D0*suth**2)
      AAABR(6790) = EE**2/CW**3*SW*csth*ssth*(4D0-5D0*suth
     &      **2)
      AAABR(6791) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2+sdth**2/CW**2+6D0*sb**2/SW**2+3D0*sdth
     &      **2/SW**2-2D0*sb**2/CW**2*sdth**2-6D0*Mu**2/MW
     &      **2/SW**2-6D0*sb**2/SW**2*sdth**2-6D0*Md**2/MW
     &      **2/SW**2*sdth**2+6D0*Mu**2/MW**2/SW**2*sdth**2)
      AAABR(6792) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      +sdth**2/CW**2+3D0*sb**2/SW**2+3D0*sdth**2/SW
     &      **2-sb**2/CW**2*sdth**2-3D0*sb**2/SW**2*sdth
     &      **2-6D0*Md**2/MW**2/SW**2*sdth**2)
      AAABR(6793) = EE**2/SW**2*(1D0-2D0*sb**2-sdth**2+2D0
     &      *sb**2*sdth**2)
      AAABR(6794) = EE**2*cdth*sdth*(1D0/CW**2+3D0/SW**2
     &      -2D0*sb**2/CW**2-6D0*sb**2/SW**2-6D0*Md**2/MW
     &      **2/SW**2+6D0*Mu**2/MW**2/SW**2)
      AAABR(6795) = EE**2*(sb**2/CW**2-3D0*sb**2/SW**2+sb
     &      **2/CW**2*sdth**2+6D0*Mu**2/MW**2/SW**2+3D0*sb
     &      **2/SW**2*sdth**2-6D0*Mu**2/MW**2/SW**2*sdth**2)
      AAABR(6796) = EE**2/CW**2*(1D0-2D0*sb**2+sdth**2-2D0
     &      *sb**2*sdth**2)
      AAABR(6797) = EE**2/CW**3*SW*(1D0-2D0*sb**2+sdth**2
     &      -2D0*sb**2*sdth**2)
      AAABR(6798) = EE**2/MW**2/SW**2*(Mu**2+Md**2*sdth**2
     &      -Mu**2*sdth**2)
      AAABR(6799) = EE**2/MW**2/SW**2*(Mu**2-Mu**2*sb**2
     &      -Mu**2*sdth**2-Md**2*sb**2*sdth**2+Mu**2*sb**2
     &      *sdth**2)
      AAABR(6800) = EE**2/MW**2*Md/SW**2*sdth**2
      AAABR(6801) = EE**2/MW**2*Mu/SW**2*(1D0-sdth**2)
      AAABR(6802) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2+ssth**2/CW**2+6D0*sb**2/SW**2+3D0*ssth
     &      **2/SW**2-2D0*sb**2/CW**2*ssth**2-6D0*Mc**2/MW
     &      **2/SW**2-6D0*sb**2/SW**2*ssth**2+6D0*Mc**2/MW
     &      **2/SW**2*ssth**2-6D0*Ms**2/MW**2/SW**2*ssth**2)
      AAABR(6803) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      +ssth**2/CW**2+3D0*sb**2/SW**2+3D0*ssth**2/SW
     &      **2-sb**2/CW**2*ssth**2-3D0*sb**2/SW**2*ssth
     &      **2-6D0*Ms**2/MW**2/SW**2*ssth**2)
      AAABR(6804) = EE**2/SW**2*(1D0-2D0*sb**2-ssth**2+2D0
     &      *sb**2*ssth**2)
      AAABR(6805) = EE**2*csth*ssth*(1D0/CW**2+3D0/SW**2
     &      -2D0*sb**2/CW**2-6D0*sb**2/SW**2+6D0*Mc**2/MW
     &      **2/SW**2-6D0*Ms**2/MW**2/SW**2)
      AAABR(6806) = EE**2*(sb**2/CW**2-3D0*sb**2/SW**2+sb
     &      **2/CW**2*ssth**2+6D0*Mc**2/MW**2/SW**2+3D0*sb
     &      **2/SW**2*ssth**2-6D0*Mc**2/MW**2/SW**2*ssth**2)
      AAABR(6807) = EE**2/CW**2*(1D0-2D0*sb**2+ssth**2-2D0
     &      *sb**2*ssth**2)
      AAABR(6808) = EE**2/CW**3*SW*(1D0-2D0*sb**2+ssth**2
     &      -2D0*sb**2*ssth**2)
      AAABR(6809) = EE**2/MW**2/SW**2*(Mc**2-Mc**2*ssth**2
     &      +Ms**2*ssth**2)
      AAABR(6810) = EE**2/MW**2/SW**2*(Mc**2-Mc**2*sb**2
     &      -Mc**2*ssth**2+Mc**2*sb**2*ssth**2-Ms**2*sb**2
     &      *ssth**2)
      AAABR(6811) = EE**2/MW**2*Ms/SW**2*ssth**2
      AAABR(6812) = EE**2/MW**2*Mc/SW**2*(1D0-ssth**2)
      AAABR(6813) = EE**2*(1D0/CW**2-3D0/SW**2-2D0*sb**2
     &      /CW**2+sbth**2/CW**2+6D0*sb**2/SW**2+3D0*sbth
     &      **2/SW**2-2D0*sb**2/CW**2*sbth**2-6D0*Mt**2/MW
     &      **2/SW**2-6D0*sb**2/SW**2*sbth**2-6D0*Mb**2/MW
     &      **2/SW**2*sbth**2+6D0*Mt**2/MW**2/SW**2*sbth**2)
      AAABR(6814) = EE**2*(1D0/CW**2-3D0/SW**2-sb**2/CW**2
     &      +sbth**2/CW**2+3D0*sb**2/SW**2+3D0*sbth**2/SW
     &      **2-sb**2/CW**2*sbth**2-3D0*sb**2/SW**2*sbth
     &      **2-6D0*Mb**2/MW**2/SW**2*sbth**2)
      AAABR(6815) = EE**2/SW**2*(1D0-2D0*sb**2-sbth**2+2D0
     &      *sb**2*sbth**2)
      AAABR(6816) = EE**2*cbth*sbth*(1D0/CW**2+3D0/SW**2
     &      -2D0*sb**2/CW**2-6D0*sb**2/SW**2-6D0*Mb**2/MW
     &      **2/SW**2+6D0*Mt**2/MW**2/SW**2)
      AAABR(6817) = EE**2*(sb**2/CW**2-3D0*sb**2/SW**2+sb
     &      **2/CW**2*sbth**2+6D0*Mt**2/MW**2/SW**2+3D0*sb
     &      **2/SW**2*sbth**2-6D0*Mt**2/MW**2/SW**2*sbth**2)
      AAABR(6818) = EE**2/CW**2*(1D0-2D0*sb**2+sbth**2-2D0
     &      *sb**2*sbth**2)
      AAABR(6819) = EE**2/CW**3*SW*(1D0-2D0*sb**2+sbth**2
     &      -2D0*sb**2*sbth**2)
      AAABR(6820) = EE**2/MW**2/SW**2*(Mt**2+Mb**2*sbth**2
     &      -Mt**2*sbth**2)
      AAABR(6821) = EE**2/MW**2/SW**2*(Mt**2-Mt**2*sb**2
     &      -Mt**2*sbth**2-Mb**2*sb**2*sbth**2+Mt**2*sb**2
     &      *sbth**2)
      AAABR(6822) = EE**2/MW**2*Mb/SW**2*sbth**2
      AAABR(6823) = EE**2/MW**2*Mt/SW**2*(1D0-sbth**2)
      AAABR(6824) = EE**2*cbth*sbth*(1D0/CW**2+3D0/SW**2
     &      -sb**2/CW**2-3D0*sb**2/SW**2-6D0*Mb**2/MW**2
     &      /SW**2)
      AAABR(6825) = EE**2/SW**2*cbth*sbth*(1D0-2D0*sb**2)
      AAABR(6826) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-sbth
     &      **2/CW**2-3D0*sbth**2/SW**2+2D0*sb**2/CW**2*sbth
     &      **2-6D0*Mb**2/MW**2/SW**2+6D0*sb**2/SW**2*sbth
     &      **2+6D0*Mb**2/MW**2/SW**2*sbth**2-6D0*Mt**2/MW
     &      **2/SW**2*sbth**2)
      AAABR(6827) = EE**2*cbth*sbth*(sb**2/CW**2+3D0*sb**2
     &      /SW**2-6D0*Mt**2/MW**2/SW**2)
      AAABR(6828) = EE**2/CW**2*cbth*sbth*(1D0-2D0*sb**2)
      AAABR(6829) = EE**2/CW**3*SW*cbth*sbth*(1D0-2D0*sb**2)
      AAABR(6830) = EE**2/MW**2/SW**2*cbth*sbth*(Mb**2-Mt
     &      **2)
      AAABR(6831) = EE**2/MW**2/SW**2*cbth*sbth*(Mt**2+Mb
     &      **2*sb**2-Mt**2*sb**2)
      AAABR(6832) = EE**2/MW**2*Mb/SW**2*cbth*sbth
      AAABR(6833) = EE**2/MW**2*Mt/SW**2*cbth*sbth
      AAABR(6834) = EE**2*csth*ssth*(1D0/CW**2+3D0/SW**2
     &      -sb**2/CW**2-3D0*sb**2/SW**2-6D0*Ms**2/MW**2
     &      /SW**2)
      AAABR(6835) = EE**2/SW**2*csth*ssth*(1D0-2D0*sb**2)
      AAABR(6836) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-ssth
     &      **2/CW**2-3D0*ssth**2/SW**2+2D0*sb**2/CW**2*ssth
     &      **2-6D0*Ms**2/MW**2/SW**2+6D0*sb**2/SW**2*ssth
     &      **2-6D0*Mc**2/MW**2/SW**2*ssth**2+6D0*Ms**2/MW
     &      **2/SW**2*ssth**2)
      AAABR(6837) = EE**2*csth*ssth*(sb**2/CW**2+3D0*sb**2
     &      /SW**2-6D0*Mc**2/MW**2/SW**2)
      AAABR(6838) = EE**2/CW**2*csth*ssth*(1D0-2D0*sb**2)
      AAABR(6839) = EE**2/CW**3*SW*csth*ssth*(1D0-2D0*sb**2)
      AAABR(6840) = EE**2/MW**2/SW**2*csth*ssth*(Mc**2-Ms
     &      **2)
      AAABR(6841) = EE**2/MW**2/SW**2*csth*ssth*(Mc**2-Mc
     &      **2*sb**2+Ms**2*sb**2)
      AAABR(6842) = EE**2/MW**2*Ms/SW**2*csth*ssth
      AAABR(6843) = EE**2/MW**2*Mc/SW**2*csth*ssth
      AAABR(6844) = EE**2*cdth*sdth*(1D0/CW**2+3D0/SW**2
     &      -sb**2/CW**2-3D0*sb**2/SW**2-6D0*Md**2/MW**2
     &      /SW**2)
      AAABR(6845) = EE**2/SW**2*cdth*sdth*(1D0-2D0*sb**2)
      AAABR(6846) = EE**2*(2D0/CW**2-4D0*sb**2/CW**2-sdth
     &      **2/CW**2-3D0*sdth**2/SW**2+2D0*sb**2/CW**2*sdth
     &      **2-6D0*Md**2/MW**2/SW**2+6D0*sb**2/SW**2*sdth
     &      **2+6D0*Md**2/MW**2/SW**2*sdth**2-6D0*Mu**2/MW
     &      **2/SW**2*sdth**2)
      AAABR(6847) = EE**2*cdth*sdth*(sb**2/CW**2+3D0*sb**2
     &      /SW**2-6D0*Mu**2/MW**2/SW**2)
      AAABR(6848) = EE**2/CW**2*cdth*sdth*(1D0-2D0*sb**2)
      AAABR(6849) = EE**2/CW**3*SW*cdth*sdth*(1D0-2D0*sb**2)
      AAABR(6850) = EE**2/MW**2/SW**2*cdth*sdth*(Md**2-Mu
     &      **2)
      AAABR(6851) = EE**2/MW**2/SW**2*cdth*sdth*(Mu**2+Md
     &      **2*sb**2-Mu**2*sb**2)
      AAABR(6852) = EE**2/MW**2*Md/SW**2*cdth*sdth
      AAABR(6853) = EE**2/MW**2*Mu/SW**2*cdth*sdth
      AAABR(6854) = EE**2/SW**2*Sqrt2*cbth*ctth*(1D0-2D0
     &      *sb**2-Mb**2/MW**2+Mt**2/MW**2)
      AAABR(6855) = EE**2/SW**2*Sqrt2*(cbth*ctth-cbth*ctth
     &      *sb**2-Mb**2/MW**2*cbth*ctth+Mb/MW**2*Mt*sbth
     &      *stth)
      AAABR(6856) = EE**2/SW**2*Sqrt2*(cbth*ctth-cbth*ctth
     &      *sb**2-Mb**2/MW**2*cbth*ctth-Mb/MW**2*Mt*sbth
     &      *stth)
      AAABR(6857) = EE**2/SW**2*Sqrt2*cbth*ctth*(1D0-2D0
     &      *sb**2)
      AAABR(6858) = EE**2/SW**2*Sqrt2*cbth*stth*(1D0-2D0
     &      *sb**2-Mb**2/MW**2+Mt**2/MW**2)
      AAABR(6859) = EE**2/SW**2*Sqrt2*ctth*sbth*(1D0-2D0
     &      *sb**2-Mb**2/MW**2+Mt**2/MW**2)
      AAABR(6860) = EE**2/SW**2*Sqrt2*(cbth*ctth*sb**2-Mt
     &      **2/MW**2*cbth*ctth-Mb/MW**2*Mt*sbth*stth)
      AAABR(6861) = EE**2/SW**2*Sqrt2*(cbth*ctth*sb**2-Mt
     &      **2/MW**2*cbth*ctth+Mb/MW**2*Mt*sbth*stth)
      AAABR(6862) = EE**2/MW**2/SW**2*Sqrt2*cbth*ctth*(Mb
     &      **2-Mt**2)
      AAABR(6863) = EE**2/MW**2/SW**2*Sqrt2*cbth*ctth*(Mt
     &      **2+Mb**2*sb**2-Mt**2*sb**2)
      AAABR(6864) = EE**2/MW**2*Mt/SW**2*Sqrt2*cbth*ctth
      AAABR(6865) = EE**2/MW**2*Mb/SW**2*Sqrt2*cbth*ctth
      AAABR(6866) = EE**2/SW**2*Sqrt2*ccth*csth*(1D0-2D0
     &      *sb**2+Mc**2/MW**2-Ms**2/MW**2)
      AAABR(6867) = EE**2/SW**2*Sqrt2*(ccth*csth-ccth*csth
     &      *sb**2-Ms**2/MW**2*ccth*csth+Mc/MW**2*Ms*scth
     &      *ssth)
      AAABR(6868) = EE**2/SW**2*Sqrt2*(ccth*csth-ccth*csth
     &      *sb**2-Ms**2/MW**2*ccth*csth-Mc/MW**2*Ms*scth
     &      *ssth)
      AAABR(6869) = EE**2/SW**2*Sqrt2*ccth*csth*(1D0-2D0
     &      *sb**2)
      AAABR(6870) = EE**2/SW**2*Sqrt2*csth*scth*(1D0-2D0
     &      *sb**2+Mc**2/MW**2-Ms**2/MW**2)
      AAABR(6871) = EE**2/SW**2*Sqrt2*ccth*ssth*(1D0-2D0
     &      *sb**2+Mc**2/MW**2-Ms**2/MW**2)
      AAABR(6872) = EE**2/SW**2*Sqrt2*(ccth*csth*sb**2-Mc
     &      **2/MW**2*ccth*csth-Mc/MW**2*Ms*scth*ssth)
      AAABR(6873) = EE**2/SW**2*Sqrt2*(ccth*csth*sb**2-Mc
     &      **2/MW**2*ccth*csth+Mc/MW**2*Ms*scth*ssth)
      AAABR(6874) = EE**2/MW**2/SW**2*Sqrt2*ccth*csth*(Mc
     &      **2-Ms**2)
      AAABR(6875) = EE**2/MW**2/SW**2*Sqrt2*ccth*csth*(Mc
     &      **2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(6876) = EE**2/MW**2*Mc/SW**2*Sqrt2*ccth*csth
      AAABR(6877) = EE**2/MW**2*Ms/SW**2*Sqrt2*ccth*csth
      AAABR(6878) = EE**2/SW**2*Sqrt2*cdth*cuth*(1D0-2D0
     &      *sb**2-Md**2/MW**2+Mu**2/MW**2)
      AAABR(6879) = EE**2/SW**2*Sqrt2*(cdth*cuth-cdth*cuth
     &      *sb**2-Md**2/MW**2*cdth*cuth+Md/MW**2*Mu*sdth
     &      *suth)
      AAABR(6880) = EE**2/SW**2*Sqrt2*(cdth*cuth-cdth*cuth
     &      *sb**2-Md**2/MW**2*cdth*cuth-Md/MW**2*Mu*sdth
     &      *suth)
      AAABR(6881) = EE**2/SW**2*Sqrt2*cdth*cuth*(1D0-2D0
     &      *sb**2)
      AAABR(6882) = EE**2/SW**2*Sqrt2*cdth*suth*(1D0-2D0
     &      *sb**2-Md**2/MW**2+Mu**2/MW**2)
      AAABR(6883) = EE**2/SW**2*Sqrt2*cuth*sdth*(1D0-2D0
     &      *sb**2-Md**2/MW**2+Mu**2/MW**2)
      AAABR(6884) = EE**2/SW**2*Sqrt2*(cdth*cuth*sb**2-Mu
     &      **2/MW**2*cdth*cuth-Md/MW**2*Mu*sdth*suth)
      AAABR(6885) = EE**2/SW**2*Sqrt2*(cdth*cuth*sb**2-Mu
     &      **2/MW**2*cdth*cuth+Md/MW**2*Mu*sdth*suth)
      AAABR(6886) = EE**2/MW**2/SW**2*Sqrt2*cdth*cuth*(Md
     &      **2-Mu**2)
      AAABR(6887) = EE**2/MW**2/SW**2*Sqrt2*cdth*cuth*(Mu
     &      **2+Md**2*sb**2-Mu**2*sb**2)
      AAABR(6888) = EE**2/MW**2*Mu/SW**2*Sqrt2*cdth*cuth
      AAABR(6889) = EE**2/MW**2*Md/SW**2*Sqrt2*cdth*cuth
      AAABR(6890) = EE**2/SW**2*Sqrt2*(cdth*suth-cdth*sb
     &      **2*suth-Md**2/MW**2*cdth*suth-Md/MW**2*Mu*cuth
     &      *sdth)
      AAABR(6891) = EE**2/SW**2*Sqrt2*(cdth*suth-cdth*sb
     &      **2*suth-Md**2/MW**2*cdth*suth+Md/MW**2*Mu*cuth
     &      *sdth)
      AAABR(6892) = EE**2/SW**2*Sqrt2*cdth*suth*(1D0-2D0
     &      *sb**2)
      AAABR(6893) = EE**2/SW**2*Sqrt2*sdth*suth*(1D0-2D0
     &      *sb**2-Md**2/MW**2+Mu**2/MW**2)
      AAABR(6894) = EE**2/SW**2*Sqrt2*(cdth*sb**2*suth-Mu
     &      **2/MW**2*cdth*suth+Md/MW**2*Mu*cuth*sdth)
      AAABR(6895) = EE**2/SW**2*Sqrt2*(cdth*sb**2*suth-Mu
     &      **2/MW**2*cdth*suth-Md/MW**2*Mu*cuth*sdth)
      AAABR(6896) = EE**2/MW**2/SW**2*Sqrt2*cdth*suth*(Md
     &      **2-Mu**2)
      AAABR(6897) = EE**2/MW**2/SW**2*Sqrt2*cdth*suth*(Mu
     &      **2+Md**2*sb**2-Mu**2*sb**2)
      AAABR(6898) = EE**2/MW**2*Mu/SW**2*Sqrt2*cdth*suth
      AAABR(6899) = EE**2/MW**2*Md/SW**2*Sqrt2*cdth*suth
      AAABR(6900) = EE**2/SW**2*Sqrt2*(csth*scth-csth*sb
     &      **2*scth-Ms**2/MW**2*csth*scth-Mc/MW**2*Ms*ccth
     &      *ssth)
      AAABR(6901) = EE**2/SW**2*Sqrt2*(csth*scth-csth*sb
     &      **2*scth-Ms**2/MW**2*csth*scth+Mc/MW**2*Ms*ccth
     &      *ssth)
      AAABR(6902) = EE**2/SW**2*Sqrt2*csth*scth*(1D0-2D0
     &      *sb**2)
      AAABR(6903) = EE**2/SW**2*Sqrt2*scth*ssth*(1D0-2D0
     &      *sb**2+Mc**2/MW**2-Ms**2/MW**2)
      AAABR(6904) = EE**2/SW**2*Sqrt2*(csth*sb**2*scth-Mc
     &      **2/MW**2*csth*scth+Mc/MW**2*Ms*ccth*ssth)
      AAABR(6905) = EE**2/SW**2*Sqrt2*(csth*sb**2*scth-Mc
     &      **2/MW**2*csth*scth-Mc/MW**2*Ms*ccth*ssth)
      AAABR(6906) = EE**2/MW**2/SW**2*Sqrt2*csth*scth*(Mc
     &      **2-Ms**2)
      AAABR(6907) = EE**2/MW**2/SW**2*Sqrt2*csth*scth*(Mc
     &      **2-Mc**2*sb**2+Ms**2*sb**2)
      AAABR(6908) = EE**2/MW**2*Mc/SW**2*Sqrt2*csth*scth
      AAABR(6909) = EE**2/MW**2*Ms/SW**2*Sqrt2*csth*scth
      AAABR(6910) = EE**2/SW**2*Sqrt2*(cbth*stth-cbth*sb
     &      **2*stth-Mb**2/MW**2*cbth*stth-Mb/MW**2*Mt*ctth
     &      *sbth)
      AAABR(6911) = EE**2/SW**2*Sqrt2*(cbth*stth-cbth*sb
     &      **2*stth-Mb**2/MW**2*cbth*stth+Mb/MW**2*Mt*ctth
     &      *sbth)
      AAABR(6912) = EE**2/SW**2*Sqrt2*cbth*stth*(1D0-2D0
     &      *sb**2)
      AAABR(6913) = EE**2/SW**2*Sqrt2*sbth*stth*(1D0-2D0
     &      *sb**2-Mb**2/MW**2+Mt**2/MW**2)
      AAABR(6914) = EE**2/SW**2*Sqrt2*(cbth*sb**2*stth-Mt
     &      **2/MW**2*cbth*stth+Mb/MW**2*Mt*ctth*sbth)
      AAABR(6915) = EE**2/SW**2*Sqrt2*(cbth*sb**2*stth-Mt
     &      **2/MW**2*cbth*stth-Mb/MW**2*Mt*ctth*sbth)
      AAABR(6916) = EE**2/MW**2/SW**2*Sqrt2*cbth*stth*(Mb
     &      **2-Mt**2)
      AAABR(6917) = EE**2/MW**2/SW**2*Sqrt2*cbth*stth*(Mt
     &      **2+Mb**2*sb**2-Mt**2*sb**2)
      AAABR(6918) = EE**2/MW**2*Mt/SW**2*Sqrt2*cbth*stth
      AAABR(6919) = EE**2/MW**2*Mb/SW**2*Sqrt2*cbth*stth
      AAABR(6920) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*cuth-cdth
     &      *cuth*sa*sb-ca/cb*cdth*cuth*sb**2-Md**2/MW**2
     &      *ca/cb*cdth*cuth+Mu**2/MW**2*cdth*cuth*sa/sb
     &      +Md/MW**2*Mu*ca/cb*sdth*suth-Md/MW**2*Mu*sa/sb
     &      *sdth*suth)
      AAABR(6921) = EE**2/SW**2*Sqrt2*(ca*cdth*cuth*sb+cdth
     &      /cb*cuth*sa-cdth/cb*cuth*sa*sb**2-Md**2/MW**2
     &      /cb*cdth*cuth*sa-Mu**2/MW**2*ca*cdth*cuth/sb
     &      +Md/MW**2*Mu*ca/sb*sdth*suth+Md/MW**2*Mu/cb*sa
     &      *sdth*suth)
      AAABR(6922) = EE**2/SW**2*Sqrt2*(cdth/cb*cuth*sa-cdth
     &      /cb*cuth*sa*sb**2-Md**2/MW**2/cb*cdth*cuth*sa
     &      +Md/MW**2*Mu*ca/sb*sdth*suth)
      AAABR(6923) = EE**2/SW**2*Sqrt2*cdth*cuth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(6924) = EE**2/SW**2*Sqrt2*(ca*cdth*sb*suth+cdth
     &      /cb*sa*suth-cdth/cb*sa*sb**2*suth-Md**2/MW**2
     &      /cb*cdth*sa*suth-Mu**2/MW**2*ca*cdth/sb*suth
     &      -Md/MW**2*Mu*ca*cuth/sb*sdth-Md/MW**2*Mu/cb*cuth
     &      *sa*sdth)
      end

      subroutine aaini09
      implicit none
#include "model.h"

      AAABR(6925) = EE**2/SW**2*Sqrt2*(ca*cuth*sb*sdth+cuth
     &      /cb*sa*sdth-cuth/cb*sa*sb**2*sdth-Md**2/MW**2
     &      /cb*cuth*sa*sdth-Mu**2/MW**2*ca*cuth/sb*sdth
     &      -Md/MW**2*Mu*ca*cdth/sb*suth-Md/MW**2*Mu/cb*cdth
     &      *sa*suth)
      AAABR(6926) = EE**2/SW**2*Sqrt2*(ca*cdth*cuth*sb-Mu
     &      **2/MW**2*ca*cdth*cuth/sb+Md/MW**2*Mu/cb*sa*sdth
     &      *suth)
      AAABR(6927) = EE**2/MW**2/SW**2*Sqrt2*(Md**2/cb*cdth
     &      *cuth*sa+Mu**2*ca*cdth*cuth/sb-Md*Mu*ca/sb*sdth
     &      *suth-Md*Mu/cb*sa*sdth*suth)
      AAABR(6928) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mu**2*ca
     &      *cdth*cuth/sb-2D0*Mu**2*ca*cdth*cuth*sb-Md*Mu
     &      *ca/sb*sdth*suth+2D0*Md*Mu*ca*sb*sdth*suth-Md
     &      *Mu/cb*sa*sdth*suth-2D0*Md**2/cb*cdth*cuth*sa
     &      *sb**2+2D0*Md*Mu/cb*sa*sb**2*sdth*suth)
      AAABR(6929) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/sb*sdth
     &      *suth+Md/cb*sa*sdth*suth-2D0*Mu*ca*cdth*cuth/sb)
      AAABR(6930) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Md/cb*cdth
     &      *cuth*sa-Mu*ca/sb*sdth*suth-Mu/cb*sa*sdth*suth)
      AAABR(6931) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*ctth-cbth
     &      *ctth*sa*sb-ca/cb*cbth*ctth*sb**2-Mb**2/MW**2
     &      *ca/cb*cbth*ctth+Mt**2/MW**2*cbth*ctth*sa/sb
     &      +Mb/MW**2*Mt*ca/cb*sbth*stth-Mb/MW**2*Mt*sa/sb
     &      *sbth*stth)
      AAABR(6932) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*ctth-ca
     &      /cb*cbth*ctth*sb**2-Mb**2/MW**2*ca/cb*cbth*ctth
     &      -Mb/MW**2*Mt*sa/sb*sbth*stth)
      AAABR(6933) = EE**2/SW**2*Sqrt2*(ca*cbth*ctth*sb+cbth
     &      /cb*ctth*sa-cbth/cb*ctth*sa*sb**2-Mb**2/MW**2
     &      /cb*cbth*ctth*sa-Mt**2/MW**2*ca*cbth*ctth/sb
     &      +Mb/MW**2*Mt*ca/sb*sbth*stth+Mb/MW**2*Mt/cb*sa
     &      *sbth*stth)
      AAABR(6934) = EE**2/SW**2*Sqrt2*cbth*ctth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(6935) = EE**2/SW**2*Sqrt2*(ca/cb*cbth*stth-cbth
     &      *sa*sb*stth-ca/cb*cbth*sb**2*stth-Mb**2/MW**2
     &      *ca/cb*cbth*stth+Mt**2/MW**2*cbth*sa/sb*stth
     &      -Mb/MW**2*Mt*ca/cb*ctth*sbth+Mb/MW**2*Mt*ctth
     &      *sa/sb*sbth)
      AAABR(6936) = EE**2/SW**2*Sqrt2*(ca/cb*ctth*sbth-ctth
     &      *sa*sb*sbth-ca/cb*ctth*sb**2*sbth-Mb**2/MW**2
     &      *ca/cb*ctth*sbth+Mt**2/MW**2*ctth*sa/sb*sbth
     &      -Mb/MW**2*Mt*ca/cb*cbth*stth+Mb/MW**2*Mt*cbth
     &      *sa/sb*stth)
      AAABR(6937) = EE**2/SW**2*Sqrt2*(cbth*ctth*sa*sb-Mt
     &      **2/MW**2*cbth*ctth*sa/sb-Mb/MW**2*Mt*ca/cb*sbth
     &      *stth)
      AAABR(6938) = EE**2/MW**2/SW**2*Sqrt2*(Mb**2*ca/cb
     &      *cbth*ctth-Mt**2*cbth*ctth*sa/sb-Mb*Mt*ca/cb
     &      *sbth*stth+Mb*Mt*sa/sb*sbth*stth)
      AAABR(6939) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mt**2*cbth
     &      *ctth*sa/sb-2D0*Mt**2*cbth*ctth*sa*sb+Mb*Mt*ca
     &      /cb*sbth*stth-Mb*Mt*sa/sb*sbth*stth+2D0*Mb*Mt
     &      *sa*sb*sbth*stth+2D0*Mb**2*ca/cb*cbth*ctth*sb
     &      **2-2D0*Mb*Mt*ca/cb*sb**2*sbth*stth)
      AAABR(6940) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/cb*sbth
     &      *stth-Mb*sa/sb*sbth*stth+2D0*Mt*cbth*ctth*sa/sb)
      AAABR(6941) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mb*ca/cb
     &      *cbth*ctth-Mt*ca/cb*sbth*stth+Mt*sa/sb*sbth*stth
     &      )
      AAABR(6942) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*csth-ccth
     &      *csth*sa*sb-ca/cb*ccth*csth*sb**2+Mc**2/MW**2
     &      *ccth*csth*sa/sb-Ms**2/MW**2*ca/cb*ccth*csth
     &      +Mc/MW**2*Ms*ca/cb*scth*ssth-Mc/MW**2*Ms*sa/sb
     &      *scth*ssth)
      AAABR(6943) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*csth-ca
     &      /cb*ccth*csth*sb**2-Ms**2/MW**2*ca/cb*ccth*csth
     &      -Mc/MW**2*Ms*sa/sb*scth*ssth)
      AAABR(6944) = EE**2/SW**2*Sqrt2*(ca*ccth*csth*sb+ccth
     &      /cb*csth*sa-ccth/cb*csth*sa*sb**2-Mc**2/MW**2
     &      *ca*ccth*csth/sb-Ms**2/MW**2/cb*ccth*csth*sa
     &      +Mc/MW**2*Ms*ca/sb*scth*ssth+Mc/MW**2*Ms/cb*sa
     &      *scth*ssth)
      AAABR(6945) = EE**2/SW**2*Sqrt2*ccth*csth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(6946) = EE**2/SW**2*Sqrt2*(ca/cb*csth*scth-csth
     &      *sa*sb*scth-ca/cb*csth*sb**2*scth+Mc**2/MW**2
     &      *csth*sa/sb*scth-Ms**2/MW**2*ca/cb*csth*scth
     &      -Mc/MW**2*Ms*ca/cb*ccth*ssth+Mc/MW**2*Ms*ccth
     &      *sa/sb*ssth)
      AAABR(6947) = EE**2/SW**2*Sqrt2*(ca/cb*ccth*ssth-ccth
     &      *sa*sb*ssth-ca/cb*ccth*sb**2*ssth+Mc**2/MW**2
     &      *ccth*sa/sb*ssth-Ms**2/MW**2*ca/cb*ccth*ssth
     &      -Mc/MW**2*Ms*ca/cb*csth*scth+Mc/MW**2*Ms*csth
     &      *sa/sb*scth)
      AAABR(6948) = EE**2/SW**2*Sqrt2*(ccth*csth*sa*sb-Mc
     &      **2/MW**2*ccth*csth*sa/sb-Mc/MW**2*Ms*ca/cb*scth
     &      *ssth)
      AAABR(6949) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ccth*csth
     &      *sa/sb-Ms**2*ca/cb*ccth*csth+Mc*Ms*ca/cb*scth
     &      *ssth-Mc*Ms*sa/sb*scth*ssth)
      AAABR(6950) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc**2*ccth
     &      *csth*sa/sb-2D0*Mc**2*ccth*csth*sa*sb+Mc*Ms*ca
     &      /cb*scth*ssth-Mc*Ms*sa/sb*scth*ssth+2D0*Mc*Ms
     &      *sa*sb*scth*ssth+2D0*Ms**2*ca/cb*ccth*csth*sb
     &      **2-2D0*Mc*Ms*ca/cb*sb**2*scth*ssth)
      AAABR(6951) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ccth
     &      *csth*sa/sb+Ms*ca/cb*scth*ssth-Ms*sa/sb*scth
     &      *ssth)
      AAABR(6952) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*scth
     &      *ssth-Mc*sa/sb*scth*ssth-2D0*Ms*ca/cb*ccth*csth)
      AAABR(6953) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*cuth-ca
     &      /cb*cdth*cuth*sb**2-Md**2/MW**2*ca/cb*cdth*cuth
     &      -Md/MW**2*Mu*sa/sb*sdth*suth)
      AAABR(6954) = EE**2/SW**2*Sqrt2*cdth*cuth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(6955) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*suth-cdth
     &      *sa*sb*suth-ca/cb*cdth*sb**2*suth-Md**2/MW**2
     &      *ca/cb*cdth*suth+Mu**2/MW**2*cdth*sa/sb*suth
     &      -Md/MW**2*Mu*ca/cb*cuth*sdth+Md/MW**2*Mu*cuth
     &      *sa/sb*sdth)
      AAABR(6956) = EE**2/SW**2*Sqrt2*(ca/cb*cuth*sdth-cuth
     &      *sa*sb*sdth-ca/cb*cuth*sb**2*sdth-Md**2/MW**2
     &      *ca/cb*cuth*sdth+Mu**2/MW**2*cuth*sa/sb*sdth
     &      -Md/MW**2*Mu*ca/cb*cdth*suth+Md/MW**2*Mu*cdth
     &      *sa/sb*suth)
      AAABR(6957) = EE**2/SW**2*Sqrt2*(cdth*cuth*sa*sb-Mu
     &      **2/MW**2*cdth*cuth*sa/sb-Md/MW**2*Mu*ca/cb*sdth
     &      *suth)
      AAABR(6958) = EE**2/MW**2/SW**2*Sqrt2*(Md**2*ca/cb
     &      *cdth*cuth-Mu**2*cdth*cuth*sa/sb-Md*Mu*ca/cb
     &      *sdth*suth+Md*Mu*sa/sb*sdth*suth)
      AAABR(6959) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mu**2*cdth
     &      *cuth*sa/sb-2D0*Mu**2*cdth*cuth*sa*sb+Md*Mu*ca
     &      /cb*sdth*suth-Md*Mu*sa/sb*sdth*suth+2D0*Md*Mu
     &      *sa*sb*sdth*suth+2D0*Md**2*ca/cb*cdth*cuth*sb
     &      **2-2D0*Md*Mu*ca/cb*sb**2*sdth*suth)
      AAABR(6960) = EE**2/MW**2/SW**2*Sqrt2*(Md*ca/cb*sdth
     &      *suth-Md*sa/sb*sdth*suth+2D0*Mu*cdth*cuth*sa/sb)
      AAABR(6961) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Md*ca/cb
     &      *cdth*cuth-Mu*ca/cb*sdth*suth+Mu*sa/sb*sdth*suth
     &      )
      AAABR(6962) = EE**2/SW**2*Sqrt2*(ccth/cb*csth*sa-ccth
     &      /cb*csth*sa*sb**2-Ms**2/MW**2/cb*ccth*csth*sa
     &      +Mc/MW**2*Ms*ca/sb*scth*ssth)
      AAABR(6963) = EE**2/SW**2*Sqrt2*ccth*csth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(6964) = EE**2/SW**2*Sqrt2*(ca*csth*sb*scth+csth
     &      /cb*sa*scth-csth/cb*sa*sb**2*scth-Mc**2/MW**2
     &      *ca*csth/sb*scth-Ms**2/MW**2/cb*csth*sa*scth
     &      -Mc/MW**2*Ms*ca*ccth/sb*ssth-Mc/MW**2*Ms/cb*ccth
     &      *sa*ssth)
      AAABR(6965) = EE**2/SW**2*Sqrt2*(ca*ccth*sb*ssth+ccth
     &      /cb*sa*ssth-ccth/cb*sa*sb**2*ssth-Mc**2/MW**2
     &      *ca*ccth/sb*ssth-Ms**2/MW**2/cb*ccth*sa*ssth
     &      -Mc/MW**2*Ms*ca*csth/sb*scth-Mc/MW**2*Ms/cb*csth
     &      *sa*scth)
      AAABR(6966) = EE**2/SW**2*Sqrt2*(ca*ccth*csth*sb-Mc
     &      **2/MW**2*ca*ccth*csth/sb+Mc/MW**2*Ms/cb*sa*scth
     &      *ssth)
      AAABR(6967) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*ca*ccth
     &      *csth/sb+Ms**2/cb*ccth*csth*sa-Mc*Ms*ca/sb*scth
     &      *ssth-Mc*Ms/cb*sa*scth*ssth)
      AAABR(6968) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc**2*ca
     &      *ccth*csth/sb-2D0*Mc**2*ca*ccth*csth*sb-Mc*Ms
     &      *ca/sb*scth*ssth+2D0*Mc*Ms*ca*sb*scth*ssth-Mc
     &      *Ms/cb*sa*scth*ssth-2D0*Ms**2/cb*ccth*csth*sa
     &      *sb**2+2D0*Mc*Ms/cb*sa*sb**2*scth*ssth)
      AAABR(6969) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*ca*ccth
     &      *csth/sb-Ms*ca/sb*scth*ssth-Ms/cb*sa*scth*ssth)
      AAABR(6970) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/sb*scth
     &      *ssth+Mc/cb*sa*scth*ssth-2D0*Ms/cb*ccth*csth*sa)
      AAABR(6971) = EE**2/SW**2*Sqrt2*(cbth/cb*ctth*sa-cbth
     &      /cb*ctth*sa*sb**2-Mb**2/MW**2/cb*cbth*ctth*sa
     &      +Mb/MW**2*Mt*ca/sb*sbth*stth)
      AAABR(6972) = EE**2/SW**2*Sqrt2*cbth*ctth*(ca*sb+sa
     &      /cb-sa/cb*sb**2)
      AAABR(6973) = EE**2/SW**2*Sqrt2*(ca*cbth*sb*stth+cbth
     &      /cb*sa*stth-cbth/cb*sa*sb**2*stth-Mb**2/MW**2
     &      /cb*cbth*sa*stth-Mt**2/MW**2*ca*cbth/sb*stth
     &      -Mb/MW**2*Mt*ca*ctth/sb*sbth-Mb/MW**2*Mt/cb*ctth
     &      *sa*sbth)
      AAABR(6974) = EE**2/SW**2*Sqrt2*(ca*ctth*sb*sbth+ctth
     &      /cb*sa*sbth-ctth/cb*sa*sb**2*sbth-Mb**2/MW**2
     &      /cb*ctth*sa*sbth-Mt**2/MW**2*ca*ctth/sb*sbth
     &      -Mb/MW**2*Mt*ca*cbth/sb*stth-Mb/MW**2*Mt/cb*cbth
     &      *sa*stth)
      AAABR(6975) = EE**2/SW**2*Sqrt2*(ca*cbth*ctth*sb-Mt
     &      **2/MW**2*ca*cbth*ctth/sb+Mb/MW**2*Mt/cb*sa*sbth
     &      *stth)
      AAABR(6976) = EE**2/MW**2/SW**2*Sqrt2*(Mb**2/cb*cbth
     &      *ctth*sa+Mt**2*ca*cbth*ctth/sb-Mb*Mt*ca/sb*sbth
     &      *stth-Mb*Mt/cb*sa*sbth*stth)
      AAABR(6977) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mt**2*ca
     &      *cbth*ctth/sb-2D0*Mt**2*ca*cbth*ctth*sb-Mb*Mt
     &      *ca/sb*sbth*stth+2D0*Mb*Mt*ca*sb*sbth*stth-Mb
     &      *Mt/cb*sa*sbth*stth-2D0*Mb**2/cb*cbth*ctth*sa
     &      *sb**2+2D0*Mb*Mt/cb*sa*sb**2*sbth*stth)
      AAABR(6978) = EE**2/MW**2/SW**2*Sqrt2*(Mb*ca/sb*sbth
     &      *stth+Mb/cb*sa*sbth*stth-2D0*Mt*ca*cbth*ctth/sb)
      AAABR(6979) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mb/cb*cbth
     &      *ctth*sa-Mt*ca/sb*sbth*stth-Mt/cb*sa*sbth*stth)
      AAABR(6980) = EE**2/SW**2*Sqrt2*(ca/cb*csth*scth-ca
     &      /cb*csth*sb**2*scth-Ms**2/MW**2*ca/cb*csth*scth
     &      +Mc/MW**2*Ms*ccth*sa/sb*ssth)
      AAABR(6981) = EE**2/SW**2*Sqrt2*csth*scth*(ca/cb-sa
     &      *sb-ca/cb*sb**2)
      AAABR(6982) = EE**2/SW**2*Sqrt2*(ca/cb*scth*ssth-sa
     &      *sb*scth*ssth-ca/cb*sb**2*scth*ssth+Mc**2/MW
     &      **2*sa/sb*scth*ssth-Ms**2/MW**2*ca/cb*scth*ssth
     &      +Mc/MW**2*Ms*ca/cb*ccth*csth-Mc/MW**2*Ms*ccth
     &      *csth*sa/sb)
      AAABR(6983) = EE**2/SW**2*Sqrt2*(csth*sa*sb*scth-Mc
     &      **2/MW**2*csth*sa/sb*scth+Mc/MW**2*Ms*ca/cb*ccth
     &      *ssth)
      AAABR(6984) = EE**2/MW**2/SW**2*Sqrt2*(Mc**2*csth*sa
     &      /sb*scth-Ms**2*ca/cb*csth*scth-Mc*Ms*ca/cb*ccth
     &      *ssth+Mc*Ms*ccth*sa/sb*ssth)
      AAABR(6985) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc**2*csth
     &      *sa/sb*scth-2D0*Mc**2*csth*sa*sb*scth-Mc*Ms*ca
     &      /cb*ccth*ssth+Mc*Ms*ccth*sa/sb*ssth-2D0*Mc*Ms
     &      *ccth*sa*sb*ssth+2D0*Ms**2*ca/cb*csth*sb**2*scth
     &      +2D0*Mc*Ms*ca/cb*ccth*sb**2*ssth)
      AAABR(6986) = EE**2/MW**2/SW**2*Sqrt2*(2D0*Mc*csth
     &      *sa/sb*scth-Ms*ca/cb*ccth*ssth+Ms*ccth*sa/sb
     &      *ssth)
      AAABR(6987) = EE**2/MW**2/SW**2*Sqrt2*(Mc*ca/cb*ccth
     &      *ssth-Mc*ccth*sa/sb*ssth+2D0*Ms*ca/cb*csth*scth)
      AAABR(6988) = EE**2/SW**2*Sqrt2*(ca/cb*cdth*suth-ca
     &      /cb*cdth*sb**2*suth-Md**2/MW**2*ca/cb*cdth*suth
     &      +Md/MW**2*Mu*cuth*sa/sb